/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.number.PuString;
import jv.object.PsDebug;
import jv.vecmath.P_Vector;
import jv.vecmath.PdVector;
import jv.vecmath.PuData;

public class PdBary
extends P_Vector {
    public static final PdBary TRIANGLE_MID = new PdBary(0.3333333333333333, 0.3333333333333333, 0.3333333333333333);
    public static final PdBary[] TRIANGLE_VERTEX = new PdBary[]{new PdBary(1.0, 0.0, 0.0), new PdBary(0.0, 1.0, 0.0), new PdBary(0.0, 0.0, 1.0)};
    public double[] m_data;
    private static PdVector[] m_c = null;
    private static PdVector[] m_jc = null;

    public double[] getEntries() {
        return (double[])this.m_data.clone();
    }

    public int getSecondVertexOfEdge() {
        int n;
        int n2 = this.isOnEdge();
        if (n2 == -1) {
            return -1;
        }
        if (this.m_data.length < 3) {
            return 1;
        }
        if (this.m_data.length == 3) {
            n = 0;
            while (n < this.m_data.length) {
                if (this.m_data[n] != 0.0 && this.m_data[(n + 1) % this.m_data.length] != 0.0) {
                    return (n + 1) % this.m_data.length;
                }
                ++n;
            }
        }
        n = this.m_data.length - 1;
        while (n >= 0) {
            if (this.m_data[n] != 0.0) {
                return n;
            }
            --n;
        }
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PdBary *********\n");
        int n = this.getSize();
        stringBuffer.append("\t size\t = " + n + "\n");
        if (n > 0) {
            stringBuffer.append("\t m_data = (" + this.m_data[0]);
            int n2 = 1;
            while (n2 < n) {
                stringBuffer.append(", " + this.m_data[n2]);
                ++n2;
            }
            stringBuffer.append(")\n");
        } else {
            stringBuffer.append("\t m_data = null\n");
        }
        return stringBuffer.toString();
    }

    public PdBary() {
        this(0);
    }

    public PdBary(int n) {
        this.m_data = new double[n];
    }

    public PdBary(double d, double d2) {
        this(2);
        this.m_data[0] = d;
        this.m_data[1] = d2;
    }

    public PdBary(double d, double d2, double d3) {
        this(3);
        this.m_data[0] = d;
        this.m_data[1] = d2;
        this.m_data[2] = d3;
    }

    public PdBary(double d, double d2, double d3, double d4) {
        this(4);
        this.m_data[0] = d;
        this.m_data[1] = d2;
        this.m_data[2] = d3;
        this.m_data[3] = d4;
    }

    public String toShortString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.getSize();
        if (this.m_data == null || n2 == 0) {
            stringBuffer.append("{ m_data = null} \t");
        } else {
            stringBuffer.append("{ " + String.valueOf(this.m_data[0]));
            n = 1;
            while (n < n2) {
                stringBuffer.append(", " + String.valueOf(this.m_data[n]));
                ++n;
            }
            stringBuffer.append("} \t");
        }
        stringBuffer.append("Attr = ");
        if (this.m_bits == null) {
            stringBuffer.append("{ } \t");
        } else {
            stringBuffer.append("{ " + PuString.intToString((int)this.m_bits[0], 4));
            n = 1;
            while (n < this.m_bits.length) {
                stringBuffer.append("\t " + PuString.intToString((int)this.m_bits[n], 4));
                ++n;
            }
            stringBuffer.append("} \t");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public double getEntry(int n) {
        if (n < 0 || this.m_data == null || this.m_data.length <= n) {
            PsDebug.warning("index out of range, index=" + n);
            return 0.0;
        }
        return this.m_data[n];
    }

    public void setEntry(int n, double d) {
        if (this.m_data == null || this.m_data.length <= n) {
            this.setSize(n + 1);
        }
        this.m_data[n] = d;
    }

    public int isOutside() {
        if (this.m_data == null) {
            return -1;
        }
        int n = 0;
        while (n < this.m_data.length) {
            if (this.m_data[n] < 0.0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int isOnVertex() {
        if (this.m_data == null) {
            return -1;
        }
        this.validate();
        int n = 0;
        while (n < this.m_data.length) {
            if (this.m_data[n] == 1.0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static void getVertex(PdVector pdVector, PdBary pdBary, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        int n = pdVector2.getSize();
        double[] dArray = pdBary.m_data;
        int n2 = 0;
        while (n2 < n) {
            pdVector.m_data[n2] = dArray[0] * pdVector2.m_data[n2] + dArray[1] * pdVector3.m_data[n2] + dArray[2] * pdVector4.m_data[n2];
            ++n2;
        }
    }

    public int isOnEdge() {
        if (this.m_data == null) {
            return -1;
        }
        if (this.m_data.length <= 3) {
            return this.isOnFace();
        }
        this.validate();
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_data.length) {
            if (this.m_data[n2] == 0.0) {
                return n++;
            }
            ++n2;
        }
        if (n == 2) {
            return 1;
        }
        return -1;
    }

    public int getFirstVertexOfEdge() {
        int n;
        int n2 = this.isOnEdge();
        if (n2 == -1) {
            return -1;
        }
        if (this.m_data.length < 3) {
            return n2;
        }
        if (this.m_data.length == 3) {
            n = 0;
            while (n < this.m_data.length) {
                if (this.m_data[n] != 0.0 && this.m_data[(n + 1) % this.m_data.length] != 0.0) {
                    return n;
                }
                ++n;
            }
        }
        n = 0;
        while (n < this.m_data.length) {
            if (this.m_data[n] != 0.0) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public void validate() {
        if (this.m_data == null) {
            return;
        }
        double d = 0.0;
        int n = 0;
        while (n < this.m_data.length) {
            if (Math.abs(this.m_data[n]) < 1.0E-10) {
                this.m_data[n] = 0.0;
            } else {
                d += this.m_data[n];
            }
            ++n;
        }
        if (Math.abs(d - 1.0) < 1.0E-10) {
            return;
        }
        n = 0;
        while (n < this.m_data.length) {
            if (this.m_data[n] != 0.0) {
                int n2 = n;
                this.m_data[n2] = this.m_data[n2] / d;
            }
            ++n;
        }
    }

    public static PdBary copyNew(PdBary pdBary) {
        if (pdBary == null) {
            PsDebug.warning("missing argument vector");
            return null;
        }
        if (pdBary.m_data == null) {
            PsDebug.warning("missing data of argument vector.");
            return null;
        }
        PdBary pdBary2 = new PdBary(pdBary.getSize());
        pdBary2.copy(pdBary);
        return pdBary2;
    }

    public void copy(PdBary pdBary) {
        if (pdBary == null) {
            PsDebug.warning("missing argument");
            return;
        }
        super.copy(pdBary);
        if (pdBary.m_data == null) {
            this.m_data = null;
            return;
        }
        if (this.m_data == null || this.m_data.length != pdBary.getSize()) {
            this.setSize(pdBary.getSize());
        }
        int n = 0;
        while (n < this.m_data.length) {
            this.m_data[n] = pdBary.m_data[n];
            ++n;
        }
    }

    public int getSize() {
        if (this.m_data == null) {
            return 0;
        }
        return this.m_data.length;
    }

    public int setSize(int n) {
        if (this.m_data == null || this.m_data.length != n) {
            this.m_data = PuData.realloc(this.m_data, n);
        }
        return n;
    }

    public Object clone() {
        return PdBary.copyNew(this);
    }

    public static void getBary(PdBary pdBary, PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        PdVector[] pdVectorArray = new PdVector[]{pdVector2, pdVector3, pdVector4};
        int n = pdVector.getSize();
        if (n != pdVector2.getSize()) {
            PsDebug.warning("point and vertex have different dimension");
            return;
        }
        if (m_c == null || m_c.length != 3 || m_c[0].getSize() != n) {
            m_c = PdVector.realloc(null, 3, n);
        }
        if (m_jc == null || m_jc.length != 3 || m_jc[0].getSize() != n) {
            m_jc = PdVector.realloc(null, 3, n);
        }
        int n2 = 0;
        do {
            m_c[n2].sub(pdVectorArray[(n2 + 2) % 3], pdVectorArray[(n2 + 1) % 3]);
        } while (++n2 < 3);
        int n3 = 2;
        n2 = 0;
        do {
            double d = m_c[n2].sqrLength();
            double d2 = PdVector.dot(m_c[n2], m_c[n3]);
            m_jc[n2].blend(1.0, m_c[n3], -d2 / d, m_c[n2]);
            if (++n3 != 3) continue;
            n3 = 0;
        } while (++n2 < 3);
        double d = 0.0;
        n2 = 0;
        do {
            pdBary.m_data[n2] = PdVector.area(pdVector, pdVectorArray[(n2 + 1) % 3], pdVectorArray[(n2 + 2) % 3]);
            m_c[0].copy(pdVector);
            m_c[0].sub(pdVectorArray[(n2 + 1) % 3]);
            if (PdVector.dot(m_jc[n2], m_c[0]) < 0.0) {
                int n4 = n2;
                pdBary.m_data[n4] = pdBary.m_data[n4] * -1.0;
            }
            d += pdBary.m_data[n2];
        } while (++n2 < 3);
        n2 = 0;
        do {
            int n5 = n2++;
            pdBary.m_data[n5] = pdBary.m_data[n5] / d;
        } while (n2 < 3);
    }

    public static void getBary(PdBary pdBary, PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        pdBary.m_data[0] = PdVector.dot(pdVector3, pdVector2, pdVector);
        pdBary.m_data[1] = PdVector.dot(pdVector2, pdVector3, pdVector);
        double d = pdBary.m_data[0] + pdBary.m_data[1];
        int n = 0;
        do {
            int n2 = n++;
            pdBary.m_data[n2] = pdBary.m_data[n2] / d;
        } while (n < 2);
    }

    public boolean isInside() {
        if (this.m_data == null) {
            return false;
        }
        this.validate();
        int n = 0;
        while (n < this.m_data.length) {
            if (this.m_data[n] < 0.0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int isOnFace() {
        if (this.m_data == null) {
            return -1;
        }
        if (this.m_data.length == 2) {
            return this.isOnVertex();
        }
        this.validate();
        int n = 0;
        while (n < this.m_data.length) {
            if (this.m_data[n] == 0.0) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

