/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;

public class PuLorentz {
    public static void normalize(PdVector pdVector, PdVector pdVector2) {
        PuLorentz.setLength(pdVector, 1.0, pdVector2);
    }

    public static double dot(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        double d = 0.0;
        int n = 0;
        while (n < pdVector.m_data.length) {
            d += pdVector.m_data[n] * pdVector2.m_data[n] * pdVector3.m_data[n];
            ++n;
        }
        return d;
    }

    public static double distMinkowski(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        return Math.sqrt(PuLorentz.sqrDistMinkowski(pdVector, pdVector2, pdVector3));
    }

    public static void getTangentAtOrigin(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        int n = PuLorentz.indexOfTime(pdVector3);
        pdVector.copy(pdVector2);
        pdVector.m_data[n] = 0.0;
        PuLorentz.setLength(pdVector, 1.0, pdVector3);
    }

    public static void rotateAtOrigin(PdMatrix pdMatrix, PdVector pdVector, double d, PdVector pdVector2) {
        double d2 = PuLorentz.distToOrigin(pdVector, pdVector2);
        if (d2 < 1.0E-10) {
            pdMatrix.setIdentity();
            return;
        }
        PdVector pdVector3 = new PdVector(pdVector.getSize());
        PuLorentz.getTangentAtOrigin(pdVector3, pdVector, pdVector2);
        double d3 = Math.cos(d *= Math.PI / 180);
        double d4 = Math.sin(d);
        double d5 = 1.0 - d3;
        double[][] dArray = pdMatrix.m_data;
        double[] dArray2 = pdVector3.m_data;
        dArray[0][0] = 1.0;
        dArray[0][3] = 0.0;
        dArray[0][2] = 0.0;
        dArray[0][1] = 0.0;
        dArray[3][0] = 0.0;
        dArray[2][0] = 0.0;
        dArray[1][0] = 0.0;
        dArray[1][1] = d3 + dArray2[1] * dArray2[1] * d5;
        dArray[1][2] = dArray2[3] * d4 + dArray2[1] * dArray2[2] * d5;
        dArray[1][3] = -dArray2[2] * d4 + dArray2[1] * dArray2[3] * d5;
        dArray[2][1] = -dArray2[3] * d4 + dArray2[1] * dArray2[2] * d5;
        dArray[2][2] = d3 + dArray2[2] * dArray2[2] * d5;
        dArray[2][3] = dArray2[1] * d4 + dArray2[2] * dArray2[3] * d5;
        dArray[3][1] = dArray2[2] * d4 + dArray2[1] * dArray2[3] * d5;
        dArray[3][2] = -dArray2[1] * d4 + dArray2[2] * dArray2[3] * d5;
        dArray[3][3] = d3 + dArray2[3] * dArray2[3] * d5;
    }

    public static void reflectAtOrigin(PdMatrix pdMatrix, PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        if (PuLorentz.distToOrigin(pdVector, pdVector3) < 1.0E-10 || PuLorentz.distToOrigin(pdVector2, pdVector3) < 1.0E-10) {
            pdMatrix.setIdentity();
            return;
        }
        int n = pdVector.getSize();
        PdVector pdVector4 = new PdVector(n);
        PdVector pdVector5 = new PdVector(n);
        PuLorentz.getTangentAtOrigin(pdVector4, pdVector, pdVector3);
        PuLorentz.getTangentAtOrigin(pdVector5, pdVector2, pdVector3);
        PdVector pdVector6 = new PdVector(n - 1);
        PdVector pdVector7 = new PdVector(n - 1);
        int n2 = 0;
        while (n2 < n - 1) {
            pdVector6.m_data[n2] = pdVector4.m_data[n2 + 1];
            pdVector7.m_data[n2] = pdVector5.m_data[n2 + 1];
            ++n2;
        }
        PdVector pdVector8 = PdVector.crossNew(pdVector6, pdVector7);
        pdVector8.normalize();
        PdVector pdVector9 = new PdVector(n);
        double[] dArray = pdVector9.m_data;
        dArray[0] = 0.0;
        n2 = 0;
        while (n2 < n - 1) {
            dArray[n2 + 1] = pdVector8.m_data[n2];
            ++n2;
        }
        double[][] dArray2 = pdMatrix.m_data;
        dArray2[0][0] = 1.0 + 2.0 * dArray[0] * dArray[0];
        dArray2[0][1] = -2.0 * dArray[1] * dArray[0];
        dArray2[0][2] = -2.0 * dArray[2] * dArray[0];
        dArray2[0][3] = -2.0 * dArray[3] * dArray[0];
        dArray2[1][0] = -dArray2[0][1];
        dArray2[1][1] = 1.0 - 2.0 * dArray[1] * dArray[1];
        dArray2[1][2] = -2.0 * dArray[2] * dArray[1];
        dArray2[1][3] = -2.0 * dArray[3] * dArray[1];
        dArray2[2][0] = -dArray2[0][2];
        dArray2[2][1] = dArray2[1][2];
        dArray2[2][2] = 1.0 - 2.0 * dArray[2] * dArray[2];
        dArray2[2][3] = -2.0 * dArray[3] * dArray[2];
        dArray2[3][0] = -dArray2[0][3];
        dArray2[3][1] = dArray2[1][3];
        dArray2[3][2] = dArray2[2][3];
        dArray2[3][3] = 1.0 - 2.0 * dArray[3] * dArray[3];
    }

    public static void reflectAtPlane(PdMatrix pdMatrix, PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        if (PuLorentz.dist(pdVector, pdVector2, pdVector4) < 1.0E-10 || PuLorentz.dist(pdVector, pdVector3, pdVector4) < 1.0E-10 || PuLorentz.dist(pdVector2, pdVector3, pdVector4) < 1.0E-10) {
            pdMatrix.setIdentity();
            return;
        }
        int n = pdVector.getSize();
        PdMatrix pdMatrix2 = new PdMatrix(n);
        PdMatrix pdMatrix3 = new PdMatrix(n);
        PdMatrix pdMatrix4 = new PdMatrix(n);
        PuLorentz.translate2Origin(pdMatrix2, pdVector, pdVector4);
        PuLorentz.translate2Point(pdMatrix3, pdVector, pdVector4);
        pdVector2.leftMultMatrix(pdMatrix2);
        pdVector3.leftMultMatrix(pdMatrix2);
        PuLorentz.reflectAtOrigin(pdMatrix, pdVector2, pdVector3, pdVector4);
        pdMatrix4.mult(pdMatrix, pdMatrix2);
        pdMatrix.mult(pdMatrix3, pdMatrix4);
    }

    public static double distToOrigin(PdVector pdVector, PdVector pdVector2) {
        int n = PuLorentz.indexOfTime(pdVector2);
        double d = Math.abs(pdVector.m_data[n]);
        d = d <= 1.0 ? Math.acos(d) : PuMath.acosh(d);
        return d;
    }

    public static void getTangent(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        double d = PuLorentz.dot(pdVector2, pdVector3, pdVector4);
        pdVector.blendBase(pdVector3, d, pdVector2);
        PuLorentz.setLength(pdVector, 1.0, pdVector4);
    }

    public static void translate2Origin(PdMatrix pdMatrix, PdVector pdVector, PdVector pdVector2) {
        double d = PuLorentz.distToOrigin(pdVector, pdVector2);
        if (d < 1.0E-10) {
            pdMatrix.setIdentity();
            return;
        }
        PdVector pdVector3 = new PdVector(pdVector.getSize());
        PuLorentz.getTangentAtOrigin(pdVector3, pdVector, pdVector2);
        double d2 = PuMath.cosh(-d);
        double d3 = PuMath.sinh(-d);
        double d4 = d2 - 1.0;
        double[][] dArray = pdMatrix.m_data;
        double[] dArray2 = pdVector3.m_data;
        dArray[0][0] = d2;
        dArray[0][1] = dArray2[1] * d3;
        dArray[0][2] = dArray2[2] * d3;
        dArray[0][3] = dArray2[3] * d3;
        dArray[1][0] = dArray[0][1];
        dArray[1][1] = dArray2[1] * dArray2[1] * d4 + 1.0;
        dArray[1][2] = dArray2[1] * dArray2[2] * d4;
        dArray[1][3] = dArray2[1] * dArray2[3] * d4;
        dArray[2][0] = dArray[0][2];
        dArray[2][1] = dArray[1][2];
        dArray[2][2] = dArray2[2] * dArray2[2] * d4 + 1.0;
        dArray[2][3] = dArray2[2] * dArray2[3] * d4;
        dArray[3][0] = dArray[0][3];
        dArray[3][1] = dArray[1][3];
        dArray[3][2] = dArray[2][3];
        dArray[3][3] = dArray2[3] * dArray2[3] * d4 + 1.0;
    }

    public static void translate(PdMatrix pdMatrix, PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        double d = PuLorentz.dist(pdVector, pdVector2, pdVector3);
        if (d < 1.0E-10) {
            pdMatrix.setIdentity();
            return;
        }
        int n = pdVector.getSize();
        PdMatrix pdMatrix2 = new PdMatrix(n);
        PdMatrix pdMatrix3 = new PdMatrix(n);
        PdMatrix pdMatrix4 = new PdMatrix(n);
        PuLorentz.translate2Origin(pdMatrix2, pdVector, pdVector3);
        PuLorentz.translate2Point(pdMatrix3, pdVector, pdVector3);
        pdVector2.leftMultMatrix(pdMatrix2);
        PuLorentz.translate2Point(pdMatrix, pdVector2, pdVector3);
        pdMatrix4.mult(pdMatrix, pdMatrix2);
        pdMatrix.mult(pdMatrix3, pdMatrix4);
    }

    public static void rotateAroundLine(PdMatrix pdMatrix, PdVector pdVector, PdVector pdVector2, double d, PdVector pdVector3) {
        double d2 = PuLorentz.dist(pdVector, pdVector2, pdVector3);
        if (d2 < 1.0E-10) {
            pdMatrix.setIdentity();
            return;
        }
        int n = pdVector.getSize();
        PdMatrix pdMatrix2 = new PdMatrix(n);
        PdMatrix pdMatrix3 = new PdMatrix(n);
        PdMatrix pdMatrix4 = new PdMatrix(n);
        PuLorentz.translate2Origin(pdMatrix2, pdVector, pdVector3);
        PuLorentz.translate2Point(pdMatrix3, pdVector, pdVector3);
        pdVector2.leftMultMatrix(pdMatrix2);
        PuLorentz.rotateAtOrigin(pdMatrix, pdVector2, d, pdVector3);
        pdMatrix4.mult(pdMatrix, pdMatrix2);
        pdMatrix.mult(pdMatrix3, pdMatrix4);
    }

    public static void invertAtPoint(PdMatrix pdMatrix, PdVector pdVector, PdVector pdVector2) {
        pdMatrix.setIdentity();
        pdMatrix.multScalar(-1.0);
        double d = PuLorentz.distToOrigin(pdVector, pdVector2);
        if (d < 1.0E-10) {
            return;
        }
        int n = pdVector.getSize();
        PdMatrix pdMatrix2 = new PdMatrix(n);
        PdMatrix pdMatrix3 = new PdMatrix(n);
        PdMatrix pdMatrix4 = new PdMatrix(n);
        PuLorentz.translate2Origin(pdMatrix2, pdVector, pdVector2);
        PuLorentz.translate2Point(pdMatrix3, pdVector, pdVector2);
        pdMatrix4.mult(pdMatrix, pdMatrix2);
        pdMatrix.mult(pdMatrix3, pdMatrix4);
    }

    public static double dist(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        double d = Math.abs(PuLorentz.dot(pdVector, pdVector2, pdVector3));
        d = d <= 1.0 ? Math.acos(d) : PuMath.acosh(d);
        return d;
    }

    public static double sqrDistMinkowski(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        double d = 0.0;
        int n = 0;
        while (n < pdVector.m_data.length) {
            d += pdVector3.m_data[n] * (pdVector.m_data[n] - pdVector2.m_data[n]);
            ++n;
        }
        return d;
    }

    public static void translate2Point(PdMatrix pdMatrix, PdVector pdVector, PdVector pdVector2) {
        double d = PuLorentz.distToOrigin(pdVector, pdVector2);
        if (d < 1.0E-10) {
            pdMatrix.setIdentity();
            return;
        }
        PdVector pdVector3 = new PdVector(pdVector.getSize());
        PuLorentz.getTangentAtOrigin(pdVector3, pdVector, pdVector2);
        double d2 = PuMath.cosh(d);
        double d3 = PuMath.sinh(d);
        double d4 = d2 - 1.0;
        double[][] dArray = pdMatrix.m_data;
        double[] dArray2 = pdVector3.m_data;
        dArray[0][0] = d2;
        dArray[0][1] = dArray2[1] * d3;
        dArray[0][2] = dArray2[2] * d3;
        dArray[0][3] = dArray2[3] * d3;
        dArray[1][0] = dArray[0][1];
        dArray[1][1] = dArray2[1] * dArray2[1] * d4 + 1.0;
        dArray[1][2] = dArray2[1] * dArray2[2] * d4;
        dArray[1][3] = dArray2[1] * dArray2[3] * d4;
        dArray[2][0] = dArray[0][2];
        dArray[2][1] = dArray[1][2];
        dArray[2][2] = dArray2[2] * dArray2[2] * d4 + 1.0;
        dArray[2][3] = dArray2[2] * dArray2[3] * d4;
        dArray[3][0] = dArray[0][3];
        dArray[3][1] = dArray[1][3];
        dArray[3][2] = dArray[2][3];
        dArray[3][3] = dArray2[3] * dArray2[3] * d4 + 1.0;
    }

    public static double abs(PdVector pdVector, PdVector pdVector2) {
        return Math.sqrt(PuLorentz.sqrAbs(pdVector, pdVector2));
    }

    public static double sqrAbs(PdVector pdVector, PdVector pdVector2) {
        double d = 0.0;
        int n = 0;
        while (n < pdVector.m_data.length) {
            d += pdVector2.m_data[n] * pdVector.m_data[n] * pdVector.m_data[n];
            ++n;
        }
        return d;
    }

    public static void setLength(PdVector pdVector, double d, PdVector pdVector2) {
        double d2 = PuLorentz.abs(pdVector, pdVector2);
        if (d2 < 1.0E-10) {
            PsDebug.warning("vector has length zero.");
            return;
        }
        int n = 0;
        while (n < pdVector.m_data.length) {
            int n2 = n++;
            pdVector.m_data[n2] = pdVector.m_data[n2] * (d / d2);
        }
    }

    private static int indexOfTime(PdVector pdVector) {
        int n = -1;
        int n2 = 0;
        while (n2 < pdVector.m_data.length) {
            if (pdVector.m_data[n2] < 0.0) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            PsDebug.warning("missing time axis in signature.\n\tSignature = \n" + pdVector.toString());
            return 0;
        }
        return n;
    }
}

