/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.PixelGrabber;
import jv.number.PdColor;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.objectGui.PsScanline;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvCameraIf;
import jv.project.PvDisplayIf;
import jv.project.PvGeometryIf;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuProj;
import jv.viewer.PvCamera;
import jv.viewer.PvDisplay;
import jv.viewer.PvLight;
import jv.viewer.PvScene;

final class PvGeometry
extends PgJvxSrc
implements PvGeometryIf {
    protected PvDisplayIf m_display;
    protected PgGeometryIf m_geometry;
    private int m_maxSizeOfElements;
    protected static int PS_ZOOM = 1;
    private int m_offFac = 1;
    protected boolean m_bSpecial = false;
    protected Color m_backColor;
    protected boolean m_bShowEdgeAura;
    protected int m_drawingOrder = 0;
    protected PdVector[] m_bndBox;
    protected PiVector[] m_bndBoxTrans;
    protected Color m_globalBndboxColor;
    protected PiVector m_centerTrans;
    private int m_dimTrans;
    protected int m_dimOfColors;
    protected int m_pickedVertex;
    protected int m_pickedPolygon;
    protected int m_pickedElement;
    protected int[] m_texturePix;
    protected int m_textureWidth;
    protected int m_textureHeight;
    protected int m_textureDepth = 256;
    protected boolean m_bEnableZBuffer;
    protected PdVector[] m_faceTextureBnd;
    protected PiVector[] m_faceDestBnd;
    protected float[][] m_colDestBnd;
    protected float[][] m_lightDestBnd;
    protected PiVector m_bndIdentifier;
    private int m_imgWidth;
    private int m_imgHeight;
    protected int m_alpha;
    protected static int m_alphaOpaque = -16777216;
    protected int m_transparency;
    protected int m_transparencyOrig;
    protected boolean m_bShowTransparency;
    protected boolean m_bShowTransparencyOrig;
    protected boolean m_bShowVectors;
    private boolean m_bHasTaggedVertices;
    protected int m_numPolygonEdges;
    protected boolean m_bHasTaggedPolygons;
    protected boolean m_bHasTaggedEdges;
    protected boolean m_bHasTaggedBoundaries;
    protected boolean m_bHasTaggedElements;
    private boolean m_bHasNeighbours;
    protected PiVector[] m_vertexTrans;
    protected PiVector[] m_vertexNormalTrans;
    protected PiVector[] m_elementNormalTrans;
    protected PiVector[][] m_vectorTrans;
    protected boolean m_useVertices;
    protected boolean m_useUnusedVertices;
    protected boolean m_useElements;
    protected boolean m_usePolygons;
    private Color[] m_vertexColorFromElement;
    private int[] m_xv;
    private int[] m_yv;
    private int[] m_zv;
    protected PdVector[] m_clipBounds;
    private PdVector[] m_vd;
    private PdVector[] m_vdClip;
    private int[][] m_cv;
    private int[][] m_cvClip;
    private float[][] m_lv;
    private float[][] m_lvClip;
    private int[] m_origInd;
    private int[] m_origIndClip;
    private PdVector[] m_tex;
    private PdVector[] m_texClip;
    private double[] m_tPos;
    private float[] cd;
    private float[] cd_inc;
    private float[] lad;
    private float[] lad_inc;
    private boolean m_bShowSmoothShading;
    protected boolean m_bShowLighting = false;
    private boolean m_bShowSmoothLighting;
    private boolean m_bShowSmoothElementColors;
    private boolean m_bInduceElementFromVertexColors;
    private int m_grey = 200;
    private boolean m_bElemIsClipped;
    private int[] m_pixData;
    protected boolean m_bShowDepthcue;
    protected boolean m_bShowEdgeOnce;
    protected boolean m_bIsClippable;
    protected boolean m_bEnableClip;
    protected boolean m_bEnableClipBounds;
    protected boolean m_bEnableClipCamera;
    protected double m_clipFar;
    protected double m_clipNear;
    protected PvScene m_scene;
    protected Dimension m_dispSize;
    private float m_heightFac;
    private float m_itemHeight;
    private PdVector m_vt;
    private PdVector m_vtSrc;
    private PdVector m_vtMod;
    private PdVector m_vtTipMod;
    private PdVector m_vnMod;
    private PdVector m_vlMod;
    private PdVector vtMod1;
    private PdVector vtSrc1;
    private PdVector vtSrc;
    private PdVector m_elemCenter;
    private PiVector m_elemCenterTrans;
    protected int[][] m_tpBuffer;
    protected int[][] m_colBuffer;
    protected int[][] m_zBuffer;
    protected boolean m_bEnable3DLook = false;
    protected boolean m_bAdaptiveSize = false;
    private boolean[] m_bCreaseEdge;
    private boolean m_bHasCreaseEdge = false;
    private PiVector m_unusedVertex = new PiVector();
    private int m_numUnusedVertices = 0;
    private PiVector m_edgePolygon = new PiVector();
    private PiVector m_edgeOffset = new PiVector();
    protected boolean m_bPerspectivity = false;
    protected PdVector m_cameraPos = new PdVector(3);
    protected PdVector m_cameraDir = new PdVector(3);
    private PdMatrix m_viewMat;
    private boolean m_bModAmb;
    private static final double ROUND = 0.3;
    private int[] m_position = null;
    protected int m_zMin = Integer.MAX_VALUE;
    protected int m_zMax = Integer.MIN_VALUE;
    private float[] c1d = new float[3];
    private float[] c2d = new float[3];
    private int m_outCol = Color.black.getRGB();
    private static final int m_colorWhite = Color.white.getRGB();
    private transient Image m_imageString;
    private transient Graphics m_gImageString;
    private int m_defWidthString;
    private int m_defHeightString;
    private int m_widthString;
    private int m_heightString;
    private transient PixelGrabber m_pgString;
    private transient int[] m_pixString;
    private int[] xvSub;
    private int[] yvSub;
    private int[] zvSub;
    private int[][] cvSub;
    private float[][] lvSub;
    private PdVector[] texSub;
    private int[][] m_elemSub;
    private int[] m_indVec;
    private PdVector[] m_currVertexArr;
    private double[] m_angleArr;
    private boolean m_bShowCurrElement = false;
    private boolean m_bShowCurrEdge = false;
    private boolean m_bDrawingEdge = false;
    private boolean m_bDepthcueEdge = false;
    private boolean m_bUse_m_heightFac = false;
    private PdVector[] m_texCoord;
    protected boolean m_bShowTexture = false;
    protected boolean m_bAutoClip = true;
    protected int m_autoClip = 0;
    private double[] bary;
    private double[] baryDelta;
    private boolean m_bIsTaggedElement = false;
    private boolean m_bIsBackface = true;
    private boolean m_bHasHighlight = false;
    protected PvLight[] m_light;
    protected PvCameraIf m_camera = null;
    protected float[] m_specular = new float[3];
    private int[] m_color = new int[3];
    private int[] m_matCol = new int[3];
    protected float[] m_lightAttMat = new float[3];
    protected float[] m_lightAttSpec = new float[3];
    private PdVector m_vertexEye = new PdVector(3);
    private PdVector m_halfVector = new PdVector(3);
    private int m_currElementCol = -16777216;
    private int m_currEdgeCol = -16777216;
    private static int m_colMark = -33554432;
    private static int NNW = 1;
    private static int NWW = 2;
    private static int SWW = 3;
    private static int SSW = 4;
    private static int SSE = 5;
    private static int SEE = 6;
    private static int NEE = 7;
    private static int NNE = 8;
    private int[][] cvTmp;
    private int[] cvTmpOne;
    private int m_zTol = 5 * PvCamera.Z_STRETCH_FAC;
    private int m_zTolLine = -30 * PvCamera.Z_STRETCH_FAC;
    private int m_zTolVertex = -60 * PvCamera.Z_STRETCH_FAC;
    private int[] m_rgb;
    private int[] poss;
    private int[] xCorner = new int[4];
    private int[] yCorner = new int[4];
    private int[] zCorner = new int[4];
    private int[] m_colArr = new int[4];
    PdVector m_currVertex = null;
    PdVector m_currNormal = null;
    PdVector m_sphNormal = new PdVector(3);
    PdVector m_camPos3D = null;
    PdVector m_camView3D = null;
    PdVector m_camUp3D = null;
    PdVector m_camHor3D = new PdVector(3);
    int cx = 0;
    int cy = 0;
    int cSize = 1;
    protected int m_z3DLookFac = 0;
    private short[][] m_heightArr = null;
    private int m_cacheRadius = 256;
    Image m_bufferedImage;
    protected boolean m_bFastZBuffer = false;
    protected boolean m_bFastClipping = false;
    protected boolean m_bFastScanline = false;
    protected boolean m_bElementDrawn = false;
    protected boolean m_bLightsSymmetric = true;
    static boolean bDebug = false;

    public void setState(int n, boolean bl) {
        switch (n) {
            case 85: {
                this.m_bEnabledIndexLabels = bl;
                return;
            }
            case 87: {
                this.m_bShowTitle = bl;
                if (!this.m_bShowTitle) break;
                this.m_bndBoxTrans = PiVector.realloc(this.m_bndBoxTrans, 2, this.m_dimTrans);
                return;
            }
            case 86: {
                this.m_bShowName = bl;
                if (!this.m_bShowName) break;
                this.m_bndBoxTrans = PiVector.realloc(this.m_bndBoxTrans, 2, this.m_dimTrans);
                return;
            }
            case 80: {
                this.m_bShowIndices = bl;
                return;
            }
            case 81: {
                this.m_bShowVertexLabels = bl;
                return;
            }
            case 82: {
                this.m_bShowPolygonLabels = bl;
                return;
            }
            case 83: {
                this.m_bShowEdgeLabels = bl;
                return;
            }
            case 84: {
                this.m_bShowElementLabels = bl;
                return;
            }
            case 50: {
                this.m_bShowVertices = bl;
                return;
            }
            case 51: {
                this.m_bShowTaggedVertices = bl;
                return;
            }
            case 52: {
                this.m_bShowEdges = bl;
                return;
            }
            case 53: {
                this.m_bShowTaggedEdges = bl;
                return;
            }
            case 88: {
                this.m_bShowSilhouette = bl;
                return;
            }
            case 54: {
                this.m_bShowPolygons = bl;
                return;
            }
            case 55: {
                this.m_bShowTaggedPolygons = bl;
                return;
            }
            case 56: {
                this.m_bShowElements = bl;
                return;
            }
            case 57: {
                this.m_bShowTaggedElements = bl;
                return;
            }
            case 68: {
                this.m_bShowBackface = bl;
                return;
            }
            case 58: {
                this.m_bShowBoundaries = bl;
                return;
            }
            case 59: {
                this.m_bShowTaggedBoundaries = bl;
                return;
            }
            case 97: {
                this.m_bShowVertexOutline = bl;
                return;
            }
            case 74: {
                this.m_bShowVertexSizes = bl;
                return;
            }
            case 60: {
                this.m_bShowVertexNormals = bl;
                return;
            }
            case 62: {
                this.m_bShowElementNormals = bl;
                return;
            }
            case 64: {
                this.m_bShowPolygonNormals = bl;
                return;
            }
            case 105: {
                this.m_bShowPolygonSizes = bl;
                return;
            }
            case 61: {
                this.m_bShowVertexNormalArrow = bl;
                return;
            }
            case 63: {
                this.m_bShowElementNormalArrow = bl;
                return;
            }
            case 65: {
                this.m_bShowPolygonNormalArrow = bl;
                return;
            }
            case 89: {
                this.m_bShowPolygonStartArrow = bl;
                return;
            }
            case 90: {
                this.m_bShowPolygonEndArrow = bl;
                return;
            }
            case 69: {
                this.m_bShowBndBox = bl;
                return;
            }
            case 70: {
                this.m_bShowCenter = bl;
                return;
            }
            case 71: {
                this.m_bShowVertexTexture = bl;
                return;
            }
            case 72: {
                this.m_bShowElementTexture = bl;
                return;
            }
            case 73: {
                this.m_bShowTransparency = bl;
                this.m_bShowTransparencyOrig = bl;
                return;
            }
            case 91: {
                this.m_bShowVertexColors = bl;
                return;
            }
            case 93: {
                this.m_bShowPolygonColors = bl;
                return;
            }
            case 94: {
                this.m_bShowEdgeColors = bl;
                return;
            }
            case 95: {
                this.m_bShowEdgeColorFromElements = bl;
                return;
            }
            case 96: {
                this.m_bShowElementColors = bl;
                return;
            }
            case 99: {
                this.m_bShowElementBackColor = bl;
                return;
            }
            case 100: {
                this.m_bShowElementBackColors = bl;
                return;
            }
            case 101: {
                this.m_bShowSmoothLighting = bl;
                if (!this.m_bShowSmoothLighting) break;
                this.lad = new float[6];
                this.lad_inc = new float[6];
                return;
            }
            case 102: {
                this.m_bShowSmoothElementColors = bl;
                return;
            }
            case 103: {
                this.m_bInduceElementFromVertexColors = bl;
                return;
            }
            case 104: {
                this.m_bHasNeighbours = bl;
                return;
            }
            case 98: {
                this.m_bShowSmoothShading = bl;
                if (!this.m_bShowSmoothShading) break;
                this.cd = new float[3];
                this.cd_inc = new float[3];
                this.cvTmpOne = new int[3];
                return;
            }
            default: {
                super.setState(n, bl);
            }
        }
    }

    public boolean getState(int n) {
        switch (n) {
            case 50: {
                return this.m_bShowVertices;
            }
            case 69: {
                return this.m_bShowBndBox;
            }
            case 73: {
                return this.m_bShowTransparency;
            }
            case 98: {
                return this.m_bShowSmoothShading;
            }
            case 101: {
                return this.m_bShowSmoothLighting;
            }
        }
        return super.getState(n);
    }

    private int[][] triangulate(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2 = n;
        int n3 = 0;
        while (n3 < n2) {
            this.m_indVec[n3] = (n3 + 1) % n2;
            ++n3;
        }
        int n4 = -1;
        int n5 = n2 - 1;
        int n6 = 0;
        int n7 = 0;
        if (this.m_currVertexArr == null || this.m_currVertexArr.length < n2) {
            this.m_currVertexArr = PdVector.realloc(this.m_currVertexArr, 2 * n2, 3);
        }
        while (n7 < n2 - 3) {
            int n8 = n2 - n7;
            int n9 = n6;
            n3 = 0;
            while (n3 < n8) {
                this.m_currVertexArr[n3].set(nArray[n9], (double)nArray2[n9], 0.0);
                n9 = this.m_indVec[n9];
                ++n3;
            }
            PdVector.angleWithOrientation(this.m_angleArr, this.m_currVertexArr, n8);
            double d = 0.0;
            int n10 = -1;
            n9 = n6;
            n3 = 0;
            while (n3 < n8) {
                if ((this.m_angleArr[(n3 - 1 + n8) % n8] < 0.01 || this.m_angleArr[(n3 + 1) % n8] < 0.01) && this.m_angleArr[n3] > d) {
                    d = this.m_angleArr[n3];
                    n10 = n9;
                    n4 = n5;
                }
                n5 = n9;
                n9 = this.m_indVec[n9];
                ++n3;
            }
            if (n10 == -1) {
                n3 = 0;
                while (n3 < n8) {
                    if (this.m_angleArr[n3] > d) {
                        d = this.m_angleArr[n3];
                        n10 = n9;
                        n4 = n5;
                    }
                    n5 = n9;
                    n9 = this.m_indVec[n9];
                    ++n3;
                }
            }
            if (n10 == -1) {
                PsDebug.error("missing max angle");
                return null;
            }
            this.m_elemSub[n7][0] = n4;
            this.m_elemSub[n7][1] = n10;
            this.m_elemSub[n7][2] = this.m_indVec[n10];
            this.m_indVec[n4] = this.m_indVec[n10];
            n5 = n4;
            n6 = this.m_indVec[n10];
            ++n7;
        }
        this.m_elemSub[n7][0] = n6;
        this.m_elemSub[n7][1] = this.m_indVec[n6];
        this.m_elemSub[n7][2] = this.m_indVec[this.m_indVec[n6]];
        return this.m_elemSub;
    }

    private void drawLineZThick3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (n < PS_ZOOM) {
            return;
        }
        float f = n5 - n2;
        float f2 = n6 - n3;
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        if ((double)f3 < 1.0E-10) {
            f3 = 1.0f;
        }
        float f4 = (float)n * f2 / f3;
        float f5 = (float)n * -f / f3;
        float f6 = (float)(this.m_z3DLookFac * n) / 2.0f;
        if (Math.abs(f4) >= Math.abs(f5)) {
            if (f4 < 0.0f) {
                f4 = -f4;
                f5 = -f5;
            }
        } else if (f5 < 0.0f) {
            f4 = -f4;
            f5 = -f5;
        }
        int n10 = (int)((float)n2 - f4 / 2.0f + 0.5f);
        int n11 = (int)((float)n3 - f5 / 2.0f + 0.5f);
        int n12 = n4;
        int n13 = (int)((float)n5 - f4 / 2.0f + 0.5f);
        int n14 = (int)((float)n6 - f5 / 2.0f + 0.5f);
        int n15 = n7;
        if (Math.abs(f4) >= Math.abs(f5)) {
            int n16 = (int)(f4 + 1.0f + 0.5f);
            float f7 = n11;
            float f8 = n14;
            float f9 = f5 / (float)(n16 - 1);
            int n17 = 0;
            while (n17 < n16) {
                float f10 = (float)((n17 << 1) - (n16 - 1)) / (float)n16;
                float f11 = 1.0f - f10 * f10;
                float f12 = (float)Math.sqrt(f11);
                int n18 = n8;
                int n19 = n9;
                if (this.m_bShowSmoothShading) {
                    n18 = m_alphaOpaque | this.m_cv[0][0] << 16 | this.m_cv[0][1] << 8 | this.m_cv[0][2];
                    n19 = m_alphaOpaque | this.m_cv[1][0] << 16 | this.m_cv[1][1] << 8 | this.m_cv[1][2];
                }
                if (n > 1) {
                    n18 = PdColor.getDimmedColor(n18, (int)(255.0f * f12));
                    n19 = this.m_bShowSmoothShading ? PdColor.getDimmedColor(n19, (int)(255.0f * f12)) : n18;
                }
                if (n17 == 0) {
                    this.drawLineZBresen(n10, n11, n12, n13, n14, n15, n18, n19);
                    if (n16 == 2 && (f9 >= 1.0f || f9 <= -1.0f)) {
                        this.drawLineZBresen(n10 + 1, n11, n12, n13 + 1, n14, n15, n18, n19);
                    }
                } else if (n17 == n16 - 1) {
                    this.drawLineZBresen(n10, n11, n12, n13, n14, n15, n18, n19);
                } else {
                    this.drawLineZBresen(n10, n11, n12, n13, n14, n15, n18, n19, 0);
                }
                ++n10;
                ++n13;
                n11 = Math.round(f7 += f9);
                n14 = Math.round(f8 += f9);
                float f13 = f12 * f6;
                n12 = Math.round((float)n4 + f13);
                n15 = Math.round((float)n7 + f13);
                ++n17;
            }
            return;
        }
        int n20 = (int)(f5 + 1.0f + 0.5f);
        float f14 = n10;
        float f15 = n13;
        float f16 = f4 / (float)(n20 - 1);
        int n21 = 0;
        while (n21 < n20) {
            float f17 = (float)((n21 << 1) - (n20 - 1)) / (float)n20;
            float f18 = 1.0f - f17 * f17;
            float f19 = (float)Math.sqrt(f18);
            int n22 = n8;
            int n23 = n9;
            if (this.m_bShowSmoothShading) {
                n22 = m_alphaOpaque | this.m_cv[0][0] << 16 | this.m_cv[0][1] << 8 | this.m_cv[0][2];
                n23 = m_alphaOpaque | this.m_cv[1][0] << 16 | this.m_cv[1][1] << 8 | this.m_cv[1][2];
            }
            if (n > 2) {
                n22 = PdColor.getDimmedColor(n22, (int)(255.0f * f19));
                n23 = this.m_bShowSmoothShading ? PdColor.getDimmedColor(n23, (int)(255.0f * f19)) : n22;
            }
            if (n21 == 0) {
                this.drawLineZBresen(n10, n11, n12, n13, n14, n15, n22, n23);
                if (n20 == 2 && (f16 >= 1.0f || f16 <= -1.0f)) {
                    this.drawLineZBresen(n10, n11 + 1, n12, n13, n14 + 1, n15, n22, n23);
                }
            } else if (n21 == n20 - 1) {
                this.drawLineZBresen(n10, n11, n12, n13, n14, n15, n22, n23);
            } else {
                this.drawLineZBresen(n10, n11, n12, n13, n14, n15, n22, n23, 1);
            }
            n10 = Math.round(f14 += f16);
            n13 = Math.round(f15 += f16);
            ++n11;
            ++n14;
            float f20 = f19 * f6;
            n12 = Math.round((float)n4 + f20);
            n15 = Math.round((float)n7 + f20);
            ++n21;
        }
    }

    private void drawLineZBresen(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n7;
        int n10 = this.m_zTol;
        this.m_zTol = this.m_zTolLine;
        int n11 = n4 - n;
        int n12 = n5 - n2;
        float f = n6 - n3;
        int n13 = n;
        int n14 = n2;
        float f2 = n3;
        int n15 = 1;
        int n16 = 1;
        if (n11 < 0) {
            n11 = -n11;
            n15 = -1;
        }
        if (n12 < 0) {
            n12 = -n12;
            n16 = -1;
        }
        if (this.m_bShowSmoothShading) {
            this.c1d[0] = n7 >> 16 & 0xFF;
            this.c1d[1] = n7 >> 8 & 0xFF;
            this.c1d[2] = n7 & 0xFF;
            this.c2d[0] = n8 >> 16 & 0xFF;
            this.c2d[1] = n8 >> 8 & 0xFF;
            this.c2d[2] = n8 & 0xFF;
            float f3 = n11 >= n12 ? (float)n11 : (float)n12;
            int n17 = 0;
            do {
                this.cd_inc[n17] = (this.c2d[n17] - this.c1d[n17]) / f3;
            } while (++n17 < 3);
        }
        if (n11 >= n12) {
            int n18 = n12 << 1;
            int n19 = n12 - n11 << 1;
            f /= (float)n11;
            int n20 = n18 - n11;
            while (n13 != n4) {
                if (this.m_bShowSmoothShading) {
                    n9 = m_alphaOpaque | (int)this.c1d[0] << 16 | (int)this.c1d[1] << 8 | (int)this.c1d[2];
                    int n21 = 0;
                    do {
                        int n22 = n21;
                        this.c1d[n22] = this.c1d[n22] + this.cd_inc[n21];
                    } while (++n21 < 3);
                }
                this.writePixel(n13, n14, n9, f2);
                n13 += n15;
                f2 += f;
                if (n20 <= 0) {
                    n20 += n18;
                    continue;
                }
                n20 += n19;
                n14 += n16;
            }
        } else {
            int n23 = n11 << 1;
            int n24 = n11 - n12 << 1;
            f /= (float)n12;
            int n25 = n23 - n12;
            while (n14 != n5) {
                if (this.m_bShowSmoothShading) {
                    n9 = m_alphaOpaque | (int)this.c1d[0] << 16 | (int)this.c1d[1] << 8 | (int)this.c1d[2];
                    int n26 = 0;
                    do {
                        int n27 = n26;
                        this.c1d[n27] = this.c1d[n27] + this.cd_inc[n26];
                    } while (++n26 < 3);
                }
                this.writePixel(n13, n14, n9, f2);
                n14 += n16;
                f2 += f;
                if (n25 <= 0) {
                    n25 += n23;
                    continue;
                }
                n25 += n24;
                n13 += n15;
            }
        }
        this.m_zTol = n10;
    }

    private void drawLineZBresen(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = n7;
        int n11 = this.m_zTol;
        this.m_zTol = this.m_zTolLine;
        int n12 = n4 - n;
        int n13 = n5 - n2;
        float f = n6 - n3;
        int n14 = n;
        int n15 = n2;
        float f2 = n3;
        int n16 = 1;
        int n17 = 1;
        if (n12 < 0) {
            n12 = -n12;
            n16 = -1;
        }
        if (n13 < 0) {
            n13 = -n13;
            n17 = -1;
        }
        if (this.m_bShowSmoothShading) {
            this.c1d[0] = n7 >> 16 & 0xFF;
            this.c1d[1] = n7 >> 8 & 0xFF;
            this.c1d[2] = n7 & 0xFF;
            this.c2d[0] = n8 >> 16 & 0xFF;
            this.c2d[1] = n8 >> 8 & 0xFF;
            this.c2d[2] = n8 & 0xFF;
            float f3 = n12 >= n13 ? (float)n12 : (float)n13;
            int n18 = 0;
            do {
                this.cd_inc[n18] = (this.c2d[n18] - this.c1d[n18]) / f3;
            } while (++n18 < 3);
        }
        if (n12 >= n13) {
            int n19 = n13 << 1;
            int n20 = n13 - n12 << 1;
            f /= (float)n12;
            int n21 = n19 - n12;
            while (n14 != n4) {
                if (this.m_bShowSmoothShading) {
                    n10 = m_alphaOpaque | (int)this.c1d[0] << 16 | (int)this.c1d[1] << 8 | (int)this.c1d[2];
                    int n22 = 0;
                    do {
                        int n23 = n22;
                        this.c1d[n23] = this.c1d[n23] + this.cd_inc[n22];
                    } while (++n22 < 3);
                }
                this.writePixel(n14, n15, n10, f2);
                this.writePixel(n14, n15 + 1, n10, f2);
                this.writePixel(n14, n15 - 1, n10, f2);
                n14 += n16;
                f2 += f;
                if (n21 <= 0) {
                    n21 += n19;
                    continue;
                }
                n21 += n20;
                n15 += n17;
            }
        } else {
            int n24 = n12 << 1;
            int n25 = n12 - n13 << 1;
            f /= (float)n13;
            int n26 = n24 - n13;
            while (n15 != n5) {
                if (this.m_bShowSmoothShading) {
                    n10 = m_alphaOpaque | (int)this.c1d[0] << 16 | (int)this.c1d[1] << 8 | (int)this.c1d[2];
                    int n27 = 0;
                    do {
                        int n28 = n27;
                        this.c1d[n28] = this.c1d[n28] + this.cd_inc[n27];
                    } while (++n27 < 3);
                }
                this.writePixel(n14, n15, n10, f2);
                this.writePixel(n14 - 1, n15, n10, f2);
                this.writePixel(n14 + 1, n15, n10, f2);
                n15 += n17;
                f2 += f;
                if (n26 <= 0) {
                    n26 += n24;
                    continue;
                }
                n26 += n25;
                n14 += n16;
            }
        }
        this.m_zTol = n11;
    }

    protected void drawPolygonOneSide(Graphics graphics, int n, int[] nArray, int[] nArray2, int[] nArray3, int n2, boolean bl, int n3) {
        if (n == PS_ZOOM) {
            graphics.drawPolygon(nArray, nArray2, n2);
            return;
        }
        int[] nArray4 = new int[n2];
        int[] nArray5 = new int[n2];
        boolean bl2 = this.getParallelCurve(nArray4, nArray5, nArray, nArray2, n2, n, true, bl);
        if (!bl2) {
            return;
        }
        --n2;
        int n4 = 0;
        while (n4 < n2) {
            this.xCorner[0] = nArray[n4];
            this.xCorner[1] = nArray4[n4];
            this.xCorner[2] = nArray4[n4 + 1];
            this.xCorner[3] = nArray[n4 + 1];
            this.yCorner[0] = nArray2[n4];
            this.yCorner[1] = nArray5[n4];
            this.yCorner[2] = nArray5[n4 + 1];
            this.yCorner[3] = nArray2[n4 + 1];
            if (!this.m_bEnableZBuffer) {
                graphics.fillPolygon(this.xCorner, this.yCorner, 4);
            } else {
                this.zCorner[0] = nArray3[n4];
                this.zCorner[1] = nArray3[n4];
                this.zCorner[2] = nArray3[n4 + 1];
                this.zCorner[3] = nArray3[n4 + 1];
                boolean bl3 = this.m_bShowTexture;
                this.m_bShowTexture = false;
                this.drawElementZBuffer(this.xCorner, this.yCorner, this.zCorner, 4, null, n3, null, null);
                this.m_bShowTexture = bl3;
            }
            ++n4;
        }
        if (n2 > 0) {
            this.xCorner[0] = nArray[n2];
            this.xCorner[1] = nArray4[n2];
            this.xCorner[2] = nArray4[0];
            this.xCorner[3] = nArray[0];
            this.yCorner[0] = nArray2[n2];
            this.yCorner[1] = nArray5[n2];
            this.yCorner[2] = nArray5[0];
            this.yCorner[3] = nArray2[0];
            if (!this.m_bEnableZBuffer) {
                graphics.fillPolygon(this.xCorner, this.yCorner, 4);
                return;
            }
            this.zCorner[0] = nArray3[n2];
            this.zCorner[1] = nArray3[n2];
            this.zCorner[2] = nArray3[0];
            this.zCorner[3] = nArray3[0];
            n4 = this.m_bShowTexture ? 1 : 0;
            this.m_bShowTexture = false;
            this.drawElementZBuffer(this.xCorner, this.yCorner, this.zCorner, 4, null, n3, null, null);
            this.m_bShowTexture = n4;
        }
    }

    protected int getNumItems() {
        int n = 0;
        if (this.m_useVertices) {
            n += this.m_numVertices;
        } else if (this.m_useUnusedVertices) {
            n += this.m_numUnusedVertices;
        }
        if (this.m_useElements) {
            n += this.m_numElements;
        }
        if (this.m_usePolygons) {
            n += this.m_numPolygonEdges;
        }
        return n;
    }

    private Color getElementCenterColor(int[] nArray) {
        int n = nArray.length;
        if (n == 0) {
            return Color.black;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            int n6 = this.m_vertexColor[nArray[n5]].getRGB();
            n2 += n6 >> 16 & 0xFF;
            n3 += n6 >> 8 & 0xFF;
            n4 += n6 & 0xFF;
            ++n5;
        }
        return new Color(n2 /= n, n3 /= n, n4 /= n);
    }

    private Color getPolygonColor(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Color color = null;
        if (bl4) {
            color = Color.cyan;
        } else if (bl || bl2) {
            color = this.m_globalPolygonTagColor;
        } else if (bl3) {
            color = this.m_globalPolygonTagColor;
        }
        if (color != null) {
            return color;
        }
        int n3 = this.m_polygon[n].m_data[n2];
        if (this.m_bShowPolygonColors && this.m_bInduceElementFromVertexColors) {
            if (n3 != -1 && this.m_bShowSmoothShading) {
                color = this.m_vertexColor[n3];
            } else {
                int n4 = this.m_polygon[n].m_data[n2 + 1];
                color = PdColor.blend(0.5, this.m_vertexColor[n3], 0.5, this.m_vertexColor[n4]);
            }
        } else {
            color = this.m_vertexColorFromElement != null && n3 != -1 ? this.m_vertexColorFromElement[n3] : (this.m_bShowPolygonColors ? this.m_polygonColor[n] : this.m_globalPolygonColor);
        }
        if (this.m_bShowDepthcue && !this.m_bEnableZBuffer) {
            color = this.m_bEnable3DLook ? PdColor.getDimmedColor(color, (double)this.m_heightFac, (double)this.m_heightFac) : PdColor.getDimmedColor(color, (double)this.m_heightFac, (double)this.m_grey * (1.0 - (double)this.m_heightFac));
        }
        return color;
    }

    public boolean hasTagVertex(int n, int n2) {
        return this.m_vertex[n].hasTag(n2);
    }

    public void setLabelStyles(PiVector piVector) {
        if (piVector == null || piVector.getSize() < 7) {
            PsDebug.warning("missing font styles");
            return;
        }
        this.m_labelStyle.copyArray(piVector);
    }

    private int[] fillColorArr(int n) {
        this.m_colArr[0] = n >> 24 & 0xFF;
        this.m_colArr[1] = n >> 16 & 0xFF;
        this.m_colArr[2] = n >> 8 & 0xFF;
        this.m_colArr[3] = n & 0xFF;
        return this.m_colArr;
    }

    private void write8Pixel(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.writePixel(n + n4, n2 + n5, n3, n6, n7);
        this.writePixel(n + n4, n2 - n5, n3, n6, n7);
        this.writePixel(n - n4, n2 - n5, n3, n6, n7);
        this.writePixel(n - n4, n2 + n5, n3, n6, n7);
        if (n4 != n5) {
            this.writePixel(n + n5, n2 + n4, n3, n6, n7);
            this.writePixel(n + n5, n2 - n4, n3, n6, n7);
            this.writePixel(n - n5, n2 - n4, n3, n6, n7);
            this.writePixel(n - n5, n2 + n4, n3, n6, n7);
        }
    }

    private int drawPixel(int n, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        int n7 = (n >> 16 & 0xFF) * n3;
        int n8 = (n >> 8 & 0xFF) * n3;
        int n9 = (n & 0xFF) * n3;
        if (bl) {
            n7 += (n2 >> 16 & 0xFF) * (255 - n3);
            n8 += (n2 >> 8 & 0xFF) * (255 - n3);
            n9 += (n2 & 0xFF) * (255 - n3);
            if (this.m_tpBuffer != null) {
                this.m_tpBuffer[n6][n5] = n3;
                this.m_colBuffer[n6][n5] = n2;
            }
        } else {
            int n10 = (255 - n3) * this.m_tpBuffer[n6][n5] >> 8;
            int n11 = (255 - n3) * (255 - this.m_tpBuffer[n6][n5]) >> 8;
            n7 += (n2 >> 16 & 0xFF) * n10;
            n8 += (n2 >> 8 & 0xFF) * n10;
            n9 += (n2 & 0xFF) * n10;
            n7 += (this.m_colBuffer[n6][n5] >> 16 & 0xFF) * n11;
            n8 += (this.m_colBuffer[n6][n5] >> 8 & 0xFF) * n11;
            n9 += (this.m_colBuffer[n6][n5] & 0xFF) * n11;
        }
        n7 = n7 << 8 & 0xFF0000;
        n9 = n9 >> 8 & 0xFF;
        return n4 | n7 | (n8 &= 0xFF00) | n9;
    }

    protected PiVector getTaggedVertices() {
        int n = this.getNumTaggedVertices();
        if (n == 0) {
            return null;
        }
        PiVector piVector = new PiVector(n);
        n = 0;
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            if (this.m_vertex[n2].hasTag(1)) {
                piVector.setEntry(n++, n2);
            }
            ++n2;
        }
        return piVector;
    }

    protected boolean untagVertices(Rectangle rectangle) {
        int n = 0;
        while (n < this.m_numVertices) {
            if (rectangle.contains(this.m_vertexTrans[n].m_data[0], this.m_vertexTrans[n].m_data[1])) {
                this.m_vertex[n].clearTag(1);
                this.m_geometry.clearTagVertex(n, 1);
                this.m_vertex[n].clearTag(12);
                this.m_geometry.clearTagVertex(n, 12);
                this.m_vertex[n].clearTag(11);
                this.m_geometry.clearTagVertex(n, 11);
            }
            ++n;
        }
        return true;
    }

    protected void setDisplay(PvDisplayIf pvDisplayIf) {
        this.m_display = pvDisplayIf;
    }

    protected int[] getUnusedVertices() {
        return this.m_unusedVertex.m_data;
    }

    protected int computeNumPolygonEdges() {
        this.m_numPolygonEdges = 0;
        int n = 0;
        while (n < this.m_numPolygons) {
            if (this.m_polygon[n] != null) {
                this.m_numPolygonEdges += Math.max(this.m_polygon[n].getSize() - 1, 0);
            }
            ++n;
        }
        this.m_edgeOffset.setSize(this.m_numPolygonEdges);
        this.m_edgePolygon.setSize(this.m_numPolygonEdges);
        n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.m_numPolygons) {
            if (this.m_polygon[n3] != null) {
                int n4 = Math.max(this.m_polygon[n3].getSize() - 1, 0);
                int n5 = 0;
                while (n5 < n4) {
                    this.m_edgePolygon.m_data[n] = n3;
                    this.m_edgeOffset.m_data[n] = n2;
                    ++n;
                    ++n5;
                }
                n2 += n4;
            }
            ++n3;
        }
        return this.m_numPolygonEdges;
    }

    protected void drawItem(Graphics graphics, int n, double d, double d2) {
        this.m_heightFac = 0.2f + 0.8f * (float)d;
        this.m_itemHeight = (float)d2;
        int n2 = 0;
        if (this.m_useVertices) {
            if (n < this.m_numVertices) {
                this.m_bShowCurrElement = true;
                this.drawVertex(graphics, n);
                return;
            }
            n2 = this.m_numVertices;
        } else if (this.m_useUnusedVertices) {
            if (n < this.m_numUnusedVertices) {
                this.m_bShowCurrElement = true;
                this.drawVertex(graphics, this.m_unusedVertex.getEntry(n));
                return;
            }
            n2 = this.m_numUnusedVertices;
        }
        if (this.m_useElements) {
            if (n - n2 < this.m_numElements) {
                this.drawElement(graphics, n - n2);
                return;
            }
            n2 += this.m_numElements;
        }
        if (this.m_usePolygons) {
            if (n - n2 < this.m_numPolygonEdges) {
                this.m_bShowCurrEdge = false;
                this.m_bShowCurrElement = true;
                this.m_bDrawingEdge = true;
                this.drawPolygon(graphics, n - n2);
                return;
            }
            PsDebug.error("itemInd out of range, index = " + n, this);
        }
    }

    private int getTexStencil(int[] nArray, int n, float f, float f2, float f3, float f4, float f5, float f6) {
        int n2 = this.m_texturePix[n];
        int n3 = n2 >> 24 & 0xFF;
        this.m_rgb[0] = n2 >> 16 & 0xFF;
        this.m_rgb[1] = n2 >> 8 & 0xFF;
        this.m_rgb[2] = n2 & 0xFF;
        f4 = 1.0f;
        f5 = 1.0f;
        if (this.m_filterType == 1) {
            this.poss[0] = n;
            this.poss[1] = (this.m_textureHeight - (int)f2 - 1) * this.m_textureWidth + (int)(f + f4);
            this.poss[2] = (this.m_textureHeight - (int)(f2 + f5) - 1) * this.m_textureWidth + (int)f;
            this.poss[3] = (this.m_textureHeight - (int)(f2 + f5) - 1) * this.m_textureWidth + (int)(f + f4);
            int n4 = 1;
            do {
                n2 = this.poss[n4] < 0 || this.poss[n4] >= this.m_texturePix.length ? this.m_texturePix[n] : this.m_texturePix[this.poss[n4]];
                n3 += n2 >> 24 & 0xFF;
                this.m_rgb[0] = this.m_rgb[0] + (n2 >> 16 & 0xFF);
                this.m_rgb[1] = this.m_rgb[1] + (n2 >> 8 & 0xFF);
                this.m_rgb[2] = this.m_rgb[2] + (n2 & 0xFF);
            } while (++n4 < 4);
            n3 >>= 2;
            n4 = 0;
            do {
                this.m_rgb[n4] = this.m_rgb[n4] >> 2;
            } while (++n4 < 3);
        } else {
            n3 <<= 1;
            int n5 = 0;
            do {
                this.m_rgb[n5] = this.m_rgb[n5] << 1;
            } while (++n5 < 3);
            this.poss[0] = (this.m_textureHeight - (int)(f2 - f5) - 1) * this.m_textureWidth + (int)(f - f4);
            this.poss[1] = (this.m_textureHeight - (int)(f2 - f5) - 1) * this.m_textureWidth + (int)(f + f4);
            this.poss[2] = (this.m_textureHeight - (int)(f2 + f5) - 1) * this.m_textureWidth + (int)(f - f4);
            this.poss[3] = (this.m_textureHeight - (int)(f2 + f5) - 1) * this.m_textureWidth + (int)(f + f4);
            this.poss[4] = (this.m_textureHeight - (int)(f2 - f5) - 1) * this.m_textureWidth + (int)f;
            this.poss[5] = (this.m_textureHeight - (int)f2 - 1) * this.m_textureWidth + (int)(f + f4);
            this.poss[6] = (this.m_textureHeight - (int)f2 - 1) * this.m_textureWidth + (int)(f - f4);
            this.poss[7] = (this.m_textureHeight - (int)(f2 + f5) - 1) * this.m_textureWidth + (int)f;
            n5 = 4;
            do {
                n2 = this.poss[n5] < 0 || this.poss[n5] >= this.m_texturePix.length ? this.m_texturePix[n] : this.m_texturePix[this.poss[n5]];
                n3 += n2 >> 24 & 0xFF;
                this.m_rgb[0] = this.m_rgb[0] + (n2 >> 16 & 0xFF);
                this.m_rgb[1] = this.m_rgb[1] + (n2 >> 8 & 0xFF);
                this.m_rgb[2] = this.m_rgb[2] + (n2 & 0xFF);
            } while (++n5 < 8);
            n3 <<= 1;
            n5 = 0;
            do {
                this.m_rgb[n5] = this.m_rgb[n5] << 1;
            } while (++n5 < 3);
            n5 = 0;
            do {
                n2 = this.poss[n5] < 0 || this.poss[n5] >= this.m_texturePix.length ? this.m_texturePix[n] : this.m_texturePix[this.poss[n5]];
                n3 += n2 >> 24 & 0xFF;
                this.m_rgb[0] = this.m_rgb[0] + (n2 >> 16 & 0xFF);
                this.m_rgb[1] = this.m_rgb[1] + (n2 >> 8 & 0xFF);
                this.m_rgb[2] = this.m_rgb[2] + (n2 & 0xFF);
            } while (++n5 < 4);
            n3 >>= 4;
            n5 = 0;
            do {
                this.m_rgb[n5] = this.m_rgb[n5] >> 4;
            } while (++n5 < 3);
        }
        n2 = n3 << 24 | this.m_rgb[0] << 16 | this.m_rgb[1] << 8 | this.m_rgb[2];
        return n2;
    }

    protected void setMIS(int n, int n2, int[] nArray) {
        this.m_imgWidth = n;
        this.m_imgHeight = n2;
        this.m_pixData = nArray;
    }

    protected int pickPolygon(int n, int n2) {
        if (n >= 0 && n < this.m_numPolygons) {
            this.m_polygon[n].setTag(n2);
            this.m_geometry.setTagPolygon(n, n2);
        }
        this.m_pickedPolygon = n;
        return this.m_pickedPolygon;
    }

    protected int releasePolygon(int n, int n2) {
        if (n >= 0 && n < this.m_numPolygons) {
            this.m_polygon[n].clearTag(n2);
            this.m_geometry.clearTagPolygon(n, n2);
        }
        this.m_pickedPolygon = -1;
        return -1;
    }

    protected void projectItems(PdMatrix pdMatrix, PdMatrix pdMatrix2, PdMatrix pdMatrix3, PdMatrix pdMatrix4) {
        if (this.m_dim != this.vtSrc.getSize()) {
            this.vtSrc.setSize(this.m_dim);
            this.vtSrc1.setSize(this.m_dim + 1);
        }
        this.m_viewMat = pdMatrix3;
        this.m_bModAmb = pdMatrix4 != null || this.m_ambientMatrix != null || this.m_ambientProj != 0;
        this.projectVertices(pdMatrix, pdMatrix4);
        if (this.m_bShowName || this.m_bShowTitle) {
            int n = this.m_ambientProj;
            this.m_ambientProj = 0;
            int n2 = 0;
            do {
                this.m_vt.copyArray(this.m_bndBox[n2]);
                this.project(this.m_bndBoxTrans[n2], this.m_vt, pdMatrix);
            } while (++n2 < 2);
            this.m_ambientProj = n;
        }
        if (this.m_bShowVertexSizes && this.m_vertexSize == null) {
            this.m_bShowVertexSizes = false;
        }
        if (this.m_bShowVertexNormals || this.m_bShowEdgeAura || this.m_bShowSilhouette || !this.m_bShowBackface || this.m_bShowElementBackColor) {
            this.projectVertexNormals(pdMatrix, pdMatrix4);
        }
        if (this.m_bShowElementNormals || this.m_bShowEdgeAura || this.m_bShowSilhouette || !this.m_bShowBackface || this.m_bShowElementBackColor || this.m_bShowElementBackColors) {
            this.projectElementNormals(pdMatrix, pdMatrix4);
        }
        if (this.m_bShowVectors) {
            this.projectVectors(pdMatrix, pdMatrix4);
        }
    }

    private void renderLight(PdVector pdVector, PdVector pdVector2, PvLight[] pvLightArray) {
        int n = 0;
        do {
            this.m_lightAttMat[n] = 0.0f;
            this.m_lightAttSpec[n] = 0.0f;
        } while (++n < 3);
        if (this.m_bModAmb) {
            this.project(this.m_vtMod, pdVector, this.m_modelMatrix, this.m_ambientMatrix);
        } else {
            this.m_vtMod.copyArray(pdVector);
        }
        if (this.m_bHasHighlight || !this.m_bLightsSymmetric) {
            this.m_vertexEye.sub(this.m_cameraPos, this.m_vtMod);
            if (this.m_bHasHighlight) {
                this.m_vertexEye.normalize();
            }
        }
        if (this.m_bModAmb) {
            this.m_vtSrc.blendBase(pdVector, this.m_globalVertexNormalLength, pdVector2);
            this.project(this.m_vtTipMod, this.m_vtSrc, this.m_modelMatrix, this.m_ambientMatrix);
            this.m_vtTipMod.sub(this.m_vtMod);
            this.m_vtTipMod.normalize();
            this.m_vnMod.copyArray(this.m_vtTipMod);
        } else {
            this.m_vnMod.copyArray(pdVector2);
        }
        if (this.m_dim < 3) {
            this.m_vnMod.m_data[2] = 1.0;
        }
        n = 0;
        while (n < pvLightArray.length) {
            block32: {
                float f;
                float f2;
                float f3;
                float f4;
                block33: {
                    if (!pvLightArray[n].m_bSwitchedOn) break block32;
                    f4 = 1.0f;
                    if (pvLightArray[n].m_lightType != 3) break block33;
                    this.m_vlMod.sub(this.m_vtMod, pvLightArray[n].m_positionView);
                    float f5 = (float)this.m_vlMod.length();
                    if ((double)f5 > pvLightArray[n].getFalloff() || (f3 = (float)PdVector.angle(pvLightArray[n].m_directionView, this.m_vlMod)) > (f2 = (float)pvLightArray[n].getAngle()) + (f = (float)pvLightArray[n].getCorona())) break block32;
                    if (f3 > f2 && (double)f > 1.0E-10) {
                        f4 = 1.0f - (f3 - f2) / f;
                    }
                }
                float[] fArray = pvLightArray[n].getColorAsFloat();
                f3 = (float)pvLightArray[n].getIntensity();
                if (pvLightArray[n].m_lightType == 0) {
                    int n2 = 0;
                    do {
                        int n3 = n2;
                        this.m_lightAttMat[n3] = this.m_lightAttMat[n3] + f3 * fArray[n2];
                    } while (++n2 < 3);
                } else {
                    float f6;
                    f2 = -((float)PdVector.dot(this.m_vnMod, pvLightArray[n].m_directionView));
                    if (f2 < -1.0f) {
                        f2 = -1.0f;
                    } else if (f2 > 1.0f) {
                        f2 = 1.0f;
                    }
                    if (pvLightArray[n].m_shading != 0) {
                        boolean bl;
                        f = (float)PdVector.dot(this.m_vnMod, this.m_vertexEye);
                        boolean bl2 = bl = f < 0.0f && f2 > 0.0f || f > 0.0f && f2 < 0.0f;
                        if (bl && f2 > 0.0f || !bl && f2 < 0.0f) {
                            f2 = -f2;
                        }
                    }
                    switch (pvLightArray[n].m_shading) {
                        case 0: {
                            if (!(f2 < 0.0f)) break;
                            f2 = -f2;
                            break;
                        }
                        case 1: 
                        case 11: {
                            if (!(f2 < 0.0f)) break;
                            f2 = 0.0f;
                            break;
                        }
                        case 2: 
                        case 12: {
                            f2 = (f2 + 1.0f) / 2.0f;
                            break;
                        }
                        case 13: {
                            f = (float)Math.sqrt(1.0f - f2 * f2);
                            float f7 = (float)Math.acos(f2) * 180.0f / (float)Math.PI;
                            f2 = (float)(0.2142857164144516 + (double)(f * 4.0f / 7.0f) / Math.PI + (double)((11.0f - 0.044444446f * f7) / 14.0f * f2));
                            break;
                        }
                        case 14: {
                            float f8 = (f2 + 1.0f) / 2.0f;
                            f = (float)Math.sqrt(1.0f - f2 * f2);
                            float f9 = (float)Math.acos(f2) * 180.0f / (float)Math.PI;
                            f6 = (float)(0.2142857164144516 + (double)(f * 4.0f / 7.0f) / Math.PI + (double)((11.0f - 0.044444446f * f9) / 14.0f * f2));
                            float f10 = (float)pvLightArray[n].getBlend();
                            f2 = f10 * f8 + (1.0f - f10) * f6;
                            break;
                        }
                        default: {
                            PsDebug.warning("unknown shading type or light model.");
                            return;
                        }
                    }
                    f2 *= f4;
                    int n4 = 0;
                    do {
                        int n5 = n4;
                        this.m_lightAttMat[n5] = this.m_lightAttMat[n5] + f3 * fArray[n4] * f2;
                    } while (++n4 < 3);
                    if (pvLightArray[n].isHighlight()) {
                        this.m_halfVector.sub(this.m_vertexEye, pvLightArray[n].m_directionView);
                        float f11 = (float)this.m_halfVector.length();
                        if (!((double)f11 < 1.0E-10)) {
                            f6 = (float)Math.abs(PdVector.dot(this.m_vnMod, this.m_halfVector) / (double)f11);
                            f6 = 255.0f * f3 * f4 * (float)Math.pow(f6, pvLightArray[n].getExponent());
                            int n6 = 0;
                            do {
                                int n7 = n6;
                                this.m_lightAttSpec[n7] = this.m_lightAttSpec[n7] + f6 * this.m_specular[n6];
                            } while (++n6 < 3);
                        }
                    }
                }
            }
            ++n;
        }
    }

    private boolean makeInducedVertexColorsFromElementColors(int n, PiVector[] piVectorArray, Color[] colorArray) {
        if (piVectorArray == null || colorArray == null) {
            PsDebug.warning("missing element colors");
            this.m_vertexColorFromElement = null;
            return false;
        }
        if (this.m_numVertices == 0 || n == 0) {
            this.m_vertexColorFromElement = null;
            return true;
        }
        int[][] nArray = new int[this.m_numVertices][3];
        int[] nArray2 = new int[this.m_numVertices];
        int n2 = 0;
        while (n2 < n) {
            int n3 = piVectorArray[n2].getSize();
            int n4 = colorArray[n2].getRGB();
            int n5 = 0;
            while (n5 < n3) {
                int n6 = piVectorArray[n2].m_data[n5];
                int[] nArray3 = nArray[n6];
                nArray3[0] = nArray3[0] + (n4 >> 16 & 0xFF);
                int[] nArray4 = nArray[n6];
                nArray4[1] = nArray4[1] + (n4 >> 8 & 0xFF);
                int[] nArray5 = nArray[n6];
                nArray5[2] = nArray5[2] + (n4 & 0xFF);
                int n7 = n6;
                nArray2[n7] = nArray2[n7] + 1;
                ++n5;
            }
            ++n2;
        }
        this.m_vertexColorFromElement = PdColor.realloc(this.m_vertexColorFromElement, this.m_numVertices);
        n2 = 0;
        while (n2 < this.m_numVertices) {
            this.m_vertexColorFromElement[n2] = nArray2[n2] > 0 ? new Color((int)((float)nArray[n2][0] / (float)nArray2[n2]), (int)((float)nArray[n2][1] / (float)nArray2[n2]), (int)((float)nArray[n2][2] / (float)nArray2[n2])) : Color.black;
            ++n2;
        }
        return true;
    }

    public void init() {
        super.init();
        this.m_useVertices = true;
        this.m_useElements = true;
        this.m_bHasNeighbours = false;
        this.m_bShowTransparency = false;
        this.m_alpha = m_alphaOpaque;
        this.m_transparency = 0;
        this.m_bHasTaggedVertices = false;
        this.m_bHasTaggedPolygons = false;
        this.m_bHasTaggedEdges = false;
        this.m_bHasTaggedBoundaries = false;
        this.m_bHasTaggedElements = false;
        this.m_vertexTrans = null;
        this.m_vertexNormalTrans = null;
        this.m_elementNormalTrans = null;
        this.m_vectorTrans = null;
        this.m_globalBndboxColor = Color.magenta;
        this.m_bndBox = PdVector.realloc(this.m_bndBox, 2, this.m_dim);
        this.m_bndBox[0].setConstant(-1.0);
        this.m_bndBox[1].setConstant(1.0);
        this.m_centerTrans = new PiVector(this.m_dimTrans);
        this.m_elemCenter = new PdVector(this.m_dim);
        this.m_elemCenterTrans = new PiVector(this.m_dimTrans);
    }

    protected int pickElement(int n, int n2) {
        if (n >= 0 && n < this.m_numElements) {
            this.m_element[n].setTag(n2);
            this.m_geometry.setTagElement(n, n2);
        }
        this.m_pickedElement = n;
        return this.m_pickedElement;
    }

    protected int releaseElement(int n, int n2) {
        if (n >= 0 && n < this.m_numElements) {
            this.m_element[n].clearTag(n2);
            this.m_geometry.clearTagElement(n, n2);
        }
        this.m_pickedElement = -1;
        return -1;
    }

    private void drawElementVectors(Graphics graphics, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n3 = 0;
        while (n3 < this.m_numVectorFields) {
            if (this.m_bShowVectorField[n3] && this.m_vectorIsElementBased[n3]) {
                Color color;
                if (this.m_vector[n3][n].hasTag(1)) {
                    color = this.m_globalElementTagColor;
                } else {
                    color = this.m_globalVectorColor[n3];
                    if (this.m_bShowVectorColors[n3]) {
                        color = this.m_vectorColor[n3][n];
                    }
                }
                this.getElementCenter(this.m_elemCenterTrans, this.m_element[n].m_data, this.m_vertexTrans, this.m_dimTrans);
                this.drawVectorAny(graphics, this.m_globalVectorSize[n3] * (double)this.m_offFac, this.m_elemCenterTrans.m_data[0], this.m_elemCenterTrans.m_data[1], this.m_elemCenterTrans.m_data[2], this.m_vectorTrans[n3][n].m_data[0], this.m_vectorTrans[n3][n].m_data[1], this.m_vectorTrans[n3][n].m_data[2], this.m_bShowVectorArrow[n3], color, false);
            }
            ++n3;
        }
    }

    protected void projectVectors(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (this.m_numVertices == 0 || this.m_numVectorFields == 0) {
            this.m_bShowVectors = false;
            return;
        }
        boolean bl = this.m_bEnableClip;
        this.m_bEnableClip = false;
        PdVector[] pdVectorArray = this.m_clipBounds;
        this.m_clipBounds = null;
        int n = 0;
        while (n < this.m_numVectorFields) {
            if (this.m_bShowVectorField[n]) {
                int n2;
                int n3 = this.getDimOfVectors(n);
                this.m_vtSrc.setConstant(0.0);
                if (!this.m_vectorIsElementBased[n]) {
                    n2 = 0;
                    while (n2 < this.m_numVertices) {
                        if (n3 == 1 && this.m_vertexNormal != null) {
                            this.m_vtSrc.blendBase(this.m_vertex[n2], this.m_globalVectorLength[n] * this.m_vector[n][n2].m_data[0], this.m_vertexNormal[n2]);
                        } else if (n3 == this.m_dim) {
                            this.m_vtSrc.blendBase(this.m_vertex[n2], this.m_globalVectorLength[n], this.m_vector[n][n2]);
                        } else {
                            this.m_vtSrc.copyArray(this.m_vector[n][n2]);
                            this.m_vtSrc.blendBase(this.m_vertex[n2], this.m_globalVectorLength[n], this.m_vtSrc);
                        }
                        if (this.m_bModAmb) {
                            this.project(this.m_vtMod, this.m_vtSrc, pdMatrix2, this.m_ambientMatrix);
                        } else {
                            this.m_vtMod.copyArray(this.m_vtSrc);
                        }
                        this.project(this.m_vectorTrans[n][n2], this.m_vtMod, pdMatrix);
                        ++n2;
                    }
                } else {
                    n2 = 0;
                    while (n2 < this.m_numElements) {
                        this.getElementCenter(this.m_elemCenter, this.m_element[n2].m_data, this.m_vertex, this.m_dim);
                        this.m_vtSrc.blendBase(this.m_elemCenter, this.m_globalVectorLength[n], this.m_vector[n][n2]);
                        if (n3 == 1 && this.m_elementNormal != null) {
                            this.m_vtSrc.blendBase(this.m_elemCenter, this.m_globalVectorLength[n] * this.m_vector[n][n2].m_data[0], this.m_elementNormal[n2]);
                        } else if (n3 == this.m_dim) {
                            this.m_vtSrc.blendBase(this.m_elemCenter, this.m_globalVectorLength[n], this.m_vector[n][n2]);
                        } else {
                            this.m_vtSrc.copyArray(this.m_vector[n][n2]);
                            this.m_vtSrc.blendBase(this.m_elemCenter, this.m_globalVectorLength[n], this.m_vtSrc);
                        }
                        if (this.m_bModAmb) {
                            this.project(this.m_vtMod, this.m_vtSrc, pdMatrix2, this.m_ambientMatrix);
                        } else {
                            this.m_vtMod.copyArray(this.m_vtSrc);
                        }
                        this.project(this.m_vectorTrans[n][n2], this.m_vtMod, pdMatrix);
                        ++n2;
                    }
                }
            }
            ++n;
        }
        this.m_bEnableClip = bl;
        this.m_clipBounds = pdVectorArray;
    }

    protected boolean setGeometryElement(int n, PiVector piVector) {
        int n2 = piVector.getSize();
        switch (this.getType()) {
            case 33: {
                if (n2 < 3) {
                    return false;
                }
                this.setElement(n, piVector);
                PiVector piVector2 = this.m_geometry.getElement(n);
                piVector2.copyArray(piVector);
                return this.m_geometry.setElement(n, piVector2);
            }
            case 32: {
                if (n2 < 2) {
                    return false;
                }
                this.setPolygon(n, piVector);
                PiVector piVector3 = this.m_geometry.getPolygon(n);
                piVector3.copyArray(piVector);
                return this.m_geometry.setPolygon(n, piVector3);
            }
        }
        return false;
    }

    public void setTexture(int[] nArray, int n, int n2, int n3, int n4) {
        this.m_texturePix = nArray;
        this.m_textureWidth = n;
        this.m_textureHeight = n2;
        if (nArray == null) {
            this.setState(71, false);
            this.setState(72, false);
            this.m_bShowTexture = false;
        }
        this.m_blendingMode = n3;
        this.m_filterType = n4;
    }

    protected void assureTexture(boolean bl) {
        if (!bl) {
            this.m_texCoord = null;
            this.texSub = null;
            this.m_faceTextureBnd = null;
            this.m_rgb = null;
            this.poss = null;
            return;
        }
        this.m_texCoord = PdVector.realloc(this.m_texCoord, this.m_maxSizeOfElements, 3);
        this.texSub = new PdVector[3];
        if (this.m_dispSize != null) {
            int n = (this.m_dispSize.height + this.m_dispSize.width) * 2;
            this.m_faceTextureBnd = PdVector.realloc(this.m_faceTextureBnd, n, 3);
        }
        this.m_rgb = new int[3];
        this.poss = new int[8];
    }

    private void writeCircle(int n, int n2, double d, int n3, int n4) {
        int n5;
        if (this.m_imgWidth == 0) {
            return;
        }
        this.m_colArr = this.fillColorArr(n3);
        this.cSize = n5 = (int)(d + 0.5);
        if (d > 0.0 && d < 1.0) {
            this.writePixel(n, n2, 0, n4, n3);
            return;
        }
        if (n5 == 1) {
            if (this.m_bShowVertexOutline) {
                this.writePixel(n - 1, n2, 0, n4, this.m_outCol);
                this.writePixel(n + 1, n2, 0, n4, this.m_outCol);
                this.writePixel(n, n2 - 1, 0, n4, this.m_outCol);
                this.writePixel(n, n2 + 1, 0, n4, this.m_outCol);
            }
            this.writePixel(n, n2, 1, n4, n3);
            return;
        }
        if (n5 == 2) {
            int n6 = n5 - 1;
            int n7 = -n6;
            while (n7 <= n6) {
                int n8 = n2 + n7;
                if (this.m_bShowVertexOutline) {
                    this.writePixel(n - n5, n8, 0, n4, this.m_outCol);
                    this.writePixel(n + n5, n8, 0, n4, this.m_outCol);
                    this.writePixel(n + n7, n2 - n6 - 1, 0, n4, this.m_outCol);
                    this.writePixel(n + n7, n2 + n6 + 1, 0, n4, this.m_outCol);
                }
                int n9 = -n6;
                while (n9 <= n6) {
                    int n10 = n + n9;
                    this.writePixel(n10, n8, 1, n4, n3);
                    ++n9;
                }
                ++n7;
            }
            return;
        }
        if (n < -n5 || n >= this.m_imgWidth + n5 || n2 < -n5 || n2 >= this.m_zBuffer.length - 1 + n5) {
            return;
        }
        if (this.m_heightArr == null) {
            this.m_heightArr = this.createHeightArr(this.m_cacheRadius);
        }
        this.cx = n;
        this.cy = n2;
        this.cSize = n5;
        float f = (float)(this.m_cacheRadius - 1) / (float)n5;
        float f2 = f / 2.0f;
        int n11 = n5;
        int n12 = 0;
        int n13 = 1 - n11;
        if (this.m_bShowVertexOutline) {
            this.write8Pixel(n, n2, 0, n12, n11, n4, this.m_outCol);
        }
        this.writeLine(n5 - 1, 0, n4, n3, f, f2);
        while (n11 > n12 + 1) {
            if (n13 < 0) {
                n13 += (n12 << 1) + 3;
                this.writeLine(n11 - 1, ++n12, n4, n3, f, f2);
            } else {
                n13 += (n12 - n11 << 1) + 5;
                this.writeLine(--n11 - 1, ++n12, n4, n3, f, f2);
                if (n12 < n11) {
                    this.writeLine(n12 - 1, n11, n4, n3, f, f2);
                }
            }
            if (!this.m_bShowVertexOutline) continue;
            this.write8Pixel(n, n2, 0, n12, n11, n4, this.m_outCol);
        }
    }

    private double getPolygonSize(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        double d = this.m_globalPolygonSize;
        if (this.m_bShowPolygonSizes) {
            d = this.m_globalPolygonSize * this.m_polygonSize.getEntry(n);
        }
        if (!this.m_bAdaptiveSize) {
            if (bl || bl2) {
                d = d < 1.0 ? 3.0 : (d += 4.0);
            } else if (bl4 && bl3) {
                d = d < 1.0 ? 2.0 : (d += 3.0);
            } else if (bl3 || bl4) {
                d = d < 1.0 ? 1.0 : (d += 2.0);
            }
        } else if (bl || bl2) {
            d *= 1.4;
        } else if (bl4 && bl3) {
            d *= 1.3;
        } else if (bl3 || bl4) {
            d *= 1.2;
        }
        return d * (double)this.m_offFac;
    }

    public void setLabelSizes(PdVector pdVector) {
        if (pdVector == null || pdVector.getSize() < 7) {
            PsDebug.warning("missing font sizes");
            return;
        }
        this.m_labelSize.copyArray(pdVector);
    }

    protected void untagPolygons(Rectangle rectangle) {
        int n = this.getNumPolygons();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.m_polygon[n2].hasTag(1)) {
                int n3 = this.m_polygon[n2].getSize();
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = this.m_polygon[n2].m_data[n4];
                    if (rectangle.contains(this.m_vertexTrans[n5].m_data[0], this.m_vertexTrans[n5].m_data[1])) {
                        this.m_polygon[n2].clearTag(1);
                        this.m_geometry.clearTagPolygon(n2, 1);
                        this.m_polygon[n2].clearTag(12);
                        this.m_geometry.clearTagPolygon(n2, 12);
                        this.m_polygon[n2].clearTag(11);
                        this.m_geometry.clearTagPolygon(n2, 11);
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void writeLine(int n, int n2, int n3, int n4, float f, float f2) {
        if (this.cy + n2 < 0 || this.cy - n2 >= this.m_zBuffer.length - 1) {
            return;
        }
        float f3 = f2;
        float f4 = f;
        float f5 = f2 + (float)n2 * f;
        int n5 = (int)f5;
        int n6 = 0;
        while (n6 <= n) {
            int n7 = (int)f3;
            f3 += f4;
            int n8 = 0;
            if (this.m_heightArr[n7][n5] > 0) {
                n8 = (int)((float)this.m_heightArr[n7][n5] / f);
            }
            this.writePixel(this.cx + n6, this.cy + n2, n8, n3, n4);
            if (n6 != 0) {
                this.writePixel(this.cx - n6, this.cy + n2, n8, n3, n4);
            }
            if (n2 != 0) {
                this.writePixel(this.cx + n6, this.cy - n2, n8, n3, n4);
                if (n6 != 0) {
                    this.writePixel(this.cx - n6, this.cy - n2, n8, n3, n4);
                }
            }
            ++n6;
        }
    }

    public void setSpecial(boolean bl) {
        this.m_bSpecial = bl;
    }

    private float getAdaptiveScale(float f) {
        float f2;
        float f3 = f2 = (float)this.m_camera.getDist();
        float f4 = Math.min(((PvDisplay)this.m_display).m_nWidth, ((PvDisplay)this.m_display).m_nHeight);
        float f5 = f4 / f3;
        float f6 = (float)this.m_camera.getFieldOfView();
        float f7 = f2;
        float f8 = (float)((double)f2 / PvCamera.SIZE * (double)f / (double)PvCamera.Z_STRETCH);
        float f9 = 1.0f;
        if ((double)(f7 - f8 * f6) < 1.0E-10) {
            return -1.0f;
        }
        float f10 = f9 * f7 / (f7 - f8 * f6);
        float f11 = f10 * f5;
        return (float)Math.log(f11 / 60.0f + 1.0f) * 3.0f;
    }

    protected int getZMax() {
        return this.m_zMax;
    }

    private void assureClip(boolean bl) {
        this.m_bEnableClip = bl;
        if (!bl) {
            this.m_vdClip = null;
            this.m_cvClip = null;
            this.m_origIndClip = null;
            this.m_texClip = null;
            this.m_lvClip = null;
            return;
        }
        this.m_vdClip = PdVector.realloc(null, this.m_maxSizeOfElements, this.m_dimTrans);
        this.m_cvClip = new int[this.m_maxSizeOfElements][3];
        this.m_origIndClip = new int[this.m_maxSizeOfElements];
        this.m_texClip = PdVector.realloc(null, this.m_maxSizeOfElements, 2);
        this.m_lvClip = new float[this.m_maxSizeOfElements][6];
    }

    public void setVertexNormals(PdVector[] pdVectorArray) {
        super.setVertexNormals(pdVectorArray);
        if (pdVectorArray == null) {
            this.m_vertexNormalTrans = null;
        }
    }

    public void setElementNormals(PdVector[] pdVectorArray) {
        super.setElementNormals(pdVectorArray);
        if (pdVectorArray == null) {
            this.m_elementNormalTrans = null;
        }
    }

    protected void projectVertexNormals(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (this.m_numVertices == 0 || this.m_vertexNormal == null || this.m_vertexNormal.length < this.m_numVertices) {
            this.m_bShowVertexNormals = false;
            return;
        }
        boolean bl = this.m_bEnableClip;
        this.m_bEnableClip = false;
        PdVector[] pdVectorArray = this.m_clipBounds;
        this.m_clipBounds = null;
        int n = 0;
        while (n < this.m_numVertices) {
            this.m_vtSrc.blendBase(this.m_vertex[n], this.m_globalVertexNormalLength, this.m_vertexNormal[n]);
            if (this.m_bModAmb) {
                this.project(this.m_vtTipMod, this.m_vtSrc, pdMatrix2, this.m_ambientMatrix);
            } else {
                this.m_vtTipMod.copyArray(this.m_vtSrc);
            }
            this.project(this.m_vertexNormalTrans[n], this.m_vtTipMod, pdMatrix);
            if (!(this.m_bShowElements || this.m_bShowPolygons || this.m_bShowBackface)) {
                boolean bl2 = false;
                if (!this.m_bPerspectivity) {
                    bl2 = this.m_vertexNormalTrans[n].m_data[2] - this.m_vertexTrans[n].m_data[2] < 0;
                } else {
                    this.project(this.m_vtMod, this.m_vertex[n], pdMatrix2, this.m_ambientMatrix);
                    this.m_vtTipMod.sub(this.m_vtMod);
                    this.m_vertexEye.sub(this.m_vtMod, this.m_cameraPos);
                    boolean bl3 = bl2 = PdVector.dot(this.m_vtTipMod, this.m_vertexEye) > 0.0;
                }
                if (bl2) {
                    this.m_vertexNormalTrans[n].setTag(15);
                } else {
                    this.m_vertexNormalTrans[n].clearTag(15);
                }
            }
            ++n;
        }
        this.m_bEnableClip = bl;
        this.m_clipBounds = pdVectorArray;
    }

    protected void projectElementNormals(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (this.m_numElements == 0 || this.m_elementNormal == null || this.m_elementNormal.length < this.m_numElements) {
            this.m_bShowElementNormals = false;
            return;
        }
        boolean bl = this.m_bEnableClip;
        this.m_bEnableClip = false;
        PdVector[] pdVectorArray = this.m_clipBounds;
        this.m_clipBounds = null;
        int n = 0;
        while (n < this.m_numElements) {
            this.getElementCenter(this.m_elemCenter, this.m_element[n].m_data, this.m_vertex, this.m_dim);
            this.m_vtSrc.blendBase(this.m_elemCenter, this.m_globalElementNormalLength, this.m_elementNormal[n]);
            this.project(this.m_vtTipMod, this.m_vtSrc, pdMatrix2, this.m_ambientMatrix);
            this.project(this.m_elementNormalTrans[n], this.m_vtTipMod, pdMatrix);
            if (this.m_bShowSilhouette || !this.m_bShowBackface || this.m_bShowElementBackColor || this.m_bShowElementBackColors || this.m_bShowEdgeAura || this.m_dim < 3) {
                boolean bl2 = false;
                if (!this.m_bPerspectivity) {
                    int n2 = this.m_element[n].m_data.length;
                    double d = this.m_vertexTrans[this.m_element[n].m_data[0]].m_data[2];
                    int n3 = 1;
                    while (n3 < n2) {
                        d += (double)this.m_vertexTrans[this.m_element[n].m_data[n3]].m_data[2];
                        ++n3;
                    }
                    bl2 = this.m_elementNormalTrans[n].m_data[2] - (int)(d / (double)n2) < 0;
                } else {
                    this.project(this.m_vtMod, this.m_elemCenter, pdMatrix2, this.m_ambientMatrix);
                    this.m_vtTipMod.sub(this.m_vtMod);
                    this.m_vertexEye.sub(this.m_vtMod, this.m_cameraPos);
                    boolean bl3 = bl2 = PdVector.dot(this.m_vtTipMod, this.m_vertexEye) > 0.0;
                }
                if (bl2) {
                    this.m_elementNormalTrans[n].setTag(15);
                } else {
                    this.m_elementNormalTrans[n].clearTag(15);
                }
            }
            ++n;
        }
        this.m_bEnableClip = bl;
        this.m_clipBounds = pdVectorArray;
    }

    public void assureVertexNormals() {
        super.assureVertexNormals();
        if (this.m_vertexNormalTrans == null || this.m_vertexNormalTrans.length != this.m_maxNumVertices) {
            this.m_vertexNormalTrans = PiVector.realloc(this.m_vertexNormalTrans, this.m_maxNumVertices, this.m_dimTrans);
        }
    }

    public void assureElementNormals() {
        super.assureElementNormals();
        if (this.m_elementNormalTrans == null || this.m_elementNormalTrans.length != this.m_maxNumElements) {
            this.m_elementNormalTrans = PiVector.realloc(this.m_elementNormalTrans, this.m_maxNumElements, this.m_dimTrans);
        }
    }

    public void setTagPolygon(int n, int n2) {
        this.m_polygon[n].setTag(n2);
        this.m_geometry.setTagPolygon(n, n2);
    }

    private int clipPolygon(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n3 = 0;
        int n4 = 0;
        double d7 = 0.0;
        int n5 = 0;
        do {
            int n6 = this.m_polygon[n].m_data[n2 + n5];
            if ((double)this.m_vertexTrans[n6].m_data[2] < this.m_clipFar || (double)this.m_vertexTrans[n6].m_data[2] > this.m_clipNear) {
                this.m_bElemIsClipped = true;
                d4 = this.m_vertexTrans[n6].m_data[0];
                d5 = this.m_vertexTrans[n6].m_data[1];
                d6 = this.m_vertexTrans[n6].m_data[2];
                if (n4 == 1) {
                    d7 = d6 < this.m_clipFar ? (d3 - this.m_clipFar) / (d3 - d6) : (d3 - this.m_clipNear) / (d3 - d6);
                    nArray[n3] = (int)((1.0 - d7) * d + d7 * d4);
                    nArray2[n3] = (int)((1.0 - d7) * d2 + d7 * d5);
                    nArray3[n3] = (int)((1.0 - d7) * d3 + d7 * d6);
                    nArray4[n3] = -1;
                    ++n3;
                }
                n4 = -1;
                continue;
            }
            d = this.m_vertexTrans[n6].m_data[0];
            d2 = this.m_vertexTrans[n6].m_data[1];
            d3 = this.m_vertexTrans[n6].m_data[2];
            if (n4 == -1) {
                d7 = d6 < this.m_clipFar ? (d3 - this.m_clipFar) / (d3 - d6) : (d3 - this.m_clipNear) / (d3 - d6);
                nArray[n3] = (int)((1.0 - d7) * d + d7 * d4);
                nArray2[n3] = (int)((1.0 - d7) * d2 + d7 * d5);
                nArray3[n3] = (int)((1.0 - d7) * d3 + d7 * d6);
                nArray4[n3] = -1;
                ++n3;
            }
            nArray[n3] = this.m_vertexTrans[n6].m_data[0];
            nArray2[n3] = this.m_vertexTrans[n6].m_data[1];
            nArray3[n3] = this.m_vertexTrans[n6].m_data[2];
            nArray4[n3] = n6;
            ++n3;
            n4 = 1;
        } while (++n5 < 2);
        return n3;
    }

    private boolean clipPolygon3D(PdVector[] pdVectorArray, double[] dArray, int n, double d, double d2) {
        double d3 = pdVectorArray[0].m_data[n] - pdVectorArray[1].m_data[n];
        if (Math.abs(d3) < 1.0E-10) {
            return false;
        }
        double d4 = (pdVectorArray[0].m_data[n] - d) / d3;
        double d5 = (pdVectorArray[0].m_data[n] - d2) / d3;
        if (d4 > d5) {
            double d6 = d4;
            d4 = d5;
            d5 = d6;
        }
        if (d4 > dArray[0]) {
            this.m_bElemIsClipped = true;
            dArray[0] = d4;
        }
        if (d5 < dArray[1]) {
            this.m_bElemIsClipped = true;
            dArray[1] = d5;
        }
        return this.m_bElemIsClipped;
    }

    public PvGeometry(int n) {
        super(n);
        if (PsConfig.getOSId() == 0) {
            this.m_defWidthString = 30;
            this.m_defHeightString = 25;
        } else {
            this.m_defWidthString = 90;
            this.m_defHeightString = 31;
        }
        this.m_widthString = this.m_defWidthString;
        this.m_heightString = this.m_defHeightString;
        this.m_dimTrans = 3;
        this.m_dimOfColors = 3;
        this.vtSrc1 = new PdVector(this.m_dim + 1);
        this.vtSrc = new PdVector(this.m_dim);
        this.vtMod1 = new PdVector(this.m_dimTrans + 1);
        this.setMaxSizeElements(6);
        this.m_vtSrc = new PdVector(this.m_dim);
        this.m_vtMod = new PdVector(this.m_dimTrans);
        this.m_vtTipMod = new PdVector(this.m_dimTrans);
        this.m_vnMod = new PdVector(this.m_dimTrans);
        this.m_vlMod = new PdVector(this.m_dimTrans);
        this.m_vt = new PdVector(this.m_dimTrans + 1);
        this.m_bShowBackface = true;
        this.m_bShowDepthcue = true;
        this.m_bShowEdgeOnce = true;
        this.m_bIsClippable = true;
        this.m_bEnableClip = false;
        this.m_bEnableClipBounds = false;
        this.m_bEnableClipCamera = false;
        this.m_clipFar = Double.NEGATIVE_INFINITY;
        this.m_clipNear = Double.MAX_VALUE;
        this.m_bEnableZBuffer = false;
        this.init();
    }

    protected void setEnabledClipCamera(boolean bl) {
        if (this.m_bEnableClipCamera == bl) {
            return;
        }
        this.m_bEnableClipCamera = bl;
        this.assureClip(this.m_bEnableClipBounds || this.m_bEnableClipCamera);
    }

    public void setTagElement(int n, int n2) {
        this.m_element[n].setTag(n2);
        this.m_geometry.setTagElement(n, n2);
    }

    public void clearTagVertex(int n, int n2) {
        this.m_vertex[n].clearTag(n2);
        this.m_geometry.clearTagVertex(n, n2);
    }

    private void drawVertex(Graphics graphics, int n) {
        Color color;
        int n2;
        boolean bl;
        PdVector pdVector = this.m_vertex[n];
        if (pdVector.hasTag(2)) {
            return;
        }
        if (n < 0 || this.m_numVertices <= n) {
            return;
        }
        this.m_bIsBackface = this.isBackVertexCulled(n);
        if (!this.m_bShowBackface && this.m_bIsBackface) {
            return;
        }
        boolean bl2 = this.m_bShowTaggedVertices && this.m_bHasTaggedVertices && pdVector.hasTag(12);
        boolean bl3 = this.m_bShowTaggedVertices && this.m_bHasTaggedVertices && pdVector.hasTag(11);
        boolean bl4 = this.m_bShowTaggedVertices && this.m_bHasTaggedVertices && pdVector.hasTag(1);
        boolean bl5 = bl = pdVector.getURL() != null;
        if (!(this.m_bShowVertices || this.m_bShowVertexNormals || this.m_bShowVectors || bl2 || bl3 || bl4 || bl)) {
            return;
        }
        int n3 = this.m_vertexTrans[n].m_data[0];
        int n4 = this.m_vertexTrans[n].m_data[1];
        int n5 = this.m_vertexTrans[n].m_data[2];
        double d = this.getVertexSize(n, bl2, bl3, bl4, bl);
        if (this.m_bAdaptiveSize) {
            float f = this.getAdaptiveScale(n5);
            if ((double)f < 0.0) {
                return;
            }
            d *= (double)f;
        }
        int n6 = (int)(d + 0.5);
        int n7 = (int)(2.0 * d + 0.5);
        this.m_bFastClipping = this.m_bFastZBuffer;
        if (this.m_bFastClipping) {
            if (n4 <= -n6 || n4 >= this.m_dispSize.height + n6 || n3 <= -n6 || n3 >= this.m_dispSize.width + n6) {
                return;
            }
            if (this.m_bEnableZBuffer && !this.m_bShowTransparency && n3 - n6 >= 0 && n3 < this.m_dispSize.width - n6 && n4 - n6 >= 0 && n4 < this.m_dispSize.height - n6 && n5 - this.m_zTolVertex + n6 < this.m_zBuffer[n4 - n6][n3 - n6] && n5 - this.m_zTolVertex + n6 < this.m_zBuffer[n4 + n6][n3 - n6] && n5 - this.m_zTolVertex + n6 < this.m_zBuffer[n4 + n6][n3 + n6] && n5 - this.m_zTolVertex + n6 < this.m_zBuffer[n4 - n6][n3 + n6] && n5 - this.m_zTolVertex + n6 < this.m_zBuffer[n4][n3]) {
                return;
            }
        }
        if (this.m_bAutoClip && n5 > this.m_autoClip) {
            return;
        }
        if (this.m_bIsClippable) {
            if (this.m_bEnableClipCamera && ((double)n5 < this.m_clipFar || (double)n5 > this.m_clipNear)) {
                return;
            }
            if (this.m_bEnableClipBounds && this.m_clipBounds != null) {
                this.project(this.m_vtMod, pdVector, this.m_modelMatrix, this.m_ambientMatrix);
                n2 = 0;
                do {
                    if (this.m_vtMod.m_data[n2] < this.m_clipBounds[0].m_data[n2] - 1.0E-10) {
                        return;
                    }
                    if (!(this.m_vtMod.m_data[n2] > this.m_clipBounds[1].m_data[n2] + 1.0E-10)) continue;
                    return;
                } while (++n2 < 3);
            }
        }
        if (this.m_bEnable3DLook) {
            this.m_currVertex = pdVector;
        }
        int n8 = n2 = !this.m_bShowLighting || this.m_vertexNormal == null || bl2 || bl3 || bl4 || this.m_bEnableZBuffer && this.m_light != null && this.m_bEnable3DLook && d > 2.0 && this.m_camUp3D != null ? 0 : 1;
        if (n2 != 0) {
            this.renderLight(pdVector, this.m_vertexNormal[n], this.m_light);
        }
        if (this.m_bShowVertexNormals) {
            color = this.m_bShowDepthcue ? PdColor.getDimmedColor(this.m_globalVertexNormalColor, (int)(255.0f * this.m_heightFac)) : this.m_globalVertexNormalColor;
            this.drawVectorAny(graphics, this.m_globalVertexNormalSize * (double)this.m_offFac, n3, n4, n5, this.m_vertexNormalTrans[n].m_data[0], this.m_vertexNormalTrans[n].m_data[1], this.m_vertexNormalTrans[n].m_data[2], this.m_bShowVertexNormalArrow, color, true);
        }
        if (this.m_bShowVectors) {
            int n9 = 0;
            while (n9 < this.m_numVectorFields) {
                if (this.m_bShowVectorField[n9] && !this.m_vectorIsElementBased[n9]) {
                    if (this.m_vector[n9][n].hasTag(1)) {
                        color = this.m_globalVertexTagColor;
                    } else {
                        color = this.m_globalVectorColor[n9];
                        if (this.m_bShowVectorColors[n9]) {
                            color = this.m_vectorColor[n9][n];
                        }
                    }
                    this.drawVectorAny(graphics, this.m_globalVectorSize[n9] * (double)this.m_offFac, n3, n4, n5, this.m_vectorTrans[n9][n].m_data[0], this.m_vectorTrans[n9][n].m_data[1], this.m_vectorTrans[n9][n].m_data[2], this.m_bShowVectorArrow[n9], color, false);
                }
                ++n9;
            }
        }
        if (!(this.m_bShowVertices || bl2 || bl3 || bl4 || bl)) {
            return;
        }
        color = this.getVertexColor(n, bl2, bl3, bl4, bl);
        if (n2 != 0) {
            color = this.attenuateColor(color, this.m_lightAttMat, this.m_lightAttSpec);
        }
        if (n6 > 0) {
            if (this.m_bEnableZBuffer) {
                this.m_outCol = bl ? Color.cyan.getRGB() : -16777216;
                this.writeCircle(n3, n4, d, color.getRGB(), n5);
            } else {
                graphics.setColor(color);
                if (n7 > 2) {
                    graphics.fillOval(n3 - n6, n4 - n6, n7, n7);
                } else {
                    graphics.fillRect(n3 - n6, n4 - n6, n7, n7);
                }
                if (this.m_bShowVertexOutline) {
                    if (bl) {
                        graphics.setColor(Color.cyan);
                    } else {
                        graphics.setColor(Color.black);
                    }
                    graphics.drawOval(n3 - n6, n4 - n6, n7, n7);
                }
            }
        }
        if (bl2 || bl || this.m_bShowIndices || this.m_bShowVertexLabels) {
            String string = pdVector.getName();
            if (string == null && (bl2 || this.m_bEnabledIndexLabels)) {
                string = String.valueOf(n);
            }
            if (string != null) {
                if (bl2 || bl3) {
                    n5 = 0x3FFFFFFF;
                }
                this.drawString(graphics, string, n3, n4, n5, (int)((double)n6 * 0.8) + 1, 0);
            }
        }
    }

    private Color getVertexColor(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Color color = this.m_globalVertexColor;
        if (bl4 && (bl || bl2)) {
            color = Color.cyan;
        } else if (bl || bl2) {
            color = this.m_globalVertexTagColor;
        } else if (bl3) {
            color = this.m_globalVertexTagColor;
        } else if (this.m_bShowVertices) {
            if (this.m_bShowVertexColors && this.m_vertexColor != null) {
                color = this.m_vertexColor[n];
            }
            if (this.m_bShowDepthcue) {
                color = PdColor.getDimmedColor(color, (int)(255.0f * this.m_heightFac));
            }
        } else {
            color = this.m_globalVertexColor;
        }
        return color;
    }

    public void setTransparency(double d) {
        this.m_alpha = Math.abs(1.0 - d) < 0.02 ? 0 : (Math.abs(d) < 0.02 ? m_alphaOpaque : (255 - (int)(255.0 * d) & 0xFF) << 24);
        this.m_transparencyOrig = this.m_transparency = (int)(255.0 * d);
        this.m_alpha = m_alphaOpaque;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.m_geometry != null && this.m_geometry.isVisible() != bl) {
            this.m_geometry.setVisible(bl);
        }
    }

    private Color getElementColor(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Color color = null;
        if (bl4) {
            color = Color.cyan;
        } else if (bl || bl2) {
            color = this.m_globalElementTagColor;
        } else if (bl3) {
            color = this.m_globalElementTagColor;
        }
        if (color != null) {
            return color;
        }
        int n3 = n2 != -1 ? this.m_element[n].m_data[n2] : -1;
        color = this.m_bIsBackface && (this.m_bShowElementBackColor || this.m_bShowElementBackColors) ? (this.m_bShowElementBackColors ? this.m_elementBackColor[n] : this.m_globalElementBackColor) : (this.m_bShowElementColors && this.m_bInduceElementFromVertexColors ? (n3 != -1 ? this.m_vertexColor[n3] : this.getElementCenterColor(this.m_element[n].m_data)) : (this.m_vertexColorFromElement != null && n3 != -1 && (!this.m_bHasCreaseEdge || !this.m_bCreaseEdge[n3]) ? this.m_vertexColorFromElement[n3] : (this.m_bShowElementColors ? this.m_elementColor[n] : this.m_globalElementColor)));
        return color;
    }

    private int clipElement(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, PdVector[] pdVectorArray, PdVector[] pdVectorArray2, int[][] nArray5, int[][] nArray6, float[][] fArray, float[][] fArray2) {
        int n3 = -2;
        int n4 = -1;
        int n5 = 1;
        float[] fArray3 = null;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n2) {
            block33: {
                int n8;
                int n9;
                int[] nArray7;
                int[] nArray8;
                int n10;
                int n11;
                block34: {
                    n11 = n7;
                    n10 = (n7 + 1) % n2;
                    int n12 = this.m_element[n].m_data[n11];
                    int n13 = this.m_element[n].m_data[n10];
                    nArray8 = this.m_vertexTrans[n12].m_data;
                    nArray7 = this.m_vertexTrans[n13].m_data;
                    n9 = n5;
                    n8 = n5;
                    if ((double)nArray8[2] < this.m_clipFar) {
                        n9 = n3;
                    }
                    if ((double)nArray8[2] > this.m_clipNear) {
                        n9 = n4;
                    }
                    if ((double)nArray7[2] < this.m_clipFar) {
                        n8 = n3;
                    }
                    if ((double)nArray7[2] > this.m_clipNear) {
                        n8 = n4;
                    }
                    if (n9 != n5 || n8 != n5) {
                        this.m_bElemIsClipped = true;
                    }
                    if (n9 == n3 && n8 == n3 || n9 == n4 && n8 == n4) break block33;
                    if (n9 != n5) break block34;
                    if (n7 < n2) {
                        int n14;
                        nArray[n6] = nArray8[0];
                        nArray2[n6] = nArray8[1];
                        nArray3[n6] = nArray8[2];
                        if (this.m_bShowTexture) {
                            pdVectorArray[n6].copyArray(pdVectorArray2[n7]);
                        }
                        if (nArray6 != null && nArray5 != null) {
                            n14 = 0;
                            do {
                                nArray5[n6][n14] = nArray6[n7][n14];
                            } while (++n14 < 3);
                        }
                        if (fArray2 != null && fArray != null) {
                            n14 = 0;
                            do {
                                fArray[n6][n14] = fArray2[n7][n14];
                            } while (++n14 < 6);
                        }
                        nArray4[n6] = n12;
                        ++n6;
                    }
                    if (n8 == n5) break block33;
                }
                if (fArray3 == null) {
                    fArray3 = new float[2];
                }
                float f = nArray8[0];
                float f2 = nArray8[1];
                float f3 = nArray8[2];
                float f4 = nArray7[0];
                float f5 = nArray7[1];
                float f6 = nArray7[2];
                PdVector pdVector = null;
                PdVector pdVector2 = null;
                if (this.m_bShowTexture) {
                    pdVector = pdVectorArray2[n11];
                    pdVector2 = pdVectorArray2[n10];
                }
                int[] nArray9 = null;
                int[] nArray10 = null;
                if (nArray6 != null) {
                    nArray9 = nArray6[n11];
                    nArray10 = nArray6[n10];
                }
                float[] fArray4 = null;
                float[] fArray5 = null;
                if (fArray2 != null) {
                    fArray4 = fArray2[n11];
                    fArray5 = fArray2[n10];
                }
                int n15 = 1;
                if (n9 == n5 && n8 == n3 || n9 == n3 && n8 == n5) {
                    fArray3[0] = (float)(((double)f3 - this.m_clipFar) / (double)(f3 - f6));
                } else if (n9 == n5 && n8 == n4 || n9 == n4 && n8 == n5) {
                    fArray3[0] = (float)(((double)f3 - this.m_clipNear) / (double)(f3 - f6));
                } else if (n9 == n3 && n8 == n4) {
                    fArray3[0] = (float)(((double)f3 - this.m_clipFar) / (double)(f3 - f6));
                    fArray3[1] = (float)(((double)f3 - this.m_clipNear) / (double)(f3 - f6));
                    n15 = 2;
                } else if (n9 == n4 && n8 == n3) {
                    fArray3[0] = (float)(((double)f3 - this.m_clipNear) / (double)(f3 - f6));
                    fArray3[1] = (float)(((double)f3 - this.m_clipFar) / (double)(f3 - f6));
                    n15 = 2;
                }
                int n16 = 0;
                while (n16 < n15) {
                    int n17;
                    nArray[n6] = (int)((1.0f - fArray3[n16]) * f + fArray3[n16] * f4);
                    nArray2[n6] = (int)((1.0f - fArray3[n16]) * f2 + fArray3[n16] * f5);
                    nArray3[n6] = (int)((1.0f - fArray3[n16]) * f3 + fArray3[n16] * f6);
                    if (this.m_bShowTexture) {
                        pdVectorArray[n6].m_data[0] = (double)(1.0f - fArray3[n16]) * pdVector.m_data[0] + (double)fArray3[n16] * pdVector2.m_data[0];
                        pdVectorArray[n6].m_data[1] = (double)(1.0f - fArray3[n16]) * pdVector.m_data[1] + (double)fArray3[n16] * pdVector2.m_data[1];
                        if (pdVector.m_data.length > 2) {
                            pdVectorArray[n6].m_data[2] = (double)(1.0f - fArray3[n16]) * pdVector.m_data[2] + (double)fArray3[n16] * pdVector2.m_data[2];
                        }
                    }
                    if (nArray6 != null && nArray5 != null) {
                        n17 = 0;
                        do {
                            nArray5[n6][n17] = (int)((1.0f - fArray3[n16]) * (float)nArray9[n17] + fArray3[n16] * (float)nArray10[n17]);
                        } while (++n17 < 3);
                    }
                    if (fArray2 != null && fArray != null) {
                        n17 = 0;
                        do {
                            fArray[n6][n17] = (1.0f - fArray3[n16]) * fArray4[n17] + fArray3[n16] * fArray5[n17];
                        } while (++n17 < 6);
                    }
                    nArray4[n6] = -1;
                    ++n6;
                    ++n16;
                }
            }
            ++n7;
        }
        n2 = n6;
        return n2;
    }

    protected int addGeometryElement(PiVector piVector) {
        int n = piVector.getSize();
        int n2 = -1;
        switch (this.getType()) {
            case 33: {
                if (n < 3) break;
                this.setNumElements(this.m_numElements + 1);
                this.setElement(this.m_numElements - 1, piVector);
                n2 = this.m_geometry.addElement(piVector);
                break;
            }
            case 32: {
                if (n < 2) break;
                this.addPolygon(piVector);
                n2 = this.m_geometry.addPolygon(piVector);
            }
        }
        this.m_geometry.update(this.m_geometry);
        return n2;
    }

    private void writePixel(int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (n < 0 || n >= this.m_imgWidth || n2 < 0 || n2 >= this.m_zBuffer.length - 1) {
            return;
        }
        if (this.m_bEnable3DLook && this.cSize > 2 && this.m_camUp3D != null) {
            n6 = n - this.cx;
            int n7 = -(n2 - this.cy);
            int n8 = 1 + n3;
            if (this.m_bShowLighting && this.m_light != null && this.m_currVertex != null && this.m_dim == 3) {
                int n9 = 0;
                while (n9 < this.m_dim) {
                    this.m_sphNormal.m_data[n9] = ((double)n6 * this.m_camHor3D.m_data[n9] + (double)n7 * this.m_camUp3D.m_data[n9] - (double)n8 * this.m_camView3D.m_data[n9]) / (double)this.cSize;
                    ++n9;
                }
                this.renderLight(this.m_currVertex, this.m_sphNormal, this.m_light);
                n5 = this.attenuateColor(n5, this.m_lightAttMat, this.m_lightAttSpec);
            } else {
                n5 = PdColor.getDimmedColor(n5, n8 * 255 / this.cSize);
            }
            n4 += n8 * this.m_z3DLookFac;
        }
        n6 = n2 * this.m_imgWidth + n;
        if (this.m_zBuffer[n2][n] >= n4 - this.m_zTolVertex) {
            if (this.m_bShowTransparency) {
                this.m_pixData[n6] = this.drawPixel(this.m_pixData[n6], n5, this.m_transparency, this.m_alpha, false, n, n2);
            }
            return;
        }
        if (this.m_bShowTransparency) {
            n5 = this.drawPixel(this.m_pixData[n6], n5, this.m_transparency, this.m_alpha, true, n, n2);
        }
        this.m_pixData[n6] = n5;
        this.m_zBuffer[n2][n] = n4 - this.m_zTolVertex;
    }

    private void drawElementNormal(Graphics graphics, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) {
        this.getElementCenter(this.m_elemCenterTrans, this.m_element[n].m_data, this.m_vertexTrans, this.m_dimTrans);
        Color color = this.m_bShowDepthcue ? PdColor.getDimmedColor(this.m_globalElementNormalColor, (int)(255.0f * this.m_heightFac)) : this.m_globalElementNormalColor;
        this.drawVectorAny(graphics, this.m_globalElementNormalSize * (double)this.m_offFac, this.m_elemCenterTrans.m_data[0], this.m_elemCenterTrans.m_data[1], this.m_elemCenterTrans.m_data[2], this.m_elementNormalTrans[n].m_data[0], this.m_elementNormalTrans[n].m_data[1], this.m_elementNormalTrans[n].m_data[2], this.m_bShowElementNormalArrow, color, true);
    }

    protected void clearImageString(Color color) {
        if (this.m_gImageString == null) {
            return;
        }
        this.m_gImageString.setColor(Color.white);
        this.m_gImageString.fillRect(0, 0, this.m_widthString, this.m_heightString);
        this.m_gImageString.setColor(color);
    }

    private void writePixel(int n, int n2, int n3, float f) {
        int n4;
        boolean bl;
        if (n2 < 0 || n2 >= this.m_zBuffer.length - 1 || n < 0 || n >= this.m_zBuffer[0].length) {
            return;
        }
        boolean bl2 = bl = (int)f - this.m_zTol > this.m_zBuffer[n2][n];
        if (!bl && !this.m_bShowTransparency) {
            return;
        }
        int n5 = n3;
        if (this.m_bShowDepthcue && this.m_bDepthcueEdge) {
            int n6;
            if (this.m_bUse_m_heightFac) {
                n4 = (int)(255.0f * this.m_heightFac);
            } else {
                n4 = (int)(255.0f * (f - (float)this.m_scene.m_zMin));
                n6 = this.m_scene.m_zMax - this.m_scene.m_zMin;
                if (n6 != 0) {
                    n4 /= n6;
                }
                if (n4 < 0) {
                    n4 = 0;
                } else if (n4 > 255) {
                    n4 = 255;
                }
            }
            n6 = (n5 >> 16 & 0xFF) * n4;
            int n7 = (n5 >> 8 & 0xFF) * n4;
            int n8 = (n5 & 0xFF) * n4;
            int n9 = this.m_grey * (255 - n4) >> 8 & 0xFF;
            n6 += n9;
            n7 += n9;
            n8 += n9;
            n6 = n6 << 8 & 0xFF0000;
            n8 = n8 >> 8 & 0xFF;
            n5 = n6 | (n7 &= 0xFF00) | n8;
        }
        n5 = this.m_alpha | n5;
        if (this.m_bShowTransparency) {
            n5 = this.drawPixel(this.m_pixData[n2 * this.m_imgWidth + n], n5, this.m_transparency, this.m_alpha, bl, n, n2);
        }
        this.m_pixData[n2 * this.m_imgWidth + n] = n5;
        n4 = (int)f - this.m_zTol;
        if (this.m_zBuffer[n2][n] < n4) {
            this.m_zBuffer[n2][n] = n4;
        }
    }

    protected int updateUnusedVertices() {
        int n;
        if (this.m_numVertices == 0) {
            return 0;
        }
        int n2 = -1;
        this.m_unusedVertex.setSize(this.m_numVertices);
        this.m_unusedVertex.setConstant(0);
        int[] nArray = this.m_unusedVertex.m_data;
        int n3 = 0;
        while (n3 < this.m_numElements) {
            n = this.m_element[n3].m_data.length - 1;
            while (n >= 0) {
                nArray[this.m_element[n3].m_data[n]] = n2;
                --n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.m_numPolygons) {
            n = this.m_polygon[n3].m_data.length - 1;
            while (n >= 0) {
                nArray[this.m_polygon[n3].m_data[n]] = n2;
                --n;
            }
            ++n3;
        }
        int n4 = 0;
        n3 = 0;
        while (n3 < this.m_numVertices) {
            if (nArray[n3] != n2) {
                nArray[n4++] = n3;
            }
            ++n3;
        }
        this.m_numUnusedVertices = n4;
        return this.m_numUnusedVertices;
    }

    private void drawVectorAny(Graphics graphics, double d, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, Color color, boolean bl2) {
        int n7;
        boolean bl3;
        boolean bl4 = this.m_bShowSmoothShading;
        boolean bl5 = this.m_bShowDepthcue;
        this.m_bShowSmoothShading = false;
        this.m_bShowDepthcue = false;
        if (this.m_bAdaptiveSize) {
            float f = this.getAdaptiveScale(n3);
            if ((double)f < 0.0) {
                return;
            }
            d *= (double)f;
        }
        boolean bl6 = bl3 = (n7 = (int)(d + 0.5)) > 3 * this.m_offFac;
        if (this.m_bEnable3DLook && bl) {
            bl3 = false;
        }
        int n8 = this.m_zTolLine;
        this.m_zTolLine = bl2 ? -3 * this.m_zTolLine : 3 * this.m_zTolLine;
        this.drawLineAny(graphics, n7, n, n2, n3, n4, n5, n6, color, color, bl3);
        if (bl) {
            this.drawVectorTipAny(graphics, n7, n, n2, n3, n4, n5, n6, true, color);
        }
        this.m_zTolLine = n8;
        this.m_bShowDepthcue = bl5;
        this.m_bShowSmoothShading = bl4;
    }

    private short[][] createHeightArr(int n) {
        int n2;
        short[][] sArray = new short[n][n];
        int n3 = 0;
        while (n3 < n) {
            n2 = 0;
            while (n2 < n) {
                sArray[n3][n2] = -1;
                ++n2;
            }
            ++n3;
        }
        n3 = n;
        n2 = (n3 - 1) * (n3 - 1);
        int n4 = n3 - 1;
        int n5 = 0;
        int n6 = 1 - n4;
        if (this.m_bShowVertexOutline) {
            sArray[0][n - 1] = 0;
            sArray[n - 1][0] = 0;
        }
        int n7 = 0;
        while (n7 < n3) {
            sArray[n7][0] = (short)(Math.sqrt(n2 - n7 * n7) + 0.5);
            ++n7;
        }
        while (n4 > n5 + 1) {
            if (n6 < 0) {
                n6 += 2 * n5 + 3;
                ++n5;
                n7 = 0;
                while (n7 < n4) {
                    sArray[n7][n5] = (short)(Math.sqrt(n2 - n5 * n5 - n7 * n7) + 0.5);
                    ++n7;
                }
            } else {
                n6 += 2 * (n5 - n4) + 5;
                ++n5;
                --n4;
                n7 = 0;
                while (n7 < n4) {
                    sArray[n7][n5] = (short)(Math.sqrt(n2 - n5 * n5 - n7 * n7) + 0.5);
                    ++n7;
                }
                if (n5 < n4) {
                    n7 = 0;
                    while (n7 < n5) {
                        sArray[n7][n4] = (short)(Math.sqrt(n2 - n4 * n4 - n7 * n7) + 0.5);
                        ++n7;
                    }
                }
            }
            if (!this.m_bShowVertexOutline) continue;
            sArray[n5][n4] = 0;
            sArray[n4][n5] = 0;
        }
        return sArray;
    }

    protected void setOffFac(int n) {
        if (this.m_offFac == n * PS_ZOOM) {
            return;
        }
        this.m_offFac = n * PS_ZOOM;
        if (this.m_imageString != null) {
            this.m_widthString = n * this.m_defWidthString;
            this.m_heightString = n * this.m_defHeightString;
            this.createImageString();
        }
    }

    public void setStateFromDisplay(int n, boolean bl) {
        if (this.m_geometry == null) {
            return;
        }
        switch (n) {
            default: {
                PsDebug.warning("invalid key = " + n);
            }
            case 50: 
        }
        this.setState(n, bl);
        this.m_geometry.setState(n, bl);
    }

    private Color getEdgeColor_(int n, int n2) {
        Color color = null;
        if (this.m_bShowTaggedEdges && this.m_bHasTaggedEdges && this.m_element[n].hasTag(1)) {
            color = this.m_globalEdgeTagColor;
            return color;
        }
        color = this.m_bShowEdgeColors && this.m_bShowEdgeColorFromElements ? this.m_elementColor[n] : (this.m_bShowEdgeColors && !this.m_bShowEdgeColorFromElements && this.m_vertexColor != null && n2 != -1 ? this.m_vertexColor[n2] : this.m_globalEdgeColor);
        if (this.m_bShowDepthcue && this.m_bShowEdgeColors && !this.m_bEnableZBuffer) {
            color = this.m_bEnable3DLook || this.m_bShowElements ? PdColor.getDimmedColor(color, (double)this.m_heightFac, (double)this.m_heightFac) : PdColor.getDimmedColor(color, (double)this.m_heightFac, (double)this.m_grey * (1.0 - (double)this.m_heightFac));
        }
        return color;
    }

    protected void setMaxSizeElements(int n) {
        this.m_maxSizeOfElements = n;
        this.m_xv = new int[this.m_maxSizeOfElements];
        this.m_yv = new int[this.m_maxSizeOfElements];
        this.m_zv = new int[this.m_maxSizeOfElements];
        this.cvTmp = new int[this.m_maxSizeOfElements][];
        this.m_elemSub = new int[this.m_maxSizeOfElements][3];
        this.m_indVec = new int[this.m_maxSizeOfElements];
        this.m_angleArr = new double[this.m_maxSizeOfElements];
        this.assureClip(this.m_bEnableClip);
        boolean bl = this.m_bShowLighting;
        this.setEnabledLighting(false);
        this.setEnabledLighting(bl);
        this.assureTexture(this.m_texCoord != null);
        this.m_vd = PdVector.realloc(null, this.m_maxSizeOfElements, this.m_dimTrans);
        this.m_cv = new int[this.m_maxSizeOfElements][3];
        this.m_origInd = new int[this.m_maxSizeOfElements];
        this.m_tex = PdVector.realloc(null, this.m_maxSizeOfElements, 2);
    }

    protected void untagElements(Rectangle rectangle) {
        int n = this.getNumElements();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.m_element[n2].hasTag(1)) {
                int n3 = this.m_element[n2].getSize();
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = this.m_element[n2].m_data[n4];
                    if (rectangle.contains(this.m_vertexTrans[n5].m_data[0], this.m_vertexTrans[n5].m_data[1])) {
                        this.m_element[n2].clearTag(1);
                        this.m_geometry.clearTagElement(n2, 1);
                        this.m_element[n2].clearTag(12);
                        this.m_geometry.clearTagElement(n2, 12);
                        this.m_element[n2].clearTag(11);
                        this.m_geometry.clearTagElement(n2, 11);
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public boolean hasTagPolygon(int n, int n2) {
        return this.m_polygon[n].hasTag(n2);
    }

    public int addPolygon(PiVector piVector) {
        this.setNumPolygons(this.m_numPolygons + 1);
        this.setPolygon(this.m_numPolygons - 1, piVector);
        this.computeNumPolygonEdges();
        return this.m_numPolygons - 1;
    }

    protected void setEnabledClipBounds(boolean bl) {
        if (this.m_bEnableClipBounds == bl) {
            return;
        }
        this.m_bEnableClipBounds = bl;
        this.assureClip(this.m_bEnableClipBounds || this.m_bEnableClipCamera);
        if (!bl) {
            this.m_clipBounds = null;
            this.m_tPos = null;
            return;
        }
        this.m_clipBounds = PdVector.realloc(null, 2, this.m_dimTrans);
        this.m_tPos = new double[2];
    }

    private void drawScanline(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, double[] dArray, double[] dArray2, int n7, int n8) {
        int n9;
        int n10;
        float f;
        int n11 = 0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        if (this.m_bShowTexture) {
            f12 = (float)dArray[2];
            f13 = (float)dArray2[2];
        } else {
            f12 = 0.2f + 0.8f * (float)(n3 - this.m_scene.m_zMin) / (float)(this.m_scene.m_zMax - this.m_scene.m_zMin);
            f13 = 0.2f + 0.8f * (float)(n6 - this.m_scene.m_zMin) / (float)(this.m_scene.m_zMax - this.m_scene.m_zMin);
        }
        int n12 = n4 - n;
        int n13 = 0;
        int n14 = n2;
        if (n14 < 0 || n14 >= this.m_imgHeight) {
            return;
        }
        int n15 = n2 * this.m_imgWidth;
        if (n12 >= 0) {
            n15 += n;
            if (this.m_bShowTexture) {
                f3 = (float)dArray[0];
                f4 = (float)dArray[1];
            }
            f5 = f12;
            f = (float)n3 + 0.5f;
            n13 = n;
            if (this.m_bShowSmoothShading) {
                n10 = 0;
                do {
                    this.cd[n10] = fArray[n10];
                } while (++n10 < 3);
            }
            if (this.m_bShowSmoothLighting) {
                n10 = 0;
                do {
                    this.lad[n10] = fArray3[n10];
                } while (++n10 < 6);
            }
        } else {
            n15 += n4;
            if (this.m_bShowTexture) {
                f3 = (float)dArray2[0];
                f4 = (float)dArray2[1];
            }
            f5 = f13;
            f = (float)n6 + 0.5f;
            n13 = n4;
            n10 = n7;
            n7 = n8;
            n8 = n10;
            if (this.m_bShowSmoothShading) {
                n9 = 0;
                do {
                    this.cd[n9] = fArray2[n9];
                } while (++n9 < 3);
            }
            if (this.m_bShowSmoothLighting) {
                n9 = 0;
                do {
                    this.lad[n9] = fArray4[n9];
                } while (++n9 < 6);
            }
        }
        if (n12 != 0) {
            if (this.m_bShowTexture) {
                f6 = (float)(dArray2[0] - dArray[0]) / (float)n12;
                f7 = (float)(dArray2[1] - dArray[1]) / (float)n12;
            }
            f8 = (f13 - f12) / (float)n12;
            f2 = (float)(n6 - n3) / (float)n12;
            if (this.m_bShowSmoothShading) {
                n10 = 0;
                do {
                    this.cd_inc[n10] = (fArray2[n10] - fArray[n10]) / (float)n12;
                } while (++n10 < 3);
            }
            if (this.m_bShowSmoothLighting) {
                n10 = 0;
                do {
                    this.lad_inc[n10] = (fArray4[n10] - fArray3[n10]) / (float)n12;
                } while (++n10 < 6);
            }
            if (n12 < 0) {
                n12 = -n12;
            }
        } else {
            if (this.m_bShowSmoothShading) {
                n10 = 0;
                do {
                    this.cd_inc[n10] = 0.0f;
                } while (++n10 < 3);
            }
            if (this.m_bShowSmoothLighting) {
                n10 = 0;
                do {
                    this.lad_inc[n10] = 0.0f;
                } while (++n10 < 6);
            }
        }
        if (this.m_bShowTexture && this.m_filterType != 0) {
            f9 = f6 / 2.0f;
            f10 = f7 / 2.0f;
            f11 = f8 / 2.0f;
        }
        n12 += n8;
        if (n7 > 0) {
            n10 = 0;
            while (n10 < n7) {
                ++n15;
                ++n13;
                if (this.m_bShowTexture) {
                    f3 += f6;
                    f4 += f7;
                }
                f5 += f8;
                f += f2;
                if (this.m_bShowSmoothShading) {
                    n9 = 0;
                    do {
                        int n16 = n9;
                        this.cd[n16] = this.cd[n16] + this.cd_inc[n9];
                    } while (++n9 < 3);
                }
                if (this.m_bShowSmoothLighting) {
                    n9 = 0;
                    do {
                        int n17 = n9;
                        this.lad[n17] = this.lad[n17] + this.lad_inc[n9];
                    } while (++n9 < 6);
                }
                --n12;
                ++n10;
            }
        }
        int n18 = 0;
        while (n12 >= 0) {
            int n19;
            int n20 = (int)f;
            boolean bl = true;
            if (this.m_bShowTransparency && n13 >= 0 && n13 < this.m_imgWidth) {
                boolean bl2 = bl = this.m_zBuffer == null || this.m_zBuffer[n14][n13] < n20 - this.m_zTol;
            }
            if (n13 >= 0 && n13 < this.m_imgWidth) {
                if (!this.m_bShowTransparency && this.m_zBuffer != null && this.m_zBuffer[n14][n13] >= n20 - this.m_zTol) {
                    if ((this.m_pixData[n15] & 0xFF000000) == m_colMark) {
                        this.m_pixData[n15] = this.m_bShowCurrEdge && this.m_bShowTransparency && this.m_zBuffer[n14][n13] < n20 + this.m_zTol ? this.drawPixel(this.m_pixData[n15], this.m_currEdgeCol, this.m_transparency, this.m_alpha, false, n13, n14) : this.m_alpha | this.m_pixData[n15] & 0xFFFFFF;
                    }
                } else if (this.m_bShowTransparency && !this.m_bShowCurrEdge && this.m_zBuffer[n14][n13] > n20 - this.m_zTol && this.m_zBuffer[n14][n13] < n20 + this.m_zTol && (this.m_pixData[n15] & 0xFF000000) == m_colMark) {
                    this.m_pixData[n15] = this.m_alpha | this.m_pixData[n15] & 0xFFFFFF;
                } else {
                    if (this.m_zBuffer != null && this.m_zBuffer[n14][n13] < n20 - this.m_zTol) {
                        this.m_zBuffer[n14][n13] = n20;
                    }
                    n19 = this.m_transparency;
                    if (this.m_bShowCurrEdge && (this.m_pixData[n15] & 0xFF000000) == m_colMark) {
                        this.m_pixData[n15] = this.m_bShowTransparency ? this.drawPixel(this.m_pixData[n15], this.m_currEdgeCol, this.m_transparency, this.m_alpha, bl, n13, n14) : this.m_currEdgeCol;
                    } else if (this.m_bShowCurrElement && this.m_bFastScanline && n18 > 0 && n12 > 0) {
                        --n18;
                        this.m_pixData[n15] = this.m_pixData[n15 - 1];
                    } else if (this.m_bShowCurrElement) {
                        int n21;
                        int n22;
                        int n23;
                        int n24;
                        if (this.m_bFastScanline) {
                            n18 = n12 - 2;
                        }
                        if (this.m_bIsTaggedElement) {
                            n11 = this.m_currElementCol;
                        } else if (this.m_bShowTexture && !this.m_bDrawingEdge) {
                            if (f3 < 0.0f && this.m_textureWidth > 0) {
                                while (f3 < 0.0f) {
                                    f3 += (float)this.m_textureWidth;
                                }
                            }
                            if (f3 >= (float)this.m_textureWidth) {
                                f3 %= (float)this.m_textureWidth;
                            }
                            if (f4 < 0.0f && this.m_textureHeight > 0) {
                                while (f4 < 0.0f) {
                                    f4 += (float)this.m_textureHeight;
                                }
                            }
                            if (f4 >= (float)this.m_textureHeight) {
                                f4 %= (float)this.m_textureHeight;
                            }
                            if ((n24 = (this.m_textureHeight - (int)f4 - 1) * this.m_textureWidth + (int)f3) >= 0 && n24 < this.m_texturePix.length) {
                                n11 = this.m_filterType != 0 ? this.getTexStencil(this.m_texturePix, n24, f3, f4, f5, f9, f10, f11) : this.m_texturePix[n24];
                                if (this.m_blendingMode == 0) {
                                    n10 = n11 >> 24 & 0xFF;
                                    if (n10 != 255) {
                                        n19 = this.m_bShowTransparency ? ((255 - n10) * 255 + n19 * n10) / 255 : 255 - n10;
                                    }
                                } else if (this.m_blendingMode == 1) {
                                    n10 = n11 >> 24 & 0xFF;
                                    if (n10 != 255) {
                                        n23 = this.m_bShowSmoothShading ? (int)this.cd[0] << 16 | (int)this.cd[1] << 8 | (int)this.cd[2] : this.m_currElementCol;
                                        n11 = this.drawPixel(n23, n11, 255 - n10, this.m_alpha, bl, n13, n14);
                                    }
                                } else if (this.m_blendingMode == 2) {
                                    n23 = this.m_bShowSmoothShading ? (int)this.cd[0] << 16 | (int)this.cd[1] << 8 | (int)this.cd[2] : this.m_currElementCol;
                                    n10 = n11 & 0xFF;
                                    if (n10 != 255) {
                                        if (this.m_bShowTransparency) {
                                            n10 = n10 <= n19 ? 0 : 255 * (n10 - n19) / (255 - n19);
                                            n19 = 255 - n10;
                                        } else {
                                            n19 = 255 - n10;
                                        }
                                    }
                                    n11 = n10 << 24 | n23 & 0xFFFFFF;
                                }
                            } else {
                                n11 = this.m_currElementCol;
                            }
                        } else {
                            n11 = this.m_bShowSmoothShading ? 0xFF000000 | (int)this.cd[0] << 16 | (int)this.cd[1] << 8 | (int)this.cd[2] : this.m_currElementCol;
                        }
                        n10 = n11 & 0xFF000000;
                        if (this.m_bShowSmoothLighting) {
                            n9 = (int)((float)(n11 >> 16 & 0xFF) * this.lad[0] + this.lad[3]);
                            n22 = (int)((float)(n11 >> 8 & 0xFF) * this.lad[1] + this.lad[4]);
                            n21 = (int)((float)(n11 & 0xFF) * this.lad[2] + this.lad[5]);
                            if (n9 > 255) {
                                n9 = 255;
                            }
                            if (n22 > 255) {
                                n22 = 255;
                            }
                            if (n21 > 255) {
                                n21 = 255;
                            }
                            n11 = n10 | n9 << 16 | n22 << 8 | n21;
                        } else if (this.m_bShowLighting) {
                            n9 = (int)((float)(n11 >> 16 & 0xFF) * this.m_lightAttMat[0] + this.m_lightAttSpec[0]);
                            n22 = (int)((float)(n11 >> 8 & 0xFF) * this.m_lightAttMat[1] + this.m_lightAttSpec[1]);
                            n21 = (int)((float)(n11 & 0xFF) * this.m_lightAttMat[2] + this.m_lightAttSpec[2]);
                            if (n9 > 255) {
                                n9 = 255;
                            }
                            if (n22 > 255) {
                                n22 = 255;
                            }
                            if (n21 > 255) {
                                n21 = 255;
                            }
                            n11 = n10 | n9 << 16 | n22 << 8 | n21;
                        }
                        if (this.m_bShowDepthcue && (!this.m_bDrawingEdge || this.m_bDepthcueEdge)) {
                            n24 = f5 < 0.0f ? 0 : (f5 > 1.0f ? 255 : (int)(f5 * 255.0f));
                            n9 = (n11 >> 16 & 0xFF) * n24;
                            n22 = (n11 >> 8 & 0xFF) * n24;
                            n21 = (n11 & 0xFF) * n24;
                            if (this.m_bDrawingEdge && this.m_bDepthcueEdge) {
                                n23 = this.m_grey * (255 - n24);
                                n9 += n23;
                                n22 += n23;
                                n21 += n23;
                            }
                            n9 = n9 << 8 & 0xFF0000;
                            n21 = n21 >> 8 & 0xFF;
                            n11 = n10 | n9 | (n22 &= 0xFF00) | n21;
                        }
                        if (n10 != 0) {
                            if (this.m_bShowTransparency) {
                                n11 = this.drawPixel(this.m_pixData[n15], n11, n19, this.m_alpha, bl, n13, n14);
                            } else if (n10 != -16777216) {
                                n11 = this.drawPixel(this.m_pixData[n15], n11, n19, this.m_alpha, bl, n13, n14);
                            }
                            this.m_pixData[n15] = n11;
                        }
                    } else if ((this.m_pixData[n15] & 0xFF000000) == m_colMark) {
                        this.m_pixData[n15] = this.m_alpha | this.m_pixData[n15] & 0xFFFFFF;
                    }
                }
            }
            ++n15;
            ++n13;
            if (this.m_bShowTexture) {
                f3 += f6;
                f4 += f7;
            }
            f5 += f8;
            f += f2;
            if (this.m_bShowSmoothShading) {
                n19 = 0;
                do {
                    int n25 = n19;
                    this.cd[n25] = this.cd[n25] + this.cd_inc[n19];
                } while (++n19 < 3);
            }
            if (this.m_bShowSmoothLighting) {
                n19 = 0;
                do {
                    int n26 = n19;
                    this.lad[n26] = this.lad[n26] + this.lad_inc[n19];
                } while (++n19 < 6);
            }
            --n12;
        }
    }

    protected int getZMin() {
        return this.m_zMin;
    }

    private void drawElementBnd(Graphics graphics, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) {
        int n3;
        if (!this.m_bHasNeighbours || this.m_neighbour[n].m_data.length < n2 || this.m_bEnableClip && this.m_bElemIsClipped) {
            return;
        }
        if (this.m_bShowSmoothShading) {
            n3 = 0;
            while (n3 < n2) {
                this.cvTmp[n3] = this.m_cv[n3];
                ++n3;
            }
        }
        n3 = 0;
        while (n3 < n2) {
            block11: {
                double d;
                Color color;
                int n4;
                int n5;
                block12: {
                    if (this.m_neighbour[n].m_data[n3] != -1) break block11;
                    n5 = (n3 + 1) % n2;
                    n4 = (n3 + 2) % n2;
                    color = this.m_globalBndColor;
                    if (this.m_bDepthcueEdge && !this.m_bEnableZBuffer) {
                        color = this.m_bEnable3DLook ? PdColor.getDimmedColor(color, (double)this.m_heightFac, (double)this.m_heightFac) : PdColor.getDimmedColor(color, (double)this.m_heightFac, (double)this.m_grey * (1.0 - (double)this.m_heightFac));
                    }
                    if (this.m_bShowSmoothShading) {
                        int n6 = color.getRGB();
                        this.cvTmpOne[0] = n6 >> 16 & 0xFF;
                        this.cvTmpOne[1] = n6 >> 8 & 0xFF;
                        this.cvTmpOne[2] = n6 & 0xFF;
                        this.m_cv[0] = this.cvTmpOne;
                        this.m_cv[1] = this.cvTmpOne;
                        this.m_cv[2] = this.cvTmpOne;
                        this.m_cv[3] = this.cvTmpOne;
                    }
                    d = this.m_globalBndSize * (double)this.m_offFac;
                    if (!this.m_bAdaptiveSize) break block12;
                    float f = this.getAdaptiveScale((float)(nArray3[n5] + nArray3[n4]) / 2.0f);
                    if ((double)f < 0.0) break block11;
                    d *= (double)f;
                }
                int n7 = (int)(d + 0.5);
                this.drawLineAny(graphics, n7, nArray[n5], nArray2[n5], nArray3[n5], nArray[n4], nArray2[n4], nArray3[n4], color, color, n7 > 3 * this.m_offFac);
            }
            ++n3;
        }
        if (this.m_bShowSmoothShading) {
            n3 = 0;
            while (n3 < n2) {
                this.m_cv[n3] = this.cvTmp[n3];
                ++n3;
            }
        }
    }

    private boolean project(PiVector piVector, PdVector pdVector, PdMatrix pdMatrix) {
        boolean bl = true;
        if (this.m_position == null) {
            int n;
            if (this.m_bIsClippable && this.m_bEnableClipBounds && this.m_clipBounds != null) {
                n = 0;
                do {
                    if (pdVector.m_data[n] < this.m_clipBounds[0].m_data[n]) {
                        pdVector.m_data[n] = this.m_clipBounds[0].m_data[n];
                    }
                    if (!(pdVector.m_data[n] > this.m_clipBounds[1].m_data[n])) continue;
                    pdVector.m_data[n] = this.m_clipBounds[1].m_data[n];
                } while (++n < 3);
            }
            if (this.m_bPerspectivity) {
                double d = pdMatrix.m_data[3][3];
                int n2 = 0;
                do {
                    d += pdMatrix.m_data[3][n2] * pdVector.m_data[n2];
                } while (++n2 < 3);
                if (d < 0.0) {
                    bl = false;
                    d = -d;
                }
                n2 = !(d > 0.001) ? 0 : 1;
                bl = bl && n2 != 0;
                int n3 = 0;
                do {
                    double d2 = pdMatrix.m_data[n3][3];
                    int n4 = 0;
                    do {
                        d2 += pdMatrix.m_data[n3][n4] * pdVector.m_data[n4];
                    } while (++n4 < 3);
                    if (n2 != 0) {
                        if (PS_ZOOM != 1 && n3 < 2) {
                            d2 *= (double)PS_ZOOM;
                        }
                        piVector.m_data[n3] = (int)(d2 / d + 0.3);
                        continue;
                    }
                    piVector.m_data[n3] = (int)(d2 + 0.3);
                } while (++n3 < 3);
                if (!bl) {
                    piVector.m_data[2] = Integer.MIN_VALUE;
                }
            } else {
                n = 0;
                do {
                    double d = pdMatrix.m_data[n][3];
                    int n5 = 0;
                    do {
                        d += pdMatrix.m_data[n][n5] * pdVector.m_data[n5];
                    } while (++n5 < 3);
                    if (PS_ZOOM != 1 && n < 2) {
                        d *= (double)PS_ZOOM;
                    }
                    piVector.m_data[n] = (int)(d + 0.3);
                } while (++n < 3);
            }
        } else {
            double d = PdVector.length(3, this.m_viewMat.m_data[2]);
            int n = this.m_dispSize.width / 10;
            int n6 = this.m_dispSize.height - n;
            double d3 = pdMatrix.m_data[0][3];
            double d4 = pdMatrix.m_data[1][3];
            double d5 = pdMatrix.m_data[0][3];
            int n7 = 0;
            do {
                d5 += pdMatrix.m_data[0][n7] * pdVector.m_data[n7] / d;
            } while (++n7 < 3);
            piVector.m_data[0] = (int)((double)PS_ZOOM * (d5 + (double)n - d3 + 0.3));
            d5 = pdMatrix.m_data[1][3];
            n7 = 0;
            do {
                d5 += pdMatrix.m_data[1][n7] * pdVector.m_data[n7] / d;
            } while (++n7 < 3);
            piVector.m_data[1] = (int)((double)PS_ZOOM * (d5 + (double)n6 - d4 + 0.3));
            d5 = pdMatrix.m_data[2][3];
            n7 = 0;
            do {
                d5 += pdMatrix.m_data[2][n7] * pdVector.m_data[n7] / d;
            } while (++n7 < 3);
            piVector.m_data[2] = (int)(d5 + 0.3);
        }
        return bl;
    }

    private void project(PdVector pdVector, PdVector pdVector2, PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (pdMatrix2 != null) {
            this.vtSrc1.copyArray(pdVector2);
            if (this.m_position == null) {
                this.vtSrc1.m_data[this.m_dim] = 1.0;
                this.vtSrc1.leftMultMatrix(pdMatrix2);
            } else {
                if (this.vtSrc1.getSize() != pdMatrix2.getSize()) {
                    this.vtSrc1.setSize(pdMatrix2.getSize());
                }
                double d = PdVector.length(this.m_dim, pdMatrix2.m_data[0]);
                this.vtSrc1.m_data[this.m_dim] = 0.0;
                this.vtSrc1.leftMultMatrix(pdMatrix2);
                this.vtSrc1.multScalar(1.0 / d);
            }
            this.vtSrc1.m_data[this.m_dim] = 0.0;
        }
        if (this.m_position == null && this.m_ambientProj != 0) {
            if (pdMatrix2 != null) {
                this.vtSrc.copyArray(this.vtSrc1);
            } else {
                this.vtSrc.copyArray(pdVector2);
            }
            if (this.m_ambientSpace == 9 || this.m_ambientSpace == 6 || this.m_ambientSpace == 3 || this.m_ambientSpace == 1 || this.m_ambientSpace == 2 || this.m_ambientSpace == 4 || this.m_ambientSpace == 7 || this.m_ambientSpace == 10) {
                if (this.m_ambientProj == 1) {
                    PuProj.stereographic(this.vtSrc, this.vtSrc);
                } else {
                    PsDebug.warning("unknown projection type");
                }
            } else if (this.m_ambientSpace == 5 || this.m_ambientSpace == 8 || this.m_ambientSpace == 11) {
                if (this.m_ambientProj == 2) {
                    PuProj.lorentz2Klein(this.vtSrc, this.vtSrc);
                } else if (this.m_ambientProj == 1) {
                    PuProj.lorentz2Poincare(this.vtSrc, this.vtSrc);
                } else if (this.m_ambientProj == 3) {
                    PuProj.lorentz2Uhm(this.vtSrc, this.vtSrc);
                } else {
                    PsDebug.warning("unknown projection type");
                }
            } else {
                PsDebug.warning("unknown ambient space");
            }
            this.vtMod1.copyArray(this.vtSrc);
            int n = this.m_dim - 1;
            while (n < this.m_dimTrans) {
                this.vtMod1.m_data[n] = 0.0;
                ++n;
            }
        } else if (pdMatrix2 != null) {
            this.vtMod1.copyArray(this.vtSrc1);
        } else {
            this.vtMod1.copyArray(pdVector2);
        }
        if (pdMatrix != null) {
            this.vtMod1.m_data[this.m_dimTrans] = 1.0;
            if (this.m_position == null) {
                this.vtMod1.leftMultMatrix(pdMatrix);
            } else {
                double d = PdVector.length(this.m_dimTrans, pdMatrix.m_data[this.m_dimTrans - 1]);
                this.vtMod1.m_data[this.m_dimTrans] = 0.0;
                this.vtMod1.leftMultMatrix(pdMatrix);
                this.vtMod1.multScalar(1.0 / d);
            }
        }
        pdVector.copyArray(this.vtMod1);
    }

    private int discretizeBndEdge(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, float[][] fArray, float[] fArray2, float[] fArray3, float[][] fArray4, PdVector pdVector, PdVector pdVector2, PdVector[] pdVectorArray, PiVector[] piVectorArray, int n7, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n8) {
        boolean bl5;
        int n9;
        int n10 = n7;
        if (n7 >= piVectorArray.length) {
            return -1;
        }
        if (this.m_bShowSmoothShading) {
            n9 = 0;
            do {
                this.cd[n9] = (float)nArray[n9] + 0.5f;
                this.cd_inc[n9] = nArray2[n9] - nArray[n9];
            } while (++n9 < 3);
        }
        if (this.m_bShowSmoothLighting) {
            n9 = 0;
            do {
                this.lad[n9] = fArray2[n9];
                this.lad_inc[n9] = fArray3[n9] - fArray2[n9];
            } while (++n9 < 6);
        }
        int n11 = n4 - n;
        int n12 = n5 - n2;
        float f = n6 - n3;
        int n13 = n;
        int n14 = n2;
        float f2 = n3;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        boolean bl6 = bl5 = pdVector != null;
        if (bl5) {
            f3 = (float)pdVector.m_data[0] + 0.5f;
            f4 = (float)pdVector.m_data[1] + 0.5f;
            f5 = (float)pdVector.m_data[2];
        }
        int n15 = 1;
        int n16 = 1;
        if (n11 < 0) {
            n11 = -n11;
            n15 = -1;
        }
        if (n12 < 0) {
            n12 = -n12;
            n16 = -1;
        }
        int n17 = n11 << 1;
        int n18 = n12 << 1;
        int n19 = this.m_pixData.length;
        int n20 = this.m_bndIdentifier.m_data[0];
        int n21 = 0xFFFFFF;
        if (n11 <= n12) {
            int n22;
            int n23 = n12;
            if (this.m_bShowTexture && n7 + n23 >= pdVectorArray.length) {
                return -1;
            }
            if (n23 == 0) {
                this.m_bndIdentifier.m_data[0] = n20;
                return n7;
            }
            if (bl5) {
                f6 = (float)(pdVector2.m_data[0] - pdVector.m_data[0]) / (float)n23;
                f7 = (float)(pdVector2.m_data[1] - pdVector.m_data[1]) / (float)n23;
                f8 = (float)(pdVector2.m_data[2] - pdVector.m_data[2]) / (float)n23;
            }
            if (this.m_bShowSmoothShading) {
                n22 = 0;
                do {
                    int n24 = n22++;
                    this.cd_inc[n24] = this.cd_inc[n24] / (float)n23;
                } while (n22 < 3);
            }
            if (this.m_bShowSmoothLighting) {
                n22 = 0;
                do {
                    int n25 = n22++;
                    this.lad_inc[n25] = this.lad_inc[n25] / (float)n23;
                } while (n22 < 6);
            }
            f /= (float)n12;
            int n26 = n17 - n12;
            int n27 = n17;
            int n28 = n17 - n18;
            do {
                int n29;
                if (bl5) {
                    pdVectorArray[n7].m_data[0] = f3;
                    pdVectorArray[n7].m_data[1] = f4;
                    pdVectorArray[n7].m_data[2] = f5;
                }
                piVectorArray[n7].m_data[0] = n13;
                piVectorArray[n7].m_data[1] = n14;
                piVectorArray[n7].m_data[2] = (int)f2;
                if (this.m_bShowSmoothShading) {
                    n22 = 0;
                    do {
                        fArray[n7][n22] = this.cd[n22];
                    } while (++n22 < 3);
                }
                if (this.m_bShowSmoothLighting) {
                    n22 = 0;
                    do {
                        fArray4[n7][n22] = this.lad[n22];
                    } while (++n22 < 6);
                }
                if (n13 >= 0 && n13 < this.m_imgWidth && (n29 = n14 * this.m_imgWidth + n13) >= 0 && n29 < n19) {
                    this.m_pixData[n29] = m_colMark | this.m_pixData[n29] & n21;
                    this.m_bndIdentifier.m_data[++n20] = n29;
                }
                if (++n7 >= piVectorArray.length) {
                    return -1;
                }
                if (bl5) {
                    f3 += f6;
                    f4 += f7;
                    f5 += f8;
                }
                n14 += n16;
                f2 += f;
                if (n26 <= 0) {
                    n26 += n27;
                } else {
                    n26 += n28;
                    n13 += n15;
                }
                if (this.m_bShowSmoothShading) {
                    n22 = 0;
                    do {
                        int n30 = n22;
                        this.cd[n30] = this.cd[n30] + this.cd_inc[n22];
                    } while (++n22 < 3);
                }
                if (!this.m_bShowSmoothLighting) continue;
                n22 = 0;
                do {
                    int n31 = n22;
                    this.lad[n31] = this.lad[n31] + this.lad_inc[n22];
                } while (++n22 < 6);
            } while (n14 != n5);
        } else {
            int n32;
            int n33;
            int n34 = n11;
            if (this.m_bShowTexture && n7 + n34 >= pdVectorArray.length) {
                return -1;
            }
            if (n34 == 0) {
                this.m_bndIdentifier.m_data[0] = n20;
                return n7;
            }
            if (bl5) {
                f6 = (float)(pdVector2.m_data[0] - pdVector.m_data[0]) / (float)n34;
                f7 = (float)(pdVector2.m_data[1] - pdVector.m_data[1]) / (float)n34;
                f8 = (float)(pdVector2.m_data[2] - pdVector.m_data[2]) / (float)n34;
            }
            if (this.m_bShowSmoothShading) {
                n33 = 0;
                do {
                    int n35 = n33++;
                    this.cd_inc[n35] = this.cd_inc[n35] / (float)n34;
                } while (n33 < 3);
            }
            if (this.m_bShowSmoothLighting) {
                n33 = 0;
                do {
                    int n36 = n33++;
                    this.lad_inc[n36] = this.lad_inc[n36] / (float)n34;
                } while (n33 < 6);
            }
            f /= (float)n11;
            int n37 = n18 - n11;
            int n38 = n18;
            int n39 = n18 - n17;
            if (bl5) {
                pdVectorArray[n7].m_data[0] = f3;
                pdVectorArray[n7].m_data[1] = f4;
                pdVectorArray[n7].m_data[2] = f5;
            }
            piVectorArray[n7].m_data[0] = n13;
            piVectorArray[n7].m_data[1] = n14;
            piVectorArray[n7].m_data[2] = (int)f2;
            if (this.m_bShowSmoothShading) {
                n33 = 0;
                do {
                    fArray[n7][n33] = this.cd[n33];
                } while (++n33 < 3);
            }
            if (this.m_bShowSmoothLighting) {
                n33 = 0;
                do {
                    fArray4[n7][n33] = this.lad[n33];
                } while (++n33 < 6);
            }
            if (n13 >= 0 && n13 < this.m_imgWidth && (n32 = n14 * this.m_imgWidth + n13) >= 0 && n32 < n19) {
                this.m_pixData[n32] = m_colMark | this.m_pixData[n32] & n21;
                this.m_bndIdentifier.m_data[++n20] = n32;
            }
            ++n7;
            n33 = !(bl2 && n16 < 0 || bl3 && n16 > 0) ? 0 : 1;
            while (n13 != n4) {
                int n40;
                if (n7 >= piVectorArray.length - 1) {
                    return -1;
                }
                if (n37 <= 0) {
                    if (bl5) {
                        f3 += f6;
                        f4 += f7;
                        f5 += f8;
                    }
                    n37 += n38;
                    n13 += n15;
                    f2 += f;
                    if (this.m_bShowSmoothShading) {
                        n40 = 0;
                        do {
                            int n41 = n40;
                            this.cd[n41] = this.cd[n41] + this.cd_inc[n40];
                        } while (++n40 < 3);
                    }
                    if (this.m_bShowSmoothLighting) {
                        n40 = 0;
                        do {
                            int n42 = n40;
                            this.lad[n42] = this.lad[n42] + this.lad_inc[n40];
                        } while (++n40 < 6);
                    }
                } else if (n33 != 0) {
                    if (bl5) {
                        f3 += f6;
                        f4 += f7;
                        f5 += f8;
                    }
                    n37 += n39;
                    n13 += n15;
                    n14 += n16;
                    f2 += f;
                    if (this.m_bShowSmoothShading) {
                        n40 = 0;
                        do {
                            int n43 = n40;
                            this.cd[n43] = this.cd[n43] + this.cd_inc[n40];
                        } while (++n40 < 3);
                    }
                    if (this.m_bShowSmoothLighting) {
                        n40 = 0;
                        do {
                            int n44 = n40;
                            this.lad[n44] = this.lad[n44] + this.lad_inc[n40];
                        } while (++n40 < 6);
                    }
                    if (n13 != n4) {
                        if (bl5) {
                            pdVectorArray[n7].m_data[0] = f3;
                            pdVectorArray[n7].m_data[1] = f4;
                            pdVectorArray[n7].m_data[2] = f5;
                        }
                        piVectorArray[n7].m_data[0] = n13;
                        piVectorArray[n7].m_data[1] = n14;
                        piVectorArray[n7].m_data[2] = (int)f2;
                        if (this.m_bShowSmoothShading) {
                            n40 = 0;
                            do {
                                fArray[n7][n40] = this.cd[n40];
                            } while (++n40 < 3);
                        }
                        if (this.m_bShowSmoothLighting) {
                            n40 = 0;
                            do {
                                fArray4[n7][n40] = this.lad[n40];
                            } while (++n40 < 6);
                        }
                        ++n7;
                    }
                } else {
                    if (bl5) {
                        pdVectorArray[n7].m_data[0] = f3;
                        pdVectorArray[n7].m_data[1] = f4;
                        pdVectorArray[n7].m_data[2] = f5;
                    }
                    piVectorArray[n7].m_data[0] = n13;
                    piVectorArray[n7].m_data[1] = n14;
                    piVectorArray[n7].m_data[2] = (int)f2;
                    if (this.m_bShowSmoothShading) {
                        n40 = 0;
                        do {
                            fArray[n7][n40] = this.cd[n40];
                        } while (++n40 < 3);
                    }
                    if (this.m_bShowSmoothLighting) {
                        n40 = 0;
                        do {
                            fArray4[n7][n40] = this.lad[n40];
                        } while (++n40 < 6);
                    }
                    ++n7;
                    if (bl5) {
                        f3 += f6;
                        f4 += f7;
                        f5 += f8;
                    }
                    n37 += n39;
                    n13 += n15;
                    n14 += n16;
                    f2 += f;
                    if (this.m_bShowSmoothShading) {
                        n40 = 0;
                        do {
                            int n45 = n40;
                            this.cd[n45] = this.cd[n45] + this.cd_inc[n40];
                        } while (++n40 < 3);
                    }
                    if (this.m_bShowSmoothLighting) {
                        n40 = 0;
                        do {
                            int n46 = n40;
                            this.lad[n46] = this.lad[n46] + this.lad_inc[n40];
                        } while (++n40 < 6);
                    }
                }
                if (n13 < 0 || n13 >= this.m_imgWidth || (n32 = n14 * this.m_imgWidth + n13) < 0 || n32 >= n19) continue;
                this.m_pixData[n32] = m_colMark | this.m_pixData[n32] & n21;
                this.m_bndIdentifier.m_data[++n20] = n32;
            }
        }
        this.m_bndIdentifier.m_data[0] = n20;
        return n7;
    }

    public boolean hasTagElement(int n, int n2) {
        return this.m_element[n].hasTag(n2);
    }

    public void setNumVectors(int n, int n2, int n3) {
        super.setNumVectors(n, n2, n3);
        this.m_vectorTrans[n] = PiVector.realloc(this.m_vectorTrans[n], n2, this.m_dimTrans);
    }

    public void setSpecularColor(Color color) {
        super.setSpecularColor(color);
        int n = this.m_specularColor.getRGB();
        this.m_specular[0] = (float)(n >> 16 & 0xFF) / 255.0f;
        this.m_specular[1] = (float)(n >> 8 & 0xFF) / 255.0f;
        this.m_specular[2] = (float)(n & 0xFF) / 255.0f;
    }

    public void setGlobalBndSize(double d) {
        this.m_globalBndSize = d;
        if (this.m_globalBndSize > 1.0) {
            this.m_globalBndSize = 2.0 * d - 1.0;
        }
    }

    private double getVertexSize(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        double d = this.m_globalVertexSize;
        if (this.m_bShowVertexSizes) {
            d *= this.m_vertexSize.getEntry(n);
        }
        if (!this.m_bAdaptiveSize) {
            if (bl || bl2) {
                d = d < 1.0 ? 3.0 : (d += 4.0);
            } else if (bl4 && bl3) {
                d = d < 1.0 ? 2.0 : (d += 3.0);
            } else if (bl3 || bl4) {
                d = d < 1.0 ? 1.0 : (d += 2.0);
            }
        } else if (bl || bl2) {
            d *= 1.4;
        } else if (bl4 && bl3) {
            d *= 1.3;
        } else if (bl3 || bl4) {
            d *= 1.2;
        }
        return d * (double)this.m_offFac;
    }

    protected int getNumTaggedVertices() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            if (this.m_vertex[n2].hasTag(1)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public void setNumVectorFields(int n) {
        if (n == this.m_numVectorFields) {
            return;
        }
        PiVector[][] piVectorArrayArray = new PiVector[n][];
        int n2 = 0;
        while (n2 < Math.min(n, this.m_numVectorFields)) {
            piVectorArrayArray[n2] = this.m_vectorTrans[n2];
            ++n2;
        }
        this.m_vectorTrans = piVectorArrayArray;
        super.setNumVectorFields(n);
    }

    protected boolean untagAllVertices() {
        int n = 0;
        while (n < this.m_numVertices) {
            this.m_vertex[n].clearTag(1);
            this.m_geometry.clearTagVertex(n, 1);
            this.m_vertex[n].clearTag(12);
            this.m_geometry.clearTagVertex(n, 12);
            this.m_vertex[n].clearTag(11);
            this.m_geometry.clearTagVertex(n, 11);
            ++n;
        }
        return true;
    }

    private void drawLineAny(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, Color color, Color color2, boolean bl) {
        if (n == 0) {
            return;
        }
        if (this.m_bEnableZBuffer) {
            int n8;
            int n9 = color.getRGB();
            int n10 = color2.getRGB();
            if (n < 2) {
                this.drawLineZBresen(n2, n3, n4, n5, n6, n7, n9, n10);
                return;
            }
            if (!this.m_bEnable3DLook) {
                this.drawLineZThick(n, n2, n3, n4, n5, n6, n7, n9, n10);
            } else {
                n8 = this.m_transparency;
                this.m_transparency = 0;
                this.drawLineZThick3D(n, n2, n3, n4, n5, n6, n7, n9, n10);
                this.m_transparency = n8;
            }
            if (bl && !this.m_bShowDepthcue) {
                n8 = this.m_bShowVertexOutline ? 1 : 0;
                this.m_bShowVertexOutline = false;
                if (this.m_bShowLighting && !this.m_bEnable3DLook) {
                    n9 = this.attenuateColor(n9, this.m_lightAttMat, this.m_lightAttSpec);
                    n10 = color == color2 ? n9 : this.attenuateColor(n10, this.m_lightAttMat, this.m_lightAttSpec);
                }
                int n11 = this.m_zTolVertex;
                this.m_zTolVertex = this.m_zTolLine;
                this.writeCircle(n2, n3, 1 + n >> 1, n9, n4);
                this.writeCircle(n5, n6, 1 + n >> 1, n10, n7);
                this.m_zTolVertex = n11;
                this.m_bShowVertexOutline = n8;
                return;
            }
        } else {
            graphics.setColor(color);
            if (n < 2 || n == PS_ZOOM) {
                graphics.drawLine(n2, n3, n5, n6);
                return;
            }
            this.drawLineThick(graphics, n, n2, n3, n5, n6, bl);
        }
    }

    private void drawLineZThick(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (n < PS_ZOOM) {
            return;
        }
        float f = n5 - n2;
        float f2 = n3 - n6;
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        if ((double)f3 < 1.0E-10) {
            f3 = 1.0f;
        }
        float f4 = (float)n / 2.0f * f2 / f3;
        float f5 = (float)n / 2.0f * -f / f3;
        this.xCorner[0] = (int)((float)n2 + f4);
        this.xCorner[1] = (int)((float)n5 + f4);
        this.xCorner[2] = (int)((float)n5 - f4);
        this.xCorner[3] = (int)((float)n2 - f4);
        this.yCorner[0] = (int)((float)n3 - f5);
        this.yCorner[1] = (int)((float)n6 - f5);
        this.yCorner[2] = (int)((float)n6 + f5);
        this.yCorner[3] = (int)((float)n3 + f5);
        this.zCorner[0] = n4;
        this.zCorner[1] = n7;
        this.zCorner[2] = n7;
        this.zCorner[3] = n4;
        int n10 = this.m_scene.m_zMin;
        int n11 = this.m_scene.m_zMax;
        float f6 = 1.0f;
        if (n11 - n10 != 0) {
            f6 = n11 - n10;
        }
        int n12 = 4;
        if (this.m_texCoord != null) {
            int n13 = 0;
            while (n13 < n12) {
                this.m_texCoord[n13].m_data[0] = this.m_textureWidth - 1;
                this.m_texCoord[n13].m_data[1] = this.m_textureHeight - 1;
                this.m_texCoord[n13].m_data[2] = (float)(this.zCorner[n13] - n10) / f6;
                ++n13;
            }
        }
        int[][] nArray = null;
        if (this.m_bShowSmoothShading) {
            nArray = this.m_cv;
        }
        float[][] fArray = null;
        if (this.m_bShowSmoothLighting) {
            fArray = this.m_lv;
        }
        int n14 = this.m_zTol;
        this.m_zTol = this.m_zTolLine;
        this.drawElementZBuffer(this.xCorner, this.yCorner, this.zCorner, n12, nArray, n8, fArray, this.m_texCoord);
        this.m_zTol = n14;
    }

    protected int getNumUnusedVertices() {
        return this.m_numUnusedVertices;
    }

    private boolean isBackVertexCulled(int n) {
        if (this.m_vertexNormalTrans == null) {
            return false;
        }
        return this.m_vertexNormalTrans[n].hasTag(15);
    }

    private boolean isBackElementCulled(int n) {
        if (this.m_elementNormalTrans == null) {
            return false;
        }
        return this.m_elementNormalTrans[n].hasTag(15);
    }

    private void createImageString() {
        if (this.m_imageString != null && this.m_imageString.getWidth(null) == this.m_widthString && this.m_imageString.getHeight(null) == this.m_heightString) {
            return;
        }
        this.m_imageString = ((PvDisplay)this.m_display).createImage(this.m_widthString, this.m_heightString);
        this.m_pixString = new int[this.m_widthString * this.m_heightString];
        this.m_gImageString = this.m_imageString.getGraphics();
    }

    private void getElementCenter(PiVector piVector, int[] nArray, PiVector[] piVectorArray, int n) {
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n) {
            double d = 0.0;
            int n4 = 0;
            while (n4 < n2) {
                d += (double)piVectorArray[nArray[n4]].m_data[n3];
                ++n4;
            }
            piVector.setEntry(n3, (int)(d / (double)n2));
            ++n3;
        }
    }

    private void getElementCenter(PdVector pdVector, int[] nArray, PdVector[] pdVectorArray, int n) {
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n) {
            double d = 0.0;
            int n4 = 0;
            while (n4 < n2) {
                d += pdVectorArray[nArray[n4]].m_data[n3];
                ++n4;
            }
            pdVector.setEntry(n3, d / (double)n2);
            ++n3;
        }
    }

    public void setLabelFonts(String[] stringArray) {
        if (stringArray == null || stringArray.length < 7) {
            PsDebug.warning("missing font names");
            return;
        }
        int n = 0;
        do {
            this.m_labelFont[n] = stringArray[n];
        } while (++n < 7);
    }

    protected void tagElements(Rectangle rectangle) {
        int n = this.getNumElements();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.m_element[n2].getSize();
            int n4 = 0;
            while (n4 < n3) {
                int n5 = this.m_element[n2].m_data[n4];
                if (rectangle.contains(this.m_vertexTrans[n5].m_data[0], this.m_vertexTrans[n5].m_data[1])) {
                    this.m_element[n2].setTag(1);
                    this.m_geometry.setTagElement(n2, 1);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected void drawCenter(Graphics graphics) {
        graphics.setColor(Color.green);
        int n = 4;
        int n2 = this.m_centerTrans.m_data[0];
        int n3 = this.m_centerTrans.m_data[1];
        graphics.fillOval(n2 - n, n3 - n, 2 * n, 2 * n);
        graphics.setColor(Color.black);
        graphics.drawOval(n2 - n, n3 - n, 2 * n, 2 * n);
    }

    public PgGeometryIf getGeometry() {
        return this.m_geometry;
    }

    public void setGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            PsDebug.warning("missing geometry");
            return;
        }
        this.m_geometry = pgGeometryIf;
        this.setType(this.m_geometry.getType());
        this.setName(pgGeometryIf.getName() + "_" + PsConfig.getMessage(15024));
        this.update(this.m_geometry);
    }

    protected void setPosition(int n, int n2) {
        if (this.m_position == null) {
            this.m_position = new int[2];
        }
        this.m_position[0] = n;
        this.m_position[1] = n2;
    }

    public int getDrawingOrder() {
        return this.m_drawingOrder;
    }

    public void setDrawingOrder(int n) {
        this.m_drawingOrder = n;
    }

    private Color attenuateColor(Color color, float[] fArray, float[] fArray2) {
        int n = color.getRGB();
        this.m_matCol[0] = n >> 16 & 0xFF;
        this.m_matCol[1] = n >> 8 & 0xFF;
        this.m_matCol[2] = n & 0xFF;
        int n2 = 0;
        do {
            this.m_color[n2] = (int)(fArray[n2] * (float)this.m_matCol[n2] + fArray2[n2]);
            if (this.m_color[n2] > 255) {
                this.m_color[n2] = 255;
                continue;
            }
            if (this.m_color[n2] >= 0) continue;
            this.m_color[n2] = 0;
        } while (++n2 < 3);
        return new Color(this.m_color[0], this.m_color[1], this.m_color[2]);
    }

    protected int pickVertex(Rectangle rectangle, int n) {
        this.m_pickedVertex = -1;
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            if (rectangle.contains(this.m_vertexTrans[n2].m_data[0], this.m_vertexTrans[n2].m_data[1])) {
                this.m_vertex[n2].setTag(n);
                this.m_geometry.setTagVertex(n2, n);
                this.m_bHasTaggedVertices = true;
                this.m_pickedVertex = n2;
                return this.m_pickedVertex;
            }
            ++n2;
        }
        return -1;
    }

    protected int releaseVertex(int n, int n2) {
        if (n >= 0 && n < this.m_numVertices) {
            this.m_vertex[n].clearTag(n2);
            this.m_geometry.clearTagVertex(n, n2);
        }
        this.m_pickedVertex = -1;
        return -1;
    }

    private int attenuateColor(int n, float[] fArray, float[] fArray2) {
        int n2 = n >> 24 & 0xFF;
        int n3 = (int)((float)(n >> 16 & 0xFF) * fArray[0] + fArray2[0]);
        int n4 = (int)((float)(n >> 8 & 0xFF) * fArray[1] + fArray2[1]);
        int n5 = (int)((float)(n & 0xFF) * fArray[2] + fArray2[2]);
        if (n3 > 255) {
            n3 = 255;
        }
        if (n4 > 255) {
            n4 = 255;
        }
        if (n5 > 255) {
            n5 = 255;
        }
        n = n2 << 24 | n3 << 16 | n4 << 8 | n5;
        return n;
    }

    protected boolean setGeometryVertex(int n, PdVector pdVector) {
        this.setVertex(n, pdVector);
        PdVector pdVector2 = this.m_geometry.getVertex(n);
        pdVector2.copyArray(pdVector);
        return this.m_geometry.setVertex(n, pdVector2);
    }

    public void clearTagElement(int n, int n2) {
        this.m_element[n].clearTag(n2);
        this.m_geometry.clearTagElement(n, n2);
    }

    private void drawElement(Graphics graphics, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        if (n < 0 || this.m_numElements <= n) {
            return;
        }
        int n12 = this.m_element[n].m_data.length;
        if (n12 == 0) {
            return;
        }
        if (2 * n12 > this.m_maxSizeOfElements) {
            this.setMaxSizeElements(2 * n12);
        }
        this.m_bIsBackface = this.isBackElementCulled(n);
        if (!this.m_bShowBackface && this.m_bIsBackface) {
            return;
        }
        this.m_bElementDrawn = true;
        if (this.m_bFastClipping) {
            n11 = 0;
            n10 = 0;
            n9 = 0;
            n8 = 0;
            n7 = 0;
            n6 = 0;
            while (n6 < n12) {
                n5 = this.m_element[n].m_data[n6];
                n4 = this.m_vertexTrans[n5].m_data[0];
                n3 = this.m_vertexTrans[n5].m_data[1];
                n2 = this.m_vertexTrans[n5].m_data[2];
                if (n4 < 0) {
                    ++n11;
                } else if (n3 < 0) {
                    ++n8;
                } else if (n4 >= this.m_dispSize.width) {
                    ++n10;
                } else if (n3 >= this.m_dispSize.height) {
                    ++n9;
                } else if (this.m_bEnableZBuffer && !this.m_bShowTransparency && n2 - this.m_zTolVertex < this.m_zBuffer[n3][n4]) {
                    ++n7;
                }
                ++n6;
            }
            if (n11 == n12 || n8 == n12 || n10 == n12 || n9 == n12 || n7 == n12) {
                this.m_bElementDrawn = false;
                return;
            }
        }
        n11 = !this.m_bShowTaggedElements || !this.m_bHasTaggedElements || !this.m_element[n].hasTag(12) ? 0 : 1;
        n10 = !this.m_bShowTaggedElements || !this.m_bHasTaggedElements || !this.m_element[n].hasTag(11) ? 0 : 1;
        this.m_bIsTaggedElement = n9 = !this.m_bShowTaggedElements || !this.m_bHasTaggedElements || !this.m_element[n].hasTag(1) ? 0 : 1;
        n8 = this.m_element[n].getURL() == null ? 0 : 1;
        this.m_bElemIsClipped = false;
        if (this.m_bIsClippable && this.m_bEnableClipBounds && this.m_clipBounds != null) {
            if (n12 > 2 * this.m_maxSizeOfElements / 3) {
                this.setMaxSizeElements(2 * this.m_maxSizeOfElements);
            }
            n7 = 0;
            while (n7 < n12) {
                this.project(this.m_vd[n7], this.m_vertex[this.m_element[n].m_data[n7]], this.m_modelMatrix, this.m_ambientMatrix);
                ++n7;
            }
            n7 = 0;
            n6 = 0;
            do {
                n5 = 0;
                n4 = 0;
                n3 = 0;
                while (n3 < n12) {
                    if (this.m_vd[n3].m_data[n6] < this.m_clipBounds[0].m_data[n6] - 1.0E-10) {
                        ++n5;
                    }
                    if (this.m_vd[n3].m_data[n6] > this.m_clipBounds[1].m_data[n6] + 1.0E-10) {
                        ++n4;
                    }
                    ++n3;
                }
                if (n5 == n12 || n4 == n12) {
                    return;
                }
                n7 += n5 + n4;
            } while (++n6 < 3);
            if (n7 != 0) {
                this.m_bElemIsClipped = true;
                if (this.m_bShowLighting && this.m_bShowSmoothLighting && (this.m_vertexNormal != null || this.m_elementNormal != null)) {
                    n6 = 0;
                    while (n6 < n12) {
                        n5 = this.m_element[n].m_data[n6];
                        if (!(this.m_vertexNormal == null || this.m_bHasCreaseEdge && this.m_bCreaseEdge[n5])) {
                            this.renderLight(this.m_vertex[n5], this.m_vertexNormal[n5], this.m_light);
                        } else {
                            this.renderLight(this.m_vertex[n5], this.m_elementNormal[n], this.m_light);
                        }
                        n4 = 0;
                        do {
                            this.m_lv[n6][n4] = this.m_lightAttMat[n4];
                            this.m_lv[n6][n4 + 3] = this.m_lightAttSpec[n4];
                        } while (++n4 < 3);
                        ++n6;
                    }
                }
                if (this.m_bShowSmoothShading) {
                    n6 = 0;
                    while (n6 < n12) {
                        Color color = this.getElementColor(n, n6, n11 != 0, n10 != 0, n9 != 0, n8 != 0);
                        n4 = color.getRGB();
                        this.m_cv[n6][0] = n4 >> 16 & 0xFF;
                        this.m_cv[n6][1] = n4 >> 8 & 0xFF;
                        this.m_cv[n6][2] = n4 & 0xFF;
                        ++n6;
                    }
                }
                if (this.m_bShowTexture) {
                    n6 = 0;
                    while (n6 < n12) {
                        if (this.m_bShowVertexTexture) {
                            this.m_tex[n6].copyArray(this.m_vertexTexture[this.m_element[n].m_data[n6]]);
                        } else if (this.m_bShowElementTexture) {
                            this.m_tex[n6].copyArray(this.m_elementTexture[n][n6]);
                        }
                        ++n6;
                    }
                }
                n6 = 0;
                while (n6 < n12) {
                    this.m_origInd[n6] = this.m_element[n].m_data[n6];
                    ++n6;
                }
                this.m_bElemIsClipped = false;
                n6 = 0;
                do {
                    if (this.m_clipBounds[0].m_data[n6] > this.m_clipBounds[1].m_data[n6]) continue;
                    this.m_bElemIsClipped = true;
                    PdVector[] pdVectorArray = null;
                    if (this.m_bShowTexture) {
                        pdVectorArray = this.m_tex;
                    }
                    n12 = this.clipElement3D(n12, this.m_vd, this.m_origInd, pdVectorArray, this.m_cv, this.m_lv, n6, (float)this.m_clipBounds[0].m_data[n6], (float)this.m_clipBounds[1].m_data[n6]);
                } while (++n6 < 3);
                PdMatrix pdMatrix = this.m_display.getTransMatrix(1);
                n5 = 0;
                while (n5 < n12) {
                    this.project(this.m_elemCenterTrans, this.m_vd[n5], pdMatrix);
                    this.m_xv[n5] = this.m_elemCenterTrans.m_data[0];
                    this.m_yv[n5] = this.m_elemCenterTrans.m_data[1];
                    this.m_zv[n5] = this.m_elemCenterTrans.m_data[2];
                    ++n5;
                }
                if (this.m_bShowTexture) {
                    n5 = 0;
                    while (n5 < n12) {
                        this.m_texCoord[n5].m_data[0] = this.m_tex[n5].m_data[0] * ((double)this.m_textureWidth - 1.0);
                        this.m_texCoord[n5].m_data[1] = this.m_tex[n5].m_data[1] * ((double)this.m_textureHeight - 1.0);
                        ++n5;
                    }
                }
                if (n12 == 0) {
                    return;
                }
            }
        }
        if (!this.m_bElemIsClipped) {
            if (this.m_bIsClippable && this.m_bEnableClipCamera) {
                if (this.m_bShowLighting && this.m_bShowSmoothLighting && (this.m_vertexNormal != null || this.m_elementNormal != null)) {
                    n7 = 0;
                    while (n7 < n12) {
                        int n13 = this.m_element[n].m_data[n7];
                        if (!(this.m_vertexNormal == null || this.m_bHasCreaseEdge && this.m_bCreaseEdge[n13])) {
                            this.renderLight(this.m_vertex[n13], this.m_vertexNormal[n13], this.m_light);
                        } else {
                            this.renderLight(this.m_vertex[n13], this.m_elementNormal[n], this.m_light);
                        }
                        n5 = 0;
                        do {
                            this.m_lvClip[n7][n5] = this.m_lightAttMat[n5];
                            this.m_lvClip[n7][n5 + 3] = this.m_lightAttSpec[n5];
                        } while (++n5 < 3);
                        ++n7;
                    }
                }
                if (this.m_bShowSmoothShading || this.m_bInduceElementFromVertexColors) {
                    n7 = 0;
                    while (n7 < n12) {
                        Color color = this.getElementColor(n, n7, n11 != 0, n10 != 0, n9 != 0, n8 != 0);
                        n5 = color.getRGB();
                        this.m_cvClip[n7][0] = n5 >> 16 & 0xFF;
                        this.m_cvClip[n7][1] = n5 >> 8 & 0xFF;
                        this.m_cvClip[n7][2] = n5 & 0xFF;
                        ++n7;
                    }
                }
                if (this.m_bShowTexture) {
                    if (this.m_bShowVertexTexture) {
                        n7 = 0;
                        while (n7 < n12) {
                            this.m_tex[n7].copyArray(this.m_vertexTexture[this.m_element[n].m_data[n7]]);
                            ++n7;
                        }
                    } else if (this.m_bShowElementTexture) {
                        n7 = 0;
                        while (n7 < n12) {
                            this.m_tex[n7].copyArray(this.m_elementTexture[n][n7]);
                            ++n7;
                        }
                    }
                }
                this.m_bElemIsClipped = false;
                n12 = this.clipElement(n, n12, this.m_xv, this.m_yv, this.m_zv, this.m_origInd, this.m_texCoord, this.m_tex, this.m_cv, this.m_cvClip, this.m_lv, this.m_lvClip);
                if (this.m_bShowTexture) {
                    n7 = 0;
                    while (n7 < n12) {
                        this.m_texCoord[n7].m_data[0] = this.m_texCoord[n7].m_data[0] * ((double)this.m_textureWidth - 1.0);
                        this.m_texCoord[n7].m_data[1] = this.m_texCoord[n7].m_data[1] * ((double)this.m_textureHeight - 1.0);
                        ++n7;
                    }
                }
                if (n12 == 0) {
                    return;
                }
            } else {
                n7 = 0;
                while (n7 < n12) {
                    int n14 = this.m_element[n].m_data[n7];
                    this.m_xv[n7] = this.m_vertexTrans[n14].m_data[0];
                    this.m_yv[n7] = this.m_vertexTrans[n14].m_data[1];
                    this.m_zv[n7] = this.m_vertexTrans[n14].m_data[2];
                    if (this.m_bAutoClip && (this.m_zv[n7] > this.m_autoClip || this.m_zv[n7] < -this.m_autoClip)) {
                        return;
                    }
                    this.m_origInd[n7] = n14;
                    ++n7;
                }
                if (this.m_bShowLighting && this.m_bShowSmoothLighting && (this.m_vertexNormal != null || this.m_elementNormal != null)) {
                    n7 = 0;
                    while (n7 < n12) {
                        int n15 = this.m_element[n].m_data[n7];
                        if (!(this.m_vertexNormal == null || this.m_bHasCreaseEdge && this.m_bCreaseEdge[n15])) {
                            this.renderLight(this.m_vertex[n15], this.m_vertexNormal[n15], this.m_light);
                        } else {
                            this.renderLight(this.m_vertex[n15], this.m_elementNormal[n], this.m_light);
                        }
                        n5 = 0;
                        do {
                            this.m_lv[n7][n5] = this.m_lightAttMat[n5];
                            this.m_lv[n7][n5 + 3] = this.m_lightAttSpec[n5];
                        } while (++n5 < 3);
                        ++n7;
                    }
                }
                if (this.m_bShowSmoothShading) {
                    n7 = 0;
                    while (n7 < n12) {
                        Color color = this.getElementColor(n, n7, n11 != 0, n10 != 0, n9 != 0, n8 != 0);
                        n5 = color.getRGB();
                        this.m_cv[n7][0] = n5 >> 16 & 0xFF;
                        this.m_cv[n7][1] = n5 >> 8 & 0xFF;
                        this.m_cv[n7][2] = n5 & 0xFF;
                        ++n7;
                    }
                }
                if (this.m_bShowTexture) {
                    if (this.m_dimOfTextures == 3) {
                        n7 = 0;
                        while (n7 < n12) {
                            if (this.m_bShowVertexTexture) {
                                this.m_texCoord[n7].copyArray(this.m_vertexTexture[this.m_element[n].m_data[n7]]);
                            } else if (this.m_bShowElementTexture) {
                                this.m_texCoord[n7].copyArray(this.m_elementTexture[n][n7]);
                            }
                            ++n7;
                        }
                    } else {
                        n7 = 0;
                        while (n7 < n12) {
                            if (this.m_bShowVertexTexture) {
                                this.m_texCoord[n7].copyArray(this.m_vertexTexture[this.m_element[n].m_data[n7]]);
                            } else if (this.m_bShowElementTexture) {
                                this.m_texCoord[n7].copyArray(this.m_elementTexture[n][n7]);
                            }
                            this.m_texCoord[n7].m_data[0] = this.m_texCoord[n7].m_data[0] * ((double)this.m_textureWidth - 1.0);
                            this.m_texCoord[n7].m_data[1] = this.m_texCoord[n7].m_data[1] * ((double)this.m_textureHeight - 1.0);
                            ++n7;
                        }
                    }
                }
            }
        }
        if (this.m_bShowTexture) {
            double d = this.m_scene.m_zMin;
            double d2 = this.m_scene.m_zMax;
            double d3 = 1.0;
            if (d2 - d != 0.0) {
                d3 = d2 - d;
            }
            int n16 = 0;
            while (n16 < n12) {
                this.m_texCoord[n16].m_data[2] = 0.2 + 0.8 * ((double)this.m_zv[n16] - d) / d3;
                ++n16;
            }
        }
        int n17 = 6;
        this.m_bShowCurrElement = this.m_bShowElements || n9 != 0;
        this.m_bShowCurrEdge = (this.m_bShowEdges || this.m_bShowTaggedEdges && this.m_bHasTaggedEdges) && n12 < n17;
        this.m_bDrawingEdge = false;
        this.m_bDepthcueEdge = false;
        Color color = this.getElementColor(n, -1, n11 != 0, n10 != 0, n9 != 0, n8 != 0);
        if (this.m_bShowLighting && !this.m_bShowSmoothLighting) {
            int n18 = this.m_element[n].m_data[0];
            if (this.m_elementNormal != null) {
                this.renderLight(this.m_vertex[n18], this.m_elementNormal[n], this.m_light);
            } else if (this.m_vertexNormal != null) {
                this.renderLight(this.m_vertex[n18], this.m_vertexNormal[n18], this.m_light);
            }
            if (!this.m_bEnableZBuffer) {
                color = this.attenuateColor(color, this.m_lightAttMat, this.m_lightAttSpec);
            }
        }
        if (this.m_bShowElements || n9 != 0) {
            if (!this.m_bEnableZBuffer || !(this.m_globalEdgeSize < 2.0) || !this.m_bShowElements || this.m_bShowSilhouette) {
                this.m_bShowCurrEdge = false;
            }
            if (this.m_bEnableZBuffer) {
                if (this.m_bShowCurrEdge) {
                    this.m_currEdgeCol = this.m_alpha | this.getEdgeColor_(n, -1).getRGB();
                }
                int n19 = color.getRGB();
                if (n12 > n17) {
                    if (this.xvSub == null) {
                        this.xvSub = new int[3];
                        this.yvSub = new int[3];
                        this.zvSub = new int[3];
                        this.cvSub = new int[3][];
                    }
                    this.m_elemSub = this.triangulate(this.m_xv, this.m_yv, this.m_zv, n12);
                    n4 = 0;
                    while (n4 < n12 - 2) {
                        int n20 = 0;
                        do {
                            this.xvSub[n20] = this.m_xv[this.m_elemSub[n4][n20]];
                            this.yvSub[n20] = this.m_yv[this.m_elemSub[n4][n20]];
                            this.zvSub[n20] = this.m_zv[this.m_elemSub[n4][n20]];
                            this.cvSub[n20] = this.m_cv[this.m_elemSub[n4][n20]];
                            if (this.m_bShowLighting) {
                                this.lvSub[n20] = this.m_lv[this.m_elemSub[n4][n20]];
                            }
                            if (!this.m_bShowTexture) continue;
                            this.texSub[n20] = this.m_texCoord[this.m_elemSub[n4][n20]];
                        } while (++n20 < 3);
                        this.drawElementZBuffer(this.xvSub, this.yvSub, this.zvSub, 3, this.cvSub, n19, this.lvSub, this.texSub);
                        ++n4;
                    }
                } else {
                    this.drawElementZBuffer(this.m_xv, this.m_yv, this.m_zv, n12, this.m_cv, n19, this.m_lv, this.m_texCoord);
                }
            } else {
                if (this.m_bShowDepthcue) {
                    color = PdColor.getDimmedColor(color, (int)(255.0f * this.m_heightFac));
                }
                graphics.setColor(color);
                graphics.fillPolygon(this.m_xv, this.m_yv, n12);
            }
        }
        this.m_bShowCurrElement = true;
        this.m_bShowCurrEdge = false;
        this.m_bDrawingEdge = true;
        boolean bl = this.m_bDepthcueEdge = !this.m_bShowElements && this.m_bShowDepthcue;
        if (this.m_bShowEdges || this.m_bShowTaggedEdges && this.m_bHasTaggedEdges) {
            if (this.m_bAdaptiveSize || this.m_bEnable3DLook && this.m_globalEdgeSize > 1.0 || !this.m_bEnableZBuffer || !(this.m_globalEdgeSize < 2.0) || n12 >= n17 || !this.m_bShowElements || this.m_bShowSilhouette) {
                boolean bl2 = this.m_bShowSmoothShading;
                this.m_bShowSmoothShading = this.m_bShowSmoothShading && this.m_bShowEdgeColors;
                this.drawElementEdges(graphics, n, n12, this.m_xv, this.m_yv, this.m_zv, this.m_texCoord);
                this.m_bShowSmoothShading = bl2;
            }
        } else if (this.m_bShowSilhouette) {
            this.drawElementEdges(graphics, n, n12, this.m_xv, this.m_yv, this.m_zv, this.m_texCoord);
        }
        if (!(!this.m_bShowBoundaries || this.m_bEnableClip && this.m_bElemIsClipped)) {
            this.drawElementBnd(graphics, n, n12, this.m_xv, this.m_yv, this.m_zv);
        }
        if (!this.m_useVertices && (this.m_bShowVertices || this.m_bShowTaggedVertices && this.m_bHasTaggedVertices || this.m_bShowVertexNormals || this.m_bShowVectors)) {
            this.drawElementVertices(graphics, n, n12, this.m_origInd);
        }
        if ((this.m_bShowIndices || this.m_bShowElementLabels) && (this.m_bShowElements || this.m_bShowTaggedElements && this.m_bHasTaggedElements)) {
            int n21 = 0;
            n4 = 0;
            int n22 = Integer.MIN_VALUE;
            n2 = n12 - 1;
            while (n2 >= 0) {
                n21 += this.m_xv[n2];
                n4 += this.m_yv[n2];
                if (n22 < this.m_zv[n2]) {
                    n22 = this.m_zv[n2];
                }
                --n2;
            }
            String string = this.m_element[n].getName();
            if (string == null && this.m_bEnabledIndexLabels) {
                string = String.valueOf(n);
            }
            if (string != null) {
                this.drawString(graphics, string, n21 / n12, n4 / n12, n22, 0, 3);
            }
        }
        if (this.m_bShowElementNormals) {
            this.drawElementNormal(graphics, n, n12, this.m_xv, this.m_yv, this.m_zv);
        }
        if (this.m_bShowVectors) {
            this.drawElementVectors(graphics, n, n12, this.m_xv, this.m_yv, this.m_zv, this.m_origInd);
        }
    }

    protected void burnElement(int n, int[] nArray, int n2, int n3, PsScanline psScanline, boolean bl) {
        int n4;
        int n5;
        boolean bl2;
        boolean bl3;
        if (this.bary == null) {
            this.bary = new double[3];
            this.baryDelta = new double[3];
        }
        boolean bl4 = this.m_bShowDepthcue;
        this.m_bShowDepthcue = false;
        int n6 = this.m_element[n].m_data.length;
        if (n6 == 0) {
            return;
        }
        this.m_bIsBackface = this.isBackElementCulled(n);
        boolean bl5 = this.m_bShowTaggedElements && this.m_bHasTaggedElements && this.m_element[n].hasTag(12);
        boolean bl6 = this.m_bShowTaggedElements && this.m_bHasTaggedElements && this.m_element[n].hasTag(11);
        this.m_bIsTaggedElement = bl3 = this.m_bShowTaggedElements && this.m_bHasTaggedElements && this.m_element[n].hasTag(1);
        boolean bl7 = bl2 = this.m_element[n].getURL() != null;
        if (this.m_bShowSmoothShading) {
            int n7 = 0;
            while (n7 < n6) {
                Color color = this.getElementColor(n, n7, bl5, bl6, bl3, bl2);
                n5 = color.getRGB();
                this.m_cv[n7][0] = n5 >> 16 & 0xFF;
                this.m_cv[n7][1] = n5 >> 8 & 0xFF;
                this.m_cv[n7][2] = n5 & 0xFF;
                ++n7;
            }
        } else {
            Color color = this.getElementColor(n, -1, bl5, bl6, bl3, bl2);
            if (this.m_bShowLighting && this.m_elementNormal != null) {
                this.renderLight(this.m_vertex[this.m_element[n].m_data[0]], this.m_elementNormal[n], this.m_light);
                color = this.attenuateColor(color, this.m_lightAttMat, this.m_lightAttSpec);
            }
            int n8 = color.getRGB();
            n5 = 0;
            while (n5 < n6) {
                this.m_cv[n5][0] = n8 >> 16 & 0xFF;
                this.m_cv[n5][1] = n8 >> 8 & 0xFF;
                this.m_cv[n5][2] = n8 & 0xFF;
                ++n5;
            }
        }
        if (this.m_bShowTexture) {
            if (this.m_dimOfTextures == 3) {
                int n9 = 0;
                while (n9 < n6) {
                    if (this.m_bShowVertexTexture) {
                        this.m_texCoord[n9].copyArray(this.m_vertexTexture[this.m_element[n].m_data[n9]]);
                    } else if (this.m_bShowElementTexture) {
                        this.m_texCoord[n9].copyArray(this.m_elementTexture[n][n9]);
                    }
                    ++n9;
                }
            } else {
                int n10 = 0;
                while (n10 < n6) {
                    if (this.m_bShowVertexTexture) {
                        this.m_texCoord[n10].copyArray(this.m_vertexTexture[this.m_element[n].m_data[n10]]);
                    } else if (this.m_bShowElementTexture) {
                        this.m_texCoord[n10].copyArray(this.m_elementTexture[n][n10]);
                    }
                    this.m_texCoord[n10].m_data[0] = this.m_texCoord[n10].m_data[0] * ((double)this.m_textureWidth - 1.0);
                    this.m_texCoord[n10].m_data[1] = this.m_texCoord[n10].m_data[1] * ((double)this.m_textureHeight - 1.0);
                    ++n10;
                }
            }
        }
        int n11 = 5;
        int n12 = psScanline.ymin;
        n5 = 0;
        while (n5 < psScanline.length) {
            n4 = n12 * n2 + psScanline.xa[n5];
            int n13 = 0;
            do {
                this.bary[n13] = psScanline.aAnteile[n13][n5];
                this.baryDelta[n13] = (double)psScanline.eAnteile[n13][n5] - this.bary[n13];
                if (psScanline.xe[n5] <= psScanline.xa[n5]) continue;
                int n14 = n13;
                this.baryDelta[n14] = this.baryDelta[n14] / (double)(psScanline.xe[n5] - psScanline.xa[n5]);
            } while (++n13 < 3);
            int n15 = psScanline.xa[n5];
            while (n15 <= psScanline.xe[n5]) {
                int n16 = 0;
                int n17 = 0;
                n13 = 0;
                int n18 = 0;
                do {
                    n13 = (int)((double)n13 + this.bary[n18] * (double)this.m_cv[n18][0]);
                    n17 = (int)((double)n17 + this.bary[n18] * (double)this.m_cv[n18][1]);
                    n16 = (int)((double)n16 + this.bary[n18] * (double)this.m_cv[n18][2]);
                } while (++n18 < 3);
                n13 = Math.max(Math.min(n13, 255), 0);
                n17 = Math.max(Math.min(n17, 255), 0);
                n16 = Math.max(Math.min(n16, 255), 0);
                if (bl) {
                    int n19 = n4;
                    nArray[n19] = nArray[n19] + (nArray[n4] & 0xFF000000 | n13 << 16 | n17 << 8 | n16);
                } else {
                    nArray[n4] = 0xFF000000 | n13 << 16 | n17 << 8 | n16;
                }
                ++n4;
                n18 = 0;
                do {
                    int n20 = n18;
                    this.bary[n20] = this.bary[n20] + this.baryDelta[n18];
                } while (++n18 < 3);
                ++n15;
            }
            n4 = n12 * n2;
            n15 = 1;
            while (n15 <= n11) {
                if (n4 + psScanline.xa[n5] - n15 >= 0) {
                    nArray[n4 + psScanline.xa[n5] - n15] = nArray[n4 + psScanline.xa[n5]];
                }
                if (n4 + psScanline.xe[n5] + n15 < nArray.length) {
                    nArray[n4 + psScanline.xe[n5] + n15] = nArray[n4 + psScanline.xe[n5]];
                }
                ++n15;
            }
            ++n12;
            ++n5;
        }
        n12 = psScanline.ymin - 1;
        if (n12 > 0) {
            n5 = 0;
            while (n5 < n11 - 1) {
                n4 = psScanline.xa[0] - n11;
                while (n4 <= psScanline.xe[0] + n11) {
                    if ((n12 - n5) * n2 + n4 >= 0 && (n12 + 1) * n2 + n4 < nArray.length) {
                        nArray[(n12 - n5) * n2 + n4] = nArray[(n12 + 1) * n2 + n4];
                    }
                    ++n4;
                }
                ++n5;
            }
        }
        if (psScanline.length > 0 && (n12 = psScanline.ymin + psScanline.length) < n3) {
            n5 = 0;
            while (n5 < n11 - 1) {
                n4 = psScanline.xa[psScanline.length - 1] - n11;
                while (n4 <= psScanline.xe[psScanline.length - 1] + n11) {
                    if ((n12 - 1) * n2 + n4 >= 0 && (n12 + n5) * n2 + n4 < nArray.length) {
                        nArray[(n12 + n5) * n2 + n4] = nArray[(n12 - 1) * n2 + n4];
                    }
                    ++n4;
                }
                ++n5;
            }
        }
        this.m_bShowDepthcue = bl4;
    }

    protected void setEnabledLighting(boolean bl) {
        if (this.m_dim > 3) {
            bl = false;
        }
        if (this.m_bShowLighting == bl) {
            return;
        }
        this.m_bShowLighting = bl;
        if (bl) {
            this.m_lv = new float[this.m_maxSizeOfElements][6];
            this.lvSub = new float[6][];
        } else {
            this.m_lv = null;
            this.lvSub = null;
        }
        if (this.m_usePolygons) {
            this.m_bShowLighting = this.m_bShowLighting && (this.m_polygonNormal != null || this.m_vertexNormal != null);
            this.m_bShowSmoothLighting = this.m_bShowSmoothLighting && (this.m_polygonNormal != null || this.m_vertexNormal != null);
            return;
        }
        if (this.m_useElements) {
            this.m_bShowLighting = this.m_bShowLighting && (this.m_elementNormal != null || this.m_vertexNormal != null);
            this.m_bShowSmoothLighting = this.m_bShowSmoothLighting && (this.m_elementNormal != null || this.m_vertexNormal != null);
            return;
        }
        this.m_bShowLighting = this.m_bShowLighting && this.m_vertexNormal != null;
        this.m_bShowSmoothLighting = false;
    }

    private void drawString(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        if (string == null || string.equals("")) {
            return;
        }
        int[] nArray = this.m_labelAttribute[n5].m_data;
        Font font = null;
        int n6 = this.m_offFac / PS_ZOOM;
        int n7 = (int)this.m_labelSize.getEntry(n5);
        if (this.m_labelFont[n5] != null) {
            font = new Font(this.m_labelFont[n5], this.m_labelStyle.getEntry(n5), n7 * n6);
        } else {
            font = PsConfig.getFont(nArray[4]);
            if (n6 != 1) {
                font = new Font(font.getName(), font.getStyle(), font.getSize() * n6);
            }
        }
        graphics.setFont(font);
        int n8 = 0;
        int n9 = 0;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (nArray[2] == 0) {
            n8 = n4;
        } else if (nArray[2] == 1) {
            n8 = -fontMetrics.stringWidth(string) * PS_ZOOM / 2;
        } else if (nArray[2] == 2) {
            n8 = -fontMetrics.stringWidth(string) * PS_ZOOM - n4;
        }
        if (nArray[3] == 2) {
            n9 = 2 * fontMetrics.getHeight() * PS_ZOOM / 3 + n4;
        } else if (nArray[3] == 1) {
            n9 = fontMetrics.getHeight() * PS_ZOOM / 3;
        } else if (nArray[3] == 0) {
            n9 = -n4;
        }
        if (this.m_bEnableZBuffer) {
            int n10 = (int)(1.1f * (float)fontMetrics.stringWidth(string));
            int n11 = (int)(1.5f * (float)fontMetrics.getHeight());
            boolean bl = false;
            if (n10 > this.m_widthString) {
                bl = true;
                this.m_widthString = n10;
            } else if (n11 > this.m_heightString) {
                bl = true;
                this.m_heightString = n11;
            }
            if (PsConfig.getOSId() != 0 && this.m_widthString * this.m_heightString <= 2730) {
                this.m_widthString = (int)(Math.ceil(2731.0f / (float)this.m_heightString) + 1.0);
                bl = true;
            }
            if (bl || this.m_imageString == null) {
                this.createImageString();
            }
            this.clearImageString(Color.black);
            Color color = this.m_labelColor[n5];
            if (n5 == 5 || n5 == 6) {
                color = PdColor.getXORColor(this.m_backColor, this.m_labelColor[n5], Color.white, 60);
            }
            int n12 = color.getRGB();
            if (this.m_gImageString.getFont() != font) {
                this.m_gImageString.setFont(font);
            }
            this.m_gImageString.drawString(string, 0, this.m_heightString >> 1);
            try {
                this.m_pgString = new PixelGrabber(this.m_imageString, 0, 0, this.m_widthString, this.m_heightString, this.m_pixString, 0, this.m_widthString);
                this.m_pgString.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            int n13 = 0;
            int n14 = this.m_pixData.length - 2 * this.m_widthString;
            int n15 = n + nArray[0] * this.m_offFac + n8;
            int n16 = n2 + nArray[1] * this.m_offFac + n9 + (this.m_heightString >> 1);
            int n17 = 0;
            while (n17 < this.m_heightString) {
                int n18 = n16 - (this.m_heightString - n17);
                int n19 = n15;
                int n20 = n18 * this.m_dispSize.width + n19;
                if (n20 >= 0 && n20 <= n14) {
                    int n21 = 0;
                    while (n21 < this.m_widthString) {
                        if (n19 >= 0 && n19 < this.m_dispSize.width && this.m_pixString[n13] != m_colorWhite) {
                            int n22 = this.m_pixString[n13] >> 16 & 0xFF;
                            boolean bl2 = n3 + this.m_zTol > this.m_zBuffer[n18][n19];
                            int n23 = n12;
                            if (this.m_bShowTransparency) {
                                this.m_pixData[n20] = n23 = this.drawPixel(this.m_pixData[n20], n12, n22, this.m_alpha, bl2, n19, n18);
                                this.m_zBuffer[n18][n19] = n3;
                            } else if (bl2) {
                                int n24 = this.m_pixData[n20];
                                int n25 = n22;
                                int n26 = (n24 >> 16 & 0xFF) * n25;
                                int n27 = (n24 >> 8 & 0xFF) * n25;
                                int n28 = (n24 & 0xFF) * n25;
                                if (bl2) {
                                    n26 += (n23 >> 16 & 0xFF) * (255 - n25);
                                    n27 += (n23 >> 8 & 0xFF) * (255 - n25);
                                    n28 += (n23 & 0xFF) * (255 - n25);
                                }
                                n26 = n26 << 8 & 0xFF0000;
                                n28 = n28 >> 8 & 0xFF;
                                this.m_pixData[n20] = n23 = this.m_alpha | n26 | (n27 &= 0xFF00) | n28;
                                this.m_zBuffer[n18][n19] = n3;
                            }
                        }
                        ++n19;
                        ++n20;
                        ++n13;
                        ++n21;
                    }
                }
                ++n17;
            }
            if (bl) {
                this.setOffFac(this.m_offFac);
                return;
            }
        } else {
            if (n5 == 5 || n5 == 6) {
                graphics.setColor(PdColor.getXORColor(this.m_backColor, this.m_labelColor[n5], Color.white, 60));
            } else {
                graphics.setColor(this.m_labelColor[n5]);
            }
            graphics.drawString(string, n + nArray[0] * this.m_offFac + n8, n2 + nArray[1] * this.m_offFac + n9);
        }
    }

    public void setDimOfVertices(int n) {
        if (this.m_dim == n) {
            return;
        }
        super.setDimOfVertices(n);
        this.m_bndBox = PdVector.realloc(this.m_bndBox, 2, this.m_dim);
        if (this.m_elemCenter != null) {
            this.m_elemCenter.setSize(this.m_dim);
        }
        if (this.vtSrc1 != null) {
            this.vtSrc1.setSize(this.m_dim + 1);
        }
        if (this.vtSrc != null) {
            this.vtSrc.setSize(this.m_dim);
        }
        if (this.m_vtSrc != null) {
            this.m_vtSrc.setSize(this.m_dim);
        }
    }

    protected void setLights(PvLight[] pvLightArray) {
        this.m_light = pvLightArray;
        this.m_bHasHighlight = false;
        if (this.m_light == null || this.m_light.length == 0) {
            return;
        }
        int n = 0;
        while (n < this.m_light.length) {
            if (this.m_light[n].m_bSwitchedOn && pvLightArray[n].isHighlight()) {
                this.m_bHasHighlight = true;
                return;
            }
            ++n;
        }
    }

    protected boolean tagVertices(Rectangle rectangle, int n) {
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            if (rectangle.contains(this.m_vertexTrans[n2].m_data[0], this.m_vertexTrans[n2].m_data[1])) {
                this.m_vertex[n2].setTag(n);
                this.m_geometry.setTagVertex(n2, n);
            }
            ++n2;
        }
        return true;
    }

    private void drawElementEdges(Graphics graphics, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, PdVector[] pdVectorArray) {
        int n3;
        int n4;
        int n5;
        boolean bl;
        if (n2 < 2) {
            return;
        }
        double d = this.m_globalEdgeSize * (double)this.m_offFac;
        int n6 = (int)(d + 0.5);
        if (this.m_bShowEdgeAura && !this.m_bShowElements) {
            int n7;
            graphics.setColor(this.m_backColor);
            int n8 = this.m_backColor.getRGB();
            bl = this.m_bShowSmoothShading;
            n5 = this.m_bEnable3DLook;
            n4 = this.m_bShowLighting;
            this.m_bShowSmoothShading = false;
            this.m_bEnable3DLook = false;
            this.m_bShowLighting = false;
            if (this.m_bEnableZBuffer) {
                n3 = this.m_bShowDepthcue ? 1 : 0;
                this.m_bShowDepthcue = false;
                if (this.m_bAdaptiveSize && n2 >= 3) {
                    float f = this.getAdaptiveScale((float)(nArray3[0] + nArray3[1] + nArray3[2]) / 3.0f);
                    if ((double)f < 0.0) {
                        return;
                    }
                    n6 = (int)(d * (double)f + 0.5);
                } else {
                    n6 = (int)(d + 0.5);
                }
                n7 = Math.max(2 * this.m_offFac, n6);
                this.drawPolygonOneSide(graphics, n7, nArray, nArray2, nArray3, n2, !this.isBackElementCulled(n), n8);
                this.m_bShowDepthcue = n3;
            } else {
                if (this.m_bAdaptiveSize && n2 >= 3) {
                    float f = this.getAdaptiveScale((float)(nArray3[0] + nArray3[1] + nArray3[2]) / 3.0f);
                    if ((double)f < 0.0) {
                        return;
                    }
                    n6 = (int)(d * (double)f + 0.5);
                } else {
                    n6 = (int)(d + 0.5);
                }
                n7 = Math.max(2 * this.m_offFac, n6);
                this.drawPolygonOneSide(graphics, n7, nArray, nArray2, nArray3, n2, !this.isBackElementCulled(n), n8);
            }
            this.m_bShowLighting = n4;
            this.m_bEnable3DLook = n5;
            this.m_bShowSmoothShading = bl;
        }
        Color color = this.getEdgeColor_(n, -1);
        if (this.m_bShowLighting && this.m_elementNormal != null) {
            this.renderLight(this.m_vertex[this.m_element[n].m_data[0]], this.m_elementNormal[n], this.m_light);
            color = this.attenuateColor(color, this.m_lightAttMat, this.m_lightAttSpec);
        }
        boolean bl2 = bl = this.m_bShowSilhouette && this.m_bHasNeighbours && this.m_elementNormal != null && (!this.m_bEnableClip || !this.m_bElemIsClipped);
        if (this.m_bShowSmoothShading) {
            n5 = 0;
            while (n5 < n2) {
                this.cvTmp[n5] = this.m_cv[n5];
                ++n5;
            }
        }
        n5 = 0;
        while (n5 < n2) {
            block34: {
                int n9;
                block38: {
                    block37: {
                        block35: {
                            int n10;
                            double d2;
                            Color color2;
                            block36: {
                                block33: {
                                    n4 = -1;
                                    if (this.m_bElemIsClipped || !this.m_bHasNeighbours) break block33;
                                    n4 = this.m_neighbour[n].m_data[n5];
                                    if (this.m_bShowEdgeOnce && this.m_bEnableZBuffer && this.m_bEnable3DLook && n4 > n) break block34;
                                }
                                n3 = (n5 + 1) % n2;
                                n9 = (n5 + 2) % n2;
                                if (!bl || n4 == -1 || this.isBackElementCulled(n) == this.isBackElementCulled(n4)) break block35;
                                if (n4 >= this.m_numElements) break block34;
                                color2 = this.m_globalBndColor;
                                if (this.m_bDepthcueEdge) {
                                    color2 = this.m_bEnable3DLook || this.m_bShowElements ? PdColor.getDimmedColor(color2, (double)this.m_heightFac, (double)this.m_heightFac) : PdColor.getDimmedColor(color2, (double)this.m_heightFac, (double)this.m_grey * (1.0 - (double)this.m_heightFac));
                                }
                                if (this.m_bShowSmoothShading) {
                                    int n11 = color2.getRGB();
                                    this.cvTmpOne[0] = n11 >> 16 & 0xFF;
                                    this.cvTmpOne[1] = n11 >> 8 & 0xFF;
                                    this.cvTmpOne[2] = n11 & 0xFF;
                                    this.m_cv[0] = this.cvTmpOne;
                                    this.m_cv[1] = this.cvTmpOne;
                                    this.m_cv[2] = this.cvTmpOne;
                                    this.m_cv[3] = this.cvTmpOne;
                                }
                                d2 = this.m_globalBndSize * (double)this.m_offFac;
                                if (!this.m_bAdaptiveSize) break block36;
                                float f = this.getAdaptiveScale((float)(nArray3[n3] + nArray3[n9]) / 2.0f);
                                if ((double)f < 0.0) break block34;
                                d2 *= (double)f;
                            }
                            if ((n10 = (int)(d2 + 0.5)) == 0 && d2 > 0.0) {
                                n10 = 1;
                            }
                            this.drawLineAny(graphics, n10, nArray[n3], nArray2[n3], nArray3[n3], nArray[n9], nArray2[n9], nArray3[n9], color2, color2, n10 > 3 * this.m_offFac);
                            break block34;
                        }
                        if (!this.m_bShowEdges) break block34;
                        int n12 = this.m_element[n].m_data[0];
                        if (!this.m_bElemIsClipped) {
                            n12 = this.m_element[n].m_data[n3];
                        }
                        if (this.m_bShowSmoothShading) {
                            if (this.m_bShowEdgeColorFromElements) {
                                this.m_cv[0] = this.cvTmp[n3];
                                this.m_cv[1] = this.cvTmp[n9];
                            } else {
                                color = this.getEdgeColor_(n, n12);
                                if (this.m_bShowLighting && this.m_vertexNormal != null) {
                                    this.renderLight(this.m_vertex[n12], this.m_vertexNormal[n12], this.m_light);
                                    color = this.attenuateColor(color, this.m_lightAttMat, this.m_lightAttSpec);
                                }
                                int n13 = color.getRGB();
                                this.cvTmpOne[0] = n13 >> 16 & 0xFF;
                                this.cvTmpOne[1] = n13 >> 8 & 0xFF;
                                this.cvTmpOne[2] = n13 & 0xFF;
                                this.m_cv[0] = this.cvTmpOne;
                                n12 = this.m_element[n].m_data[n9];
                                color = this.getEdgeColor_(n, n12);
                                if (this.m_bShowLighting && this.m_vertexNormal != null) {
                                    this.renderLight(this.m_vertex[n12], this.m_vertexNormal[n12], this.m_light);
                                    color = this.attenuateColor(color, this.m_lightAttMat, this.m_lightAttSpec);
                                }
                                n13 = color.getRGB();
                                this.cvTmpOne[0] = n13 >> 16 & 0xFF;
                                this.cvTmpOne[1] = n13 >> 8 & 0xFF;
                                this.cvTmpOne[2] = n13 & 0xFF;
                                this.m_cv[1] = this.cvTmpOne;
                            }
                            this.m_cv[2] = this.m_cv[1];
                            this.m_cv[3] = this.m_cv[0];
                        } else {
                            color = this.getEdgeColor_(n, n12);
                            if (this.m_bShowLighting && this.m_vertexNormal != null) {
                                this.renderLight(this.m_vertex[n12], this.m_vertexNormal[n12], this.m_light);
                                color = this.attenuateColor(color, this.m_lightAttMat, this.m_lightAttSpec);
                            } else if (this.m_bShowLighting && this.m_elementNormal != null) {
                                this.renderLight(this.m_elemCenter, this.m_elementNormal[n], this.m_light);
                                color = this.attenuateColor(color, this.m_lightAttMat, this.m_lightAttSpec);
                            }
                        }
                        if (this.m_bDepthcueEdge && !this.m_bEnableZBuffer) {
                            color = this.m_bEnable3DLook || this.m_bShowElements ? PdColor.getDimmedColor(color, (double)this.m_heightFac, (double)this.m_heightFac) : PdColor.getDimmedColor(color, (double)this.m_heightFac, (double)this.m_grey * (1.0 - (double)this.m_heightFac));
                        }
                        if (!this.m_bAdaptiveSize) break block37;
                        float f = this.getAdaptiveScale((float)(nArray3[n3] + nArray3[n9]) / 2.0f);
                        if ((double)f < 0.0) break block34;
                        n6 = (int)(d * (double)f + 0.5);
                        break block38;
                    }
                    n6 = (int)(d + 0.5);
                }
                if (n6 == 0 && d > 0.0) {
                    n6 = 1;
                }
                this.drawLineAny(graphics, n6, nArray[n3], nArray2[n3], nArray3[n3], nArray[n9], nArray2[n9], nArray3[n9], color, color, n6 > 3 * this.m_offFac);
            }
            ++n5;
        }
        if (this.m_bShowSmoothShading) {
            n5 = 0;
            while (n5 < n2) {
                this.m_cv[n5] = this.cvTmp[n5];
                ++n5;
            }
        }
    }

    private void drawElementVertices(Graphics graphics, int n, int n2, int[] nArray) {
        int n3 = 0;
        while (n3 < n2) {
            block5: {
                block6: {
                    if (nArray[n3] == -1) break block5;
                    if (!this.m_bShowBackface || !this.m_bShowEdgeOnce || !this.m_bHasNeighbours || this.m_bElemIsClipped || this.m_numUnusedVertices != 0) break block6;
                    int n4 = this.m_neighbour[n].m_data[(n3 - 2 + n2) % n2];
                    int n5 = this.m_neighbour[n].m_data[(n3 - 1 + n2) % n2];
                    if (n4 >= this.m_numElements || n5 >= this.m_numElements) {
                        PsDebug.warning("void neighbour information, invoke: makeNeighbour()!");
                        return;
                    }
                    if (n4 != -1 && (double)this.m_itemHeight < this.m_scene.getHeightOfElementInCurrentGeometry(n4) || n5 != -1 && (double)this.m_itemHeight < this.m_scene.getHeightOfElementInCurrentGeometry(n5)) break block5;
                }
                this.drawVertex(graphics, nArray[n3]);
            }
            ++n3;
        }
    }

    protected void projectVertices(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (this.m_numVertices == 0) {
            return;
        }
        this.m_zMin = Integer.MAX_VALUE;
        this.m_zMax = Integer.MIN_VALUE;
        bDebug = true;
        int n = 0;
        while (n < this.m_numVertices) {
            if (this.m_bModAmb) {
                this.project(this.m_vtMod, this.m_vertex[n], pdMatrix2, this.m_ambientMatrix);
            } else {
                this.m_vtMod.copyArray(this.m_vertex[n]);
            }
            boolean bl = this.project(this.m_vertexTrans[n], this.m_vtMod, pdMatrix);
            if (bl) {
                if (this.m_vertexTrans[n].m_data[2] < this.m_zMin) {
                    this.m_zMin = this.m_vertexTrans[n].m_data[2];
                }
                if (this.m_vertexTrans[n].m_data[2] > this.m_zMax) {
                    this.m_zMax = this.m_vertexTrans[n].m_data[2];
                }
            }
            ++n;
        }
        if (this.m_center != null) {
            if (this.m_bModAmb) {
                this.project(this.m_vtMod, this.m_center, pdMatrix2, this.m_ambientMatrix);
            } else {
                this.m_vtMod.copyArray(this.m_center);
            }
        } else {
            this.m_vtMod.setConstant(0.0);
        }
        this.project(this.m_centerTrans, this.m_vtMod, pdMatrix);
        bDebug = false;
    }

    protected void setMaxNumVertices(int n) {
        if (this.m_maxNumVertices == n) {
            return;
        }
        super.setMaxNumVertices(n);
        this.m_vertexTrans = PiVector.realloc(this.m_vertexTrans, n, this.m_dimTrans);
    }

    public boolean update(Object object) {
        int n;
        Object object2;
        int n2;
        if (object != this.m_geometry) {
            return false;
        }
        if (this.m_geometry == null) {
            PsDebug.warning("missing associated geometry");
            return false;
        }
        try {
            this.m_geometry.paint(this);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            PsDebug.outOfMemory(outOfMemoryError);
        }
        String string = this.m_geometry.getName();
        if (this.m_numPolygons > 0) {
            n2 = 0;
            while (n2 < this.m_numPolygons) {
                object2 = this.m_polygon[n2].m_data;
                n = 0;
                while (n < ((int[])object2).length) {
                    if (object2[n] < 0 || object2[n] >= this.m_numVertices) {
                        this.m_numPolygons = 0;
                        this.m_usePolygons = false;
                        PsDebug.error("geometry[" + string + "] has polygon which refers a void vertex,\n" + "\tpolygon[" + n2 + "].m_data[" + n + "]==" + (int)object2[n]);
                        return false;
                    }
                    ++n;
                }
                n2 += 1;
            }
        }
        if (this.m_numElements > 0) {
            n2 = 0;
            while (n2 < this.m_numElements) {
                object2 = this.m_element[n2].m_data;
                n = 0;
                while (n < ((int[])object2).length) {
                    if (object2[n] < 0 || object2[n] >= this.m_numVertices) {
                        this.m_numElements = 0;
                        this.m_useElements = false;
                        PsDebug.error("geometry[" + string + "] has element which refers a void vertex,\n" + "\telement[" + n2 + "].m_data[" + n + "]==" + (int)object2[n]);
                        return false;
                    }
                    ++n;
                }
                n2 += 1;
            }
        }
        if (!this.getName().startsWith(string)) {
            this.setName(string + "_Container");
        }
        this.getBounds(true);
        if (this.m_bShowTaggedVertices) {
            this.m_bHasTaggedVertices = false;
            n2 = 0;
            while (n2 < this.m_numVertices) {
                object2 = this.m_vertex[n2];
                if (((P_Vector)object2).hasTag(1) || ((P_Vector)object2).hasTag(11) || ((P_Vector)object2).hasTag(12) || ((P_Vector)object2).getURL() != null) {
                    this.m_bHasTaggedVertices = true;
                    break;
                }
                n2 += 1;
            }
        }
        if (this.m_bShowTaggedPolygons) {
            this.m_bHasTaggedPolygons = false;
            n2 = 0;
            while (n2 < this.m_numPolygons) {
                object2 = this.m_polygon[n2];
                if (((P_Vector)object2).hasTag(1) || ((P_Vector)object2).hasTag(11) || ((P_Vector)object2).hasTag(12) || ((P_Vector)object2).getURL() != null) {
                    this.m_bHasTaggedPolygons = true;
                    break;
                }
                n2 += 1;
            }
        }
        if (this.m_bShowTaggedElements) {
            this.m_bHasTaggedElements = false;
            n2 = 0;
            while (n2 < this.m_numElements) {
                object2 = this.m_element[n2];
                if (((P_Vector)object2).hasTag(1) || ((P_Vector)object2).hasTag(11) || ((P_Vector)object2).hasTag(12) || ((P_Vector)object2).getURL() != null) {
                    this.m_bHasTaggedElements = true;
                    break;
                }
                n2 += 1;
            }
        }
        this.m_numUnusedVertices = 0;
        if (this.m_numVertices > 0 && this.m_bShowVertices && (this.m_numElements > 0 || this.m_numPolygonEdges > 0)) {
            this.updateUnusedVertices();
        }
        this.m_useVertices = false;
        this.m_useUnusedVertices = false;
        this.m_useElements = false;
        this.m_usePolygons = false;
        this.m_bShowVectors = false;
        if (this.m_bShowVectorFields) {
            n2 = 0;
            while (n2 < this.m_numVectorFields) {
                if (this.m_bShowVectorField[n2]) {
                    this.m_bShowVectors = true;
                    break;
                }
                n2 += 1;
            }
        }
        if (this.m_numElements == 0 && this.m_numPolygonEdges == 0 && (this.m_bShowVertices || this.m_bShowTaggedVertices && this.m_bHasTaggedVertices || this.m_bShowVertexNormals || this.m_bShowVectors) || (this.m_numElements > 0 && !this.m_bShowElements && !this.m_bShowEdges && !this.m_bShowBoundaries && !this.m_bShowElementNormals && !this.m_bShowVectors && !this.m_bShowPolygons || this.m_numPolygonEdges > 0 && !this.m_bShowPolygons && !this.m_bShowPolygonNormals) && (this.m_bShowVertices || this.m_bShowTaggedVertices && this.m_bHasTaggedVertices || this.m_bShowVertexNormals || this.m_bShowVectors)) {
            this.m_useVertices = true;
        } else if (this.m_bShowVertices && this.m_numUnusedVertices > 0 && (this.m_numElements > 0 || this.m_numPolygonEdges > 0)) {
            this.m_useUnusedVertices = true;
        }
        if (this.m_numPolygonEdges > 0 && (this.m_bShowPolygons || this.m_bShowTaggedPolygons && this.m_bHasTaggedPolygons || this.m_bShowPolygonNormals)) {
            this.m_usePolygons = true;
        }
        if (this.m_numElements > 0 && (this.m_bShowElements || this.m_bShowEdges || this.m_bShowSilhouette || this.m_bShowBoundaries || this.m_bShowElementNormals || this.m_bShowVectors || this.m_bShowTaggedElements && this.m_bHasTaggedElements || this.m_bShowTaggedEdges && this.m_bHasTaggedEdges)) {
            this.m_useElements = true;
            if (this.m_neighbour == null || this.m_neighbour.length < this.m_numElements || this.m_neighbour[0] == null || this.m_neighbour[0].getSize() != this.m_element[0].getSize()) {
                this.m_bHasNeighbours = false;
            }
        }
        if (this.m_bShowVertexColors && this.m_vertexColor == null) {
            this.m_bShowVertexColors = false;
        }
        if (this.m_bInduceElementFromVertexColors && this.m_vertexColor == null) {
            this.m_bInduceElementFromVertexColors = false;
        }
        if (this.m_bShowPolygonColors && this.m_polygonColor == null && !this.m_bInduceElementFromVertexColors) {
            this.m_bShowPolygonColors = false;
        }
        if (this.m_bShowElementColors && this.m_elementColor == null && !this.m_bInduceElementFromVertexColors) {
            this.m_bShowElementColors = false;
        }
        if (this.m_bShowElementBackColors && this.m_elementBackColor == null) {
            this.m_bShowElementBackColors = false;
        }
        if (this.m_bShowEdgeColors && this.m_elementColor == null && this.m_vertexColor == null) {
            this.m_bShowEdgeColors = false;
        }
        if (this.m_bShowEdgeColorFromElements && this.m_elementColor == null) {
            this.m_bShowEdgeColorFromElements = false;
        }
        if (this.m_bShowVertexTexture && this.m_vertexTexture == null) {
            this.m_bShowVertexTexture = false;
        }
        if (this.m_bShowElementTexture && this.m_elementTexture == null) {
            this.m_bShowElementTexture = false;
        }
        this.m_bShowTexture = (this.m_bShowVertexTexture || this.m_bShowElementTexture) && this.m_texturePix != null;
        this.assureTexture(this.m_bShowTexture);
        if (!(this.m_bShowBackface || this.m_elementNormal != null && this.m_elementNormal.length >= this.m_numElements)) {
            this.m_bShowBackface = true;
            PsDebug.warning("missing normals, backelement culling switched off");
        }
        n2 = 0;
        if (this.m_usePolygons) {
            n2 = !this.m_bShowSmoothElementColors || !this.m_bShowPolygonColors && !this.m_bInduceElementFromVertexColors ? 0 : 1;
        } else if (this.m_useElements) {
            n2 = !this.m_bShowSmoothElementColors || !this.m_bShowElementColors && !this.m_bInduceElementFromVertexColors ? 0 : 1;
        }
        this.setState(98, n2 != 0);
        if (this.m_bShowSmoothShading && !this.m_bInduceElementFromVertexColors) {
            if (this.m_usePolygons) {
                this.makeInducedVertexColorsFromElementColors(this.m_numPolygons, this.m_polygon, this.m_polygonColor);
            } else if (this.m_useElements) {
                this.makeInducedVertexColorsFromElementColors(this.m_numElements, this.m_element, this.m_elementColor);
            } else {
                this.m_vertexColorFromElement = null;
            }
        } else {
            this.m_vertexColorFromElement = null;
        }
        this.m_bHasCreaseEdge = false;
        if ((this.m_bShowSmoothShading || this.m_bShowSmoothLighting) && this.m_creaseAngle <= Math.PI && this.m_numElements > 0 && this.m_elementNormal != null && this.m_bHasNeighbours) {
            if (this.m_bCreaseEdge == null || this.m_bCreaseEdge.length != this.m_numVertices) {
                this.m_bCreaseEdge = new boolean[this.m_numVertices];
            }
            int n3 = 0;
            while (n3 < this.m_numVertices) {
                this.m_bCreaseEdge[n3] = false;
                ++n3;
            }
            double d = Math.cos(this.m_creaseAngle);
            int n4 = 0;
            while (n4 < this.m_numElements) {
                int n5 = this.m_element[n4].getSize();
                int n6 = 0;
                while (n6 < n5) {
                    int n7 = this.m_neighbour[n4].m_data[n6];
                    if (n7 >= n4) {
                        boolean bl;
                        double d2 = PdVector.dot(this.m_elementNormal[n4], this.m_elementNormal[n7]);
                        boolean bl2 = bl = d2 <= d;
                        if (bl) {
                            this.m_bCreaseEdge[this.m_element[n4].m_data[(n6 + 1) % n5]] = true;
                            this.m_bCreaseEdge[this.m_element[n4].m_data[(n6 + 2) % n5]] = true;
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
            n4 = 0;
            while (n4 < this.m_numVertices) {
                if (this.m_bCreaseEdge[n4]) {
                    this.m_bHasCreaseEdge = true;
                    break;
                }
                ++n4;
            }
        } else {
            this.m_bCreaseEdge = null;
        }
        return true;
    }

    protected void drawTitle(Graphics graphics) {
        String string;
        if (!this.m_bShowName && !this.m_bShowTitle) {
            return;
        }
        if (this.m_bShowTitle && this.m_geometry.getTitle() != null) {
            string = this.m_geometry.getTitle();
            this.drawString(graphics, string, this.m_bndBoxTrans[0].m_data[0], this.m_bndBoxTrans[1].m_data[1], 0, 0, 6);
        }
        if (this.m_bShowName && this.m_geometry.getName() != null) {
            string = this.m_geometry.getName();
            this.drawString(graphics, string, this.m_bndBoxTrans[1].m_data[0], this.m_bndBoxTrans[1].m_data[1], 0, 0, 5);
        }
    }

    public void clearTagPolygon(int n, int n2) {
        this.m_polygon[n].clearTag(n2);
        this.m_geometry.clearTagPolygon(n, n2);
    }

    private void drawPolygon(Graphics graphics, int n) {
        int n2;
        block42: {
            int n3;
            Color color;
            int n4;
            double d;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            boolean bl;
            boolean bl2;
            int n10;
            block43: {
                boolean bl3;
                n10 = this.m_edgePolygon.getEntry(n);
                n -= this.m_edgeOffset.getEntry(n);
                if (n10 == this.m_numPolygons) {
                    PsDebug.warning("edgeInd = " + n + " out of bounds.");
                    return;
                }
                bl2 = n == 0;
                bl = n == this.m_polygon[n10].getSize() - 2;
                n9 = 2;
                this.m_bElemIsClipped = false;
                if (this.m_bIsClippable && this.m_bEnableClipBounds && this.m_clipBounds != null) {
                    n2 = 0;
                    while (n2 < n9) {
                        this.project(this.m_vd[n2], this.m_vertex[this.m_polygon[n10].m_data[n + n2]], this.m_modelMatrix, this.m_ambientMatrix);
                        ++n2;
                    }
                    n2 = 0;
                    n8 = 0;
                    n7 = 0;
                    n6 = 0;
                    do {
                        n5 = 0;
                        while (n5 < n9) {
                            if (this.m_vd[n5].m_data[n6] < this.m_clipBounds[0].m_data[n6] - 1.0E-10) {
                                ++n8;
                            }
                            if (this.m_vd[n5].m_data[n6] > this.m_clipBounds[1].m_data[n6] + 1.0E-10) {
                                ++n7;
                            }
                            ++n5;
                        }
                        if (n8 == n9 || n7 == n9) {
                            return;
                        }
                        n2 = n8 + n7;
                    } while (++n6 < 3);
                    this.m_bElemIsClipped = false;
                    if (n2 != 0) {
                        this.m_tPos[0] = 0.0;
                        this.m_tPos[1] = 1.0;
                        n6 = 0;
                        do {
                            if (this.m_clipBounds[0].m_data[n6] > this.m_clipBounds[1].m_data[n6]) continue;
                            this.clipPolygon3D(this.m_vd, this.m_tPos, n6, this.m_clipBounds[0].m_data[n6], this.m_clipBounds[1].m_data[n6]);
                            if (!(this.m_tPos[0] > 1.0) && !(this.m_tPos[1] < 0.0)) continue;
                            return;
                        } while (++n6 < 3);
                        this.m_bElemIsClipped = true;
                        n6 = 0;
                        while (n6 < n9) {
                            if (this.m_tPos[n6] != (double)n6) {
                                this.m_vtMod.blend(1.0 - this.m_tPos[n6], this.m_vd[0], this.m_tPos[n6], this.m_vd[1]);
                                this.project(this.m_elemCenterTrans, this.m_vtMod, this.m_display.getTransMatrix(1));
                                this.m_xv[n6] = this.m_elemCenterTrans.m_data[0];
                                this.m_yv[n6] = this.m_elemCenterTrans.m_data[1];
                                this.m_zv[n6] = this.m_elemCenterTrans.m_data[2];
                            } else {
                                n5 = this.m_polygon[n10].m_data[n + n6];
                                this.m_xv[n6] = this.m_vertexTrans[n5].m_data[0];
                                this.m_yv[n6] = this.m_vertexTrans[n5].m_data[1];
                                this.m_zv[n6] = this.m_vertexTrans[n5].m_data[2];
                            }
                            this.m_origInd[n6] = this.m_polygon[n10].m_data[n + n6];
                            ++n6;
                        }
                    }
                }
                if (!this.m_bElemIsClipped) {
                    if (this.m_bIsClippable && this.m_bEnableClipCamera) {
                        this.m_bElemIsClipped = false;
                        n9 = this.clipPolygon(n10, n, this.m_xv, this.m_yv, this.m_zv, this.m_origInd);
                        if (n9 == 0) {
                            return;
                        }
                    } else {
                        n2 = 0;
                        while (n2 < n9) {
                            n8 = this.m_polygon[n10].m_data[n + n2];
                            this.m_xv[n2] = this.m_vertexTrans[n8].m_data[0];
                            this.m_yv[n2] = this.m_vertexTrans[n8].m_data[1];
                            this.m_zv[n2] = this.m_vertexTrans[n8].m_data[2];
                            if (this.m_bAutoClip && this.m_zv[n2] > this.m_autoClip) {
                                return;
                            }
                            this.m_origInd[n2] = n8;
                            ++n2;
                        }
                    }
                }
                n2 = this.m_useVertices || !this.m_bShowVertices && (!this.m_bShowTaggedVertices || !this.m_bHasTaggedVertices) && !this.m_bShowVertexNormals && !this.m_bShowVectors ? 0 : 1;
                n8 = !this.m_bShowTaggedPolygons || !this.m_bHasTaggedPolygons || !this.m_polygon[n10].hasTag(12) ? 0 : 1;
                n7 = !this.m_bShowTaggedPolygons || !this.m_bHasTaggedPolygons || !this.m_polygon[n10].hasTag(11) ? 0 : 1;
                n6 = !this.m_bShowTaggedPolygons || !this.m_bHasTaggedPolygons || !this.m_polygon[n10].hasTag(1) ? 0 : 1;
                n5 = this.m_polygon[n10].getURL() == null ? 0 : 1;
                boolean bl4 = bl3 = this.m_bShowPolygons || n8 != 0 || n7 != 0 || n6 != 0 || n5 != 0;
                if (!bl3) break block42;
                d = this.getPolygonSize(n10, n8 != 0, n7 != 0, n6 != 0, n5 != 0);
                if (!this.m_bAdaptiveSize) break block43;
                n4 = this.m_polygon[n10].m_data[n];
                float f = this.getAdaptiveScale(this.m_vertexTrans[n4].m_data[2]);
                if ((double)f < 0.0) break block42;
                d *= (double)f;
            }
            n4 = (int)(d + 0.5);
            int n11 = (int)(2.0 * d + 0.5);
            if (n4 == 0 && d > 0.0) {
                n4 = 1;
            }
            if (n11 == 0 && d > 0.0) {
                n11 = 1;
            }
            Color color2 = color = this.getPolygonColor(n10, n, n8 != 0, n7 != 0, n6 != 0, n5 != 0);
            if (this.m_bShowLighting && !this.m_bShowSmoothLighting && this.m_vertexNormal != null) {
                n3 = this.m_polygon[n10].m_data[n];
                this.renderLight(this.m_vertex[n3], this.m_vertexNormal[n3], this.m_light);
                color = this.attenuateColor(color, this.m_lightAttMat, this.m_lightAttSpec);
            }
            if (n4 > 0) {
                int n12;
                double d2;
                int n13;
                if (this.m_bShowSmoothShading) {
                    n3 = 0;
                    while (n3 < n9) {
                        Color color3 = this.getPolygonColor(n10, n + n3, n8 != 0, n7 != 0, n6 != 0, n5 != 0);
                        n13 = color3.getRGB();
                        if (n3 == 1) {
                            color2 = color3;
                        }
                        int n14 = n13 >> 16 & 0xFF;
                        this.m_cv[3 - n3][0] = n14;
                        this.m_cv[n3][0] = n14;
                        int n15 = n13 >> 8 & 0xFF;
                        this.m_cv[3 - n3][1] = n15;
                        this.m_cv[n3][1] = n15;
                        int n16 = n13 & 0xFF;
                        this.m_cv[3 - n3][2] = n16;
                        this.m_cv[n3][2] = n16;
                        ++n3;
                    }
                }
                if (this.m_bShowEdgeAura) {
                    this.m_bDepthcueEdge = false;
                    n3 = this.m_bShowSmoothShading ? 1 : 0;
                    boolean bl5 = this.m_bEnable3DLook;
                    n13 = this.m_bShowLighting;
                    this.m_bShowSmoothShading = false;
                    this.m_bEnable3DLook = false;
                    this.m_bShowLighting = false;
                    this.drawLineAny(graphics, Math.max(4 * this.m_offFac, n11), this.m_xv[0], this.m_yv[0], this.m_zv[0] - 30, this.m_xv[1], this.m_yv[1], this.m_zv[1] - 30, this.m_backColor, this.m_backColor, false);
                    this.m_bShowLighting = n13;
                    this.m_bEnable3DLook = bl5;
                    this.m_bShowSmoothShading = n3;
                }
                this.m_bDepthcueEdge = true;
                if ((this.m_bShowPolygonStartArrow || this.m_bShowPolygonEndArrow) && (d2 = Math.sqrt((n3 = this.m_xv[1] - this.m_xv[0]) * n3 + (n12 = this.m_yv[1] - this.m_yv[0]) * n12)) > 1.0E-10) {
                    int n17 = 0;
                    do {
                        if ((!bl2 || n17 != 0 || !this.m_bShowPolygonStartArrow) && (!bl || n17 != 1 || !this.m_bShowPolygonEndArrow)) continue;
                        int n18 = this.m_polygon[n10].m_data[n + n17];
                        boolean bl6 = this.m_bShowTaggedVertices && this.m_bHasTaggedVertices && this.m_vertex[n18].hasTag(12);
                        boolean bl7 = this.m_bShowTaggedVertices && this.m_bHasTaggedVertices && this.m_vertex[n18].hasTag(11);
                        boolean bl8 = this.m_bShowTaggedVertices && this.m_bHasTaggedVertices && this.m_vertex[n18].hasTag(1);
                        double d3 = this.getVertexSize(n18, bl6, bl7, bl8, false);
                        if (this.m_bAdaptiveSize) {
                            float f = this.getAdaptiveScale(this.m_vertexTrans[n18].m_data[2]);
                            if ((double)f < 0.0) break block42;
                            d3 *= (double)f;
                        }
                        double d4 = d3 + (double)n4 / 2.0 - 1.0;
                        if (n17 == 1) {
                            d4 = -d4;
                        }
                        if (d4 == 0.0) continue;
                        int n19 = n17;
                        this.m_xv[n19] = (int)((double)this.m_xv[n19] + (double)n3 * d4 / d2);
                        int n20 = n17;
                        this.m_yv[n20] = (int)((double)this.m_yv[n20] + (double)n12 * d4 / d2);
                    } while (++n17 < 2);
                }
                n3 = n2 != 0 || n4 <= 3 * this.m_offFac ? 0 : 1;
                this.drawLineAny(graphics, n4, this.m_xv[0], this.m_yv[0], this.m_zv[0], this.m_xv[1], this.m_yv[1], this.m_zv[1], color, color2, n3 != 0);
                if (this.m_bShowPolygonEndArrow && bl) {
                    this.drawVectorTipAny(graphics, n4, this.m_xv[0], this.m_yv[0], this.m_zv[0], this.m_xv[1], this.m_yv[1], this.m_zv[1], false, color2);
                }
                if (this.m_bShowPolygonStartArrow && bl2) {
                    this.drawVectorTipAny(graphics, n4, this.m_xv[1], this.m_yv[1], this.m_zv[1], this.m_xv[0], this.m_yv[0], this.m_zv[0], false, color);
                }
            }
            if (this.m_bShowIndices || this.m_bShowPolygonLabels || this.m_bShowEdgeLabels) {
                String string = this.m_polygon[n10].getName();
                if (string == null && this.m_bEnabledIndexLabels) {
                    string = this.m_bShowPolygonLabels ? String.valueOf(n10) : "";
                    if (this.m_bShowEdgeLabels) {
                        if (this.m_bShowPolygonLabels) {
                            string = string + ",";
                        }
                        string = string + String.valueOf(n);
                    }
                }
                if (string != null) {
                    this.drawString(graphics, string, (this.m_xv[0] + this.m_xv[1]) / 2, (this.m_yv[0] + this.m_yv[1]) / 2, (this.m_zv[0] + this.m_zv[1]) / 2, n4 >> 1, 2);
                }
            }
        }
        if (n2 != 0) {
            int n21 = 0;
            do {
                if (this.m_origInd[n21] == -1) continue;
                this.drawVertex(graphics, this.m_origInd[n21]);
            } while (++n21 < 2);
        }
    }

    public boolean setLabelAttributes(PiVector[] piVectorArray) {
        PiVector.copy(this.m_labelAttribute, 0, piVectorArray, 0, piVectorArray.length);
        return true;
    }

    public PdVector[] getBounds(boolean bl) {
        boolean bl2;
        if (this.m_numVertices == 0) {
            return null;
        }
        PdVector[] pdVectorArray = super.getBounds();
        this.m_bndBox[0].copyArray(pdVectorArray[0]);
        this.m_bndBox[1].copyArray(pdVectorArray[1]);
        boolean bl3 = this.hasModelMatrix();
        boolean bl4 = this.hasAmbientMatrix();
        boolean bl5 = bl2 = bl3 || bl4 || this.m_ambientSpace != 3 && this.m_ambientSpace != 1;
        if (!bl2) {
            return pdVectorArray;
        }
        PdVector pdVector = (PdVector)pdVectorArray[0].clone();
        PdVector pdVector2 = (PdVector)pdVectorArray[1].clone();
        pdVector.setConstant(Double.MAX_VALUE);
        pdVector2.setConstant(Double.NEGATIVE_INFINITY);
        this.m_vt.setConstant(0.0);
        int n = 0;
        while (n < this.m_numVertices) {
            if (bl2) {
                this.m_vtSrc.copyArray(this.m_vertex[n]);
                this.project(this.m_vtMod, this.m_vtSrc, this.m_modelMatrix, this.m_ambientMatrix);
            } else {
                this.m_vtMod.copyArray(this.m_vertex[n]);
            }
            int n2 = 0;
            while (n2 < this.m_dimTrans) {
                if (pdVector.m_data[n2] > this.m_vtMod.m_data[n2]) {
                    pdVector.m_data[n2] = this.m_vtMod.m_data[n2];
                }
                if (pdVector2.m_data[n2] < this.m_vtMod.m_data[n2]) {
                    pdVector2.m_data[n2] = this.m_vtMod.m_data[n2];
                }
                ++n2;
            }
            ++n;
        }
        n = this.m_dimTrans - 1;
        while (n >= this.m_dim) {
            this.m_bndBox[0].setEntry(n, 0.0);
            this.m_bndBox[1].setEntry(n, 0.0);
            --n;
        }
        return new PdVector[]{pdVector, pdVector2};
    }

    private int clipElement3D(int n, PdVector[] pdVectorArray, int[] nArray, PdVector[] pdVectorArray2, int[][] nArray2, float[][] fArray, int n2, float f, float f2) {
        int n3;
        PdVector[] pdVectorArray3 = this.m_vdClip;
        int[] nArray3 = this.m_origIndClip;
        PdVector[] pdVectorArray4 = this.m_texClip;
        int[][] nArray4 = this.m_cvClip;
        float[][] fArray2 = this.m_lvClip;
        int n4 = -2;
        int n5 = -1;
        int n6 = 1;
        float[] fArray3 = null;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n) {
            block38: {
                int n9;
                int n10;
                float f3;
                float f4;
                int n11;
                block39: {
                    n3 = n8;
                    n11 = (n8 + 1) % n;
                    int n12 = nArray[n3];
                    f4 = (float)pdVectorArray[n3].m_data[n2];
                    f3 = (float)pdVectorArray[n11].m_data[n2];
                    n10 = n6;
                    n9 = n6;
                    if (f4 < f) {
                        n10 = n4;
                    }
                    if (f4 > f2) {
                        n10 = n5;
                    }
                    if (f3 < f) {
                        n9 = n4;
                    }
                    if (f3 > f2) {
                        n9 = n5;
                    }
                    if (n10 != n6 || n9 != n6) {
                        this.m_bElemIsClipped = true;
                    }
                    if (n10 == n4 && n9 == n4 || n10 == n5 && n9 == n5) break block38;
                    if (n10 != n6) break block39;
                    if (n8 < n) {
                        int n13;
                        pdVectorArray3[n7].copyArray(pdVectorArray[n3]);
                        if (pdVectorArray2 != null) {
                            pdVectorArray4[n7].copyArray(pdVectorArray2[n8]);
                        }
                        if (nArray2 != null && nArray4 != null) {
                            n13 = 0;
                            do {
                                nArray4[n7][n13] = nArray2[n8][n13];
                            } while (++n13 < 3);
                        }
                        if (fArray != null && fArray2 != null) {
                            n13 = 0;
                            do {
                                fArray2[n7][n13] = fArray[n8][n13];
                            } while (++n13 < 6);
                        }
                        nArray3[n7] = n12;
                        ++n7;
                    }
                    if (n9 == n6) break block38;
                }
                if (fArray3 == null) {
                    fArray3 = new float[2];
                }
                PdVector pdVector = null;
                PdVector pdVector2 = null;
                if (pdVectorArray2 != null) {
                    pdVector = pdVectorArray2[n3];
                    pdVector2 = pdVectorArray2[n11];
                }
                int[] nArray5 = null;
                int[] nArray6 = null;
                if (nArray2 != null) {
                    nArray5 = nArray2[n3];
                    nArray6 = nArray2[n11];
                }
                float[] fArray4 = null;
                float[] fArray5 = null;
                if (fArray != null) {
                    fArray4 = fArray[n3];
                    fArray5 = fArray[n11];
                }
                int n14 = 1;
                if (n10 == n6 && n9 == n4 || n10 == n4 && n9 == n6) {
                    fArray3[0] = (f4 - f) / (f4 - f3);
                } else if (n10 == n6 && n9 == n5 || n10 == n5 && n9 == n6) {
                    fArray3[0] = (f4 - f2) / (f4 - f3);
                } else if (n10 == n4 && n9 == n5) {
                    fArray3[0] = (f4 - f) / (f4 - f3);
                    fArray3[1] = (f4 - f2) / (f4 - f3);
                    n14 = 2;
                } else if (n10 == n5 && n9 == n4) {
                    fArray3[0] = (f4 - f2) / (f4 - f3);
                    fArray3[1] = (f4 - f) / (f4 - f3);
                    n14 = 2;
                }
                int n15 = 0;
                while (n15 < n14) {
                    int n16;
                    pdVectorArray3[n7].blend(1.0f - fArray3[n15], pdVectorArray[n3], fArray3[n15], pdVectorArray[n11]);
                    if (pdVectorArray2 != null) {
                        pdVectorArray4[n7].blend(1.0f - fArray3[n15], pdVector, fArray3[n15], pdVector2);
                    }
                    if (nArray2 != null && nArray4 != null) {
                        n16 = 0;
                        do {
                            nArray4[n7][n16] = (int)((1.0f - fArray3[n15]) * (float)nArray5[n16] + fArray3[n15] * (float)nArray6[n16] + 0.5f);
                        } while (++n16 < 3);
                    }
                    if (fArray != null && fArray2 != null) {
                        n16 = 0;
                        do {
                            fArray2[n7][n16] = (1.0f - fArray3[n15]) * fArray4[n16] + fArray3[n15] * fArray5[n16];
                        } while (++n16 < 6);
                    }
                    nArray3[n7] = -1;
                    ++n7;
                    ++n15;
                }
            }
            ++n8;
        }
        n = n7;
        n8 = 0;
        while (n8 < n) {
            pdVectorArray[n8].copyArray(pdVectorArray3[n8]);
            nArray[n8] = nArray3[n8];
            if (pdVectorArray2 != null) {
                pdVectorArray2[n8].copyArray(pdVectorArray4[n8]);
            }
            if (nArray2 != null && nArray4 != null) {
                n3 = 0;
                do {
                    nArray2[n8][n3] = nArray4[n8][n3];
                } while (++n3 < 3);
            }
            if (fArray != null && fArray2 != null) {
                n3 = 0;
                do {
                    fArray[n8][n3] = fArray2[n8][n3];
                } while (++n3 < 6);
            }
            ++n8;
        }
        return n;
    }

    public boolean isSpecial() {
        return this.m_bSpecial;
    }

    private void drawElementTexture_(int[] nArray, int[] nArray2, int[] nArray3, int n, int[][] nArray4, float[][] fArray, PdVector[] pdVectorArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 0;
        int n8 = nArray2[0];
        int n9 = 1;
        while (n9 < n) {
            if (nArray2[n9] < n8 || nArray2[n9] == n8 && nArray2[(n9 + 1) % n] > nArray2[n9]) {
                n8 = nArray2[n9];
                n7 = n9;
            }
            ++n9;
        }
        int n10 = nArray[n7];
        int n11 = nArray2[n7];
        int n12 = nArray[(n7 + 1) % n];
        int n13 = nArray2[(n7 + 1) % n];
        int n14 = nArray[(n7 - 1 + n) % n];
        int n15 = nArray2[(n7 - 1 + n) % n];
        int[] nArray5 = null;
        int[] nArray6 = null;
        float[] fArray2 = null;
        float[] fArray3 = null;
        boolean bl = n12 * (n15 - n11) + n14 * (n11 - n13) - (n15 - n13) * n10 < 0;
        int n16 = 0;
        this.m_bndIdentifier.setEntry(0, 0);
        int n17 = 0;
        while (n17 < n) {
            n9 = (n7 + n17) % n;
            int n18 = (n9 + 1) % n;
            if (bl) {
                n6 = nArray[n18] >= nArray[n9] ? 0 : 1;
                n5 = nArray[n18] <= nArray[n9] ? 0 : 1;
            } else {
                n6 = nArray[n18] <= nArray[n9] ? 0 : 1;
                n5 = nArray[n18] >= nArray[n9] ? 0 : 1;
            }
            n4 = nArray[n18] - nArray[n9];
            n3 = nArray2[n18] - nArray2[n9];
            n2 = Math.abs(n4) < Math.abs(n3) ? (bl && n4 < 0 || !bl && n4 > 0 ? (bl && n3 < 0 || !bl && n3 > 0 ? NEE : NWW) : (bl && n3 > 0 || !bl && n3 < 0 ? SWW : SEE)) : (bl && n4 < 0 || !bl && n4 > 0 ? (bl && n3 < 0 || !bl && n3 > 0 ? NNE : NNW) : (bl && n3 > 0 || !bl && n3 < 0 ? SSW : SSE));
            if (this.m_bShowSmoothShading) {
                nArray5 = nArray4[n9];
                nArray6 = nArray4[n18];
            }
            if (this.m_bShowSmoothLighting) {
                fArray2 = fArray[n9];
                fArray3 = fArray[n18];
            }
            PdVector pdVector = null;
            PdVector pdVector2 = null;
            if (this.m_bShowTexture) {
                pdVector = pdVectorArray[n9];
                pdVector2 = pdVectorArray[n18];
            }
            if ((n16 = this.discretizeBndEdge(nArray[n9], nArray2[n9], nArray3[n9], nArray[n18], nArray2[n18], nArray3[n18], nArray5, nArray6, this.m_colDestBnd, fArray2, fArray3, this.m_lightDestBnd, pdVector, pdVector2, this.m_faceTextureBnd, this.m_faceDestBnd, n16, this.m_bShowCurrEdge, n6 != 0, n5 != 0, bl, n2)) == -1) {
                return;
            }
            ++n17;
        }
        if (n16 == 0) {
            return;
        }
        int n19 = (int)((float)(n16 + 2) / 2.0f);
        n6 = -1;
        int n20 = 0;
        int n21 = 0;
        if (this.m_faceDestBnd[n16 - 1].m_data[1] == this.m_faceDestBnd[0].m_data[1] && this.m_faceDestBnd[n16 - 1].m_data[1] == this.m_faceDestBnd[n16 - 2].m_data[1] && Math.abs(this.m_faceDestBnd[n16 - 1].m_data[0] - this.m_faceDestBnd[0].m_data[0]) <= Math.abs(this.m_faceDestBnd[n16 - 2].m_data[0] - this.m_faceDestBnd[0].m_data[0])) {
            --n16;
        }
        if (this.m_faceDestBnd[n16 - 1].m_data[1] == this.m_faceDestBnd[0].m_data[1]) {
            n21 = n16 - 1;
        }
        if (this.m_faceDestBnd[0].m_data[1] == this.m_faceDestBnd[1].m_data[1]) {
            if (this.m_faceDestBnd[n16 - 1].m_data[1] == this.m_faceDestBnd[0].m_data[1]) {
                if (Math.abs(this.m_faceDestBnd[n16 - 1].m_data[0] - this.m_faceDestBnd[0].m_data[0]) <= Math.abs(this.m_faceDestBnd[n16 - 1].m_data[0] - this.m_faceDestBnd[1].m_data[0])) {
                    n20 = 1;
                }
            } else {
                n20 = 1;
            }
        }
        n9 = 0;
        while (n9 < n19) {
            int n22 = 0;
            int n23 = 0;
            n17 = this.m_faceDestBnd[n20].m_data[0];
            if (!this.m_bShowCurrEdge) {
                n23 = this.m_faceDestBnd[n20].m_data[3];
            }
            if (this.m_faceDestBnd[n20].m_data[1] <= n6 || this.m_faceDestBnd[n20].m_data[1] < 0) {
                ++n20;
            } else {
                n6 = this.m_faceDestBnd[n20].m_data[1];
                if (n6 < 0 || n6 >= this.m_imgHeight) break;
                n5 = this.m_faceDestBnd[n20].m_data[2];
                while (this.m_faceDestBnd[n21].m_data[1] < n6 && n21 > 0) {
                    --n21;
                }
                if (n21 < 0) break;
                n2 = this.m_faceDestBnd[n21].m_data[0];
                if (!this.m_bShowCurrEdge) {
                    n22 = this.m_faceDestBnd[n21].m_data[3];
                }
                n4 = n6;
                n4 = this.m_faceDestBnd[n21].m_data[1];
                n3 = this.m_faceDestBnd[n21].m_data[2];
                if (n4 < 0 || n4 >= this.m_imgHeight) {
                    n4 = n6;
                }
                if (n4 < 0 || n4 >= this.m_dispSize.height) {
                    n4 = n6;
                }
                if (this.m_bShowTexture) {
                    this.drawScanline(n17, n6, n5, n2, n4, n3, this.m_colDestBnd[n20], this.m_colDestBnd[n21], this.m_lightDestBnd[n20], this.m_lightDestBnd[n21], this.m_faceTextureBnd[n20].m_data, this.m_faceTextureBnd[n21].m_data, n23, n22);
                } else {
                    this.drawScanline(n17, n6, n5, n2, n4, n3, this.m_colDestBnd[n20], this.m_colDestBnd[n21], this.m_lightDestBnd[n20], this.m_lightDestBnd[n21], null, null, n23, n22);
                }
                ++n20;
                n21 = n21 == 0 ? n16 - 1 : --n21;
            }
            ++n9;
        }
        int n24 = this.m_bndIdentifier.getEntry(0);
        n9 = 1;
        while (n9 < n24) {
            int n25 = this.m_bndIdentifier.m_data[n9];
            if ((this.m_pixData[n25] & 0xFF000000) == m_colMark) {
                this.m_pixData[n25] = this.m_alpha | this.m_pixData[n25] & 0xFFFFFF;
            }
            ++n9;
        }
    }

    protected boolean getParallelCurve(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n, double d, boolean bl, boolean bl2) {
        double d2;
        double d3;
        int n2 = n - 1;
        if (bl) {
            ++n2;
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n];
        int n3 = 0;
        while (n3 < n2) {
            double d4;
            d3 = nArray3[(n3 + 1) % n] - nArray3[n3];
            d2 = nArray4[n3] - nArray4[(n3 + 1) % n];
            if (Math.abs(d3) + Math.abs(d2) < Math.abs(d)) {
                return false;
            }
            if (nArray3[(n3 + 1) % n] == nArray3[n3]) {
                d4 = d2 > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
            } else {
                d4 = Math.atan(d2 / d3);
                if (nArray3[(n3 + 1) % n] < nArray3[n3]) {
                    d4 = d2 > 0.0 ? (d4 += Math.PI) : (d4 -= Math.PI);
                }
            }
            dArray[n3] = d4 >= 0.0 ? d4 : Math.PI * 2 + d4;
            ++n3;
        }
        d3 = 0.2;
        if (bl && n > 2) {
            n3 = 0;
            while (n3 < n) {
                dArray2[n3] = (dArray[(n3 - 1 + n) % n] + dArray[n3] - Math.PI) / 2.0;
                d2 = Math.abs(dArray[(n3 - 1 + n) % n] - dArray[n3]);
                if (d2 < d3 || Math.abs(d2 - Math.PI) < d3 || Math.abs(d2 - Math.PI * 2) < d3 || Math.abs(d2 - Math.PI * 3) < d3) {
                    return false;
                }
                if (Math.abs(d2) >= Math.PI) {
                    int n4 = n3;
                    dArray2[n4] = dArray2[n4] + Math.PI;
                }
                ++n3;
            }
        } else {
            n3 = 1;
            while (n3 < n - 1) {
                dArray2[n3] = (dArray[n3 - 1] + dArray[n3] - Math.PI) / 2.0;
                d2 = Math.abs(dArray[n3 - 1] - dArray[n3]);
                if (d2 < d3 || Math.abs(d2 - Math.PI) < d3 || Math.abs(d2 - Math.PI * 2) < d3 || Math.abs(d2 - Math.PI * 3) < d3) {
                    return false;
                }
                if (d2 >= Math.PI) {
                    int n5 = n3;
                    dArray2[n5] = dArray2[n5] + Math.PI;
                }
                ++n3;
            }
            dArray2[0] = dArray[0] - 1.5707963267948966;
            dArray2[n - 1] = dArray[n - 1] - 1.5707963267948966;
        }
        n3 = 0;
        while (n3 < n) {
            d2 = Math.sin(dArray2[n3]);
            double d5 = Math.cos(dArray2[n3]);
            double d6 = d;
            double d7 = (dArray[(n3 - 1 + n) % n] - dArray[n3]) / 2.0;
            double d8 = Math.sin(d7 = Math.min(1.5707963267948966 - d7, 1.5707963267948966 + d7));
            if (Math.abs(d8) > 0.2) {
                d6 /= Math.abs(d8);
            }
            if (bl2) {
                nArray[n3] = (int)((double)nArray3[n3] - d6 * d5);
                nArray2[n3] = (int)((double)nArray4[n3] + d6 * d2);
            } else {
                nArray[n3] = (int)((double)nArray3[n3] + d6 * d5);
                nArray2[n3] = (int)((double)nArray4[n3] - d6 * d2);
            }
            ++n3;
        }
        return true;
    }

    public void setLabelColors(Color[] colorArray) {
        if (colorArray == null || colorArray.length < 7) {
            PsDebug.warning("missing font colors");
            return;
        }
        int n = 0;
        do {
            this.m_labelColor[n] = colorArray[n];
        } while (++n < 7);
    }

    public void setGlobalVertexNormalSize(double d) {
        this.m_globalVertexNormalSize = d;
        if (this.m_globalVertexNormalSize > 1.0) {
            this.m_globalVertexNormalSize = 2.0 * d - 1.0;
        }
    }

    public void setGlobalEdgeSize(double d) {
        this.m_globalEdgeSize = d;
        if (this.m_globalEdgeSize > 1.0) {
            this.m_globalEdgeSize = 2.0 * d - 1.0;
        }
    }

    public void setGlobalElementNormalSize(double d) {
        this.m_globalElementNormalSize = d;
        if (this.m_globalElementNormalSize > 1.0) {
            this.m_globalElementNormalSize = 2.0 * d - 1.0;
        }
    }

    public void setTagVertex(int n, int n2) {
        this.m_vertex[n].setTag(n2);
        this.m_geometry.setTagVertex(n, n2);
    }

    protected int addGeometryVertex(PdVector pdVector) {
        this.setNumVertices(this.m_numVertices + 1);
        this.setVertex(this.m_numVertices - 1, pdVector);
        return this.m_geometry.addVertex(pdVector);
    }

    public void setModelMatrix(PdMatrix pdMatrix) {
        super.setModelMatrix(pdMatrix);
        if (this.m_geometry != null) {
            this.m_geometry.setModelMatrix(pdMatrix);
        }
    }

    public void setAmbientMatrix(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        super.setAmbientMatrix(pdMatrix, pdMatrix2);
        if (this.m_geometry != null) {
            this.m_geometry.setAmbientMatrix(pdMatrix, pdMatrix2);
        }
    }

    public void setPolygons(PiVector[] piVectorArray) {
        super.setPolygons(piVectorArray);
        this.computeNumPolygonEdges();
    }

    public void setGlobalPolygonSize(double d) {
        this.m_globalPolygonSize = d;
    }

    public void setGlobalPolygonNormalSize(double d) {
        this.m_globalPolygonNormalSize = d;
        if (this.m_globalPolygonNormalSize > 1.0) {
            this.m_globalPolygonNormalSize = 2.0 * d - 1.0;
        }
    }

    protected void tagPolygons(Rectangle rectangle) {
        int n = this.getNumPolygons();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.m_polygon[n2].getSize();
            int n4 = 0;
            while (n4 < n3) {
                int n5 = this.m_polygon[n2].m_data[n4];
                if (rectangle.contains(this.m_vertexTrans[n5].m_data[0], this.m_vertexTrans[n5].m_data[1])) {
                    this.m_polygon[n2].setTag(1);
                    this.m_geometry.setTagPolygon(n2, 1);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void drawVectorTipAny(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, Color color) {
        double d = n5 - n2;
        double d2 = n6 - n3;
        double d3 = n7 - n4;
        double d4 = d * d + d2 * d2;
        if (d4 < 1.0) {
            return;
        }
        double d5 = (double)n + 4.0 * (double)this.m_offFac;
        if (n > 3 && this.m_offFac > 1) {
            d5 = (double)n + 4.0 * (double)this.m_offFac * 0.8;
        }
        double d6 = this.m_offFac;
        d6 *= d6;
        double d7 = bl ? 2.0 * d5 / Math.PI / Math.sqrt(d4) * Math.atan(d4 / 50.0 / d6) : 2.0 * d5 / Math.PI / Math.sqrt(d4) * Math.atan(8.0);
        d = (int)(d * d7);
        d2 = (int)(d2 * d7);
        d3 = (int)(d3 * d7);
        int n8 = n5 + (int)(-d + d2);
        int n9 = n6 + (int)(-d - d2);
        int n10 = n7 - (int)d3;
        boolean bl2 = this.m_bShowSmoothShading;
        boolean bl3 = this.m_bShowDepthcue;
        this.m_bShowSmoothShading = false;
        this.m_bShowDepthcue = false;
        this.drawLineAny(graphics, n, n5, n6, n7, n8, n9, n10, color, color, n > 3 * this.m_offFac);
        n8 = n5 + (int)(-d - d2);
        n9 = n6 + (int)(d - d2);
        this.drawLineAny(graphics, n, n5, n6, n7, n8, n9, n10, color, color, n > 3 * this.m_offFac);
        this.m_bShowDepthcue = bl3;
        this.m_bShowSmoothShading = bl2;
    }

    private boolean drawElementZBuffer(int[] nArray, int[] nArray2, int[] nArray3, int n, int[][] nArray4, int n2, float[][] fArray, PdVector[] pdVectorArray) {
        this.m_currElementCol = this.m_alpha | n2 & 0xFFFFFF;
        boolean bl = this.m_bShowSmoothShading;
        if (nArray4 == null) {
            this.m_bShowSmoothShading = false;
        }
        boolean bl2 = this.m_bShowSmoothLighting;
        if (fArray == null) {
            this.m_bShowSmoothLighting = false;
        }
        this.drawElementTexture_(nArray, nArray2, nArray3, n, nArray4, fArray, pdVectorArray);
        this.m_bShowSmoothLighting = bl2;
        this.m_bShowSmoothShading = bl;
        return true;
    }

    protected void drawLineThick(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        float f = n4 - n2;
        float f2 = n3 - n5;
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        if ((double)f3 < 1.0E-10) {
            f3 = 1.0f;
        }
        float f4 = (float)n / 2.0f * f2 / f3;
        float f5 = (float)n / 2.0f * -f / f3;
        this.xCorner[0] = (int)((float)n2 + f4);
        this.xCorner[1] = (int)((float)n4 + f4);
        this.xCorner[2] = (int)((float)n4 - f4);
        this.xCorner[3] = (int)((float)n2 - f4);
        this.yCorner[0] = (int)((float)n3 - f5);
        this.yCorner[1] = (int)((float)n5 - f5);
        this.yCorner[2] = (int)((float)n5 + f5);
        this.yCorner[3] = (int)((float)n3 + f5);
        graphics.fillPolygon(this.xCorner, this.yCorner, 4);
        if (bl) {
            int n6 = (int)((float)n / 2.0f);
            graphics.fillOval(n2 - n6, n3 - n6, n - PS_ZOOM, n - PS_ZOOM);
            graphics.fillOval(n4 - n6, n5 - n6, n - PS_ZOOM, n - PS_ZOOM);
        }
    }

    protected void clearMIS() {
        this.m_imgWidth = 0;
        this.m_imgHeight = 0;
        this.m_pixData = null;
    }
}

