/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.Color;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;

final class PvGrid
extends PgJvxSrc {
    private double m_uMin = -20.0;
    private double m_vMin = -20.0;
    private double m_uMax = 20.0;
    private double m_vMax = 20.0;
    private int m_numULines = 21;
    private int m_numVLines = 21;
    protected PdVector m_origin = new PdVector(0.0, 0.0, 0.0);
    protected PdVector m_uDir = new PdVector(1.0, 0.0, 0.0);
    protected PdVector m_vDir = new PdVector(0.0, 1.0, 0.0);
    protected PdVector m_normal = new PdVector(0.0, 0.0, 1.0);

    public PvGrid(int n) {
        super(n);
        this.init();
    }

    public void init() {
        super.init();
        this.setState(151, true);
        this.setGlobalVertexColor(Color.blue);
        this.setGlobalEdgeColor(new Color(161, 161, 161));
        this.setGlobalElementColor(Color.white);
        this.showElements(false);
    }

    public void compute() {
        this.setNumVertices(this.m_numULines * this.m_numVLines);
        double d = this.m_uMin;
        double d2 = this.m_vMin;
        double d3 = (this.m_uMax - d) / (-1.0 + (double)this.m_numULines);
        double d4 = (this.m_vMax - d2) / (-1.0 + (double)this.m_numVLines);
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numULines) {
            double d5 = d + d3 * (double)n2;
            int n3 = 0;
            while (n3 < this.m_numVLines) {
                double d6 = d2 + d4 * (double)n3;
                int n4 = 0;
                while (n4 < this.m_dim) {
                    this.m_vertex[n].m_data[n4] = this.m_origin.m_data[n4] + d5 * this.m_uDir.m_data[n4] + d6 * this.m_vDir.m_data[n4];
                    ++n4;
                }
                ++n;
                ++n3;
            }
            ++n2;
        }
        this.makeQuadrConn(this.m_numULines, this.m_numVLines, false, false);
        this.assureVertexNormals();
        PdVector.setConstant(this.m_vertexNormal, this.m_normal);
    }
}

