/*
 * Decompiled with CFR 0.152.
 */
package dev.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.BitSet;
import java.util.Date;
import java.util.Vector;
import jv.loader.PgLoader;
import jv.loader.PgLoaderIf;
import jv.loader.PvDisplayOption;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgMaLoader
implements PgLoaderIf {
    protected PvDisplayOption m_displayOption;
    protected PdVector m_boundingBoxMin;
    protected PdVector m_boundingBoxMax;
    protected String[] m_axesLabels;
    protected String m_axesStyle;
    protected Vector m_geomVec;
    protected Vector m_geomColor;
    protected Vector m_geomStyle;
    protected Vector m_geomTitle;
    protected int m_numGeoms;
    protected boolean m_bIsAnimation = false;
    protected PgJvxSrc[] m_geomArr;
    protected PgJvxSrc[][] m_animArr;

    private boolean parsePlotOptions(StreamTokenizer streamTokenizer, int n) throws IOException {
        return true;
    }

    public void setGeometryOption(BitSet bitSet) {
    }

    public boolean isEnabledOptimization() {
        return false;
    }

    private boolean parse(BufferedReader bufferedReader) throws IOException {
        return true;
    }

    private static double[] parseDoubleRange(StreamTokenizer streamTokenizer) throws IOException {
        double d = PgLoader.parseDouble((StreamTokenizer)streamTokenizer);
        double d2 = PgLoader.parseDouble((StreamTokenizer)streamTokenizer);
        return new double[]{d, d2};
    }

    private static int[] parse2ArrayOfDoubles(StreamTokenizer streamTokenizer, Vector vector) throws IOException {
        int n = 0;
        int n2 = 0;
        return new int[]{n, n2};
    }

    private static double[][] parseView(StreamTokenizer streamTokenizer) throws IOException {
        double[] dArray = PgMaLoader.parseDoubleRange(streamTokenizer);
        double[] dArray2 = PgMaLoader.parseDoubleRange(streamTokenizer);
        double[] dArray3 = PgMaLoader.parseDoubleRange(streamTokenizer);
        return new double[][]{dArray, dArray2, dArray3};
    }

    private static PdVector parsePoint(StreamTokenizer streamTokenizer, int n) throws IOException {
        PdVector pdVector = new PdVector(n);
        return pdVector;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        this.m_bIsAnimation = false;
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        this.m_geomVec = new Vector();
        this.m_numGeoms = 0;
        try {
            boolean bl = this.parse(bufferedReader);
            if (!bl) {
                PsDebug.warning((String)"error during parsing of reader");
                return null;
            }
            if (this.m_numGeoms == 0) {
                PsDebug.warning((String)"missing geometries");
                return null;
            }
        }
        catch (IOException iOException) {
            PsDebug.warning((String)"exception during parsing of reader");
            iOException.printStackTrace();
            return null;
        }
        PgJvxSrc[] pgJvxSrcArray = new PgJvxSrc[this.m_numGeoms];
        int n = 0;
        int n2 = 0;
        PdVector pdVector = this.m_geomVec.elements();
        while (pdVector.hasMoreElements()) {
            pgJvxSrcArray[n2] = (PgJvxSrc)pdVector.nextElement();
            if (n == 0) {
                n = pgJvxSrcArray[n2].getDimOfVertices();
            } else if (n != pgJvxSrcArray[n2].getDimOfVertices()) {
                n = -1;
            }
            switch (pgJvxSrcArray[n2].getType()) {
                case 30: {
                    pgJvxSrcArray[n2].showVertices(true);
                    break;
                }
                case 33: {
                    pgJvxSrcArray[n2].assureNeighbours();
                }
            }
            ++n2;
        }
        if (n == 2) {
            this.m_displayOption = new PvDisplayOption();
            this.m_displayOption.setNumCameras(1);
            this.m_displayOption.setCameraProjection(0, 1);
            this.m_displayOption.setCameraInterest(0, new PdVector(0.0, 0.0, 0.0));
            this.m_displayOption.setCameraPosition(0, new PdVector(0.0, 0.0, 1.0));
            this.m_displayOption.setCurrentCamera(1);
            this.m_displayOption.setAxesLabel(this.m_axesLabels);
            this.m_displayOption.setOption(6, true);
            this.m_displayOption.setOption(9, true);
            if (this.m_axesStyle != null) {
                this.m_displayOption.setOption(5, !this.m_axesStyle.equals("none"));
                if (this.m_axesStyle.equalsIgnoreCase("frame")) {
                    this.m_displayOption.setAxesType(6);
                } else if (this.m_axesStyle.equalsIgnoreCase("box") || this.m_axesStyle.equalsIgnoreCase("boxed")) {
                    this.m_displayOption.setAxesType(6);
                    this.m_displayOption.setOption(12, true);
                } else if (this.m_axesStyle.equalsIgnoreCase("normal")) {
                    this.m_displayOption.setAxesType(3);
                } else {
                    this.m_displayOption.setAxesType(-1);
                }
            } else {
                this.m_displayOption.setOption(5, true);
                this.m_displayOption.setAxesType(3);
            }
            this.m_displayOption.setOption(3, true);
        } else if (n == 3) {
            this.m_displayOption = new PvDisplayOption();
            this.m_displayOption.setNumCameras(1);
            this.m_displayOption.setCameraPosition(0, new PdVector(1.3, -2.4, 2.0));
            this.m_displayOption.setCameraProjection(0, 0);
            pdVector = new PdVector(3);
            pdVector.setConstant(0.5);
            this.m_displayOption.setCameraInterest(0, pdVector);
            this.m_displayOption.setEnabledCameraClip(0, false);
            this.m_displayOption.setCameraFieldOfView(0, 0.0);
            this.m_displayOption.setCameraRoll(0, 0.0);
            this.m_displayOption.setCurrentCamera(0);
            this.m_displayOption.setCameraNearClip(0, 0.0);
            this.m_displayOption.setCameraFarClip(0, 0.0);
            this.m_displayOption.setAxesLabel(this.m_axesLabels);
            this.m_displayOption.setOption(6, true);
            this.m_displayOption.setOption(9, true);
            if (this.m_axesStyle != null) {
                this.m_displayOption.setOption(5, !this.m_axesStyle.equals("none"));
                if (this.m_axesStyle.equalsIgnoreCase("frame")) {
                    this.m_displayOption.setAxesType(1);
                } else if (this.m_axesStyle.equalsIgnoreCase("box") || this.m_axesStyle.equalsIgnoreCase("boxed")) {
                    this.m_displayOption.setAxesType(2);
                    this.m_displayOption.setOption(12, true);
                } else if (this.m_axesStyle.equalsIgnoreCase("normal")) {
                    this.m_displayOption.setAxesType(0);
                } else {
                    this.m_displayOption.setAxesType(-1);
                }
            } else {
                this.m_displayOption.setOption(5, false);
                this.m_displayOption.setAxesType(-1);
            }
            this.m_displayOption.setOption(3, true);
        }
        return pgJvxSrcArray;
    }

    public static PgJvxSrc[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open((String)string);
        if (bufferedReader == null) {
            PsDebug.warning((String)("could not open = " + string));
            return null;
        }
        PgMaLoader pgMaLoader = new PgMaLoader();
        PgJvxSrc[] pgJvxSrcArray = pgMaLoader.read(bufferedReader);
        if (pgJvxSrcArray != null) {
            int n = 0;
            while (n < pgJvxSrcArray.length) {
                if (pgJvxSrcArray[n] != null && pgJvxSrcArray[n].getName() == null) {
                    pgJvxSrcArray[n].setName(PsUtil.getFileBaseName((String)string) + "[" + n + "]");
                }
                ++n;
            }
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return pgJvxSrcArray;
    }

    private static PdVector parsePoint(StreamTokenizer streamTokenizer) throws IOException {
        int n = 10;
        PdVector pdVector = new PdVector(n);
        return pdVector;
    }

    private static String parseString(StreamTokenizer streamTokenizer, String string) throws IOException {
        String string2 = streamTokenizer.sval;
        return string2;
    }

    public PgJvxSrc[][] getAnimations() {
        return this.m_animArr;
    }

    public PgJvxSrc[] getGeometries() {
        return this.m_geomArr;
    }

    public PvDisplayOption getDisplayOption() {
        return this.m_displayOption;
    }

    public void setDisplayOption(PvDisplayOption pvDisplayOption) {
        this.m_displayOption = pvDisplayOption;
    }

    public void setAnimation(boolean bl) {
        this.m_bIsAnimation = bl;
    }

    private static int[] parse2ArrayOfPoints(StreamTokenizer streamTokenizer, Vector vector, int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        return new int[]{n2, n3};
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        int n;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        this.m_numGeoms = pgJvxSrcArray.length;
        int n2 = 0;
        while (n2 < this.m_numGeoms) {
            if (pgJvxSrcArray[n2] == null) {
                PsDebug.warning((String)("missing geometry[" + n2 + "]"));
                return false;
            }
            ++n2;
        }
        PgJvxSrc pgJvxSrc = null;
        writer.write("//Maya ASCII 4.0 scene\n");
        writer.write("//Produced with JavaView v." + PsConfig.getVersion() + "\n");
        writer.write("//JavaView is " + PsConfig.getCopyright() + ", " + PsConfig.getHomepage() + "\n");
        writer.write("//by " + PsConfig.getAuthors() + "\n");
        writer.write("//   File Format           = Maya ASCII 4.0\n");
        writer.write("//   Date                  = " + new Date().toString() + "\n");
        writer.write("//   Number of Geometries  = " + this.m_numGeoms + "\n");
        int n3 = 0;
        while (n3 < this.m_numGeoms) {
            pgJvxSrc = pgJvxSrcArray[n3];
            writer.write("//   Geometry[" + String.valueOf(n3) + "]           = " + pgJvxSrc.getName() + "\n");
            int n4 = pgJvxSrc.getNumVertices();
            writer.write("//   Number of Vertices    = " + n4 + "\n");
            n = pgJvxSrc.getNumElements();
            if (n > 0) {
                writer.write("//   Number of Elements    = " + n + "\n");
            }
            ++n3;
        }
        writer.write("//End of Header\n");
        writer.write("requires maya \"4.0\";\n");
        n3 = pgJvxSrcArray[0].getDimOfVertices();
        n = 0;
        while (n < this.m_numGeoms) {
            int n5;
            int n6;
            PdVector[][] pdVectorArray;
            pgJvxSrc = pgJvxSrcArray[n];
            String string = pgJvxSrc.getName();
            writer.write("createNode transform -n \"" + string + "P\";\n");
            writer.write("createNode mesh -n \"" + string + "\" -p \"" + string + "P\";\n");
            PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
            int n7 = pgJvxSrc.getNumVertices();
            int n8 = pgJvxSrc.getNumElements();
            boolean bl = false;
            boolean bl2 = false;
            if (pgJvxSrc.isShowingElementTexture()) {
                bl2 = true;
                pdVectorArray = pgJvxSrc.getElementTextures();
                writer.write("setAttr \".uvst[0].uvsn\" -type \"string\" \"map1\";\n");
                n6 = 0;
                int n9 = 0;
                while (n9 < n8) {
                    n6 += pgJvxSrc.getElement(n9).getSize();
                    ++n9;
                }
                writer.write("setAttr -s " + n6 + " \".uvst[0].uvsp[0:" + (n6 - 1) + "]\" -type \"float2\"\n");
                n9 = 0;
                while (n9 < n8) {
                    int n10 = pgJvxSrc.getElement(n9).getSize();
                    n5 = 0;
                    while (n5 < n10) {
                        writer.write(String.valueOf(pdVectorArray[n9][(n5 + 1) % n10].m_data[0]) + " " + String.valueOf(pdVectorArray[n9][(n5 + 1) % n10].m_data[1]));
                        if (n9 != n8 - 1 || n5 != n10 - 1) {
                            writer.write("\n");
                        } else {
                            writer.write(";\n");
                        }
                        ++n5;
                    }
                    ++n9;
                }
                writer.write("setAttr \".cuvs\" -type \"string\" \"map1\";\n");
            }
            if (!bl2 && pgJvxSrc.isShowingVertexTexture()) {
                bl = true;
                pdVectorArray = pgJvxSrc.getVertexTextures();
                writer.write("setAttr \".uvst[0].uvsn\" -type \"string\" \"map1\";\n");
                writer.write("setAttr -s " + n7 + " \".uvst[0].uvsp[0:" + (n7 - 1) + "]\" -type \"float2\"\n");
                n6 = 0;
                while (n6 < n7) {
                    writer.write(String.valueOf(pdVectorArray[n6].m_data[0]) + " " + String.valueOf(pdVectorArray[n6].m_data[1]));
                    if (n6 != n7 - 1) {
                        writer.write("\n");
                    } else {
                        writer.write(";\n");
                    }
                    ++n6;
                }
                writer.write("setAttr \".cuvs\" -type \"string\" \"map1\";\n");
            }
            writer.write("setAttr -s " + n7 + " \".vt[0:" + (n7 - 1) + "]\"\n");
            int n11 = 0;
            while (n11 < n7) {
                n6 = 0;
                while (n6 < n3) {
                    if (Math.abs(pdVectorArray2[n11].m_data[n6]) < 1.0E-10) {
                        writer.write("0.0");
                    } else {
                        writer.write(String.valueOf(pdVectorArray2[n11].m_data[n6]));
                    }
                    if (n6 != n3 - 1) {
                        writer.write(" ");
                    } else if (n11 != n7 - 1) {
                        writer.write("\n");
                    } else {
                        writer.write(";\n");
                    }
                    ++n6;
                }
                ++n11;
            }
            if (n8 > 0) {
                int n12;
                PiVector piVector;
                PiVector[] piVectorArray = pgJvxSrc.getElements();
                PiVector[] piVectorArray2 = pgJvxSrc.getNeighbours();
                PiVector[] piVectorArray3 = new PiVector[n8];
                Vector<PiVector> vector = new Vector<PiVector>();
                int n13 = 0;
                int n14 = 0;
                while (n14 < n8) {
                    piVectorArray3[n14] = new PiVector(piVectorArray[n14].getSize() + 1);
                    ++n14;
                }
                n14 = 0;
                while (n14 < n8) {
                    piVector = piVectorArray[n14];
                    PiVector piVector2 = piVectorArray2[n14];
                    piVectorArray3[n14].m_data[0] = n5 = piVector.getSize();
                    n12 = 0;
                    while (n12 < n5) {
                        if (piVector2.m_data[n12] == -1 || piVector2.m_data[n12] > n14) {
                            int n15 = piVector.m_data[(n12 + 1) % n5];
                            int n16 = piVector.m_data[(n12 + 2) % n5];
                            PiVector piVector3 = new PiVector(n15, n16);
                            piVectorArray3[n14].m_data[n12 + 1] = n13;
                            piVectorArray3[n14].m_data[n12 + 1] = n13;
                            vector.addElement(piVector3);
                            if (piVector2.m_data[n12] != -1) {
                                PiVector piVector4 = piVectorArray[piVector2.m_data[n12]];
                                int n17 = piVector.getSize();
                                int n18 = 0;
                                while (n18 < n17) {
                                    if (piVector4.m_data[(n18 + 1) % n17] == n15 && piVector4.m_data[(n18 + 2) % n17] == n16) {
                                        piVectorArray3[piVector2.m_data[n12]].m_data[n18 + 1] = n13;
                                        break;
                                    }
                                    if (piVector4.m_data[(n18 + 1) % n17] == n16 && piVector4.m_data[(n18 + 2) % n17] == n15) {
                                        piVectorArray3[piVector2.m_data[n12]].m_data[n18 + 1] = -1 - n13;
                                        break;
                                    }
                                    ++n18;
                                }
                            }
                            ++n13;
                        }
                        ++n12;
                    }
                    ++n14;
                }
                writer.write("setAttr -s " + n13 + " \".ed[0:" + (n13 - 1) + "]\"\n");
                n14 = 0;
                while (n14 < n13) {
                    writer.write(((PiVector)vector.elementAt((int)n14)).m_data[0] + " " + ((PiVector)vector.elementAt((int)n14)).m_data[1] + " 0");
                    if (n14 != n13 - 1) {
                        writer.write("\n");
                    } else {
                        writer.write(";\n");
                    }
                    ++n14;
                }
                n14 = 0;
                writer.write("setAttr -s " + n8 + " \".fc[0:" + (n8 - 1) + "]\" -type \"polyFaces\"\n");
                n12 = 0;
                while (n12 < n8) {
                    piVector = piVectorArray3[n12];
                    n5 = piVector.getSize();
                    writer.write("f");
                    int n19 = 0;
                    while (n19 < n5) {
                        writer.write(" " + piVector.m_data[n19]);
                        ++n19;
                    }
                    if (bl2) {
                        writer.write("\nmu 0 " + (n5 - 1));
                        n19 = 0;
                        while (n19 < n5 - 1) {
                            writer.write(" " + (n14 + n19));
                            ++n19;
                        }
                        n14 += n5 - 1;
                    } else if (bl) {
                        writer.write("\nmu 0 " + (n5 - 1));
                        n19 = 0;
                        while (n19 < n5 - 1) {
                            writer.write(" " + piVectorArray[n12].m_data[(n19 + 1) % (n5 - 1)]);
                            ++n19;
                        }
                    }
                    if (n12 != n8 - 1) {
                        writer.write("\n");
                    } else {
                        writer.write(";\n");
                    }
                    ++n12;
                }
            }
            if (bl || bl2) {
                writer.write("createNode file -n \"tex\";\n");
                writer.write("setAttr \".ftn\" -type \"string\" \"" + pgJvxSrc.getTextureImageName() + "\";\n");
                writer.write("createNode place2dTexture -n \"place2dTexture1\";\n");
                writer.write("connectAttr \"tex.oc\" \":lambert1.c\";\n");
                writer.write("connectAttr \"" + string + ".iog\" \":initialShadingGroup.dsm\" -na;\n");
            }
            ++n;
        }
        return true;
    }

    public boolean load(BufferedReader bufferedReader) {
        this.m_geomArr = this.read(bufferedReader);
        return this.m_geomArr != null;
    }

    private static String[] parseAxesLabels(StreamTokenizer streamTokenizer) throws IOException {
        return null;
    }

    public boolean isAnimation() {
        return this.m_bIsAnimation;
    }

    private static double[] parseRange(StreamTokenizer streamTokenizer) throws IOException {
        double d = PgLoader.parseDouble((StreamTokenizer)streamTokenizer);
        double d2 = PgLoader.parseDouble((StreamTokenizer)streamTokenizer);
        return new double[]{d, d2};
    }

    public PgGeometryIf[] getSpecializedGeometries() {
        return null;
    }

    private void addGeometry(PgJvxSrc pgJvxSrc) {
        ++this.m_numGeoms;
        this.m_geomVec.addElement(pgJvxSrc);
        this.m_geomColor.setSize(this.m_numGeoms);
        this.m_geomStyle.setSize(this.m_numGeoms);
        this.m_geomTitle.setSize(this.m_numGeoms);
    }

    private static Color[] parseColor(StreamTokenizer streamTokenizer) throws IOException {
        return null;
    }

    protected Vector readGraphics(StreamTokenizer streamTokenizer, int n, Vector vector) throws IOException {
        return vector;
    }

    private static String parseUnknown(StreamTokenizer streamTokenizer) throws IOException {
        String string = "";
        return string;
    }
}

