/*
 * Decompiled with CFR 0.152.
 */
package dev.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.BitSet;
import jv.loader.PgLoaderIf;
import jv.loader.PsXmlLoader;
import jv.loader.PvDisplayOption;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.PdVector;

public final class PgXvcLoader
implements PgLoaderIf {
    protected boolean m_bIsEnabledOptimization = false;
    protected BitSet m_geometryOption;
    protected boolean m_bIsAnimation = false;
    protected PgJvxSrc[] m_geomArr;
    protected PgJvxSrc[][] m_animArr;

    public void setGeometryOption(BitSet bitSet) {
        this.m_geometryOption = bitSet;
    }

    public boolean isEnabledOptimization() {
        return this.m_bIsEnabledOptimization;
    }

    protected PgJvxSrc[] parseRsrcTree(PsXmlSrc psXmlSrc) {
        PsXmlNode psXmlNode;
        int n;
        PsXmlNode[] psXmlNodeArray;
        int n2;
        PsXmlNode psXmlNode2;
        PsXmlNode psXmlNode3;
        PsXmlNode psXmlNode4 = psXmlSrc.getRootNode();
        if (psXmlNode4 == null) {
            PsDebug.warning((String)"missing root node.");
            return null;
        }
        if (psXmlNode4.getType() == null || !psXmlNode4.getType().equalsIgnoreCase("Canvas")) {
            PsDebug.warning((String)"missing <Canvas> element,\nthis is not a valid MuPAD xvc file.");
            return null;
        }
        PgJvxSrc pgJvxSrc = null;
        PgJvxSrc[][] pgJvxSrcArrayArray = null;
        PsXmlNode psXmlNode5 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode4, (String)"Scene2d");
        if (psXmlNode5 != null && (psXmlNode3 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode5, (String)"CoordinateSystem2d")) != null) {
            psXmlNode2 = PsXmlSrc.getRsrcNodes((PsXmlNode)psXmlNode3, (String)"Obj2d");
            if (psXmlNode2 == null || ((PsXmlNode)psXmlNode2).length == 0) {
                return null;
            }
            pgJvxSrcArrayArray = new PgJvxSrc[((PsXmlNode)psXmlNode2).length][];
            n2 = 0;
            while (n2 < ((PsXmlNode)psXmlNode2).length) {
                psXmlNodeArray = PsXmlSrc.getRsrcNodes((PsXmlNode)psXmlNode2[n2], (String)"Img2d");
                if (psXmlNodeArray != null) {
                    int n3 = psXmlNodeArray.length;
                    pgJvxSrcArrayArray[n2] = new PgJvxSrc[n3];
                    n = 0;
                    while (n < n3) {
                        PsXmlNode psXmlNode6 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[1], (String)"Poly2d");
                        if (psXmlNode6 != null) {
                            pgJvxSrc = new PgJvxSrc();
                            pgJvxSrc.setType(31);
                            pgJvxSrc.showPolygons(true);
                            psXmlNode = PsXmlLoader.parseDoubleList((PsXmlNode)psXmlNode6, (String)"P2", null);
                            if (psXmlNode != null) {
                                pgJvxSrc.setDimOfVertices(psXmlNode[0].getSize());
                                pgJvxSrc.setNumVertices(((PdVector[])psXmlNode).length);
                                pgJvxSrc.setVertices((PdVector[])psXmlNode);
                            }
                        }
                        if ((psXmlNode = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[1], (String)"Pt2d")) != null) {
                            pgJvxSrc = new PgJvxSrc();
                            pgJvxSrc.setType(31);
                            pgJvxSrc.showPolygons(true);
                            PdVector[] pdVectorArray = PsXmlLoader.parseDoubleList((PsXmlNode)psXmlNode, (String)"Pt2d", null);
                            if (pdVectorArray != null) {
                                pgJvxSrc.setDimOfVertices(pdVectorArray[0].getSize());
                                pgJvxSrc.setNumVertices(pdVectorArray.length);
                                pgJvxSrc.setVertices(pdVectorArray);
                            }
                        }
                        pgJvxSrcArrayArray[n2][n] = pgJvxSrc;
                        ++n;
                    }
                }
                ++n2;
            }
        }
        if ((psXmlNode3 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode4, (String)"Scene3d")) != null && (psXmlNode2 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode3, (String)"CoordinateSystem3d")) != null) {
            psXmlNodeArray = PsXmlSrc.getRsrcNodes((PsXmlNode)psXmlNode2, (String)"Obj3d");
            if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
                return null;
            }
            pgJvxSrcArrayArray = new PgJvxSrc[psXmlNodeArray.length][];
            n2 = 0;
            while (n2 < psXmlNodeArray.length) {
                pgJvxSrc = new PgJvxSrc();
                PsXmlNode[] psXmlNodeArray2 = PsXmlSrc.getRsrcNodes((PsXmlNode)psXmlNodeArray[n2], (String)"Img3d");
                if (psXmlNodeArray2 != null) {
                    int n4 = psXmlNodeArray2.length;
                    pgJvxSrcArrayArray[n2] = new PgJvxSrc[n4];
                    n = 0;
                    while (n < n4) {
                        psXmlNode = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray2[n], (String)"Mesh3d");
                        if (psXmlNode != null) {
                            PdVector[] pdVectorArray;
                            pgJvxSrc = new PgJvxSrc();
                            pgJvxSrc.setType(33);
                            pgJvxSrc.showElements(true);
                            int n5 = this.getAttributeAsInt(psXmlNode, "VMesh");
                            int n6 = this.getAttributeAsInt(psXmlNode, "UMesh");
                            if (n5 != -1 && n6 != -1) {
                                pgJvxSrc.makeQuadrConn(n6, n5, false, false);
                            }
                            if ((pdVectorArray = PsXmlLoader.parseDoubleList((PsXmlNode)psXmlNode, (String)"P3", null)) != null) {
                                pgJvxSrc.setDimOfVertices(pdVectorArray[0].getSize());
                                pgJvxSrc.setNumVertices(pdVectorArray.length);
                                pgJvxSrc.setVertices(pdVectorArray);
                            }
                        }
                        pgJvxSrcArrayArray[n2][n] = pgJvxSrc;
                        ++n;
                    }
                }
                ++n2;
            }
        }
        return pgJvxSrcArrayArray[0];
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing buffered reader");
            return null;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read((BufferedReader)bufferedReader);
        if (psXmlSrc == null) {
            PsDebug.warning((String)"failed to parse XML stream");
            return null;
        }
        PgJvxSrc[] pgJvxSrcArray = this.parseRsrcTree(psXmlSrc);
        if (pgJvxSrcArray == null) {
            PsDebug.warning((String)"failed to interpret XVC tree");
            return null;
        }
        return pgJvxSrcArray;
    }

    public static PgJvxSrc[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open((String)string);
        if (bufferedReader == null) {
            PsDebug.warning((String)("could not open = " + string));
            return null;
        }
        PgXvcLoader pgXvcLoader = new PgXvcLoader();
        PgJvxSrc[] pgJvxSrcArray = pgXvcLoader.read(bufferedReader);
        if (pgJvxSrcArray != null) {
            int n = 0;
            while (n < pgJvxSrcArray.length) {
                String string2;
                if (pgJvxSrcArray[n] != null && ((string2 = pgJvxSrcArray[n].getName()) == null || string2.toLowerCase().startsWith("object_"))) {
                    String string3 = PsUtil.getFileBaseName((String)string);
                    if (n == 0) {
                        pgJvxSrcArray[n].setName(string3);
                    } else {
                        pgJvxSrcArray[n].setName(string3 + "[" + n + "]");
                    }
                }
                ++n;
            }
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return pgJvxSrcArray;
    }

    public PgJvxSrc[][] getAnimations() {
        return this.m_animArr;
    }

    public PgJvxSrc[] getGeometries() {
        return this.m_geomArr;
    }

    public PvDisplayOption getDisplayOption() {
        return null;
    }

    public void setDisplayOption(PvDisplayOption pvDisplayOption) {
    }

    public void setAnimation(boolean bl) {
        this.m_bIsAnimation = bl;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) {
        PsDebug.warning((String)"method not implemented yet");
        return false;
    }

    public boolean load(BufferedReader bufferedReader) {
        this.m_geomArr = this.read(bufferedReader);
        return this.m_geomArr != null;
    }

    public boolean isAnimation() {
        return this.m_bIsAnimation;
    }

    public PgGeometryIf[] getSpecializedGeometries() {
        return null;
    }

    private int getAttributeAsInt(PsXmlNode psXmlNode, String string) {
        String string2 = psXmlNode.getAttribute(string);
        if (string2 == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning((String)("wrong format = " + string2));
            return -1;
        }
    }
}

