/*
 * Decompiled with CFR 0.152.
 */
package vgp.curve.common;

import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jvx.numeric.PnOde;
import vgp.surface.common.PgSurfaceDescr;

public class PnSurfaceOde
extends PnOde {
    protected PgSurfaceDescr m_surface;
    private static /* synthetic */ Class class$vgp$curve$common$PnSurfaceOde;

    public boolean solve(PgPolygon pgPolygon, double d, double[] dArray, double d2, double d3) {
        if (pgPolygon == null) {
            PsDebug.warning((String)"Missing polygon.");
            return false;
        }
        if (this.m_surface == null) {
            PsDebug.warning((String)"Missing surface.");
            return false;
        }
        if (dArray == null || d2 == 0.0 || d3 < d2) {
            PsDebug.warning((String)"Wrong argument.");
            return false;
        }
        int n = dArray.length;
        if (n < this.m_order) {
            PsDebug.warning((String)"Dim of initial value yStart is less than order of DGL.");
            return false;
        }
        int n2 = (int)(d3 / d2);
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        double d4 = d;
        int n3 = 0;
        while (n3 < n) {
            dArray2[n3] = dArray[n3];
            ++n3;
        }
        pgPolygon.setNumVertices(n2 + 1);
        this.m_surface.eval(pgPolygon.getVertex(0), dArray2[0], dArray2[1]);
        int n4 = 1;
        double d5 = 1.0000000001;
        while (n4 < n2 + 1 && d5 > 1.0E-10 && (dArray2[0] >= this.m_surface.getUMin() && dArray2[0] <= this.m_surface.getUMax() || this.m_surface.isUPeriodic()) && (dArray2[1] >= this.m_surface.getVMin() && dArray2[1] <= this.m_surface.getVMax() || this.m_surface.isVPeriodic())) {
            PnOde.rungeKutta((PnOde)this, (double)d4, (double[])dArray2, (double)d2, (double[])dArray3);
            d4 += d2;
            d5 = (dArray3[0] - dArray2[0]) * (dArray3[0] - dArray2[0]) + (dArray3[1] - dArray2[1]) * (dArray3[1] - dArray2[1]);
            System.arraycopy(dArray3, 0, dArray2, 0, n);
            this.m_surface.eval(pgPolygon.getVertex(n4), dArray2[0], dArray2[1]);
            ++n4;
        }
        pgPolygon.setNumVertices(n4 - 1);
        return true;
    }

    public void setSurface(PgSurfaceDescr pgSurfaceDescr) {
        this.m_surface = pgSurfaceDescr;
    }

    public PgSurfaceDescr getSurface() {
        return this.m_surface;
    }

    public PnSurfaceOde() {
        if (((Object)((Object)this)).getClass() == (class$vgp$curve$common$PnSurfaceOde != null ? class$vgp$curve$common$PnSurfaceOde : (class$vgp$curve$common$PnSurfaceOde = PnSurfaceOde.class$("vgp.curve.common.PnSurfaceOde")))) {
            this.init();
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.setOrder(2);
    }

    public void solve(PgPolygon pgPolygon) {
        this.solve(pgPolygon, this.m_x0, this.m_y0, this.m_stepSize, this.m_length);
    }
}

