/*
 * Decompiled with CFR 0.152.
 */
package vgp.curve.elastic;

import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jvx.numeric.PnOde;

public class PnElasticCurvature
extends PnOde {
    protected double m_paramA = 0.0;
    protected double m_paramB = 0.0;
    protected PgPolygon m_p;
    protected double[] m_y;
    protected double[] m_yOut;
    protected double m_x;
    protected int m_dim;
    protected int m_i;
    private static /* synthetic */ Class class$vgp$curve$elastic$PnElasticCurvature;

    public void setInitialData(double d, double[] dArray, double d2, double d3, double d4, double d5) {
        super.setInitialData(d, dArray, d2, d3);
        this.m_paramA = d4;
        this.m_paramB = d5;
    }

    public PnElasticCurvature() {
        if (((Object)((Object)this)).getClass() == (class$vgp$curve$elastic$PnElasticCurvature != null ? class$vgp$curve$elastic$PnElasticCurvature : (class$vgp$curve$elastic$PnElasticCurvature = PnElasticCurvature.class$("vgp.curve.elastic.PnElasticCurvature")))) {
            this.init();
        }
    }

    public void initSolve(PgPolygon pgPolygon) {
        if (pgPolygon == null) {
            PsDebug.warning((String)"Missing polygon.");
            return;
        }
        if (this.m_y0 == null || this.m_stepSize == 0.0 || this.m_length < this.m_stepSize) {
            PsDebug.warning((String)"Wrong argument.");
            return;
        }
        this.m_p = pgPolygon;
        this.m_dim = this.m_y0.length;
        if (this.m_dim == 0) {
            PsDebug.warning((String)"Dim of initial value m_y0 is 0.");
            return;
        }
        this.m_y = new double[this.m_dim];
        this.m_yOut = new double[this.m_dim];
        System.arraycopy(this.m_y0, 0, this.m_y, 0, this.m_dim);
        this.m_x = this.m_x0;
        int n = 0;
        while (n < this.m_dim) {
            this.m_y[n] = this.m_y0[n];
            ++n;
        }
        this.m_p.setNumVertices(100);
        this.m_p.setNumVertices(1);
        this.m_p.setVertex(0, this.m_x, this.m_y[0], 0.0);
        this.m_i = 0;
    }

    public void diffEquation(double d, double[] dArray, double[] dArray2) {
        dArray2[0] = dArray[1];
        dArray2[1] = this.m_paramB + (this.m_paramA - 0.5 * dArray[0] * dArray[0]) * dArray[0];
    }

    public void nextStep() {
        ++this.m_i;
        this.m_p.setNumVertices(this.m_p.getNumVertices() + 1);
        PnOde.rungeKutta((PnOde)this, (double)this.m_x, (double[])this.m_y, (double)this.m_stepSize, (double[])this.m_yOut);
        this.m_x += this.m_stepSize;
        System.arraycopy(this.m_yOut, 0, this.m_y, 0, this.m_dim);
        this.m_p.setVertex(this.m_i, this.m_x, this.m_y[0], 0.0);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.setOrder(2);
    }

    public void solve(PgPolygon pgPolygon) {
        this.initSolve(pgPolygon);
        int n = (int)(this.m_length / this.m_stepSize);
        int n2 = 1;
        while (n2 < n) {
            this.nextStep();
            ++n2;
        }
    }
}

