/*
 * Decompiled with CFR 0.152.
 */
package vgp.curve.elastic;

import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jvx.numeric.PnOde;
import vgp.curve.elastic.PnElasticCurvature;

public class PnElasticOde
extends PnOde {
    protected PgPolygon m_curvature;
    protected PnElasticCurvature m_rk;
    private static /* synthetic */ Class class$vgp$curve$elastic$PnElasticOde;

    public void setInitialData(double d, double[] dArray, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        super.setInitialData(d, dArray, d2, d3);
        double[] dArray2 = new double[]{d4, d5};
        this.m_rk = new PnElasticCurvature();
        this.m_rk.setInitialData(d, dArray2, d6, d6, d7, d8);
        this.m_curvature = new PgPolygon(3);
        this.m_rk.initSolve(this.m_curvature);
    }

    public PnElasticOde() {
        if (((Object)((Object)this)).getClass() == (class$vgp$curve$elastic$PnElasticOde != null ? class$vgp$curve$elastic$PnElasticOde : (class$vgp$curve$elastic$PnElasticOde = PnElasticOde.class$("vgp.curve.elastic.PnElasticOde")))) {
            this.init();
        }
    }

    public void diffEquation(double d, double[] dArray, double[] dArray2) {
        dArray2[0] = dArray[2];
        dArray2[1] = dArray[3];
        int n = -1;
        double d2 = 0.0;
        int n2 = this.m_curvature.getNumVertices();
        do {
            if (++n < n2) continue;
            this.m_rk.nextStep();
            ++n2;
        } while (d > this.m_curvature.getVertex(n).getEntry(0));
        if (n == 0) {
            d2 = this.m_curvature.getVertex(n).getEntry(2);
        } else {
            double d3;
            double d4 = this.m_curvature.getVertex(n).getEntry(0);
            if (d4 - (d3 = this.m_curvature.getVertex(n - 1).getEntry(0)) < 1.0E-10) {
                PsDebug.warning((String)"x1-x0 < eps");
            }
            double d5 = (d - d3) / (d4 - d3);
            double d6 = this.m_curvature.getVertex(n).getEntry(1);
            double d7 = this.m_curvature.getVertex(n - 1).getEntry(1);
            d2 = d5 * d6 + (1.0 - d5) * d7;
        }
        dArray2[2] = -d2 * dArray[3];
        dArray2[3] = d2 * dArray[2];
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.setOrder(4);
        this.m_curvature = new PgPolygon(3);
    }

    public void solve(PgPolygon pgPolygon) {
        if (pgPolygon == null) {
            PsDebug.warning((String)"Missing polygon.");
            return;
        }
        if (this.m_y0 == null || this.m_stepSize == 0.0 || this.m_length < this.m_stepSize) {
            PsDebug.warning((String)"Wrong argument.");
            return;
        }
        int n = this.m_y0.length;
        if (n == 0) {
            PsDebug.warning((String)"Dim of initial value m_y0 is 0.");
            return;
        }
        int n2 = (int)(this.m_length / this.m_stepSize);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        System.arraycopy(this.m_y0, 0, dArray, 0, n);
        double d = this.m_x0;
        int n3 = 0;
        while (n3 < n) {
            dArray[n3] = this.m_y0[n3];
            ++n3;
        }
        pgPolygon.setNumVertices(n2);
        pgPolygon.setVertex(0, dArray[0], dArray[1]);
        int n4 = 1;
        while (n4 < n2) {
            PnOde.rungeKutta((PnOde)this, (double)d, (double[])dArray, (double)this.m_stepSize, (double[])dArray2);
            d += this.m_stepSize;
            System.arraycopy(dArray2, 0, dArray, 0, n);
            pgPolygon.setVertex(n4, dArray[0], dArray[1]);
            ++n4;
        }
    }
}

