/*
 * Decompiled with CFR 0.152.
 */
package vgp.discrete.confEnergy;

import java.awt.Color;
import java.awt.Component;
import jv.function.PuFunction;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvPickListenerIf;
import jv.project.PvViewerIf;
import jv.vecmath.PdVector;
import jvx.numeric.PnConfEnergy;
import jvx.numeric.PnEnergy;
import jvx.numeric.PnEnergyMinimizer;

public class PjConfEnergy
extends PjProject {
    public static final int SURFACE = 0;
    public static final int DUAL = 1;
    protected int m_activeSurface = 0;
    protected PgElementSet m_domain = new PgElementSet(3);
    protected PgElementSet m_confMap;
    protected PuFunction m_function;
    protected PnEnergyMinimizer m_diri;
    private boolean bUpdateFromDiri = false;
    private static /* synthetic */ Class class$vgp$discrete$confEnergy$PjConfEnergy;

    public PjConfEnergy() {
        super("PjConfEnergy");
        this.m_domain.setName("Domain");
        this.m_domain.setParent((PsUpdateIf)this);
        this.m_confMap = new PgElementSet(2);
        this.m_confMap.setName("Conformal Map");
        this.m_confMap.setParent((PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$discrete$confEnergy$PjConfEnergy != null ? class$vgp$discrete$confEnergy$PjConfEnergy : (class$vgp$discrete$confEnergy$PjConfEnergy = PjConfEnergy.class$("vgp.discrete.confEnergy.PjConfEnergy")))) {
            this.init();
        }
    }

    public boolean update(Object object) {
        if (object == this.m_domain) {
            this.m_confMap.setNumVertices(this.m_domain.getNumVertices());
            this.m_confMap.copyElementSet(this.m_domain);
            this.makeVertices();
            if (!this.m_diri.isRunning()) {
                this.m_confMap.update((Object)this.m_confMap);
            }
            this.m_diri.setSurface(this.m_domain, this.m_confMap);
            super.update(null);
            return true;
        }
        if (object == this.m_confMap) {
            if (!this.bUpdateFromDiri) {
                this.m_diri.setSurface(this.m_domain, this.m_confMap);
            }
            super.update(null);
            return true;
        }
        if (object == this.m_diri) {
            this.bUpdateFromDiri = true;
            this.m_confMap.update((Object)this.m_confMap);
            this.bUpdateFromDiri = false;
            return true;
        }
        if (object == this.m_function) {
            this.m_confMap.setNumVertices(this.m_domain.getNumVertices());
            this.m_confMap.copyElementSet(this.m_domain);
            this.makeVertices();
            if (!this.m_diri.isRunning()) {
                this.m_confMap.update((Object)this.m_confMap);
            }
            this.m_diri.setSurface(this.m_domain, this.m_confMap);
            return true;
        }
        return super.update(object);
    }

    public void start() {
        PvViewerIf pvViewerIf = this.getViewer();
        PvDisplayIf pvDisplayIf = pvViewerIf.newDisplay("Display Domain", true);
        pvDisplayIf.addPickListener((PvPickListenerIf)this);
        pvDisplayIf.addGeometry((PgGeometryIf)this.m_domain);
        pvDisplayIf.selectCamera(1);
        this.addDisplay(pvDisplayIf);
        this.addGeometry((PgGeometryIf)this.m_confMap);
        this.selectGeometry((PgGeometryIf)this.m_confMap);
        pvDisplayIf = this.getDisplay();
        if (pvDisplayIf != null) {
            pvDisplayIf.selectCamera(1);
        }
        ((Component)pvDisplayIf.getFrame()).setVisible(true);
        super.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void makeVertices() {
        if (this.m_domain == null || this.m_confMap == null) {
            return;
        }
        if (this.m_domain.getNumVertices() != this.m_confMap.getNumVertices()) {
            PsDebug.warning((String)("domain and confMap differ in numVertices.\n\tdomain\t = " + this.m_domain.getName() + " numVertices = " + this.m_domain.getNumVertices() + "\n\tconfMap = " + this.m_confMap.getName() + " numVertices = " + this.m_confMap.getNumVertices()));
            return;
        }
        PdVector[] pdVectorArray = this.m_domain.getVertices();
        PdVector[] pdVectorArray2 = this.m_confMap.getVertices();
        int n = this.m_domain.getNumVertices();
        int n2 = 0;
        while (n2 < n) {
            this.m_function.eval(pdVectorArray2[n2].m_data, pdVectorArray[n2].m_data);
            ++n2;
        }
        this.m_confMap.makeVertexNormals();
    }

    public void init() {
        this.m_domain.setGlobalElementColor(Color.lightGray);
        this.computeDomain();
        this.m_confMap.setNumVertices(this.m_domain.getNumVertices());
        this.m_confMap.copyElementSet(this.m_domain);
        this.m_function = new PuFunction(2, 2);
        this.m_function.setName("Initial Conformal Map");
        this.m_function.setExpression(0, "u");
        this.m_function.setExpression(1, "v");
        this.m_function.setParent((PsUpdateIf)this);
        this.makeVertices();
        this.m_diri = new PnEnergyMinimizer();
        this.m_diri.enableUpdateDomain(false);
        this.m_diri.setParent((PsUpdateIf)this);
        this.m_diri.setSurface(this.m_domain, this.m_confMap);
        this.m_diri.setEnergy((PnEnergy)new PnConfEnergy());
        this.m_diri.minimize();
    }

    public void computeDomain() {
        if (this.m_domain == null || this.m_confMap == null) {
            return;
        }
        this.m_domain.setDimOfElements(3);
        this.m_domain.computeDisk(5, 6, 1.0);
        this.m_domain.close();
        this.m_domain.fixBoundaries();
    }
}

