/*
 * Decompiled with CFR 0.152.
 */
package vgp.discrete.platonic;

import jv.geom.PgElementSet;
import jv.object.PsConfig;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jvx.geom.PgTube;
import jvx.geom.PwModel;
import jvx.geom.PwPlatonic;

public class PjPlatonic
extends PjProject {
    protected boolean m_bShowSolid;
    protected boolean m_bShowTube;
    protected boolean m_bShowSolidSave;
    protected boolean m_bShowTubeSave;
    protected String m_defSolidName = "Icosahedron";
    protected String m_solidName;
    protected PgElementSet m_solid = new PgElementSet(3);
    protected PgTube m_tube;
    protected PwModel m_pwModel;
    protected PwPlatonic m_pwPlatonic;
    protected boolean m_bShowModeling;
    private static /* synthetic */ Class class$vgp$discrete$platonic$PjPlatonic;

    public PjPlatonic() {
        super("Platonic Solids");
        this.m_solidName = this.m_defSolidName;
        this.m_tube = new PgTube(3);
        this.m_tube.setName("Tube");
        this.m_tube.setElementSet(this.m_solid);
        this.m_pwPlatonic = new PwPlatonic();
        this.m_pwPlatonic.setGeometry(this.m_solid);
        this.m_pwPlatonic.reset();
        this.m_pwPlatonic.setParent((PsUpdateIf)this);
        this.m_pwModel = new PwModel();
        this.m_pwModel.setParent((PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$discrete$platonic$PjPlatonic != null ? class$vgp$discrete$platonic$PjPlatonic : (class$vgp$discrete$platonic$PjPlatonic = PjPlatonic.class$("vgp.discrete.platonic.PjPlatonic")))) {
            this.init();
        }
    }

    public void setVisibleTube(boolean bl) {
        if (bl == this.m_bShowTube) {
            return;
        }
        this.m_bShowTube = bl;
        this.m_tube.setVisible(bl);
        this.m_tube.setEnabled(bl);
        if (this.m_bShowTube) {
            this.m_tube.setElementSet(this.m_solid);
            this.addGeometry((PgGeometryIf)this.m_tube);
            return;
        }
        this.removeGeometry((PgGeometryIf)this.m_tube);
        this.m_tube.removeElementSet();
    }

    public boolean isVisibleTube() {
        return this.m_bShowTube;
    }

    public boolean update(Object object) {
        if (object == this || object == null) {
            this.m_solid.update((Object)this.m_solid);
            return super.update(object);
        }
        if (object == this.m_pwModel) {
            return super.update(null);
        }
        if (object == this.m_pwPlatonic) {
            this.setSolidName(this.m_pwPlatonic.getSolidName());
            this.m_tube.setName(PsConfig.getMessage((int)45000) + " " + this.m_solidName);
            this.m_solid.setName(this.m_solidName);
            this.m_solid.makeElementColorsFromXYZ();
            this.m_pwModel.setGeometry(this.m_solid);
            if (this.isVisibleModeling()) {
                this.m_pwModel.compute();
            }
            this.update((Object)this);
            return true;
        }
        return super.update(object);
    }

    public void setVisibleSolid(boolean bl) {
        if (bl == this.m_bShowSolid) {
            return;
        }
        this.m_bShowSolid = bl;
        this.m_solid.setVisible(this.m_bShowSolid);
        if (this.m_bShowSolid) {
            this.addGeometry((PgGeometryIf)this.m_solid);
            return;
        }
        this.removeGeometry((PgGeometryIf)this.m_solid);
    }

    public void setVisibleModeling(boolean bl) {
        if (bl == this.m_bShowModeling) {
            return;
        }
        this.m_bShowModeling = bl;
        if (bl) {
            this.m_bShowSolidSave = this.m_bShowSolid;
            this.m_bShowTubeSave = this.m_bShowTube;
            this.setVisibleSolid(true);
            this.setVisibleTube(false);
            this.m_pwModel.setGeometry(this.m_solid);
            this.m_pwModel.compute();
            this.m_pwModel.update((Object)this.m_pwModel);
            return;
        }
        this.setVisibleSolid(this.m_bShowSolidSave);
        this.setVisibleTube(this.m_bShowTubeSave);
        this.m_pwModel.removeGeometry();
        this.m_pwModel.update((Object)this.m_pwModel);
        this.compute();
    }

    public void start() {
        this.compute();
        this.getDisplay().showDepthcue(false);
        this.addGeometry((PgGeometryIf)this.m_tube);
        this.selectGeometry((PgGeometryIf)this.m_tube);
        this.setVisibleSolid(this.m_bShowSolid);
        this.update((Object)this);
        super.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String getSolidName() {
        return this.m_solidName;
    }

    public boolean setSolidName(String string) {
        this.m_solidName = string;
        return this.m_pwPlatonic.setSolidName(this.m_solidName);
    }

    public void init() {
        super.init();
        this.setVisibleModeling(false);
        this.setVisibleSolid(false);
        this.setVisibleTube(true);
        this.m_bShowSolidSave = this.m_bShowSolid;
        this.m_bShowTubeSave = this.m_bShowTube;
        this.m_tube.setDefDiscr(2);
        this.m_tube.setDefThicknessBounds(0.01, 0.5, 0.01, 0.1);
        this.m_tube.setDefThickness(0.1);
        this.m_tube.init();
        this.m_tube.setEnabledInduceColors(true);
        this.m_solid.showElementColors(true);
    }

    public boolean compute() {
        this.m_pwPlatonic.compute();
        this.m_tube.setName(PsConfig.getMessage((int)45000) + " " + this.m_solidName);
        this.m_solid.setName(this.m_solidName);
        this.m_solid.makeElementColorsFromXYZ();
        return true;
    }

    public boolean isVisibleSolid() {
        return this.m_bShowSolid;
    }

    public boolean isVisibleModeling() {
        return this.m_bShowModeling;
    }
}

