/*
 * Decompiled with CFR 0.152.
 */
package vgp.game.mines;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import jv.object.PsConfig;
import jv.object.PsMainFrame;
import jv.project.PjProject;
import jv.viewer.PvViewer;
import vgp.game.mines.PjMinesweeper;

public class PaMinesweeper
extends Applet
implements Runnable {
    protected Frame m_frame = null;
    protected PvViewer m_viewer;
    private String m_drawString = "Initializing ...";

    public void stop() {
        if (this.m_viewer != null) {
            this.m_viewer.stop();
        }
    }

    public void startFromThread() {
        if (this.m_viewer != null) {
            this.m_viewer.start();
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.blue);
        graphics.drawString(PsConfig.getProgram() + " v." + PsConfig.getVersion(), 20, 40);
        graphics.drawString(this.m_drawString, 20, 60);
    }

    public void destroy() {
        if (this.m_viewer != null) {
            this.m_viewer.destroy();
        }
    }

    private void drawMessage(String string) {
        this.m_drawString = string;
        this.repaint();
    }

    public static void main(String[] stringArray) {
        PaMinesweeper paMinesweeper = new PaMinesweeper();
        PsMainFrame psMainFrame = new PsMainFrame((Component)paMinesweeper, stringArray);
        psMainFrame.pack();
        psMainFrame.setBounds(new Rectangle(420, 5, 640, 550));
        paMinesweeper.m_frame = psMainFrame;
        paMinesweeper.init();
        psMainFrame.setVisible(true);
    }

    public String getAppletInfo() {
        return "Name: " + this.getClass().getName() + "\r\n" + "Author:\t\t" + "Ulrich Reitebuch" + "\r\n" + "Version:\t\t" + "09.05.00" + "\r\n" + "Applet demonstrates minesweeper" + "\r\n";
    }

    public void run() {
        this.drawMessage("Loading viewer ...");
        this.m_viewer = new PvViewer((Applet)this, this.m_frame);
        Component component = (Component)this.m_viewer.getDisplay();
        this.drawMessage("Loading geometry ...");
        PjMinesweeper pjMinesweeper = new PjMinesweeper();
        this.m_viewer.addProject((PjProject)pjMinesweeper);
        this.m_viewer.selectProject((PjProject)pjMinesweeper);
        this.setLayout(new BorderLayout());
        this.add(component, "Center");
        this.validate();
        this.m_viewer.showPanel(13);
        this.startFromThread();
    }

    public void init() {
        Thread thread = new Thread((Runnable)this, "JavaView: inititialize applet");
        thread.setPriority(5);
        thread.start();
    }
}

