/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass_Costa
extends PgWeierstrassDescr {
    protected PuInteger m_numULines = new PuInteger("Number of U-Lines", (PsUpdateIf)this);
    protected PuInteger m_numVLines = new PuInteger("Number of V-Lines", (PsUpdateIf)this);
    protected PuDouble m_radius = new PuDouble("Radius", (PsUpdateIf)this);
    protected PuDouble m_radius2 = new PuDouble("Radius2", (PsUpdateIf)this);
    private static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass_Costa;

    public void getReflections(PiVector piVector) {
        if (piVector == null) {
            this.reflectPart(1, 0, 3, 1);
            this.reflectPart(2, 0, 2, 0);
            this.reflectPart(3, 2, 3, 1);
            this.reflectPart(4, 3, 2, 0);
            this.reflectPart(5, 4, 3, 1);
            this.reflectPart(6, 1, 2, 0);
            this.reflectPart(7, 6, 3, 1);
        }
    }

    public PgWeierstrass_Costa() {
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass_Costa != null ? class$vgp$minimal$weier$PgWeierstrass_Costa : (class$vgp$minimal$weier$PgWeierstrass_Costa = PgWeierstrass_Costa.class$("vgp.minimal.weier.PgWeierstrass_Costa")))) {
            this.init();
        }
    }

    public PuComplex g(PiVector piVector, int n, PuComplex puComplex) {
        double d = -0.96776;
        if (puComplex.re == 0.0 && puComplex.im == 0.0) {
            return PuComplex.ZERO;
        }
        return PuComplex.div((PuComplex)new PuComplex(d), (PuComplex)this.w(puComplex));
    }

    public int getDimOfElements() {
        return 4;
    }

    public boolean update(Object object) {
        if (object == this.m_numULines) {
            return ((PsObject)this).m_parent.update((Object)this);
        }
        if (object == this.m_numVLines) {
            return ((PsObject)this).m_parent.update((Object)this);
        }
        if (object == this.m_radius) {
            return ((PsObject)this).m_parent.update((Object)this);
        }
        if (object == this.m_radius2) {
            return ((PsObject)this).m_parent.update((Object)this);
        }
        return super.update(object);
    }

    public double getUMin(PiVector piVector, int n) {
        if (n == 0) {
            return 0.0;
        }
        return 0.0;
    }

    public double getVMin(PiVector piVector, int n) {
        if (n == 0) {
            return 0.0;
        }
        return 0.0;
    }

    public PuComplex f(PiVector piVector, int n, PuComplex puComplex) {
        if (puComplex.re == 0.0 && puComplex.im == 0.0) {
            return PuComplex.ZERO;
        }
        return PuComplex.div((PuComplex)puComplex, (PuComplex)this.w(puComplex));
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PuComplex transform(PiVector piVector, int n, PuComplex puComplex) {
        PuComplex puComplex2 = n == 0 ? PuComplex.polarToRect((double)Math.exp(-puComplex.im * puComplex.im / this.m_radius.getValue()), (double)(puComplex.re * puComplex.re / Math.PI)) : PuComplex.polarToRect((double)Math.exp(puComplex.re * puComplex.re / this.m_radius2.getValue()), (double)(puComplex.im * puComplex.im / Math.PI));
        puComplex2.sub(new PuComplex(1.0));
        puComplex2.mult(PuComplex.I);
        PuComplex puComplex3 = PuComplex.mult((PuComplex)PuComplex.sqrt((PuComplex)PuComplex.I), (PuComplex)PuComplex.sqrt((PuComplex)puComplex2));
        return puComplex3;
    }

    public int getNumULines(PiVector piVector, int n) {
        if (n == 0) {
            return this.m_numULines.getValue();
        }
        return this.m_numVLines.getValue();
    }

    public int getNumVLines(PiVector piVector, int n) {
        if (n == 0) {
            return this.m_numVLines.getValue();
        }
        return this.m_numULines.getValue();
    }

    public void getConnections(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            this.connectPart(1, 3, 0, 0);
        }
        if (piVector == null) {
            this.connectPart(5, 2, 7, 2);
        }
    }

    public boolean connectReflection(PiVector piVector, int n) {
        return true;
    }

    public String getName() {
        return "Costa";
    }

    public int getNumParts(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            return 2;
        }
        return 8;
    }

    public void init() {
        this.m_numULines.setDefBounds(3, 65, 1, 10);
        this.m_numULines.setDefValue(7);
        this.m_numULines.init();
        this.addParameter((PsObject)this.m_numULines);
        this.m_numVLines.setDefBounds(3, 65, 1, 10);
        this.m_numVLines.setDefValue(7);
        this.m_numVLines.init();
        this.addParameter((PsObject)this.m_numVLines);
        this.m_radius.setDefBounds(0.2, 10.0, 0.1, 1.0);
        this.m_radius.setDefValue(4.0);
        this.m_radius.init();
        this.addParameter((PsObject)this.m_radius);
        this.m_radius2.setDefBounds(0.2, 10.0, 0.1, 1.0);
        this.m_radius2.setDefValue(6.0);
        this.m_radius2.init();
        this.addParameter((PsObject)this.m_radius2);
        this.m_intDiscr.setDefBounds(1, 200, 10, 25);
        this.m_intDiscr.setDefValue(50);
        this.m_intDiscr.init();
        this.m_conjugation.setDefBounds(0.0, Math.PI * 2, 0.04908738521234052, 0.7853981633974483);
        this.m_conjugation.setDefValue(0.0);
        this.m_conjugation.init();
        this.addParameter((PsObject)this.m_conjugation);
        super.init();
    }

    public boolean partIsSubdivided(PiVector piVector, int n) {
        return piVector == null && n == 0;
    }

    public double getUMax(PiVector piVector, int n) {
        if (n == 0) {
            return Math.PI;
        }
        return this.m_radius2.getValue();
    }

    public double getVMax(PiVector piVector, int n) {
        if (n == 0) {
            return this.m_radius.getValue();
        }
        return Math.PI;
    }

    public PuComplex w(PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.sub((PuComplex)PuComplex.sqr((PuComplex)puComplex), (PuComplex)PuComplex.ONE);
        puComplex2 = PuComplex.mult((PuComplex)PuComplex.sqrt((PuComplex)PuComplex.mult((PuComplex)puComplex2, (PuComplex)PuComplex.NEG_I)), (PuComplex)PuComplex.sqrt((PuComplex)PuComplex.I));
        puComplex2 = PuComplex.mult((PuComplex)puComplex2, (PuComplex)PuComplex.sqrt((PuComplex)puComplex));
        puComplex2.mult(PuComplex.I);
        return puComplex2;
    }

    public PuComplex[] getFStart(int n) {
        PuComplex[] puComplexArray = new PuComplex[this.m_vertDim];
        puComplexArray[0] = new PuComplex(0.0, 0.0);
        puComplexArray[1] = new PuComplex(0.0, 0.0);
        puComplexArray[2] = new PuComplex(0.0, 0.0);
        return puComplexArray;
    }
}

