/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass_KNoid2
extends PgWeierstrassDescr {
    protected PuInteger m_numULines = new PuInteger("Number of U-Lines", (PsUpdateIf)this);
    protected PuInteger m_numVLines = new PuInteger("Number of V-Lines", (PsUpdateIf)this);
    protected PuInteger m_symmetry;
    protected PuDouble m_radius = new PuDouble("Radius", (PsUpdateIf)this);
    private static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass_KNoid2;

    public void getReflections(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            this.reflectPart(1, 0, 3, 1);
            this.reflectPart(2, 0, 2, 1);
            this.reflectPart(3, 1, 2, 1);
        }
        if (piVector == null) {
            this.returnUserReflections();
        }
    }

    public boolean markBnd() {
        return true;
    }

    public PgWeierstrass_KNoid2() {
        this.m_symmetry = new PuInteger("Symmetry", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass_KNoid2 != null ? class$vgp$minimal$weier$PgWeierstrass_KNoid2 : (class$vgp$minimal$weier$PgWeierstrass_KNoid2 = PgWeierstrass_KNoid2.class$("vgp.minimal.weier.PgWeierstrass_KNoid2")))) {
            this.init();
        }
    }

    public PuComplex g(PiVector piVector, int n, PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex(puComplex);
        int n2 = 1;
        while ((double)n2 < (double)this.m_symmetry.getValue() - 1.0) {
            puComplex2.mult(puComplex);
            ++n2;
        }
        return puComplex2;
    }

    public void getBndReflectType(PiVector piVector, int n, PiVector piVector2) {
        if (this.equals(piVector, 0) && n == 0) {
            piVector2.m_data[0] = 1;
            piVector2.m_data[3] = 1;
            piVector2.m_data[2] = 1;
        }
    }

    public int getDimOfElements() {
        return 4;
    }

    public boolean update(Object object) {
        if (object == this.m_numULines) {
            return ((PsObject)this).m_parent.update((Object)this);
        }
        if (object == this.m_numVLines) {
            return ((PsObject)this).m_parent.update((Object)this);
        }
        if (object == this.m_radius) {
            return ((PsObject)this).m_parent.update((Object)this);
        }
        if (object == this.m_symmetry) {
            return ((PsObject)this).m_parent.update((Object)this);
        }
        return super.update(object);
    }

    public double getUMin(PiVector piVector, int n) {
        return 0.0;
    }

    public double getVMin(PiVector piVector, int n) {
        return 0.0;
    }

    public PuComplex f(PiVector piVector, int n, PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex(puComplex);
        int n2 = 0;
        while ((double)n2 < (double)this.m_symmetry.getValue() - 1.0) {
            puComplex2.mult(puComplex);
            ++n2;
        }
        return PuComplex.mult((PuComplex)PuComplex.I, (PuComplex)PuComplex.inv((PuComplex)PuComplex.sqr((PuComplex)PuComplex.sub((PuComplex)puComplex2, (PuComplex)PuComplex.ONE))));
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PuComplex transform(PiVector piVector, int n, PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.polarToRect((double)(1.0 - puComplex.re), (double)(1.5707963267948966 - puComplex.im));
        puComplex2 = PuComplex.div((PuComplex)PuComplex.sub((PuComplex)puComplex2, (PuComplex)PuComplex.I), (PuComplex)PuComplex.add((PuComplex)puComplex2, (PuComplex)PuComplex.I));
        puComplex2 = PuComplex.polarToRect((double)Math.exp(2.0 / (double)this.m_symmetry.getValue() * Math.log(PuComplex.abs((PuComplex)puComplex2))), (double)(2.0 / (double)this.m_symmetry.getValue() * PuComplex.arg((PuComplex)puComplex2)));
        return puComplex2;
    }

    public int getNumULines(PiVector piVector, int n) {
        return this.m_numULines.getValue();
    }

    public int getNumVLines(PiVector piVector, int n) {
        return this.m_numVLines.getValue();
    }

    public void getConnections(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            this.connectPart(3, 3, 2, 3);
        }
    }

    public boolean connectReflection(PiVector piVector, int n) {
        return true;
    }

    public String getName() {
        return "K-Noid conjugate";
    }

    public int getNumParts(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            return 4;
        }
        return this.m_numUserReflections + 1;
    }

    public void init() {
        this.m_numULines.setDefBounds(3, 65, 1, 10);
        this.m_numULines.setDefValue(7);
        this.m_numULines.init();
        this.addParameter((PsObject)this.m_numULines);
        this.m_numVLines.setDefBounds(3, 65, 1, 10);
        this.m_numVLines.setDefValue(7);
        this.m_numVLines.init();
        this.addParameter((PsObject)this.m_numVLines);
        this.m_radius.setDefBounds(0.2, 1.0, 0.01, 0.1);
        this.m_radius.setDefValue(0.8);
        this.m_radius.init();
        this.addParameter((PsObject)this.m_radius);
        this.m_symmetry.setDefBounds(2, 20, 1, 5);
        this.m_symmetry.setDefValue(3);
        this.m_symmetry.init();
        this.addParameter((PsObject)this.m_symmetry);
        super.init();
        this.m_intDiscr.setDefBounds(1, 100, 1, 10);
        this.m_intDiscr.setDefValue(50);
        this.m_intDiscr.init();
        this.m_conjugation.setDefBounds(0.0, Math.PI * 2, 0.04908738521234052, 0.7853981633974483);
        this.m_conjugation.setDefValue(0.0);
        this.m_conjugation.init();
        this.addParameter((PsObject)this.m_conjugation);
    }

    public boolean partIsSubdivided(PiVector piVector, int n) {
        return piVector == null && n == 0;
    }

    public double getUMax(PiVector piVector, int n) {
        return this.m_radius.getValue();
    }

    public double getVMax(PiVector piVector, int n) {
        return 1.5707963267948966;
    }

    public PuComplex[] getFStart(int n) {
        PuComplex[] puComplexArray = new PuComplex[this.m_vertDim];
        puComplexArray[0] = new PuComplex(0.0, 0.0);
        puComplexArray[1] = new PuComplex(0.0, 0.0);
        puComplexArray[2] = new PuComplex(0.0, 0.0);
        return puComplexArray;
    }
}

