/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.loader;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsMainFrame;
import jv.object.PsUtil;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvDisplayIf;
import jv.viewer.PvViewer;
import vgp.tutor.loader.PgAbcLoader;

public class PaLoader
extends Applet {
    public Frame m_frame = null;
    protected PvViewer m_viewer;

    public void stop() {
        this.m_viewer.stop();
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.blue);
        graphics.drawString("Geometry Browser, Version " + PsConfig.getVersion(), 20, 40);
        graphics.drawString("Loading Projects .....", 20, 60);
    }

    public void destroy() {
        this.m_viewer.destroy();
    }

    public static void main(String[] stringArray) {
        PaLoader paLoader = new PaLoader();
        PsMainFrame psMainFrame = new PsMainFrame((Component)paLoader, stringArray);
        psMainFrame.pack();
        psMainFrame.setBounds(new Rectangle(420, 5, 640, 550));
        psMainFrame.setVisible(true);
        paLoader.m_frame = psMainFrame;
        paLoader.init();
        paLoader.start();
    }

    public void start() {
        this.m_viewer.start();
    }

    public String getAppletInfo() {
        return "Name: " + this.getClass().getName() + "\r\n" + "Author: " + "Konrad Polthier" + "\r\n" + "Version: " + "1.15" + "\r\n" + "Tutorial on usage of parsing an own geometry file format." + "\r\n";
    }

    public void init() {
        String string;
        this.m_viewer = new PvViewer((Applet)this, this.m_frame);
        PvDisplayIf pvDisplayIf = this.m_viewer.getDisplay();
        String string2 = this.m_viewer.getParameter("filename");
        String string3 = PsUtil.getFileExtension((String)string2);
        if (string3 == null) {
            PsDebug.warning((String)("missing extension in file=" + string2));
        }
        PgJvxSrc[] pgJvxSrcArray = null;
        BufferedReader bufferedReader = PsUtil.open((String)(PsConfig.getCodeBase() + string2));
        if (bufferedReader == null) {
            PsDebug.warning((String)("could not open file = " + string2));
        } else {
            PgAbcLoader pgAbcLoader = new PgAbcLoader();
            string = this.m_viewer.getParameter("vgp.tutor.loader.indexfirstvertex");
            if (string != null) {
                int n = Integer.parseInt(string);
                pgAbcLoader.setFirstVertexIndex(n);
            }
            pgJvxSrcArray = pgAbcLoader.read(bufferedReader);
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        if (pgJvxSrcArray == null || pgJvxSrcArray[0] == null) {
            PsDebug.warning((String)("error when reading file = " + string2));
        } else {
            int n = 0;
            while (n < pgJvxSrcArray.length) {
                if (string2 != null) {
                    string = PsUtil.getFileBaseName((String)string2);
                    if (pgJvxSrcArray.length == 1) {
                        pgJvxSrcArray[n].setName(string);
                    } else {
                        pgJvxSrcArray[n].setName(string + "[" + String.valueOf(n) + "]");
                    }
                }
                string = null;
                switch (pgJvxSrcArray[n].getType()) {
                    case 30: {
                        string = new PgPointSet(pgJvxSrcArray[n].getDimOfVertices());
                        break;
                    }
                    case 31: {
                        string = new PgPolygon(pgJvxSrcArray[n].getDimOfVertices());
                        break;
                    }
                    case 32: {
                        string = new PgPolygon(pgJvxSrcArray[n].getDimOfVertices());
                        break;
                    }
                    case 33: {
                        string = new PgElementSet(pgJvxSrcArray[n].getDimOfVertices());
                        break;
                    }
                    default: {
                        PsDebug.warning((String)("geometry[" + n + "] has unknown type = " + pgJvxSrcArray[n].getType()));
                    }
                }
                if (string == null) {
                    string = pgJvxSrcArray[n];
                } else {
                    string.setJvx(pgJvxSrcArray[n]);
                }
                pvDisplayIf.addGeometry((PgGeometryIf)string);
                if (n == 0) {
                    pvDisplayIf.selectGeometry((PgGeometryIf)string);
                }
                ++n;
            }
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_viewer.getDisplay(), "Center");
        this.validate();
    }
}

