/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.BitSet;
import java.util.Date;
import jv.loader.PgLoader;
import jv.loader.PgLoaderIf;
import jv.loader.PvDisplayOption;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgAbcLoader
implements PgLoaderIf {
    protected int m_indexFirstVertex = 0;
    protected PgJvxSrc[] m_geomArr;

    public void setGeometryOption(BitSet bitSet) {
    }

    public boolean isEnabledOptimization() {
        return false;
    }

    protected boolean parse(BufferedReader bufferedReader, PgJvxSrc pgJvxSrc) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.ordinaryChars(47, 47);
        streamTokenizer.ordinaryChars(95, 95);
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.ordinaryChar(45);
        streamTokenizer.ordinaryChar(43);
        streamTokenizer.ordinaryChar(46);
        streamTokenizer.ordinaryChars(48, 48);
        streamTokenizer.ordinaryChars(49, 57);
        streamTokenizer.wordChars(94, 94);
        streamTokenizer.wordChars(38, 38);
        streamTokenizer.wordChars(36, 36);
        streamTokenizer.wordChars(40, 40);
        streamTokenizer.wordChars(41, 41);
        streamTokenizer.wordChars(126, 126);
        streamTokenizer.wordChars(64, 64);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.wordChars(42, 42);
        streamTokenizer.wordChars(48, 48);
        streamTokenizer.wordChars(49, 57);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(44, 44);
        streamTokenizer.wordChars(59, 59);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(58, 58);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.commentChar(35);
        try {
            streamTokenizer.nextToken();
            int n = Integer.parseInt(streamTokenizer.sval);
            PdVector[] pdVectorArray = new PdVector[n];
            int n2 = 0;
            while (n2 < n) {
                pdVectorArray[n2] = new PdVector(3);
                int n3 = 0;
                do {
                    streamTokenizer.nextToken();
                    double d = PgLoader.parseDouble((String)streamTokenizer.sval);
                    pdVectorArray[n2].setEntry(n3, d);
                } while (++n3 < 3);
                ++n2;
            }
            n2 = 0;
            PiVector[] piVectorArray = null;
            streamTokenizer.nextToken();
            if (streamTokenizer.sval != null) {
                n2 = Integer.parseInt(streamTokenizer.sval);
                piVectorArray = new PiVector[n2];
                int n4 = 200;
                int[] nArray = new int[n4];
                streamTokenizer.eolIsSignificant(true);
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                int n5 = 0;
                while (n5 < n2) {
                    int n6 = 0;
                    boolean bl = false;
                    while (!bl) {
                        switch (streamTokenizer.nextToken()) {
                            default: {
                                PsDebug.warning((String)("parsing broke abnormally in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype));
                                return false;
                            }
                            case 10: {
                                bl = true;
                                break;
                            }
                            case -2: {
                                nArray[n6++] = (int)streamTokenizer.nval - this.m_indexFirstVertex;
                            }
                        }
                    }
                    piVectorArray[n5] = new PiVector(n6);
                    piVectorArray[n5].set(nArray, n6);
                    ++n5;
                }
            }
            if (n > 0) {
                pgJvxSrc.setNumVertices(n);
                pgJvxSrc.setVertices(pdVectorArray);
                pgJvxSrc.setDimOfVertices(pdVectorArray[0].getSize());
            }
            if (n2 > 0) {
                pgJvxSrc.setNumElements(n2);
                pgJvxSrc.setElements(piVectorArray);
                int n7 = piVectorArray[0].getSize();
                int n8 = 1;
                while (n8 < n2) {
                    if (piVectorArray[n8].getSize() != n7) {
                        n7 = -1;
                        break;
                    }
                    ++n8;
                }
                pgJvxSrc.setDimOfElements(n7);
            }
        }
        catch (IOException iOException) {
            PsDebug.warning((String)("Exception thrown = " + iOException.toString() + "\n\tparsing broke abnormally in line=" + streamTokenizer.lineno() + ",\n\treading st.sval=" + streamTokenizer.sval + ",\n\tst.ttype=" + streamTokenizer.ttype));
            return false;
        }
        return true;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        if (!this.load(bufferedReader)) {
            return null;
        }
        return this.getGeometries();
    }

    public PgJvxSrc[][] getAnimations() {
        return null;
    }

    public PgJvxSrc[] getGeometries() {
        return this.m_geomArr;
    }

    public PvDisplayOption getDisplayOption() {
        return null;
    }

    public void setDisplayOption(PvDisplayOption pvDisplayOption) {
    }

    public void setAnimation(boolean bl) {
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        writer.write("# Produced with JavaView v." + PsConfig.getVersion() + "\n");
        writer.write("# JavaView is " + PsConfig.getCopyright() + ", " + PsConfig.getHomepage() + "\n");
        writer.write("# by " + PsConfig.getAuthors() + "\n");
        writer.write("#     File Format = ABC (tutorial demonstration)\n");
        writer.write("#     Geometry    = " + pgJvxSrc.getName() + "\n");
        writer.write("#     Date        = " + new Date().toString() + "\n#\n");
        int n = pgJvxSrc.getNumVertices();
        writer.write("#     Number of Vertices    = " + n + "\n");
        int n2 = pgJvxSrc.getNumElements();
        writer.write("#     Number of Elements\t   = " + n2 + "\n");
        writer.write("#     Index of First Vertex = " + this.m_indexFirstVertex + "\n");
        writer.write("#\n# End of Header\n");
        PdVector[] pdVectorArray = pgJvxSrc.getVertices();
        writer.write(String.valueOf(n) + "\n");
        int n3 = 0;
        while (n3 < n) {
            writer.write(PuString.toString((double[])pdVectorArray[n3].m_data) + "\n");
            ++n3;
        }
        PiVector[] piVectorArray = pgJvxSrc.getElements();
        writer.write(String.valueOf(n2) + "\n");
        int n4 = 0;
        while (n4 < n2) {
            int n5 = piVectorArray[n4].m_data.length;
            if (n5 == 0) {
                PsDebug.warning((String)("Missing vertex references in element[" + n4 + "]"));
                return false;
            }
            String string = String.valueOf(piVectorArray[n4].m_data[0] + this.m_indexFirstVertex);
            int n6 = 1;
            while (n6 < n5) {
                string = string + " " + String.valueOf(piVectorArray[n4].m_data[n6] + this.m_indexFirstVertex);
                ++n6;
            }
            writer.write(string + "\n");
            ++n4;
        }
        return true;
    }

    public boolean load(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing reader");
            return false;
        }
        PgJvxSrc pgJvxSrc = new PgJvxSrc();
        if (!this.parse(bufferedReader, pgJvxSrc)) {
            PsDebug.warning((String)"error during parsing of reader");
            return false;
        }
        if (pgJvxSrc.getNumElements() == 0) {
            pgJvxSrc.setType(30);
            pgJvxSrc.showVertices(true);
            pgJvxSrc.setGlobalVertexSize(1.0);
        } else {
            pgJvxSrc.setType(33);
            pgJvxSrc.assureNeighbours();
            pgJvxSrc.showEdges(true);
            pgJvxSrc.showElements(true);
        }
        this.m_geomArr = new PgJvxSrc[]{pgJvxSrc};
        return true;
    }

    public int getFirstVertexIndex() {
        return this.m_indexFirstVertex;
    }

    public void setFirstVertexIndex(int n) {
        this.m_indexFirstVertex = n;
    }

    public boolean isAnimation() {
        return false;
    }

    public PgGeometryIf[] getSpecializedGeometries() {
        return null;
    }
}

