/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.lsystem;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PjProject_IP;
import vgp.tutor.lsystem.PjLSystem;

public class PjLSystem_IP
extends PjProject_IP
implements ActionListener,
ItemListener {
    protected PjLSystem m_pjLSystem;
    protected Button m_bReset;
    protected PsPanel m_pBounds;
    protected PsPanel m_pSystem;
    protected PsPanel m_pRules;
    protected int m_numLetters;
    protected TextField m_tAlphabet;
    protected TextField m_tAxiom;
    protected TextField[] m_tRule;
    protected TextArea m_tTree;
    protected Checkbox m_cAutoFit;
    protected Checkbox m_cCurrentState;
    private static /* synthetic */ Class class$vgp$tutor$lsystem$PjLSystem_IP;

    public PjLSystem_IP() {
        if (this.getClass() == (class$vgp$tutor$lsystem$PjLSystem_IP != null ? class$vgp$tutor$lsystem$PjLSystem_IP : (class$vgp$tutor$lsystem$PjLSystem_IP = PjLSystem_IP.class$("vgp.tutor.lsystem.PjLSystem_IP")))) {
            this.init();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_project == null) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object == this.m_cAutoFit) {
            this.m_pjLSystem.m_bAutoFit = this.m_cAutoFit.getState();
            if (this.m_cAutoFit.getState()) {
                this.m_pjLSystem.fitDisplays();
            }
            this.m_pjLSystem.m_bAutoFit = this.m_cAutoFit.getState();
            return;
        }
        if (object == this.m_cCurrentState) {
            if (this.m_cCurrentState.getState()) {
                PsPanel.setText((TextComponent)this.m_tTree, (String)this.m_pjLSystem.m_lsystem.getTree());
            } else {
                PsPanel.setText((TextComponent)this.m_tTree, (String)"");
            }
            this.m_pjLSystem.m_bCurrentState = this.m_cCurrentState.getState();
        }
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_pjLSystem = (PjLSystem)psUpdateIf;
        this.m_pBounds.removeAll();
        this.m_pBounds.add((Component)this.m_pjLSystem.m_numIterations.getInfoPanel());
        this.m_pBounds.add((Component)this.m_pjLSystem.m_delta.getInfoPanel());
        char[] cArray = this.m_pjLSystem.m_lsystem.m_alphabet;
        this.m_numLetters = cArray.length;
        this.m_pRules.removeAll();
        this.m_pRules.addSubTitle("Replacement Rules");
        this.m_tRule = new TextField[this.m_numLetters];
        int n = 0;
        while (n < this.m_numLetters) {
            this.m_tRule[n] = new TextField();
            this.m_tRule[n].addActionListener(this);
            this.m_pRules.addLabelComponent(String.valueOf(cArray[n]), (Component)this.m_tRule[n]);
            ++n;
        }
        this.m_pRules.validate();
        PsPanel.setText((TextComponent)this.m_tTree, (String)this.m_pjLSystem.m_lsystem.getTree());
    }

    public boolean update(Object object) {
        if (this.m_pjLSystem == object) {
            PsPanel.setText((TextComponent)this.m_tAlphabet, (String)new String(this.m_pjLSystem.m_lsystem.m_alphabet));
            PsPanel.setText((TextComponent)this.m_tAxiom, (String)this.m_pjLSystem.m_lsystem.m_axiom);
            int n = 0;
            while (n < this.m_numLetters) {
                PsPanel.setText((TextComponent)this.m_tRule[n], (String)this.m_pjLSystem.m_lsystem.m_rule[n]);
                ++n;
            }
            this.m_cCurrentState.setState(this.m_pjLSystem.m_bCurrentState);
            if (this.m_cCurrentState.getState()) {
                PsPanel.setText((TextComponent)this.m_tTree, (String)this.m_pjLSystem.m_lsystem.getTree());
            } else {
                PsPanel.setText((TextComponent)this.m_tTree, (String)"");
            }
            this.m_cAutoFit.setState(this.m_pjLSystem.m_bAutoFit);
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_pjLSystem == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object != this.m_tAlphabet) {
            if (object == this.m_tAxiom) {
                this.m_pjLSystem.m_lsystem.m_axiom = this.m_tAxiom.getText();
            } else if (object == this.m_bReset) {
                this.m_pjLSystem.m_lsystem.init();
                this.m_pjLSystem.init();
                this.m_pjLSystem.start();
            } else {
                int n = 0;
                while (n < this.m_numLetters) {
                    if (object == this.m_tRule[n]) {
                        this.m_pjLSystem.m_lsystem.m_rule[n] = this.m_tRule[n].getText();
                        break;
                    }
                    ++n;
                }
            }
        }
        this.m_pjLSystem.recompute();
        this.m_pjLSystem.update((Object)this.m_pjLSystem);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        PsPanel psPanel = new PsPanel();
        psPanel.setLayout(new GridLayout(1, 2));
        psPanel.addTitle("L-System");
        this.m_cAutoFit = new Checkbox("Auto Fit");
        this.m_cAutoFit.addItemListener(this);
        psPanel.add(this.m_cAutoFit);
        ((Container)((Object)this)).add((Component)psPanel);
        this.m_pSystem = new PsPanel();
        ((Container)((Object)this)).add((Component)this.m_pSystem);
        this.m_tAlphabet = new TextField();
        this.m_tAlphabet.addActionListener(this);
        this.m_tAlphabet.setEditable(false);
        this.m_pSystem.addLabelComponent("Alphabet", (Component)this.m_tAlphabet);
        this.m_tAxiom = new TextField();
        this.m_tAxiom.addActionListener(this);
        this.m_pSystem.addLabelComponent("Axiom", (Component)this.m_tAxiom);
        this.m_pRules = new PsPanel();
        this.m_pSystem.add((Component)this.m_pRules);
        this.m_pBounds = new PsPanel();
        ((Container)((Object)this)).add((Component)this.m_pBounds);
        PsPanel psPanel2 = new PsPanel();
        psPanel2.setLayout(new GridLayout(1, 2));
        psPanel2.addSubTitle("Current State");
        this.m_cCurrentState = new Checkbox("Show State");
        this.m_cCurrentState.addItemListener(this);
        psPanel2.add(this.m_cCurrentState);
        ((Container)((Object)this)).add((Component)psPanel2);
        this.m_tTree = new TextArea("", 5, 20, 1);
        this.m_tTree.setEditable(false);
        ((Container)((Object)this)).add(this.m_tTree);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1));
        this.m_bReset = new Button("Reset");
        this.m_bReset.addActionListener(this);
        panel.add(this.m_bReset);
        ((Container)((Object)this)).add(panel);
    }
}

