/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.texture;

import java.awt.Image;
import java.util.Enumeration;
import jv.geom.PgElementSet;
import jv.geom.PgTexture;
import jv.objectGui.PsImage;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.vecmath.PdVector;

public class PjTexturedSurface
extends PjProject {
    protected PgElementSet m_geom;
    protected PsImage m_image;
    protected String m_defaultImageFile;
    protected String m_imageFile;
    protected String m_surfaceName;
    protected int m_numULines;
    protected int m_numVLines;
    private static /* synthetic */ Class class$vgp$tutor$texture$PjTexturedSurface;

    public PjTexturedSurface() {
        super("Textured Surface");
        this.m_imageFile = this.m_defaultImageFile = "vgp/tutor/texture/images/Water.jpg";
        this.m_surfaceName = "torus";
        this.m_numULines = 15;
        this.m_numVLines = 10;
        this.m_geom = new PgElementSet(3);
        if (((Object)((Object)this)).getClass() == (class$vgp$tutor$texture$PjTexturedSurface != null ? class$vgp$tutor$texture$PjTexturedSurface : (class$vgp$tutor$texture$PjTexturedSurface = PjTexturedSurface.class$("vgp.tutor.texture.PjTexturedSurface")))) {
            this.init();
        }
    }

    public boolean update(Object object) {
        if (object == this.getInspector("Info")) {
            Enumeration enumeration = this.m_geom.getDisplays();
            while (enumeration.hasMoreElements()) {
                PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
                if (this.m_image != null) {
                    pvDisplayIf.setBackgroundImage(this.m_image.getImage());
                } else {
                    pvDisplayIf.setBackgroundImage(null);
                }
                pvDisplayIf.update(null);
            }
            return true;
        }
        return super.update(object);
    }

    public void start() {
        PdVector[] pdVectorArray;
        PvViewerIf pvViewerIf = this.getViewer();
        if (pvViewerIf != null) {
            String string;
            pdVectorArray = pvViewerIf.getParameter("vgp.tutor.texture.PjTexturedSurface#surface");
            if (pdVectorArray != null) {
                this.m_surfaceName = pdVectorArray;
            }
            if ((string = pvViewerIf.getParameter("vgp.tutor.texture.PjTexturedSurface#image")) != null) {
                this.m_imageFile = string;
            }
        }
        if (this.m_surfaceName.equalsIgnoreCase("torus")) {
            this.m_geom.computeTorus(this.m_numULines, this.m_numVLines, 2.0, 1.0);
        } else if (this.m_surfaceName.equalsIgnoreCase("sphere")) {
            this.m_geom.computeSphere(this.m_numULines, this.m_numVLines, 5.0);
        } else {
            this.m_geom.computePlane(this.m_numULines, this.m_numVLines, 0.0, 0.0, 5.0, 5.0);
        }
        this.m_geom.makeVertexNormals();
        this.m_geom.makeElementNormals();
        this.m_geom.showBackface(false);
        this.m_geom.showEdges(false);
        this.m_geom.setName("Textured Surface");
        this.m_geom.setDimOfTextures(2);
        this.m_geom.assureVertexTextures();
        this.m_geom.showVertexTexture(true);
        pdVectorArray = this.m_geom.getVertexTextures();
        double d = 1.0 / (-1.0 + (double)this.m_numULines);
        double d2 = 1.0 / (-1.0 + (double)this.m_numVLines);
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numULines) {
            double d3 = d * (double)n2;
            int n3 = 0;
            while (n3 < this.m_numVLines) {
                double d4 = d2 * (double)n3;
                pdVectorArray[n].m_data[0] = d3;
                pdVectorArray[n].m_data[1] = d4;
                ++n;
                ++n3;
            }
            ++n2;
        }
        PsImage psImage = new PsImage(this.m_imageFile);
        if (psImage != null) {
            psImage.loadImage();
            Image image = psImage.getImage();
            if (image != null) {
                PgTexture pgTexture = new PgTexture();
                pgTexture.setImage(image);
                this.m_geom.setTexture(pgTexture);
                this.m_geom.update((Object)this.m_geom);
            }
        }
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        this.getDisplay().showDepthcue(true);
        super.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        this.m_geom.computeTorus(this.m_numULines, this.m_numVLines, 2.0, 1.0);
        this.m_geom.makeVertexNormals();
        this.m_geom.makeElementNormals();
        this.m_geom.showBackface(false);
        this.m_geom.showEdges(false);
        super.init();
    }
}

