/*
 * Decompiled with CFR 0.152.
 */
package vgp.vector.hodge;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.object.PsConfig;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jvx.geom.PwHodge;
import jvx.geom.PwVectorField;
import jvx.surface.PgDomain;
import jvx.surface.PgDomainDescr;

public class PjHodge
extends PjProject {
    protected static final int m_dimOfDomain = 2;
    protected PgElementSet m_domain = new PgElementSet(2);
    protected PgDomain m_copy;
    protected PgDomainDescr m_descrCopy;
    protected PwHodge m_hodge;
    protected PwVectorField m_vec;
    private double m_UMin = 0.0;
    private double m_UMax = 0.0;
    private double m_VMin = 0.0;
    private double m_VMax = 0.0;
    private int m_ULines = -1;
    private int m_VLines = -1;
    private int m_numVF = 0;
    protected boolean m_bUpdateSender = false;
    private static /* synthetic */ Class class$vgp$vector$hodge$PjHodge;

    private void memorizeStatus() {
        this.m_UMin = this.m_descrCopy.getUMin();
        this.m_VMin = this.m_descrCopy.getVMin();
        this.m_UMax = this.m_descrCopy.getUMax();
        this.m_VMax = this.m_descrCopy.getVMax();
        this.m_ULines = this.m_descrCopy.getNumULines();
        this.m_VLines = this.m_descrCopy.getNumVLines();
        this.m_numVF = this.m_domain.getNumVectorFields();
    }

    private boolean checkForChange() {
        return this.m_UMin == this.m_descrCopy.getUMin() && this.m_VMin == this.m_descrCopy.getVMin() && this.m_UMax == this.m_descrCopy.getUMax() && this.m_VMax == this.m_descrCopy.getVMax() && this.m_ULines == this.m_descrCopy.getNumULines() && this.m_VLines == this.m_descrCopy.getNumVLines() && this.m_numVF == this.m_domain.getNumVectorFields() && this.m_domain.getVectorField(this.m_numVF - 1).getBasedOn() == 1;
    }

    public PjHodge() {
        super("Potential");
        this.m_domain.setName(PsConfig.getMessage((int)75010));
        this.m_domain.setParent((PsUpdateIf)this);
        this.m_domain.setGlobalVectorColor(Color.black);
        this.m_copy = new PgDomain(2);
        this.m_copy.setName(PsConfig.getMessage((int)75011));
        this.m_copy.setParent((PsUpdateIf)this);
        this.m_copy.setGlobalVectorColor(Color.black);
        this.m_hodge = new PwHodge();
        this.m_hodge.setParent((PsUpdateIf)this);
        this.m_hodge.setIconScale(3.0E-4);
        this.m_vec = new PwVectorField(this.getDisplay());
        if (((Object)((Object)this)).getClass() == (class$vgp$vector$hodge$PjHodge != null ? class$vgp$vector$hodge$PjHodge : (class$vgp$vector$hodge$PjHodge = PjHodge.class$("vgp.vector.hodge.PjHodge")))) {
            this.init();
        }
    }

    public boolean update(Object object) {
        if (object == null || this.m_bUpdateSender) {
            return super.update(null);
        }
        if (object == this.m_copy) {
            if (this.updateGeometry()) {
                this.m_bUpdateSender = true;
                this.m_vec.update((Object)this.m_vec);
                this.m_domain.update((Object)this.m_domain);
                this.m_bUpdateSender = false;
            }
            return super.update(null);
        }
        if (object == this.m_domain) {
            if (this.updateGeometry()) {
                this.m_bUpdateSender = true;
                this.m_vec.update((Object)this.m_vec);
                this.m_domain.update((Object)this.m_domain);
                this.m_bUpdateSender = false;
            }
            return super.update(null);
        }
        if (object == this.m_hodge) {
            return true;
        }
        return super.update(object);
    }

    public void start() {
        super.start();
        this.m_hodge.setViewer(this.getViewer());
        this.m_domain.removeAllVectorFields();
        this.m_vec.clearCenter();
        this.m_vec.makeNewVF(1);
        this.m_vec.setDisplay(this.getDisplay());
        this.m_domain.showEdges(false);
        this.m_domain.showElements(false);
        this.addGeometry((PgGeometryIf)this.m_domain);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        if (pvDisplayIf != null) {
            pvDisplayIf.setMajorMode(5);
            pvDisplayIf.selectCamera(1);
        }
        this.m_vec.addCenter(new PdVector(-2.5, -2.5), 0, 0.9);
        this.m_vec.addCenter(1, 0.5);
        this.m_vec.update((Object)this.m_vec);
        this.fitDisplays();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void dispose() {
        this.m_hodge.close();
        super.dispose();
    }

    public void init() {
        super.init();
        this.m_descrCopy = this.m_copy.getDescr();
        this.m_descrCopy.setMaxSize(-10.0, -10.0, 10.0, 10.0);
        this.m_descrCopy.setSize(-5.0, -5.0, 5.0, 5.0);
        this.m_descrCopy.setDiscrBounds(2, 2, 50, 50);
        this.m_descrCopy.setDiscr(10, 10);
        this.m_copy.compute();
        this.m_domain.copy((PsObject)this.m_copy);
        PgElementSet.triangulate((PgElementSet)this.m_domain);
        this.m_vec.setEnabledConvert(false);
        this.m_vec.setGeometry((PgPointSet)this.m_domain);
    }

    private boolean updateGeometry() {
        if (!this.checkForChange()) {
            this.m_hodge.stop();
            this.m_copy.removeAllVectorFields();
            int n = 1;
            int n2 = 0;
            while (n2 < n) {
                PgVectorField pgVectorField = new PgVectorField(2);
                pgVectorField.setBasedOn(1);
                pgVectorField.setGeometry((PgPointSet)this.m_copy);
                pgVectorField.setName("Vector Field");
                this.m_copy.addVectorField(pgVectorField);
                ++n2;
            }
            this.memorizeStatus();
            this.m_domain.copy((PsObject)this.m_copy);
            PgElementSet.triangulate((PgElementSet)this.m_domain);
            this.m_domain.makeElementNormals();
            this.m_vec.setGeometry((PgPointSet)this.m_domain);
            if (n > 0) {
                this.m_hodge.setVectorField(this.m_domain, 0);
            }
            return true;
        }
        return false;
    }
}

