/*
 * Decompiled with CFR 0.152.
 */
package vgp.vector.lic;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgTexture;
import jv.geom.PgVectorField;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.viewer.PvDisplay;
import jvx.geom.PwIntegralLines;
import jvx.geom.PwLIC;
import jvx.geom.PwVectorField;
import jvx.numeric.PnElementRK;
import jvx.numeric.PnGeodesicRK;
import jvx.numeric.PnLIC;
import jvx.numeric.PnVertexRK;
import jvx.surface.PgDomain;
import jvx.surface.PgDomainDescr;

public class PjLIC
extends PjProject
implements ActionListener,
Runnable {
    protected PwLIC m_lic;
    protected PgDomain m_domain;
    protected PgDomainDescr m_descr;
    protected PwVectorField m_vec;
    protected PwIntegralLines m_integral;
    private double m_UMin = 0.0;
    private double m_UMax = 0.0;
    private double m_VMin = 0.0;
    private double m_VMax = 0.0;
    private int m_ULines = -1;
    private int m_VLines = -1;
    protected boolean m_bAutoUpdateLIC = true;
    private PgVectorField m_vf;
    private Thread m_thread;
    int[] pix = null;
    PnGeodesicRK rk = null;
    PgTexture tex = null;
    Frame frame = new Frame();
    MemoryImageSource mis = null;
    Image image = null;
    PdVector[] texvec = null;
    PdBaryDir[] baryvec = null;
    double[] len = null;
    PdVector[] pixTexCoord = null;
    boolean[] computedVec = null;
    boolean[] computedCoord = null;
    int imageWidth = 0;
    int imageHeight = 0;
    private static /* synthetic */ Class class$vgp$vector$lic$PjLIC;

    public PjLIC() {
        super("LIC");
        this.m_vec = new PwVectorField(this.getDisplay());
        this.m_lic = new PwLIC();
        this.m_integral = new PwIntegralLines();
        this.m_integral.addActionListener((ActionListener)this);
        this.m_domain = new PgDomain(2);
        this.m_domain.setName("Domain with Vector Field");
        this.m_domain.setParent((PsUpdateIf)this);
        if (this.getClass() == (class$vgp$vector$lic$PjLIC != null ? class$vgp$vector$lic$PjLIC : (class$vgp$vector$lic$PjLIC = PjLIC.class$("vgp.vector.lic.PjLIC")))) {
            this.init();
        }
    }

    public boolean update(Object object) {
        if (object == this.m_domain) {
            if (!this.checkDescr()) {
                this.m_lic.stopLIC();
                this.memorizeDescr();
                int n = this.m_domain.getNumVectorFields();
                int n2 = 0;
                while (n2 < n) {
                    this.m_domain.getVectorField(n2).setGeometry((PgPointSet)this.m_domain);
                    ++n2;
                }
                this.m_domain.showElementTexture(false);
                this.m_domain.setElementTextures(null);
                PgElementSet.triangulate((PgElementSet)this.m_domain);
                this.autoUpdateLICIfEnabled();
            }
            return super.update(null);
        }
        if (object == this.m_vf) {
            if (this.checkDescr()) {
                this.autoUpdateLICIfEnabled();
            }
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_integral && this.getDisplay() != null && this.m_integral.getIntegralLines() != null) {
            this.getDisplay().setDrawingOrder(1, (PgGeometryIf)this.m_integral.getIntegralLines());
            this.getDisplay().update((Object)this.getDisplay());
        }
    }

    private void autoUpdateLICIfEnabled() {
        if (this.m_vf == null || !this.m_bAutoUpdateLIC || this.m_lic.isComputingLIC()) {
            return;
        }
        this.m_bAutoUpdateLIC = false;
        if (this.m_thread == null) {
            this.m_thread = new Thread(this);
            this.m_thread.start();
        }
    }

    public void start() {
        super.start();
        if (this.getDisplay() != null) {
            this.getDisplay().selectCamera(1);
            this.getDisplay().setMajorMode(5);
            this.m_integral.setDisplay(this.getDisplay());
        }
        this.update(this.m_domain);
        this.m_vec.setDisplay(this.getDisplay());
        this.m_vec.setGeometry((PgPointSet)this.m_domain);
        this.m_vec.makeNewVF(1);
        this.m_vec.addCenter(new PdVector(-2.5, -2.5), 0);
        this.m_vec.addCenter(1);
        this.m_vf = this.m_domain.getVectorField(0);
        this.m_vf.addUpdateListener((PsUpdateIf)this);
        this.m_domain.showVectorFields(false);
        this.m_domain.showEdges(false);
        this.m_domain.showElements(false);
        this.m_domain.setGlobalVectorColor(Color.black);
        this.addGeometry((PgGeometryIf)this.m_domain);
        this.m_vf.update(null);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void run() {
        this.m_vec.setEnabledUpdates(false);
        if (this.m_vf.getBasedOn() == 1) {
            if (this.rk == null || !(this.rk instanceof PnElementRK)) {
                this.rk = new PnElementRK((PgElementSet)this.m_domain);
            }
            ((PnElementRK)this.rk).setVectorField(this.m_vf);
        } else {
            if (this.rk == null || !(this.rk instanceof PnVertexRK)) {
                this.rk = new PnVertexRK((PgElementSet)this.m_domain);
            }
            ((PnVertexRK)this.rk).setVectorField(this.m_vf);
        }
        PnLIC pnLIC = this.m_lic.getNumericLICInstance();
        if (this.m_lic.getTextureSize().width == 0 || this.m_lic.getTextureSize().height == 0 || this.m_domain.getElementTextures() == null) {
            this.m_lic.computeTextureSize();
            this.pix = null;
        }
        pnLIC.setRungeKutta(this.rk);
        if (this.pix == null || this.imageWidth != this.m_lic.getTextureSize().width || this.imageHeight != this.m_lic.getTextureSize().height) {
            this.imageWidth = pnLIC.getTextureWidth();
            this.imageHeight = pnLIC.getTextureHeight();
            this.pix = new int[this.imageWidth * this.imageHeight];
            this.mis = new MemoryImageSource(this.imageWidth, this.imageHeight, this.pix, 0, this.imageWidth);
            this.mis.setAnimated(true);
            this.image = null;
        }
        pnLIC.setWorldConvolutionWidth((double)this.m_lic.getConvolutionWidth() / 100.0);
        pnLIC.setCoarseness(this.m_lic.getCoarseness());
        pnLIC.setStepSize(this.m_lic.getStepSize());
        int n = this.m_domain.getNumElements();
        pnLIC.reset();
        if (this.texvec == null || this.texvec.length != n) {
            this.texvec = new PdVector[n];
            this.baryvec = new PdBaryDir[n];
            this.len = new double[n];
            this.pixTexCoord = new PdVector[3 * n];
            this.computedVec = new boolean[n];
            this.computedCoord = new boolean[n];
        }
        int n2 = 0;
        while (n2 < n) {
            this.computedVec[n2] = false;
            this.computedCoord[n2] = false;
            ++n2;
        }
        n2 = n - 1;
        while (n2 >= 0) {
            pnLIC.makeFastElement(n2, this.texvec, this.baryvec, this.len, this.pixTexCoord, this.computedVec, this.computedCoord);
            --n2;
        }
        this.pix = pnLIC.getPixArray(this.pix, this.m_lic.getContrast());
        this.mis.newPixels(0, 0, this.imageWidth, this.imageHeight);
        if (this.m_domain.getTexture() == null) {
            this.m_domain.setTexture(new PgTexture());
        }
        if (this.tex != this.m_domain.getTexture() || this.image != this.tex.getImage()) {
            this.tex = this.m_domain.getTexture();
            this.image = this.frame.createImage(this.mis);
            this.tex.setImage(this.image);
        }
        this.m_domain.showElements(true);
        this.m_domain.showElementTexture(true);
        this.m_domain.update(null);
        if (this.getDisplay() != null && this.getDisplay() instanceof PvDisplay) {
            ((PvDisplay)this.getDisplay()).repaint();
        }
        this.m_vec.setEnabledUpdates(true);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {}
        this.m_bAutoUpdateLIC = true;
        this.m_thread = null;
    }

    public void init() {
        super.init();
        this.m_descr = this.m_domain.getDescr();
        this.m_descr.setMaxSize(-10.0, -10.0, 10.0, 10.0);
        this.m_descr.setSize(-5.0, -5.0, 5.0, 5.0);
        this.m_descr.setDiscrBounds(2, 2, 50, 50);
        this.m_descr.setDiscr(9, 9);
        this.m_domain.compute();
        PgElementSet.triangulate((PgElementSet)this.m_domain);
        this.m_lic.setGeometry((PgElementSet)this.m_domain);
        this.m_lic.setFast(true);
        this.m_lic.setLICSize(50);
    }

    private void memorizeDescr() {
        this.m_UMin = this.m_descr.getUMin();
        this.m_VMin = this.m_descr.getVMin();
        this.m_UMax = this.m_descr.getUMax();
        this.m_VMax = this.m_descr.getVMax();
        this.m_ULines = this.m_descr.getNumULines();
        this.m_VLines = this.m_descr.getNumVLines();
    }

    private boolean checkDescr() {
        return this.m_UMin == this.m_descr.getUMin() && this.m_VMin == this.m_descr.getVMin() && this.m_UMax == this.m_descr.getUMax() && this.m_VMax == this.m_descr.getVMax() && this.m_ULines == this.m_descr.getNumULines() && this.m_VLines == this.m_descr.getNumVLines();
    }
}

