/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.function.PuFunction;
import jv.geom.PgPolygon;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;

public class PgParmCurve
extends PgPolygon {
    protected PuFunction m_function;
    protected PuDouble m_uMin;
    protected PuDouble m_uMax;
    protected PuInteger m_numPoints;
    private static /* synthetic */ Class class$jvx$geom$PgParmCurve;

    public PgParmCurve() {
        this(3);
    }

    public PgParmCurve(int n) {
        super(n);
        this.setTag(7);
        this.setFunction(new PuFunction(1, n));
        this.m_function.setName(PsConfig.getMessage((int)15044));
        this.m_uMin = new PuDouble("u-" + PsConfig.getMessage((int)54000), (PsUpdateIf)this);
        this.m_uMax = new PuDouble("u-" + PsConfig.getMessage((int)54001), (PsUpdateIf)this);
        this.m_numPoints = new PuInteger(PsConfig.getMessage((int)54002), (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PgParmCurve != null ? class$jvx$geom$PgParmCurve : (class$jvx$geom$PgParmCurve = PgParmCurve.class$("jvx.geom.PgParmCurve")))) {
            this.init();
        }
    }

    public boolean computeCurve() {
        int n = this.m_numPoints.getValue();
        double d = this.m_uMin.getValue();
        double d2 = (this.m_uMax.getValue() - d) / (double)(n - 1);
        this.setNumVertices(n);
        double[] dArray = new double[1];
        PdVector pdVector = new PdVector(((PgGeometry)this).m_dim);
        int n2 = 0;
        dArray[0] = d;
        int n3 = 0;
        while (n3 < n) {
            this.m_function.eval(pdVector.m_data, dArray);
            this.setVertex(n2, pdVector);
            ++n2;
            dArray[0] = dArray[0] + d2;
            ++n3;
        }
        return true;
    }

    public boolean update(Object object) {
        if (object == this.m_function) {
            this.computeCurve();
            return super.update((Object)this);
        }
        if (object == this.m_numPoints) {
            if (this.m_numPoints.getValue() <= 1) {
                this.m_numPoints.setValue(2);
            }
            this.computeCurve();
            return super.update((Object)this);
        }
        if (object == this.m_uMin) {
            if (this.m_uMin.getValue() > this.m_uMax.getValue()) {
                this.m_uMax.setValue(this.m_uMin.getValue());
            } else {
                this.computeCurve();
            }
            return super.update((Object)this);
        }
        if (object == this.m_uMax) {
            if (this.m_uMax.getValue() < this.m_uMin.getValue()) {
                this.m_uMin.setValue(this.m_uMax.getValue());
            } else {
                this.computeCurve();
            }
            return super.update((Object)this);
        }
        return super.update(object);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean setFunction(PuFunction puFunction) {
        if (puFunction == null) {
            PsDebug.warning((String)"missing function");
            return false;
        }
        if (puFunction.getNumFunctions() != this.getDimOfVertices()) {
            PsDebug.warning((String)"number of functions different than dimension of vertices.");
            return false;
        }
        this.m_function = puFunction;
        this.m_function.setParent((PsUpdateIf)this);
        return true;
    }

    public void init() {
        super.init();
        this.showVertices(false);
        this.setGlobalEdgeSize(2.0);
        this.m_function.setExpression(0, "cos(u)*sin(u)*u");
        this.m_function.setExpression(1, "sin(u)*u");
        this.m_function.setExpression(2, "u/5");
        this.m_uMin.setDefBounds(-100.0, 100.0, 0.1, 5.0);
        this.m_uMin.setDefValue(-25.0);
        this.m_uMin.init();
        this.m_uMax.setDefBounds(-100.0, 100.0, 0.1, 5.0);
        this.m_uMax.setDefValue(25.0);
        this.m_uMax.init();
        this.m_numPoints.setDefBounds(2, 1000, 1, 5);
        this.m_numPoints.setDefValue(300);
        this.m_numPoints.init();
        this.computeCurve();
    }
}

