/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.number.PdColor;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.project.PjWorkshop;

public class PnCellOperator
extends PjWorkshop
implements PvPickListenerIf,
Runnable {
    public static final int LIFE = 0;
    public static final int MAJORITY = 1;
    protected int rule;
    public static final int NEIGHBOUR = 0;
    public static final int CORONA = 1;
    protected int influence;
    protected int m_sleepTime;
    protected PgElementSet m_geom;
    protected Color[] m_color;
    protected static final int SET_ELEMENT_TAG = 0;
    protected static final int SET_COLOR = 1;
    protected int m_outputType = 0;
    protected PiVector m_markI;
    protected int m_numStates = 2;
    protected PiVector[] m_infCell;
    protected PiVector[] m_geomElement;
    protected PiVector[] m_geomNeighbour;
    protected Thread m_thread;
    protected int m_numLoops;
    protected int m_currLoop;
    protected boolean m_bMarkGlider;
    protected boolean m_bUseGlobalElementColor;
    protected boolean m_bHasElementColors;
    protected boolean m_bShowTaggedElements;
    protected Color[] m_originalColors;
    private static /* synthetic */ Class class$jvx$geom$PnCellOperator;

    public void setRule(int n) {
        this.rule = n;
    }

    public int ruleOfLife(int n) {
        int n2 = 0;
        int n3 = this.m_infCell[n].getSize();
        int n4 = 0;
        while (n4 < n3) {
            if (this.getState(this.m_infCell[n].m_data[n4]) > 0) {
                n2 += this.getState(this.m_infCell[n].m_data[n4]);
            }
            ++n4;
        }
        n2 = this.m_markI.m_data[this.m_infCell[n].m_data[0]] == 1 ? (n2 > 2 && n2 < 5 ? 1 : 0) : (n2 == 3 ? 1 : 0);
        return n2;
    }

    public void stop() {
        this.m_thread = null;
    }

    public void setNumStates(int n) {
        if (n > 0) {
            this.m_numStates = n;
        }
    }

    public int getNumStates() {
        return this.m_numStates;
    }

    public void requestPick() {
        Vector vector = this.m_geom.getDisplayList();
        if (vector != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                PvDisplayIf pvDisplayIf = (PvDisplayIf)vector.elementAt(n2);
                pvDisplayIf.addPickListener((PvPickListenerIf)this);
                pvDisplayIf.requestPickFocus((PvPickListenerIf)this);
                ++n2;
            }
        }
    }

    public int getState(int n) {
        if (n < 0) {
            return -1;
        }
        return this.m_markI.m_data[n];
    }

    public int getNumLoops() {
        return this.m_numLoops;
    }

    public void setNumLoops(int n) {
        this.m_numLoops = n;
    }

    public void setCurrLoop(int n) {
        this.m_currLoop = n;
    }

    public void makeInfluence() {
        if (this.influence == 0) {
            this.makeNeighbourInfluence();
        }
        if (this.influence == 1) {
            this.makeCoronaInfluence();
        }
    }

    public boolean update(Object object) {
        if (object == this.m_geom) {
            if (this.isUpdateSender()) {
                return true;
            }
            if (this.isModal()) {
                return true;
            }
            this.setGeometry(this.m_geom);
            this.reset();
            this.evaluate();
            this.setUpdateSender(true);
            this.m_geom.update((Object)this.m_geom);
            this.setUpdateSender(false);
            return true;
        }
        return super.update(object);
    }

    public void evaluate() {
        if (this.m_outputType == 1) {
            this.setColors();
            return;
        }
        if (this.m_outputType == 0) {
            this.setElementTags();
        }
    }

    public void dragInitial(PvPickEvent pvPickEvent) {
        this.pickInitial(pvPickEvent);
    }

    public int cellOperator(int n) {
        if (this.rule == 0) {
            return this.ruleOfLife(n);
        }
        if (this.rule == 1) {
            return this.ruleOfMajority(n);
        }
        return 0;
    }

    public void start() {
        if (this.m_currLoop >= this.m_numLoops) {
            return;
        }
        this.m_thread = new Thread((Runnable)this, "JavaView: " + PsConfig.getMessage((int)48002));
        this.m_thread.setPriority(5);
        this.m_thread.start();
    }

    public void dragVertex(PgGeometryIf pgGeometryIf, int n, PdVector pdVector) {
        this.pickVertex(pgGeometryIf, n, pdVector);
    }

    public void setOutputType(int n) {
        this.m_outputType = n;
        if (n == 1) {
            this.m_bUseGlobalElementColor = !this.m_geom.isShowingElementColors();
            this.m_bHasElementColors = this.m_geom.hasElementColors();
            if (this.m_bHasElementColors) {
                this.m_originalColors = PdColor.copyNew((Color[])this.m_geom.getElementColors());
            }
            this.m_color = new Color[2];
            this.m_color[0] = this.m_bUseGlobalElementColor ? this.m_geom.getGlobalElementColor() : new Color(0, 95, 159);
            this.m_color[1] = new Color(255, 0, 0);
            this.m_geom.assureElementColors();
            this.m_geom.showElementColors(true);
            return;
        }
        if (n == 0) {
            this.m_geom.showTaggedElements(true);
        }
    }

    public void unmarkVertices(PvPickEvent pvPickEvent) {
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        if (pvPickEvent.getGeometry() != this.m_geom) {
            return;
        }
        this.markElement(pvPickEvent.getElementInd());
        this.evaluate();
        this.update(this);
    }

    public void markVertices(PvPickEvent pvPickEvent) {
    }

    public void close() {
        this.releasePick();
        if (this.m_geom != null) {
            this.m_geom.removeUpdateListener((PsUpdateIf)this);
            if (this.m_outputType == 1) {
                this.restoreColors();
            }
            this.m_geom.update((Object)this.m_geom);
        }
        super.close();
    }

    public void setInfluence(int n) {
        this.influence = n;
    }

    public void setInfluence(String string) {
        if (string.equalsIgnoreCase("NEIGHBOUR")) {
            this.influence = 0;
            return;
        }
        if (string.equalsIgnoreCase("CORONA")) {
            this.influence = 1;
        }
    }

    public void reset() {
        super.reset();
        if (this.m_geom == null) {
            return;
        }
        if (this.m_markI == null) {
            this.m_markI = new PiVector();
        }
        this.m_markI.setSize(this.m_geom.getNumElements());
        this.m_markI.setConstant(0);
        this.m_infCell = PiVector.realloc((PiVector[])this.m_infCell, (int)this.m_geom.getNumElements());
        this.makeInfluence();
    }

    public void restoreColors() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing geometry");
            return;
        }
        this.m_geom.showElementColors(!this.m_bUseGlobalElementColor);
        if (this.m_bHasElementColors) {
            this.m_geom.setElementColors(this.m_originalColors);
        }
    }

    public PnCellOperator() {
        super(PsConfig.getMessage((int)48000));
        if (this.getClass() == (class$jvx$geom$PnCellOperator != null ? class$jvx$geom$PnCellOperator : (class$jvx$geom$PnCellOperator = PnCellOperator.class$("jvx.geom.PnCellOperator")))) {
            this.init();
        }
    }

    public PnCellOperator(PgElementSet pgElementSet) {
        this();
        this.setGeometry(pgElementSet);
        this.reset();
    }

    public Color getColor(int n) {
        return this.m_color[n];
    }

    public void setColor(int n, Color color) {
        this.m_color[n] = color;
    }

    public void selectGeometry(PgGeometryIf pgGeometryIf) {
    }

    public void setGeometry(PgElementSet pgElementSet) {
        super.setGeometry((PgGeometry)pgElementSet);
        if (this.m_geom != null) {
            this.m_geom.removeUpdateListener((PsUpdateIf)this);
        }
        this.m_geom = pgElementSet;
        this.m_geom.addUpdateListener((PsUpdateIf)this);
        this.requestPick();
        this.setName(PsConfig.getMessage((int)48001) + " " + this.m_geom.getName());
        this.m_bShowTaggedElements = this.m_geom.isShowingTaggedElements();
        this.m_geom.showTaggedElements(true);
        this.m_geomElement = this.m_geom.getElements();
        this.m_geomNeighbour = this.m_geom.getNeighbours();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void releasePick() {
        Vector vector = this.m_geom.getDisplayList();
        if (vector != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                PvDisplayIf pvDisplayIf = (PvDisplayIf)vector.elementAt(n2);
                pvDisplayIf.releasePickFocus();
                pvDisplayIf.removePickListener((PvPickListenerIf)this);
                ++n2;
            }
        }
    }

    public void dragDisplay(PvPickEvent pvPickEvent) {
        this.pickDisplay(pvPickEvent);
    }

    public void markGlider(int n, int n2) {
        if (this.m_infCell[n].getSize() != 9) {
            PsDebug.warning((String)("Can't generate glider at Cell " + n + " - wrong number of Influence Cells"));
            return;
        }
        this.m_markI.m_data[this.m_infCell[n].m_data[0]] = 0;
        if (this.m_infCell[n].m_data[(1 + n2) % 4 + 1] != -1) {
            this.m_markI.m_data[this.m_infCell[n].m_data[(1 + n2) % 4 + 1]] = 1;
        }
        if (this.m_infCell[n].m_data[(2 + n2) % 4 + 1] != -1) {
            this.m_markI.m_data[this.m_infCell[n].m_data[(2 + n2) % 4 + 1]] = 1;
        }
        if (this.m_infCell[n].m_data[(3 + n2) % 4 + 1] != -1) {
            this.m_markI.m_data[this.m_infCell[n].m_data[(3 + n2) % 4 + 1]] = 1;
        }
        if (this.m_infCell[n].m_data[(4 + n2) % 4 + 1] != -1) {
            this.m_markI.m_data[this.m_infCell[n].m_data[(4 + n2) % 4 + 1]] = 0;
        }
        if (n2 % 8 < 4) {
            if (this.m_infCell[n].m_data[(1 + n2) % 4 + 5] != -1) {
                this.m_markI.m_data[this.m_infCell[n].m_data[(1 + n2) % 4 + 5]] = 1;
            }
            if (this.m_infCell[n].m_data[(2 + n2) % 4 + 5] != -1) {
                this.m_markI.m_data[this.m_infCell[n].m_data[(2 + n2) % 4 + 5]] = 0;
            }
            if (this.m_infCell[n].m_data[(3 + n2) % 4 + 5] != -1) {
                this.m_markI.m_data[this.m_infCell[n].m_data[(3 + n2) % 4 + 5]] = 0;
            }
            if (this.m_infCell[n].m_data[(4 + n2) % 4 + 5] != -1) {
                this.m_markI.m_data[this.m_infCell[n].m_data[(4 + n2) % 4 + 5]] = 1;
                return;
            }
        } else {
            if (this.m_infCell[n].m_data[(1 + n2) % 4 + 5] != -1) {
                this.m_markI.m_data[this.m_infCell[n].m_data[(1 + n2) % 4 + 5]] = 0;
            }
            if (this.m_infCell[n].m_data[(2 + n2) % 4 + 5] != -1) {
                this.m_markI.m_data[this.m_infCell[n].m_data[(2 + n2) % 4 + 5]] = 1;
            }
            if (this.m_infCell[n].m_data[(3 + n2) % 4 + 5] != -1) {
                this.m_markI.m_data[this.m_infCell[n].m_data[(3 + n2) % 4 + 5]] = 1;
            }
            if (this.m_infCell[n].m_data[(4 + n2) % 4 + 5] != -1) {
                this.m_markI.m_data[this.m_infCell[n].m_data[(4 + n2) % 4 + 5]] = 0;
            }
        }
    }

    public void clear() {
        int n = this.m_markI.getSize();
        int n2 = 0;
        while (n2 < n) {
            this.m_markI.m_data[n2] = 0;
            ++n2;
        }
        this.evaluate();
    }

    public void makeNeighbourInfluence() {
        int n = this.m_geom.getNumElements();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.m_geomNeighbour[n2].getSize();
            this.m_infCell[n2] = new PiVector(n3 + 1);
            this.m_infCell[n2].m_data[0] = n2;
            int n4 = 0;
            while (n4 < n3) {
                this.m_infCell[n2].m_data[n4 + 1] = this.m_geomNeighbour[n2].m_data[n4];
                ++n4;
            }
            ++n2;
        }
    }

    public void makeCoronaInfluence() {
        PgVertexStar pgVertexStar = new PgVertexStar();
        int n = this.m_geom.getNumElements();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.m_geomElement[n2].getSize();
            this.m_infCell[n2] = new PiVector(n3 + 1);
            this.m_infCell[n2].m_data[0] = n2;
            int n4 = this.m_geomNeighbour[n2].m_data[n3 - 2];
            int n5 = n3 + 1;
            int n6 = 0;
            while (n6 < n3) {
                int n7;
                this.m_infCell[n2].m_data[n6 + 1] = this.m_geomNeighbour[n2].m_data[n6];
                pgVertexStar.makeVertexStar(this.m_geom, this.m_geomElement[n2].m_data[n6], n2);
                PiVector piVector = pgVertexStar.getElement();
                int n8 = n4;
                n4 = this.m_geomNeighbour[n2].m_data[(n6 + n3 - 1) % n3];
                int n9 = piVector.getSize();
                if (pgVertexStar.isClosed()) {
                    this.m_infCell[n2].setSize(n5 + piVector.getSize() - 3);
                    n7 = 0;
                    while (n7 < n9) {
                        if (piVector.m_data[n7] != n2 && piVector.m_data[n7] != n8 && piVector.m_data[n7] != n4) {
                            this.m_infCell[n2].m_data[n5] = piVector.m_data[n7];
                            ++n5;
                        }
                        ++n7;
                    }
                } else {
                    n7 = 0;
                    while (n7 < n9) {
                        if (piVector.m_data[n7] != n2 && piVector.m_data[n7] != n8 && piVector.m_data[n7] != n4) {
                            this.m_infCell[n2].setSize(n5 + 1);
                            this.m_infCell[n2].m_data[n5] = piVector.m_data[n7];
                            ++n5;
                        }
                        ++n7;
                    }
                }
                ++n6;
            }
            ++n2;
        }
    }

    public void pickDisplay(PvPickEvent pvPickEvent) {
    }

    public void run() {
        while (this.m_thread != null) {
            ++this.m_currLoop;
            if (this.m_currLoop > this.m_numLoops) {
                this.stop();
            }
            this.compute();
            this.update(this);
            try {
                Thread.sleep(this.m_sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void init() {
        super.init();
        this.setNumLoops(1000);
        this.m_sleepTime = 50;
        this.m_bMarkGlider = false;
        this.rule = 0;
        this.influence = 1;
    }

    public void markElement(int n) {
        if (this.m_bMarkGlider) {
            this.markGlider(n, 1);
            return;
        }
        this.m_markI.m_data[n] = (this.m_markI.m_data[n] + 1) % this.m_numStates;
    }

    public void markElement(int n, int n2) {
        if (n2 > -1 && n2 < this.m_numStates) {
            this.m_markI.m_data[n] = n2;
        }
    }

    public void compute() {
        PiVector piVector = PiVector.copyNew((PiVector)this.m_markI);
        int n = this.m_markI.getSize();
        int n2 = 0;
        while (n2 < n) {
            piVector.m_data[n2] = this.cellOperator(n2);
            ++n2;
        }
        this.m_markI.copy(piVector);
        this.evaluate();
    }

    public void setColors() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing geometry");
            return;
        }
        int n = this.m_geom.getNumElements();
        int n2 = 0;
        while (n2 < n) {
            this.m_geom.setElementColor(n2, this.m_color[this.m_markI.m_data[n2]]);
            ++n2;
        }
    }

    public int ruleOfMajority(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.m_infCell[n].getSize();
        int n5 = 0;
        while (n5 < n4) {
            if (this.getState(this.m_infCell[n].m_data[n5]) > -1) {
                n2 += this.getState(this.m_infCell[n].m_data[n5]);
                ++n3;
            }
            ++n5;
        }
        n2 = 2 * n2 > n3 ? 1 : 0;
        return n2;
    }

    public void pickVertex(PgGeometryIf pgGeometryIf, int n, PdVector pdVector) {
    }

    public void setElementTags() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing geometry");
            return;
        }
        int n = this.m_geom.getNumElements();
        int n2 = 0;
        while (n2 < n) {
            if (this.m_markI.m_data[n2] > 0) {
                this.m_geom.setTagElement(n2, 1);
            } else {
                this.m_geom.clearTagElement(n2, 1);
            }
            ++n2;
        }
    }

    public void setRule(String string) {
        if (string.equalsIgnoreCase("Life")) {
            this.rule = 0;
            return;
        }
        if (string.equals("Majority")) {
            this.rule = 1;
        }
    }
}

