/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.util.BitSet;
import java.util.Vector;
import jv.geom.PgPointSet;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PnTree {
    protected PgPointSet[] m_pointSet;
    protected Vector[] m_position;
    protected PdVector m_bndBoxMin;
    protected PdVector m_bndBoxMax;
    protected int m_dim;
    protected boolean[] m_bUseVector;
    protected Vector[] m_vertex;

    public void setElement(int n, PiVector piVector) {
        if (this.m_position[0].size() > n) {
            this.m_position[0].setElementAt(this.computePosition(0, piVector), n);
            return;
        }
        this.m_position[0].addElement(this.computePosition(0, piVector));
    }

    public void setElement(int n, int n2, PiVector piVector) {
        if (this.m_position[n].size() > n2) {
            this.m_position[n].setElementAt(this.computePosition(n, piVector), n2);
            return;
        }
        this.m_position[n].addElement(this.computePosition(n, piVector));
    }

    public PnTree(PgPointSet pgPointSet) {
        this(new PgPointSet[]{pgPointSet});
    }

    public PnTree(PgPointSet pgPointSet, PgPointSet pgPointSet2) {
        this(new PgPointSet[]{pgPointSet, pgPointSet2});
    }

    public PnTree(PgPointSet[] pgPointSetArray) {
        this.m_pointSet = pgPointSetArray;
        this.computeBndBox();
        int n = pgPointSetArray.length;
        this.m_position = new Vector[n];
        this.m_bUseVector = new boolean[n];
        this.m_vertex = new Vector[n];
        int n2 = 0;
        while (n2 < n) {
            this.m_position[n2] = new Vector();
            this.m_bUseVector[n2] = false;
            ++n2;
        }
    }

    public void removeElement(int n) {
        this.m_position[0].removeElementAt(n);
    }

    public void removeElement(int n, int n2) {
        this.m_position[n].removeElementAt(n2);
    }

    public void setVertices(int n, Vector vector) {
        if (vector != null) {
            this.m_vertex[n] = vector;
            this.m_bUseVector[n] = true;
            return;
        }
        this.m_bUseVector[n] = false;
    }

    public void setElements(PiVector[] piVectorArray, int n) {
        this.m_position[0].removeAllElements();
        int n2 = 0;
        while (n2 < n) {
            this.m_position[0].addElement(this.computePosition(0, piVectorArray[n2]));
            ++n2;
        }
    }

    public void setElements(int n, PiVector[] piVectorArray, int n2) {
        this.m_position[n].removeAllElements();
        int n3 = 0;
        while (n3 < n2) {
            this.m_position[n].addElement(this.computePosition(n, piVectorArray[n3]));
            ++n3;
        }
    }

    private boolean[][] computePosition(int n, PiVector piVector) {
        int n2;
        int n3;
        Object object;
        int n4;
        PgPointSet pgPointSet = this.m_pointSet[n];
        int n5 = piVector.getSize();
        PdVector[] pdVectorArray = new PdVector[n5];
        if (this.m_bUseVector[n]) {
            n4 = 0;
            while (n4 < n5) {
                pdVectorArray[n4] = (PdVector)this.m_vertex[n].elementAt(piVector.m_data[n4]);
                ++n4;
            }
        } else {
            n4 = 0;
            while (n4 < n5) {
                pdVectorArray[n4] = pgPointSet.getVertex(piVector.m_data[n4]);
                ++n4;
            }
        }
        BitSet[] bitSetArray = new BitSet[this.m_dim];
        int n6 = 0;
        while (n6 < this.m_dim) {
            bitSetArray[n6] = new BitSet();
            ++n6;
        }
        if (n5 == 1) {
            boolean[][] blArray = new boolean[this.m_dim][1];
            int n7 = 0;
            while (n7 < this.m_dim) {
                blArray[n7][0] = true;
                ++n7;
            }
            return blArray;
        }
        double d = 0.0;
        int n8 = 1;
        while (n8 < n5) {
            double d2 = PdVector.sqrDist((PdVector)pdVectorArray[0], (PdVector)pdVectorArray[n8]);
            if (d2 > d) {
                d = d2;
            }
            ++n8;
        }
        if (d == 0.0) {
            boolean[][] blArray = new boolean[this.m_dim][1];
            int n9 = 0;
            while (n9 < this.m_dim) {
                blArray[n9][0] = true;
                ++n9;
            }
            return blArray;
        }
        PdVector pdVector = PdVector.copyNew((PdVector)this.m_bndBoxMin);
        PdVector pdVector2 = PdVector.copyNew((PdVector)this.m_bndBoxMax);
        boolean bl = true;
        boolean[] blArray = new boolean[this.m_dim];
        int n10 = 0;
        while (bl) {
            object = PdVector.blendNew((double)0.5, (PdVector)pdVector, (double)0.5, (PdVector)pdVector2);
            n3 = 0;
            while (n3 < this.m_dim) {
                if (pdVectorArray[0].m_data[n3] > object.m_data[n3]) {
                    blArray[n3] = true;
                    pdVector.m_data[n3] = object.m_data[n3];
                } else {
                    blArray[n3] = false;
                    pdVector2.m_data[n3] = object.m_data[n3];
                }
                ++n3;
            }
            n3 = 1;
            while (n3 < n5) {
                n2 = 0;
                while (n2 < this.m_dim) {
                    if (pdVectorArray[n3].m_data[n2] > pdVector2.m_data[n2] || pdVectorArray[n3].m_data[n2] < pdVector.m_data[n2]) {
                        bl = false;
                    }
                    ++n2;
                }
                ++n3;
            }
            if (!bl) continue;
            n3 = 0;
            while (n3 < this.m_dim) {
                if (blArray[n3]) {
                    bitSetArray[n3].set(n10);
                } else {
                    bitSetArray[n3].clear(n10);
                }
                ++n3;
            }
            ++n10;
        }
        object = new boolean[this.m_dim][n10 + 1];
        n3 = 0;
        while (n3 < this.m_dim) {
            object[n3][0] = (PdVector)true;
            ++n3;
        }
        n3 = 0;
        while (n3 < n10) {
            n2 = 0;
            while (n2 < this.m_dim) {
                object[n2][n3 + 1] = (PdVector)bitSetArray[n2].get(n3);
                ++n2;
            }
            ++n3;
        }
        return object;
    }

    public void addElement(PiVector piVector) {
        this.m_position[0].addElement(this.computePosition(0, piVector));
    }

    public void addElement(int n, PiVector piVector) {
        this.m_position[n].addElement(this.computePosition(n, piVector));
    }

    public boolean compare(int n, int n2) {
        int n3;
        int n4;
        boolean[][] blArray = (boolean[][])this.m_position[0].elementAt(n);
        boolean[][] blArray2 = (boolean[][])this.m_position[0].elementAt(n2);
        int n5 = blArray2[0].length;
        if (n5 < (n4 = (n3 = blArray[0].length))) {
            n4 = n5;
        }
        int n6 = 0;
        while (n6 < n4) {
            int n7 = 0;
            while (n7 < this.m_dim) {
                if (blArray[n7][n6] != blArray2[n7][n6]) {
                    return false;
                }
                ++n7;
            }
            ++n6;
        }
        return true;
    }

    public boolean compare(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        boolean[][] blArray = (boolean[][])this.m_position[n].elementAt(n2);
        boolean[][] blArray2 = (boolean[][])this.m_position[n3].elementAt(n4);
        int n7 = blArray2[0].length;
        if (n7 < (n6 = (n5 = blArray[0].length))) {
            n6 = n7;
        }
        int n8 = 0;
        while (n8 < n6) {
            int n9 = 0;
            while (n9 < this.m_dim) {
                if (blArray[n9][n8] != blArray2[n9][n8]) {
                    return false;
                }
                ++n9;
            }
            ++n8;
        }
        return true;
    }

    private void computeBndBox() {
        int n = this.m_pointSet.length;
        PdVector[] pdVectorArray = new PdVector[n];
        PdVector[] pdVectorArray2 = new PdVector[n];
        this.m_dim = 0;
        int n2 = 0;
        while (n2 < n) {
            if (this.m_pointSet[n2].getDimOfVertices() > this.m_dim) {
                this.m_dim = this.m_pointSet[n2].getDimOfVertices();
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            PdVector[] pdVectorArray3 = this.m_pointSet[n2].getAmbientBounds();
            if (pdVectorArray3 != null) {
                pdVectorArray3[0].setSize(this.m_dim);
                pdVectorArray3[1].setSize(this.m_dim);
                pdVectorArray[n2] = pdVectorArray3[0];
                pdVectorArray2[n2] = pdVectorArray3[1];
            }
            ++n2;
        }
        this.m_bndBoxMin = new PdVector(this.m_dim);
        this.m_bndBoxMax = new PdVector(this.m_dim);
        PdVector.min((PdVector)this.m_bndBoxMin, (PdVector[])pdVectorArray, (int)n);
        PdVector.max((PdVector)this.m_bndBoxMax, (PdVector[])pdVectorArray2, (int)n);
    }
}

