/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.object.PsDebug;
import jv.object.PsObject;

public final class PuPriorityQueue
extends PsObject {
    protected int[] m_elements;
    protected int[] m_positions;
    protected double[] m_keys;
    protected int m_heapSize;

    public int getCapacity() {
        return this.m_elements.length;
    }

    public int getElement(int n) {
        return this.m_elements[n];
    }

    public boolean enqueue(int n, double d) {
        if (this.m_positions[n] < this.m_heapSize) {
            return false;
        }
        this.m_keys[n] = Double.MAX_VALUE;
        this.m_elements[this.m_heapSize] = n;
        this.m_positions[n] = this.m_heapSize++;
        this.changeKey(n, d);
        return true;
    }

    public PuPriorityQueue(int n) {
        this.m_elements = new int[n];
        this.m_positions = new int[n];
        this.m_keys = new double[n];
        this.m_heapSize = 0;
        double d = Double.MAX_VALUE;
        int n2 = 0;
        while (n2 < n) {
            this.m_keys[n2] = d;
            this.m_elements[n2] = -1;
            this.m_positions[n2] = Integer.MAX_VALUE;
            ++n2;
        }
    }

    public PuPriorityQueue(double[] dArray) {
        this.m_elements = new int[dArray.length];
        this.m_positions = new int[dArray.length];
        this.m_keys = new double[dArray.length];
        this.m_heapSize = dArray.length;
        int n = 0;
        while (n < dArray.length) {
            this.m_keys[n] = dArray[n];
            this.m_elements[n] = n;
            this.m_positions[n] = n;
            ++n;
        }
        n = this.m_heapSize >> 1;
        while (n >= 0) {
            this.heapify(n);
            --n;
        }
    }

    public PuPriorityQueue(int n, double d) {
        this.m_elements = new int[n];
        this.m_positions = new int[n];
        this.m_keys = new double[n];
        this.m_heapSize = n;
        int n2 = 0;
        while (n2 < n) {
            this.m_keys[n2] = d;
            this.m_elements[n2] = n2;
            this.m_positions[n2] = n2;
            ++n2;
        }
    }

    protected final void heapify(int n) {
        while (true) {
            int n2 = (n << 1) + 1;
            int n3 = (n << 1) + 2;
            int n4 = n;
            if (n2 < this.m_heapSize && this.m_keys[this.m_elements[n2]] < this.m_keys[this.m_elements[n]]) {
                n4 = n2;
            }
            if (n3 < this.m_heapSize && this.m_keys[this.m_elements[n3]] < this.m_keys[this.m_elements[n4]]) {
                n4 = n3;
            }
            if (n4 == n) {
                return;
            }
            int n5 = this.m_elements[n];
            this.m_positions[n5] = n4;
            this.m_elements[n] = this.m_elements[n4];
            this.m_positions[this.m_elements[n4]] = n;
            this.m_elements[n4] = n5;
            n = n4;
        }
    }

    public double getKeyOfMin() {
        if (this.m_heapSize < 1) {
            PsDebug.warning((String)"cannot return the key of the minimun, because the heap is empty.");
            return Double.POSITIVE_INFINITY;
        }
        return this.m_keys[this.m_elements[0]];
    }

    public int extractMin() {
        if (this.m_heapSize <= 1) {
            if (this.m_heapSize == 1) {
                this.m_heapSize = 0;
                this.m_positions[this.m_elements[0]] = Integer.MAX_VALUE;
                return this.m_elements[0];
            }
            return -1;
        }
        int n = this.m_elements[0];
        this.m_positions[n] = Integer.MAX_VALUE;
        this.m_positions[this.m_elements[this.m_heapSize - 1]] = 0;
        this.m_elements[0] = this.m_elements[this.m_heapSize - 1];
        this.m_heapSize += -1;
        this.heapify(0);
        return n;
    }

    public boolean isElement(int n) {
        return this.m_positions[n] < this.m_heapSize;
    }

    public int[] getElements() {
        return this.m_elements;
    }

    public int getHeapSize() {
        return this.m_heapSize;
    }

    public boolean increaseKey(int n, double d) {
        if (this.m_positions[n] >= this.m_heapSize) {
            return false;
        }
        if (this.m_keys[n] > d) {
            return false;
        }
        this.m_keys[n] = d;
        this.heapify(this.m_positions[n]);
        return true;
    }

    protected final int parent(int n) {
        if (n == 0) {
            return -1;
        }
        return n - 1 >> 1;
    }

    public void emptyHeap() {
        double d = Double.MAX_VALUE;
        int n = this.m_heapSize - 1;
        while (n >= 0) {
            this.m_keys[this.m_elements[n]] = d;
            this.m_positions[this.m_elements[n]] = Integer.MAX_VALUE;
            this.m_elements[n] = -1;
            --n;
        }
        this.m_heapSize = 0;
    }

    protected final int left(int n) {
        return (n << 1) + 1;
    }

    public int[] getPositions() {
        return this.m_positions;
    }

    public int getPosition(int n) {
        if (n < 0 || this.m_positions.length <= n) {
            PsDebug.warning((String)("specified element: " + n + " " + "is out of the range of the heap."));
            return -1;
        }
        if (this.m_positions[n] < this.m_heapSize) {
            return this.m_positions[n];
        }
        return -1;
    }

    public double getKey(int n) {
        if (n < 0 || this.m_positions.length <= n) {
            PsDebug.warning((String)("specified element: " + n + " " + "is out of the range of the heap."));
            return Double.POSITIVE_INFINITY;
        }
        return this.m_keys[n];
    }

    protected final int right(int n) {
        return (n << 1) + 2;
    }

    public boolean decreaseKey(int n, double d) {
        if (this.m_positions[n] >= this.m_heapSize) {
            return false;
        }
        if (this.m_keys[n] < d) {
            return false;
        }
        int n2 = this.m_positions[n];
        int n3 = n2 - 1 >> 1;
        this.m_keys[n] = d;
        while (n3 >= 0 && this.m_keys[n] < this.m_keys[this.m_elements[n3]]) {
            int n4 = this.m_elements[n2];
            int n5 = n2;
            this.m_positions[this.m_elements[n2]] = n3;
            this.m_elements[n2] = this.m_elements[n3];
            this.m_positions[this.m_elements[n3]] = n5;
            this.m_elements[n3] = n4;
            n2 = n3;
            n3 = n2 - 1 >> 1;
        }
        return true;
    }

    public double[] getKeys() {
        return this.m_keys;
    }

    public boolean changeKey(int n, double d) {
        if (this.m_positions[n] >= this.m_heapSize) {
            return false;
        }
        if (this.m_keys[n] < d) {
            this.increaseKey(n, d);
        } else if (this.m_keys[n] > d) {
            this.decreaseKey(n, d);
        }
        return true;
    }

    public Object clone() {
        PuPriorityQueue puPriorityQueue = (PuPriorityQueue)((Object)super.clone());
        puPriorityQueue.m_heapSize = this.m_heapSize;
        int n = 0;
        while (n < this.m_keys.length) {
            puPriorityQueue.m_keys[n] = this.m_keys[n];
            puPriorityQueue.m_elements[n] = this.m_elements[n];
            puPriorityQueue.m_positions[n] = this.m_positions[n];
            ++n;
        }
        return puPriorityQueue;
    }

    public boolean enqueueOrDecrease(int n, double d) {
        if (this.m_positions[n] < this.m_heapSize) {
            if (d < this.m_keys[n]) {
                this.decreaseKey(n, d);
                return true;
            }
            return false;
        }
        this.enqueue(n, d);
        return true;
    }
}

