/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PgVertexStar;

public final class PwBary {
    private static PgElementSet m_prevGeom = null;
    private static int m_prevElement = -1;
    private static double m_AA;
    private static double m_BB;
    private static double m_CC;
    private static double m_AB;
    private static double m_BC;
    private static double m_AC;
    private static final double m_eps = 1.0E-10;
    private static PdBaryDir m_tmpEdge1;
    private static PdBaryDir m_tmpEdge2;
    private static PdBaryDir m_tmpEdge3;
    private static PdBaryDir m_tmpEdge4;
    private static PdVector[] m_projVert;
    private static PdVector m_projN;
    private static PdVector m_rotVertAngles;
    private static PgVertexStar m_rotVertStar;
    private static PdBaryDir m_rotVertEdge;
    private static PdBaryDir m_rotVertHalf;
    private static PdBaryDir m_rotVertNormal;
    private static PdBaryDir m_angleEdge;
    private static double[] m_angleOriented;
    private static PdBaryDir[] m_angleVectors;
    private static final String errormsg = "Elements degenerated in element set.";

    public static PdBaryDir[] getTransRepresentation(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, int n2, PiVector piVector, PiVector piVector2) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return null;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"Missing vector.");
            return null;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)"Invalid element.");
            return null;
        }
        if (n2 < 0 || n2 >= 3) {
            PsDebug.warning((String)"Invalid vertex.");
            return null;
        }
        PdVector pdVector = new PdVector(1);
        double d = PwBary.getTransRepresentationValues(pgElementSet, n, pdBaryDir, n2, piVector, piVector2, pdVector);
        double d2 = PwBary.norm(pgElementSet, n, pdBaryDir, false);
        int n3 = piVector.getSize();
        PdBaryDir[] pdBaryDirArray = new PdBaryDir[n3];
        PdBaryDir pdBaryDir2 = new PdBaryDir(3);
        PdBaryDir pdBaryDir3 = new PdBaryDir(3);
        int n4 = 0;
        while (n4 < n3) {
            int n5 = piVector.getEntry(n4);
            int n6 = piVector2.getEntry(n4);
            double d3 = pdVector.getEntry(n4);
            pdBaryDir2.m_data[n6] = -1.0;
            pdBaryDir2.m_data[(n6 + 1) % 3] = 1.0;
            pdBaryDir2.m_data[(n6 + 2) % 3] = 0.0;
            pdBaryDir3.m_data[n6] = -1.0;
            pdBaryDir3.m_data[(n6 + 1) % 3] = 0.0;
            pdBaryDir3.m_data[(n6 + 2) % 3] = 1.0;
            double d4 = PwBary.norm(pgElementSet, n5, pdBaryDir2, false);
            if (d4 < 1.0E-10) {
                PsDebug.warning((String)"Edges degenerated.");
            } else {
                pdBaryDir2.multScalar(1.0 / d4);
            }
            double d5 = PwBary.getOrientedAngle(pgElementSet, n5, pdBaryDir2, pdBaryDir3, false) / 2.0;
            double d6 = d5 - Math.PI * 2 / d * (d3 + d5);
            pdBaryDirArray[n4] = new PdBaryDir(3);
            PwBary.rotateInElement(pgElementSet, n5, pdBaryDir2, d6, pdBaryDirArray[n4], false);
            pdBaryDirArray[n4].multScalar(d2);
            ++n4;
        }
        return pdBaryDirArray;
    }

    public static int rotateAtEdge(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, int n2, PdBaryDir pdBaryDir2, PdBary pdBary, double d, boolean bl) {
        double d2;
        while (d < 0.0) {
            d += Math.PI * 2;
        }
        while (d > Math.PI * 2) {
            d -= Math.PI * 2;
        }
        PdBaryDir pdBaryDir3 = new PdBaryDir(3);
        pdBaryDir3.copy(PdBaryDir.TRIANGLE_EDGE[n2]);
        pdBaryDir3.multScalar(-1.0);
        double d3 = PwBary.getOrientedAngle(pgElementSet, n, pdBaryDir, pdBaryDir3, bl);
        if (d3 < 0.0) {
            d3 += Math.PI * 2;
        }
        if ((d2 = d - d3) > 0.0 && d2 < Math.PI) {
            d -= d3;
            int n3 = pgElementSet.getNeighbour(n).getEntry(n2);
            if (n3 == -1) {
                return -1;
            }
            int n4 = pgElementSet.getOppVertexLocInd(n, n2);
            PwBary.rotateInElement(pgElementSet, n3, PdBaryDir.TRIANGLE_EDGE[n4], d, pdBaryDir2, false);
            double d4 = PwBary.norm(pgElementSet, n3, pdBaryDir2, false);
            if (d4 < 1.0E-10) {
                PsDebug.warning((String)"degenerated edges");
                return -1;
            }
            pdBaryDir2.multScalar(1.0 / d4);
            d4 = PwBary.norm(pgElementSet, n, pdBaryDir, false);
            pdBaryDir2.multScalar(d4);
            PwBary.changeBarycentricOnEdge(pdBary, n2, n4);
            return n3;
        }
        PwBary.rotateInElement(pgElementSet, n, pdBaryDir, d, pdBaryDir2, false);
        return n;
    }

    public static boolean showsIntoElement(PdBaryDir pdBaryDir, int n) {
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"wrong direction");
            return false;
        }
        return pdBaryDir.m_data[n] <= 0.0 && pdBaryDir.m_data[(n + 1) % 3] >= 0.0 && pdBaryDir.m_data[(n + 2) % 3] >= 0.0;
    }

    public static double norm(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, boolean bl) {
        double d;
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing element set.");
            return 0.0;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"No valid x.");
            return 0.0;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)("Not a valid element index " + n + "."));
            return 0.0;
        }
        if (bl || m_prevGeom != pgElementSet || m_prevElement != n) {
            PiVector piVector = pgElementSet.getElement(n);
            PdVector pdVector = pgElementSet.getVertex(piVector.m_data[0]);
            PdVector pdVector2 = pgElementSet.getVertex(piVector.m_data[1]);
            PdVector pdVector3 = pgElementSet.getVertex(piVector.m_data[2]);
            m_AA = 0.0;
            m_BB = 0.0;
            m_CC = 0.0;
            m_AB = 0.0;
            m_AC = 0.0;
            m_BC = 0.0;
            int n2 = pdVector.getSize();
            int n3 = 0;
            while (n3 < n2) {
                m_AA += pdVector.m_data[n3] * pdVector.m_data[n3];
                m_BB += pdVector2.m_data[n3] * pdVector2.m_data[n3];
                m_CC += pdVector3.m_data[n3] * pdVector3.m_data[n3];
                m_AB += pdVector.m_data[n3] * pdVector2.m_data[n3];
                m_AC += pdVector.m_data[n3] * pdVector3.m_data[n3];
                m_BC += pdVector2.m_data[n3] * pdVector3.m_data[n3];
                ++n3;
            }
            m_prevGeom = pgElementSet;
            m_prevElement = n;
        }
        if ((d = pdBaryDir.m_data[0] * pdBaryDir.m_data[0] * m_AA + pdBaryDir.m_data[1] * pdBaryDir.m_data[1] * m_BB + pdBaryDir.m_data[2] * pdBaryDir.m_data[2] * m_CC + 2.0 * pdBaryDir.m_data[1] * pdBaryDir.m_data[0] * m_AB + 2.0 * pdBaryDir.m_data[2] * pdBaryDir.m_data[1] * m_BC + 2.0 * pdBaryDir.m_data[0] * pdBaryDir.m_data[2] * m_AC) < 0.0) {
            return 0.0;
        }
        return Math.sqrt(d);
    }

    public static double getVertexAngles(PgVertexStar pgVertexStar, PgElementSet pgElementSet, PdVector pdVector) {
        PiVector piVector = pgVertexStar.getElement();
        PiVector piVector2 = pgVertexStar.getVertexLocInd();
        int n = piVector.m_data.length;
        if (pdVector == null) {
            pdVector = new PdVector(n);
        } else if (pdVector.m_data == null || pdVector.m_data.length != n) {
            pdVector.setSize(n);
        }
        double d = 0.0;
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            int n3 = piVector2.m_data[n2];
            PwBary.m_tmpEdge1.m_data[n3] = -1.0;
            PwBary.m_tmpEdge1.m_data[(n3 + 1) % 3] = 1.0;
            PwBary.m_tmpEdge1.m_data[(n3 + 2) % 3] = 0.0;
            PwBary.m_tmpEdge2.m_data[n3] = -1.0;
            PwBary.m_tmpEdge2.m_data[(n3 + 1) % 3] = 0.0;
            PwBary.m_tmpEdge2.m_data[(n3 + 2) % 3] = 1.0;
            double d2 = PwBary.scalar(pgElementSet, piVector.m_data[n2], m_tmpEdge1, m_tmpEdge2, bl);
            if (bl) {
                bl = false;
            }
            d2 /= PwBary.norm(pgElementSet, piVector.m_data[n2], m_tmpEdge1, bl);
            if ((d2 /= PwBary.norm(pgElementSet, piVector.m_data[n2], m_tmpEdge2, bl)) > 1.0) {
                d2 = 1.0;
            } else if (d2 < -1.0) {
                d2 = -1.0;
            }
            pdVector.m_data[n2] = d2 = Math.acos(d2);
            d += d2;
            ++n2;
        }
        return d;
    }

    public static int createVectorAtVertexThatShowsIntoElement(PgElementSet pgElementSet, int n, PdBary pdBary, PdBaryDir pdBaryDir) {
        int n2 = PwBary.liesOnVertex(pdBary);
        if (n2 != -1 && !PwBary.showsIntoElement(pdBaryDir, n2)) {
            PdBaryDir pdBaryDir2 = new PdBaryDir(3);
            pdBaryDir2.copyArray(PdBaryDir.TRIANGLE_EDGE[(n2 + 2) % 3]);
            pdBaryDir2.multScalar(PwBary.norm(pgElementSet, n, pdBaryDir, true) / PwBary.norm(pgElementSet, n, pdBaryDir2, false));
            double d = PwBary.getOrientedAngle(pgElementSet, n, pdBaryDir2, pdBaryDir, true);
            n = PwBary.rotateAtVertex(pgElementSet, n, n2, pdBaryDir2, pdBaryDir, pdBary, d);
        }
        return n;
    }

    public static PdBaryDir[] computeNormals(PgPolygonOnElementSet pgPolygonOnElementSet, PdBaryDir[] pdBaryDirArray, PiVector piVector) {
        int n;
        int n2;
        double d;
        int n3 = pgPolygonOnElementSet.getNumVertices();
        if (pdBaryDirArray == null || pdBaryDirArray.length != n3) {
            pdBaryDirArray = new PdBaryDir[n3];
            int n4 = 0;
            while (n4 < n3) {
                pdBaryDirArray[n4] = new PdBaryDir(3);
                ++n4;
            }
        }
        if (piVector == null) {
            piVector = new PiVector(n3);
        } else if (piVector.getSize() != n3) {
            piVector.setSize(n3);
        }
        if (n3 < 2) {
            if (n3 == 1) {
                pdBaryDirArray[0].setZero();
            }
            return pdBaryDirArray;
        }
        PgElementSet pgElementSet = pgPolygonOnElementSet.getGeometry();
        PdBary pdBary = new PdBary(3);
        PdBary pdBary2 = new PdBary(3);
        PdBary pdBary3 = new PdBary(3);
        PdBary pdBary4 = new PdBary(3);
        PdBaryDir pdBaryDir = new PdBaryDir(3);
        PdBaryDir pdBaryDir2 = new PdBaryDir(3);
        int n5 = n3 - 1;
        int n6 = 0;
        do {
            n2 = PwBary.equalizeElementIndex(pgPolygonOnElementSet, 0, ++n6, pdBary, pdBary2);
            pdBaryDir.sub(pdBary2, pdBary);
            if (n2 == -1) {
                PsDebug.warning((String)"vertices must have common elements - wrong PgPolygonOnElementSet");
                return null;
            }
            d = PwBary.norm(pgElementSet, n2, pdBaryDir, n6 == 1);
        } while (n6 < n3 - 1 && d < 1.0E-10);
        if (d < 1.0E-10) {
            PsDebug.warning((String)"polygon is degenerated to point");
            return null;
        }
        int n7 = PwBary.liesOnVertex(pdBary);
        if (n7 != -1) {
            n = PwBary.rotateAtVertex(pgElementSet, n2, n7, pdBaryDir, pdBaryDirArray[0], pdBary, 1.5707963267948966);
            if (n < 0) {
                PwBary.rotateInElement(pgElementSet, n2, pdBaryDir, 1.5707963267948966, pdBaryDirArray[0], true);
                n = n2;
            }
            piVector.setEntry(0, n);
        } else {
            n7 = PwBary.getEdgeIndex(pdBary);
            if (n7 != -1) {
                n = PwBary.rotateAtEdge(pgElementSet, n2, pdBaryDir, n7, pdBaryDirArray[0], pdBary, 1.5707963267948966, true);
                if (n < 0) {
                    PwBary.rotateInElement(pgElementSet, n2, pdBaryDir, 1.5707963267948966, pdBaryDirArray[0], false);
                    n = n2;
                }
                piVector.setEntry(0, n);
            } else {
                PwBary.rotateInElement(pgElementSet, n2, pdBaryDir, 1.5707963267948966, pdBaryDirArray[0], true);
                piVector.setEntry(0, n2);
            }
        }
        int n8 = 1;
        while (n8 < n6) {
            piVector.setEntry(n8, piVector.getEntry(0));
            pdBaryDirArray[n8].copy(pdBaryDirArray[0]);
            ++n8;
        }
        n8 = n6;
        while (n8 < n3 - 1) {
            double d2;
            n6 = n8;
            do {
                n2 = PwBary.equalizeElementIndex(pgPolygonOnElementSet, n8, ++n6, pdBary, pdBary2);
                pdBaryDir.sub(pdBary2, pdBary);
                if (n2 == -1) {
                    PsDebug.warning((String)"vertices must have common elements - wrong PgPolygonOnElementSet");
                    return null;
                }
                d = PwBary.norm(pgElementSet, n2, pdBaryDir, n6 == 1);
            } while (n6 < n3 - 1 && d < 1.0E-10);
            if (d < 1.0E-10) {
                n5 = n8;
                break;
            }
            int n9 = PwBary.equalizeElementIndex(pgPolygonOnElementSet, n8, n8 - 1, pdBary3, pdBary4);
            pdBaryDir2.sub(pdBary4, pdBary3);
            if (n9 == -1) {
                PsDebug.warning((String)"vertices must have common elements - wrong PgPolygonOnElementSet");
                return null;
            }
            n7 = PwBary.liesOnVertex(pdBary);
            if (n7 != -1) {
                d2 = PwBary.getOrientedAngleAtVertex(pgElementSet, n2, pdBaryDir, n7, n9, pdBaryDir2, PwBary.liesOnVertex(pdBary3), false);
                n = PwBary.rotateAtVertex(pgElementSet, n2, n7, pdBaryDir, pdBaryDirArray[n8], pdBary, d2 / 2.0);
                if (n < 0) {
                    PwBary.rotateInElement(pgElementSet, n2, pdBaryDir, d2 / 2.0, pdBaryDirArray[n8], false);
                    n = n2;
                }
                piVector.setEntry(n8, n);
            } else {
                n7 = PwBary.getEdgeIndex(pdBary);
                if (n7 != -1) {
                    d2 = PwBary.getOrientedAngleAtEdge(pgElementSet, n2, pdBaryDir, n7, n9, pdBaryDir2, PwBary.getEdgeIndex(pdBary3), false);
                    n = PwBary.rotateAtEdge(pgElementSet, n2, pdBaryDir, n7, pdBaryDirArray[n8], pdBary, d2 / 2.0, false);
                    if (n < 0) {
                        PwBary.rotateInElement(pgElementSet, n2, pdBaryDir, d2 / 2.0, pdBaryDirArray[n8], false);
                        n = n2;
                    }
                    piVector.setEntry(n8, n);
                } else {
                    d2 = PwBary.getOrientedAngle(pgElementSet, n2, pdBaryDir, pdBaryDir2, false);
                    if (d2 < 0.0) {
                        d2 += Math.PI * 2;
                    }
                    PwBary.rotateInElement(pgElementSet, n2, pdBaryDir, d2 / 2.0, pdBaryDirArray[n8], false);
                    piVector.setEntry(n8, n2);
                }
            }
            int n10 = n8 + 1;
            while (n10 < n6) {
                piVector.setEntry(n10, piVector.getEntry(n8));
                pdBaryDirArray[n10].copy(pdBaryDirArray[n8]);
                ++n10;
            }
            n8 = n6 - 1;
            ++n8;
        }
        n2 = PwBary.equalizeElementIndex(pgPolygonOnElementSet, n5, n5 - 1, pdBary, pdBary2);
        pdBaryDir.sub(pdBary2, pdBary);
        if (n2 == -1) {
            PsDebug.warning((String)"vertices must have common elements - wrong PgPolygonOnElementSet");
            return null;
        }
        n7 = PwBary.liesOnVertex(pdBary);
        if (n7 != -1) {
            n = PwBary.rotateAtVertex(pgElementSet, n2, n7, pdBaryDir, pdBaryDirArray[n5], pdBary, -1.5707963267948966);
            if (n < 0) {
                PwBary.rotateInElement(pgElementSet, n2, pdBaryDir, -1.5707963267948966, pdBaryDirArray[n5], false);
                n = n2;
            }
            piVector.setEntry(n5, n);
        } else {
            n7 = PwBary.getEdgeIndex(pdBary);
            if (n7 != -1) {
                n = PwBary.rotateAtEdge(pgElementSet, n2, pdBaryDir, n7, pdBaryDirArray[n5], pdBary, -1.5707963267948966, false);
                if (n < 0) {
                    PwBary.rotateInElement(pgElementSet, n2, pdBaryDir, -1.5707963267948966, pdBaryDirArray[n5], false);
                    n = n2;
                }
                piVector.setEntry(n5, n);
            } else {
                PwBary.rotateInElement(pgElementSet, n2, pdBaryDir, -1.5707963267948966, pdBaryDirArray[n5], false);
                piVector.setEntry(n5, n2);
            }
        }
        n8 = n5 + 1;
        while (n8 < n3) {
            piVector.setEntry(n8, piVector.getEntry(n5));
            pdBaryDirArray[n8].copy(pdBaryDirArray[n5]);
            ++n8;
        }
        n8 = 0;
        while (n8 < n3) {
            d = PwBary.norm(pgElementSet, piVector.getEntry(n8), pdBaryDirArray[n8], false);
            if (d < 1.0E-10) {
                PsDebug.warning((String)("degenerated normal at position " + n8));
            } else {
                pdBaryDirArray[n8].multScalar(1.0 / d);
            }
            ++n8;
        }
        return pdBaryDirArray;
    }

    public static boolean transformBary(PgElementSet pgElementSet, int n, PdBary pdBary, int n2, PdBary pdBary2) {
        if (n2 < 0) {
            return false;
        }
        int n3 = PwBary.liesOnVertex(pdBary);
        if (n3 != -1) {
            int n4 = pgElementSet.getElement(n).getEntry(n3);
            PiVector piVector = pgElementSet.getElement(n2);
            if (piVector == null) {
                return false;
            }
            n3 = -1;
            int n5 = piVector.getSize() - 1;
            while (n5 >= 0) {
                if (piVector.getEntry(n5) == n4) {
                    n3 = n5;
                    break;
                }
                --n5;
            }
            if (n3 == -1) {
                return false;
            }
            pdBary2.copy(PdBary.TRIANGLE_VERTEX[n3]);
        } else {
            n3 = PwBary.getEdgeIndex(pdBary);
            if (n3 != -1) {
                int n6 = pgElementSet.getNeighbour(n).getEntry(n3);
                if (n2 != n6) {
                    return false;
                }
                pdBary2.copy(pdBary);
                PwBary.changeBarycentricOnEdge(pdBary2, n3, pgElementSet.getOppVertexLocInd(n, n3));
            } else {
                return false;
            }
        }
        return true;
    }

    static {
        m_tmpEdge1 = new PdBaryDir(3);
        m_tmpEdge2 = new PdBaryDir(3);
        m_tmpEdge3 = new PdBaryDir(3);
        m_tmpEdge4 = new PdBaryDir(3);
        m_projVert = null;
        m_projN = new PdVector();
        m_rotVertAngles = new PdVector();
        m_rotVertStar = new PgVertexStar();
        m_rotVertEdge = new PdBaryDir(3);
        m_rotVertHalf = new PdBaryDir(3);
        m_rotVertNormal = new PdBaryDir(3);
        m_angleEdge = new PdBaryDir(3);
        m_angleOriented = new double[2];
        m_angleVectors = new PdBaryDir[2];
    }

    public static int getEdgeIndex(PdBary pdBary) {
        int n = -1;
        int n2 = pdBary.getSize();
        int n3 = 0;
        while (n3 < n2) {
            if (pdBary.m_data[n3] < 1.0E-10 && pdBary.m_data[n3] > -1.0E-10) {
                n = n3;
                break;
            }
            ++n3;
        }
        return n;
    }

    public static int equalizeElementIndex(PgPolygonOnElementSet pgPolygonOnElementSet, int n, int n2, PdBary pdBary, PdBary pdBary2) {
        PgElementSet pgElementSet = pgPolygonOnElementSet.getGeometry();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        int[] nArray = new int[]{n, n2};
        PdBary[] pdBaryArray = new PdBary[]{pdBary, pdBary2};
        PiVector[] piVectorArray3 = new PiVector[2];
        PgVertexStar[] pgVertexStarArray = new PgVertexStar[2];
        int[] nArray2 = new int[]{-1, -1};
        int n3 = 0;
        do {
            piVectorArray3[n3] = new PiVector();
            int n4 = pgPolygonOnElementSet.getElemInd(nArray[n3]);
            PdBary pdBary3 = pgPolygonOnElementSet.getBary(nArray[n3]);
            int n5 = PwBary.liesOnVertex(pdBary3);
            if (n5 >= 0) {
                pgVertexStarArray[n3] = new PgVertexStar();
                pgVertexStarArray[n3].makeVertexStar(pgElementSet, piVectorArray[n4].m_data[n5], n4);
                piVectorArray3[n3].setSize(pgVertexStarArray[n3].getSize());
                piVectorArray3[n3].copyArray(pgVertexStarArray[n3].getElement());
                continue;
            }
            nArray2[n3] = PwBary.getEdgeIndex(pdBary3);
            if (nArray2[n3] != -1) {
                piVectorArray3[n3].setSize(2);
                piVectorArray3[n3].m_data[0] = n4;
                piVectorArray3[n3].m_data[1] = piVectorArray2[n4].m_data[nArray2[n3]];
                continue;
            }
            piVectorArray3[n3].setSize(1);
            piVectorArray3[n3].m_data[0] = n4;
        } while (++n3 < 2);
        int[] nArray3 = new int[]{-1, -1};
        int n6 = -1;
        int n7 = piVectorArray3[0].getSize();
        int n8 = piVectorArray3[1].getSize();
        int n9 = 0;
        while (n9 < n7) {
            int n10 = 0;
            while (n10 < n8) {
                if (piVectorArray3[0].m_data[n9] == piVectorArray3[1].m_data[n10] && piVectorArray3[0].m_data[n9] != -1) {
                    nArray3[0] = n9;
                    nArray3[1] = n10;
                    n6 = piVectorArray3[0].m_data[n9];
                    break;
                }
                ++n10;
            }
            ++n9;
        }
        if (n6 < 0) {
            return -1;
        }
        n9 = 0;
        do {
            if (nArray3[n9] == 0) {
                pdBaryArray[n9].copy(pgPolygonOnElementSet.getBary(nArray[n9]));
                continue;
            }
            if (pgVertexStarArray[n9] != null) {
                pdBaryArray[n9].copy(PdBary.TRIANGLE_VERTEX[pgVertexStarArray[n9].getVertexLocInd().getEntry(nArray3[n9])]);
                continue;
            }
            pdBaryArray[n9].copy(pgPolygonOnElementSet.getBary(nArray[n9]));
            PwBary.changeBarycentricOnEdge(pdBaryArray[n9], nArray2[n9], pgElementSet.getOppVertexLocInd(pgPolygonOnElementSet.getElemInd(nArray[n9]), nArray2[n9]));
        } while (++n9 < 2);
        return n6;
    }

    public static double getOrientedAngle(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, PdBaryDir pdBaryDir2, boolean bl) {
        double d = Double.NEGATIVE_INFINITY;
        PwBary.m_angleEdge.m_data[0] = 0.0;
        PwBary.m_angleEdge.m_data[1] = -1.0;
        PwBary.m_angleEdge.m_data[2] = 1.0;
        double d2 = PwBary.norm(pgElementSet, n, m_angleEdge, bl);
        if (d2 < 1.0E-10) {
            PsDebug.warning((String)"Edges degenerated.");
            return d;
        }
        m_angleEdge.multScalar(1.0 / d2);
        PwBary.m_angleVectors[0] = pdBaryDir;
        PwBary.m_angleVectors[1] = pdBaryDir2;
        int n2 = 0;
        do {
            PwBary.m_angleOriented[n2] = PwBary.scalar(pgElementSet, n, m_angleVectors[n2], m_angleEdge, false);
            double d3 = PwBary.norm(pgElementSet, n, m_angleVectors[n2], false);
            if (d3 < 1.0E-10) {
                PsDebug.warning((String)("Vector degenerated no." + n2 + "."));
                if (m_angleVectors[n2] != null) {
                    PsDebug.warning((String)m_angleVectors[n2].toShortString());
                }
                return d;
            }
            int n3 = n2;
            m_angleOriented[n3] = m_angleOriented[n3] / d3;
            if (m_angleOriented[n2] > 1.0) {
                PwBary.m_angleOriented[n2] = 1.0;
            } else if (m_angleOriented[n2] < -1.0) {
                PwBary.m_angleOriented[n2] = -1.0;
            }
            PwBary.m_angleOriented[n2] = Math.acos(m_angleOriented[n2]);
            if (!(PwBary.m_angleVectors[n2].m_data[0] < 0.0)) continue;
            int n4 = n2;
            m_angleOriented[n4] = m_angleOriented[n4] * -1.0;
        } while (++n2 < 2);
        double d4 = m_angleOriented[1] - m_angleOriented[0];
        while (d4 > Math.PI) {
            d4 -= Math.PI * 2;
        }
        while (d4 < -Math.PI) {
            d4 += Math.PI * 2;
        }
        return d4;
    }

    public static double scalar(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, PdBaryDir pdBaryDir2, boolean bl) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing element set.");
            return 0.0;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"No valid x.");
            return 0.0;
        }
        if (pdBaryDir2 == null || pdBaryDir2.getSize() != 3) {
            PsDebug.warning((String)"No valid y.");
            return 0.0;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)("Not a valid element index " + n + "."));
            return 0.0;
        }
        if (bl || m_prevGeom != pgElementSet || m_prevElement != n) {
            PiVector piVector = pgElementSet.getElement(n);
            PdVector pdVector = pgElementSet.getVertex(piVector.m_data[0]);
            PdVector pdVector2 = pgElementSet.getVertex(piVector.m_data[1]);
            PdVector pdVector3 = pgElementSet.getVertex(piVector.m_data[2]);
            m_AA = 0.0;
            m_BB = 0.0;
            m_CC = 0.0;
            m_AB = 0.0;
            m_AC = 0.0;
            m_BC = 0.0;
            int n2 = pdVector.getSize();
            int n3 = 0;
            while (n3 < n2) {
                m_AA += pdVector.m_data[n3] * pdVector.m_data[n3];
                m_BB += pdVector2.m_data[n3] * pdVector2.m_data[n3];
                m_CC += pdVector3.m_data[n3] * pdVector3.m_data[n3];
                m_AB += pdVector.m_data[n3] * pdVector2.m_data[n3];
                m_AC += pdVector.m_data[n3] * pdVector3.m_data[n3];
                m_BC += pdVector2.m_data[n3] * pdVector3.m_data[n3];
                ++n3;
            }
            m_prevGeom = pgElementSet;
            m_prevElement = n;
        }
        double d = pdBaryDir.m_data[0];
        double d2 = pdBaryDir.m_data[1];
        double d3 = pdBaryDir.m_data[2];
        double d4 = pdBaryDir2.m_data[0];
        double d5 = pdBaryDir2.m_data[1];
        double d6 = pdBaryDir2.m_data[2];
        double d7 = d * d4 * m_AA + d2 * d5 * m_BB + d3 * d6 * m_CC + (d * d5 + d2 * d4) * m_AB + (d2 * d6 + d3 * d5) * m_BC + (d3 * d4 + d * d6) * m_AC;
        return d7;
    }

    public static double getOrientedAngleAtVertex(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, int n2, int n3, PdBaryDir pdBaryDir2, int n4, boolean bl) {
        PgVertexStar pgVertexStar = new PgVertexStar();
        int n5 = pgElementSet.getElement(n).getEntry(n2);
        pgVertexStar.makeVertexStar(pgElementSet, n5, n);
        int n6 = pgVertexStar.getSize();
        PiVector piVector = pgVertexStar.getElement();
        int n7 = 0;
        boolean bl2 = false;
        if (!pgVertexStar.isClosed()) {
            int n8 = -1;
            int n9 = -1;
            int n10 = 0;
            while (n10 < n6) {
                n7 = piVector.getEntry(n10);
                if (n7 == n) {
                    n8 = n10;
                } else if (n7 == n3) {
                    n9 = n10;
                }
                ++n10;
            }
            if (n8 == -1 || n9 == -1) {
                PsDebug.warning((String)"wrong elem indices");
                return 0.0;
            }
            if (n9 < n8) {
                bl2 = true;
                PdBaryDir pdBaryDir3 = pdBaryDir;
                pdBaryDir = pdBaryDir2;
                pdBaryDir2 = pdBaryDir3;
                n7 = n;
                n = n3;
                n3 = n7;
                n7 = n2;
                n2 = n4;
                n4 = n7;
                n7 = n9;
            } else {
                n7 = n8;
            }
        }
        PdVector pdVector = new PdVector();
        double d = PwBary.getVertexAngles(pgVertexStar, pgElementSet, pdVector);
        double d2 = 0.0;
        PdBaryDir pdBaryDir4 = new PdBaryDir(3);
        pdBaryDir4.copy(PdBaryDir.TRIANGLE_EDGE[(n2 + 1) % 3]);
        pdBaryDir4.multScalar(-1.0);
        double d3 = PwBary.getOrientedAngle(pgElementSet, n, pdBaryDir, pdBaryDir4, bl);
        if (d3 < 0.0) {
            d3 += Math.PI * 2;
        }
        d2 += d3;
        ++n7;
        while (n7 < n6 && piVector.getEntry(n7) != n3) {
            d2 += pdVector.getEntry(n7);
            ++n7;
        }
        d3 = PwBary.getOrientedAngle(pgElementSet, n3, PdBaryDir.TRIANGLE_EDGE[(n4 + 2) % 3], pdBaryDir2, false);
        if (d3 < 0.0) {
            d3 += Math.PI * 2;
        }
        d2 += d3;
        d2 = bl2 ? -d2 : (d2 *= Math.PI * 2 / d);
        return d2;
    }

    public static PdBaryDir[] getProjRepresentation(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, int n2, PiVector piVector, PiVector piVector2) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return null;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"Missing vector.");
            return null;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)"Invalid element.");
            return null;
        }
        if (n2 < 0 || n2 >= 3) {
            PsDebug.warning((String)"Invalid vertex.");
            return null;
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        pgVertexStar.makeVertexStar(pgElementSet, pgElementSet.getElement((int)n).m_data[n2], n);
        int n3 = pgVertexStar.getFirstElemInd();
        piVector.setSize(pgVertexStar.getElement().getSize());
        piVector.copy(pgVertexStar.getElement());
        piVector2.setSize(pgVertexStar.getVertexLocInd().getSize());
        piVector2.copy(pgVertexStar.getVertexLocInd());
        PdBaryDir[] pdBaryDirArray = new PdBaryDir[pgVertexStar.getSize()];
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        int n4 = pgElementSet.getDimOfVertices();
        PdVector pdVector = new PdVector(n4);
        int n5 = 0;
        while (n5 < n4) {
            pdVector.m_data[n5] = 0.0;
            ++n5;
        }
        n5 = 0;
        while (n5 < n4) {
            int n6 = 0;
            do {
                int n7 = n5;
                pdVector.m_data[n7] = pdVector.m_data[n7] + pdBaryDir.m_data[n6] * pdVectorArray[piVectorArray[n].m_data[n6]].m_data[n5];
            } while (++n6 < 3);
            ++n5;
        }
        n5 = 0;
        while (n5 < pdBaryDirArray.length) {
            if (n5 == n3) {
                pdBaryDirArray[n5] = new PdBaryDir(3);
                pdBaryDirArray[n5].copy(pdBaryDir);
            } else {
                pdBaryDirArray[n5] = new PdBaryDir(3);
                PwBary.projectOntoElement(pgElementSet, piVector.m_data[n5], pdVector, pdBaryDirArray[n5]);
            }
            ++n5;
        }
        return pdBaryDirArray;
    }

    public static double getOrientedAngleAtEdge(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, int n2, int n3, PdBaryDir pdBaryDir2, int n4, boolean bl) {
        double d = 0.0;
        PdBaryDir pdBaryDir3 = new PdBaryDir(3);
        pdBaryDir3.copy(PdBaryDir.TRIANGLE_EDGE[n2]);
        pdBaryDir3.multScalar(-1.0);
        double d2 = PwBary.getOrientedAngle(pgElementSet, n, pdBaryDir, pdBaryDir3, bl);
        if (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        d += d2;
        d2 = PwBary.getOrientedAngle(pgElementSet, n3, PdBaryDir.TRIANGLE_EDGE[n4], pdBaryDir2, false);
        if (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        return d += d2;
    }

    public static void changeBarycentricOnEdge(PdBary pdBary, int n, int n2) {
        double d = pdBary.m_data[(n + 1) % 3];
        double d2 = pdBary.m_data[(n + 2) % 3];
        pdBary.m_data[n2] = 0.0;
        pdBary.m_data[(n2 + 1) % 3] = d2;
        pdBary.m_data[(n2 + 2) % 3] = d;
    }

    public static void blendBase(PdBary pdBary, double d, PdBaryDir pdBaryDir, PdBary pdBary2) {
        int n = pdBary.getSize();
        int n2 = 0;
        while (n2 < n) {
            pdBary2.m_data[n2] = pdBary.m_data[n2] + d * pdBaryDir.m_data[n2];
            ++n2;
        }
    }

    public static double getTransRepresentationValues(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, int n2, PiVector piVector, PiVector piVector2, PdVector pdVector) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return 0.0;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"Missing vector.");
            return 0.0;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)"Invalid element.");
            return 0.0;
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        pgVertexStar.makeVertexStar(pgElementSet, pgElementSet.getElement((int)n).m_data[n2], n);
        int n3 = pgVertexStar.getFirstElemInd();
        int n4 = pgVertexStar.getElement().getSize();
        piVector2.setSize(n4);
        piVector.setSize(n4);
        int n5 = 0;
        while (n5 < n4) {
            piVector.setEntry(n5, pgVertexStar.getElement().getEntry((n5 + n3) % n4));
            piVector2.setEntry(n5, pgVertexStar.getVertexLocInd().getEntry((n5 + n3) % n4));
            ++n5;
        }
        PdVector pdVector2 = new PdVector();
        double d = PwBary.getVertexAngles(pgVertexStar, pgElementSet, pdVector2);
        double d2 = Math.PI * 2 - d;
        if (!pgVertexStar.isClosed()) {
            d = Math.PI * 2;
        }
        PdBaryDir pdBaryDir2 = new PdBaryDir(3);
        pdBaryDir2.m_data[n2] = -1.0;
        pdBaryDir2.m_data[(n2 + 1) % 3] = 0.0;
        pdBaryDir2.m_data[(n2 + 2) % 3] = 1.0;
        double d3 = 0.0;
        double d4 = PwBary.norm(pgElementSet, n, pdBaryDir, true);
        if (d4 >= 1.0E-10) {
            d3 = PwBary.getOrientedAngle(pgElementSet, n, pdBaryDir, pdBaryDir2, false);
        }
        pdVector.setSize(n4);
        pdVector.setEntry(0, d - pdVector2.m_data[n3] + d3);
        int n6 = n3 + 1;
        while (n6 < n3 + pgVertexStar.getSize()) {
            int n7 = n6 % pgVertexStar.getSize();
            if (!pgVertexStar.isClosed() && n6 == pgVertexStar.getSize()) {
                d3 += d2;
            }
            pdVector.setEntry(n6 - n3, d3);
            d3 += pdVector2.m_data[n7];
            ++n6;
        }
        return d;
    }

    public static void projectOntoElement(PgElementSet pgElementSet, int n, PdVector pdVector, PdBaryDir pdBaryDir) {
        double d;
        int n2;
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return;
        }
        if (pdVector == null) {
            PsDebug.warning((String)"Missing vector.");
            return;
        }
        if (pdBaryDir == null) {
            PsDebug.warning((String)"Missing output variable.");
            return;
        }
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        int n3 = pgElementSet.getDimOfVertices();
        if (m_projVert == null) {
            m_projVert = new PdVector[3];
            n2 = 0;
            do {
                PwBary.m_projVert[n2] = new PdVector(n3);
            } while (++n2 < 3);
        }
        n2 = 0;
        do {
            m_projVert[n2].setSize(pdVectorArray[piVectorArray[n].m_data[n2]].getSize());
            m_projVert[n2].copy(pdVectorArray[piVectorArray[n].m_data[n2]]);
        } while (++n2 < 3);
        m_projVert[1].sub(m_projVert[0]);
        m_projVert[2].sub(m_projVert[0]);
        m_projN.setSize(n3);
        n2 = 0;
        while (n2 < n3) {
            PwBary.m_projN.m_data[n2] = 0.0;
            ++n2;
        }
        if (n3 == 3) {
            m_projN.cross(m_projVert[1], m_projVert[2]);
            double d2 = m_projN.length();
            if (d2 < 1.0E-10) {
                PsDebug.warning((String)errormsg);
                return;
            }
            m_projN.multScalar(1.0 / d2);
            d = PdVector.dot((PdVector)m_projN, (PdVector)pdVector);
            m_projN.multScalar(-d);
            m_projN.add(pdVector);
        } else if (n3 < 3) {
            m_projN.copy(pdVector);
        }
        double d3 = m_projVert[1].sqrLength();
        if (d3 < 1.0E-10) {
            PsDebug.warning((String)errormsg);
            return;
        }
        d = PdVector.dot((PdVector)m_projN, (PdVector)m_projVert[1]) / d3;
        double d4 = PdVector.dot((PdVector)m_projVert[2], (PdVector)m_projVert[1]) / d3;
        m_projVert[1].multScalar(-d4);
        m_projVert[2].add(m_projVert[1]);
        d3 = m_projVert[2].sqrLength();
        if (d3 < 1.0E-10) {
            PsDebug.warning((String)errormsg);
            return;
        }
        double d5 = PdVector.dot((PdVector)m_projN, (PdVector)m_projVert[2]) / d3;
        pdBaryDir.setSize(3);
        pdBaryDir.m_data[0] = -d - d5 + d5 * d4;
        pdBaryDir.m_data[1] = d - d5 * d4;
        pdBaryDir.m_data[2] = d5;
    }

    public static void rotateInElement(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, double d, PdBaryDir pdBaryDir2, boolean bl) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)("Wrong element index=" + n));
            return;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"Wrong direction");
            return;
        }
        if (pdBaryDir2 == null) {
            PsDebug.warning((String)"Missing output parameter");
            return;
        }
        int n2 = -1;
        double d2 = 1.0;
        int n3 = 0;
        do {
            if (!(pdBaryDir.m_data[n3] < d2)) continue;
            n2 = n3;
            d2 = pdBaryDir.m_data[n3];
        } while (++n3 < 3);
        double d3 = PwBary.norm(pgElementSet, n, pdBaryDir, bl);
        if (d3 < 1.0E-10) {
            PsDebug.warning((String)"Direction degenerated.");
            return;
        }
        m_tmpEdge3.copyArray(pdBaryDir);
        pdBaryDir2.setSize(3);
        pdBaryDir2.copyArray(PdBaryDir.TRIANGLE_EDGE[n2]);
        m_tmpEdge3.multScalar(1.0 / d3);
        m_tmpEdge4.copyArray(m_tmpEdge3);
        m_tmpEdge4.multScalar(-PwBary.scalar(pgElementSet, n, m_tmpEdge3, pdBaryDir2, false));
        int n4 = 0;
        do {
            int n5 = n4;
            pdBaryDir2.m_data[n5] = pdBaryDir2.m_data[n5] + PwBary.m_tmpEdge4.m_data[n4];
        } while (++n4 < 3);
        double d4 = PwBary.norm(pgElementSet, n, pdBaryDir2, false);
        if (d4 < 1.0E-10) {
            PsDebug.warning((String)"Edges degenerated.");
            return;
        }
        pdBaryDir2.multScalar(1.0 / d4);
        m_tmpEdge3.multScalar(Math.cos(d));
        pdBaryDir2.multScalar(Math.sin(d));
        int n6 = 0;
        do {
            int n7 = n6;
            pdBaryDir2.m_data[n7] = pdBaryDir2.m_data[n7] + PwBary.m_tmpEdge3.m_data[n6];
        } while (++n6 < 3);
        pdBaryDir2.multScalar(d3);
    }

    public static double computeLambda(PdBary pdBary, PdBaryDir pdBaryDir) {
        int n = pdBary.getSize();
        double d = Double.POSITIVE_INFINITY;
        int n2 = 0;
        while (n2 < n) {
            double d2;
            if (pdBaryDir.m_data[n2] < 0.0 && (d2 = -pdBary.m_data[n2] / pdBaryDir.m_data[n2]) >= -1.0E-10 && d2 < d) {
                d = d2;
            }
            ++n2;
        }
        return d;
    }

    /*
     * Unable to fully structure code
     */
    public static void translatePolygonOnElementSet(PgPolygonOnElementSet var0, PdBaryDir[] var1_1, PiVector var2_2, PdVector var3_3) {
        var4_4 = var0.getGeometry();
        var5_5 = new PgPolygonOnElementSet(var4_4);
        var6_6 = var0.getNumVertices();
        var7_7 = var0.getElemInd();
        var8_8 = var0.getBary();
        var9_9 = new PdBary(3);
        var12_10 = 0;
        while (var12_10 < var6_6) {
            block5: {
                block4: {
                    block3: {
                        var10_11 = var2_2.getEntry(var12_10);
                        if (var10_11 != var7_7.getEntry(var12_10)) break block3;
                        var9_9.copy(var8_8[var12_10]);
                        break block4;
                    }
                    if (var10_11 >= 0) {
                        if (!PwBary.transformBary(var4_4, var7_7.getEntry(var12_10), var8_8[var12_10], var10_11, var9_9)) {
                            PsDebug.warning((String)"incompatible vector field and polygon");
                            return;
                        } else {
                            ** GOTO lbl19
                        }
                    }
                    break block5;
                }
                var5_5.exp(var10_11, var9_9, var1_1[var12_10], var3_3.getEntry(var12_10));
                var11_12 = var5_5.getNumVertices();
                var8_8[var12_10].copy(var5_5.getBary(var11_12 - 1));
                var7_7.setEntry(var12_10, var5_5.getElemInd(var11_12 - 1));
            }
            ++var12_10;
        }
    }

    public static int rotateAtVertex(PgElementSet pgElementSet, int n, int n2, PdBaryDir pdBaryDir, PdBaryDir pdBaryDir2, PdBary pdBary, double d) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return 0;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)("Wrong element index=" + n));
            return 0;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"Wrong direction");
            return 0;
        }
        if (pdBaryDir2 == null) {
            PsDebug.warning((String)"Missing output parameter");
            return 0;
        }
        m_rotVertStar.makeVertexStar(pgElementSet, pgElementSet.getElement((int)n).m_data[n2], n);
        double d2 = PwBary.getVertexAngles(m_rotVertStar, pgElementSet, m_rotVertAngles);
        double d3 = !m_rotVertStar.isClosed() ? Math.PI * 2 : d2;
        double d4 = d;
        while (d4 < 0.0) {
            d4 += Math.PI * 2;
        }
        double d5 = d3 / 2.0 / Math.PI * d4;
        int n3 = m_rotVertStar.getFirstElemInd();
        int n4 = PwBary.m_rotVertStar.getVertexLocInd().m_data[n3];
        int n5 = PwBary.m_rotVertStar.getElement().m_data[n3];
        PwBary.m_rotVertEdge.m_data[n4] = -1.0;
        PwBary.m_rotVertEdge.m_data[(n4 + 1) % 3] = 0.0;
        PwBary.m_rotVertEdge.m_data[(n4 + 2) % 3] = 1.0;
        double d6 = PwBary.norm(pgElementSet, n5, pdBaryDir, false);
        double d7 = PwBary.scalar(pgElementSet, n5, m_rotVertEdge, pdBaryDir, false);
        double d8 = PwBary.norm(pgElementSet, n5, m_rotVertEdge, false);
        if (Math.abs(d8) < 1.0E-10) {
            PsDebug.warning((String)"Edges degenerated in geometry.");
            return -1;
        }
        if (Math.abs(d6) < 1.0E-10) {
            PsDebug.warning((String)"Dir degenerated.");
            return -1;
        }
        d7 /= d8;
        if ((d7 /= d6) < -1.0) {
            d7 = -1.0;
        } else if (d7 > 1.0) {
            d7 = 1.0;
        }
        d7 = Math.acos(d7);
        double d9 = 0.0;
        while (d7 + d9 < d5 - 1.0E-6) {
            if (!m_rotVertStar.isClosed() && ++n3 % PwBary.m_rotVertAngles.m_data.length == 0 && n3 > 0) {
                d7 = Math.PI * 2 - d2;
                if (d7 + (d9 += d7) >= d5 + 1.0E-6) {
                    return -1;
                }
                d7 = Math.min(d7, d5 - d9);
            }
            d9 += d7;
            d7 = PwBary.m_rotVertAngles.m_data[n3 % PwBary.m_rotVertAngles.m_data.length];
        }
        if (d7 + d9 < d5) {
            d5 = d7 + d9;
        }
        int n6 = PwBary.m_rotVertStar.getVertexLocInd().m_data[n3 % m_rotVertStar.getSize()];
        n5 = PwBary.m_rotVertStar.getElement().m_data[n3 % PwBary.m_rotVertAngles.m_data.length];
        if (n3 == m_rotVertStar.getFirstElemInd()) {
            pdBaryDir2.setSize(3);
            PwBary.rotateInElement(pgElementSet, n5, pdBaryDir, d5 - d9, pdBaryDir2, false);
        } else {
            PwBary.m_rotVertEdge.m_data[n6] = -1.0;
            PwBary.m_rotVertEdge.m_data[(n6 + 1) % 3] = 1.0;
            PwBary.m_rotVertEdge.m_data[(n6 + 2) % 3] = 0.0;
            d8 = PwBary.norm(pgElementSet, n5, m_rotVertEdge, false);
            if (Math.abs(d8) < 1.0E-10) {
                PsDebug.warning((String)"Edges degenerated in geometry.");
                return -1;
            }
            m_rotVertEdge.multScalar(1.0 / d8);
            PwBary.m_rotVertHalf.m_data[n6] = -1.0;
            PwBary.m_rotVertHalf.m_data[(n6 + 1) % 3] = 0.0;
            PwBary.m_rotVertHalf.m_data[(n6 + 2) % 3] = 1.0;
            m_rotVertNormal.copy(m_rotVertEdge);
            m_rotVertNormal.multScalar(-1.0 * PwBary.scalar(pgElementSet, n5, m_rotVertHalf, m_rotVertEdge, false));
            int n7 = 0;
            do {
                int n8 = n7;
                PwBary.m_rotVertNormal.m_data[n8] = PwBary.m_rotVertNormal.m_data[n8] + PwBary.m_rotVertHalf.m_data[n7];
            } while (++n7 < 3);
            d8 = PwBary.norm(pgElementSet, n5, m_rotVertNormal, false);
            if (Math.abs(d8) < 1.0E-10) {
                PsDebug.warning((String)"Edges degenerated in geometry.");
                return -1;
            }
            m_rotVertNormal.multScalar(1.0 / d8);
            pdBaryDir2.copy(m_rotVertEdge);
            pdBaryDir2.multScalar(Math.cos(d5 - d9));
            m_rotVertHalf.copy(m_rotVertNormal);
            m_rotVertHalf.multScalar(Math.sin(d5 - d9));
            n7 = 0;
            do {
                int n9 = n7;
                pdBaryDir2.m_data[n9] = pdBaryDir2.m_data[n9] + PwBary.m_rotVertHalf.m_data[n7];
            } while (++n7 < 3);
            pdBaryDir2.multScalar(d6);
        }
        pdBary.m_data[n6] = 1.0;
        pdBary.m_data[(n6 + 1) % 3] = 0.0;
        pdBary.m_data[(n6 + 2) % 3] = 0.0;
        return n5;
    }

    public static int liesOnVertex(PdBary pdBary) {
        int n;
        if (pdBary == null || pdBary.getSize() != 3) {
            PsDebug.warning((String)"wrong argument 'pos'");
            return -1;
        }
        int n2 = 0;
        int n3 = -1;
        int n4 = n = pdBary.getSize() - 1;
        while (n4 >= 0) {
            if (Math.abs(pdBary.m_data[n4]) < 1.0E-10) {
                ++n2;
            } else {
                n3 = n4;
            }
            --n4;
        }
        if (n2 == 2) {
            return n3;
        }
        return -1;
    }

    public static PdBaryDir[] getGeodRepresentation(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, int n2, PiVector piVector, PiVector piVector2) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return null;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"Missing vector.");
            return null;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)"Invalid element.");
            return null;
        }
        if (n2 < 0 || n2 >= 3) {
            PsDebug.warning((String)"Invalid vertex.");
            return null;
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        pgVertexStar.makeVertexStar(pgElementSet, pgElementSet.getElement((int)n).m_data[n2], n);
        piVector.setSize(pgVertexStar.getElement().getSize());
        piVector.copy(pgVertexStar.getElement());
        PdBaryDir[] pdBaryDirArray = new PdBaryDir[pgVertexStar.getSize()];
        double d = PwBary.norm(pgElementSet, n, pdBaryDir, true);
        if (d < 1.0E-10) {
            int n3 = 0;
            while (n3 < pdBaryDirArray.length) {
                pdBaryDirArray[n3] = new PdBaryDir(0.0, 0.0, 0.0);
                ++n3;
            }
            return pdBaryDirArray;
        }
        PdVector pdVector = new PdVector();
        double d2 = PwBary.getVertexAngles(pgVertexStar, pgElementSet, pdVector);
        double d3 = Math.PI * 2 - d2;
        if (!pgVertexStar.isClosed()) {
            d2 = Math.PI * 2;
        }
        int n4 = pgVertexStar.getFirstElemInd();
        PdBaryDir pdBaryDir2 = new PdBaryDir(3);
        pdBaryDir2.m_data[n2] = 1.0;
        pdBaryDir2.m_data[(n2 + 1) % 3] = 0.0;
        pdBaryDir2.m_data[(n2 + 2) % 3] = -1.0;
        double d4 = PwBary.scalar(pgElementSet, n, pdBaryDir, pdBaryDir2, false);
        d4 /= d;
        double d5 = PwBary.norm(pgElementSet, n, pdBaryDir2, false);
        if (d5 < 1.0E-10) {
            PsDebug.warning((String)"Edges degenerated in element set.");
            return null;
        }
        if ((d4 /= d5) > 1.0) {
            d4 = 1.0;
        } else if (d4 < -1.0) {
            d4 = -1.0;
        }
        d4 = Math.acos(d4);
        if (pdBaryDir.m_data[(n2 + 1) % 3] > 0.0) {
            d4 = Math.PI * 2 - d4;
        }
        pdBaryDirArray[n4] = new PdBaryDir(3);
        pdBaryDirArray[n4].copy(pdBaryDir);
        piVector2.setSize(pgVertexStar.getVertexLocInd().getSize());
        piVector2.copy(pgVertexStar.getVertexLocInd());
        PdBaryDir pdBaryDir3 = new PdBaryDir(3);
        PdBaryDir pdBaryDir4 = new PdBaryDir(3);
        double d6 = 0.0;
        int n5 = n4 + 1;
        while (n5 < n4 + pgVertexStar.getSize()) {
            int n6 = n5 % pgVertexStar.getSize();
            if (!pgVertexStar.isClosed() && n5 == pgVertexStar.getSize()) {
                d6 += d3;
            }
            int n7 = piVector2.m_data[n6];
            pdBaryDir2.m_data[n7] = -1.0;
            pdBaryDir2.m_data[(n7 + 1) % 3] = 1.0;
            pdBaryDir2.m_data[(n7 + 2) % 3] = 0.0;
            d5 = PwBary.norm(pgElementSet, piVector.m_data[n6], pdBaryDir2, false);
            if (d5 < 1.0E-10) {
                PsDebug.warning((String)"Edges degenerated in element set.");
                return null;
            }
            pdBaryDir2.multScalar(1.0 / d5);
            pdBaryDir4 = new PdBaryDir(3);
            pdBaryDir4.m_data[n7] = -1.0;
            pdBaryDir4.m_data[(n7 + 1) % 3] = 0.0;
            pdBaryDir4.m_data[(n7 + 2) % 3] = 1.0;
            pdBaryDir3 = new PdBaryDir(3);
            pdBaryDir3.copy(pdBaryDir2);
            pdBaryDir3.multScalar(-1.0 * PwBary.scalar(pgElementSet, piVector.m_data[n6], pdBaryDir4, pdBaryDir2, false));
            pdBaryDir3.m_data[0] = pdBaryDir3.m_data[0] + pdBaryDir4.m_data[0];
            pdBaryDir3.m_data[1] = pdBaryDir3.m_data[1] + pdBaryDir4.m_data[1];
            pdBaryDir3.m_data[2] = pdBaryDir3.m_data[2] + pdBaryDir4.m_data[2];
            d5 = PwBary.norm(pgElementSet, piVector.m_data[n6], pdBaryDir3, false);
            if (Math.abs(d5) < 1.0E-10) {
                PsDebug.warning((String)"Edges degenerated in geometry.");
                return null;
            }
            pdBaryDir3.multScalar(1.0 / d5);
            double d7 = d2 / 2.0 - d6 - d4;
            pdBaryDirArray[n6] = new PdBaryDir(3);
            pdBaryDirArray[n6].copy(pdBaryDir2);
            pdBaryDirArray[n6].multScalar(Math.cos(d7));
            pdBaryDir4.copy(pdBaryDir3);
            pdBaryDir4.multScalar(Math.sin(d7));
            pdBaryDirArray[n6].m_data[0] = pdBaryDirArray[n6].m_data[0] + pdBaryDir4.m_data[0];
            pdBaryDirArray[n6].m_data[1] = pdBaryDirArray[n6].m_data[1] + pdBaryDir4.m_data[1];
            pdBaryDirArray[n6].m_data[2] = pdBaryDirArray[n6].m_data[2] + pdBaryDir4.m_data[2];
            pdBaryDirArray[n6].multScalar(d);
            d6 += pdVector.m_data[n6];
            ++n5;
        }
        return pdBaryDirArray;
    }
}

