/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.util.Vector;
import jv.geom.PgBndConstraint;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementSet;
import jv.geom.PgPolygonSet;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwCleanMesh;
import jvx.project.PjWorkshop;

public class PwBoundary
extends PjWorkshop {
    protected boolean m_bMakeBoundaryConstraints;
    protected PuDouble m_lineTol = new PuDouble(PsConfig.getMessage((int)54045), (PsUpdateIf)this);
    protected double m_defaultLineTol = 0.001;
    protected PuDouble m_planeTol = new PuDouble(PsConfig.getMessage((int)54046), (PsUpdateIf)this);
    protected double m_defaultPlaneTol = 0.001;
    private static /* synthetic */ Class class$jvx$geom$PwBoundary;

    public void close() {
        PwCleanMesh.removeMarks(this.m_geom);
        this.update((Object)this);
        super.close();
    }

    public void reset() {
        super.reset();
        this.m_geom.copy((PsObject)this.m_geomSave);
        this.update((Object)this);
    }

    public static void makeBoundaryConstraint(PgElementSet pgElementSet, int n, double d, double d2) {
        int n2;
        PgBndPolygon[] pgBndPolygonArray;
        if (!pgElementSet.hasBoundary()) {
            PsDebug.warning((String)"Missing Boundary");
        }
        if ((pgBndPolygonArray = pgElementSet.getBoundaries()).length - 1 < n) {
            PsDebug.warning((String)"bndIndex to high");
        }
        PiVector piVector = pgBndPolygonArray[n].getVertexInd();
        int n3 = pgBndPolygonArray[n].getNumVertices();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        if (n3 < 2) {
            return;
        }
        double d3 = PdVector.dist((PdVector)pdVectorArray[piVector.m_data[0]], (PdVector)pdVectorArray[piVector.m_data[n3 - 1]]);
        boolean bl = true;
        if (d3 > 1.0E-10) {
            int n4 = 1;
            while (n4 < n3 - 1) {
                double d4 = PdVector.dist((PdVector)pdVectorArray[piVector.m_data[0]], (PdVector)pdVectorArray[piVector.m_data[n4]]);
                double d5 = PdVector.dist((PdVector)pdVectorArray[piVector.m_data[n3 - 1]], (PdVector)pdVectorArray[piVector.m_data[n4]]);
                if (d4 > d3) {
                    if ((d3 + d5) / d4 > 1.0 + d) {
                        bl = false;
                    }
                } else if (d5 > d3) {
                    if ((d3 + d4) / d5 > 1.0 + d) {
                        bl = false;
                    }
                } else if ((d4 + d5) / d3 > 1.0 + d) {
                    bl = false;
                }
                ++n4;
            }
        } else {
            bl = false;
        }
        if (bl) {
            PgBndConstraint pgBndConstraint = new PgBndConstraint(pgElementSet.getDimOfVertices());
            pgBndConstraint.setShape(4);
            pgBndConstraint.m_start = PdVector.copyNew((PdVector)pdVectorArray[piVector.m_data[0]]);
            pgBndConstraint.m_end = PdVector.copyNew((PdVector)pdVectorArray[piVector.m_data[n3 - 1]]);
            PdVector pdVector = PdVector.subNew((PdVector)pdVectorArray[piVector.m_data[n3 - 1]], (PdVector)pdVectorArray[piVector.m_data[0]]);
            pdVector.normalize();
            pgBndConstraint.m_dir = pdVector;
            pgBndPolygonArray[n].setBndConstraint(pgBndConstraint);
            return;
        }
        if (n3 < 3) {
            return;
        }
        PdVector pdVector = new PdVector();
        PdVector pdVector2 = new PdVector();
        boolean bl2 = false;
        int n5 = 0;
        while (n5 < n3 - 2) {
            n2 = n5 + 1;
            while (n2 < n3 - 1) {
                int n6 = n3 - 1;
                while (n6 > n2) {
                    PdVector pdVector3;
                    PdVector pdVector4 = PdVector.subNew((PdVector)pdVectorArray[piVector.m_data[n2]], (PdVector)pdVectorArray[piVector.m_data[n5]]);
                    pdVector = PdVector.crossNew((PdVector)pdVector4, (PdVector)(pdVector3 = PdVector.subNew((PdVector)pdVectorArray[piVector.m_data[n6]], (PdVector)pdVectorArray[piVector.m_data[n5]])));
                    if (pdVector.normalize()) {
                        pdVector4 = PdVector.crossNew((PdVector)pdVector, (PdVector)pdVector4);
                        pdVector4.normalize();
                        pdVector3.normalize();
                        PdVector pdVector5 = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[piVector.m_data[n2]], (double)0.5, (PdVector)pdVectorArray[piVector.m_data[n5]]);
                        PdVector pdVector6 = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[piVector.m_data[n6]], (double)0.5, (PdVector)pdVectorArray[piVector.m_data[n5]]);
                        double d6 = PdVector.dot((PdVector)PdVector.subNew((PdVector)pdVector6, (PdVector)pdVector5), (PdVector)pdVector3);
                        pdVector2 = pdVector5;
                        pdVector4.multScalar(d6 / PdVector.dot((PdVector)pdVector4, (PdVector)pdVector3));
                        pdVector2.add(pdVector4);
                        bl2 = true;
                        break;
                    }
                    --n6;
                }
                if (bl2) break;
                ++n2;
            }
            if (bl2) break;
            ++n5;
        }
        n5 = 0;
        if (bl2) {
            n5 = 1;
            n2 = 1;
            while (n2 < n3) {
                double d7 = Math.abs(PdVector.dot((PdVector)PdVector.subNew((PdVector)pdVectorArray[piVector.m_data[n2]], (PdVector)pdVectorArray[piVector.m_data[0]]), (PdVector)pdVector));
                if (d7 > d2) {
                    n5 = 0;
                    break;
                }
                ++n2;
            }
        }
        if (n5 == 0) {
            PgBndConstraint pgBndConstraint = new PgBndConstraint(pgElementSet.getDimOfVertices());
            pgBndConstraint.setShape(3);
            pgBndPolygonArray[n].setBndConstraint(pgBndConstraint);
            return;
        }
        PgBndConstraint pgBndConstraint = new PgBndConstraint(pgElementSet.getDimOfVertices());
        pgBndConstraint.setShape(5);
        pgBndConstraint.m_start = PdVector.copyNew((PdVector)pdVectorArray[piVector.m_data[0]]);
        pgBndConstraint.m_end = PdVector.copyNew((PdVector)pdVectorArray[piVector.m_data[n3 - 1]]);
        pgBndConstraint.m_dir = pdVector;
        pgBndPolygonArray[n].setBndConstraint(pgBndConstraint);
    }

    public PwBoundary() {
        super(PsConfig.getMessage((int)51065));
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwBoundary != null ? class$jvx$geom$PwBoundary : (class$jvx$geom$PwBoundary = PwBoundary.class$("jvx.geom.PwBoundary")))) {
            this.init();
        }
    }

    public void makeBoundaryConstraints() {
        PgElementSet pgElementSet = (PgElementSet)this.m_geom;
        if (!pgElementSet.hasBoundary()) {
            PsDebug.warning((String)"Missing Boundary");
        }
        PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
        int n = 0;
        while (n < pgBndPolygonArray.length) {
            PwBoundary.makeBoundaryConstraint(pgElementSet, n, this.m_lineTol.getValue(), this.m_planeTol.getValue());
            ++n;
        }
        n = 0;
        while (n < pgBndPolygonArray.length) {
            PgBndConstraint pgBndConstraint = pgBndPolygonArray[n].getBndConstraint();
            if (pgBndConstraint != null && pgBndConstraint.hasShape(5)) {
                int n2;
                int n3 = pgBndPolygonArray[n].getNumVertices();
                PiVector piVector = pgBndPolygonArray[n].getVertexInd();
                int n4 = piVector.getEntry(0);
                if (n4 == (n2 = piVector.getEntry(n3 - 1))) {
                    pgBndConstraint.m_startDir = null;
                    pgBndConstraint.m_endDir = null;
                } else {
                    int n5 = 0;
                    while (n5 < pgBndPolygonArray.length) {
                        PgBndConstraint pgBndConstraint2;
                        if (n != n5 && (pgBndConstraint2 = pgBndPolygonArray[n5].getBndConstraint()) != null && pgBndConstraint2.hasShape(5)) {
                            n3 = pgBndPolygonArray[n5].getNumVertices();
                            piVector = pgBndPolygonArray[n5].getVertexInd();
                            PdVector pdVector = PdVector.crossNew((PdVector)pgBndConstraint.m_dir, (PdVector)pgBndConstraint2.m_dir);
                            pdVector.normalize();
                            if (n4 == piVector.getEntry(0)) {
                                pgBndConstraint.m_startDir = (PdVector)pdVector.clone();
                                pgBndConstraint2.m_startDir = (PdVector)pdVector.clone();
                            } else if (n4 == piVector.getEntry(n3 - 1)) {
                                pgBndConstraint.m_startDir = (PdVector)pdVector.clone();
                                pgBndConstraint2.m_endDir = (PdVector)pdVector.clone();
                            } else if (n2 == piVector.getEntry(0)) {
                                pgBndConstraint.m_endDir = (PdVector)pdVector.clone();
                                pgBndConstraint2.m_startDir = (PdVector)pdVector.clone();
                            } else if (n2 == piVector.getEntry(n3 - 1)) {
                                pgBndConstraint.m_endDir = (PdVector)pdVector.clone();
                                pgBndConstraint2.m_endDir = (PdVector)pdVector.clone();
                            }
                        }
                        ++n5;
                    }
                }
            }
            ++n;
        }
    }

    public boolean update(Object object) {
        if (object == this.m_lineTol) {
            return true;
        }
        if (object == this.m_planeTol) {
            return true;
        }
        return super.update(object);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setEnabledMakeConstraints(boolean bl) {
        this.m_bMakeBoundaryConstraints = bl;
    }

    public boolean isEnabledMakeConstraints() {
        return this.m_bMakeBoundaryConstraints;
    }

    public void ok() {
        this.makeBoundary();
        if (this.m_bMakeBoundaryConstraints) {
            this.makeBoundaryConstraints();
        }
        this.close();
    }

    public void init() {
        super.init();
        this.setEnabledMakeConstraints(true);
        this.m_lineTol.setDefBounds(0.0, 100.0 * this.m_defaultLineTol, 1.0 * this.m_defaultLineTol, 10.0 * this.m_defaultLineTol);
        this.m_lineTol.setDefValue(this.m_defaultLineTol);
        this.m_lineTol.init();
        this.m_planeTol.setDefBounds(0.0, 100.0 * this.m_defaultPlaneTol, 1.0 * this.m_defaultPlaneTol, 10.0 * this.m_defaultPlaneTol);
        this.m_planeTol.setDefValue(this.m_defaultPlaneTol);
        this.m_planeTol.init();
    }

    protected void removeBoundary() {
        if (this.m_geom == null) {
            return;
        }
        if (((PgElementSet)this.m_geom).hasBoundary()) {
            ((PgElementSet)this.m_geom).removeBoundaries();
        }
    }

    protected void makeBoundary() {
        if (this.m_geom == null) {
            return;
        }
        PwBoundary.makeBoundary((PgElementSet)this.m_geom);
    }

    public static void makeBoundary(PgElementSet pgElementSet) {
        PgBndPolygon[] pgBndPolygonArray;
        int n;
        int n2;
        if (pgElementSet.hasBoundary()) {
            pgElementSet.removeBoundaries();
        }
        Vector<PgBndPolygon[]> vector = new Vector<PgBndPolygon[]>();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        int n3 = pgElementSet.getNumElements();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            n2 = piVectorArray[n5].getSize();
            n = 0;
            while (n < n2) {
                if (piVectorArray2[n5].m_data[n] == -1) {
                    pgBndPolygonArray = new PiVector(2);
                    pgBndPolygonArray.m_data[0] = piVectorArray[n5].m_data[(n + 1) % n2];
                    pgBndPolygonArray.m_data[1] = piVectorArray[n5].m_data[(n + 2) % n2];
                    vector.addElement(pgBndPolygonArray);
                    ++n4;
                }
                ++n;
            }
            ++n5;
        }
        if (n4 == 0) {
            return;
        }
        PgPolygonSet pgPolygonSet = new PgPolygonSet(pgElementSet.getDimOfVertices());
        n2 = pgElementSet.getNumVertices();
        pgPolygonSet.setNumVertices(n2);
        if (n2 < 1) {
            return;
        }
        pgPolygonSet.setVertices(pgElementSet.getVertices());
        pgPolygonSet.setNumPolygons(n4);
        n = 0;
        while (n < n4) {
            pgPolygonSet.setPolygon(n, ((PiVector)vector.elementAt((int)n)).m_data[0], ((PiVector)vector.elementAt((int)n)).m_data[1]);
            ++n;
        }
        PwCleanMesh.joinPolygons(pgPolygonSet);
        n = pgPolygonSet.getNumPolygons();
        pgBndPolygonArray = new PgBndPolygon[n];
        int n6 = 0;
        while (n6 < n) {
            pgBndPolygonArray[n6] = new PgBndPolygon(pgElementSet.getDimOfVertices());
            pgBndPolygonArray[n6].setNumVertices(pgPolygonSet.getPolygon(n6).getSize());
            pgBndPolygonArray[n6].setElementSet(pgElementSet);
            pgBndPolygonArray[n6].getVertexInd().copy(pgPolygonSet.getPolygon(n6));
            pgBndPolygonArray[n6].makeElementInd();
            ++n6;
        }
        pgElementSet.setBoundary(pgBndPolygonArray);
    }
}

