/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgUtil;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PgVertexStar;
import jvx.numeric.PnJacobi;

public class PwCurvature
extends PsObject {
    public static void getPrincipalCurvatures(PgElementSet pgElementSet, PdVector[] pdVectorArray, PdVector[][] pdVectorArray2) {
        PwCurvature.getPrincipalCurvatures(pgElementSet, null, pdVectorArray, pdVectorArray2);
    }

    public static void getPrincipalCurvatures(PgElementSet pgElementSet) {
        PwCurvature.getPrincipalCurvatures(pgElementSet, false);
    }

    public static void getPrincipalCurvatures(PgElementSet pgElementSet, boolean bl) {
        int n;
        if (pgElementSet == null) {
            PsDebug.warning((String)"Cannot compute principal curvatures. Given geometry is null.");
            return;
        }
        int n2 = pgElementSet.getDimOfVertices();
        int n3 = pgElementSet.getNumVertices();
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)2, (int)n3);
        PdVector[][] pdVectorArrayArray = new PdVector[][]{PdVector.realloc(null, (int)n3, (int)n2), PdVector.realloc(null, (int)n3, (int)n2)};
        PwCurvature.getPrincipalCurvatures(pgElementSet, null, pdVectorArray, pdVectorArrayArray);
        if (bl) {
            // empty if block
        }
        int n4 = 0;
        while (n4 < n3) {
            n = 0;
            do {
                pdVectorArrayArray[n][n4].setLength(Math.abs(pdVectorArray[n].m_data[n4]));
            } while (++n < 2);
            ++n4;
        }
        PgVectorField[] pgVectorFieldArray = new PgVectorField[2];
        n = 0;
        do {
            pgVectorFieldArray[n] = new PgVectorField(n2);
            pgVectorFieldArray[n].setBasedOn(0);
            pgVectorFieldArray[n].setGeometry((PgPointSet)pgElementSet);
            pgVectorFieldArray[n].setVectors(pdVectorArrayArray[n]);
            pgElementSet.addVectorField(pgVectorFieldArray[n]);
        } while (++n < 2);
        pgVectorFieldArray[0].setName("Max Principal Curvature Direction");
        pgVectorFieldArray[1].setName("Min Principal Curvature Direction");
        pgVectorFieldArray = new PgVectorField[2];
        n = 0;
        do {
            pgVectorFieldArray[n] = new PgVectorField(n2);
            pgVectorFieldArray[n].setBasedOn(0);
            pgVectorFieldArray[n].setGeometry((PgPointSet)pgElementSet);
            pgVectorFieldArray[n].setVectors(pdVectorArrayArray[n]);
            PdVector[] pdVectorArray2 = pgVectorFieldArray[n].getVectors();
            int n5 = 0;
            while (n5 < n3) {
                pdVectorArray2[n5].multScalar(-1.0);
                ++n5;
            }
            pgElementSet.addVectorField(pgVectorFieldArray[n]);
        } while (++n < 2);
        pgVectorFieldArray[0].setName("Max Principal Curvature Direction");
        pgVectorFieldArray[1].setName("Min Principal Curvature Direction");
    }

    public static void getPrincipalCurvatures(PgElementSet pgElementSet, PdMatrix[] pdMatrixArray, PdVector[] pdVectorArray, PdVector[][] pdVectorArray2) {
        PwCurvature.getPrincipalCurvatures(pgElementSet, pdMatrixArray, pdVectorArray, pdVectorArray2, false);
    }

    public static void getPrincipalCurvatures(PgElementSet pgElementSet, PdMatrix[] pdMatrixArray, PdVector[] pdVectorArray, PdVector[][] pdVectorArray2, boolean bl) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Cannot compute principal curvatures. Given geometry is null.");
            return;
        }
        int n = pgElementSet.getDimOfVertices();
        int n2 = pgElementSet.getNumVertices();
        pdMatrixArray = PwCurvature.getShapeOperator(pgElementSet, pdMatrixArray, true);
        PdVector pdVector = new PdVector(n);
        PdVector pdVector2 = new PdVector(n);
        PdVector[] pdVectorArray3 = PdVector.realloc(null, (int)n, (int)n);
        int[] nArray = new int[n];
        int n3 = 0;
        while (n3 < n2) {
            PnJacobi.computeEigenvectors(pdMatrixArray[n3], n, pdVector, pdVectorArray3);
            int n4 = 0;
            while (n4 < n) {
                pdVector2.m_data[n4] = Math.abs(pdVector.m_data[n4]);
                ++n4;
            }
            PuMath.heapsort((int)n, (double[])pdVector2.m_data, (int[])nArray);
            if (!bl && pdVector.m_data[nArray[n - 1]] < pdVector.m_data[nArray[n - 2]]) {
                if (pdVectorArray2 != null) {
                    pdVectorArray2[0][n3].copyArray(pdVectorArray3[nArray[n - 2]]);
                }
                if (pdVectorArray != null) {
                    pdVectorArray[0].m_data[n3] = pdVector.m_data[nArray[n - 2]];
                }
                if (pdVectorArray2 != null) {
                    pdVectorArray2[1][n3].copyArray(pdVectorArray3[nArray[n - 1]]);
                }
                if (pdVectorArray != null) {
                    pdVectorArray[1].m_data[n3] = pdVector.m_data[nArray[n - 1]];
                }
            } else {
                n4 = 0;
                do {
                    if (pdVectorArray2 != null) {
                        pdVectorArray2[n4][n3].copyArray(pdVectorArray3[nArray[n - 1 - n4]]);
                    }
                    if (pdVectorArray == null) continue;
                    pdVectorArray[n4].m_data[n3] = pdVector.m_data[nArray[n - 1 - n4]];
                } while (++n4 < 2);
            }
            ++n3;
        }
    }

    public static PdVector[] getMeanCurvature(PgElementSet pgElementSet, PdVector[] pdVectorArray) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"elements must be triangular, no action");
            return pdVectorArray;
        }
        int n = pgElementSet.getDimOfVertices();
        int n2 = pgElementSet.getNumElements();
        int n3 = pgElementSet.getNumVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray2 = pgElementSet.getVertices();
        pdVectorArray = PdVector.realloc((PdVector[])pdVectorArray, (int)n3, (int)n);
        PdVector.setConstant((PdVector[])pdVectorArray, (double)0.0);
        double[] dArray = new double[3];
        PdVector[] pdVectorArray3 = new PdVector[3];
        PdVector[] pdVectorArray4 = new PdVector[3];
        PdVector pdVector = new PdVector(n);
        double[] dArray2 = new double[n3];
        pgElementSet.makeNeighbour();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        int n4 = 0;
        do {
            pdVectorArray4[n4] = new PdVector(n);
        } while (++n4 < 3);
        int n5 = 0;
        while (n5 < n3) {
            pdVectorArray2[n5].clearTag(0);
            ++n5;
        }
        n5 = 0;
        while (n5 < n2) {
            pdVectorArray3 = pgElementSet.getElementVertices(n5);
            double d = PdVector.area((PdVector[])pdVectorArray3);
            PuVectorGeom.ctg((double[])dArray, (PdVector)pdVectorArray3[0], (PdVector)pdVectorArray3[1], (PdVector)pdVectorArray3[2]);
            n4 = 0;
            do {
                pdVectorArray4[n4].sub(pdVectorArray3[(n4 - 1 + 3) % 3], pdVectorArray3[(n4 + 1 + 3) % 3]);
            } while (++n4 < 3);
            n4 = 0;
            do {
                int n6 = (n4 - 1 + 3) % 3;
                int n7 = (n4 + 1 + 3) % 3;
                PiVector piVector = piVectorArray2[n5];
                if (piVector.m_data[n6] == -1) {
                    if (piVector.m_data[n7] == -1) {
                        pdVector.setConstant(0.0);
                    } else {
                        pdVector.blend(-dArray[n6], pdVectorArray4[n6], dArray[n4], pdVectorArray4[n4]);
                    }
                } else if (piVector.m_data[n7] == -1) {
                    pdVector.blend(-dArray[n4], pdVectorArray4[n4], dArray[n7], pdVectorArray4[n7]);
                } else {
                    pdVector.blend(-dArray[n6], pdVectorArray4[n6], dArray[n7], pdVectorArray4[n7]);
                }
                pdVectorArray[piVectorArray[n5].m_data[n4]].add(pdVector);
                pdVectorArray2[piVectorArray[n5].m_data[n4]].setTag(0);
                int n8 = piVectorArray[n5].m_data[n4];
                dArray2[n8] = dArray2[n8] + d;
            } while (++n4 < 3);
            ++n5;
        }
        n5 = 0;
        while (n5 < n3) {
            pdVectorArray[n5].multScalar(0.5);
            ++n5;
        }
        return pdVectorArray;
    }

    public static boolean getMeanCurvature(PgElementSet pgElementSet) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"elements must be triangular, no action");
            return false;
        }
        int n = pgElementSet.getNumVertices();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        pgElementSet.assureVertexNormals();
        PdVector[] pdVectorArray2 = null;
        pdVectorArray2 = PwCurvature.getMeanCurvature(pgElementSet, pdVectorArray2);
        PdVector[] pdVectorArray3 = pgElementSet.getVertexNormals();
        int n2 = 0;
        while (n2 < n) {
            if (pdVectorArray[n2].hasTag(0)) {
                pdVectorArray3[n2].copy(pdVectorArray2[n2]);
            } else {
                pdVectorArray3[n2].setConstant(0.0);
            }
            ++n2;
        }
        return true;
    }

    public static PdVector getMeanCurvature(PgElementSet pgElementSet, PdVector pdVector) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"elements must be triangular, no action");
            return pdVector;
        }
        int n = pgElementSet.getNumVertices();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        if (!pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
        PdVector[] pdVectorArray2 = pgElementSet.getVertexNormals();
        if (pdVector == null) {
            pdVector = new PdVector(n);
        } else if (pdVector.getSize() < n) {
            pdVector.setSize(n);
        }
        PdVector[] pdVectorArray3 = PwCurvature.getMeanCurvature(pgElementSet, null);
        int n2 = 0;
        while (n2 < n) {
            pdVector.m_data[n2] = 0.0;
            if (pdVectorArray[n2].hasTag(0)) {
                pdVector.m_data[n2] = PdVector.dot((PdVector)pdVectorArray3[n2], (PdVector)pdVectorArray2[n2]) > 0.0 ? pdVectorArray3[n2].length() : -pdVectorArray3[n2].length();
                double[] dArray = pdVectorArray3[n2].m_data;
            }
            ++n2;
        }
        return pdVector;
    }

    protected static PdVector getEdgeCurv(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, PdVector pdVector5, double[] dArray) {
        if (pdVector5 == null || pdVector5.m_data.length < pdVector.m_data.length) {
            pdVector5 = new PdVector(pdVector.m_data.length);
        }
        if (dArray == null || dArray.length < 3) {
            dArray = new double[3];
        }
        PuVectorGeom.ctg((double[])dArray, (PdVector)pdVector, (PdVector)pdVector2, (PdVector)pdVector3);
        int n = 0;
        while (n < pdVector.m_data.length) {
            pdVector5.m_data[n] = dArray[1] * (pdVector3.m_data[n] - pdVector.m_data[n]) + dArray[2] * (pdVector2.m_data[n] - pdVector.m_data[n]);
            ++n;
        }
        PuVectorGeom.ctg((double[])dArray, (PdVector)pdVector4, (PdVector)pdVector3, (PdVector)pdVector2);
        n = 0;
        while (n < pdVector.m_data.length) {
            int n2 = n;
            pdVector5.m_data[n2] = pdVector5.m_data[n2] + (dArray[2] * (pdVector3.m_data[n] - pdVector4.m_data[n]) + dArray[1] * (pdVector2.m_data[n] - pdVector4.m_data[n]));
            ++n;
        }
        return pdVector5;
    }

    public static void makeColorFromGaussCurvature(PgElementSet pgElementSet) {
        pgElementSet.assureElementColors();
        pgElementSet.assureVertexColors();
        PdVector pdVector = new PdVector(pgElementSet.getNumVertices());
        PwCurvature.getGaussCurvature(pgElementSet, pdVector);
        double d = pdVector.max();
        double d2 = pdVector.min();
        double d3 = 255.0;
        if (d - d2 > 1.0E-10) {
            d3 = 255.0 / (d - d2);
        }
        double[] dArray = pdVector.m_data;
        int n = pgElementSet.getNumVertices() - 1;
        while (n >= 0) {
            pgElementSet.setVertexColor(n, PdColor.hsv2rgb((int)((int)((dArray[n] - d2) * d3)), (int)255, (int)255));
            --n;
        }
        pgElementSet.makeElementFromVertexColors();
    }

    public static PdMatrix[] getShapeOperator(PgElementSet pgElementSet, PdMatrix[] pdMatrixArray) {
        return PwCurvature.getShapeOperator(pgElementSet, pdMatrixArray, true);
    }

    public static PdMatrix[] getShapeOperator(PgElementSet pgElementSet, PdMatrix[] pdMatrixArray, boolean bl) {
        int n;
        if (pgElementSet == null) {
            PsDebug.warning((String)"Cannot compute shape operator. Given geometry is null.");
            return pdMatrixArray;
        }
        int n2 = pgElementSet.getNumVertices();
        int n3 = pgElementSet.getDimOfVertices();
        if (pdMatrixArray == null || pdMatrixArray.length < n2) {
            pdMatrixArray = PdMatrix.realloc(null, (int)n2, (int)n3, (int)n3);
        } else {
            n = 0;
            while (n < n2) {
                if (pdMatrixArray[n] == null || pdMatrixArray[n].getISize() != n3 || pdMatrixArray[n].getJSize() != n3) {
                    pdMatrixArray[n] = new PdMatrix(n3, n3);
                } else {
                    pdMatrixArray[n].setConstant(0.0);
                }
                ++n;
            }
        }
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        int n4 = pgElementSet.getNumElements();
        double[] dArray = new double[3];
        PdVector pdVector = new PdVector(n3);
        PdVector pdVector2 = new PdVector(n3);
        PdVector pdVector3 = new PdVector(n3);
        PdVector pdVector4 = new PdVector(n3);
        PdMatrix pdMatrix = new PdMatrix(n3, n3);
        PdVector[] pdVectorArray2 = null;
        PdVector pdVector5 = new PdVector(3);
        pgElementSet.assureVertexNormals();
        pdVectorArray2 = pgElementSet.getVertexNormals();
        pgElementSet.assureElementNormals();
        n = 0;
        while (n < n4) {
            int n5 = piVectorArray[n].getSize();
            int n6 = 0;
            while (n6 < n5) {
                if (piVectorArray2[n].m_data[n6] >= n) {
                    PdVector pdVector6 = pdVectorArray[piVectorArray[n].m_data[n6]];
                    PdVector pdVector7 = pdVectorArray[piVectorArray[n].m_data[(n6 + 1) % n5]];
                    PdVector pdVector8 = pdVectorArray[piVectorArray[n].m_data[(n6 + 2) % n5]];
                    PuVectorGeom.ctg((double[])dArray, (PdVector)pdVector6, (PdVector)pdVector7, (PdVector)pdVector8);
                    int n7 = 0;
                    while (n7 < n3) {
                        pdVector3.m_data[n7] = dArray[1] * (pdVector8.m_data[n7] - pdVector6.m_data[n7]) + dArray[2] * (pdVector7.m_data[n7] - pdVector6.m_data[n7]);
                        ++n7;
                    }
                    pdVector6 = pdVectorArray[pgElementSet.getOppVertexInd(n, n6)];
                    PuVectorGeom.ctg((double[])dArray, (PdVector)pdVector6, (PdVector)pdVector7, (PdVector)pdVector8);
                    n7 = 0;
                    while (n7 < n3) {
                        pdVector4.m_data[n7] = dArray[1] * (pdVector8.m_data[n7] - pdVector6.m_data[n7]) + dArray[2] * (pdVector7.m_data[n7] - pdVector6.m_data[n7]);
                        ++n7;
                    }
                    pdVector2.add(pdVector3, pdVector4);
                    double d = pdVector2.length();
                    if (!(d < 1.0E-10)) {
                        double d2;
                        if (PdVector.dot((PdVector)pdVector2, (PdVector)pdVectorArray2[piVectorArray[n].m_data[(n6 + 1) % n5]]) < 0.0) {
                            d *= -1.0;
                        }
                        pdVector2.normalize();
                        pdVector.sub(pdVector3, pdVector4);
                        pdVector.normalize();
                        if (bl) {
                            pdVector5.copyArray(pdVectorArray2[piVectorArray[n].m_data[(n6 + 1) % n5]]);
                            pdVector5.multScalar(-PdVector.dot((PdVector)pdVector, (PdVector)pdVector5));
                            pdVector5.add(pdVector);
                            pdVector5.normalize();
                            pdMatrix.adjoint(pdVector5);
                            d2 = d / 2.0 * Math.abs(PdVector.dot((PdVector)pdVector2, (PdVector)pdVectorArray2[piVectorArray[n].m_data[(n6 + 1) % n5]]));
                            pdMatrix.multScalar(d2);
                            pdMatrixArray[piVectorArray[n].m_data[(n6 + 1) % n5]].add(pdMatrix);
                            pdVector5.copyArray(pdVectorArray2[piVectorArray[n].m_data[(n6 + 2) % n5]]);
                            pdVector5.multScalar(-PdVector.dot((PdVector)pdVector, (PdVector)pdVector5));
                            pdVector5.add(pdVector);
                            pdVector5.normalize();
                            pdMatrix.adjoint(pdVector5);
                            d2 = d / 2.0 * Math.abs(PdVector.dot((PdVector)pdVector2, (PdVector)pdVectorArray2[piVectorArray[n].m_data[(n6 + 2) % n5]]));
                            pdMatrix.multScalar(d2);
                            pdMatrixArray[piVectorArray[n].m_data[(n6 + 2) % n5]].add(pdMatrix);
                        } else {
                            pdMatrix.adjoint(pdVector);
                            d2 = d / 2.0;
                            pdMatrix.multScalar(d2);
                            pdMatrixArray[piVectorArray[n].m_data[(n6 + 1) % n5]].add(pdMatrix);
                            pdMatrix.adjoint(pdVector);
                            d2 = d / 2.0;
                            pdMatrix.multScalar(d2);
                            pdMatrixArray[piVectorArray[n].m_data[(n6 + 2) % n5]].add(pdMatrix);
                        }
                    }
                }
                ++n6;
            }
            ++n;
        }
        return pdMatrixArray;
    }

    public static PdMatrix[] getShapeOperator(PgElementSet pgElementSet, double d) {
        double d2;
        int n;
        int n2;
        PdMatrix[] pdMatrixArray = PwCurvature.getShapeOperator(pgElementSet, null, false);
        int n3 = pgElementSet.getNumVertices();
        int n4 = pgElementSet.getNumElements();
        int n5 = pgElementSet.getDimOfVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        int[] nArray = new int[n3];
        int n6 = 0;
        while (n6 < n4) {
            n2 = piVectorArray[n6].m_data.length;
            n = 0;
            while (n < n2) {
                if (nArray[piVectorArray[n6].m_data[n]] == 0) {
                    nArray[piVectorArray[n6].m_data[n]] = n6;
                }
                ++n;
            }
            ++n6;
        }
        double[] dArray = new double[n3];
        n6 = 0;
        while (n6 < n4) {
            n2 = piVectorArray[n6].m_data.length;
            d2 = pgElementSet.getAreaOfElement(n6);
            n = 0;
            while (n < n2) {
                int n7 = piVectorArray[n6].m_data[n];
                dArray[n7] = dArray[n7] + d2;
                ++n;
            }
            ++n6;
        }
        PdMatrix[] pdMatrixArray2 = PdMatrix.realloc(null, (int)n3, (int)n5, (int)n5);
        PgVertexStar pgVertexStar = new PgVertexStar();
        boolean[] blArray = new boolean[n3];
        PiVector piVector = new PiVector(25);
        n6 = 0;
        while (n6 < n3) {
            int n8 = 0;
            int n9 = 1;
            piVector.m_data[0] = n6;
            blArray[n6] = true;
            d2 = 0.0;
            while (n8 < n9) {
                int n10 = piVector.m_data[n8++];
                pdMatrixArray2[n6].add(pdMatrixArray[n10]);
                d2 += dArray[n10];
                pgVertexStar.makeVertexStar(pgElementSet, n10, nArray[n10]);
                int[] nArray2 = pgVertexStar.getLink().m_data;
                n = 0;
                while (n < nArray2.length) {
                    if (!blArray[nArray2[n]] && !(PdVector.dist((PdVector)pdVectorArray[n6], (PdVector)pdVectorArray[nArray2[n]]) > d)) {
                        blArray[nArray2[n]] = true;
                        if (piVector.m_data.length == n9) {
                            piVector.setSize(2 * n9);
                        }
                        piVector.m_data[n9++] = nArray2[n];
                    }
                    ++n;
                }
            }
            pdMatrixArray2[n6].multScalar(1.0 / d2);
            n = 0;
            while (n < n9) {
                blArray[piVector.m_data[n]] = false;
                ++n;
            }
            ++n6;
        }
        return pdMatrixArray2;
    }

    public static double getGaussCurvature(PgElementSet pgElementSet, int n) {
        return 0.0;
    }

    public static double getGaussCurvature(PgElementSet pgElementSet, PdVector pdVector) {
        int n;
        int n2;
        int n3 = pgElementSet.getNumElements();
        int n4 = pgElementSet.getNumVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        if (pdVector == null) {
            pdVector = new PdVector(n4);
        } else {
            if (pdVector.getSize() != n4) {
                pdVector.setSize(n4);
            }
            pdVector.setConstant(0.0);
        }
        double[] dArray = pdVector.m_data;
        int n5 = 0;
        while (n5 < n4) {
            pdVectorArray[n5].clearTag(0);
            ++n5;
        }
        double[] dArray2 = new double[3];
        n5 = 0;
        while (n5 < n3) {
            int n6;
            n2 = piVectorArray[n5].getSize();
            n = 0;
            while (n < n2) {
                pdVectorArray[piVectorArray[n5].m_data[n]].setTag(0);
                ++n;
            }
            PdVector[] pdVectorArray2 = pgElementSet.getElementVertices(n5);
            if (n2 > 3) {
                PiVector[] piVectorArray3 = PgUtil.triangulate((PdVector[])pdVectorArray2, (int)n2);
                n = 0;
                while (n < n2 - 2) {
                    PdVector.angle((double[])dArray2, (PdVector)pdVectorArray2[piVectorArray3[n].m_data[0]], (PdVector)pdVectorArray2[piVectorArray3[n].m_data[1]], (PdVector)pdVectorArray2[piVectorArray3[n].m_data[2]]);
                    n6 = 0;
                    do {
                        int n7 = piVectorArray[n5].m_data[piVectorArray3[n].m_data[n6]];
                        dArray[n7] = dArray[n7] + dArray2[n6];
                    } while (++n6 < 3);
                    ++n;
                }
            } else if (n2 == 3) {
                PdVector.angle((double[])dArray2, (PdVector)pdVectorArray2[0], (PdVector)pdVectorArray2[1], (PdVector)pdVectorArray2[2]);
                n6 = 0;
                do {
                    int n8 = piVectorArray[n5].m_data[n6];
                    dArray[n8] = dArray[n8] + dArray2[n6];
                } while (++n6 < 3);
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < n3) {
            n2 = piVectorArray[n5].m_data.length;
            n = 0;
            while (n < n2) {
                if (piVectorArray2[n5].m_data[n] == -1) {
                    pdVectorArray[piVectorArray[n5].m_data[(n + 1) % n2]].clearTag(0);
                    pdVectorArray[piVectorArray[n5].m_data[(n + 2) % n2]].clearTag(0);
                }
                ++n;
            }
            ++n5;
        }
        double d = 0.0;
        n5 = 0;
        while (n5 < n4) {
            if (pdVectorArray[n5].hasTag(0)) {
                pdVector.m_data[n5] = Math.PI * 2 - dArray[n5];
                d += pdVector.m_data[n5];
            } else {
                pdVector.m_data[n5] = 0.0;
            }
            ++n5;
        }
        return d;
    }
}

