/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.geom.PgElementSet;
import jv.object.PsConfig;
import jv.object.PsObject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.viewer.PvDisplay;
import jvx.geom.PwModel;
import jvx.project.PjWorkshop;

public class PwExplode
extends PjWorkshop
implements PsTimeListenerIf {
    public PsAnimation m_anim = new PsAnimation();
    private PdVector[] m_expDirection;
    private PdVector[] m_elCenter;
    private PdVector[] m_direction1;
    private PdVector[] m_direction2;
    private PdVector[] m_rotationAxis;
    private PdVector[] m_relCoord;
    private PdVector m_initialSpeed;
    private PdVector m_rotation;
    private double m_speed;
    private double m_gravity = 0.00981;
    private double m_rotationSpeed;
    private double m_normalAberration = 0.05;
    private double m_geomSize;
    private double m_insideTime = 50.0;
    private boolean m_bRunOnce;

    public void close() {
        this.m_anim.stop();
        this.m_anim.removeTimeListener((PsTimeListenerIf)this);
        super.close();
    }

    public void setGravity(double d) {
        this.m_gravity = d;
    }

    public double getGravity() {
        return this.m_gravity;
    }

    public void reset() {
        PdVector pdVector;
        PdMatrix pdMatrix;
        super.reset();
        this.m_geom.copy((PsObject)this.m_geomSave);
        this.m_geomSize = this.m_geom.getDiameter();
        this.m_speed = 0.2 * this.m_geomSize;
        this.m_gravity = 0.00981;
        PvDisplay pvDisplay = (PvDisplay)this.getDisplay();
        if (pvDisplay != null) {
            pdMatrix = new PdMatrix(4);
            pdMatrix = pvDisplay.getTransMatrix(128);
            PdVector pdVector2 = new PdVector(0.0, -1.0, 0.0, 0.0);
            pdVector2.leftMultMatrix(pdMatrix);
            pdVector = new PdVector(pdVector2.m_data[0], pdVector2.m_data[1], pdVector2.m_data[2]);
            double d = 10.0 * pdVector.length();
            double d2 = this.m_speed / (this.m_gravity * this.m_geomSize);
            this.m_insideTime = d2 + Math.sqrt(d2 * d2 + 2.0 * d / (this.m_gravity * this.m_geomSize));
        }
        this.m_rotationSpeed = 0.5;
        pdMatrix = (PgElementSet)this.m_geom;
        pdMatrix.showBoundaries(false);
        PwModel.shrink((PgElementSet)pdMatrix, 1.0);
        pdMatrix.makeElementNormals();
        int n = pdMatrix.getNumElements();
        this.m_expDirection = new PdVector[n];
        pdVector = new PdVector(3);
        int n2 = 0;
        while (n2 < n) {
            do {
                pdVector.m_data[0] = Math.random();
                pdVector.m_data[1] = Math.random();
                pdVector.m_data[2] = Math.random();
            } while (pdVector.sqrLength() < 0.01);
            pdVector.normalize();
            this.m_expDirection[n2] = PdVector.blendNew((double)(1.0 - this.m_normalAberration), (PdVector)pdMatrix.getElementNormal(n2), (double)this.m_normalAberration, (PdVector)pdVector);
            ++n2;
        }
        this.m_elCenter = new PdVector[n];
        this.m_initialSpeed = new PdVector(n);
        this.m_rotation = new PdVector(n);
        this.m_rotationAxis = new PdVector[n];
        this.m_direction1 = new PdVector[n];
        this.m_direction2 = new PdVector[n];
        this.m_relCoord = new PdVector[pdMatrix.getNumVertices()];
        PdVector pdVector3 = new PdVector(3);
        int n3 = 0;
        while (n3 < n) {
            this.m_initialSpeed.m_data[n3] = Math.random() * this.m_speed;
            this.m_rotation.m_data[n3] = Math.random() * this.m_rotationSpeed;
            this.m_elCenter[n3] = new PdVector(3);
            this.m_elCenter[n3].setConstant(0.0);
            PiVector piVector = pdMatrix.getElement(n3);
            int n4 = 0;
            while (n4 < piVector.getSize()) {
                this.m_elCenter[n3].add(pdMatrix.getVertex(piVector.m_data[n4]));
                ++n4;
            }
            this.m_elCenter[n3].multScalar(1.0 / (double)piVector.getSize());
            this.m_rotationAxis[n3] = new PdVector(3);
            do {
                this.m_rotationAxis[n3].m_data[0] = Math.random();
                this.m_rotationAxis[n3].m_data[1] = Math.random();
                this.m_rotationAxis[n3].m_data[2] = Math.random();
            } while (this.m_rotationAxis[n3].sqrLength() < 0.01);
            this.m_rotationAxis[n3].normalize();
            this.m_direction1[n3] = PdVector.normalToVectorNew((PdVector)this.m_rotationAxis[n3]);
            this.m_direction2[n3] = PdVector.crossNew((PdVector)this.m_rotationAxis[n3], (PdVector)this.m_direction1[n3]);
            n4 = 0;
            while (n4 < piVector.getSize()) {
                int n5 = piVector.m_data[n4];
                pdVector3 = PdVector.subNew((PdVector)pdMatrix.getVertex(n5), (PdVector)this.m_elCenter[n3]);
                this.m_relCoord[n5] = new PdVector(3);
                this.m_relCoord[n5].m_data[0] = PdVector.dot((PdVector)pdVector3, (PdVector)this.m_rotationAxis[n3]);
                this.m_relCoord[n5].m_data[1] = PdVector.dot((PdVector)pdVector3, (PdVector)this.m_direction1[n3]);
                this.m_relCoord[n5].m_data[2] = PdVector.dot((PdVector)pdVector3, (PdVector)this.m_direction2[n3]);
                ++n4;
            }
            ++n3;
        }
    }

    public PwExplode() {
        super(PsConfig.getMessage((int)48016));
        this.m_anim.setName(PsConfig.getMessage((int)48003));
        this.m_anim.setRepeat(0);
        this.m_anim.setSpeedType(0);
        this.m_anim.addTimeListener((PsTimeListenerIf)this);
        this.m_anim.setTimeInterval(0.0, 50.0, 1.0, 5.0);
    }

    public boolean setTime(PsTimeEvent psTimeEvent) {
        return this.setTime(psTimeEvent.getTime());
    }

    public boolean setTime(double d) {
        d *= this.m_insideTime / 50.0;
        PvDisplay pvDisplay = (PvDisplay)this.getDisplay();
        PdMatrix pdMatrix = new PdMatrix(4);
        pdMatrix = pvDisplay.getTransMatrix(128);
        PdVector pdVector = new PdVector(0.0, -1.0, 0.0, 0.0);
        pdVector.leftMultMatrix(pdMatrix);
        PdVector pdVector2 = new PdVector(pdVector.m_data[0], pdVector.m_data[1], pdVector.m_data[2]);
        pdVector2.normalize();
        pdVector2.multScalar(this.m_geomSize);
        int n = 3;
        PdVector pdVector3 = new PdVector(n);
        PdVector pdVector4 = new PdVector(n);
        int n2 = ((PgElementSet)this.m_geom).getNumElements();
        int n3 = 0;
        while (n3 < n2) {
            pdVector4.blendBase(this.m_elCenter[n3], d * this.m_initialSpeed.m_data[n3], this.m_expDirection[n3]);
            pdVector4.blendBase(pdVector4, d * d * this.m_gravity / 2.0, pdVector2);
            PiVector piVector = this.m_geom.getElement(n3);
            int n4 = piVector.getSize();
            double d2 = this.m_rotation.m_data[n3] * d;
            double d3 = Math.cos(d2);
            double d4 = Math.sin(d2);
            int n5 = 0;
            while (n5 < n4) {
                int n6 = piVector.m_data[n5];
                pdVector3.blendBase(pdVector4, this.m_relCoord[n6].m_data[0], this.m_rotationAxis[n3]);
                pdVector3.blendBase(pdVector3, d3 * this.m_relCoord[n6].m_data[1] - d4 * this.m_relCoord[n6].m_data[2], this.m_direction1[n3]);
                pdVector3.blendBase(pdVector3, d4 * this.m_relCoord[n6].m_data[1] + d3 * this.m_relCoord[n6].m_data[2], this.m_direction2[n3]);
                this.m_geom.setVertex(n6, pdVector3);
                ++n5;
            }
            ++n3;
        }
        return this.m_geom.update((Object)this.m_geom);
    }

    public PsAnimation getAnimation() {
        return this.m_anim;
    }

    public void setAnimation(PsAnimation psAnimation) {
        this.m_anim = psAnimation;
    }

    public String getName() {
        return PsConfig.getMessage((int)48004);
    }

    public boolean hasAnimation() {
        return true;
    }

    public void setSpeed(double d) {
        this.m_speed = d;
    }

    public double getSpeed() {
        return this.m_speed;
    }

    public void setRotationSpeed(double d) {
        this.m_rotationSpeed = d;
    }

    public double getRotationSpeed() {
        return this.m_rotationSpeed;
    }

    public void cancel() {
        this.m_anim.stop();
        super.cancel();
    }

    public void runOnce(boolean bl) {
        this.m_bRunOnce = bl;
    }
}

