/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.util.Vector;
import jv.function.PuFunction;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PuCleanMesh;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwBoundary;
import jvx.geom.PwCleanMesh;
import jvx.geom.PwGeodesic;
import jvx.geom.PwIntersectElementSet;
import jvx.numeric.PnRootFinder;

public class PwIntersectWithFunction
extends PwIntersectElementSet {
    protected PuFunction m_function = new PuFunction(3, 1);
    protected PuDouble m_level;
    protected String m_defaultFunction = "u*u+v*v+w*w";
    private PdVector vertexData;
    private static /* synthetic */ Class class$jvx$geom$PwIntersectWithFunction;

    protected void intersectWithFunction(double d) {
        PdVector pdVector = new PdVector(3);
        PdVector[] pdVectorArray = new PdVector[3];
        int n = this.m_subElements[0].size();
        this.m_currentIndex[0] = 0;
        while (this.m_currentIndex[0] < n) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            PiVector piVector = (PiVector)this.m_subElements[0].elementAt(this.m_currentIndex[0]);
            int n5 = 0;
            do {
                pdVectorArray[n5] = (PdVector)this.m_vertices[0].elementAt(piVector.m_data[n5]);
                pdVector.m_data[n5] = this.m_function.eval(0, pdVectorArray[n5].m_data) - d;
                if (pdVector.m_data[n5] > 1.0E-10) {
                    ++n2;
                    continue;
                }
                if (pdVector.m_data[n5] < -1.0E-10) {
                    ++n3;
                    continue;
                }
                ++n4;
                pdVector.m_data[n5] = 0.0;
            } while (++n5 < 3);
            if (n4 != 3 && n3 != 3 && n2 != 3 && (n4 != 1 || n3 != 2 && n2 != 2)) {
                int n6;
                int n7;
                PdVector pdVector2;
                double[] dArray;
                int n8;
                if (n4 == 2) {
                    n8 = pdVector.m_data[0] != 0.0 ? 0 : (pdVector.m_data[1] != 0.0 ? 1 : 2);
                    if (this.m_bCutElements[0]) {
                        this.divideElement(0, n8);
                        this.m_polygonSetXEdges[0].addElement(new PiVector(piVector.m_data[(n8 + 1) % 3], piVector.m_data[(n8 + 2) % 3]));
                    } else {
                        this.m_polygonSetEdges.addElement(new PiVector(this.addPolygonSetVertex(pdVectorArray[(n8 + 1) % 3]), this.addPolygonSetVertex(pdVectorArray[(n8 + 2) % 3])));
                    }
                } else if (n4 == 1) {
                    n8 = pdVector.m_data[0] == 0.0 ? 0 : (pdVector.m_data[1] == 0.0 ? 1 : 2);
                    dArray = PnRootFinder.findValue(this.m_function, pdVectorArray[(n8 + 2) % 3].m_data, pdVectorArray[(n8 + 1) % 3].m_data, d);
                    PdVector pdVector3 = new PdVector(dArray);
                    if (this.m_bCutElements[0]) {
                        int n9 = this.addVertex(0, piVector.m_data[(n8 + 1) % 3], piVector.m_data[(n8 + 2) % 3], pdVector3);
                        this.divideIntoTwo(0, n9, n8);
                        this.m_polygonSetXEdges[0].addElement(new PiVector(piVector.m_data[n8], n9));
                    } else {
                        this.m_polygonSetEdges.addElement(new PiVector(this.addPolygonSetVertex(pdVectorArray[n8]), this.addPolygonSetVertex(pdVector3)));
                    }
                } else if (n2 == 1) {
                    n8 = pdVector.m_data[0] > 0.0 ? 0 : (pdVector.m_data[1] > 0.0 ? 1 : 2);
                    dArray = PnRootFinder.findValue(this.m_function, pdVectorArray[n8].m_data, pdVectorArray[(n8 + 1) % 3].m_data, d);
                    PdVector pdVector4 = new PdVector(dArray);
                    dArray = PnRootFinder.findValue(this.m_function, pdVectorArray[n8].m_data, pdVectorArray[(n8 + 2) % 3].m_data, d);
                    pdVector2 = new PdVector(dArray);
                    if (this.m_bCutElements[0]) {
                        n7 = this.addVertex(0, piVector.m_data[n8], piVector.m_data[(n8 + 1) % 3], pdVector4);
                        n6 = this.addVertex(0, piVector.m_data[n8], piVector.m_data[(n8 + 2) % 3], pdVector2);
                        this.divideIntoThree(0, n7, n6, n8);
                        this.m_polygonSetXEdges[0].addElement(new PiVector(n7, n6));
                    } else {
                        this.m_polygonSetEdges.addElement(new PiVector(this.addPolygonSetVertex(pdVector4), this.addPolygonSetVertex(pdVector2)));
                    }
                } else {
                    n8 = pdVector.m_data[0] < 0.0 ? 0 : (pdVector.m_data[1] < 0.0 ? 1 : 2);
                    dArray = PnRootFinder.findValue(this.m_function, pdVectorArray[n8].m_data, pdVectorArray[(n8 + 1) % 3].m_data, d);
                    PdVector pdVector5 = new PdVector(dArray);
                    dArray = PnRootFinder.findValue(this.m_function, pdVectorArray[n8].m_data, pdVectorArray[(n8 + 2) % 3].m_data, d);
                    pdVector2 = new PdVector(dArray);
                    if (this.m_bCutElements[0]) {
                        n7 = this.addVertex(0, piVector.m_data[n8], piVector.m_data[(n8 + 1) % 3], pdVector5);
                        n6 = this.addVertex(0, piVector.m_data[n8], piVector.m_data[(n8 + 2) % 3], pdVector2);
                        this.divideIntoThree(0, n7, n6, n8);
                        this.m_polygonSetXEdges[0].addElement(new PiVector(n7, n6));
                    } else {
                        this.m_polygonSetEdges.addElement(new PiVector(this.addPolygonSetVertex(pdVector5), this.addPolygonSetVertex(pdVector2)));
                    }
                }
            }
            this.m_currentIndex[0] = this.m_currentIndex[0] + 1;
        }
        if (this.m_bCutElements[0]) {
            this.conformize(0);
            int n10 = this.m_polygonSetXEdges[0].size();
            this.m_polygonSet.setNumPolygons(n10);
            int n11 = 0;
            while (n11 < n10) {
                this.m_polygonSet.setPolygon(n11, (PiVector)this.m_polygonSetXEdges[0].elementAt(n11));
                ++n11;
            }
            this.m_polygonSet.setNumVertices(this.m_elSet[0].getNumVertices());
            this.m_polygonSet.setVertices((PdVector[])this.m_elSet[0].getVertices().clone());
        } else {
            int n12 = this.m_polygonSetEdges.size();
            int n13 = this.m_polygonSetVertices.size();
            this.m_polygonSet.setNumVertices(n13);
            int n14 = 0;
            while (n14 < n13) {
                this.m_polygonSet.setVertex(n14, (PdVector)this.m_polygonSetVertices.elementAt(n14));
                ++n14;
            }
            n14 = 0;
            while (n14 < n12) {
                this.m_polygonSet.setPolygon(n14, (PiVector)this.m_polygonSetEdges.elementAt(n14));
                ++n14;
            }
            PuCleanMesh.identifyVertices((PgPointSet)this.m_polygonSet, (double)1.0E-10);
        }
        this.m_polygonSet.setGlobalPolygonColor(new Color(255, 0, 0));
        this.m_polygonSet.showVertices(false);
    }

    public PwIntersectWithFunction() {
        super(PsConfig.getMessage((int)48006));
        this.m_function.setVariables(new String[]{"u", "v", "w"});
        this.m_function.setExpression(this.m_defaultFunction);
        this.m_function.setParent((PsUpdateIf)this);
        this.m_function.setName(PsConfig.getMessage((int)45005));
        this.m_level = new PuDouble(PsConfig.getMessage((int)54059), (PsUpdateIf)this);
        this.m_level.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_level.setDefValue(1.0);
        this.m_level.init();
        this.m_bFractionize = new boolean[1];
        this.m_bCutElements = new boolean[1];
        this.m_bFractionize[0] = false;
        this.m_bCutElements[0] = true;
        this.m_cancelUpdateList = new Vector();
        this.m_cancelRemoveList = new Vector();
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwIntersectWithFunction != null ? class$jvx$geom$PwIntersectWithFunction : (class$jvx$geom$PwIntersectWithFunction = PwIntersectWithFunction.class$("jvx.geom.PwIntersectWithFunction")))) {
            super.init();
        }
    }

    public void clipAtFunction(boolean bl) {
        this.intersectWithFunction();
        PgElementSet pgElementSet = this.splitFunctionIntersectedGeometry();
        if (bl) {
            if (pgElementSet != null) {
                this.m_geom.copy((PsObject)pgElementSet);
                return;
            }
            ((PgElementSet)this.m_geom).setNumElements(0);
            ((PgElementSet)this.m_geom).setNumVertices(0);
        }
    }

    private void intersectAtData() {
        if (this.m_elSet == null) {
            this.m_elSet = new PgElementSet[1];
            this.m_elSet[0] = (PgElementSet)this.m_geom;
        }
        this.m_elSet[0].copy((PsObject)this.m_geomSave);
        this.reset();
        PiVector piVector = new PiVector(1);
        piVector.m_data[0] = 0;
        int n = ((PgElementSet)this.m_geom).getNumVertices();
        this.vertexData = new PdVector(n);
        PwGeodesic.getDijkstraDistance((PgElementSet)this.m_geom, piVector);
        int n2 = 0;
        while (n2 < n) {
            this.vertexData.m_data[n2] = n2;
            ++n2;
        }
        this.intersectWithPdVector(this.m_level.getValue());
        this.m_geom = this.m_elSet[0];
    }

    public boolean update(Object object) {
        if (object == this) {
            this.intersectWithFunction();
            return super.update((Object)this);
        }
        if (object == this.m_level) {
            this.intersectWithFunction();
            return super.update((Object)this);
        }
        if (object == this.m_function) {
            this.computeBounds();
            this.intersectWithFunction();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    private void intersectWithPdVector(double d) {
        int n;
        int n2;
        Vector<PdVector> vector = new Vector<PdVector>();
        int n3 = this.m_elSet[0].getNumVertices();
        int n4 = 0;
        while (n4 < n3) {
            vector.addElement(new PdVector(this.vertexData.m_data[n4]));
            ++n4;
        }
        PdVector pdVector = new PdVector(3);
        int n5 = this.m_subElements[0].size();
        this.m_currentIndex[0] = 0;
        while (this.m_currentIndex[0] < n5) {
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            PiVector piVector = (PiVector)this.m_subElements[0].elementAt(this.m_currentIndex[0]);
            int n9 = 0;
            do {
                pdVector.m_data[n9] = ((PdVector)vector.elementAt((int)piVector.m_data[n9])).m_data[0] - d;
                if (pdVector.m_data[n9] > 1.0E-10) {
                    ++n6;
                    continue;
                }
                if (pdVector.m_data[n9] < -1.0E-10) {
                    ++n7;
                    continue;
                }
                ++n8;
                pdVector.m_data[n9] = 0.0;
            } while (++n9 < 3);
            if (n8 != 3 && n7 != 3 && n6 != 3 && (n8 != 1 || n7 != 2 && n6 != 2)) {
                int n10;
                int n11;
                PdVector pdVector2;
                double d2;
                int n12;
                if (n8 == 2) {
                    n12 = pdVector.m_data[0] != 0.0 ? 0 : (pdVector.m_data[1] != 0.0 ? 1 : 2);
                    if (this.m_bCutElements[0]) {
                        this.divideElement(0, n12);
                        this.m_polygonSetXEdges[0].addElement(new PiVector(piVector.m_data[(n12 + 1) % 3], piVector.m_data[(n12 + 2) % 3]));
                    } else {
                        this.m_polygonSetEdges.addElement(new PiVector(this.addPolygonSetVertex((PdVector)this.m_vertices[0].elementAt(piVector.m_data[(n12 + 1) % 3])), this.addPolygonSetVertex((PdVector)this.m_vertices[0].elementAt(piVector.m_data[(n12 + 2) % 3]))));
                    }
                } else if (n8 == 1) {
                    n12 = pdVector.m_data[0] == 0.0 ? 0 : (pdVector.m_data[1] == 0.0 ? 1 : 2);
                    d2 = pdVector.m_data[(n12 + 1) % 3] - pdVector.m_data[(n12 + 2) % 3];
                    PdVector pdVector3 = PdVector.blendNew((double)(pdVector.m_data[(n12 + 1) % 3] / d2), (PdVector)((PdVector)this.m_vertices[0].elementAt(piVector.m_data[(n12 + 2) % 3])), (double)(-pdVector.m_data[(n12 + 2) % 3] / d2), (PdVector)((PdVector)this.m_vertices[0].elementAt(piVector.m_data[(n12 + 1) % 3])));
                    if (this.m_bCutElements[0]) {
                        int n13 = this.addVertex(0, piVector.m_data[(n12 + 1) % 3], piVector.m_data[(n12 + 2) % 3], pdVector3);
                        if (n13 >= vector.size()) {
                            vector.addElement(new PdVector(d));
                        }
                        this.divideIntoTwo(0, n13, n12);
                        this.m_polygonSetXEdges[0].addElement(new PiVector(piVector.m_data[n12], n13));
                    } else {
                        this.m_polygonSetEdges.addElement(new PiVector(this.addPolygonSetVertex((PdVector)this.m_vertices[0].elementAt(piVector.m_data[n12])), this.addPolygonSetVertex(pdVector3)));
                    }
                } else if (n6 == 1) {
                    n12 = pdVector.m_data[0] > 0.0 ? 0 : (pdVector.m_data[1] > 0.0 ? 1 : 2);
                    d2 = pdVector.m_data[n12] - pdVector.m_data[(n12 + 1) % 3];
                    PdVector pdVector4 = PdVector.blendNew((double)(pdVector.m_data[n12] / d2), (PdVector)((PdVector)this.m_vertices[0].elementAt(piVector.m_data[(n12 + 1) % 3])), (double)(-pdVector.m_data[(n12 + 1) % 3] / d2), (PdVector)((PdVector)this.m_vertices[0].elementAt(piVector.m_data[n12])));
                    d2 = pdVector.m_data[n12] - pdVector.m_data[(n12 + 2) % 3];
                    pdVector2 = PdVector.blendNew((double)(pdVector.m_data[n12] / d2), (PdVector)((PdVector)this.m_vertices[0].elementAt(piVector.m_data[(n12 + 2) % 3])), (double)(-pdVector.m_data[(n12 + 2) % 3] / d2), (PdVector)((PdVector)this.m_vertices[0].elementAt(piVector.m_data[n12])));
                    if (this.m_bCutElements[0]) {
                        n11 = this.addVertex(0, piVector.m_data[n12], piVector.m_data[(n12 + 1) % 3], pdVector4);
                        if (n11 >= vector.size()) {
                            vector.addElement(new PdVector(d));
                        }
                        if ((n10 = this.addVertex(0, piVector.m_data[n12], piVector.m_data[(n12 + 2) % 3], pdVector2)) >= vector.size()) {
                            vector.addElement(new PdVector(d));
                        }
                        this.divideIntoThree(0, n11, n10, n12);
                        this.m_polygonSetXEdges[0].addElement(new PiVector(n11, n10));
                    } else {
                        this.m_polygonSetEdges.addElement(new PiVector(this.addPolygonSetVertex(pdVector4), this.addPolygonSetVertex(pdVector2)));
                    }
                } else {
                    n12 = pdVector.m_data[0] < 0.0 ? 0 : (pdVector.m_data[1] < 0.0 ? 1 : 2);
                    d2 = pdVector.m_data[n12] - pdVector.m_data[(n12 + 1) % 3];
                    PdVector pdVector5 = PdVector.blendNew((double)(pdVector.m_data[n12] / d2), (PdVector)((PdVector)this.m_vertices[0].elementAt(piVector.m_data[(n12 + 1) % 3])), (double)(-pdVector.m_data[(n12 + 1) % 3] / d2), (PdVector)((PdVector)this.m_vertices[0].elementAt(piVector.m_data[n12])));
                    d2 = pdVector.m_data[n12] - pdVector.m_data[(n12 + 2) % 3];
                    pdVector2 = PdVector.blendNew((double)(pdVector.m_data[n12] / d2), (PdVector)((PdVector)this.m_vertices[0].elementAt(piVector.m_data[(n12 + 2) % 3])), (double)(-pdVector.m_data[(n12 + 2) % 3] / d2), (PdVector)((PdVector)this.m_vertices[0].elementAt(piVector.m_data[n12])));
                    if (this.m_bCutElements[0]) {
                        n11 = this.addVertex(0, piVector.m_data[n12], piVector.m_data[(n12 + 1) % 3], pdVector5);
                        if (n11 >= vector.size()) {
                            vector.addElement(new PdVector(d));
                        }
                        if ((n10 = this.addVertex(0, piVector.m_data[n12], piVector.m_data[(n12 + 2) % 3], pdVector2)) >= vector.size()) {
                            vector.addElement(new PdVector(d));
                        }
                        this.divideIntoThree(0, n11, n10, n12);
                        this.m_polygonSetXEdges[0].addElement(new PiVector(n11, n10));
                    } else {
                        this.m_polygonSetEdges.addElement(new PiVector(this.addPolygonSetVertex(pdVector5), this.addPolygonSetVertex(pdVector2)));
                    }
                }
            }
            this.m_currentIndex[0] = this.m_currentIndex[0] + 1;
        }
        if (this.m_bCutElements[0]) {
            this.conformize(0);
            n2 = this.m_polygonSetXEdges[0].size();
            this.m_polygonSet.setNumPolygons(n2);
            n = 0;
            while (n < n2) {
                this.m_polygonSet.setPolygon(n, (PiVector)this.m_polygonSetXEdges[0].elementAt(n));
                ++n;
            }
            this.m_polygonSet.setNumVertices(this.m_elSet[0].getNumVertices());
            this.m_polygonSet.setVertices((PdVector[])this.m_elSet[0].getVertices().clone());
        } else {
            n2 = this.m_polygonSetEdges.size();
            n = this.m_polygonSetVertices.size();
            this.m_polygonSet.setNumVertices(n);
            int n14 = 0;
            while (n14 < n) {
                this.m_polygonSet.setVertex(n14, (PdVector)this.m_polygonSetVertices.elementAt(n14));
                ++n14;
            }
            n14 = 0;
            while (n14 < n2) {
                this.m_polygonSet.setPolygon(n14, (PiVector)this.m_polygonSetEdges.elementAt(n14));
                ++n14;
            }
            PuCleanMesh.identifyVertices((PgPointSet)this.m_polygonSet, (double)1.0E-10);
        }
        this.m_polygonSet.setGlobalPolygonColor(new Color(255, 0, 0));
        this.m_polygonSet.showVertices(false);
        n2 = this.m_elSet[0].getNumVertices();
        this.vertexData.setSize(n2);
        n = n3;
        while (n < n2) {
            this.vertexData.m_data[n] = d;
            ++n;
        }
    }

    public void setGeometry(PgGeometry pgGeometry) {
        super.setGeometry(pgGeometry);
        if (this.m_geomSave == null) {
            this.m_geomSave = (PgGeometry)this.m_geom.clone();
        }
        int n = this.m_geom.getDimOfVertices();
        this.m_function.setNumVariables(n);
        if (n == 4) {
            this.m_function.setVariables(new String[]{"u0", "u1", "u2", "u3"});
            this.m_function.setExpression("u0*u0+u1*u1+u2*u2+u3*u3");
        } else if (n == 3) {
            this.m_function.setVariables(new String[]{"u", "v", "w"});
            this.m_function.setExpression("u*u+v*v+w*w");
        } else if (n == 2) {
            this.m_function.setVariables(new String[]{"u", "v"});
            this.m_function.setExpression("u*u+v*v");
        } else if (n == 1) {
            this.m_function.setVariables(new String[]{"u"});
            this.m_function.setExpression("u");
        } else {
            PsDebug.warning((String)("void dimension of geometry, dim = " + String.valueOf(n)));
            return;
        }
        this.computeBounds();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String getFunction() {
        if (this.m_function.getNumFunctions() == 0) {
            return null;
        }
        return this.m_function.getExpression();
    }

    public void setFunction(String string) {
        this.m_defaultFunction = new String(string);
        this.m_function.setExpression(this.m_defaultFunction);
        this.computeBounds();
    }

    public PgElementSet splitAtFunction() {
        this.intersectWithFunction();
        PgElementSet pgElementSet = this.splitFunctionIntersectedGeometry();
        pgElementSet.setName(this.m_geom.getName() + " +");
        this.m_geom.setName(this.m_geom.getName() + " -");
        return pgElementSet;
    }

    private void computeBounds() {
        double d = (this.m_level.getValue() - this.m_level.getMin()) / (this.m_level.getMax() - this.m_level.getMin());
        if (this.m_geom == null) {
            return;
        }
        int n = ((PgPointSet)this.m_geomSave).getNumVertices();
        if (n < 1) {
            return;
        }
        double d2 = Double.MAX_VALUE;
        double d3 = Double.NEGATIVE_INFINITY;
        PdVector[] pdVectorArray = ((PgPointSet)this.m_geomSave).getVertices();
        int n2 = 0;
        while (n2 < n) {
            double d4 = this.m_function.eval(0, pdVectorArray[n2].m_data);
            if (d4 < d2) {
                d2 = d4;
            }
            if (d4 > d3) {
                d3 = d4;
            }
            ++n2;
        }
        if (d3 - d2 < 1.0E-10) {
            d3 += 1.0;
            d2 -= 1.0;
        }
        this.m_level.setBounds(d2, d3, (d3 - d2) / 100.0, (d3 - d2) / 10.0);
        this.m_level.setValue(d2 + d * (d3 - d2));
    }

    protected PgElementSet splitFunctionIntersectedGeometry() {
        PgElementSet pgElementSet = (PgElementSet)this.m_geom;
        if (!this.m_bFractionize[0]) {
            PwCleanMesh.cutAlongPolygonSet(pgElementSet, this.m_polygonSet);
        }
        int n = pgElementSet.getNumVertices();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        boolean[] blArray = new boolean[n];
        double d = this.m_level.getValue();
        int n2 = 0;
        while (n2 < n) {
            blArray[n2] = this.m_function.eval(0, pdVectorArray[n2].m_data) - d < -1.0E-10;
            ++n2;
        }
        return this.splitGeometry(pgElementSet, blArray);
    }

    public double getLevel() {
        return this.m_level.getValue();
    }

    public void setLevel(double d) {
        this.m_level.setValue(d);
    }

    private PgElementSet splitDataIntersectedGeometry() {
        PgElementSet pgElementSet = (PgElementSet)this.m_geom;
        if (!this.m_bFractionize[0]) {
            PwCleanMesh.cutAlongPolygonSet(pgElementSet, this.m_polygonSet);
        }
        int n = pgElementSet.getNumVertices();
        boolean[] blArray = new boolean[n];
        double d = this.m_level.getValue();
        int n2 = 0;
        while (n2 < this.vertexData.getSize()) {
            blArray[n2] = this.vertexData.m_data[n2] - d < -1.0E-10;
            ++n2;
        }
        n2 = this.vertexData.getSize();
        while (n2 < n) {
            blArray[n2] = false;
            ++n2;
        }
        return this.splitGeometry(pgElementSet, blArray);
    }

    protected PgElementSet splitGeometry(PgElementSet pgElementSet, boolean[] blArray) {
        int n;
        int n2 = 0;
        PiVector[] piVectorArray = pgElementSet.getElements();
        int n3 = pgElementSet.getNumElements();
        boolean[] blArray2 = new boolean[n3];
        int n4 = 0;
        while (n4 < n3) {
            n = piVectorArray[n4].getSize();
            blArray2[n4] = false;
            int n5 = 0;
            while (n5 < n) {
                if (blArray[piVectorArray[n4].m_data[n5]]) {
                    blArray2[n4] = true;
                    ++n2;
                    break;
                }
                ++n5;
            }
            ++n4;
        }
        PgElementSet pgElementSet2 = (PgElementSet)pgElementSet.clone();
        n = 0;
        while (n < n3) {
            if (blArray2[n]) {
                pgElementSet2.setTagElement(n, 2);
            } else {
                this.m_geom.setTagElement(n, 2);
            }
            ++n;
        }
        pgElementSet.removeMarkedElements();
        pgElementSet.removeUnusedVertices();
        PwBoundary.makeBoundary(pgElementSet);
        pgElementSet2.removeMarkedElements();
        pgElementSet2.removeUnusedVertices();
        PwBoundary.makeBoundary(pgElementSet2);
        return pgElementSet2;
    }

    public void intersectWithFunction() {
        if (this.m_elSet == null) {
            this.m_elSet = new PgElementSet[1];
            this.m_elSet[0] = (PgElementSet)this.m_geom;
        }
        this.m_elSet[0].copy((PsObject)this.m_geomSave);
        this.reset();
        this.intersectWithFunction(this.m_level.getValue());
        this.m_geom.copy((PsObject)this.m_elSet[0]);
    }
}

