/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.util.Random;
import java.util.Vector;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.vecmath.PiVector;
import jvx.geom.PwCleanMesh;
import jvx.geom.PwGeodesic;
import jvx.project.PjWorkshop;

public class PwMatching
extends PjWorkshop {
    protected PgElementSet m_elementSet;
    private int[] m_matching;
    private int m_noe;
    private int m_numUnmatched;
    private Vector m_outer;
    private Vector m_refusedOuter;
    private int[] m_iPreviousOuter;
    private int[] m_oDeviation;
    private int[] m_currentWay;
    private int[] m_root;
    private int[] m_triangleType;
    private static final int UNUSED = -1;
    private static final int ROOT = 0;
    private static final int INNER = 1;
    private static final int OUTER = 2;
    private int m_preMatching = 0;
    public static final int CONSERVATIVE = 0;
    public static final int DIJKSTRA = 1;
    public static final int GREEDY = 2;
    public static final int NONE = 3;
    private static /* synthetic */ Class class$jvx$geom$PwMatching;

    private void makeOuter(int n) {
        PiVector piVector = this.m_elementSet.getNeighbour(n);
        int n2 = 0;
        do {
            if (piVector.m_data[n2] == -1 || this.m_matching[piVector.m_data[n2]] == n || piVector.m_data[n2] == -1 || piVector.m_data[n2] == this.m_iPreviousOuter[n]) continue;
            int[] nArray = new int[]{n, piVector.m_data[n2], this.m_root[n]};
            this.m_outer.addElement(nArray);
        } while (++n2 < 3);
    }

    public void matchAllInner() {
        int n = this.m_noe;
        PgBndPolygon[] pgBndPolygonArray = null;
        boolean bl = false;
        if (this.m_elementSet.hasBoundary()) {
            bl = true;
            pgBndPolygonArray = (PgBndPolygon[])PsObject.clone((PsObject[])this.m_elementSet.getBoundaries());
        }
        PwCleanMesh.closeHoles(this.m_elementSet);
        this.init();
        if (this.m_preMatching == 0) {
            this.conservativeMatching();
        } else if (this.m_preMatching == 1) {
            this.dijkstraMatching();
        } else if (this.m_preMatching == 2) {
            this.greedyMatching();
        }
        this.setRoots();
        while (this.m_numUnmatched >= 2 && this.findMatching()) {
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.m_matching[n2] >= n) {
                this.m_matching[n2] = -1;
            }
            PiVector piVector = this.m_elementSet.getNeighbour(n2);
            int n3 = 0;
            do {
                if (piVector.m_data[n3] < n) continue;
                piVector.m_data[n3] = -1;
            } while (++n3 < 3);
            ++n2;
        }
        this.m_elementSet.setNumElements(n);
        this.m_noe = n;
        this.turnTriangles();
        if (bl) {
            this.m_elementSet.setBoundary(pgBndPolygonArray);
        }
        this.m_elementSet.update((Object)this.m_elementSet);
        this.init();
    }

    private void createBlossom(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = this.m_root[n];
        int[] nArray = new int[]{n, n2};
        int n7 = -1;
        int[][] nArrayArray = new int[2][];
        int n8 = 0;
        do {
            this.markPath(nArray[n8], n6);
            n5 = nArray[n8];
            n4 = 1;
            while (n5 != n6) {
                n4 += 2;
                if (n7 == -1 && this.m_root[n5] == -1) {
                    n7 = n5;
                }
                this.m_root[n5] = -1;
                n5 = this.m_currentWay[this.m_matching[n5]];
            }
            nArrayArray[n8] = new int[n4];
            n5 = nArray[n8];
            n3 = 0;
            while (n5 != n6) {
                nArrayArray[n8][n3] = n5;
                nArrayArray[n8][++n3] = this.m_matching[n5];
                ++n3;
                n5 = this.m_currentWay[this.m_matching[n5]];
            }
            nArrayArray[n8][n3] = n5;
            n3 = 0;
            while (n3 < n4) {
                this.m_currentWay[nArrayArray[n8][n3]] = -1;
                n3 += 2;
            }
        } while (++n8 < 2);
        n8 = 0;
        do {
            n4 = nArrayArray[n8].length;
            n3 = 0;
            while (n3 < n4) {
                this.m_root[nArrayArray[n8][n3]] = n6;
                n3 += 2;
            }
        } while (++n8 < 2);
        if (n7 == -1) {
            n7 = n6;
        }
        n8 = 0;
        do {
            n5 = nArray[n8];
            n4 = 0;
            int n9 = this.m_iPreviousOuter[nArray[n8]] != -1 ? nArray[n8] : -1;
            boolean bl = true;
            while (n5 != n7) {
                int n10 = nArrayArray[n8][n4 += 2];
                if (n10 != n7 && this.m_iPreviousOuter[n10] == -1) {
                    this.m_iPreviousOuter[n10] = this.m_matching[n5];
                }
                if (this.m_triangleType[this.m_matching[n5]] == 1) {
                    this.m_triangleType[this.m_matching[n5]] = 2;
                    this.makeOuter(this.m_matching[n5]);
                    this.m_oDeviation[this.m_matching[n5]] = n9;
                    if (bl) {
                        bl = false;
                        n9 = -1;
                    }
                } else if (!bl) {
                    bl = true;
                    n9 = n5;
                }
                n5 = n10;
            }
        } while (++n8 < 2);
        n8 = 0;
        do {
            if (nArray[n8] == n7 || this.m_iPreviousOuter[nArray[n8]] != -1) continue;
            this.m_iPreviousOuter[nArray[n8]] = nArray[(n8 + 1) % 2];
        } while (++n8 < 2);
    }

    public void reset() {
        this.m_geom.copy((PsObject)this.m_geomSave);
        this.m_elementSet.copy((PsObject)this.m_geom);
        this.m_elementSet.update((Object)this.m_elementSet);
        this.init();
    }

    public void greedyMatching() {
        int n = 0;
        while (n < this.m_noe) {
            PiVector piVector = this.m_elementSet.getNeighbour(n);
            if (this.m_matching[n] == -1) {
                int n2 = 0;
                do {
                    if (piVector.m_data[n2] == -1 || this.m_matching[piVector.m_data[n2]] != -1) continue;
                    this.m_matching[piVector.m_data[n2]] = n;
                    this.m_matching[n] = piVector.m_data[n2];
                    break;
                } while (++n2 < 3);
            }
            ++n;
        }
    }

    public PwMatching() {
        super(PsConfig.getMessage((int)54441));
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwMatching != null ? class$jvx$geom$PwMatching : (class$jvx$geom$PwMatching = PwMatching.class$("jvx.geom.PwMatching")))) {
            this.init();
        }
    }

    public void conservativeMatching() {
        int n = 0;
        while (n < this.m_noe) {
            this.m_matching[n] = -1;
            ++n;
        }
        n = 0;
        while (n < this.m_noe) {
            if (this.m_matching[n] == -1) {
                PiVector piVector = this.m_elementSet.getNeighbour(n);
                int n2 = piVector.m_data[0];
                if (n2 != -1) {
                    piVector = this.m_elementSet.getNeighbour(n2);
                    if (piVector.m_data[0] == n) {
                        this.m_matching[n] = n2;
                        this.m_matching[n2] = n;
                    }
                }
            }
            ++n;
        }
        this.greedyMatching();
    }

    protected void setRoots() {
        this.m_numUnmatched = 0;
        int n = 0;
        while (n < this.m_noe) {
            if (this.m_matching[n] == -1) {
                ++this.m_numUnmatched;
                this.m_triangleType[n] = 0;
                this.m_root[n] = n;
                this.makeOuter(n);
            } else {
                this.m_root[n] = -1;
                this.m_triangleType[n] = -1;
            }
            this.m_iPreviousOuter[n] = -1;
            this.m_oDeviation[n] = -1;
            this.m_currentWay[n] = -1;
            ++n;
        }
    }

    public void makeQuadrangulation() {
        int n;
        int n2 = 0;
        PiVector[] piVectorArray = new PiVector[this.m_noe];
        int[] nArray = new int[this.m_noe];
        int n3 = 0;
        while (n3 < this.m_noe) {
            PiVector piVector;
            piVectorArray[n3] = piVector = this.m_elementSet.getNeighbour(n3);
            if (!this.m_elementSet.hasTagElement(n3, 2)) {
                nArray[n3] = n3;
                if (piVector.getSize() == 3 && piVector.m_data[0] != -1) {
                    int n4 = piVector.m_data[0];
                    PiVector piVector2 = this.m_elementSet.getNeighbour(n4);
                    if (piVector2.getSize() == 3 && piVector2.m_data[0] == n3) {
                        int n5;
                        PiVector piVector3 = this.m_elementSet.getElement(n3);
                        PiVector piVector4 = this.m_elementSet.getElement(n4);
                        boolean bl = true;
                        if (piVector3.m_data[1] == piVector4.m_data[1]) {
                            bl = false;
                        }
                        if (this.m_elementSet.getDimOfElements() == 3) {
                            this.m_elementSet.setDimOfElements(-1);
                        }
                        piVectorArray[n3] = bl ? new PiVector(piVector2.m_data[1], piVector2.m_data[2], piVector.m_data[1], piVector.m_data[2]) : new PiVector(piVector2.m_data[2], piVector2.m_data[1], piVector.m_data[1], piVector.m_data[2]);
                        this.m_elementSet.setElement(n3, new PiVector(piVector3.m_data[0], piVector3.m_data[1], piVector4.m_data[0], piVector3.m_data[2]));
                        this.m_elementSet.setTagElement(n4, 2);
                        nArray[n4] = n3;
                        if (this.m_elementSet.hasElementNormals()) {
                            this.m_elementSet.getElementNormal(n3).blend(0.5, this.m_elementSet.getElementNormal(n3), 0.5, this.m_elementSet.getElementNormal(n4));
                        }
                        if ((n5 = this.m_elementSet.getNumVectorFields()) > 0) {
                            n = 0;
                            while (n < n5) {
                                PgVectorField pgVectorField = this.m_elementSet.getVectorField(n);
                                if (pgVectorField.getBasedOn() == 1) {
                                    pgVectorField.getVector(n3).blend(0.5, pgVectorField.getVector(n3), 0.5, pgVectorField.getVector(n4));
                                }
                                ++n;
                            }
                        }
                        if (this.m_elementSet.hasElementColors()) {
                            this.m_elementSet.setElementColor(n3, PdColor.blend((double)0.5, (Color)this.m_elementSet.getElementColor(n3), (double)0.5, (Color)this.m_elementSet.getElementColor(n4)));
                        }
                        if (this.m_elementSet.hasElementBackColors()) {
                            this.m_elementSet.setElementBackColor(n3, PdColor.blend((double)0.5, (Color)this.m_elementSet.getElementBackColor(n3), (double)0.5, (Color)this.m_elementSet.getElementBackColor(n4)));
                        }
                    } else {
                        ++n2;
                    }
                } else {
                    ++n2;
                }
            }
            ++n3;
        }
        if (this.m_elementSet.hasElementTextures()) {
            this.m_elementSet.assureElementTextures();
        }
        n3 = 0;
        while (n3 < this.m_noe) {
            int n6 = piVectorArray[n3].getSize();
            n = 0;
            while (n < n6) {
                if (piVectorArray[n3].m_data[n] != -1) {
                    piVectorArray[n3].m_data[n] = nArray[piVectorArray[n3].m_data[n]];
                }
                ++n;
            }
            ++n3;
        }
        this.m_elementSet.setNeighbours(piVectorArray);
        this.m_elementSet.removeMarkedElements();
        if (n2 == 0) {
            this.m_elementSet.setDimOfElements(4);
        } else {
            this.m_elementSet.setDimOfElements(-1);
        }
        this.m_elementSet.update((Object)this.m_elementSet);
    }

    public void scrambleTriangles() {
        int n = -1;
        Random random = new Random();
        int n2 = 0;
        while (n2 < this.m_noe) {
            int n3;
            PiVector piVector;
            PiVector piVector2;
            n = Math.abs(random.nextInt()) % 3;
            if (n == 1) {
                piVector2 = this.m_elementSet.getElement(n2);
                piVector = this.m_elementSet.getNeighbour(n2);
                n3 = piVector2.m_data[0];
                piVector2.m_data[0] = piVector2.m_data[1];
                piVector2.m_data[1] = piVector2.m_data[2];
                piVector2.m_data[2] = n3;
                n3 = piVector.m_data[0];
                piVector.m_data[0] = piVector.m_data[1];
                piVector.m_data[1] = piVector.m_data[2];
                piVector.m_data[2] = n3;
            } else if (n == 2) {
                piVector2 = this.m_elementSet.getElement(n2);
                piVector = this.m_elementSet.getNeighbour(n2);
                n3 = piVector2.m_data[0];
                piVector2.m_data[0] = piVector2.m_data[2];
                piVector2.m_data[2] = piVector2.m_data[1];
                piVector2.m_data[1] = n3;
                n3 = piVector.m_data[0];
                piVector.m_data[0] = piVector.m_data[2];
                piVector.m_data[2] = piVector.m_data[1];
                piVector.m_data[1] = n3;
            }
            ++n2;
        }
    }

    private void rematch(int n, int n2) {
        int[] nArray = new int[]{n, n2};
        int n3 = 0;
        do {
            int n4 = nArray[n3];
            int n5 = this.m_root[n4];
            this.markPath(nArray[n3], n5);
            int n6 = this.m_matching[n4];
            while (n4 != n5) {
                int n7 = n6;
                n4 = this.m_currentWay[n7];
                n6 = this.m_matching[n4];
                this.m_matching[n4] = n7;
                this.m_matching[n7] = n4;
                this.m_triangleType[n4] = -1;
                this.m_triangleType[n7] = -1;
                this.m_oDeviation[n4] = -1;
                this.m_oDeviation[n7] = -1;
                this.m_iPreviousOuter[n4] = -1;
                this.m_iPreviousOuter[n7] = -1;
                this.m_root[n4] = -1;
                this.m_root[n7] = -1;
                this.m_currentWay[n4] = -1;
                this.m_currentWay[n7] = -1;
            }
            this.m_matching[nArray[n3]] = nArray[(n3 + 1) % 2];
            this.m_triangleType[nArray[n3]] = -1;
            this.m_oDeviation[nArray[n3]] = -1;
            this.m_iPreviousOuter[nArray[n3]] = -1;
            this.m_currentWay[nArray[n3]] = -1;
        } while (++n3 < 2);
        n3 = this.m_refusedOuter.size() - 1;
        while (n3 >= 0) {
            int[] nArray2 = (int[])this.m_refusedOuter.elementAt(n3);
            if ((this.m_root[nArray2[1]] == this.m_root[nArray[0]] || this.m_root[nArray2[1]] == this.m_root[nArray[1]] || this.m_root[nArray2[1]] == -1) && this.m_root[nArray2[0]] != this.m_root[nArray[0]] && this.m_root[nArray2[0]] != this.m_root[nArray[1]] && this.m_matching[nArray2[2]] == -1) {
                this.m_outer.addElement(nArray2);
                this.m_refusedOuter.removeElementAt(n3);
            } else if (nArray2[2] == this.m_root[nArray[0]] || nArray2[2] == this.m_root[nArray[1]] || this.m_matching[nArray2[2]] != -1) {
                this.m_refusedOuter.removeElementAt(n3);
            }
            --n3;
        }
        this.m_root[nArray[0]] = -1;
        this.m_root[nArray[1]] = -1;
        this.m_numUnmatched -= 2;
    }

    public void match() {
        if (this.m_preMatching == 0) {
            this.conservativeMatching();
        } else if (this.m_preMatching == 1) {
            this.dijkstraMatching();
        } else if (this.m_preMatching == 2) {
            this.greedyMatching();
        }
        this.setRoots();
        while (this.m_numUnmatched >= 2 && this.findMatching()) {
        }
        this.turnTriangles();
        this.m_elementSet.update((Object)this.m_elementSet);
    }

    private void markPath(int n, int n2) {
        if (n == n2) {
            return;
        }
        if (this.m_matching[n] == n2) {
            return;
        }
        int n3 = n;
        while (this.m_oDeviation[n3] == -1) {
            this.m_currentWay[this.m_matching[n3]] = this.m_iPreviousOuter[this.m_matching[n3]];
            this.m_currentWay[this.m_currentWay[this.m_matching[n3]]] = this.m_matching[n3];
            if ((n3 = this.m_currentWay[this.m_matching[n3]]) != n2) continue;
            return;
        }
        this.markPath(this.m_oDeviation[n3], this.m_matching[n3]);
        PiVector piVector = this.m_elementSet.getNeighbour(this.m_oDeviation[n3]);
        int n4 = 0;
        do {
            if (piVector.m_data[n4] == this.m_matching[this.m_oDeviation[n3]] || piVector.m_data[n4] == this.m_iPreviousOuter[this.m_oDeviation[n3]]) continue;
            this.m_currentWay[piVector.m_data[n4]] = this.m_oDeviation[n3];
            this.m_currentWay[this.m_oDeviation[n3]] = piVector.m_data[n4];
            this.markPath(piVector.m_data[n4], n2);
            return;
        } while (++n4 < 3);
    }

    public void setPreMatching(int n) {
        this.m_preMatching = n;
    }

    public void setGeometry(PgElementSet pgElementSet) {
        this.m_elementSet = pgElementSet;
        super.setGeometry((PgGeometry)pgElementSet);
        this.init();
    }

    public void dijkstraMatching() {
        int n = this.m_elementSet.getNumVertices();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (this.m_elementSet.hasTagVertex(n3, 1)) {
                ++n2;
            }
            ++n3;
        }
        PiVector piVector = new PiVector();
        if (n2 == 0) {
            piVector.setSize(1);
            piVector.m_data[0] = 0;
        } else {
            piVector.setSize(n2);
            int n4 = 0;
            n3 = 0;
            while (n3 < n) {
                if (this.m_elementSet.hasTagVertex(n3, 1)) {
                    piVector.m_data[n4] = n3;
                    ++n4;
                }
                ++n3;
            }
        }
        PiVector piVector2 = PwGeodesic.getDijkstraDistance(this.m_elementSet, piVector);
        n3 = 0;
        while (n3 < this.m_noe) {
            this.m_matching[n3] = -1;
            ++n3;
        }
        n3 = 0;
        while (n3 < this.m_noe) {
            PiVector piVector3 = this.m_elementSet.getElement(n3);
            PiVector piVector4 = this.m_elementSet.getNeighbour(n3);
            int n5 = 0;
            do {
                if ((piVector2.m_data[piVector3.m_data[n5]] >= piVector2.m_data[piVector3.m_data[(n5 + 1) % 3]] || piVector2.m_data[piVector3.m_data[n5]] >= piVector2.m_data[piVector3.m_data[(n5 + 2) % 3]]) && (piVector2.m_data[piVector3.m_data[n5]] <= piVector2.m_data[piVector3.m_data[(n5 + 1) % 3]] || piVector2.m_data[piVector3.m_data[n5]] <= piVector2.m_data[piVector3.m_data[(n5 + 2) % 3]])) continue;
                this.m_matching[n3] = piVector4.m_data[n5];
            } while (++n5 < 3);
            ++n3;
        }
        n3 = 0;
        while (n3 < this.m_noe) {
            if (this.m_matching[n3] != -1 && this.m_matching[this.m_matching[n3]] != n3) {
                this.m_matching[n3] = -1;
            }
            ++n3;
        }
        this.greedyMatching();
    }

    protected boolean findMatching() {
        while (!this.m_outer.isEmpty()) {
            int[] nArray = (int[])this.m_outer.elementAt(0);
            this.m_outer.removeElementAt(0);
            int n = nArray[0];
            if (nArray[2] != this.m_root[n] || this.m_matching[this.m_root[n]] != -1) continue;
            int n2 = nArray[1];
            if (this.m_triangleType[n2] != -1 && this.m_matching[this.m_root[n2]] != -1 || this.m_triangleType[n2] == -1) {
                int n3 = this.m_matching[n2];
                this.m_iPreviousOuter[n3] = -1;
                this.m_oDeviation[n2] = -1;
                this.m_oDeviation[n3] = -1;
                this.m_currentWay[n2] = -1;
                this.m_currentWay[n3] = -1;
                this.m_triangleType[n2] = 1;
                this.m_triangleType[n3] = 2;
                this.m_iPreviousOuter[n2] = n;
                this.m_root[n2] = this.m_root[n];
                this.m_root[n3] = this.m_root[n];
                this.makeOuter(n3);
                continue;
            }
            if (this.m_triangleType[n2] == 2 || this.m_triangleType[n2] == 0) {
                if (this.m_root[n] == this.m_root[n2]) {
                    this.createBlossom(n, n2);
                    continue;
                }
                this.rematch(n, n2);
                return true;
            }
            if (this.m_root[n] == this.m_root[n2]) continue;
            this.m_refusedOuter.addElement(nArray);
        }
        return false;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void turnTriangles() {
        int n = -1;
        int n2 = 0;
        while (n2 < this.m_noe) {
            PiVector piVector;
            PiVector piVector2 = this.m_elementSet.getNeighbour(n2);
            if (this.m_matching[n2] == -1) {
                n = 0;
            }
            int n3 = 0;
            do {
                if (piVector2.m_data[n3] != this.m_matching[n2]) continue;
                n = n3;
                break;
            } while (++n3 < 3);
            if (n == 1) {
                piVector = this.m_elementSet.getElement(n2);
                n3 = piVector.m_data[0];
                piVector.m_data[0] = piVector.m_data[1];
                piVector.m_data[1] = piVector.m_data[2];
                piVector.m_data[2] = n3;
                n3 = piVector2.m_data[0];
                piVector2.m_data[0] = piVector2.m_data[1];
                piVector2.m_data[1] = piVector2.m_data[2];
                piVector2.m_data[2] = n3;
            } else if (n == 2) {
                piVector = this.m_elementSet.getElement(n2);
                n3 = piVector.m_data[0];
                piVector.m_data[0] = piVector.m_data[2];
                piVector.m_data[2] = piVector.m_data[1];
                piVector.m_data[1] = n3;
                n3 = piVector2.m_data[0];
                piVector2.m_data[0] = piVector2.m_data[2];
                piVector2.m_data[2] = piVector2.m_data[1];
                piVector2.m_data[1] = n3;
            }
            ++n2;
        }
    }

    public void init() {
        super.init();
        if (this.m_elementSet != null) {
            if (this.m_elementSet.getDimOfElements() != 3) {
                PsDebug.warning((String)"Geometry is not triangulated.");
            }
            if (!this.m_elementSet.checkNeighbour(false)) {
                this.m_elementSet.makeNeighbour();
            }
            this.m_noe = this.m_elementSet.getNumElements();
            this.m_matching = new int[this.m_noe];
            this.m_iPreviousOuter = new int[this.m_noe];
            this.m_oDeviation = new int[this.m_noe];
            this.m_currentWay = new int[this.m_noe];
            this.m_root = new int[this.m_noe];
            this.m_triangleType = new int[this.m_noe];
            int n = 0;
            while (n < this.m_noe) {
                this.m_matching[n] = -1;
                this.m_iPreviousOuter[n] = -1;
                this.m_oDeviation[n] = -1;
                this.m_currentWay[n] = -1;
                this.m_root[n] = -1;
                this.m_triangleType[n] = -1;
                ++n;
            }
            this.m_outer = new Vector();
            this.m_refusedOuter = new Vector();
        }
    }
}

