/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import jv.geom.PgElementEdge;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgTexture;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.objectGui.PsScanline;
import jv.project.PgGeometry;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.geom.PwBary;
import jvx.project.PjWorkshop;

public class PwRotDiv
extends PjWorkshop {
    protected PgElementSet m_elemset = null;
    protected PuInteger m_vecindex = new PuInteger(PsConfig.getMessage((int)54312), (PsUpdateIf)this);
    protected PdColor m_neg;
    protected PdColor m_zer;
    protected PdColor m_pos;
    protected PuDouble m_middle;
    protected PuDouble m_extension;
    protected PdVector[] m_scalarField;
    protected int m_fieldType;
    protected boolean m_bUseExistentTexture = false;
    public static final int VERTEX_ROTATION = 0;
    public static final int VERTEX_ROTATION_AREA = 1;
    public static final int EDGE_ROTATION = 2;
    public static final int EDGE_ROTATION_AREA = 3;
    public static final int VERTEX_DIVERGENCE = 4;
    public static final int VERTEX_DIVERGENCE_AREA = 5;
    public static final int EDGE_DIVERGENCE = 6;
    public static final int EDGE_DIVERGENCE_AREA = 7;
    public static final int VERTEX_ROTATION_NOGAUSS = 8;
    public static final int VERTEX_DIVERGENCE_NOGAUSS = 9;
    private static /* synthetic */ Class class$jvx$geom$PwRotDiv;

    public int getFieldType() {
        return this.m_fieldType;
    }

    private static void makeTextureFromScalarField(PgElementSet pgElementSet, Color color, Color color2, Color color3, double d, double d2, PdVector[] pdVectorArray) {
        int n = pgElementSet.getNumElements();
        PgTexture pgTexture = new PgTexture();
        int[] nArray = new int[1022];
        double d3 = color.getRed();
        double d4 = color.getGreen();
        double d5 = color.getBlue();
        double d6 = ((double)color2.getRed() - d3) / 255.0;
        double d7 = ((double)color2.getGreen() - d4) / 255.0;
        double d8 = ((double)color2.getBlue() - d5) / 255.0;
        int n2 = 0;
        int n3 = 0;
        do {
            nArray[n2] = -16777216 + ((int)d3 << 16) + ((int)d4 << 8) + (int)d5;
            nArray[++n2] = nArray[n2 - 1];
            ++n2;
            d3 += d6;
            d4 += d7;
            d5 += d8;
        } while (++n3 < 256);
        d6 = ((double)color3.getRed() - d3) / 255.0;
        d7 = ((double)color3.getGreen() - d4) / 255.0;
        d8 = ((double)color3.getBlue() - d5) / 255.0;
        n3 = 1;
        do {
            nArray[n2] = -16777216 + ((int)(d3 += d6) << 16) + ((int)(d4 += d7) << 8) + (int)(d5 += d8);
            nArray[++n2] = nArray[n2 - 1];
            ++n2;
        } while (++n3 < 256);
        pgTexture.setImage(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(2, 511, nArray, 0, 2)));
        PdVector[][] pdVectorArray2 = new PdVector[n][3];
        int n4 = 0;
        while (n4 < n) {
            double d9 = 0.0;
            n2 = 0;
            do {
                pdVectorArray2[n4][n2] = new PdVector(d9, Math.max(0.0, Math.min(1.0, 1.0 - ((pdVectorArray[n4].getEntry(n2) - d) * 0.5 / d2 + 0.5))));
                d9 += 0.5;
            } while (++n2 < 3);
            ++n4;
        }
        pgElementSet.setDimOfTextures(2);
        pgElementSet.assureElementTextures();
        pgElementSet.setElementTextures(pdVectorArray2);
        pgElementSet.setTexture(pgTexture);
    }

    protected static void makeVertexColorFromRotation(PgElementSet pgElementSet, int n, Color color, Color color2, Color color3) {
        PdVector pdVector = PwRotDiv.getVertexRotation(pgElementSet, n, null);
        if (pdVector == null) {
            return;
        }
        double d = Math.abs(pdVector.max());
        double d2 = Math.abs(pdVector.min());
        if (d2 > d) {
            d = d2;
        }
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        int n5 = color2.getRed();
        int n6 = color2.getGreen();
        int n7 = color2.getBlue();
        int n8 = color3.getRed();
        int n9 = color3.getGreen();
        int n10 = color3.getBlue();
        pgElementSet.showVertexColors(true);
        int n11 = pdVector.getSize();
        int n12 = 0;
        while (n12 < n11) {
            double d3 = pdVector.getEntry(n12);
            double d4 = Math.abs(d3) / d;
            double d5 = 1.0 - d4;
            if (d3 < 0.0) {
                pgElementSet.setVertexColor(n12, new Color((int)((double)n2 * d4 + (double)n5 * d5), (int)((double)n3 * d4 + (double)n6 * d5), (int)((double)n4 * d4 + (double)n7 * d5)));
            } else {
                pgElementSet.setVertexColor(n12, new Color((int)((double)n8 * d4 + (double)n5 * d5), (int)((double)n9 * d4 + (double)n6 * d5), (int)((double)n10 * d4 + (double)n7 * d5)));
            }
            ++n12;
        }
    }

    public double getMaximumValue() {
        if (this.m_scalarField == null) {
            return 0.0;
        }
        double d = Double.NEGATIVE_INFINITY;
        int n = 0;
        while (n < this.m_scalarField.length) {
            double d2 = this.m_scalarField[n].max();
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    private static PdVector[] scalarFromVertexToElementBased(PgElementSet pgElementSet, PdVector pdVector) {
        if (pdVector == null) {
            return null;
        }
        int n = pgElementSet.getNumElements();
        PdVector[] pdVectorArray = new PdVector[n];
        PiVector[] piVectorArray = pgElementSet.getElements();
        int n2 = 0;
        while (n2 < n) {
            pdVectorArray[n2] = new PdVector(3);
            int n3 = 0;
            do {
                pdVectorArray[n2].setEntry(n3, pdVector.getEntry(piVectorArray[n2].getEntry(n3)));
            } while (++n3 < 3);
            ++n2;
        }
        return pdVectorArray;
    }

    public PwRotDiv() {
        super(PsConfig.getMessage((int)48022));
        this.m_vecindex.setDefBounds(0, 0, 0, 0);
        this.m_vecindex.setDefValue(0);
        this.m_vecindex.init();
        this.m_neg = new PdColor(PsConfig.getMessage((int)54313), null);
        this.m_neg.setColor(Color.red);
        this.m_zer = new PdColor(PsConfig.getMessage((int)54314), null);
        this.m_zer.setColor(Color.white);
        this.m_pos = new PdColor(PsConfig.getMessage((int)54315), null);
        this.m_pos.setColor(Color.green);
        this.m_middle = new PuDouble(PsConfig.getMessage((int)54316), null);
        this.m_middle.setDefBounds(-10.0, 10.0, 0.1, 0.5);
        this.m_middle.setDefValue(0.0);
        this.m_extension = new PuDouble(PsConfig.getMessage((int)54317), null);
        this.m_extension.setDefBounds(0.0, 10.0, 0.1, 0.5);
        this.m_extension.setDefValue(3.0);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwRotDiv != null ? class$jvx$geom$PwRotDiv : (class$jvx$geom$PwRotDiv = PwRotDiv.class$("jvx.geom.PwRotDiv")))) {
            this.init();
        }
    }

    public void makeTexture() {
        if (this.m_scalarField == null) {
            return;
        }
        switch (this.m_fieldType) {
            case 0: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (this.m_bUseExistentTexture) {
                    PwRotDiv.colorTextureFromScalarField(this.m_elemset, this.m_neg.getColor(), this.m_zer.getColor(), this.m_pos.getColor(), this.m_middle.getValue(), this.m_extension.getValue(), this.m_scalarField);
                    return;
                }
                PwRotDiv.makeTextureFromScalarField(this.m_elemset, this.m_neg.getColor(), this.m_zer.getColor(), this.m_pos.getColor(), this.m_middle.getValue(), this.m_extension.getValue(), this.m_scalarField);
                return;
            }
        }
        PsDebug.warning((String)("wrong 'fieldType'=" + this.m_fieldType + ". Use constants from PwRotDiv."));
    }

    protected static PgPointSet createPointSetFromZMaxMinCrit(PgElementSet pgElementSet, Color color, Color color2, Color color3, double d) {
        if (pgElementSet.getDimOfVertices() < 3) {
            return null;
        }
        int n = pgElementSet.getDimOfVertices() - 1;
        PgPointSet pgPointSet = new PgPointSet(pgElementSet.getDimOfVertices());
        pgPointSet.setModelMatrix(pgElementSet.getModelMatrix());
        pgPointSet.assureVertexColors();
        pgPointSet.showVertexColors(true);
        pgPointSet.setName(PsConfig.getMessage((int)45058) + pgElementSet.getName());
        int n2 = pgElementSet.getNumVertices();
        pgElementSet.assureVertexColors();
        PgVertexStar pgVertexStar = new PgVertexStar();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        int n3 = 0;
        PdVector pdVector = new PdVector(pgElementSet.getDimOfVertices());
        int n4 = 0;
        while (n4 < n2) {
            if (n4 == 97) {
                System.err.println("");
            }
            pgVertexStar.makeVertexStar(pgElementSet, n4, -1);
            PiVector piVector = pgVertexStar.getLink();
            if (pgVertexStar.isClosed()) {
                double d2 = pdVectorArray[n4].getEntry(n);
                double d3 = d2 - d;
                double d4 = d2 + d;
                int n5 = piVector.getSize();
                boolean bl = true;
                boolean bl2 = true;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                while (n9 < n5) {
                    double d5 = pdVectorArray[piVector.getEntry(n9)].getEntry(n);
                    if (d5 > d3) {
                        bl2 = false;
                    }
                    if (d5 < d4) {
                        bl = false;
                    }
                    if (d5 > d4 && n7 < 0) {
                        ++n6;
                        n7 = 1;
                    } else if (d5 < d3 && n7 > 0) {
                        ++n6;
                        n7 = -1;
                    } else if (n7 == 0) {
                        if (d5 > d4) {
                            n7 = 1;
                        } else if (d5 < d3) {
                            n7 = -1;
                        }
                        n8 = n7;
                    }
                    ++n9;
                }
                n9 = 3;
                if (n8 != n7) {
                    ++n6;
                }
                if (bl2 || bl || n6 >= n9) {
                    pdVector.copy(pdVectorArray[n4]);
                    if (bl2) {
                        pdVector.setName(" +");
                    } else if (bl) {
                        pdVector.setName(" -");
                    } else {
                        pdVector.setName(" " + n6);
                    }
                    pgPointSet.addVertex(pdVector);
                    ++n3;
                }
                if (bl2) {
                    pgPointSet.setVertexColor(n3 - 1, color3);
                } else if (bl) {
                    pgPointSet.setVertexColor(n3 - 1, color);
                } else if (n6 >= n9) {
                    pgPointSet.setVertexColor(n3 - 1, color2);
                    pgPointSet.setVertex(n3 - 1, pdVector);
                }
            }
            ++n4;
        }
        return pgPointSet;
    }

    protected void makeEverythingVisible() {
        this.m_elemset.showElements(true);
        this.m_elemset.showElementTexture(true);
        this.m_elemset.update(null);
    }

    public static void colorTextureFromScalarField(PgElementSet pgElementSet, Color color, Color color2, Color color3, double d, double d2, PdVector[] pdVectorArray) {
        String string = "Could not fetch texture image";
        PgTexture pgTexture = pgElementSet.getTexture();
        if (pgTexture == null) {
            PsDebug.warning((String)string);
            return;
        }
        Image image = pgTexture.getImage();
        MediaTracker mediaTracker = new MediaTracker(new Panel());
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            PsDebug.warning((String)(string + ": " + interruptedException));
            return;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            PsDebug.warning((String)(string + ": " + interruptedException));
            return;
        }
        float[][] fArray = new float[3][3];
        int n3 = pgElementSet.getNumElements();
        PsScanline psScanline = new PsScanline();
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            int n6 = 0;
            do {
                double d3 = pdVectorArray[n4].getEntry(n6);
                double d4 = Math.min(Math.abs(d3 - d) / d2, 1.0);
                double d5 = 1.0 - d4;
                if (d > d3) {
                    fArray[n6][0] = (float)Math.min((d4 * (double)color.getRed() + d5 * (double)color2.getRed()) / 255.0, 1.0);
                    fArray[n6][1] = (float)Math.min((d4 * (double)color.getGreen() + d5 * (double)color2.getGreen()) / 255.0, 1.0);
                    fArray[n6][2] = (float)Math.min((d4 * (double)color.getBlue() + d5 * (double)color2.getBlue()) / 255.0, 1.0);
                    continue;
                }
                fArray[n6][0] = (float)Math.min((d4 * (double)color3.getRed() + d5 * (double)color2.getRed()) / 255.0, 1.0);
                fArray[n6][1] = (float)Math.min((d4 * (double)color3.getGreen() + d5 * (double)color2.getGreen()) / 255.0, 1.0);
                fArray[n6][2] = (float)Math.min((d4 * (double)color3.getBlue() + d5 * (double)color2.getBlue()) / 255.0, 1.0);
            } while (++n6 < 3);
            PdVector[] pdVectorArray2 = pgElementSet.getElementTexture(n4);
            psScanline.makeScanlines((int)(pdVectorArray2[0].m_data[0] * (double)(n - 1)), (int)((1.0 - pdVectorArray2[0].m_data[1]) * (double)(n2 - 1)), (int)(pdVectorArray2[1].m_data[0] * (double)(n - 1)), (int)((1.0 - pdVectorArray2[1].m_data[1]) * (double)(n2 - 1)), (int)(pdVectorArray2[2].m_data[0] * (double)(n - 1)), (int)((1.0 - pdVectorArray2[2].m_data[1]) * (double)(n2 - 1)));
            int n7 = psScanline.ymin;
            n6 = 0;
            while (n6 < psScanline.length) {
                int n8 = n7 * n + psScanline.xa[n6];
                int n9 = 0;
                do {
                    dArray[n9] = psScanline.aAnteile[n9][n6];
                    dArray2[n9] = (double)psScanline.eAnteile[n9][n6] - dArray[n9];
                    if (psScanline.xe[n6] <= psScanline.xa[n6]) continue;
                    int n10 = n9;
                    dArray2[n10] = dArray2[n10] / (double)(psScanline.xe[n6] - psScanline.xa[n6]);
                } while (++n9 < 3);
                n5 = psScanline.xa[n6];
                while (n5 <= psScanline.xe[n6]) {
                    double d6 = Math.max(Math.max((nArray[n8] & 0xFF0000) >> 16, (nArray[n8] & 0xFF00) >> 8), nArray[n8] & 0xFF);
                    double d7 = Math.min(((double)fArray[0][0] * dArray[0] + (double)fArray[1][0] * dArray[1] + (double)fArray[2][0] * dArray[2]) * 255.0, 255.0);
                    double d8 = Math.min(((double)fArray[0][1] * dArray[0] + (double)fArray[1][1] * dArray[1] + (double)fArray[2][1] * dArray[2]) * 255.0, 255.0);
                    double d9 = Math.min(((double)fArray[0][2] * dArray[0] + (double)fArray[1][2] * dArray[1] + (double)fArray[2][2] * dArray[2]) * 255.0, 255.0);
                    nArray[n8] = (nArray[n8] & 0xFF000000) + ((int)((d6 /= Math.max(d7, Math.max(d8, d9))) * d7) << 16) + ((int)(d6 * d8) << 8) + (int)(d6 * d9);
                    ++n8;
                    n9 = 0;
                    do {
                        int n11 = n9;
                        dArray[n11] = dArray[n11] + dArray2[n9];
                    } while (++n9 < 3);
                    ++n5;
                }
                n8 = n7 * n;
                n9 = 1;
                do {
                    if (psScanline.xa[n6] - n9 >= 0) {
                        nArray[n8 + psScanline.xa[n6] - n9] = nArray[n8 + psScanline.xa[n6]];
                    }
                    if (psScanline.xe[n6] + n9 >= n) continue;
                    nArray[n8 + psScanline.xe[n6] + n9] = nArray[n8 + psScanline.xe[n6]];
                } while (++n9 <= 2);
                ++n7;
                ++n6;
            }
            if (psScanline.length >= 1) {
                n7 = psScanline.ymin + psScanline.length;
                if (n7 < n2) {
                    n5 = psScanline.xa[psScanline.length - 1] - 2;
                    while (n5 <= psScanline.xe[psScanline.length - 1] + 2) {
                        if (n5 >= 0 && n5 < n) {
                            nArray[n7 * n + n5] = nArray[(n7 - 1) * n + n5];
                        }
                        ++n5;
                    }
                }
                if ((n7 = psScanline.ymin - 1) >= 0) {
                    n5 = psScanline.xa[psScanline.length - 1] - 2;
                    while (n5 <= psScanline.xe[psScanline.length - 1] + 2) {
                        if (n5 >= 0 && n5 < n) {
                            nArray[n7 * n + n5] = nArray[(n7 + 1) * n + n5];
                        }
                        ++n5;
                    }
                }
            }
            ++n4;
        }
        pgTexture.setImage(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n, n2, nArray, 0, n)));
        pgElementSet.setTexture(pgTexture);
    }

    public static PdVector getVertexRotation(PgElementSet pgElementSet, int n, PiVector piVector, PdVector pdVector) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing argument 'surface'");
            return null;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"'surface' not triangulated");
            return null;
        }
        if (pgElementSet.getNumVectorFields() <= n || n < 0) {
            PsDebug.warning((String)("non-existent vector field index=" + n));
            return null;
        }
        if (pgElementSet.getVectorField(n).getBasedOn() != 1) {
            PsDebug.warning((String)("not element based vector field index=" + n));
            return null;
        }
        if (piVector == null) {
            PsDebug.warning((String)"missing vertex indices");
            return null;
        }
        int n2 = piVector.getSize();
        if (pdVector == null) {
            pdVector = new PdVector(n2);
        }
        if (pdVector.getSize() < n2) {
            pdVector.setSize(n2);
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        PgVectorField pgVectorField = pgElementSet.getVectorField(n);
        PdVector pdVector2 = new PdVector(pgElementSet.getDimOfVertices());
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            double d = 0.0;
            pgVertexStar.makeVertexStar(pgElementSet, piVector.getEntry(n3), -1);
            PiVector piVector2 = pgVertexStar.getElement();
            PiVector piVector3 = pgVertexStar.getVertexLocInd();
            int n5 = piVector2.getSize();
            int n6 = 0;
            while (n6 < n5) {
                n4 = piVector3.getEntry(n6);
                int n7 = piVector2.getEntry(n6);
                pdVector2.sub(pdVectorArray[piVectorArray[n7].getEntry((n4 + 2) % 3)], pdVectorArray[piVectorArray[n7].getEntry((n4 + 1) % 3)]);
                d += PdVector.dot((PdVector)pdVector2, (PdVector)pgVectorField.getVector(n7));
                ++n6;
            }
            if (!pgVertexStar.isClosed()) {
                n6 = piVector3.getEntry(0);
                n4 = piVector2.getEntry(0);
                pdVector2.sub(pdVectorArray[piVectorArray[n4].getEntry((n6 + 1) % 3)], pdVectorArray[piVector.getEntry(n3)]);
                d += PdVector.dot((PdVector)pdVector2, (PdVector)pgVectorField.getVector(n4));
                n6 = piVector3.getLastEntry();
                n4 = piVector2.getLastEntry();
                pdVector2.sub(pdVectorArray[piVector.getEntry(n3)], pdVectorArray[piVectorArray[n4].getEntry((n6 + 2) % 3)]);
                d += PdVector.dot((PdVector)pdVector2, (PdVector)pgVectorField.getVector(n4));
            }
            pdVector.setEntry(n3, d);
            ++n3;
        }
        return pdVector;
    }

    public static PdVector getVertexRotation(PgElementSet pgElementSet, int n, PdVector pdVector) {
        return PwRotDiv.getVertexRotation(pgElementSet, n, pdVector, false, false);
    }

    public static PdVector getVertexRotation(PgElementSet pgElementSet, int n, PdVector pdVector, boolean bl, boolean bl2) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing argument 'surface'");
            return null;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"'surface' not triangulated");
            return null;
        }
        if (pgElementSet.getNumVectorFields() <= n || n < 0) {
            PsDebug.warning((String)("non-existent vector field index=" + n));
            return null;
        }
        if (pgElementSet.getVectorField(n).getBasedOn() != 1) {
            PsDebug.warning((String)("not element based vector field index=" + n));
            return null;
        }
        int n2 = pgElementSet.getNumVertices();
        if (pdVector == null) {
            pdVector = new PdVector(n2);
        }
        if (pdVector.getSize() < n2) {
            pdVector.setSize(n2);
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        PgVectorField pgVectorField = pgElementSet.getVectorField(n);
        PdVector pdVector2 = new PdVector(pgElementSet.getDimOfVertices());
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            double d = 0.0;
            double d2 = 0.0;
            pgVertexStar.makeVertexStar(pgElementSet, n3, -1);
            PiVector piVector = pgVertexStar.getElement();
            PiVector piVector2 = pgVertexStar.getVertexLocInd();
            int n5 = piVector.getSize();
            int n6 = 0;
            while (n6 < n5) {
                n4 = piVector2.getEntry(n6);
                int n7 = piVector.getEntry(n6);
                if (bl) {
                    d2 += pgElementSet.getAreaOfElement(n7);
                }
                pdVector2.sub(pdVectorArray[piVectorArray[n7].getEntry((n4 + 2) % 3)], pdVectorArray[piVectorArray[n7].getEntry((n4 + 1) % 3)]);
                d += PdVector.dot((PdVector)pdVector2, (PdVector)pgVectorField.getVector(n7));
                ++n6;
            }
            if (!pgVertexStar.isClosed() && !bl2) {
                n6 = piVector2.getEntry(0);
                n4 = piVector.getEntry(0);
                pdVector2.sub(pdVectorArray[piVectorArray[n4].getEntry((n6 + 1) % 3)], pdVectorArray[n3]);
                d += PdVector.dot((PdVector)pdVector2, (PdVector)pgVectorField.getVector(n4));
                n6 = piVector2.getLastEntry();
                n4 = piVector.getLastEntry();
                pdVector2.sub(pdVectorArray[n3], pdVectorArray[piVectorArray[n4].getEntry((n6 + 2) % 3)]);
                d += PdVector.dot((PdVector)pdVector2, (PdVector)pgVectorField.getVector(n4));
            }
            if (bl) {
                pdVector.setEntry(n3, d / d2);
            } else {
                pdVector.setEntry(n3, d);
            }
            ++n3;
        }
        return pdVector;
    }

    public static PdVector[] getEdgeRotation(PgElementSet pgElementSet, int n, PdVector[] pdVectorArray) {
        return PwRotDiv.getEdgeRotation(pgElementSet, n, pdVectorArray, false, false);
    }

    public static PdVector[] getEdgeRotation(PgElementSet pgElementSet, int n, PdVector[] pdVectorArray, boolean bl, boolean bl2) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing argument 'surface'");
            return null;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"'surface' not triangulated");
            return null;
        }
        if (pgElementSet.getNumVectorFields() <= n || n < 0) {
            PsDebug.warning((String)("non-existent vector field index=" + n));
            return null;
        }
        if (pgElementSet.getVectorField(n).getBasedOn() != 1) {
            PsDebug.warning((String)("not element based vector field index=" + n));
            return null;
        }
        int n2 = pgElementSet.getNumElements();
        if (pdVectorArray == null || pdVectorArray.length != n2) {
            pdVectorArray = new PdVector[n2];
        }
        PgVectorField pgVectorField = pgElementSet.getVectorField(n);
        PgElementEdge[] pgElementEdgeArray = pgElementSet.getEdgeList();
        PdVector pdVector = new PdVector(pgElementSet.getDimOfVertices());
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray2 = pgElementSet.getVertices();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        int n3 = 0;
        while (n3 < pgElementEdgeArray.length) {
            int n4;
            int n5 = pgElementEdgeArray[n3].getSize();
            double d = 0.0;
            double d2 = 0.0;
            if (n5 != 1 || bl2) {
                n4 = 0;
                while (n4 < 2 && n4 < n5) {
                    nArray[n4] = pgElementEdgeArray[n3].getElementInd(n4);
                    nArray2[n4] = pgElementEdgeArray[n3].getNeighbourLocInd(n4);
                    if (bl) {
                        d2 += pgElementSet.getAreaOfElement(nArray[n4]);
                    }
                    pdVector.sub(pdVectorArray2[piVectorArray[nArray[n4]].getEntry((nArray2[n4] + 2) % 3)], pdVectorArray2[piVectorArray[nArray[n4]].getEntry((nArray2[n4] + 1) % 3)]);
                    d -= PdVector.dot((PdVector)pdVector, (PdVector)pgVectorField.getVector(nArray[n4]));
                    ++n4;
                }
            }
            n4 = 0;
            while (n4 < 2 && n4 < n5) {
                if (pdVectorArray[nArray[n4]] == null) {
                    pdVectorArray[nArray[n4]] = new PdVector(3);
                }
                if (bl) {
                    pdVectorArray[nArray[n4]].setEntry(nArray2[n4], d / d2);
                } else {
                    pdVectorArray[nArray[n4]].setEntry(nArray2[n4], d);
                }
                ++n4;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            double d = pdVectorArray[n3].getEntry(0);
            double d3 = pdVectorArray[n3].getEntry(1);
            double d4 = pdVectorArray[n3].getEntry(2);
            pdVectorArray[n3].setEntry(0, d3 + d4 - d);
            pdVectorArray[n3].setEntry(1, d + d4 - d3);
            pdVectorArray[n3].setEntry(2, d + d3 - d4);
            ++n3;
        }
        return pdVectorArray;
    }

    public static PdVector getVertexDivergence(PgElementSet pgElementSet, int n, PdVector pdVector) {
        return PwRotDiv.getVertexDivergence(pgElementSet, n, pdVector, false, false);
    }

    public static PdVector getVertexDivergence(PgElementSet pgElementSet, int n, PdVector pdVector, boolean bl, boolean bl2) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing argument 'surface'");
            return null;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"'surface' not triangulated");
            return null;
        }
        if (pgElementSet.getNumVectorFields() <= n || n < 0) {
            PsDebug.warning((String)("non-existent vector field index=" + n));
            return null;
        }
        if (pgElementSet.getVectorField(n).getBasedOn() != 1) {
            PsDebug.warning((String)("not element based vector field index=" + n));
            return null;
        }
        int n2 = pgElementSet.getNumVertices();
        if (pdVector == null) {
            pdVector = new PdVector(n2);
        }
        if (pdVector.getSize() < n2) {
            pdVector.setSize(n2);
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        PgVectorField pgVectorField = pgElementSet.getVectorField(n);
        int n3 = pgElementSet.getDimOfVertices();
        PdVector pdVector2 = new PdVector(n3);
        PdBaryDir pdBaryDir = new PdBaryDir(3);
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        boolean bl3 = true;
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            double d = 0.0;
            double d2 = 0.0;
            pgVertexStar.makeVertexStar(pgElementSet, n4, -1);
            PiVector piVector = pgVertexStar.getElement();
            PiVector piVector2 = pgVertexStar.getVertexLocInd();
            int n6 = piVector.getSize();
            int n7 = 0;
            while (n7 < n6) {
                n5 = piVector2.getEntry(n7);
                int n8 = piVector.getEntry(n7);
                pdBaryDir.copyArray(PdBaryDir.TRIANGLE_EDGE[n5]);
                PwBary.rotateInElement(pgElementSet, n8, pdBaryDir, -1.5707963267948966, pdBaryDir, bl3);
                bl3 = false;
                PdBaryDir.getVector((PdVector)pdVector2, (PdBaryDir)pdBaryDir, (PdVector)pdVectorArray[piVectorArray[n8].getEntry(0)], (PdVector)pdVectorArray[piVectorArray[n8].getEntry(1)], (PdVector)pdVectorArray[piVectorArray[n8].getEntry(2)]);
                d += PdVector.dot((PdVector)pdVector2, (PdVector)pgVectorField.getVector(n8));
                d2 += pgElementSet.getAreaOfElement(n8);
                ++n7;
            }
            if (!pgVertexStar.isClosed() && !bl2) {
                n7 = piVector2.getEntry(0);
                n5 = piVector.getEntry(0);
                pdBaryDir.m_data[n7] = -1.0;
                pdBaryDir.m_data[(n7 + 2) % 3] = 0.0;
                pdBaryDir.m_data[(n7 + 1) % 3] = 1.0;
                PwBary.rotateInElement(pgElementSet, n5, pdBaryDir, -1.5707963267948966, pdBaryDir, bl3);
                PdBaryDir.getVector((PdVector)pdVector2, (PdBaryDir)pdBaryDir, (PdVector)pdVectorArray[piVectorArray[n5].getEntry(0)], (PdVector)pdVectorArray[piVectorArray[n5].getEntry(1)], (PdVector)pdVectorArray[piVectorArray[n5].getEntry(2)]);
                d += PdVector.dot((PdVector)pdVector2, (PdVector)pgVectorField.getVector(n5));
                n7 = piVector2.getLastEntry();
                n5 = piVector.getLastEntry();
                pdBaryDir.m_data[n7] = 1.0;
                pdBaryDir.m_data[(n7 + 2) % 3] = -1.0;
                pdBaryDir.m_data[(n7 + 1) % 3] = 0.0;
                PwBary.rotateInElement(pgElementSet, n5, pdBaryDir, -1.5707963267948966, pdBaryDir, bl3);
                PdBaryDir.getVector((PdVector)pdVector2, (PdBaryDir)pdBaryDir, (PdVector)pdVectorArray[piVectorArray[n5].getEntry(0)], (PdVector)pdVectorArray[piVectorArray[n5].getEntry(1)], (PdVector)pdVectorArray[piVectorArray[n5].getEntry(2)]);
                d += PdVector.dot((PdVector)pdVector2, (PdVector)pgVectorField.getVector(n5));
            }
            if (bl) {
                pdVector.setEntry(n4, d / d2);
            } else {
                pdVector.setEntry(n4, d);
            }
            ++n4;
        }
        return pdVector;
    }

    public static PdVector[] getEdgeDivergence(PgElementSet pgElementSet, int n, PdVector[] pdVectorArray) {
        return PwRotDiv.getEdgeDivergence(pgElementSet, n, pdVectorArray, false, false);
    }

    public static PdVector[] getEdgeDivergence(PgElementSet pgElementSet, int n, PdVector[] pdVectorArray, boolean bl, boolean bl2) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing argument 'surface'");
            return null;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"'surface' not triangulated");
            return null;
        }
        if (pgElementSet.getNumVectorFields() <= n || n < 0) {
            PsDebug.warning((String)("non-existent vector field index=" + n));
            return null;
        }
        if (pgElementSet.getVectorField(n).getBasedOn() != 1) {
            PsDebug.warning((String)("not element based vector field index=" + n));
            return null;
        }
        int n2 = pgElementSet.getNumElements();
        if (pdVectorArray == null || pdVectorArray.length != n2) {
            pdVectorArray = new PdVector[n2];
        }
        PgVectorField pgVectorField = pgElementSet.getVectorField(n);
        PgElementEdge[] pgElementEdgeArray = pgElementSet.getEdgeList();
        PdVector pdVector = new PdVector(pgElementSet.getDimOfVertices());
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray2 = pgElementSet.getVertices();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        PdBaryDir pdBaryDir = null;
        boolean bl3 = true;
        int n3 = 0;
        while (n3 < pgElementEdgeArray.length) {
            int n4 = pgElementEdgeArray[n3].getSize();
            double d = 0.0;
            double d2 = 0.0;
            int n5 = 0;
            while (n5 < 2 && n5 < n4) {
                nArray[n5] = pgElementEdgeArray[n3].getElementInd(n5);
                nArray2[n5] = pgElementEdgeArray[n3].getNeighbourLocInd(n5);
                if (bl) {
                    d2 += pgElementSet.getAreaOfElement(nArray[n5]);
                }
                if (n4 > 1 || bl2) {
                    if (pdBaryDir == null) {
                        pdBaryDir = new PdBaryDir(3);
                    }
                    pdBaryDir.copyArray(PdBaryDir.TRIANGLE_EDGE[nArray2[n5]]);
                    PwBary.rotateInElement(pgElementSet, nArray[n5], pdBaryDir, -1.5707963267948966, pdBaryDir, bl3);
                    bl3 = false;
                    PdBaryDir.getVector((PdVector)pdVector, (PdBaryDir)pdBaryDir, (PdVector)pdVectorArray2[piVectorArray[nArray[n5]].getEntry(0)], (PdVector)pdVectorArray2[piVectorArray[nArray[n5]].getEntry(1)], (PdVector)pdVectorArray2[piVectorArray[nArray[n5]].getEntry(2)]);
                    d += PdVector.dot((PdVector)pdVector, (PdVector)pgVectorField.getVector(nArray[n5]));
                }
                ++n5;
            }
            n5 = 0;
            while (n5 < 2 && n5 < n4) {
                if (pdVectorArray[nArray[n5]] == null) {
                    pdVectorArray[nArray[n5]] = new PdVector(3);
                }
                if (bl) {
                    pdVectorArray[nArray[n5]].setEntry(nArray2[n5], d / d2);
                } else {
                    pdVectorArray[nArray[n5]].setEntry(nArray2[n5], d);
                }
                ++n5;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            double d = pdVectorArray[n3].getEntry(0);
            double d3 = pdVectorArray[n3].getEntry(1);
            double d4 = pdVectorArray[n3].getEntry(2);
            pdVectorArray[n3].setEntry(0, d3 + d4 - d);
            pdVectorArray[n3].setEntry(1, d + d4 - d3);
            pdVectorArray[n3].setEntry(2, d + d3 - d4);
            ++n3;
        }
        return pdVectorArray;
    }

    public boolean update(Object object) {
        if (object == this.m_vecindex) {
            this.setFieldType(this.getFieldType());
            return super.update(null);
        }
        return super.update(object);
    }

    public void setGeometry(PgGeometry pgGeometry) {
        if (!(pgGeometry instanceof PgElementSet) || pgGeometry == null) {
            PsDebug.warning((String)"argument 'geom' is no element set");
            return;
        }
        PgElementSet pgElementSet = (PgElementSet)pgGeometry;
        int n = pgElementSet.getNumVectorFields();
        if (n <= 0) {
            PsDebug.warning((String)"argument 'geom' has no vector field");
            return;
        }
        int n2 = 0;
        while (n2 < n && pgElementSet.getVectorField(n2).getBasedOn() != 1) {
            ++n2;
        }
        if (n2 >= n) {
            PsDebug.warning((String)"argument 'geom' has no element based vector field");
            return;
        }
        super.setGeometry(pgGeometry);
        this.m_elemset = pgElementSet;
        if (this.m_elemset.hasElementTextures()) {
            this.m_bUseExistentTexture = true;
        }
        this.updateFromElementSet();
        this.m_vecindex.setDefValue(n2 + 1);
        this.m_vecindex.setValue(n2 + 1);
        this.setFieldType(0);
    }

    public void setColorExistentTexture(boolean bl) {
        this.m_bUseExistentTexture = bl;
    }

    public boolean getColorExistentTexture() {
        return this.m_bUseExistentTexture;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static void makeTextureFromVertexRotation(PgElementSet pgElementSet, int n, Color color, Color color2, Color color3, double d, double d2) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"'surface' not triangulated");
            return;
        }
        PdVector pdVector = PwRotDiv.getVertexRotation(pgElementSet, n, null);
        if (pdVector == null) {
            return;
        }
        PdVector[] pdVectorArray = PwRotDiv.scalarFromVertexToElementBased(pgElementSet, pdVector);
        PwRotDiv.makeTextureFromScalarField(pgElementSet, color, color2, color3, d, d2, pdVectorArray);
    }

    protected static void makeTextureFromEdgeRotation(PgElementSet pgElementSet, int n, Color color, Color color2, Color color3, double d, double d2) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"'surface' not triangulated");
            return;
        }
        PdVector[] pdVectorArray = PwRotDiv.getEdgeRotation(pgElementSet, n, null);
        if (pdVectorArray == null) {
            return;
        }
        PwRotDiv.makeTextureFromScalarField(pgElementSet, color, color2, color3, d, d2, pdVectorArray);
    }

    protected static void makeTextureFromVertexDivergence(PgElementSet pgElementSet, int n, Color color, Color color2, Color color3, double d, double d2) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"'surface' not triangulated");
            return;
        }
        PdVector pdVector = PwRotDiv.getVertexDivergence(pgElementSet, n, null);
        if (pdVector == null) {
            return;
        }
        PdVector[] pdVectorArray = PwRotDiv.scalarFromVertexToElementBased(pgElementSet, pdVector);
        PwRotDiv.makeTextureFromScalarField(pgElementSet, color, color2, color3, d, d2, pdVectorArray);
    }

    public void init() {
        this.m_middle.init();
        this.m_extension.init();
    }

    protected void updateFromElementSet() {
        this.m_vecindex.setDefBounds(1, this.m_elemset.getNumVectorFields(), 1, 2);
        this.m_vecindex.setDefValue(1);
        this.m_vecindex.init();
    }

    public double getMinimumValue() {
        if (this.m_scalarField == null) {
            return 0.0;
        }
        double d = Double.POSITIVE_INFINITY;
        int n = 0;
        while (n < this.m_scalarField.length) {
            double d2 = this.m_scalarField[n].min();
            if (d2 < d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public void setFieldType(int n) {
        switch (n) {
            case 0: {
                this.m_scalarField = PwRotDiv.scalarFromVertexToElementBased(this.m_elemset, PwRotDiv.getVertexRotation(this.m_elemset, this.m_vecindex.getValue() - 1, null));
                break;
            }
            case 1: {
                this.m_scalarField = PwRotDiv.scalarFromVertexToElementBased(this.m_elemset, PwRotDiv.getVertexRotation(this.m_elemset, this.m_vecindex.getValue() - 1, null, true, false));
                break;
            }
            case 2: {
                this.m_scalarField = PwRotDiv.getEdgeRotation(this.m_elemset, this.m_vecindex.getValue() - 1, null);
                break;
            }
            case 3: {
                this.m_scalarField = PwRotDiv.getEdgeRotation(this.m_elemset, this.m_vecindex.getValue() - 1, null, true, false);
                break;
            }
            case 4: {
                this.m_scalarField = PwRotDiv.scalarFromVertexToElementBased(this.m_elemset, PwRotDiv.getVertexDivergence(this.m_elemset, this.m_vecindex.getValue() - 1, null));
                break;
            }
            case 6: {
                this.m_scalarField = PwRotDiv.getEdgeDivergence(this.m_elemset, this.m_vecindex.getValue() - 1, null);
                break;
            }
            case 5: {
                this.m_scalarField = PwRotDiv.scalarFromVertexToElementBased(this.m_elemset, PwRotDiv.getVertexDivergence(this.m_elemset, this.m_vecindex.getValue() - 1, null, true, false));
                break;
            }
            case 7: {
                this.m_scalarField = PwRotDiv.getEdgeDivergence(this.m_elemset, this.m_vecindex.getValue() - 1, null, true, false);
                break;
            }
            case 8: {
                this.m_scalarField = PwRotDiv.scalarFromVertexToElementBased(this.m_elemset, PwRotDiv.getVertexRotation(this.m_elemset, this.m_vecindex.getValue() - 1, null, false, true));
                break;
            }
            case 9: {
                this.m_scalarField = PwRotDiv.scalarFromVertexToElementBased(this.m_elemset, PwRotDiv.getVertexDivergence(this.m_elemset, this.m_vecindex.getValue() - 1, null, false, true));
                break;
            }
            default: {
                PsDebug.warning((String)("wrong 'fieldType'=" + n + ". Use constants from PwRotDiv."));
                return;
            }
        }
        this.m_fieldType = n;
        this.update((Object)this);
    }
}

