/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwBary;
import jvx.geom.PwExplode;
import jvx.project.PjWorkshop;

public class PwShooter
extends PjWorkshop
implements Runnable {
    protected int m_numGames = 0;
    protected int m_shots = 0;
    protected int m_peeks = 0;
    protected PgElementSet m_elemSet = null;
    protected double m_transparency = 0.0;
    protected boolean m_transparent = false;
    protected PgPointSet m_start = null;
    protected boolean m_startInDisplay = false;
    protected int m_startElem = 0;
    protected PdBary m_startBary = null;
    protected PgElementSet m_sphere = null;
    protected boolean m_sphereInDisplay = false;
    protected int m_sphereElem = 0;
    protected PdBary m_sphereBary = null;
    protected double m_sphereRadius = 0.05;
    protected int m_sphereDiscr = 8;
    protected PwExplode m_expl;
    protected PdBaryDir m_dir = null;
    protected PgVectorField m_vf;
    protected PuInteger m_angle = new PuInteger("", (PsUpdateIf)this);
    protected PuDouble m_dist = new PuDouble("", null);
    private static /* synthetic */ Class class$jvx$geom$PwShooter;

    private void removeFromDisplay() {
        if (this.m_start != null && this.m_display != null && this.m_startInDisplay) {
            this.m_display.removeGeometry((PgGeometryIf)this.m_start);
            this.m_startInDisplay = false;
        }
        if (this.m_sphere != null && this.m_display != null && this.m_sphereInDisplay) {
            this.m_display.removeGeometry((PgGeometryIf)this.m_sphere);
            this.m_sphereInDisplay = false;
        }
    }

    public void setDisplay(PvDisplayIf pvDisplayIf) {
        this.removeFromDisplay();
        super.setDisplay(pvDisplayIf);
        if (pvDisplayIf == null) {
            PsDebug.warning((String)"missing display");
            return;
        }
        this.addToDisplay();
    }

    public void reset() {
        this.m_numGames = -1;
        this.m_shots = 0;
        this.m_peeks = 0;
        this.startGame();
    }

    public PwShooter() {
        super(PsConfig.getMessage((int)51069));
        if (this.getClass() == (class$jvx$geom$PwShooter != null ? class$jvx$geom$PwShooter : (class$jvx$geom$PwShooter = PwShooter.class$("jvx.geom.PwShooter")))) {
            this.init();
        }
    }

    public boolean update(Object object) {
        if (object == this.m_angle) {
            this.computeVector();
            if (this.m_elemSet != null) {
                this.m_vf.update(null);
                this.m_elemSet.update(null);
            }
            return super.update(null);
        }
        return super.update(object);
    }

    public void setGeometry(PgGeometry pgGeometry) {
        if (pgGeometry == null) {
            return;
        }
        if (!(pgGeometry instanceof PgElementSet)) {
            PsDebug.warning((String)"geometry is no element set - aborting");
            return;
        }
        this.m_elemSet = (PgElementSet)pgGeometry;
        if (this.m_elemSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"geometry is not triangulated - aborting");
            return;
        }
        super.setGeometry(pgGeometry);
        this.m_transparency = this.m_elemSet.getTransparency();
        this.m_transparent = this.m_elemSet.isShowingTransparency();
        this.m_elemSet.setTransparency(0.4);
        this.m_elemSet.showTransparency(true);
        this.m_elemSet.update(null);
        this.removeFromDisplay();
        int n = this.m_elemSet.getDimOfVertices();
        this.m_start = new PgPointSet(n);
        this.m_start.setName(PsConfig.getMessage((int)45045));
        this.m_start.setNumVertices(1);
        this.m_start.setGlobalVertexSize(3.0);
        this.m_start.showVectorArrows(true);
        this.m_vf = new PgVectorField(n);
        this.m_vf.setGeometry(this.m_start);
        this.m_start.addVectorField(this.m_vf);
        this.m_vf.update((Object)this.m_vf);
        this.m_sphere = new PgElementSet(n);
        this.m_sphere.setName(PsConfig.getMessage((int)45046));
        this.addToDisplay();
        this.reset();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void startGame() {
        if (this.m_geom == null) {
            return;
        }
        ++this.m_numGames;
        PdVector[] pdVectorArray = this.m_elemSet.getVertices();
        int n = this.m_elemSet.getNumElements();
        this.m_startElem = (int)(Math.random() * (double)n);
        this.m_startBary = this.randomBary();
        PiVector piVector = this.m_elemSet.getElement(this.m_startElem);
        PdVector pdVector = new PdVector(this.m_elemSet.getDimOfVertices());
        PdBary.getVertex((PdVector)pdVector, (PdBary)this.m_startBary, (PdVector)pdVectorArray[piVector.m_data[0]], (PdVector)pdVectorArray[piVector.m_data[1]], (PdVector)pdVectorArray[piVector.m_data[2]]);
        this.m_start.setVertex(0, pdVector);
        this.m_dir = new PdBaryDir(3);
        this.m_sphereElem = (int)(Math.random() * (double)n);
        this.m_sphereBary = this.randomBary();
        piVector = this.m_elemSet.getElement(this.m_sphereElem);
        PdBary.getVertex((PdVector)pdVector, (PdBary)this.m_sphereBary, (PdVector)pdVectorArray[piVector.m_data[0]], (PdVector)pdVectorArray[piVector.m_data[1]], (PdVector)pdVectorArray[piVector.m_data[2]]);
        this.m_sphere.computeSphere(this.m_sphereDiscr, this.m_sphereDiscr, this.m_sphereRadius);
        this.m_sphere.translate(pdVector);
        this.m_sphere.update(null);
        this.update(this.m_angle);
        this.update(this);
    }

    private void addToDisplay() {
        if (this.m_start != null && this.m_display != null && !this.m_startInDisplay) {
            this.m_display.addGeometry((PgGeometryIf)this.m_start);
            this.m_startInDisplay = true;
        }
        if (this.m_sphere != null && this.m_display != null && !this.m_sphereInDisplay) {
            this.m_display.addGeometry((PgGeometryIf)this.m_sphere);
            this.m_sphereInDisplay = true;
        }
    }

    public void run() {
        this.m_expl.getAnimation().start();
        try {
            do {
                Thread.sleep(1000L);
            } while (this.m_expl.getAnimation().isRunning());
        }
        catch (InterruptedException interruptedException) {}
        this.startGame();
    }

    public void init() {
        super.init();
        this.m_angle.setName(PsConfig.getMessage((int)54179));
        this.m_dist.setName(PsConfig.getMessage((int)54054));
        this.m_angle.setDefBounds(0, 360, 1, 5);
        this.m_angle.setDefValue(0);
        this.m_angle.init();
        this.m_dist.setDefBounds(0.0, 1000.0, 0.5, 10.0);
        this.m_dist.setDefValue(1.0);
        this.m_dist.init();
    }

    public void removeGeometry() {
        this.removeFromDisplay();
        if (this.m_elemSet != null) {
            this.m_elemSet.setTransparency(this.m_transparency);
            this.m_elemSet.showTransparency(this.m_transparent);
            this.m_elemSet.update(null);
        }
        this.m_elemSet = null;
        super.removeGeometry();
    }

    private PdBary randomBary() {
        PdBary pdBary = new PdBary(3);
        double d = Math.random();
        pdBary.setEntry(0, d);
        double d2 = Math.random();
        pdBary.setEntry(1, d2 * (1.0 - d));
        pdBary.setEntry(2, (1.0 - d2) * (1.0 - d));
        pdBary.validate();
        return pdBary;
    }

    private void computeVector() {
        if (this.m_elemSet == null) {
            return;
        }
        this.m_dir.m_data[0] = 1.0;
        this.m_dir.m_data[1] = -1.0;
        this.m_dir.m_data[2] = 0.0;
        PwBary.rotateInElement(this.m_elemSet, this.m_startElem, this.m_dir, (double)this.m_angle.getValue() / 180.0 * Math.PI, this.m_dir, true);
        PdVector pdVector = new PdVector(this.m_elemSet.getDimOfVertices());
        PdVector[] pdVectorArray = this.m_elemSet.getVertices();
        PiVector piVector = this.m_elemSet.getElement(this.m_startElem);
        double d = PwBary.norm(this.m_elemSet, this.m_startElem, this.m_dir, true);
        if (d > 0.0) {
            this.m_dir.multScalar(1.0 / d);
        }
        PdBaryDir.getVector((PdVector)pdVector, (PdBaryDir)this.m_dir, (PdVector)pdVectorArray[piVector.m_data[0]], (PdVector)pdVectorArray[piVector.m_data[1]], (PdVector)pdVectorArray[piVector.m_data[2]]);
        this.m_vf.setVector(0, pdVector);
    }

    protected void endGame() {
        this.m_expl = new PwExplode();
        this.m_expl.setGeometry((PgGeometry)this.m_sphere);
        this.m_expl.setDisplay(this.getDisplay());
        this.m_expl.setGravity(0.0);
        double d = this.m_elemSet.getDiameter();
        this.m_expl.setRotationSpeed(0.5);
        this.m_expl.setSpeed(0.1 * d);
        this.m_expl.runOnce(false);
        this.m_expl.reset();
        this.m_expl.getAnimation().setRepeat(0);
        Thread thread = new Thread(this);
        thread.start();
    }
}

