/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Random;
import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PuCleanMesh;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvCameraIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuReflect;
import jv.viewer.PvCamera;
import jvx.geom.PuPriorityQueue;
import jvx.geom.PwCleanMesh;
import jvx.geom.PwModel;
import jvx.numeric.PnMatrix;
import jvx.project.PjWorkshop;

public class PwUnfold
extends PjWorkshop
implements PsTimeListenerIf,
Runnable,
PvPickListenerIf {
    protected PgElementSet m_geom;
    protected PgElementSet m_geomSave;
    protected int[] m_linTree;
    protected int[] m_linTreeParent;
    protected boolean m_showSplice;
    protected boolean m_isFlat;
    protected PgElementSet m_splice;
    protected boolean m_isUnfold;
    protected int m_numOfParts = 0;
    protected PsAnimation m_anim = new PsAnimation();
    protected int[][] m_vertOfPolygons;
    protected double[][] m_translatePolygons;
    protected double[][] m_BBoxdata;
    protected boolean m_update;
    protected boolean m_bAutoFit;
    protected double[] m_diamBB;
    protected boolean m_bPickFixElem;
    protected boolean m_bFixElem;
    protected int m_fixedElement = -1;
    protected static final double SPLICES_FIRST = 0.125;
    protected static final double SPLICES_SECOND = 0.325;
    protected int m_weight;
    public static final int WEIGHT_EDGELENGTH = 0;
    public static final int WEIGHT_ELEMENTINDEX = 0;
    private PdMatrix m_eq;
    private PdVector m_tri;
    private PdVector m_oriTri;
    private PdMatrix m_trafo;
    private PdVector m_trans;
    private PdVector m_helpEdge1;
    private PdVector m_helpEdge2;
    protected boolean m_bAnimIsRunning;
    protected boolean m_isImproving = false;
    private boolean noOverlaps = false;
    protected boolean m_bStopImproving = false;
    protected boolean m_bquickImprove = false;
    protected boolean m_bUpdateWhileImprove = true;
    private boolean m_bNoImprove = false;
    protected int[] m_elemTreeTable;
    protected Thread m_thread;
    protected boolean m_bRunning = false;
    protected boolean m_bStopped = true;
    private static /* synthetic */ Class class$jvx$geom$PwUnfold;

    public void refold() {
        this.flatten(0.0);
    }

    public boolean setTime(PsTimeEvent psTimeEvent) {
        if (this.m_isImproving) {
            return true;
        }
        this.m_bAnimIsRunning = true;
        double d = psTimeEvent.getTime();
        this.timestep(d);
        this.m_bAnimIsRunning = false;
        return true;
    }

    public PsAnimation getAnimation() {
        return this.m_anim;
    }

    public void setAnimation(PsAnimation psAnimation) {
        this.m_anim = psAnimation;
    }

    protected void stopAnimation() {
        if (this.m_anim != null && this.m_anim.isRunning()) {
            this.m_anim.stop();
            int n = -10000;
            while (this.m_bAnimIsRunning && n < 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
                n += 100;
            }
            if (n == 0) {
                PsDebug.warning((String)"animation has not been stopped properly.");
            }
        }
    }

    public void dragVertex(PgGeometryIf pgGeometryIf, int n, PdVector pdVector) {
    }

    public void setWeight(int n) {
        this.m_weight = n;
    }

    public int getWeight() {
        return this.m_weight;
    }

    public void unmarkVertices(PvPickEvent pvPickEvent) {
    }

    protected void timestep(double d) {
        this.flatten((d - this.m_anim.getMinTime()) / (this.m_anim.getMaxTime() - this.m_anim.getMinTime()));
        this.showSplices();
        if (this.m_bAutoFit && this.m_display != null) {
            PvCameraIf pvCameraIf = this.m_display.getCamera();
            if (pvCameraIf instanceof PvCamera) {
                PvCamera pvCamera = (PvCamera)pvCameraIf;
                double d2 = (d - this.m_anim.getMinTime()) / (this.m_anim.getMaxTime() - this.m_anim.getMinTime());
                pvCamera.fit((1.0 - d2) * this.m_diamBB[0] + d2 * this.m_diamBB[1]);
            } else {
                this.m_display.fit();
            }
        }
        this.update(this);
    }

    public boolean isRunning() {
        return this.m_bRunning;
    }

    public void cancel() {
        if (this.m_display != null) {
            this.m_display.removePickListener((PvPickListenerIf)this);
        }
        this.stopAnimation();
        this.removeSplice();
        super.cancel();
    }

    protected void setVertexPos() {
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray2 = this.m_geomSave.getVertices();
        PiVector[] piVectorArray2 = this.m_geomSave.getElements();
        int n = this.m_geom.getNumElements();
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < piVectorArray[n2].getSize()) {
                int n4 = 0;
                do {
                    pdVectorArray[piVectorArray[n2].m_data[n3]].m_data[n4] = pdVectorArray2[piVectorArray2[n2].m_data[n3]].m_data[n4];
                } while (++n4 < 3);
                ++n3;
            }
            ++n2;
        }
        this.m_geom.makeNeighbour();
    }

    public void markVertices(PvPickEvent pvPickEvent) {
    }

    public void setDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_display != null) {
            this.m_display.removePickListener((PvPickListenerIf)this);
        }
        if (pvDisplayIf != null) {
            super.setDisplay(pvDisplayIf);
            this.m_display.addPickListener((PvPickListenerIf)this);
        }
    }

    public void selectGeometry(PgGeometryIf pgGeometryIf) {
    }

    public void setGeometry(PgElementSet pgElementSet) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Cannot compute unfolding of geometry, given geometry is null");
            return;
        }
        if (pgElementSet.getDimOfVertices() != 3) {
            PsDebug.warning((String)("Cannot compute unfolding of geometry, dimension of vertices is " + pgElementSet.getDimOfVertices() + ". " + "Vertices must have dimension 3."));
            return;
        }
        if (!pgElementSet.makeNeighbour()) {
            PsDebug.warning((String)("Cannot unfold this geometry: " + pgElementSet.getName() + "." + " Problems computing the neighbour information."));
            return;
        }
        this.stopAnimation();
        this.m_anim.removeTimeListener((PsTimeListenerIf)this);
        this.m_anim.setTime(this.m_anim.getMinTime());
        this.m_anim.addTimeListener((PsTimeListenerIf)this);
        this.removeSplice();
        this.m_splice = null;
        ((PjWorkshop)this).m_geomSave = null;
        super.setGeometry((PgGeometry)pgElementSet);
        this.m_geom = pgElementSet;
        boolean bl = false;
        if (!PwCleanMesh.hasPlanarElements(this.m_geom, 0.01)) {
            PgElementSet.triangulate((PgElementSet)this.m_geom);
            bl = true;
        }
        if (PwCleanMesh.isDegenerated(this.m_geom)) {
            PuCleanMesh.identifyVertices((PgPointSet)this.m_geom, (double)1.0E-10);
            PuCleanMesh.removeDegenerateElements((PgElementSet)this.m_geom);
            bl = true;
        }
        if (((PjWorkshop)this).m_geomSave == null) {
            bl = true;
        }
        this.m_geomSave = bl ? (PgElementSet)this.m_geom.clone() : (PgElementSet)((PjWorkshop)this).m_geomSave;
        int n = this.m_geom.getNumElements();
        this.m_linTree = new int[n];
        this.m_linTreeParent = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.m_linTreeParent[n2] = -1;
            ++n2;
        }
        this.m_isFlat = false;
        this.m_isUnfold = false;
        PdVector[] pdVectorArray = this.m_geom.getBounds();
        this.m_diamBB[0] = PdVector.dist((PdVector)pdVectorArray[0], (PdVector)pdVectorArray[1]);
    }

    public void fitGeometry(boolean bl) {
        this.m_bAutoFit = bl;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean hasAnimation() {
        return this.m_anim == null;
    }

    public void run() {
        this.improveUnfolding();
        this.m_bRunning = false;
        this.m_bStopImproving = false;
        this.m_bStopped = true;
        if (this.m_anim.getTime() != this.m_anim.getMaxTime()) {
            this.m_anim.setTime(this.m_anim.getMaxTime());
        } else {
            this.showSplices();
        }
        this.update(this);
    }

    public void init() {
        super.init();
        if (this.m_splice != null) {
            this.removeSplice();
        }
        this.m_showSplice = false;
        this.m_isFlat = false;
        this.m_splice = null;
        this.m_isUnfold = false;
        this.m_bAutoFit = false;
        this.m_bPickFixElem = false;
        this.m_bFixElem = false;
        this.m_weight = 0;
        this.m_update = false;
        this.m_bAnimIsRunning = false;
        this.m_helpEdge1 = new PdVector(3);
        this.m_helpEdge2 = new PdVector(3);
        this.stopAnimation();
    }

    public void setEnabledFixingElement(boolean bl) {
        this.m_bFixElem = bl;
        this.m_bPickFixElem = bl;
    }

    protected void getSubComponent(int n, int n2, int[] nArray) {
        if (n < 0 || n >= this.m_geom.getNumElements()) {
            PsDebug.warning((String)("Cannot compute component " + n + " is not an index of an element."));
            return;
        }
        if (n2 < 0 || n2 >= this.m_geom.getNumElements()) {
            PsDebug.warning((String)("Cannot compute subcomponent. " + n + " is not an index of an element."));
            return;
        }
        PiVector[] piVectorArray = this.m_geom.getNeighbours();
        int n3 = piVectorArray[n].getSize();
        int n4 = -1;
        int n5 = 0;
        while (n5 < n3) {
            if (piVectorArray[n].m_data[n5] == n2) {
                n4 = n5;
                break;
            }
            ++n5;
        }
        if (n4 == -1) {
            PsDebug.warning((String)("Cannot compute subcomponent. Elements " + n + " and " + n2 + " are not neighbours."));
            return;
        }
        if (this.m_linTreeParent[n] != -1 && piVectorArray[n].m_data[this.m_linTreeParent[n]] == n2) {
            nArray[0] = n;
            nArray[1] = nArray[0];
            n4 = -1;
            n5 = (this.m_linTreeParent[nArray[1]] - 1 + n3) % n3;
            while (n5 != this.m_linTreeParent[nArray[1]]) {
                if (piVectorArray[nArray[1]].m_data[n5] > -1) {
                    n4 = n5;
                    break;
                }
                n5 = (n5 - 1 + n3) % n3;
            }
            block2: while (n4 != -1) {
                nArray[1] = piVectorArray[nArray[1]].m_data[n4];
                n3 = piVectorArray[nArray[1]].getSize();
                n4 = -1;
                n5 = (this.m_linTreeParent[nArray[1]] - 1 + n3) % n3;
                while (n5 != this.m_linTreeParent[nArray[1]]) {
                    if (piVectorArray[nArray[1]].m_data[n5] != -1) {
                        n4 = n5;
                        continue block2;
                    }
                    n5 = (n5 - 1 + n3) % n3;
                }
            }
            nArray[2] = -1;
            nArray[3] = -1;
            return;
        }
        nArray[0] = n;
        while (this.m_linTreeParent[nArray[0]] > -1) {
            nArray[0] = piVectorArray[nArray[0]].m_data[this.m_linTreeParent[nArray[0]]];
        }
        n4 = -1;
        n3 = piVectorArray[n].getSize();
        int n6 = this.m_geom.getOppVertexLocInd(n2, this.m_linTreeParent[n2]);
        int n7 = this.m_linTreeParent[n] != -1 ? this.m_linTreeParent[n] : n3 - 1;
        n5 = (n6 - 1 + n3) % n3;
        while (n5 != n7) {
            if (piVectorArray[n].m_data[n5] != -1) {
                n4 = n5;
                break;
            }
            n5 = (n5 - 1 + n3) % n3;
        }
        nArray[1] = n;
        block6: while (n4 != -1) {
            nArray[1] = piVectorArray[nArray[1]].m_data[n4];
            n3 = piVectorArray[nArray[1]].getSize();
            n4 = -1;
            n5 = (this.m_linTreeParent[nArray[1]] - 1 + n3) % n3;
            while (n5 != this.m_linTreeParent[nArray[1]]) {
                if (piVectorArray[nArray[1]].m_data[n5] != -1) {
                    n4 = n5;
                    continue block6;
                }
                n5 = (n5 - 1 + n3) % n3;
            }
        }
        n4 = -1;
        n6 = this.m_geom.getOppVertexLocInd(n2, this.m_linTreeParent[n2]);
        nArray[2] = n;
        while (true) {
            n3 = piVectorArray[nArray[2]].getSize();
            n7 = this.m_linTreeParent[nArray[2]] != -1 ? this.m_linTreeParent[nArray[2]] : 0;
            n5 = (n6 + 1) % n3;
            while (n5 != n7) {
                if (piVectorArray[nArray[2]].m_data[n5] != -1) {
                    n4 = n5;
                    break;
                }
                n5 = (n5 + 1) % n3;
            }
            if (n4 != -1) {
                nArray[2] = piVectorArray[nArray[2]].m_data[n4];
                break;
            }
            if (this.m_linTreeParent[nArray[2]] == -1) {
                nArray[2] = -1;
                break;
            }
            n6 = this.m_geom.getOppVertexLocInd(nArray[2], this.m_linTreeParent[nArray[2]]);
            nArray[2] = piVectorArray[nArray[2]].m_data[this.m_linTreeParent[nArray[2]]];
        }
        if (nArray[2] != -1) {
            nArray[3] = nArray[0];
            n3 = piVectorArray[nArray[3]].getSize();
            n4 = -1;
            n5 = n3 - 1;
            while (n5 >= 0) {
                if (piVectorArray[nArray[3]].m_data[n5] > -1) {
                    n4 = n5;
                    break;
                }
                --n5;
            }
            block11: while (n4 != -1) {
                nArray[3] = piVectorArray[nArray[3]].m_data[n4];
                n3 = piVectorArray[nArray[3]].getSize();
                n4 = -1;
                n5 = (this.m_linTreeParent[nArray[3]] - 1 + n3) % n3;
                while (n5 != this.m_linTreeParent[nArray[3]]) {
                    if (piVectorArray[nArray[3]].m_data[n5] != -1) {
                        n4 = n5;
                        continue block11;
                    }
                    n5 = (n5 - 1 + n3) % n3;
                }
            }
            return;
        }
        nArray[3] = -1;
    }

    protected void moveComponent(int n, int n2, int n3, int n4) {
        PdMatrix pdMatrix = this.computeTrafo(n, n2);
        int n5 = this.m_geom.getNumElements();
        int[] nArray = new int[n5];
        int n6 = 0;
        while (n6 < n5) {
            nArray[this.m_linTree[n6]] = n6;
            ++n6;
        }
        this.moveComponent(n, n2, n3, n4, pdMatrix, nArray);
    }

    protected void moveComponent(int n, int n2, int n3, int n4, PdMatrix pdMatrix, int[] nArray) {
        int n5;
        int n6;
        int n7;
        int n8;
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PgElementSet pgElementSet = this.m_geomSave;
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        int[] nArray2 = new int[4];
        this.getSubComponent(n3, piVectorArray2[n3].m_data[n4], nArray2);
        int n9 = piVectorArray2[n].m_data[n2];
        int n10 = pgElementSet.getOppVertexLocInd(n, n2);
        int n11 = piVectorArray[n9].getSize();
        int n12 = piVectorArray[n].getSize();
        int n13 = piVectorArray[n].m_data[(n2 + 1) % n12];
        int n14 = piVectorArray[n].m_data[(n2 + 2) % n12];
        if (pgElementSet.getElement((int)n).m_data[(n2 + 1) % n12] == pgElementSet.getElement((int)n9).m_data[(n10 + 1) % n11]) {
            n8 = piVectorArray[n9].m_data[(n10 + 1) % n11];
            n7 = piVectorArray[n9].m_data[(n10 + 2) % n11];
        } else {
            n8 = piVectorArray[n9].m_data[(n10 + 2) % n11];
            n7 = piVectorArray[n9].m_data[(n10 + 1) % n11];
        }
        n12 = piVectorArray[n3].getSize();
        int n15 = piVectorArray[n3].m_data[(n4 + 1) % n12];
        int n16 = piVectorArray[n3].m_data[(n4 + 2) % n12];
        int n17 = nArray[nArray2[0]];
        while (n17 <= nArray[nArray2[1]]) {
            n6 = this.m_linTree[n17];
            n12 = piVectorArray[n6].getSize();
            n5 = 0;
            while (n5 < n12) {
                if (piVectorArray[n6].m_data[n5] == n13) {
                    piVectorArray[n6].m_data[n5] = n8;
                }
                if (piVectorArray[n6].m_data[n5] == n14) {
                    piVectorArray[n6].m_data[n5] = n7;
                }
                ++n5;
            }
            ++n17;
        }
        if (nArray2[2] != -1 && nArray2[3] != -1) {
            n17 = nArray[nArray2[2]];
            while (n17 <= nArray[nArray2[3]]) {
                n6 = this.m_linTree[n17];
                n12 = piVectorArray[n6].getSize();
                n5 = 0;
                while (n5 < n12) {
                    if (piVectorArray[n6].m_data[n5] == n13) {
                        piVectorArray[n6].m_data[n5] = n8;
                    }
                    if (piVectorArray[n6].m_data[n5] == n14) {
                        piVectorArray[n6].m_data[n5] = n7;
                    }
                    ++n5;
                }
                ++n17;
            }
        }
        if (n13 == n16 || n14 == n15) {
            n17 = n15;
            n15 = n16;
            n16 = n17;
        }
        n17 = 0;
        while (n17 < this.m_geom.getDimOfVertices()) {
            pdVectorArray[n13].m_data[n17] = pdVectorArray[n15].m_data[n17];
            pdVectorArray[n14].m_data[n17] = pdVectorArray[n16].m_data[n17];
            ++n17;
        }
        n17 = nArray[nArray2[0]];
        while (n17 <= nArray[nArray2[1]]) {
            n6 = this.m_linTree[n17];
            n12 = piVectorArray[n6].getSize();
            n5 = 0;
            while (n5 < n12) {
                if (piVectorArray[n6].m_data[n5] == n15) {
                    piVectorArray[n6].m_data[n5] = n13;
                }
                if (piVectorArray[n6].m_data[n5] == n16) {
                    piVectorArray[n6].m_data[n5] = n14;
                }
                ++n5;
            }
            ++n17;
        }
        if (nArray2[2] != -1 && nArray2[3] != -1) {
            n17 = nArray[nArray2[2]];
            while (n17 <= nArray[nArray2[3]]) {
                n6 = this.m_linTree[n17];
                n12 = piVectorArray[n6].getSize();
                n5 = 0;
                while (n5 < n12) {
                    if (piVectorArray[n6].m_data[n5] == n15) {
                        piVectorArray[n6].m_data[n5] = n13;
                    }
                    if (piVectorArray[n6].m_data[n5] == n16) {
                        piVectorArray[n6].m_data[n5] = n14;
                    }
                    ++n5;
                }
                ++n17;
            }
        }
        PiVector[] piVectorArray3 = this.m_geom.getNeighbours();
        piVectorArray3[n].m_data[n2] = piVectorArray2[n].m_data[n2];
        n17 = piVectorArray2[n].m_data[n2];
        n5 = pgElementSet.getOppVertexLocInd(n, n2);
        piVectorArray3[n17].m_data[n5] = piVectorArray2[n17].m_data[n5];
        piVectorArray3[n3].m_data[n4] = -1;
        n17 = piVectorArray2[n3].m_data[n4];
        n5 = pgElementSet.getOppVertexLocInd(n3, n4);
        piVectorArray3[n17].m_data[n5] = -1;
        int n18 = n;
        int n19 = this.m_linTreeParent[n];
        int n20 = -1;
        if (n19 != -1) {
            n6 = piVectorArray3[n].m_data[n19];
            while (n6 != -1 && this.m_linTreeParent[n6] != -1) {
                n20 = this.m_linTreeParent[n6];
                this.m_linTreeParent[n6] = this.m_geom.getOppVertexLocInd(n18, n19);
                n18 = n6;
                n6 = piVectorArray3[n6].m_data[n20];
                n19 = n20;
            }
            if (n6 != -1) {
                this.m_linTreeParent[n6] = this.m_geom.getOppVertexLocInd(n18, n19);
            }
        }
        if (this.m_linTreeParent[n17 = piVectorArray2[n3].m_data[n4]] == (n5 = pgElementSet.getOppVertexLocInd(n3, n4))) {
            this.m_linTreeParent[n17] = -1;
        }
        this.m_linTreeParent[n] = n2;
        PdVector pdVector = new PdVector(this.m_geom.getDimOfVertices());
        n17 = nArray[nArray2[0]];
        while (n17 <= nArray[nArray2[1]]) {
            n6 = this.m_linTree[n17];
            n12 = piVectorArray[n6].getSize();
            n5 = (this.m_linTreeParent[n6] + 3) % n12;
            while (n5 != (this.m_linTreeParent[n6] + 1) % n12) {
                if (piVectorArray[n6].m_data[n5] != n8 && piVectorArray[n6].m_data[n5] != n7) {
                    pdVector.copy(pdVectorArray[piVectorArray[n6].m_data[n5]]);
                    this.transform(pdMatrix, pdVector, pdVectorArray[piVectorArray[n6].m_data[n5]]);
                }
                n5 = (n5 + 1) % n12;
            }
            ++n17;
        }
        if (nArray2[2] != -1 && nArray2[3] != -1) {
            n17 = nArray[nArray2[2]];
            while (n17 <= nArray[nArray2[3]]) {
                n6 = this.m_linTree[n17];
                n12 = piVectorArray[n6].getSize();
                n5 = (this.m_linTreeParent[n6] + 3) % n12;
                while (n5 != (this.m_linTreeParent[n6] + 1) % n12) {
                    if (piVectorArray[n6].m_data[n5] != n8 && piVectorArray[n6].m_data[n5] != n7) {
                        pdVector.copy(pdVectorArray[piVectorArray[n6].m_data[n5]]);
                        this.transform(pdMatrix, pdVector, pdVectorArray[piVectorArray[n6].m_data[n5]]);
                    }
                    n5 = (n5 + 1) % n12;
                }
                ++n17;
            }
        }
    }

    protected void moveTree(int n, int n2) {
        PiVector piVector = this.m_geomSave.getNeighbour(n);
        int n3 = piVector.getSize();
        int n4 = 0;
        while (n4 < n3) {
            if (piVector.m_data[n4] == n2) break;
            ++n4;
        }
        if (n4 == n3) {
            PsDebug.warning((String)"Cannot move tree.");
            return;
        }
        PdMatrix pdMatrix = this.computeTrafo(n, n4);
        this.moveTree(n, n4, pdMatrix);
    }

    protected void moveTree(int n, int n2, PdMatrix pdMatrix) {
        int n3;
        int n4;
        int n5;
        if (pdMatrix == null || pdMatrix.getISize() < 2 || pdMatrix.getJSize() < 3) {
            PsDebug.warning((String)"Cannot move tree. Missing transformation matrix.");
            return;
        }
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PiVector[] piVectorArray2 = this.m_geom.getNeighbours();
        int n6 = 0;
        int n7 = n;
        while (this.m_linTreeParent[n7] != -1) {
            n7 = piVectorArray2[n7].m_data[this.m_linTreeParent[n7]];
        }
        while (this.m_linTree[n6] != n7) {
            ++n6;
        }
        int n8 = n6 + 1;
        int n9 = this.m_geom.getNumElements();
        while (n8 < n9 && this.m_linTreeParent[this.m_linTree[n8]] != -1) {
            ++n8;
        }
        if (n8 != n6) {
            --n8;
        }
        PiVector[] piVectorArray3 = this.m_geomSave.getNeighbours();
        piVectorArray2[n].m_data[n2] = piVectorArray3[n].m_data[n2];
        n7 = piVectorArray3[n].m_data[n2];
        int n10 = this.m_geomSave.getOppVertexLocInd(n, n2);
        piVectorArray2[n7].m_data[n10] = piVectorArray3[n7].m_data[n10];
        int n11 = n;
        int n12 = this.m_linTreeParent[n];
        int n13 = -1;
        if (n12 != -1) {
            n5 = piVectorArray2[n].m_data[n12];
            while (n5 != -1 && this.m_linTreeParent[n5] != -1) {
                n13 = this.m_linTreeParent[n5];
                this.m_linTreeParent[n5] = this.m_geom.getOppVertexLocInd(n11, n12);
                n11 = n5;
                n5 = piVectorArray2[n5].m_data[n13];
                n12 = n13;
            }
            if (n5 != -1) {
                this.m_linTreeParent[n5] = this.m_geom.getOppVertexLocInd(n11, n12);
            }
        }
        this.m_linTreeParent[n] = n2;
        int n14 = piVectorArray3[n].m_data[n2];
        int n15 = this.m_geomSave.getOppVertexLocInd(n, n2);
        int n16 = piVectorArray[n].getSize();
        int n17 = piVectorArray[n14].getSize();
        int n18 = piVectorArray[n].m_data[(n2 + 1) % n16];
        int n19 = piVectorArray[n].m_data[(n2 + 2) % n16];
        if (this.m_geomSave.getElement((int)n).m_data[(n2 + 1) % n16] == this.m_geomSave.getElement((int)n14).m_data[(n15 + 1) % piVectorArray3[n14].getSize()]) {
            n4 = piVectorArray[n14].m_data[(n15 + 1) % n17];
            n3 = piVectorArray[n14].m_data[(n15 + 2) % n17];
        } else {
            n4 = piVectorArray[n14].m_data[(n15 + 2) % n17];
            n3 = piVectorArray[n14].m_data[(n15 + 1) % n17];
        }
        n7 = n6;
        while (n7 <= n8) {
            n16 = piVectorArray[this.m_linTree[n7]].getSize();
            n10 = 0;
            while (n10 < n16) {
                if (piVectorArray[this.m_linTree[n7]].m_data[n10] == n18) {
                    piVectorArray[this.m_linTree[n7]].m_data[n10] = n4;
                }
                if (piVectorArray[this.m_linTree[n7]].m_data[n10] == n19) {
                    piVectorArray[this.m_linTree[n7]].m_data[n10] = n3;
                }
                ++n10;
            }
            ++n7;
        }
        PdVector pdVector = new PdVector(this.m_geom.getDimOfVertices());
        n7 = n6;
        while (n7 <= n8) {
            n5 = this.m_linTree[n7];
            n16 = piVectorArray[n5].getSize();
            n10 = (this.m_linTreeParent[n5] + 3) % n16;
            while (n10 != (this.m_linTreeParent[n5] + 1) % n16) {
                if (piVectorArray[n5].m_data[n10] != n4 && piVectorArray[n5].m_data[n10] != n3) {
                    pdVector.copy(pdVectorArray[piVectorArray[n5].m_data[n10]]);
                    this.transform(pdMatrix, pdVector, pdVectorArray[piVectorArray[n5].m_data[n10]]);
                }
                n10 = (n10 + 1) % n16;
            }
            ++n7;
        }
    }

    public void pickVertex(PgGeometryIf pgGeometryIf, int n, PdVector pdVector) {
    }

    public void stop() {
        if (this.m_bRunning) {
            this.m_bStopImproving = true;
            this.m_thread = null;
        }
    }

    protected void rebuildLinTreeDepthFirst() {
        PiVector[] piVectorArray = this.m_geom.getNeighbours();
        int n = this.m_geom.getNumElements();
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            if (this.m_linTreeParent[n2] != -1) {
                ++n2;
                continue;
            }
            this.m_linTree[n3] = n2;
            ++n3;
            int n4 = piVectorArray[n2].getSize();
            int n5 = 0;
            while (n5 < n4) {
                if (piVectorArray[n2].m_data[n5] != -1) break;
                ++n5;
            }
            if (n5 == n4) {
                ++n2;
                continue;
            }
            int n6 = piVectorArray[n2].m_data[n5];
            n4 = piVectorArray[n6].getSize();
            int n7 = (this.m_geom.getOppVertexLocInd(n2, n5) + 1) % n4;
            this.m_linTree[n3] = n6;
            ++n3;
            while (n6 != n2 || n7 != n5) {
                int n8;
                if (n7 == this.m_linTreeParent[n6]) {
                    n8 = n6;
                    n6 = piVectorArray[n6].m_data[n7];
                    n4 = piVectorArray[n6].getSize();
                    n7 = (this.m_geom.getOppVertexLocInd(n8, n7) + 1) % n4;
                    continue;
                }
                if (piVectorArray[n6].m_data[n7] == -1) {
                    n7 = (n7 + 1) % n4;
                    continue;
                }
                n8 = n6;
                n6 = piVectorArray[n6].m_data[n7];
                n4 = piVectorArray[n6].getSize();
                n7 = (this.m_geom.getOppVertexLocInd(n8, n7) + 1) % n4;
                this.m_linTree[n3] = n6;
                ++n3;
            }
            ++n2;
        }
    }

    public boolean isEnabledFixingElement() {
        return this.m_bFixElem;
    }

    protected int computeCenterElement() {
        PdVector pdVector = this.m_geom.getCenterOfGravity();
        int n = this.m_geom.getNumElements();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PdVector pdVector2 = new PdVector(3);
        double d = Double.POSITIVE_INFINITY;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int[] nArray = piVectorArray[n3].m_data;
            pdVector2.copyArray(pdVectorArray[nArray[0]]);
            int n4 = 1;
            while (n4 < nArray.length) {
                pdVector2.add(pdVectorArray[nArray[n4]]);
                ++n4;
            }
            pdVector2.multScalar(1.0 / (double)nArray.length);
            double d2 = PdVector.sqrDist((PdVector)pdVector2, (PdVector)pdVector);
            if (d2 < d) {
                n2 = n3;
                d = d2;
            }
            ++n3;
        }
        return n2;
    }

    private void normalOfElement(int n, PdVector pdVector) {
        PiVector piVector = this.m_geom.getElement(n);
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        pdVector.setConstant(0.0);
        int n2 = piVector.m_data.length;
        if (n2 == 3) {
            this.m_helpEdge1.sub(pdVectorArray[piVector.m_data[0]], pdVectorArray[piVector.m_data[1]]);
            this.m_helpEdge2.sub(pdVectorArray[piVector.m_data[2]], pdVectorArray[piVector.m_data[1]]);
            pdVector.m_data[0] = pdVector.m_data[0] + (this.m_helpEdge1.m_data[1] * this.m_helpEdge2.m_data[2] - this.m_helpEdge1.m_data[2] * this.m_helpEdge2.m_data[1]);
            pdVector.m_data[1] = pdVector.m_data[1] + (-this.m_helpEdge1.m_data[0] * this.m_helpEdge2.m_data[2] + this.m_helpEdge1.m_data[2] * this.m_helpEdge2.m_data[0]);
            pdVector.m_data[2] = pdVector.m_data[2] + (this.m_helpEdge1.m_data[0] * this.m_helpEdge2.m_data[1] - this.m_helpEdge1.m_data[1] * this.m_helpEdge2.m_data[0]);
        } else {
            int n3 = 0;
            while (n3 < n2) {
                this.m_helpEdge1.sub(pdVectorArray[piVector.m_data[n3]], pdVectorArray[piVector.m_data[(n3 + 1) % n2]]);
                this.m_helpEdge2.sub(pdVectorArray[piVector.m_data[(n3 + 2) % n2]], pdVectorArray[piVector.m_data[(n3 + 1) % n2]]);
                pdVector.m_data[0] = pdVector.m_data[0] + (this.m_helpEdge1.m_data[1] * this.m_helpEdge2.m_data[2] - this.m_helpEdge1.m_data[2] * this.m_helpEdge2.m_data[1]);
                pdVector.m_data[1] = pdVector.m_data[1] + (-this.m_helpEdge1.m_data[0] * this.m_helpEdge2.m_data[2] + this.m_helpEdge1.m_data[2] * this.m_helpEdge2.m_data[0]);
                pdVector.m_data[2] = pdVector.m_data[2] + (this.m_helpEdge1.m_data[0] * this.m_helpEdge2.m_data[1] - this.m_helpEdge1.m_data[1] * this.m_helpEdge2.m_data[0]);
                ++n3;
            }
        }
        pdVector.normalize();
    }

    private void computeUnfolding() {
        double d;
        double d2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing Geometry. Set Geometry first.");
            return;
        }
        PgElementSet pgElementSet = this.m_geomSave;
        PiVector[] piVectorArray = pgElementSet.getNeighbours();
        int n6 = this.m_geom.getNumElements();
        double[][] dArrayArray = new double[n6][];
        PiVector[] piVectorArray2 = this.m_geom.getElements();
        if (this.m_weight == 1) {
            n5 = 0;
            while (n5 < n6) {
                n4 = piVectorArray2[n5].getSize();
                dArrayArray[n5] = new double[n4];
                n3 = 0;
                while (n3 < n4) {
                    dArrayArray[n5][n3] = Math.abs(n5 - piVectorArray[n5].m_data[n3]);
                    ++n3;
                }
                ++n5;
            }
        } else {
            n5 = 0;
            while (n5 < n6) {
                n4 = piVectorArray2[n5].getSize();
                dArrayArray[n5] = new double[n4];
                n3 = 0;
                while (n3 < n4) {
                    dArrayArray[n5][n3] = -this.m_geom.getEdgeLength(n5, n3);
                    ++n3;
                }
                ++n5;
            }
        }
        try {
            PwModel.shrink(this.m_geom, 1.0);
        }
        catch (Exception exception) {
            PsDebug.warning((String)" Removing unused vertices. ");
            this.m_geom.removeUnusedVertices();
            PwModel.shrink(this.m_geom, 1.0);
        }
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PuPriorityQueue puPriorityQueue = new PuPriorityQueue(n6, Double.MAX_VALUE);
        int n7 = 0;
        int n8 = -1;
        int n9 = -1;
        Object object = new PdMatrix(4);
        PdVector pdVector = new PdVector(0.0, 0.0, 1.0);
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        PdVector pdVector5 = new PdVector(3);
        PdVector pdVector6 = new PdVector(3);
        PdVector[] pdVectorArray2 = new PdVector[]{new PdVector(3), new PdVector(3)};
        double[][] dArray = new double[this.m_geom.getNumEdges()][4];
        boolean[] blArray = new boolean[dArray.length];
        int[][] nArray = new int[dArray.length][2];
        int n10 = 0;
        boolean bl = true;
        boolean bl2 = false;
        double[] dArray2 = new double[2];
        double[][] dArray3 = new double[3][2];
        double[] dArray4 = new double[4];
        int n11 = -1;
        double d3 = 1.0E-10;
        double d4 = -1.0;
        double d5 = -1.0;
        while ((n8 = puPriorityQueue.extractMin()) != -1) {
            n2 = piVectorArray2[n8].getSize();
            if (this.m_linTreeParent[n8] == -1) {
                this.normalOfElement(n8, pdVector2);
                double d6 = PdVector.angle((PdVector)pdVector2, (PdVector)pdVector);
                pdVector4.cross(pdVector2, pdVector);
                object = pdVector4.sqrLength() < 1.0E-10 ? null : PuReflect.rotateLine((PdVector)pdVectorArray[piVectorArray2[n8].m_data[0]], (PdVector)pdVector4, (double)(d6 * Math.PI / 180.0));
                if (Math.abs(d6) < 1.0E-10 || object == null) {
                    n5 = 0;
                    while (n5 < n2) {
                        pdVectorArray[piVectorArray2[n8].m_data[n5]].m_data[2] = 0.0;
                        ++n5;
                    }
                } else {
                    pdVector4.cross(pdVector2, pdVector);
                    object = pdVector4.sqrLength() < 1.0E-10 ? null : PuReflect.rotateLine((PdVector)pdVectorArray[piVectorArray2[n8].m_data[0]], (PdVector)pdVector4, (double)(d6 * Math.PI / 180.0));
                    double[] dArray5 = object.m_data[2];
                    dArray5[3] = dArray5[3] - pdVectorArray[piVectorArray2[n8].m_data[0]].m_data[2];
                    n5 = 0;
                    while (n5 < n2) {
                        pdVector4.copy(pdVectorArray[piVectorArray2[n8].m_data[n5]]);
                        pdVectorArray[piVectorArray2[n8].m_data[n5]].leftMultAffin(object, pdVector4, true);
                        ++n5;
                    }
                }
                n10 = n2;
                n5 = 0;
                while (n5 < n2 - 1) {
                    nArray[n5][0] = n8;
                    nArray[n5][1] = (n5 - 1 + n2) % n2;
                    if (pdVectorArray[piVectorArray2[n8].m_data[n5]].m_data[0] < pdVectorArray[piVectorArray2[n8].m_data[n5 + 1]].m_data[0]) {
                        dArray[n5][0] = pdVectorArray[piVectorArray2[n8].m_data[n5]].m_data[0];
                        dArray[n5][1] = pdVectorArray[piVectorArray2[n8].m_data[n5 + 1]].m_data[0];
                        if (pdVectorArray[piVectorArray2[n8].m_data[n5]].m_data[1] < pdVectorArray[piVectorArray2[n8].m_data[n5 + 1]].m_data[1]) {
                            dArray[n5][2] = pdVectorArray[piVectorArray2[n8].m_data[n5]].m_data[1];
                            dArray[n5][3] = pdVectorArray[piVectorArray2[n8].m_data[n5 + 1]].m_data[1];
                            blArray[n5] = true;
                        } else {
                            dArray[n5][2] = pdVectorArray[piVectorArray2[n8].m_data[n5 + 1]].m_data[1];
                            dArray[n5][3] = pdVectorArray[piVectorArray2[n8].m_data[n5]].m_data[1];
                            blArray[n5] = false;
                        }
                    } else {
                        dArray[n5][0] = pdVectorArray[piVectorArray2[n8].m_data[n5 + 1]].m_data[0];
                        dArray[n5][1] = pdVectorArray[piVectorArray2[n8].m_data[n5]].m_data[0];
                        if (pdVectorArray[piVectorArray2[n8].m_data[n5]].m_data[1] < pdVectorArray[piVectorArray2[n8].m_data[n5 + 1]].m_data[1]) {
                            dArray[n5][2] = pdVectorArray[piVectorArray2[n8].m_data[n5]].m_data[1];
                            dArray[n5][3] = pdVectorArray[piVectorArray2[n8].m_data[n5 + 1]].m_data[1];
                            blArray[n5] = false;
                        } else {
                            dArray[n5][2] = pdVectorArray[piVectorArray2[n8].m_data[n5 + 1]].m_data[1];
                            dArray[n5][3] = pdVectorArray[piVectorArray2[n8].m_data[n5]].m_data[1];
                            blArray[n5] = true;
                        }
                    }
                    ++n5;
                }
                nArray[n2 - 1][0] = n8;
                nArray[n2 - 1][1] = n2 - 2;
                if (pdVectorArray[piVectorArray2[n8].m_data[n2 - 1]].m_data[0] < pdVectorArray[piVectorArray2[n8].m_data[0]].m_data[0]) {
                    dArray[n2 - 1][0] = pdVectorArray[piVectorArray2[n8].m_data[n2 - 1]].m_data[0];
                    dArray[n2 - 1][1] = pdVectorArray[piVectorArray2[n8].m_data[0]].m_data[0];
                    if (pdVectorArray[piVectorArray2[n8].m_data[n2 - 1]].m_data[1] < pdVectorArray[piVectorArray2[n8].m_data[0]].m_data[1]) {
                        dArray[n2 - 1][2] = pdVectorArray[piVectorArray2[n8].m_data[n2 - 1]].m_data[1];
                        dArray[n2 - 1][3] = pdVectorArray[piVectorArray2[n8].m_data[0]].m_data[1];
                        blArray[n2 - 1] = true;
                    } else {
                        dArray[n2 - 1][2] = pdVectorArray[piVectorArray2[n8].m_data[0]].m_data[1];
                        dArray[n2 - 1][3] = pdVectorArray[piVectorArray2[n8].m_data[n2 - 1]].m_data[1];
                        blArray[n2 - 1] = false;
                    }
                } else {
                    dArray[n2 - 1][0] = pdVectorArray[piVectorArray2[n8].m_data[0]].m_data[0];
                    dArray[n2 - 1][1] = pdVectorArray[piVectorArray2[n8].m_data[n2 - 1]].m_data[0];
                    if (pdVectorArray[piVectorArray2[n8].m_data[n2 - 1]].m_data[1] < pdVectorArray[piVectorArray2[n8].m_data[0]].m_data[1]) {
                        dArray[n2 - 1][2] = pdVectorArray[piVectorArray2[n8].m_data[n2 - 1]].m_data[1];
                        dArray[n2 - 1][3] = pdVectorArray[piVectorArray2[n8].m_data[0]].m_data[1];
                        blArray[n2 - 1] = false;
                    } else {
                        dArray[n2 - 1][2] = pdVectorArray[piVectorArray2[n8].m_data[0]].m_data[1];
                        dArray[n2 - 1][3] = pdVectorArray[piVectorArray2[n8].m_data[n2 - 1]].m_data[1];
                        blArray[n2 - 1] = true;
                    }
                }
                this.m_linTree[n7] = n8;
                ++n7;
            } else {
                pdVector5.sub(pdVectorArray[piVectorArray2[n8].m_data[(this.m_linTreeParent[n8] + 2) % n2]], pdVectorArray[piVectorArray2[n8].m_data[(this.m_linTreeParent[n8] + 1) % n2]]);
                pdVector5.normalize();
                pdVector6.sub(pdVectorArray[piVectorArray2[n8].m_data[this.m_linTreeParent[n8]]], pdVectorArray[piVectorArray2[n8].m_data[(this.m_linTreeParent[n8] + 1) % n2]]);
                pdVector4.multScalar(pdVector5, PdVector.dot((PdVector)pdVector5, (PdVector)pdVector6));
                pdVector6.sub(pdVector4);
                pdVector6.normalize();
                pdVectorArray2[0].setSize(n2);
                pdVectorArray2[1].setSize(n2);
                pdVector3 = pdVectorArray[piVectorArray2[n8].m_data[(this.m_linTreeParent[n8] + 1) % n2]];
                n5 = 0;
                while (n5 < n2) {
                    pdVector4.sub(pdVectorArray[piVectorArray2[n8].m_data[n5]], pdVector3);
                    pdVectorArray2[0].setEntry(n5, PdVector.dot((PdVector)pdVector5, (PdVector)pdVector4));
                    pdVector4.sub(pdVectorArray[piVectorArray2[n8].m_data[n5]], pdVector3);
                    pdVectorArray2[1].setEntry(n5, PdVector.dot((PdVector)pdVector6, (PdVector)pdVector4));
                    ++n5;
                }
                int n12 = piVectorArray[n8].m_data[this.m_linTreeParent[n8]];
                int n13 = piVectorArray2[n12].getSize();
                int n14 = pgElementSet.getOppVertexLocInd(n8, this.m_linTreeParent[n8]);
                bl = true;
                bl2 = false;
                if (pgElementSet.getElement((int)n8).m_data[(this.m_linTreeParent[n8] + 1) % n2] == pgElementSet.getElement((int)n12).m_data[(n14 + 1) % n13]) {
                    bl = false;
                    pdVector5.sub(pdVectorArray[piVectorArray2[n12].m_data[(n14 + 2) % n13]], pdVectorArray[piVectorArray2[n12].m_data[(n14 + 1) % n13]]);
                    pdVector5.normalize();
                    pdVector6.m_data[0] = -pdVector5.m_data[1];
                    pdVector6.m_data[1] = pdVector5.m_data[0];
                    pdVector6.m_data[2] = 0.0;
                    pdVector4.sub(pdVectorArray[piVectorArray2[n12].m_data[n14]], pdVectorArray[piVectorArray2[n12].m_data[(n14 + 1) % n13]]);
                    if (PdVector.dot((PdVector)pdVector6, (PdVector)pdVector4) > 0.0) {
                        pdVector6.multScalar(-1.0);
                    }
                    dArray2[0] = pdVectorArray[piVectorArray2[n12].m_data[(n14 + 1) % n13]].m_data[0];
                    dArray2[1] = pdVectorArray[piVectorArray2[n12].m_data[(n14 + 1) % n13]].m_data[1];
                } else {
                    pdVector5.sub(pdVectorArray[piVectorArray2[n12].m_data[(n14 + 1) % n13]], pdVectorArray[piVectorArray2[n12].m_data[(n14 + 2) % n13]]);
                    pdVector5.normalize();
                    pdVector6.m_data[0] = -pdVector5.m_data[1];
                    pdVector6.m_data[1] = pdVector5.m_data[0];
                    pdVector6.m_data[2] = 0.0;
                    pdVector4.sub(pdVectorArray[piVectorArray2[n12].m_data[n14]], pdVectorArray[piVectorArray2[n12].m_data[(n14 + 2) % n13]]);
                    if (PdVector.dot((PdVector)pdVector6, (PdVector)pdVector4) > 0.0) {
                        pdVector6.multScalar(-1.0);
                    }
                    dArray2[0] = pdVectorArray[piVectorArray2[n12].m_data[(n14 + 2) % n13]].m_data[0];
                    dArray2[1] = pdVectorArray[piVectorArray2[n12].m_data[(n14 + 2) % n13]].m_data[1];
                }
                if (dArray3.length != n2) {
                    dArray3 = new double[n2][2];
                }
                n5 = 0;
                while (n5 < n2) {
                    dArray3[n5][0] = dArray2[0] + pdVectorArray2[0].m_data[n5] * pdVector5.m_data[0] + pdVectorArray2[1].m_data[n5] * pdVector6.m_data[0];
                    dArray3[n5][1] = dArray2[1] + pdVectorArray2[0].m_data[n5] * pdVector5.m_data[1] + pdVectorArray2[1].m_data[n5] * pdVector6.m_data[1];
                    ++n5;
                }
                dArray4[0] = dArray3[0][0];
                dArray4[1] = dArray3[0][0];
                dArray4[2] = dArray3[0][1];
                dArray4[3] = dArray3[0][1];
                n5 = 1;
                while (n5 < n2) {
                    dArray4[0] = Math.min(dArray4[0], dArray3[n5][0]);
                    dArray4[1] = Math.max(dArray4[1], dArray3[n5][0]);
                    dArray4[2] = Math.min(dArray4[2], dArray3[n5][1]);
                    dArray4[3] = Math.max(dArray4[3], dArray3[n5][1]);
                    ++n5;
                }
                n5 = (this.m_linTreeParent[n8] + 1) % n2;
                n3 = (this.m_linTreeParent[n8] + 2) % n2;
                int n15 = pgElementSet.getNeighbour((int)n8).m_data[this.m_linTreeParent[n8]];
                int n16 = pgElementSet.getOppVertexLocInd(n8, this.m_linTreeParent[n8]);
                n5 = 0;
                while (n5 < n10) {
                    if (bl2) break;
                    if (!(dArray[n5][0] > dArray4[1] || dArray[n5][1] < dArray4[0] || dArray[n5][2] > dArray4[3] || dArray[n5][3] < dArray4[2])) {
                        if (nArray[n5][0] == n15 && nArray[n5][1] == n16) {
                            n11 = n5;
                        } else {
                            double d7;
                            double d8;
                            double d9;
                            double d10;
                            if (blArray[n5]) {
                                d10 = dArray[n5][0];
                                d9 = dArray[n5][2];
                                d8 = dArray[n5][1] - d10;
                                d7 = dArray[n5][3] - d9;
                            } else {
                                d10 = dArray[n5][0];
                                d9 = dArray[n5][3];
                                d8 = dArray[n5][1] - d10;
                                d7 = dArray[n5][2] - d9;
                            }
                            n3 = (this.m_linTreeParent[n8] + 2) % n2;
                            while (n3 != (this.m_linTreeParent[n8] + 1) % n2) {
                                double d11 = dArray3[n3][1];
                                double d12 = dArray3[(n3 + 1) % n2][1] - d11;
                                double d13 = dArray3[n3][0];
                                double d14 = dArray3[(n3 + 1) % n2][0] - d13;
                                if ((d12 * d8 - d14 * d7 > d3 || -(d12 * d8 - d14 * d7) > d3) && (d4 = ((d13 - d10) * d7 - (d11 - d9) * d8) / (d12 * d8 - d14 * d7)) > -d3 && d4 < 1.0 + d3 && (d5 = ((d11 - d9) * d14 - (d13 - d10) * d12) / (d14 * d7 - d12 * d8)) > -d3 && d5 < 1.0 + d3) {
                                    if (d4 > d3 && d4 < 1.0 - d3 && d5 > d3 && d5 < 1.0 - d3) {
                                        bl2 = true;
                                        if (!this.noOverlaps) break;
                                        bl2 = false;
                                        break;
                                    }
                                    if (!(d4 < d3) && !(d4 > 1.0 - d3) || !(d5 < d3) && !(d5 > 1.0 - d3)) {
                                        if (d4 < d3) {
                                            if (d8 * (d11 + d12 - d9) - d7 * (d13 + d14 - d10) > 0.0) {
                                                bl2 = true;
                                                if (!this.noOverlaps) break;
                                                bl2 = false;
                                                break;
                                            }
                                        } else if (d4 > 1.0 - d3) {
                                            if (d8 * (d11 - d9) - d7 * (d13 - d10) > 0.0) {
                                                bl2 = true;
                                                if (!this.noOverlaps) break;
                                                bl2 = false;
                                                break;
                                            }
                                        } else if (d5 < d3) {
                                            if (d14 * (d9 + d7 - d11) - d12 * (d10 + d8 - d13) > 0.0) {
                                                bl2 = true;
                                                if (!this.noOverlaps) break;
                                                bl2 = false;
                                                break;
                                            }
                                        } else if (d5 > 1.0 - d3 && d14 * (d9 - d11) - d12 * (d10 - d13) > 0.0) {
                                            bl2 = true;
                                            if (!this.noOverlaps) break;
                                            bl2 = false;
                                            break;
                                        }
                                    }
                                }
                                n3 = (n3 + 1) % n2;
                            }
                        }
                    }
                    ++n5;
                }
                if (bl2) {
                    puPriorityQueue.enqueue(n8, Double.POSITIVE_INFINITY);
                    this.m_linTreeParent[n8] = -1;
                    bl2 = false;
                    continue;
                }
                if (bl) {
                    piVectorArray2[n8].m_data[(this.m_linTreeParent[n8] + 1) % n2] = piVectorArray2[n12].m_data[(n14 + 2) % n13];
                    piVectorArray2[n8].m_data[(this.m_linTreeParent[n8] + 2) % n2] = piVectorArray2[n12].m_data[(n14 + 1) % n13];
                } else {
                    piVectorArray2[n8].m_data[(this.m_linTreeParent[n8] + 1) % n2] = piVectorArray2[n12].m_data[(n14 + 1) % n13];
                    piVectorArray2[n8].m_data[(this.m_linTreeParent[n8] + 2) % n2] = piVectorArray2[n12].m_data[(n14 + 2) % n13];
                }
                n5 = 0;
                while (n5 < n2) {
                    pdVectorArray[piVectorArray2[n8].m_data[n5]].m_data[0] = dArray3[n5][0];
                    pdVectorArray[piVectorArray2[n8].m_data[n5]].m_data[1] = dArray3[n5][1];
                    pdVectorArray[piVectorArray2[n8].m_data[n5]].m_data[2] = 0.0;
                    ++n5;
                }
                this.m_linTree[n7] = n8;
                ++n7;
                n5 = 0;
                while (n5 < n2 - 1) {
                    nArray[n10][0] = n8;
                    nArray[n10][1] = (n5 - 1 + n2) % n2;
                    if (dArray3[n5][0] < dArray3[n5 + 1][0]) {
                        dArray[n10][0] = dArray3[n5][0];
                        dArray[n10][1] = dArray3[n5 + 1][0];
                        if (dArray3[n5][1] < dArray3[n5 + 1][1]) {
                            dArray[n10][2] = dArray3[n5][1];
                            dArray[n10][3] = dArray3[n5 + 1][1];
                            blArray[n10] = true;
                        } else {
                            dArray[n10][2] = dArray3[n5 + 1][1];
                            dArray[n10][3] = dArray3[n5][1];
                            blArray[n10] = false;
                        }
                    } else {
                        dArray[n10][0] = dArray3[n5 + 1][0];
                        dArray[n10][1] = dArray3[n5][0];
                        if (dArray3[n5][1] < dArray3[n5 + 1][1]) {
                            dArray[n10][2] = dArray3[n5][1];
                            dArray[n10][3] = dArray3[n5 + 1][1];
                            blArray[n10] = false;
                        } else {
                            dArray[n10][2] = dArray3[n5 + 1][1];
                            dArray[n10][3] = dArray3[n5][1];
                            blArray[n10] = true;
                        }
                    }
                    ++n10;
                    ++n5;
                }
                if (n11 >= 0) {
                    nArray[n11][0] = n8;
                    nArray[n11][1] = n2 - 2;
                    if (dArray3[n2 - 1][0] < dArray3[0][0]) {
                        dArray[n11][0] = dArray3[n2 - 1][0];
                        dArray[n11][1] = dArray3[0][0];
                        if (dArray3[n2 - 1][1] < dArray3[0][1]) {
                            dArray[n11][2] = dArray3[n2 - 1][1];
                            dArray[n11][3] = dArray3[0][1];
                            blArray[n11] = true;
                        } else {
                            dArray[n11][2] = dArray3[0][1];
                            dArray[n11][3] = dArray3[n2 - 1][1];
                            blArray[n11] = false;
                        }
                    } else {
                        dArray[n11][0] = dArray3[0][0];
                        dArray[n11][1] = dArray3[n2 - 1][0];
                        if (dArray3[n5][1] < dArray3[0][1]) {
                            dArray[n11][2] = dArray3[n2 - 1][1];
                            dArray[n11][3] = dArray3[0][1];
                            blArray[n11] = false;
                        } else {
                            dArray[n11][2] = dArray3[0][1];
                            dArray[n11][3] = dArray3[n2 - 1][1];
                            blArray[n11] = true;
                        }
                    }
                    n11 = -1;
                } else {
                    nArray[n10][0] = n8;
                    nArray[n10][1] = n2 - 2;
                    if (dArray3[n2 - 1][0] < dArray3[0][0]) {
                        dArray[n10][0] = dArray3[n2 - 1][0];
                        dArray[n10][1] = dArray3[0][0];
                        if (dArray3[n2 - 1][1] < dArray3[0][1]) {
                            dArray[n10][2] = dArray3[n2 - 1][1];
                            dArray[n10][3] = dArray3[0][1];
                            blArray[n10] = true;
                        } else {
                            dArray[n10][2] = dArray3[0][1];
                            dArray[n10][3] = dArray3[n2 - 1][1];
                            blArray[n10] = false;
                        }
                    } else {
                        dArray[n10][0] = dArray3[0][0];
                        dArray[n10][1] = dArray3[n2 - 1][0];
                        if (dArray3[n5][1] < dArray3[0][1]) {
                            dArray[n10][2] = dArray3[n2 - 1][1];
                            dArray[n10][3] = dArray3[0][1];
                            blArray[n10] = false;
                        } else {
                            dArray[n10][2] = dArray3[0][1];
                            dArray[n10][3] = dArray3[n2 - 1][1];
                            blArray[n10] = true;
                        }
                    }
                    ++n10;
                }
            }
            n5 = 0;
            while (n5 < n2) {
                n9 = piVectorArray[n8].m_data[n5];
                if (n9 != -1 && puPriorityQueue.isElement(n9) && dArrayArray[n8][n5] < puPriorityQueue.getKey(n9)) {
                    n3 = 0;
                    while (n3 < piVectorArray[n9].getSize()) {
                        if (piVectorArray[n9].m_data[n3] == n8) {
                            this.m_linTreeParent[n9] = n3;
                            break;
                        }
                        ++n3;
                    }
                    puPriorityQueue.decreaseKey(n9, dArrayArray[n8][n5]);
                }
                ++n5;
            }
        }
        this.m_geom.removeUnusedVertices();
        pdVectorArray = this.m_geom.getVertices();
        double d15 = 0.0;
        double d16 = 0.0;
        this.m_numOfParts = 0;
        n5 = 0;
        while (n5 < n6) {
            if (this.m_linTreeParent[n5] == -1) {
                ++this.m_numOfParts;
            }
            ++n5;
        }
        this.m_vertOfPolygons = new int[this.m_numOfParts][];
        n3 = 0;
        n4 = 0;
        n5 = n6 - 1;
        while (n5 >= 0) {
            if (this.m_linTreeParent[this.m_linTree[n5]] == -1) {
                this.m_vertOfPolygons[n4] = new int[n3 += piVectorArray2[this.m_linTree[n5]].getSize()];
                ++n4;
                n3 = 0;
            } else {
                n3 += piVectorArray2[this.m_linTree[n5]].getSize() - 2;
            }
            --n5;
        }
        n4 = 0;
        n3 = 0;
        n5 = n6 - 1;
        while (n5 >= 0) {
            if (this.m_linTreeParent[this.m_linTree[n5]] == -1) {
                n = 0;
                while (n < piVectorArray2[this.m_linTree[n5]].getSize()) {
                    this.m_vertOfPolygons[n4][n3] = piVectorArray2[this.m_linTree[n5]].getEntry(n);
                    ++n3;
                    ++n;
                }
                ++n4;
                n3 = 0;
            } else {
                n2 = piVectorArray2[this.m_linTree[n5]].getSize();
                n = 0;
                while (n < n2 - 2) {
                    this.m_vertOfPolygons[n4][n3] = piVectorArray2[this.m_linTree[n5]].getEntry((this.m_linTreeParent[this.m_linTree[n5]] - n + n2) % n2);
                    ++n3;
                    ++n;
                }
            }
            --n5;
        }
        double[][] dArray6 = new double[this.m_numOfParts][2];
        this.m_BBoxdata = new double[this.m_numOfParts][4];
        n5 = 0;
        while (n5 < this.m_numOfParts) {
            double d17;
            double d18;
            d2 = d18 = pdVectorArray[this.m_vertOfPolygons[n5][0]].m_data[0];
            d = d17 = pdVectorArray[this.m_vertOfPolygons[n5][0]].m_data[1];
            this.m_BBoxdata[n5][0] = d18;
            this.m_BBoxdata[n5][3] = d;
            this.m_BBoxdata[n5][1] = d17;
            n3 = 1;
            while (n3 < this.m_vertOfPolygons[n5].length) {
                if (pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[0] > d2) {
                    d2 = pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[0];
                } else if (pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[0] < d18) {
                    this.m_BBoxdata[n5][0] = d18 = pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[0];
                }
                if (pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[1] > d) {
                    this.m_BBoxdata[n5][3] = d = pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[1];
                } else if (pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[1] < d17) {
                    this.m_BBoxdata[n5][1] = d17 = pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[1];
                }
                ++n3;
            }
            dArray6[n5][0] = d2 - d18;
            dArray6[n5][1] = d - d17;
            if (dArray6[n5][0] > d15) {
                d15 = dArray6[n5][0];
            }
            if (dArray6[n5][1] > d16) {
                d16 = dArray6[n5][1];
            }
            ++n5;
        }
        double d19 = Math.log(2.0);
        if (d15 > d16) {
            if (d15 > 2.0 * d16) {
                d16 = Math.pow(2.0, Math.floor(Math.log(d15 / d16) / d19)) * d16;
            } else if (d16 > 2.0 * d15) {
                d15 = Math.pow(2.0, Math.floor(Math.log(d16 / d15) / d19)) * d15;
            }
        }
        int[] nArray2 = new int[this.m_numOfParts];
        int n17 = 0;
        n5 = 0;
        while (n5 < this.m_numOfParts) {
            d2 = Math.log(d15 / dArray6[n5][0]) / d19;
            n3 = (int)Math.floor(Math.min(d2, d = Math.log(d16 / dArray6[n5][1]) / d19));
            n3 = dArray6[n5][0] * Math.pow(2.0, n3 + 1) < d15 ? 2 * n3 + 1 : (n3 *= 2);
            nArray2[n5] = n3;
            if (n3 > n17) {
                n17 = n3;
            }
            ++n5;
        }
        PiVector[] piVectorArray3 = new PiVector[n17 + 1];
        n5 = 0;
        while (n5 < n17 + 1) {
            piVectorArray3[n5] = new PiVector(0);
            ++n5;
        }
        n5 = 0;
        while (n5 < this.m_numOfParts) {
            piVectorArray3[nArray2[n5]].addEntry(n5);
            ++n5;
        }
        int n18 = 0;
        double d20 = 0.0;
        n5 = 0;
        while (n5 < n17 + 1) {
            d20 += (double)piVectorArray3[n5].getSize() / Math.pow(2.0, n5);
            ++n5;
        }
        n18 = (int)Math.ceil(d20);
        int n19 = (int)Math.ceil(Math.sqrt(n18));
        this.m_translatePolygons = new double[this.m_numOfParts][2];
        int n20 = 0;
        int n21 = 0;
        n5 = (int)((double)n19 * Math.pow(2.0, Math.ceil((double)n17 / 2.0)));
        int[] nArray3 = new int[n5];
        PdVector pdVector7 = pgElementSet.getCenterOfGravity();
        double d21 = d15 / Math.pow(2.0, Math.ceil((double)n17 / 2.0));
        double d22 = d16 / Math.pow(2.0, Math.floor((double)n17 / 2.0));
        n5 = 0;
        while (n5 < n17 + 1) {
            n3 = 0;
            while (n3 < piVectorArray3[n5].getSize()) {
                this.m_translatePolygons[piVectorArray3[n5].m_data[n3]][0] = (double)n21 * d21;
                this.m_translatePolygons[piVectorArray3[n5].m_data[n3]][1] = (double)n20 * d22;
                n21 += (int)Math.pow(2.0, Math.ceil((double)n17 / 2.0) - Math.ceil((double)n5 / 2.0));
                n = n20 + (int)Math.pow(2.0, Math.floor((double)n17 / 2.0) - Math.floor((double)n5 / 2.0));
                n4 = n20;
                while (n4 < n) {
                    nArray3[n4] = n21;
                    ++n4;
                }
                while (n21 >= nArray3.length && n20 < nArray3.length - 1) {
                    n21 = nArray3[++n20];
                }
                ++n3;
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < this.m_vertOfPolygons.length) {
            n3 = 0;
            while (n3 < this.m_vertOfPolygons[n5].length) {
                if (this.m_BBoxdata[n5][2] == 0.0) {
                    pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[0] = pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[0] + (this.m_translatePolygons[n5][0] - this.m_BBoxdata[n5][0]);
                    pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[1] = pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[1] + (this.m_translatePolygons[n5][1] - this.m_BBoxdata[n5][1]);
                } else {
                    d20 = pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[0];
                    pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[0] = pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[0] + (-pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[1] - pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[0] + (this.m_translatePolygons[n5][0] + this.m_BBoxdata[n5][3]));
                    pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[1] = pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[1] + (d20 - pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[1] + (this.m_translatePolygons[n5][1] - this.m_BBoxdata[n5][0]));
                }
                ++n3;
            }
            ++n5;
        }
        PdVector pdVector8 = this.m_geom.getCenterOfGravity();
        double d23 = pdVector7.m_data[0] - pdVector8.m_data[0];
        double d24 = pdVector7.m_data[1] - pdVector8.m_data[1];
        n5 = 0;
        while (n5 < n17 + 1) {
            n3 = 0;
            while (n3 < piVectorArray3[n5].getSize()) {
                double[] dArray7 = this.m_translatePolygons[piVectorArray3[n5].m_data[n3]];
                dArray7[0] = dArray7[0] + d23;
                double[] dArray8 = this.m_translatePolygons[piVectorArray3[n5].m_data[n3]];
                dArray8[1] = dArray8[1] + d24;
                ++n3;
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < this.m_vertOfPolygons.length) {
            n3 = 0;
            while (n3 < this.m_vertOfPolygons[n5].length) {
                pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[0] = pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[0] + d23;
                pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[1] = pdVectorArray[this.m_vertOfPolygons[n5][n3]].m_data[1] + d24;
                ++n3;
            }
            ++n5;
        }
        int n22 = this.m_geom.getNumVertices();
        n5 = 0;
        while (n5 < n22) {
            pdVectorArray[n5].m_data[2] = pdVectorArray[n5].m_data[2] + pdVector7.m_data[2];
            ++n5;
        }
        this.m_isUnfold = true;
        this.m_geom.makeNeighbour();
        this.m_geom.makeElementNormals();
        this.m_geom.makeVertexNormals();
        PdVector[] pdVectorArray3 = this.m_geom.getBounds();
        this.m_diamBB[1] = PdVector.dist((PdVector)pdVectorArray3[0], (PdVector)pdVectorArray3[1]);
    }

    public boolean improveUnfolding() {
        int n;
        if (this.m_anim.isRunning() && this.m_bUpdateWhileImprove) {
            this.stopAnimation();
        }
        if (this.m_bUpdateWhileImprove) {
            n = this.m_fixedElement;
            this.m_fixedElement = -1;
            this.flatten(1.0);
            this.m_fixedElement = n;
        }
        this.m_isImproving = true;
        int n2 = n = this.assureElemTreeTable();
        int n3 = n + 1;
        if (n <= 1) {
            this.m_isImproving = false;
            return false;
        }
        boolean bl = true;
        int n4 = 0;
        int n5 = 0;
        bl = false;
        n4 = 0;
        while (!bl && n4 < 10) {
            bl = this.resort(false);
            n2 = this.assureElemTreeTable();
            if (this.m_bStopImproving) break;
            ++n4;
        }
        if (!this.m_bquickImprove) {
            block3: while (n5 < 10 && n2 > 1) {
                n3 = n2;
                bl = false;
                n4 = 0;
                while (!bl && n4 < 10) {
                    bl = this.resort(true);
                    n2 = this.assureElemTreeTable();
                    if (this.m_bStopImproving) break block3;
                    ++n4;
                }
                bl = false;
                n4 = 0;
                while (!bl && n4 < 10) {
                    bl = this.resort(false);
                    n2 = this.assureElemTreeTable();
                    if (this.m_bStopImproving) break block3;
                    ++n4;
                }
                if (n3 <= n2) {
                    ++n5;
                    continue;
                }
                if (this.m_numOfParts == n2 || !this.m_bUpdateWhileImprove) continue;
                this.m_numOfParts = n2;
                this.update(this);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.setVertexPos();
        this.m_geom.removeUnusedVertices();
        int n6 = this.m_geom.getNumElements();
        int n7 = 0;
        while (n7 < n6) {
            this.m_linTreeParent[n7] = -1;
            ++n7;
        }
        this.m_isFlat = false;
        this.m_isUnfold = false;
        n7 = this.m_geom.getNumElements();
        PiVector[] piVectorArray = new PiVector[n7];
        PiVector[] piVectorArray2 = this.m_geomSave.getNeighbours();
        PiVector[] piVectorArray3 = this.m_geom.getNeighbours();
        int n8 = 0;
        while (n8 < n7) {
            int n9 = piVectorArray2[n8].getSize();
            piVectorArray[n8] = new PiVector(n9);
            int n10 = 0;
            while (n10 < n9) {
                piVectorArray[n8].m_data[n10] = piVectorArray2[n8].m_data[n10];
                ++n10;
            }
            ++n8;
        }
        PiVector.copy((PiVector[])piVectorArray2, (int)0, (PiVector[])piVectorArray3, (int)0, (int)n7);
        this.noOverlaps = true;
        this.m_bNoImprove = true;
        this.flatten(1.0);
        this.m_bNoImprove = false;
        this.noOverlaps = false;
        this.m_fixedElement = this.computeCenterElement();
        PiVector.copy((PiVector[])piVectorArray2, (int)0, (PiVector[])piVectorArray, (int)0, (int)n7);
        this.m_isImproving = false;
        this.rebuildLinTreeBreadthFirst();
        return n != n2;
    }

    private void computeSplices() {
        int n;
        int n2 = 0;
        PiVector[] piVectorArray = this.m_geom.getNeighbours();
        PiVector[] piVectorArray2 = this.m_geomSave.getNeighbours();
        PiVector[] piVectorArray3 = this.m_geom.getElements();
        int n3 = this.m_geom.getNumElements();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < piVectorArray3[n4].getSize()) {
                if (n4 < piVectorArray2[n4].m_data[n5] && piVectorArray[n4].m_data[n5] == -1) {
                    ++n2;
                }
                ++n5;
            }
            ++n4;
        }
        this.m_splice.setNumElements(n2);
        this.m_splice.setNumVertices(4 * n2);
        n4 = 0;
        PdVector pdVector = new PdVector(3);
        pdVector.m_data[2] = this.m_geomSave.getCenterOfGravity().m_data[2];
        piVectorArray = this.m_geom.getNeighbours();
        piVectorArray2 = this.m_geomSave.getNeighbours();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PdVector[] pdVectorArray2 = this.m_splice.getVertices();
        piVectorArray3 = this.m_geom.getElements();
        n3 = this.m_geom.getNumElements();
        int n6 = 0;
        while (n6 < n3) {
            n = 0;
            while (n < piVectorArray3[n6].getSize()) {
                if (n6 < piVectorArray2[n6].m_data[n] && piVectorArray[n6].m_data[n] == -1) {
                    double d = pdVectorArray[piVectorArray3[n6].m_data[(n + 1) % piVectorArray3[n6].getSize()]].m_data[0];
                    double d2 = pdVectorArray[piVectorArray3[n6].m_data[(n + 1) % piVectorArray3[n6].getSize()]].m_data[1];
                    double d3 = pdVectorArray[piVectorArray3[n6].m_data[(n + 2) % piVectorArray3[n6].getSize()]].m_data[0];
                    double d4 = pdVectorArray[piVectorArray3[n6].m_data[(n + 2) % piVectorArray3[n6].getSize()]].m_data[1];
                    pdVector.m_data[0] = d * 0.875 + d3 * 0.125;
                    pdVector.m_data[1] = d2 * 0.875 + d4 * 0.125;
                    pdVectorArray2[n4++].copyArray(pdVector);
                    pdVector.m_data[0] = d * 0.125 + d3 * 0.875;
                    pdVector.m_data[1] = d2 * 0.125 + d4 * 0.875;
                    pdVectorArray2[n4++].copyArray(pdVector);
                    double d5 = pdVectorArray[piVectorArray3[n6].m_data[n]].m_data[0];
                    double d6 = pdVectorArray[piVectorArray3[n6].m_data[n]].m_data[1];
                    if ((-d2 + d4) * (d5 - d) + (d - d3) * (d6 - d2) < 0.0) {
                        pdVector.m_data[0] = (-d2 + d4) / 10.0 + d * 0.325 + d3 * 0.675;
                        pdVector.m_data[1] = (d - d3) / 10.0 + d2 * 0.325 + d4 * 0.675;
                        pdVectorArray2[n4++].copyArray(pdVector);
                        pdVector.m_data[0] = (-d2 + d4) / 10.0 + d * 0.675 + d3 * 0.325;
                        pdVector.m_data[1] = (d - d3) / 10.0 + d2 * 0.675 + d4 * 0.325;
                        pdVectorArray2[n4++].copyArray(pdVector);
                    } else {
                        pdVector.m_data[0] = (d2 - d4) / 10.0 + d * 0.325 + d3 * 0.675;
                        pdVector.m_data[1] = (-d + d3) / 10.0 + d2 * 0.325 + d4 * 0.675;
                        pdVectorArray2[n4++].copyArray(pdVector);
                        pdVector.m_data[0] = (d2 - d4) / 10.0 + d * 0.675 + d3 * 0.325;
                        pdVector.m_data[1] = (-d + d3) / 10.0 + d2 * 0.675 + d4 * 0.325;
                        pdVectorArray2[n4++].copyArray(pdVector);
                    }
                }
                ++n;
            }
            ++n6;
        }
        int n7 = this.m_splice.getNumElements();
        n6 = 0;
        while (n6 < n7) {
            n = 4 * n6;
            this.m_splice.setElement(n6, n, n + 1, n + 2, n + 3);
            ++n6;
        }
    }

    private void transformSplice() {
        if (this.m_isFlat && this.m_showSplice && this.m_bFixElem && this.m_trafo != null && this.m_fixedElement >= 0) {
            PdVector[] pdVectorArray = this.m_splice.getVertices();
            PdVector pdVector = this.m_geomSave.getVertex(this.m_geomSave.getElement((int)this.m_fixedElement).m_data[0]);
            int n = this.m_splice.getNumVertices();
            PdVector pdVector2 = new PdVector(3);
            int n2 = 0;
            while (n2 < n) {
                pdVectorArray[n2].sub(this.m_trans);
                pdVector2.copyArray(pdVectorArray[n2]);
                pdVectorArray[n2].leftMultMatrix(this.m_trafo, pdVector2);
                pdVectorArray[n2].add(pdVector);
                ++n2;
            }
        }
    }

    public boolean update(Object object) {
        if (object == this.m_geom) {
            if (this.isUpdateSender()) {
                return true;
            }
            this.setGeometry(this.m_geom);
            return true;
        }
        return super.update(object);
    }

    public void dragInitial(PvPickEvent pvPickEvent) {
        this.pickInitial(pvPickEvent);
    }

    public void start() {
        if (!this.m_bStopped || this.m_bRunning) {
            return;
        }
        this.m_bRunning = true;
        this.m_bStopped = false;
        this.m_thread = new Thread((Runnable)this, "JavaView: Improve Unfolding");
        this.m_thread.setPriority(5);
        this.m_thread.start();
    }

    protected final PdVector transform(PdMatrix pdMatrix, PdVector pdVector, PdVector pdVector2) {
        pdVector2.m_data[0] = pdMatrix.m_data[0][0] * pdVector.m_data[0] + pdMatrix.m_data[0][1] * pdVector.m_data[1] + pdMatrix.m_data[0][2];
        pdVector2.m_data[1] = pdMatrix.m_data[1][0] * pdVector.m_data[0] + pdMatrix.m_data[1][1] * pdVector.m_data[1] + pdMatrix.m_data[1][2];
        return pdVector2;
    }

    public boolean isStopped() {
        return this.m_bStopped;
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        if (!this.m_bPickFixElem || pvPickEvent.getGeometry() != this.m_geom) {
            return;
        }
        this.setFixedElement(pvPickEvent.getElementInd());
        this.update(this);
    }

    public boolean isFittingGeometry() {
        return this.m_bAutoFit;
    }

    public void unfold() {
        this.flatten(1.0);
    }

    protected boolean doIntersect(int n, int n2, PdMatrix pdMatrix, int n3, int n4, PdMatrix pdMatrix2) {
        int n5;
        int n6;
        int n7;
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = 1.0E-12;
        PiVector[] piVectorArray = this.m_geom.getNeighbours();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PiVector[] piVectorArray2 = this.m_geom.getElements();
        if (pdMatrix == null) {
            pdMatrix = new PdMatrix(2, 3);
            pdMatrix.m_data[0][0] = 1.0;
            pdMatrix.m_data[1][1] = 1.0;
            pdMatrix.m_data[1][0] = 0.0;
            pdMatrix.m_data[0][1] = 0.0;
            pdMatrix.m_data[1][2] = 0.0;
            pdMatrix.m_data[0][2] = 0.0;
        }
        if (pdMatrix2 == null) {
            d4 = pdVectorArray[piVectorArray2[this.m_linTree[n3]].m_data[0]].m_data[0];
            d3 = pdVectorArray[piVectorArray2[this.m_linTree[n3]].m_data[0]].m_data[1];
            d2 = d4;
            d = d3;
            n7 = n3;
            while (n7 < n4 + 1) {
                n6 = piVectorArray2[this.m_linTree[n7]].getSize();
                n5 = 0;
                while (n5 < n6) {
                    if (pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]].m_data[0] < d4) {
                        d4 = pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]].m_data[0];
                    } else if (pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]].m_data[0] > d2) {
                        d2 = pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]].m_data[0];
                    }
                    if (pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]].m_data[1] < d3) {
                        d3 = pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]].m_data[1];
                    } else if (pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]].m_data[1] > d) {
                        d = pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]].m_data[1];
                    }
                    ++n5;
                }
                ++n7;
            }
        } else {
            PdVector pdVector = new PdVector(this.m_geom.getDimOfVertices());
            d4 = this.transform((PdMatrix)pdMatrix2, (PdVector)pdVectorArray[piVectorArray2[this.m_linTree[n3]].m_data[0]], (PdVector)pdVector).m_data[0];
            d3 = this.transform((PdMatrix)pdMatrix2, (PdVector)pdVectorArray[piVectorArray2[this.m_linTree[n3]].m_data[0]], (PdVector)pdVector).m_data[1];
            d2 = d4;
            d = d3;
            n7 = n3;
            while (n7 < n4 + 1) {
                n6 = piVectorArray2[this.m_linTree[n7]].getSize();
                n5 = 0;
                while (n5 < n6) {
                    if (this.transform((PdMatrix)pdMatrix2, (PdVector)pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]], (PdVector)pdVector).m_data[0] < d4) {
                        d4 = this.transform((PdMatrix)pdMatrix2, (PdVector)pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]], (PdVector)pdVector).m_data[0];
                    } else if (this.transform((PdMatrix)pdMatrix2, (PdVector)pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]], (PdVector)pdVector).m_data[0] > d2) {
                        d2 = this.transform((PdMatrix)pdMatrix2, (PdVector)pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]], (PdVector)pdVector).m_data[0];
                    }
                    if (this.transform((PdMatrix)pdMatrix2, (PdVector)pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]], (PdVector)pdVector).m_data[1] < d3) {
                        d3 = this.transform((PdMatrix)pdMatrix2, (PdVector)pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]], (PdVector)pdVector).m_data[1];
                    } else if (this.transform((PdMatrix)pdMatrix2, (PdVector)pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]], (PdVector)pdVector).m_data[1] > d) {
                        d = this.transform((PdMatrix)pdMatrix2, (PdVector)pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]], (PdVector)pdVector).m_data[1];
                    }
                    ++n5;
                }
                ++n7;
            }
        }
        PdVector pdVector = new PdVector(3);
        n7 = n;
        while (n7 < n2 + 1) {
            n6 = piVectorArray2[this.m_linTree[n7]].getSize();
            n5 = 0;
            while (n5 < n6) {
                block33: {
                    if (piVectorArray[this.m_linTree[n7]].m_data[n5] != -1) break block33;
                    this.transform(pdMatrix, pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[(n5 + 1) % n6]], pdVector);
                    double d6 = pdVector.m_data[0];
                    double d7 = pdVector.m_data[1];
                    this.transform(pdMatrix, pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[(n5 + 2) % n6]], pdVector);
                    double d8 = pdVector.m_data[0];
                    double d9 = pdVector.m_data[1];
                    if (Math.min(d6, d8) > d2 || Math.max(d6, d8) < d4 || Math.min(d7, d9) > d || Math.max(d7, d9) < d3) break block33;
                    d8 -= d6;
                    d9 -= d7;
                    this.transform(pdMatrix, pdVectorArray[piVectorArray2[this.m_linTree[n7]].m_data[n5]], pdVector);
                    if (d8 * (pdVector.m_data[1] - d7) - d9 * (pdVector.m_data[0] - d6) < 0.0) {
                        d6 += d8;
                        d7 += d9;
                        d8 = -d8;
                        d9 = -d9;
                    }
                    int n8 = n3;
                    while (n8 < n4 + 1) {
                        int n9 = piVectorArray2[this.m_linTree[n8]].getSize();
                        int n10 = 0;
                        while (n10 < n9) {
                            block34: {
                                double d10;
                                double d11;
                                double d12;
                                double d13;
                                double d14;
                                double d15;
                                block36: {
                                    block35: {
                                        if (piVectorArray[this.m_linTree[n8]].m_data[n10] != -1) break block34;
                                        if (pdMatrix2 == null) break block35;
                                        this.transform(pdMatrix2, pdVectorArray[piVectorArray2[this.m_linTree[n8]].m_data[(n10 + 1) % n9]], pdVector);
                                        d15 = pdVector.m_data[0];
                                        d14 = pdVector.m_data[1];
                                        this.transform(pdMatrix2, pdVectorArray[piVectorArray2[this.m_linTree[n8]].m_data[(n10 + 2) % n9]], pdVector);
                                        d13 = pdVector.m_data[0];
                                        d12 = pdVector.m_data[1];
                                        if (Math.min(d15, d13) >= Math.max(d6, d8 + d6) || Math.max(d15, d13) <= Math.min(d6, d8 + d6) || Math.min(d14, d12) >= Math.max(d7, d9 + d7) || Math.max(d14, d12) <= Math.min(d7, d9 + d7)) break block34;
                                        d13 -= d15;
                                        d12 -= d14;
                                        this.transform(pdMatrix2, pdVectorArray[piVectorArray2[this.m_linTree[n8]].m_data[n10]], pdVector);
                                        if (d13 * (pdVector.m_data[1] - d14) - d12 * (pdVector.m_data[0] - d15) < 0.0) {
                                            d15 += d13;
                                            d14 += d12;
                                            d13 = -d13;
                                            d12 = -d12;
                                        }
                                        break block36;
                                    }
                                    d15 = pdVectorArray[piVectorArray2[this.m_linTree[n8]].m_data[(n10 + 1) % n9]].m_data[0];
                                    d14 = pdVectorArray[piVectorArray2[this.m_linTree[n8]].m_data[(n10 + 1) % n9]].m_data[1];
                                    d13 = pdVectorArray[piVectorArray2[this.m_linTree[n8]].m_data[(n10 + 2) % n9]].m_data[0];
                                    d12 = pdVectorArray[piVectorArray2[this.m_linTree[n8]].m_data[(n10 + 2) % n9]].m_data[1];
                                    if (Math.min(d15, d13) >= Math.max(d6, d8 + d6) || Math.max(d15, d13) <= Math.min(d6, d8 + d6) || Math.min(d14, d12) >= Math.max(d7, d9 + d7) || Math.max(d14, d12) <= Math.min(d7, d9 + d7)) break block34;
                                    d13 -= d15;
                                    d12 -= d14;
                                    pdVector.copy(pdVectorArray[piVectorArray2[this.m_linTree[n8]].m_data[n10]]);
                                    if (d13 * (pdVector.m_data[1] - d14) - d12 * (pdVector.m_data[0] - d15) < 0.0) {
                                        d15 += d13;
                                        d14 += d12;
                                        d13 = -d13;
                                        d12 = -d12;
                                    }
                                }
                                if ((d12 * d8 - d13 * d9 > d5 || -(d12 * d8 - d13 * d9) > d5) && (d11 = ((d15 - d6) * d9 - (d14 - d7) * d8) / (d12 * d8 - d13 * d9)) > -d5 && d11 < 1.0 + d5 && (d10 = ((d14 - d7) * d13 - (d15 - d6) * d12) / (d13 * d9 - d12 * d8)) > -d5 && d10 < 1.0 + d5) {
                                    if (d11 > d5 && d11 < 1.0 - d5 && d10 > d5 && d10 < 1.0 - d5) {
                                        return true;
                                    }
                                    if ((!(d11 < d5) && !(d11 > 1.0 - d5) || !(d10 < d5) && !(d10 > 1.0 - d5)) && (d11 < d5 ? d8 * (d14 + d12 - d7) - d9 * (d15 + d13 - d6) > 0.0 : (d11 > 1.0 - d5 ? d8 * (d14 - d7) - d9 * (d15 - d6) > 0.0 : (d10 < d5 ? d13 * (d7 + d9 - d14) - d12 * (d6 + d8 - d15) > 0.0 : d10 > 1.0 - d5 && d13 * (d7 - d14) - d12 * (d6 - d15) > 0.0)))) {
                                        return true;
                                    }
                                }
                            }
                            ++n10;
                        }
                        ++n8;
                    }
                }
                ++n5;
            }
            ++n7;
        }
        return false;
    }

    public void reset() {
        this.stopAnimation();
        super.reset();
        if (this.m_geom != null && this.m_geomSave != null) {
            this.m_geom.copy((PsObject)this.m_geomSave);
            this.setGeometry(this.m_geom);
        }
    }

    public PwUnfold() {
        super(PsConfig.getMessage((int)48014));
        this.m_anim.setName(PsConfig.getMessage((int)54207));
        this.m_anim.addTimeListener((PsTimeListenerIf)this);
        this.m_anim.setTimeInterval(0.0, 100.0, 2.0, 4.0);
        this.m_anim.update((Object)this.m_anim);
        this.m_diamBB = new double[2];
        if (this.getClass() == (class$jvx$geom$PwUnfold != null ? class$jvx$geom$PwUnfold : (class$jvx$geom$PwUnfold = PwUnfold.class$("jvx.geom.PwUnfold")))) {
            this.init();
        }
    }

    public void flatten(double d) {
        int n;
        int n2;
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing Geometry. Set Geometry first.");
            return;
        }
        this.m_isFlat = d == 1.0;
        if (!this.m_isFlat && this.m_splice != null) {
            this.removeSplice();
            this.m_splice = null;
        }
        if (!this.m_isUnfold) {
            this.computeUnfolding();
            if (!this.m_bNoImprove) {
                boolean bl = this.m_isFlat;
                this.m_isFlat = true;
                if (this.m_geom.getNumElements() < 250) {
                    this.m_bUpdateWhileImprove = false;
                    this.improveUnfolding();
                    this.m_bUpdateWhileImprove = true;
                }
                this.m_isFlat = bl;
            }
            this.m_fixedElement = this.computeCenterElement();
        }
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray2 = this.m_geomSave.getVertices();
        PiVector[] piVectorArray2 = this.m_geomSave.getElements();
        int n3 = this.m_geom.getNumElements();
        int n4 = 0;
        while (n4 < n3) {
            n2 = 0;
            while (n2 < piVectorArray[n4].getSize()) {
                n = 0;
                do {
                    pdVectorArray[piVectorArray[n4].m_data[n2]].m_data[n] = pdVectorArray2[piVectorArray2[n4].m_data[n2]].m_data[n];
                } while (++n < 3);
                ++n2;
            }
            ++n4;
        }
        if (d == 0.0) {
            this.m_geom.makeElementNormals();
            this.m_geom.makeVertexNormals();
            return;
        }
        n4 = this.m_linTree.length - 1;
        int[] nArray = new int[this.m_geom.getNumVertices()];
        int n5 = 0;
        PiVector[] piVectorArray3 = this.m_geom.getNeighbours();
        Object object = new PdMatrix(4);
        PdMatrix pdMatrix = new PdMatrix(3);
        PdVector pdVector = new PdVector(3);
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        PdVector pdVector5 = new PdVector(0.0, 0.0, 1.0);
        int n6 = -1;
        int[] nArray2 = new int[n3];
        int n7 = 3;
        double d2 = 0.0;
        while (n4 >= 0) {
            double d3;
            PiVector piVector;
            int n8 = this.m_linTree[n4];
            int n9 = this.m_linTreeParent[n8];
            if (n9 == -1) {
                n6 = 0;
                nArray2[0] = n8;
                n7 = piVectorArray[n8].getSize();
                n2 = 0;
                while (n2 < n7) {
                    nArray[n5] = piVectorArray[n8].m_data[n2];
                    ++n5;
                    ++n2;
                }
                --n6;
                n2 = 0;
                while (n2 < n7) {
                    if (piVectorArray3[n8].m_data[n2] >= 0) {
                        nArray2[++n6] = piVectorArray3[n8].m_data[n2];
                    }
                    ++n2;
                }
                while (n6 >= 0) {
                    n8 = nArray2[n6];
                    n9 = this.m_linTreeParent[n8];
                    n7 = piVectorArray[n8].getSize();
                    n2 = (n9 + 3) % n7;
                    while (n2 != (n9 + 1) % n7) {
                        nArray[n5] = piVectorArray[n8].m_data[n2];
                        ++n5;
                        n2 = (n2 + 1) % n7;
                    }
                    --n6;
                    n2 = (n9 + 1) % n7;
                    while (n2 != n9 % n7) {
                        if (piVectorArray3[n8].m_data[n2] >= 0) {
                            nArray2[++n6] = piVectorArray3[n8].m_data[n2];
                        }
                        n2 = (n2 + 1) % n7;
                    }
                }
                n8 = this.m_linTree[n4];
                n9 = this.m_linTreeParent[n8];
                piVector = this.m_geom.getElement(this.m_linTree[n4]);
                this.normalOfElement(this.m_linTree[n4], pdVector);
                d3 = PdVector.angle((PdVector)pdVector, (PdVector)pdVector5);
                pdVector4.cross(pdVector, pdVector5);
                object = pdVector4.sqrLength() < 1.0E-10 ? null : PuReflect.rotateLine((PdVector)this.m_geom.getVertex(piVector.m_data[0]), (PdVector)pdVector4, (double)((d3 *= d) * Math.PI / 180.0));
                d2 = this.m_geom.getVertex((int)piVector.m_data[0]).m_data[2];
                double d4 = this.m_geomSave.getCenterOfGravity().m_data[2];
                if (object != null) {
                    n2 = 0;
                    while (n2 < n5) {
                        pdVector3 = this.m_geom.getVertex(nArray[n2]);
                        pdVector4.copy(pdVector3);
                        pdVector3.leftMultAffin(object, pdVector4, true);
                        pdVector3.m_data[2] = pdVector3.m_data[2] + d * (d4 - d2);
                        ++n2;
                    }
                } else {
                    n2 = 0;
                    while (n2 < n5) {
                        pdVector3 = this.m_geom.getVertex(nArray[n2]);
                        pdVector3.m_data[2] = pdVector3.m_data[2] + d * (d4 - d2);
                        ++n2;
                    }
                }
                --n4;
                n5 = 0;
                continue;
            }
            n6 = 0;
            nArray2[0] = n8;
            while (n6 >= 0) {
                n8 = nArray2[n6];
                n9 = this.m_linTreeParent[n8];
                n7 = piVectorArray[n8].getSize();
                n2 = (n9 + 3) % n7;
                while (n2 != (n9 + 1) % n7) {
                    nArray[n5] = piVectorArray[n8].m_data[n2];
                    ++n5;
                    n2 = (n2 + 1) % n7;
                }
                --n6;
                n2 = (n9 + 1) % n7;
                while (n2 != n9 % n7) {
                    if (piVectorArray3[n8].m_data[n2] >= 0) {
                        nArray2[++n6] = piVectorArray3[n8].m_data[n2];
                    }
                    n2 = (n2 + 1) % n7;
                }
            }
            n8 = this.m_linTree[n4];
            n9 = this.m_linTreeParent[n8];
            piVector = this.m_geom.getElement(this.m_linTree[n4]);
            n7 = piVector.getSize();
            n2 = this.m_linTreeParent[this.m_linTree[n4]];
            PiVector piVector2 = this.m_geom.getElement(piVectorArray3[this.m_linTree[n4]].m_data[n2]);
            if (piVector.m_data[(n2 + 1) % n7] == piVector2.m_data[(this.m_geom.getOppVertexLocInd(this.m_linTree[n4], n2) + 1) % piVector2.getSize()]) {
                this.normalOfElement(this.m_linTree[n4], pdVector);
                this.normalOfElement(piVectorArray3[this.m_linTree[n4]].m_data[n2], pdVector2);
                pdVector2.multScalar(-1.0);
            } else {
                this.normalOfElement(this.m_linTree[n4], pdVector);
                this.normalOfElement(piVectorArray3[this.m_linTree[n4]].m_data[n2], pdVector2);
            }
            d3 = PdVector.angle((PdVector)pdVector, (PdVector)pdVector2);
            d3 *= d;
            pdVector4.sub(this.m_geom.getVertex(piVector.m_data[(n2 + 2) % n7]), this.m_geom.getVertex(piVector.m_data[(n2 + 1) % n7]));
            pdMatrix.setColumn(0, pdVector4);
            pdMatrix.setColumn(1, pdVector);
            pdMatrix.setColumn(2, pdVector2);
            if (pdMatrix.det() < 0.0) {
                d3 = -d3;
            }
            pdVector4.sub(this.m_geom.getVertex(piVector.m_data[(n2 + 2) % n7]), this.m_geom.getVertex(piVector.m_data[(n2 + 1) % n7]));
            object = pdVector4.sqrLength() < 1.0E-10 ? null : PuReflect.rotateLine((PdVector)this.m_geom.getVertex(piVector.m_data[(n2 + 1) % n7]), (PdVector)pdVector4, (double)(d3 * Math.PI / 180.0));
            if (object != null) {
                n = 0;
                while (n < n5) {
                    pdVector3 = this.m_geom.getVertex(nArray[n]);
                    pdVector4.copy(pdVector3);
                    pdVector3.leftMultAffin(object, pdVector4, true);
                    ++n;
                }
            }
            --n4;
            n5 = 0;
        }
        n2 = 0;
        while (n2 < this.m_vertOfPolygons.length) {
            n = 0;
            while (n < this.m_vertOfPolygons[n2].length) {
                if (this.m_BBoxdata[n2][2] == 0.0) {
                    pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[0] = pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[0] + d * (this.m_translatePolygons[n2][0] - this.m_BBoxdata[n2][0]);
                    pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[1] = pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[1] + d * (this.m_translatePolygons[n2][1] - this.m_BBoxdata[n2][1]);
                } else {
                    double d5 = pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[0];
                    pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[0] = pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[0] + (d * (-pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[1] - pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[0]) + d * (this.m_translatePolygons[n2][0] + this.m_BBoxdata[n2][3]));
                    pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[1] = pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[1] + (d * (d5 - pdVectorArray[this.m_vertOfPolygons[n2][n]].m_data[1]) + d * (this.m_translatePolygons[n2][1] - this.m_BBoxdata[n2][0]));
                }
                ++n;
            }
            ++n2;
        }
        if (this.m_bFixElem && this.m_fixedElement >= 0 && this.m_fixedElement < n3) {
            this.fixElement(this.m_fixedElement);
        }
        this.m_geom.makeElementNormals();
        this.m_geom.makeVertexNormals();
    }

    public void setFixedElement(int n) {
        this.m_fixedElement = n;
    }

    public int getFixedElement() {
        return this.m_fixedElement;
    }

    private void fixElement(int n) {
        if (this.m_eq == null) {
            this.m_eq = new PdMatrix(9);
            this.m_tri = new PdVector(9);
            this.m_oriTri = new PdVector(9);
            this.m_trafo = new PdMatrix(3);
            this.m_trans = new PdVector(3);
        }
        int[] nArray = this.m_geom.getElement((int)n).m_data;
        int[] nArray2 = this.m_geomSave.getElement((int)n).m_data;
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PdVector[] pdVectorArray2 = this.m_geomSave.getVertices();
        double[] dArray = this.m_tri.m_data;
        double[] dArray2 = this.m_oriTri.m_data;
        int n2 = nArray.length - 1;
        PdVector pdVector = new PdVector(3);
        int n3 = 0;
        do {
            dArray[n3] = pdVectorArray[nArray[1]].m_data[n3] - pdVectorArray[nArray[0]].m_data[n3];
            dArray[n3 + 3] = pdVectorArray[nArray[n2]].m_data[n3] - pdVectorArray[nArray[0]].m_data[n3];
            dArray2[n3] = pdVectorArray2[nArray2[1]].m_data[n3] - pdVectorArray2[nArray2[0]].m_data[n3];
            dArray2[n3 + 3] = pdVectorArray2[nArray2[n2]].m_data[n3] - pdVectorArray2[nArray2[0]].m_data[n3];
        } while (++n3 < 3);
        pdVector.m_data[0] = dArray[1] * dArray[5] - dArray[2] * dArray[4];
        pdVector.m_data[1] = dArray[2] * dArray[3] - dArray[0] * dArray[5];
        pdVector.m_data[2] = dArray[0] * dArray[4] - dArray[1] * dArray[3];
        pdVector.normalize();
        n3 = 0;
        do {
            dArray[6 + n3] = pdVector.m_data[n3];
        } while (++n3 < 3);
        pdVector.m_data[0] = dArray2[1] * dArray2[5] - dArray2[2] * dArray2[4];
        pdVector.m_data[1] = dArray2[2] * dArray2[3] - dArray2[0] * dArray2[5];
        pdVector.m_data[2] = dArray2[0] * dArray2[4] - dArray2[1] * dArray2[3];
        pdVector.normalize();
        n3 = 0;
        do {
            dArray2[6 + n3] = pdVector.m_data[n3];
        } while (++n3 < 3);
        this.m_eq.setConstant(0.0);
        int n4 = 0;
        n3 = 0;
        while (n3 < 3) {
            this.m_eq.m_data[n3][0] = dArray[n4++];
            this.m_eq.m_data[n3][1] = dArray[n4++];
            this.m_eq.m_data[n3][2] = dArray[n4];
            ++n4;
            ++n3;
        }
        n4 = 0;
        n3 = 3;
        while (n3 < 6) {
            this.m_eq.m_data[n3][3] = dArray[n4++];
            this.m_eq.m_data[n3][4] = dArray[n4++];
            this.m_eq.m_data[n3][5] = dArray[n4];
            ++n4;
            ++n3;
        }
        n4 = 0;
        n3 = 6;
        while (n3 < 9) {
            this.m_eq.m_data[n3][6] = dArray[n4++];
            this.m_eq.m_data[n3][7] = dArray[n4++];
            this.m_eq.m_data[n3][8] = dArray[n4];
            ++n4;
            ++n3;
        }
        n3 = 0;
        do {
            dArray[n3] = dArray2[n3];
        } while (++n3 < 9);
        dArray2[1] = dArray[3];
        dArray2[2] = dArray[6];
        dArray2[3] = dArray[1];
        dArray2[5] = dArray[7];
        dArray2[6] = dArray[2];
        dArray2[7] = dArray[5];
        PnMatrix.invert(this.m_eq.m_data, this.m_eq.m_data, 9);
        this.m_tri.leftMultMatrix(this.m_eq, this.m_oriTri);
        double[][] dArray3 = this.m_trafo.m_data;
        int n5 = 0;
        n3 = 0;
        while (n3 < 3) {
            n4 = 0;
            do {
                dArray3[n3][n4] = dArray[n5++];
            } while (++n4 < 3);
            ++n3;
        }
        this.m_trans.copyArray(pdVectorArray[nArray[0]]);
        n4 = this.m_geom.getNumVertices();
        n3 = 0;
        while (n3 < n4) {
            pdVectorArray[n3].sub(this.m_trans);
            pdVector.copyArray(pdVectorArray[n3]);
            pdVectorArray[n3].leftMultMatrix(this.m_trafo, pdVector);
            pdVectorArray[n3].add(pdVectorArray2[nArray2[0]]);
            ++n3;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean resort(boolean var1_1) {
        var2_2 = this.m_geom.getNeighbours();
        var3_3 = this.m_geomSave.getNeighbours();
        var4_4 = 3;
        var5_5 = this.m_geom.getNumElements();
        var6_6 = new PdMatrix(2, 3);
        var7_7 = this.assureElemTreeTable();
        var14_8 = new int[var7_7];
        var7_7 = 0;
        while (var7_7 < var5_5) {
            v0 = this.m_elemTreeTable[var7_7];
            var14_8[v0] = var14_8[v0] + 1;
            ++var7_7;
        }
        var15_9 = 0;
        var16_10 = true;
        var8_11 = var14_8[0];
        var7_7 = 1;
        while (var7_7 < var14_8.length) {
            if (var14_8[var7_7] > var8_11) {
                var15_9 = var7_7;
                var8_11 = var14_8[var7_7];
            }
            ++var7_7;
        }
        var17_12 = new int[var5_5];
        var7_7 = 0;
        while (var7_7 < var5_5) {
            var17_12[this.m_linTree[var7_7]] = var7_7;
            ++var7_7;
        }
        var18_13 = -1;
        var19_14 = false;
        var20_15 = true;
        var21_16 = true;
        var22_17 = -1;
        var23_18 = -1;
        var24_19 = new int[]{-1, -1, -1, -1};
        var25_20 = 1;
        var26_21 = new int[6];
        var27_22 = new int[var5_5];
        var7_7 = 0;
        while (var7_7 < var5_5) {
            var27_22[var7_7] = var7_7;
            ++var7_7;
        }
        var12_23 = var5_5 / 2;
        var28_24 = new Random();
        var7_7 = 0;
        while (var7_7 < var12_23) {
            var8_11 = Math.abs(var28_24.nextInt()) % var5_5;
            var9_25 = Math.abs(var28_24.nextInt()) % var5_5;
            var10_26 = var27_22[var8_11];
            var27_22[var8_11] = var27_22[var9_25];
            var27_22[var9_25] = var10_26;
            ++var7_7;
        }
        var12_23 = 0;
        while (var12_23 < var5_5) {
            block48: {
                if (this.m_bStopImproving) {
                    return var16_10;
                }
                var7_7 = var27_22[var12_23];
                if (!var1_1 && this.m_elemTreeTable[var7_7] == var15_9) break block48;
                var4_4 = var2_2[var7_7].getSize();
                var8_11 = 0;
                while (var8_11 < var4_4) {
                    block49: {
                        block52: {
                            block53: {
                                block50: {
                                    if (var2_2[var7_7].m_data[var8_11] != -1 || var3_3[var7_7].m_data[var8_11] == -1 || this.m_elemTreeTable[var7_7] == this.m_elemTreeTable[var3_3[var7_7].m_data[var8_11]] || (var1_1 != false ? var14_8[this.m_elemTreeTable[var7_7]] < var14_8[this.m_elemTreeTable[var3_3[var7_7].m_data[var8_11]]] : var14_8[this.m_elemTreeTable[var7_7]] > var14_8[this.m_elemTreeTable[var3_3[var7_7].m_data[var8_11]]])) break block49;
                                    var6_6 = this.computeTrafo(var7_7, var8_11);
                                    var22_17 = var17_12[var3_3[var7_7].m_data[var8_11]];
                                    while (this.m_linTreeParent[this.m_linTree[var22_17]] != -1) {
                                        var22_17 = var17_12[var2_2[this.m_linTree[var22_17]].m_data[this.m_linTreeParent[this.m_linTree[var22_17]]]];
                                    }
                                    var23_18 = var22_17 + 1;
                                    while (var23_18 < var5_5 && this.m_linTreeParent[this.m_linTree[var23_18]] != -1) {
                                        ++var23_18;
                                    }
                                    --var23_18;
                                    if (var26_21.length < var4_4) {
                                        var26_21 = new int[var4_4];
                                    }
                                    var9_25 = 0;
                                    while (var9_25 < var4_4) {
                                        var26_21[var9_25] = var2_2[var7_7].m_data[var9_25];
                                        var2_2[var7_7].m_data[var9_25] = -1;
                                        ++var9_25;
                                    }
                                    if (!this.doIntersect(var17_12[var7_7], var17_12[var7_7], var6_6, var22_17, var23_18, null)) break block50;
                                    var9_25 = 0;
                                    while (var9_25 < var4_4) {
                                        var2_2[var7_7].m_data[var9_25] = var26_21[var9_25];
                                        ++var9_25;
                                    }
                                    break block49;
                                }
                                var9_25 = 0;
                                while (var9_25 < var4_4) {
                                    var2_2[var7_7].m_data[var9_25] = var26_21[var9_25];
                                    ++var9_25;
                                }
                                var25_20 = 1;
                                var9_25 = 0;
                                while (var9_25 < var4_4) {
                                    block51: {
                                        if (var2_2[var7_7].m_data[var9_25] == -1) break block51;
                                        this.getSubComponent(var2_2[var7_7].m_data[var9_25], var7_7, var24_19);
                                        var20_15 = this.doIntersect(var17_12[var24_19[0]], var17_12[var24_19[1]], var6_6, var22_17, var23_18, null);
                                        var21_16 = var24_19[2] >= 0 && var24_19[3] >= 0 ? this.doIntersect(var17_12[var24_19[2]], var17_12[var24_19[3]], var6_6, var22_17, var23_18, null) : false;
                                        if (!var20_15 && !var21_16) ** GOTO lbl110
                                        if (var18_13 == -1) {
                                            var18_13 = var9_25;
                                        } else {
                                            var19_14 = true;
                                            break;
lbl110:
                                            // 1 sources

                                            if (var1_1) {
                                                var25_20 = var24_19[2] >= 0 && var24_19[3] >= 0 ? (var25_20 += var17_12[var24_19[1]] - var17_12[var24_19[0]] + var17_12[var24_19[3]] - var17_12[var24_19[2]]) : (var25_20 += var17_12[var24_19[1]] - var17_12[var24_19[0]]);
                                                if (var14_8[this.m_elemTreeTable[var7_7]] - 2 * var25_20 < var14_8[this.m_elemTreeTable[var3_3[var7_7].m_data[var8_11]]]) {
                                                    if (var18_13 == -1) {
                                                        var18_13 = var9_25;
                                                    } else {
                                                        var19_14 = true;
                                                        break;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    ++var9_25;
                                }
                                if (var19_14) break block52;
                                if (var18_13 == -1) break block53;
                                var29_29 = var7_7;
                                var30_30 = var2_2[var7_7].m_data[var18_13];
                                var31_31 = var18_13;
                                var32_32 = -1;
                                var33_33 = this.m_geom.getOppVertexLocInd(var7_7, var18_13);
                                var34_34 = false;
                                var4_4 = var2_2[var30_30].getSize();
                                while (!var34_34) {
                                    if (var26_21.length < var4_4) {
                                        var26_21 = new int[var4_4];
                                    }
                                    var9_25 = 0;
                                    while (var9_25 < var4_4) {
                                        var26_21[var9_25] = var2_2[var30_30].m_data[var9_25];
                                        var2_2[var30_30].m_data[var9_25] = -1;
                                        ++var9_25;
                                    }
                                    if (this.doIntersect(var17_12[var30_30], var17_12[var30_30], var6_6, var22_17, var23_18, null)) {
                                        var9_25 = 0;
                                        while (var9_25 < var4_4) {
                                            var2_2[var30_30].m_data[var9_25] = var26_21[var9_25];
                                            ++var9_25;
                                        }
                                        var34_34 = true;
                                        continue;
                                    }
                                    var9_25 = 0;
                                    while (var9_25 < var4_4) {
                                        var2_2[var30_30].m_data[var9_25] = var26_21[var9_25];
                                        ++var9_25;
                                    }
                                    var9_25 = 0;
                                    while (var9_25 < var4_4) {
                                        block54: {
                                            if (var9_25 == var33_33 || var2_2[var30_30].m_data[var9_25] == -1) break block54;
                                            this.getSubComponent(var2_2[var30_30].m_data[var9_25], var30_30, var24_19);
                                            var20_15 = this.doIntersect(var17_12[var24_19[0]], var17_12[var24_19[1]], var6_6, var22_17, var23_18, null);
                                            var21_16 = var24_19[2] >= 0 && var24_19[3] >= 0 ? this.doIntersect(var17_12[var24_19[2]], var17_12[var24_19[3]], var6_6, var22_17, var23_18, null) : false;
                                            if (!var20_15 && !var21_16) ** GOTO lbl164
                                            if (var32_32 == -1) {
                                                var32_32 = var9_25;
                                            } else {
                                                var34_34 = true;
                                                break;
lbl164:
                                                // 1 sources

                                                if (var1_1) {
                                                    var25_20 = var24_19[2] >= 0 && var24_19[3] >= 0 ? (var25_20 += var17_12[var24_19[1]] - var17_12[var24_19[0]] + var17_12[var24_19[3]] - var17_12[var24_19[2]]) : (var25_20 += var17_12[var24_19[1]] - var17_12[var24_19[0]]);
                                                    if (var14_8[this.m_elemTreeTable[var7_7]] - 2 * var25_20 < var14_8[this.m_elemTreeTable[var3_3[var7_7].m_data[var8_11]]]) {
                                                        if (var32_32 == -1) {
                                                            var32_32 = var9_25;
                                                        } else {
                                                            var34_34 = true;
                                                            break;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        ++var9_25;
                                    }
                                    if (var34_34) continue;
                                    if (var32_32 != -1) {
                                        var33_33 = this.m_geom.getOppVertexLocInd(var30_30, var32_32);
                                        var29_29 = var30_30;
                                        var31_31 = var32_32;
                                        var30_30 = var2_2[var29_29].m_data[var31_31];
                                        var32_32 = -1;
                                        var4_4 = var2_2[var30_30].getSize();
                                        continue;
                                    }
                                    var34_34 = true;
                                }
                                if (!var1_1) {
                                    this.moveComponent(var7_7, var8_11, var29_29, var31_31, var6_6, var17_12);
                                    var16_10 = false;
                                    this.assureElemTreeTable();
                                    var11_27 = 0;
                                    while (var11_27 < var5_5) {
                                        var17_12[this.m_linTree[var11_27]] = var11_27;
                                        ++var11_27;
                                    }
                                    var11_27 = 0;
                                    while (var11_27 < var14_8.length) {
                                        var14_8[var11_27] = 0;
                                        ++var11_27;
                                    }
                                    var11_27 = 0;
                                    while (var11_27 < var5_5) {
                                        v1 = this.m_elemTreeTable[var11_27];
                                        var14_8[v1] = var14_8[v1] + 1;
                                        ++var11_27;
                                    }
                                } else {
                                    this.getSubComponent(var29_29, var2_2[var29_29].m_data[var31_31], var24_19);
                                    var13_28 = var24_19[2] >= 0 && var24_19[3] >= 0 ? var17_12[var24_19[1]] - var17_12[var24_19[0]] + var17_12[var24_19[3]] - var17_12[var24_19[2]] + 1 : var17_12[var24_19[1]] - var17_12[var24_19[0]] + 1;
                                    if (var14_8[this.m_elemTreeTable[var7_7]] - 2 * var13_28 > var14_8[this.m_elemTreeTable[var3_3[var7_7].m_data[var8_11]]]) {
                                        this.moveComponent(var7_7, var8_11, var29_29, var31_31, var6_6, var17_12);
                                        var16_10 = false;
                                        this.assureElemTreeTable();
                                        var11_27 = 0;
                                        while (var11_27 < var5_5) {
                                            var17_12[this.m_linTree[var11_27]] = var11_27;
                                            ++var11_27;
                                        }
                                        var11_27 = 0;
                                        while (var11_27 < var14_8.length) {
                                            var14_8[var11_27] = 0;
                                            ++var11_27;
                                        }
                                        var11_27 = 0;
                                        while (var11_27 < var5_5) {
                                            v2 = this.m_elemTreeTable[var11_27];
                                            var14_8[v2] = var14_8[v2] + 1;
                                            ++var11_27;
                                        }
                                    }
                                }
                                break block52;
                            }
                            this.moveTree(var7_7, var8_11, var6_6);
                            var16_10 = false;
                            this.assureElemTreeTable();
                            var11_27 = 0;
                            while (var11_27 < var5_5) {
                                var17_12[this.m_linTree[var11_27]] = var11_27;
                                ++var11_27;
                            }
                            var11_27 = 0;
                            while (var11_27 < var14_8.length) {
                                var14_8[var11_27] = 0;
                                ++var11_27;
                            }
                            var11_27 = 0;
                            while (var11_27 < var5_5) {
                                v3 = this.m_elemTreeTable[var11_27];
                                var14_8[v3] = var14_8[v3] + 1;
                                ++var11_27;
                            }
                        }
                        var18_13 = -1;
                        var19_14 = false;
                        break;
                    }
                    ++var8_11;
                }
            }
            ++var12_23;
        }
        return var16_10;
    }

    protected int assureElemTreeTable() {
        this.rebuildLinTreeDepthFirst();
        if (this.m_elemTreeTable == null || this.m_elemTreeTable.length != this.m_linTree.length) {
            this.m_elemTreeTable = new int[this.m_linTree.length];
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.m_linTree.length) {
            if (this.m_linTreeParent[this.m_linTree[n2]] == -1) {
                // empty if block
            }
            this.m_elemTreeTable[this.m_linTree[n2]] = ++n;
            ++n2;
        }
        return n + 1;
    }

    protected void rebuildLinTreeBreadthFirst() {
        int n = this.m_geom.getNumElements();
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            blArray[n2] = false;
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        PiVector[] piVectorArray = this.m_geom.getNeighbours();
        int n6 = 0;
        while (n3 < n) {
            n6 = n3;
            while (this.m_linTreeParent[n6] != -1) {
                n6 = piVectorArray[n6].m_data[this.m_linTreeParent[n6]];
            }
            this.m_linTree[n5] = n6;
            blArray[n6] = true;
            ++n5;
            while (n4 != n5) {
                int n7 = piVectorArray[this.m_linTree[n4]].m_data.length;
                n2 = 0;
                while (n2 < n7) {
                    if (piVectorArray[this.m_linTree[n4]].m_data[n2] != -1 && n2 != this.m_linTreeParent[this.m_linTree[n4]]) {
                        this.m_linTree[n5] = piVectorArray[this.m_linTree[n4]].m_data[n2];
                        blArray[piVectorArray[this.m_linTree[n4]].m_data[n2]] = true;
                        ++n5;
                    }
                    ++n2;
                }
                ++n4;
            }
            while (n3 < n && blArray[n3]) {
                ++n3;
            }
        }
    }

    protected PdMatrix computeTrafo(int n, int n2) {
        PdMatrix pdMatrix = new PdMatrix(2, 3);
        return this.computeTrafo(n, n2, pdMatrix);
    }

    protected PdMatrix computeTrafo(int n, int n2, PdMatrix pdMatrix) {
        PdVector pdVector;
        double d;
        PdVector pdVector2;
        if (this.m_geom.getNeighbour((int)n).m_data[n2] != -1) {
            return null;
        }
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        int n3 = this.m_geomSave.getNeighbour((int)n).m_data[n2];
        int n4 = piVectorArray[n].getSize();
        int n5 = piVectorArray[n3].getSize();
        int n6 = this.m_geomSave.getOppVertexLocInd(n, n2);
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = false;
        if (this.m_geomSave.getElement((int)n).m_data[(n2 + 1) % n4] == this.m_geomSave.getElement((int)n3).m_data[(n6 + 1) % n5]) {
            d2 = pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]].m_data[0] - pdVectorArray[piVectorArray[n].m_data[(n2 + 2) % n4]].m_data[0];
            d3 = pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]].m_data[1] - pdVectorArray[piVectorArray[n].m_data[(n2 + 2) % n4]].m_data[1];
            pdVector2 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray[n].m_data[(n2 + 2) % n4]], (PdVector)pdVectorArray[piVectorArray[n].m_data[(n2 + 1) % n4]]);
            PdVector pdVector3 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]], (PdVector)pdVectorArray[piVectorArray[n3].m_data[(n6 + 1) % n5]]);
            d = PdVector.angleWithOrientation((PdVector)pdVector2, (PdVector)pdVector3, (PdVector)new PdVector(0.0, 0.0, 1.0));
            pdVector = new PdVector(3);
            PdVector pdVector4 = new PdVector(3);
            pdVector.normalOfPlane(pdVectorArray[piVectorArray[n].m_data[n2]], pdVectorArray[piVectorArray[n].m_data[(n2 + 1) % n4]], pdVectorArray[piVectorArray[n].m_data[(n2 + 2) % n4]]);
            pdVector4.normalOfPlane(pdVectorArray[piVectorArray[n3].m_data[n6]], pdVectorArray[piVectorArray[n3].m_data[(n6 + 1) % n5]], pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]]);
            if (PdVector.dot((PdVector)pdVector, (PdVector)pdVector4) > 0.0) {
                bl = true;
            }
        } else {
            d2 = pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]].m_data[0] - pdVectorArray[piVectorArray[n].m_data[(n2 + 1) % n4]].m_data[0];
            d3 = pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]].m_data[1] - pdVectorArray[piVectorArray[n].m_data[(n2 + 1) % n4]].m_data[1];
            pdVector2 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray[n].m_data[(n2 + 1) % n4]], (PdVector)pdVectorArray[piVectorArray[n].m_data[(n2 + 2) % n4]]);
            PdVector pdVector5 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]], (PdVector)pdVectorArray[piVectorArray[n3].m_data[(n6 + 1) % n5]]);
            d = PdVector.angleWithOrientation((PdVector)pdVector2, (PdVector)pdVector5, (PdVector)new PdVector(0.0, 0.0, 1.0));
            pdVector = new PdVector(3);
            PdVector pdVector6 = new PdVector(3);
            pdVector.normalOfPlane(pdVectorArray[piVectorArray[n].m_data[n2]], pdVectorArray[piVectorArray[n].m_data[(n2 + 1) % n4]], pdVectorArray[piVectorArray[n].m_data[(n2 + 2) % n4]]);
            pdVector6.normalOfPlane(pdVectorArray[piVectorArray[n3].m_data[n6]], pdVectorArray[piVectorArray[n3].m_data[(n6 + 1) % n5]], pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]]);
            if (PdVector.dot((PdVector)pdVector, (PdVector)pdVector6) < 0.0) {
                bl = true;
            }
        }
        double d4 = Math.cos(d);
        double d5 = Math.sin(d);
        PdVector pdVector7 = pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]];
        if (pdMatrix == null || pdMatrix.getISize() < 2 || pdMatrix.getJSize() < 3) {
            pdMatrix = new PdMatrix(2, 3);
        }
        pdMatrix.m_data[0][0] = d4;
        pdMatrix.m_data[0][1] = -d5;
        pdMatrix.m_data[0][2] = pdVector7.m_data[0] - d4 * (pdVector7.m_data[0] - d2) + d5 * (pdVector7.m_data[1] - d3);
        pdMatrix.m_data[1][0] = d5;
        pdMatrix.m_data[1][1] = d4;
        pdMatrix.m_data[1][2] = pdVector7.m_data[1] - d5 * (pdVector7.m_data[0] - d2) - d4 * (pdVector7.m_data[1] - d3);
        if (bl) {
            PdVector pdVector8 = PdVector.subNew((PdVector)pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]], (PdVector)pdVectorArray[piVectorArray[n3].m_data[(n6 + 1) % n5]]);
            double d6 = pdVector8.m_data[0];
            pdVector8.m_data[0] = -pdVector8.m_data[1];
            pdVector8.m_data[1] = d6;
            pdVector8.m_data[2] = 0.0;
            pdVector8.normalize();
            double d7 = pdVector8.m_data[0];
            double d8 = pdVector8.m_data[1];
            d6 = PdVector.dot((PdVector)pdVectorArray[piVectorArray[n3].m_data[(n6 + 2) % n5]], (PdVector)pdVector8);
            double d9 = pdMatrix.m_data[0][0];
            double d10 = pdMatrix.m_data[0][1];
            double d11 = pdMatrix.m_data[0][2];
            double d12 = pdMatrix.m_data[1][0];
            double d13 = pdMatrix.m_data[1][1];
            double d14 = pdMatrix.m_data[1][2];
            pdMatrix.m_data[0][0] = (1.0 - 2.0 * d7 * d7) * d9 - 2.0 * d8 * d7 * d12;
            pdMatrix.m_data[0][1] = (1.0 - 2.0 * d7 * d7) * d10 - 2.0 * d8 * d7 * d13;
            pdMatrix.m_data[0][2] = (1.0 - 2.0 * d7 * d7) * d11 - 2.0 * d8 * d7 * d14 + 2.0 * d6 * d7;
            pdMatrix.m_data[1][0] = -2.0 * d7 * d8 * d9 + (1.0 - 2.0 * d8 * d8) * d12;
            pdMatrix.m_data[1][1] = -2.0 * d7 * d8 * d10 + (1.0 - 2.0 * d8 * d8) * d13;
            pdMatrix.m_data[1][2] = -2.0 * d7 * d8 * d11 + (1.0 - 2.0 * d8 * d8) * d14 + 2.0 * d6 * d8;
        }
        return pdMatrix;
    }

    public boolean isShowingSplices() {
        return this.m_showSplice;
    }

    public void showSplices(boolean bl) {
        this.m_showSplice = bl;
        if (this.m_showSplice) {
            this.showSplices();
            return;
        }
        this.removeSplice();
    }

    public void dragDisplay(PvPickEvent pvPickEvent) {
        this.pickDisplay(pvPickEvent);
    }

    protected void showSplices() {
        if (this.m_isFlat && this.m_showSplice) {
            if (this.m_splice == null) {
                this.m_splice = new PgElementSet(3);
                this.m_splice.setName(PsConfig.getMessage((int)45049));
                this.m_splice.setGlobalElementColor(Color.magenta);
                this.m_splice.setGlobalElementBackColor(Color.magenta);
                if (this.m_bFixElem) {
                    int n = this.m_fixedElement;
                    this.m_fixedElement = -1;
                    this.flatten(1.0);
                    this.computeSplices();
                    this.m_fixedElement = n;
                    this.flatten(1.0);
                    this.transformSplice();
                } else {
                    this.computeSplices();
                }
                Enumeration enumeration = this.m_geom.getDisplayList().elements();
                while (enumeration.hasMoreElements()) {
                    PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
                    pvDisplayIf.addGeometry((PgGeometryIf)this.m_splice);
                }
            } else {
                if (this.m_bFixElem) {
                    int n = this.m_fixedElement;
                    this.m_fixedElement = -1;
                    this.flatten(1.0);
                    this.computeSplices();
                    this.m_fixedElement = n;
                    this.flatten(1.0);
                    this.transformSplice();
                } else {
                    this.computeSplices();
                }
                if (!this.m_splice.isVisible()) {
                    this.m_splice.setVisible(true);
                }
            }
            this.m_splice.update((Object)this.m_splice);
            return;
        }
        if (this.m_splice != null && this.m_splice.isVisible()) {
            this.m_splice.setVisible(false);
            this.m_splice.update((Object)this.m_splice);
            return;
        }
    }

    protected void colorPieces() {
        int n = this.assureElemTreeTable();
        int n2 = (int)Math.ceil((float)n / 8.0f);
        int[][] nArrayArray = new int[9][];
        int[] nArray = new int[3];
        nArray[0] = 255;
        nArray[1] = 255;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 255;
        nArrayArray[1] = nArray2;
        nArrayArray[2] = new int[]{255, 175, 175};
        int[] nArray3 = new int[3];
        nArray3[1] = 255;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = 255;
        nArray4[2] = 255;
        nArrayArray[4] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[1] = 255;
        nArray5[2] = 255;
        nArrayArray[5] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[2] = 255;
        nArrayArray[6] = nArray6;
        int[] nArray7 = new int[3];
        nArray7[0] = 255;
        nArray7[1] = 200;
        nArrayArray[7] = nArray7;
        int[] nArray8 = new int[3];
        nArray8[0] = 255;
        nArrayArray[8] = nArray8;
        int[][] nArrayArray2 = nArrayArray;
        int n3 = 0;
        while (n3 < this.m_elemTreeTable.length) {
            int n4 = this.m_elemTreeTable[n3] / n2;
            double d = (double)(this.m_elemTreeTable[n3] % n2) / (double)n2;
            int n5 = (int)((double)nArrayArray2[n4][0] * d + (1.0 - d) * (double)nArrayArray2[n4 + 1][0]);
            int n6 = (int)((double)nArrayArray2[n4][1] * d + (1.0 - d) * (double)nArrayArray2[n4 + 1][1]);
            int n7 = (int)((double)nArrayArray2[n4][2] * d + (1.0 - d) * (double)nArrayArray2[n4 + 1][2]);
            this.m_geom.setElementColor(n3, new Color(n5, n6, n7));
            ++n3;
        }
    }

    public void ok() {
        this.stopAnimation();
        super.ok();
    }

    public void pickDisplay(PvPickEvent pvPickEvent) {
    }

    protected void removeSplice() {
        if (this.m_splice == null) {
            return;
        }
        Enumeration enumeration = this.m_splice.getDisplayList().elements();
        while (enumeration.hasMoreElements()) {
            PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
            pvDisplayIf.removeGeometry((PgGeometryIf)this.m_splice);
            pvDisplayIf.update((Object)pvDisplayIf);
        }
        this.m_splice = null;
    }
}

