/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.BitSet;
import jv.geom.PgElementSet;
import jv.loader.PgLoaderIf;
import jv.loader.PvDisplayOption;
import jv.object.PsDebug;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.loader.PgMacroPatch;

public final class PgBdLoader
implements PgLoaderIf {
    protected String m_task;
    protected int m_startFrame;
    protected int m_endFrame;
    protected int m_numIntegerParms;
    protected int m_numDoubleParms;
    protected int m_numPatches;
    protected int m_numVertices;
    protected PdVector[] m_vertex;
    protected PiVector[] m_vertexType;
    protected PgMacroPatch[] m_patch;
    protected boolean m_bIsAnimation = false;
    protected PgElementSet[] m_elemArr;
    protected PgJvxSrc[] m_geomArr;
    protected PgJvxSrc[][] m_animArr;

    public void setGeometryOption(BitSet bitSet) {
    }

    public boolean isEnabledOptimization() {
        return false;
    }

    protected boolean parse(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing argumnt");
            return false;
        }
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.whitespaceChars(59, 59);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        try {
            int n;
            if (this.nextToken(streamTokenizer) != -3) {
                PsDebug.warning((String)"failed reading m_task");
                return false;
            }
            this.m_task = new String(streamTokenizer.sval);
            if (this.nextToken(streamTokenizer) != -2) {
                PsDebug.warning((String)"failed reading m_startFrame");
                return false;
            }
            this.m_startFrame = (int)streamTokenizer.nval;
            if (this.nextToken(streamTokenizer) != -2) {
                PsDebug.warning((String)"failed reading m_endFrame");
                return false;
            }
            this.m_endFrame = (int)streamTokenizer.nval;
            if (this.nextToken(streamTokenizer) != -2) {
                PsDebug.warning((String)"failed reading m_numIntegerParms");
                return false;
            }
            this.m_numIntegerParms = (int)streamTokenizer.nval;
            if (this.nextToken(streamTokenizer) != -2) {
                PsDebug.warning((String)"failed reading m_numDoubleParms");
                return false;
            }
            this.m_numDoubleParms = (int)streamTokenizer.nval;
            if (this.nextToken(streamTokenizer) != -2) {
                PsDebug.warning((String)"failed reading numPatches");
                return false;
            }
            this.m_numPatches = (int)streamTokenizer.nval;
            this.m_patch = new PgMacroPatch[this.m_numPatches];
            if (this.nextToken(streamTokenizer) != -2) {
                PsDebug.warning((String)"Number expected");
                return false;
            }
            this.m_numVertices = (int)streamTokenizer.nval;
            this.m_vertexType = new PiVector[this.m_numVertices];
            this.m_vertex = new PdVector[this.m_numVertices];
            int n2 = 0;
            while (n2 < this.m_numVertices) {
                this.m_vertexType[n2] = new PiVector(3);
                this.m_vertex[n2] = new PdVector(3);
                n = 0;
                do {
                    if (this.nextToken(streamTokenizer) != -2) {
                        PsDebug.warning((String)("failed reading m_vertexType[" + n2 + "].m_data[" + n + "]"));
                        return false;
                    }
                    this.m_vertexType[n2].m_data[n] = (int)streamTokenizer.nval;
                } while (++n < 3);
                n = 0;
                do {
                    if (this.nextToken(streamTokenizer) != -2) {
                        PsDebug.warning((String)("failed reading m_vertex[" + n2 + "].m_data[" + n + "]"));
                        return false;
                    }
                    this.m_vertex[n2].m_data[n] = streamTokenizer.nval;
                } while (++n < 3);
                ++n2;
            }
            n2 = 0;
            while (n2 < this.m_numPatches) {
                int n3;
                int n4;
                String string;
                this.m_patch[n2] = new PgMacroPatch(3);
                this.m_patch[n2].setVertexType(this.m_vertexType);
                this.m_patch[n2].setVertex(this.m_vertex);
                if (this.nextToken(streamTokenizer) != -2) {
                    PsDebug.warning((String)("error reading orientation in patch[" + n2 + "]"));
                    return false;
                }
                this.m_patch[n2].setOrientation((int)streamTokenizer.nval);
                if (this.nextToken(streamTokenizer) != -2) {
                    PsDebug.warning((String)("error reading bndType in patch[" + n2 + "]"));
                    return false;
                }
                this.m_patch[n2].setBndType((int)streamTokenizer.nval);
                if (this.nextToken(streamTokenizer) != -2) {
                    PsDebug.warning((String)("error reading patchLength in patch[" + n2 + "]"));
                    return false;
                }
                this.m_patch[n2].setNumVertices((int)streamTokenizer.nval);
                int n5 = this.m_patch[n2].getNumVertices();
                int n6 = 0;
                while (n6 < n5) {
                    if (this.nextToken(streamTokenizer) != -2) {
                        PsDebug.warning((String)("error reading element[" + n6 + "] in patch[" + n2 + "]"));
                        return false;
                    }
                    this.m_patch[n2].m_element.m_data[n6] = (int)streamTokenizer.nval;
                    ++n6;
                }
                if (this.nextToken(streamTokenizer) != -2) {
                    PsDebug.warning((String)("error reading numULines in patch[" + n2 + "]"));
                    return false;
                }
                this.m_patch[n2].m_numULines = (int)streamTokenizer.nval;
                if (this.nextToken(streamTokenizer) != -2) {
                    PsDebug.warning((String)("error reading numVLines in patch[" + n2 + "]"));
                    return false;
                }
                this.m_patch[n2].m_numVLines = (int)streamTokenizer.nval;
                if (this.nextToken(streamTokenizer) != -2) {
                    PsDebug.warning((String)("error reading numUSubs in patch[" + n2 + "]"));
                    return false;
                }
                this.m_patch[n2].m_numUSubs = (int)streamTokenizer.nval;
                if (this.nextToken(streamTokenizer) != -2) {
                    PsDebug.warning((String)("error reading numVSubs in patch[" + n2 + "]"));
                    return false;
                }
                this.m_patch[n2].m_numVSubs = (int)streamTokenizer.nval;
                if (this.m_patch[n2].getBndType() == 1) {
                    n6 = 0;
                    while (n6 < n5) {
                        if (this.nextToken(streamTokenizer) != -2) {
                            PsDebug.warning((String)("error reading bndShape[" + n6 + "][0] in patch[" + n2 + "]"));
                            return false;
                        }
                        string = Integer.toString((int)streamTokenizer.nval);
                        n4 = Integer.parseInt(string, 8);
                        string = Integer.toBinaryString(n4);
                        n3 = string.length();
                        n = 0;
                        while (n < n3) {
                            if (string.charAt(n3 - 1 - n) == '1') {
                                this.m_patch[n2].m_bndShapeBits[n6].set(n);
                            } else {
                                this.m_patch[n2].m_bndShapeBits[n6].clear(n);
                            }
                            ++n;
                        }
                        if (this.nextToken(streamTokenizer) != -2) {
                            PsDebug.warning((String)("error reading bndShape[" + n6 + "][" + 0 + "] in patch[" + n2 + "]"));
                            return false;
                        }
                        this.m_patch[n2].m_bndShape[n6].m_data[0] = (int)streamTokenizer.nval;
                        if (!this.m_patch[n2].m_bndShapeBits[n6].get(7) || this.m_patch[n2].m_bndShapeBits[n6].get(7) && this.m_patch[n2].m_bndShapeBits[n6].get(5)) {
                            n = 1;
                            do {
                                if (this.nextToken(streamTokenizer) != -2) {
                                    PsDebug.warning((String)("error reading bndShape[" + n6 + "][" + n + "] in patch[" + n2 + "]"));
                                    return false;
                                }
                                this.m_patch[n2].m_bndShape[n6].m_data[n] = (int)streamTokenizer.nval;
                            } while (++n < 3);
                        }
                        ++n6;
                    }
                } else {
                    n6 = 0;
                    while (n6 < n5) {
                        string = Integer.toString(220);
                        n4 = Integer.parseInt(string, 8);
                        string = Integer.toBinaryString(n4);
                        n3 = string.length();
                        n = 0;
                        while (n < n3) {
                            if (string.charAt(n3 - 1 - n) == '1') {
                                this.m_patch[n2].m_bndShapeBits[n6].set(n);
                            } else {
                                this.m_patch[n2].m_bndShapeBits[n6].clear(n);
                            }
                            ++n;
                        }
                        ++n6;
                    }
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            PsDebug.warning((String)("Exception thrown = " + iOException.toString() + "\n\tparsing broke abnormally in line=" + streamTokenizer.lineno() + ",\n\treading st.sval=" + streamTokenizer.sval + ",\n\tst.ttype=" + streamTokenizer.ttype));
            return false;
        }
        return true;
    }

    public PgElementSet[] readElementSet(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        boolean bl = this.parse(bufferedReader);
        if (!bl) {
            PsDebug.warning((String)"error during parsing of reader");
            return null;
        }
        PgElementSet pgElementSet = new PgElementSet(3);
        int n = 0;
        while (n < this.getNumPatches()) {
            PgMacroPatch pgMacroPatch = this.getPatch(n);
            PgElementSet pgElementSet2 = new PgElementSet(3);
            pgElementSet2 = pgMacroPatch.buildElementSet(pgElementSet2);
            if (this.getNumPatches() == 1) {
                return new PgElementSet[]{pgElementSet2};
            }
            pgElementSet.merge((PgGeometryIf)pgElementSet2);
            ++n;
        }
        pgElementSet.close();
        this.m_elemArr = new PgElementSet[]{pgElementSet};
        return this.m_elemArr;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int nextToken(StreamTokenizer streamTokenizer) throws IOException {
        block6: while (true) {
            switch (streamTokenizer.nextToken()) {
                case 10: {
                    continue block6;
                }
                case -3: {
                    return -3;
                }
                case -2: {
                    return -2;
                }
                case -1: {
                    return -1;
                }
            }
            PsDebug.warning((String)"token not identified");
        }
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        this.m_elemArr = this.readElementSet(bufferedReader);
        if (this.m_elemArr == null) {
            PsDebug.warning((String)"error during parsing.");
            return null;
        }
        PgJvxSrc[] pgJvxSrcArray = new PgJvxSrc[this.m_elemArr.length];
        int n = 0;
        while (n < this.m_elemArr.length) {
            pgJvxSrcArray[n] = this.m_elemArr[n].getJvx();
            ++n;
        }
        return pgJvxSrcArray;
    }

    public PgJvxSrc[][] getAnimations() {
        return this.m_animArr;
    }

    public PgJvxSrc[] getGeometries() {
        return this.m_geomArr;
    }

    public PvDisplayOption getDisplayOption() {
        return null;
    }

    public void setDisplayOption(PvDisplayOption pvDisplayOption) {
    }

    public void setAnimation(boolean bl) {
        this.m_bIsAnimation = bl;
    }

    public PgMacroPatch getPatch(int n) {
        if (this.m_patch == null) {
            PsDebug.warning((String)"m_Patch==null");
            return null;
        }
        if (n < 0 || this.m_patch.length <= n) {
            PsDebug.warning((String)"index out of range");
            return null;
        }
        return this.m_patch[n];
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        PsDebug.error((String)"method not implemented yet.");
        return false;
    }

    public boolean load(BufferedReader bufferedReader) {
        this.m_geomArr = this.read(bufferedReader);
        return this.m_geomArr != null;
    }

    public int getNumPatches() {
        return this.m_numPatches;
    }

    public boolean isAnimation() {
        return this.m_bIsAnimation;
    }

    public PgGeometryIf[] getSpecializedGeometries() {
        return this.m_elemArr;
    }
}

