/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.BitSet;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import jv.loader.PgLoader;
import jv.loader.PgLoaderIf;
import jv.loader.PvDisplayOption;
import jv.number.PdColor;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgFeLoader
implements PgLoaderIf {
    private static final int MESH_EDGE = 1;
    private static final int MESH_SIMPLEX = 2;
    private static final int ITEM_MODE_NONE = 1;
    private static final int ITEM_MODE_VERTEX = 2;
    private static final int ITEM_MODE_EDGE = 3;
    private static final int ITEM_MODE_FACE = 4;
    private static final int ITEM_MODE_BODY = 5;
    protected int m_meshType;
    protected int m_meshRepresentation;
    protected int m_dimOfVertices = -1;
    protected int m_numVertices = 0;
    protected Vector m_vVertex;
    protected int m_numEdges = 0;
    protected Vector m_vEdge;
    protected Vector m_vEdgeColor;
    protected int m_dimOfElements = -1;
    protected int m_numElements = 0;
    protected Vector m_vElement;
    protected int m_numTetras = 0;
    protected Vector m_vTetra;
    protected boolean m_bLinear = false;
    protected double m_scale = 1.0;
    protected double m_totalTime = -1.0;
    protected PdMatrix m_viewMat = null;
    protected boolean m_bIsAnimation = false;
    protected PgJvxSrc[] m_geomArr;
    protected PgJvxSrc[][] m_animArr;

    public void setGeometryOption(BitSet bitSet) {
    }

    public boolean isEnabledOptimization() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean parse(BufferedReader var1_1, PgJvxSrc var2_2) {
        block81: {
            var3_3 = 4;
            var4_4 = 200;
            var5_5 = new double[var3_3];
            var6_6 = new int[var4_4];
            this.m_vVertex = new Vector<E>();
            this.m_vEdge = new Vector<E>();
            this.m_vElement = new Vector<E>();
            this.m_vTetra = new Vector<E>();
            this.m_dimOfVertices = 3;
            this.m_meshType = 33;
            this.m_meshRepresentation = 1;
            this.m_numVertices = 0;
            this.m_numEdges = 0;
            this.m_numElements = 0;
            this.m_numTetras = 0;
            var10_7 = 0;
            var11_8 = 0;
            var12_9 = 0;
            var13_10 = 0;
            var14_11 = null;
            var15_12 = false;
            var16_13 = 1;
            var17_14 = new StreamTokenizer(var1_1);
            var17_14.eolIsSignificant(true);
            var17_14.wordChars(95, 95);
            var17_14.whitespaceChars(58, 58);
            var17_14.commentChar(47);
            var17_14.commentChar(35);
            var18_15 = true;
            block22: while (true) {
                try {
                    block23: while (!var15_12) {
                        block24: while (true) {
                            var19_19 = var17_14.nextToken();
                            block1 : switch (var19_19) {
                                default: {
                                    PsDebug.warning((String)("parsing broke abnormally in line=" + var17_14.lineno() + " reading st.sval=" + var17_14.sval + ", st.ttype=" + var17_14.ttype));
                                    continue block22;
                                }
                                case 10: {
                                    var18_15 = true;
                                    continue block22;
                                }
                                case -3: {
                                    if ("SIMPLEX_REPRESENTATION".equalsIgnoreCase(var17_14.sval)) {
                                        this.m_meshRepresentation = 2;
                                        continue block22;
                                    }
                                    if ("SPACE_DIMENSION".equalsIgnoreCase(var17_14.sval)) {
                                        if (var17_14.nextToken() != -2) continue block22;
                                        this.m_dimOfVertices = (int)var17_14.nval;
                                        continue block22;
                                    }
                                    if ("SURFACE_DIMENSION".equalsIgnoreCase(var17_14.sval)) {
                                        if (var17_14.nextToken() != -2) continue block22;
                                        switch ((int)var17_14.nval) {
                                            case 3: {
                                                this.m_meshType = 34;
                                                this.m_dimOfElements = 4;
                                                break;
                                            }
                                            case 2: {
                                                this.m_meshType = 33;
                                                this.m_dimOfElements = 3;
                                                break;
                                            }
                                            case 1: {
                                                this.m_meshType = 32;
                                                break;
                                            }
                                            default: {
                                                this.m_meshType = 30;
                                                break;
                                            }
                                        }
                                        continue block22;
                                    }
                                    if ("STRING".equalsIgnoreCase(var17_14.sval)) {
                                        this.m_meshType = 32;
                                        continue block22;
                                    }
                                    if ("SOAPFILM".equalsIgnoreCase(var17_14.sval)) {
                                        this.m_meshType = 33;
                                        if (this.m_meshRepresentation != 2) continue block22;
                                        this.m_dimOfElements = 3;
                                        continue block22;
                                    }
                                    if ("fixed".equalsIgnoreCase(var17_14.sval) && var14_11 != null) {
                                        var14_11.setTag(3);
                                        continue block22;
                                    }
                                    if ("vertices".equalsIgnoreCase(var17_14.sval)) {
                                        var16_13 = 2;
                                        continue block22;
                                    }
                                    if ("edges".equalsIgnoreCase(var17_14.sval)) {
                                        var16_13 = 3;
                                        continue block22;
                                    }
                                    if ("faces".equalsIgnoreCase(var17_14.sval)) {
                                        var16_13 = 4;
                                        continue block22;
                                    }
                                    if ("bodies".equalsIgnoreCase(var17_14.sval)) {
                                        var16_13 = 5;
                                        continue block22;
                                    }
                                    if ("boundary".equalsIgnoreCase(var17_14.sval)) {
                                        if (var17_14.nextToken() != -2) continue block22;
                                        var10_7 = (int)var17_14.nval - 1;
                                        continue block22;
                                    }
                                    if ("read".equalsIgnoreCase(var17_14.sval)) {
                                        var15_12 = true;
                                        break;
                                    }
                                    if ("tension".equalsIgnoreCase(var17_14.sval)) {
                                        if (var17_14.nextToken() != -2) continue block22;
                                        var10_7 = (int)var17_14.nval - 1;
                                        continue block22;
                                    }
                                    if ("wrap".equalsIgnoreCase(var17_14.sval)) {
                                        if (var17_14.nextToken() != -2) continue block22;
                                        var10_7 = (int)var17_14.nval - 1;
                                        continue block22;
                                    }
                                    if ("bare".equalsIgnoreCase(var17_14.sval)) continue block22;
                                    if ("nodisplay".equalsIgnoreCase(var17_14.sval)) {
                                        var14_11.setTag(15);
                                        continue block22;
                                    }
                                    if ("constraints".equalsIgnoreCase(var17_14.sval)) {
                                        while (var17_14.nextToken() == -2) {
                                            var10_7 = (int)var17_14.nval - 1;
                                        }
                                        var17_14.pushBack();
                                        continue block22;
                                    }
                                    if ("volume".equalsIgnoreCase(var17_14.sval)) {
                                        PgLoader.parseDouble((StreamTokenizer)var17_14);
                                        continue block22;
                                    }
                                    if ("area".equalsIgnoreCase(var17_14.sval)) {
                                        PgLoader.parseDouble((StreamTokenizer)var17_14);
                                        continue block22;
                                    }
                                    if ("length".equalsIgnoreCase(var17_14.sval)) {
                                        PgLoader.parseDouble((StreamTokenizer)var17_14);
                                        continue block22;
                                    }
                                    if ("CONSTRAINT".equalsIgnoreCase(var17_14.sval)) {
                                        PgLoader.parseEndOfLine((StreamTokenizer)var17_14);
                                        continue block22;
                                    }
                                    if ("CONSTRAINT_TOLERANCE".equalsIgnoreCase(var17_14.sval)) {
                                        PgLoader.parseDouble((StreamTokenizer)var17_14);
                                        continue block22;
                                    }
                                    if ("define".equalsIgnoreCase(var17_14.sval)) {
                                        PgLoader.parseEndOfLine((StreamTokenizer)var17_14);
                                        continue block22;
                                    }
                                    if ("color".equalsIgnoreCase(var17_14.sval)) {
                                        var19_19 = var17_14.nextToken();
                                        if (var19_19 != -3) continue block22;
                                        var20_21 = PdColor.getColorFromName((String)var17_14.sval);
                                        switch (var16_13) {
                                            case 3: {
                                                if (this.m_vEdgeColor == null) {
                                                    this.m_vEdgeColor = new Vector<E>(var10_7 + 1);
                                                }
                                                if (this.m_vEdgeColor.size() < var10_7 + 1) {
                                                    this.m_vEdgeColor.setSize(Math.max(var10_7 + 1, 2 * this.m_vEdgeColor.size()));
                                                }
                                                this.m_vEdgeColor.setElementAt(var20_21, var10_7);
                                                continue block22;
                                            }
                                            default: {
                                                if (!var15_12) continue block24;
                                            }
                                        }
                                    }
                                    if ("FUNCTION".equalsIgnoreCase(var17_14.sval)) {
                                        PgLoader.parseEndOfLine((StreamTokenizer)var17_14);
                                        continue block22;
                                    }
                                    if ("LINEAR".equalsIgnoreCase(var17_14.sval)) {
                                        this.m_bLinear = true;
                                        continue block22;
                                    }
                                    if ("PARAMETER".equalsIgnoreCase(var17_14.sval)) {
                                        PgLoader.parseEndOfLine((StreamTokenizer)var17_14);
                                        continue block22;
                                    }
                                    if ("QUANTITY".equalsIgnoreCase(var17_14.sval)) {
                                        PgLoader.parseEndOfLine((StreamTokenizer)var17_14);
                                        continue block22;
                                    }
                                    if ("QUANTITIY".equalsIgnoreCase(var17_14.sval)) {
                                        PgLoader.parseEndOfLine((StreamTokenizer)var17_14);
                                        continue block22;
                                    }
                                    if ("SCALE".equalsIgnoreCase(var17_14.sval)) {
                                        this.m_scale = PgLoader.parseDouble((StreamTokenizer)var17_14);
                                        continue block22;
                                    }
                                    if ("SCALE_LIMIT".equalsIgnoreCase(var17_14.sval)) {
                                        PgLoader.parseDouble((StreamTokenizer)var17_14);
                                        continue block22;
                                    }
                                    if ("TOTAL_TIME".equalsIgnoreCase(var17_14.sval)) {
                                        this.m_totalTime = PgLoader.parseDouble((StreamTokenizer)var17_14);
                                        continue block22;
                                    }
                                    if ("VIEW_MATRIX".equalsIgnoreCase(var17_14.sval)) {
                                        this.m_viewMat = new PdMatrix(4);
                                        var7_16 = 0;
                                        do {
                                            var8_17 = 0;
                                            do {
                                                this.m_viewMat.setEntry(var7_16, var8_17, PgLoader.parseDouble((StreamTokenizer)var17_14));
                                            } while (++var8_17 < 4);
                                        } while (++var7_16 < 4);
                                        continue block22;
                                    }
                                    if (!"ZOOM_VERTEX".equalsIgnoreCase(var17_14.sval)) continue block22;
                                    PgLoader.parseDouble((StreamTokenizer)var17_14);
                                    continue block22;
                                }
                                case -2: {
                                    if (var18_15) ** break;
                                    continue block22;
                                    var10_7 = (int)var17_14.nval - 1;
                                    switch (var16_13) {
                                        case 2: {
                                            var9_18 = 0;
                                            var7_16 = 0;
                                            while (var7_16 < this.m_dimOfVertices) {
                                                var5_5[var7_16] = PgLoader.parseDouble((StreamTokenizer)var17_14);
                                                ++var9_18;
                                                ++var7_16;
                                            }
                                            if (var9_18 == this.m_dimOfVertices) {
                                                ++this.m_numVertices;
                                                var20_22 = new PdVector(this.m_dimOfVertices);
                                                var20_22.copy(var5_5, this.m_dimOfVertices);
                                                if (this.m_vVertex.size() < var10_7 + 1) {
                                                    this.m_vVertex.setSize(Math.max(var10_7 + 1, 2 * this.m_vVertex.size()));
                                                }
                                                var11_8 = Math.max(var11_8, var10_7);
                                                this.m_vVertex.setElementAt(var20_22, var10_7);
                                                var14_11 = var20_22;
                                            } else {
                                                var14_11 = null;
                                                PsDebug.warning((String)("vertex with wrong number of coords in line=" + var17_14.lineno()));
                                            }
                                            PgLoader.parseEndOfLine((StreamTokenizer)var17_14);
                                            ** GOTO lbl-1000
                                        }
                                        case 3: {
                                            var20_23 = -1;
                                            var21_24 = -1;
                                            if (var17_14.nextToken() == -2) {
                                                var20_23 = (int)var17_14.nval - 1;
                                            }
                                            if (var17_14.nextToken() == -2) {
                                                var21_24 = (int)var17_14.nval - 1;
                                            }
                                            if (var20_23 == -1 || var21_24 == -1) {
                                                PsDebug.warning((String)("edge with void vertex index in line=" + var17_14.lineno()));
                                            } else {
                                                ++this.m_numEdges;
                                                var9_18 = 2;
                                                var22_25 = new PiVector(var20_23, var21_24);
                                                this.m_vEdge.addElement(var22_25);
                                                if (this.m_vEdge.size() < var10_7 + 1) {
                                                    this.m_vEdge.setSize(Math.max(var10_7 + 1, 2 * this.m_vEdge.size()));
                                                }
                                                var12_9 = Math.max(var12_9, var10_7);
                                                this.m_vEdge.setElementAt(var22_25, var10_7);
                                                var14_11 = var22_25;
                                                var18_15 = false;
                                            }
                                            ** GOTO lbl-1000
                                        }
                                        case 4: {
                                            var9_18 = 0;
                                            while (var17_14.nextToken() == -2) {
                                                var6_6[var9_18] = (int)var17_14.nval;
                                                if (this.m_meshRepresentation != 1) {
                                                    v0 = var9_18;
                                                    var6_6[v0] = var6_6[v0] + -1;
                                                }
                                                ++var9_18;
                                            }
                                            var17_14.pushBack();
                                            if (var9_18 == 0) {
                                                var14_11 = null;
                                                PsDebug.warning((String)("element with missing vertex index in line=" + var17_14.lineno()));
                                                break block1;
                                            }
                                            var23_26 = new PiVector(var9_18);
                                            if (this.m_meshRepresentation == 1) {
                                                var7_16 = 0;
                                                while (var7_16 < var9_18) {
                                                    var22_25 = (PiVector)this.m_vEdge.elementAt(Math.abs(var6_6[var7_16]) - 1);
                                                    var23_26.m_data[var7_16] = var6_6[var7_16] > 0 ? var22_25.m_data[0] : var22_25.m_data[1];
                                                    ++var7_16;
                                                }
                                            } else {
                                                var23_26.copy(var6_6, var9_18);
                                            }
                                            if (this.m_vElement.size() < var10_7 + 1) {
                                                this.m_vElement.setSize(Math.max(var10_7 + 1, 2 * this.m_vElement.size()));
                                            }
                                            var13_10 = Math.max(var13_10, var10_7);
                                            this.m_vElement.setElementAt(var23_26, var10_7);
                                            var14_11 = var23_26;
                                            if (this.m_numElements == 0) {
                                                this.m_dimOfElements = var9_18;
                                            } else if (this.m_dimOfElements != var9_18) {
                                                this.m_dimOfElements = -1;
                                            }
                                            ++this.m_numElements;
                                            var18_15 = false;
                                            ** GOTO lbl-1000
                                        }
                                        default: {
                                            PsDebug.warning((String)("found number without being in mode, line=" + var17_14.lineno()));
                                        }
lbl-1000:
                                        // 6 sources

                                        {
                                            ** case 5:
                                        }
                                    }
lbl286:
                                    // 1 sources

                                    continue block23;
                                    break;
                                }
                            }
                            break;
                        }
                    }
                    break block81;
                }
                catch (Exception var19_20) {
                    PsDebug.warning((String)("Exception thrown in line=" + var17_14.lineno() + ", Exception = " + var19_20));
                    return false;
                }
                break;
            }
            {
                ** case -1:
            }
        }
        return true;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        Color[] colorArray;
        int n;
        PdVector[] pdVectorArray;
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        PgJvxSrc pgJvxSrc = new PgJvxSrc();
        boolean bl = this.parse(bufferedReader, pgJvxSrc);
        if (!bl) {
            PsDebug.warning((String)"error during parsing of reader");
            return null;
        }
        pgJvxSrc.setType(this.m_meshType);
        if (this.m_numVertices > 0) {
            pgJvxSrc.setDimOfVertices(this.m_dimOfVertices);
            pgJvxSrc.setNumVertices(this.m_numVertices);
            pdVectorArray = pgJvxSrc.getVertices();
            n = 0;
            colorArray = this.m_vVertex.elements();
            while (n < this.m_numVertices && colorArray.hasMoreElements()) {
                pdVectorArray[n++].copy((PdVector)colorArray.nextElement());
            }
        }
        if (this.m_numEdges > 0) {
            pgJvxSrc.setDimOfPolygons(2);
            pgJvxSrc.setNumPolygons(this.m_numEdges);
            pdVectorArray = pgJvxSrc.getPolygons();
            n = 0;
            colorArray = this.m_vEdge.elements();
            while (n < this.m_numEdges && colorArray.hasMoreElements()) {
                pdVectorArray[n++].copy((PiVector)colorArray.nextElement());
            }
            if (this.m_vEdgeColor != null) {
                pgJvxSrc.assurePolygonColors();
                colorArray = pgJvxSrc.getPolygonColors();
                n = 0;
                Enumeration enumeration = this.m_vEdgeColor.elements();
                while (n < this.m_numEdges && enumeration.hasMoreElements()) {
                    Color color = (Color)enumeration.nextElement();
                    colorArray[n++] = color != null ? color : pgJvxSrc.getGlobalPolygonColor();
                }
                pgJvxSrc.setPolygonColors(colorArray);
                pgJvxSrc.showPolygonColors(true);
            }
        }
        if (this.m_numElements > 0) {
            pgJvxSrc.setDimOfElements(this.m_dimOfElements);
            pgJvxSrc.setNumElements(this.m_numElements);
            pdVectorArray = pgJvxSrc.getElements();
            n = 0;
            colorArray = this.m_vElement.elements();
            while (n < this.m_numElements && colorArray.hasMoreElements()) {
                pdVectorArray[n++].copy((PiVector)colorArray.nextElement());
            }
        }
        PgFeLoader.geomInitType(pgJvxSrc);
        return new PgJvxSrc[]{pgJvxSrc};
    }

    public PgJvxSrc[][] getAnimations() {
        return this.m_animArr;
    }

    public PgJvxSrc[] getGeometries() {
        return this.m_geomArr;
    }

    public PvDisplayOption getDisplayOption() {
        return null;
    }

    public void setDisplayOption(PvDisplayOption pvDisplayOption) {
    }

    public void setAnimation(boolean bl) {
        this.m_bIsAnimation = bl;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        writer.write("// Produced with JavaView v." + PsConfig.getVersion() + "\n");
        writer.write("// JavaView is " + PsConfig.getCopyright() + ", " + PsConfig.getHomepage() + "\n");
        writer.write("// by " + PsConfig.getAuthors() + "\n");
        writer.write("//     File Format = Surface Evolver FE\n");
        writer.write("//     Geometry    = " + pgJvxSrc.getName() + "\n");
        writer.write("//     Date        = " + new Date().toString() + "\n//\n");
        int n = pgJvxSrc.getNumVertices();
        writer.write("//     Number of Vertices = " + n + "\n");
        int n2 = pgJvxSrc.getNumElements();
        if (n2 > 0) {
            writer.write("//     Number of Elements = " + n2 + "\n");
        }
        if (pgJvxSrc.getVertexNormals() != null) {
            writer.write("//     Additional: Vertex Normals\n");
        }
        writer.write("//\n// End of Header\n");
        int n3 = pgJvxSrc.getDimOfSimplex();
        if (n3 == 0 || n3 == 1) {
            writer.write("STRING\n");
        } else if (n3 == 2) {
            writer.write("SOAPFILM\n");
        } else if (n3 > 2) {
            writer.write("SURFACE_DIMENSION " + n3 + "\n");
        }
        writer.write("SPACE_DIMENSION " + pgJvxSrc.getDimOfVertices() + "\n");
        writer.write("SIMPLEX_REPRESENTATION\n");
        PdVector[] pdVectorArray = pgJvxSrc.getVertices();
        PiVector[] piVectorArray = pgJvxSrc.getElements();
        PiVector[] piVectorArray2 = pgJvxSrc.getNeighbours();
        if (piVectorArray2 != null) {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = piVectorArray[n4].getSize();
                int n6 = 0;
                while (n6 < n5) {
                    if (piVectorArray2[n4].m_data[n6] < 0) {
                        pdVectorArray[piVectorArray[n4].m_data[(n6 + 1) % n5]].setTag(3);
                        pdVectorArray[piVectorArray[n4].m_data[(n6 + 2) % n5]].setTag(3);
                    }
                    ++n6;
                }
                ++n4;
            }
        }
        if (!PgFeLoader.writeVertices(writer, n, pdVectorArray)) {
            return false;
        }
        return PgFeLoader.writeElements(writer, n2, piVectorArray);
    }

    public boolean load(BufferedReader bufferedReader) {
        this.m_geomArr = this.read(bufferedReader);
        return this.m_geomArr != null;
    }

    public boolean isAnimation() {
        return this.m_bIsAnimation;
    }

    private static void geomInitType(PgJvxSrc pgJvxSrc) {
        switch (pgJvxSrc.getType()) {
            case 30: {
                pgJvxSrc.showVertices(true);
                return;
            }
            case 33: {
                pgJvxSrc.assureNeighbours();
                pgJvxSrc.showEdges(true);
                pgJvxSrc.showElements(true);
                return;
            }
            case 32: {
                pgJvxSrc.showVertices(false);
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.showEdges(true);
                return;
            }
        }
    }

    public PgGeometryIf[] getSpecializedGeometries() {
        return null;
    }

    protected static boolean writeVertices(Writer writer, int n, PdVector[] pdVectorArray) throws IOException {
        if (n <= 0 || pdVectorArray == null || n > pdVectorArray.length) {
            return false;
        }
        writer.write("vertices\n");
        int n2 = 0;
        while (n2 < n) {
            if (pdVectorArray[n2] == null || pdVectorArray[n2].m_data.length == 0) {
                PsDebug.warning((String)("missing vertex, ind = " + n2));
                return false;
            }
            writer.write(String.valueOf(n2 + 1) + " " + PuString.toString((double[])pdVectorArray[n2].m_data));
            if (pdVectorArray[n2].hasTag(3)) {
                writer.write("  fixed");
            }
            writer.write("\n");
            ++n2;
        }
        return true;
    }

    protected static boolean writeElements(Writer writer, int n, PiVector[] piVectorArray) throws IOException {
        if (n <= 0 || piVectorArray == null || n > piVectorArray.length) {
            return false;
        }
        writer.write("faces\n");
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            if (piVectorArray[n2] == null || piVectorArray[n2].m_data.length == 0) {
                PsDebug.warning((String)("missing element, ind = " + n2));
                return false;
            }
            if (!bl && piVectorArray[n2].m_data.length != 3) {
                PsDebug.warning((String)("element[" + n2 + "] is not a simplex as required in SIMPLEX_REPRESENTATION"));
                bl = true;
            }
            writer.write(String.valueOf(n2 + 1));
            int n3 = 0;
            while (n3 < piVectorArray[n2].m_data.length) {
                writer.write(" " + (piVectorArray[n2].m_data[n3] + 1));
                ++n3;
            }
            writer.write("\n");
            ++n2;
        }
        return true;
    }
}

