/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jv.loader.PgLoader;
import jv.loader.PgLoaderIf;
import jv.loader.PvDisplayOption;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgXyzLoader
implements PgLoaderIf {
    protected boolean m_bIsAnimation = false;
    protected PgJvxSrc[] m_geomArr;
    protected PgJvxSrc[][] m_animArr;
    private static final String[] elementSymbols = new String[]{"Xx", "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt"};
    private static Hashtable htElementMap;
    private static final int elementNumberMax;
    private static final String[] elementNames;
    private static final byte[] alternateElementNumbers;
    private static final String[] alternateElementNames;
    private static final short[] vanderwaalsMars;
    private static final short[] covalentMars;
    private static final int CHARGE_MIN = -4;
    private static final int CHARGE_MAX = 7;
    private static final short[] ionicLookupTable;
    private static final short[] ionicMars;
    private static final int[] argbsCpk;

    public void setGeometryOption(BitSet bitSet) {
    }

    public boolean isEnabledOptimization() {
        return false;
    }

    protected PgJvxSrc[] parse(BufferedReader bufferedReader) throws IOException {
        PgJvxSrc[] pgJvxSrcArray;
        int n;
        Vector<PgJvxSrc[]> vector = new Vector<PgJvxSrc[]>();
        int n2 = 0;
        while ((n = this.readAtomCount(bufferedReader)) > 0) {
            pgJvxSrcArray = new PgJvxSrc();
            pgJvxSrcArray.setType(32);
            pgJvxSrcArray.setName(bufferedReader.readLine());
            pgJvxSrcArray.setNumVertices(n);
            pgJvxSrcArray.showVertices(true);
            pgJvxSrcArray.showPolygons(true);
            pgJvxSrcArray.setGlobalVertexSize(7.0);
            pgJvxSrcArray.setGlobalPolygonSize(5.0);
            this.readAtoms(bufferedReader, (PgJvxSrc)pgJvxSrcArray, n, n2);
            if (n == 0) {
                PsDebug.warning((String)("missing atoms in model = " + String.valueOf(n2)));
                return null;
            }
            if (n2 > 0) {
                PgJvxSrc pgJvxSrc = (PgJvxSrc)vector.elementAt(0);
                pgJvxSrcArray.setNumPolygons(pgJvxSrc.getNumPolygons());
                pgJvxSrcArray.setPolygons(pgJvxSrc.getPolygons());
            }
            vector.addElement(pgJvxSrcArray);
            ++n2;
        }
        if (n2 == 0) {
            PsDebug.warning((String)"missing model");
            return null;
        }
        if (n2 > 1) {
            this.m_bIsAnimation = true;
        }
        pgJvxSrcArray = new PgJvxSrc[n2];
        int n3 = 0;
        while (n3 < n2) {
            pgJvxSrcArray[n3] = (PgJvxSrc)vector.elementAt(n3);
            ++n3;
        }
        return pgJvxSrcArray;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        this.m_geomArr = null;
        try {
            this.m_geomArr = this.parse(bufferedReader);
            if (this.m_geomArr == null) {
                PsDebug.warning((String)"error during parsing of reader");
                return null;
            }
        }
        catch (IOException iOException) {
            PsDebug.warning((String)"error when during parsing of reader");
            iOException.printStackTrace();
            return null;
        }
        if (this.m_bIsAnimation) {
            this.m_animArr = new PgJvxSrc[this.m_geomArr.length][1];
            int n = 0;
            while (n < this.m_geomArr.length) {
                this.m_animArr[n][0] = this.m_geomArr[n];
                ++n;
            }
        }
        return this.m_geomArr;
    }

    public static PgJvxSrc[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open((String)string);
        if (bufferedReader == null) {
            PsDebug.warning((String)("could not open = " + string));
            return null;
        }
        PgXyzLoader pgXyzLoader = new PgXyzLoader();
        PgJvxSrc[] pgJvxSrcArray = pgXyzLoader.read(bufferedReader);
        if (pgJvxSrcArray != null && pgJvxSrcArray.length > 0 && pgJvxSrcArray[0] != null) {
            pgJvxSrcArray[0].setName(PsUtil.getFileBaseName((String)string));
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return pgJvxSrcArray;
    }

    public PgJvxSrc[][] getAnimations() {
        return this.m_animArr;
    }

    public PgJvxSrc[] getGeometries() {
        return this.m_geomArr;
    }

    public PvDisplayOption getDisplayOption() {
        return null;
    }

    public void setDisplayOption(PvDisplayOption pvDisplayOption) {
    }

    public void setAnimation(boolean bl) {
        this.m_bIsAnimation = bl;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        return true;
    }

    public boolean load(BufferedReader bufferedReader) {
        this.m_geomArr = this.read(bufferedReader);
        return this.m_geomArr != null;
    }

    private int readAtomCount(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        if (string == null) {
            return 0;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t ");
        if (!stringTokenizer.hasMoreTokens()) {
            return 0;
        }
        return Integer.parseInt(stringTokenizer.nextToken());
    }

    private void readAtoms(BufferedReader bufferedReader, PgJvxSrc pgJvxSrc, int n, int n2) throws IOException {
        int n3;
        boolean bl = false;
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)pgJvxSrc.getNumVertices(), (int)3);
        double[] dArray = new double[4];
        int[] nArray = new int[n];
        Color[] colorArray = new Color[n];
        int n4 = 0;
        while (n4 < n) {
            StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine(), "\t ");
            String string = stringTokenizer.nextToken().intern();
            nArray[n4] = PgXyzLoader.elementNumberFromSymbol(string);
            colorArray[n4] = new Color(argbsCpk[nArray[n4]]);
            double d = PgLoader.parseDouble((String)stringTokenizer.nextToken());
            double d2 = PgLoader.parseDouble((String)stringTokenizer.nextToken());
            double d3 = PgLoader.parseDouble((String)stringTokenizer.nextToken());
            PdVector pdVector = new PdVector(d, d2, d3);
            pdVector.setName(string);
            pgJvxSrc.setVertex(n4, pdVector);
            n3 = 0;
            while (n3 < 4 && stringTokenizer.hasMoreTokens()) {
                dArray[n3] = PgLoader.parseDouble((String)stringTokenizer.nextToken());
                ++n3;
            }
            double cfr_ignored_0 = dArray[0];
            if (n3 >= 3) {
                bl = true;
                double d4 = dArray[n3 - 3];
                double d5 = dArray[n3 - 2];
                double d6 = dArray[n3 - 1];
                pdVectorArray[n4].set(d, d2, d3);
            }
            ++n4;
        }
        pgJvxSrc.setVertexColors(colorArray);
        pgJvxSrc.showVertexColors(true);
        pgJvxSrc.showPolygonColors(true);
        pgJvxSrc.showSmoothElementColors(true);
        pgJvxSrc.showElementFromVertexColors(true);
        if (bl) {
            pgJvxSrc.setNumVectorFields(1);
            pgJvxSrc.setVectors(0, pdVectorArray);
        }
        if (n2 == 0) {
            pgJvxSrc.setNumPolygons(n);
            pgJvxSrc.setNumPolygons(0);
            float f = 0.4f;
            int n5 = 0;
            while (n5 < n) {
                short s = covalentMars[nArray[n5]];
                int n6 = n5 + 1;
                while (n6 < n) {
                    n3 = covalentMars[nArray[n6]];
                    float f2 = (float)(s + n3 + 450) / 1000.0f;
                    float f3 = (float)PdVector.dist((PdVector)pgJvxSrc.getVertex(n5), (PdVector)pgJvxSrc.getVertex(n6));
                    if (f < f3 && f3 < f2) {
                        pgJvxSrc.addPolygon(new PiVector(n5, n6));
                    }
                    ++n6;
                }
                ++n5;
            }
        }
    }

    static {
        elementNumberMax = elementSymbols.length;
        elementNames = new String[]{"unknown", "hydrogen", "helium", "lithium", "beryllium", "boron", "carbon", "nitrogen", "oxygen", "fluorine", "neon", "sodium", "magnesium", "aluminum", "silicon", "phosphorus", "sulfur", "chlorine", "argon", "potassium", "calcium", "scandium", "titanium", "vanadium", "chromium", "manganese", "iron", "cobalt", "nickel", "copper", "zinc", "gallium", "germanium", "arsenic", "selenium", "bromine", "krypton", "rubidium", "strontium", "yttrium", "zirconium", "niobium", "molybdenum", "technetium", "ruthenium", "rhodium", "palladium", "silver", "cadmium", "indium", "tin", "antimony", "tellurium", "iodine", "xenon", "cesium", "barium", "lanthanum", "cerium", "praseodymium", "neodymium", "promethium", "samarium", "europium", "gadolinium", "terbium", "dysprosium", "holmium", "erbium", "thulium", "ytterbium", "lutetium", "hafnium", "tantalum", "tungsten", "rhenium", "osmium", "iridium", "platinum", "gold", "mercury", "thallium", "lead", "bismuth", "polonium", "astatine", "radon", "francium", "radium", "actinium", "thorium", "protactinium", "uranium", "neptunium", "plutonium", "americium", "curium", "berkelium", "californium", "einsteinium", "fermium", "mendelvium", "nobelium", "lawrencium", "rutherfordium", "dubnium", "seaborgium", "bohrium", "hassium", "meitnerium"};
        alternateElementNumbers = new byte[]{13, 16, 55};
        alternateElementNames = new String[]{"aluminium", "sulphur", "caesium"};
        vanderwaalsMars = new short[]{1000, 1200, 1400, 1820, 1700, 2080, 1950, 1850, 1700, 1730, 1540, 2270, 1730, 2050, 2100, 2080, 2000, 1970, 1880, 2750, 1973, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1630, 1400, 1390, 1870, 1700, 1850, 1900, 2100, 2020, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1630, 1720, 1580, 1930, 2170, 2200, 2060, 2150, 2160, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1720, 1660, 1550, 1960, 2020, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1860, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700};
        covalentMars = new short[]{2000, 230, 930, 680, 350, 830, 680, 680, 680, 640, 1120, 970, 1100, 1350, 1200, 750, 1020, 990, 1570, 1330, 990, 1440, 1470, 1330, 1350, 1350, 1340, 1330, 1500, 1520, 1450, 1220, 1170, 1210, 1220, 1210, 1910, 1470, 1120, 1780, 1560, 1480, 1470, 1350, 1400, 1450, 1500, 1590, 1690, 1630, 1460, 1460, 1470, 1400, 1980, 1670, 1340, 1870, 1830, 1820, 1810, 1800, 1800, 1990, 1790, 1760, 1750, 1740, 1730, 1720, 1940, 1720, 1570, 1430, 1370, 1350, 1370, 1320, 1500, 1500, 1700, 1550, 1540, 1540, 1680, 1700, 2400, 2000, 1900, 1880, 1790, 1610, 1580, 1550, 1530, 1510, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1600, 1600, 1600, 1600, 1600, 1600};
        ionicLookupTable = new short[]{19, 53, 69, 70, 85, 87, 96, 104, 113, 117, 119, 121, 130, 131, 133, 138, 147, 155, 165, 181, 197, 198, 215, 224, 227, 229, 232, 241, 247, 249, 258, 262, 264, 266, 275, 281, 283, 293, 309, 325, 326, 343, 357, 358, 359, 360, 374, 375, 376, 377, 389, 390, 391, 394, 406, 407, 408, 411, 422, 423, 438, 439, 454, 469, 470, 485, 486, 501, 503, 512, 518, 520, 529, 535, 537, 546, 547, 549, 552, 554, 563, 569, 571, 597, 614, 631, 645, 648, 661, 664, 665, 677, 680, 682, 699, 712, 727, 742, 744, 757, 758, 773, 774, 791, 800, 803, 806, 808, 817, 823, 825, 834, 835, 837, 840, 842, 851, 857, 859, 885, 901, 902, 917, 919, 933, 935, 936, 951, 952, 967, 983, 999, 1014, 1015, 1031, 1047, 1048, 1063, 1079, 1095, 1111, 1126, 1127, 1143, 1160, 1177, 1192, 1194, 1208, 1211, 1224, 1226, 1240, 1254, 1256, 1269, 1271, 1285, 1286, 1301, 1303, 1318, 1320, 1333, 1335, 1337, 1354, 1371, 1397, 1414, 1431, 1448, 1463, 1464, 1465, 1480, 1482, 1495, 1496, 1499, 1511, 1512, 1527, 1528};
        ionicMars = new short[]{1540, 680, 440, 350, 350, 230, 2600, 160, 1710, 250, 160, 130, 1320, 1760, 220, 90, 1330, 80, 1120, 970, 820, 660, 510, 2710, 3840, 650, 420, 2120, 440, 350, 1840, 2190, 370, 300, 1810, 340, 270, 1540, 1330, 1180, 990, 732, 960, 940, 760, 680, 880, 740, 630, 590, 810, 890, 630, 520, 800, 660, 600, 460, 740, 640, 720, 630, 690, 960, 720, 880, 740, 810, 620, 2720, 730, 530, 2220, 580, 460, 1910, 2320, 660, 500, 420, 1960, 470, 390, 1470, 1120, 893, 1090, 790, 1000, 740, 690, 930, 700, 620, 979, 670, 680, 800, 650, 1260, 890, 1140, 970, 810, 2940, 3700, 930, 710, 2450, 760, 620, 2110, 2500, 820, 700, 560, 2200, 620, 500, 1670, 1530, 1340, 1390, 1016, 1270, 1034, 920, 1013, 900, 995, 979, 964, 1090, 950, 938, 923, 840, 908, 894, 881, 870, 930, 858, 850, 780, 680, 700, 620, 720, 560, 880, 690, 680, 800, 650, 1370, 850, 1270, 1100, 1470, 950, 1200, 840, 980, 960, 740, 670, 620, 1800, 1430, 1180, 1020, 1130, 980, 890, 970, 800, 1100, 950, 710, 1080, 930, 1070, 920};
        argbsCpk = new int[]{-60269, -1, -2490369, -3374849, -3997952, -19019, -7303024, -13610760, -62195, -7282608, -4987915, -5546766, -7667968, -4217178, -997216, Short.MIN_VALUE, -208, -14684129, -8334877, -7388972, -12714240, -1644826, -4209977, -5855573, -7693881, -6522169, -2070989, -1011552, -11481008, -3637197, -8552272, -4026481, -10055793, -4357917, -24320, -5887703, -10700591, -9425232, -16711936, -7012353, -7020320, -9190711, -11225675, -12869986, -14381169, -16089716, -16750203, -4144960, -9841, -5868173, -10059648, -6397003, -2852352, -7077740, -12411216, -11069553, -16725760, -9382657, -57, -2490425, -3670073, -6029369, -7340089, -10354745, -12189753, -13566009, -14680121, -16711780, -16718219, -16722862, -16728264, -16733404, -11681025, -11688193, -14576426, -14254677, -14260586, -15248249, -3092256, -11997, -4671280, -5876659, -11052703, -6402123, -5547008, -9089211, -12418410, -12451738, -16745216, -9393158, -16729345, -16735745, -16740353, -16744193, -16749569, -11248398, -8889117, -7712797, -6211884, -5038124, -5038150, -5042778, -4387449, -3735450, -3407783, -3080113, -2555835, -2097096, -1703890, -1376218};
    }

    private static short getBondingMar(int n, int n2) {
        if (n2 != 0) {
            short s = (short)((n << 4) + (n2 + 4));
            int n3 = 0;
            int n4 = ionicLookupTable.length;
            while (n3 != n4) {
                int n5 = (n3 + n4) / 2;
                if (s < ionicLookupTable[n5]) {
                    n4 = n5;
                    continue;
                }
                if (s > ionicLookupTable[n5]) {
                    n3 = n5 + 1;
                    continue;
                }
                return ionicMars[n5];
            }
        }
        return covalentMars[n];
    }

    public boolean isAnimation() {
        return this.m_bIsAnimation;
    }

    private static byte elementNumberFromSymbol(String string) {
        Serializable serializable;
        if (htElementMap == null) {
            serializable = new Hashtable();
            int n = elementNumberMax;
            while (--n >= 0) {
                String string2 = elementSymbols[n];
                Integer n2 = new Integer(n);
                ((Hashtable)serializable).put(string2, n2);
                if (string2.length() != 2) continue;
                string2 = "" + string2.charAt(0) + Character.toUpperCase(string2.charAt(1));
                ((Hashtable)serializable).put(string2, n2);
            }
            htElementMap = serializable;
        }
        if (string == null) {
            System.out.println("elementNumberFromSymbol(null) ?");
            return 0;
        }
        serializable = (Integer)htElementMap.get(string);
        if (serializable != null) {
            return (byte)((Integer)serializable).intValue();
        }
        System.out.println("" + string + "' is not a recognized symbol");
        return 0;
    }

    public PgGeometryIf[] getSpecializedGeometries() {
        return null;
    }
}

