/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.numeric.PnEnergy;
import jvx.numeric.PnStiffDiriConforming;
import jvx.numeric.PnStiffDiriNonConforming;

public class PnAreaEnergy
extends PnEnergy {
    private static /* synthetic */ Class class$jvx$numeric$PnAreaEnergy;

    public boolean setSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (pgElementSet2 == null) {
            PsDebug.warning((String)"missing surface geometry.");
            return false;
        }
        if (!super.setSurface(pgElementSet, pgElementSet2)) {
            return false;
        }
        if (this.m_domain != null && this.m_domain.isConforming() != this.m_surface.isConforming()) {
            PsDebug.error((String)"domain and surface have different conformality", (Object)((Object)this));
            return false;
        }
        if (this.m_domain != null && this.m_domain.getDimOfElements() != 3) {
            PsDebug.warning((String)("domain=" + this.m_domain.getName() + " not triangulated"));
            PgElementSet.triangulate((PgElementSet)this.m_domain);
        }
        if (this.m_surface.getDimOfElements() != 3) {
            PsDebug.warning((String)("surface=" + this.m_surface.getName() + " not triangulated"));
            PgElementSet.triangulate((PgElementSet)this.m_surface);
        }
        this.m_stiffMatrix = this.m_surface.isConforming() ? new PnStiffDiriConforming(this.m_surface) : new PnStiffDiriNonConforming(this.m_surface);
        return true;
    }

    public PnAreaEnergy() {
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnAreaEnergy != null ? class$jvx$numeric$PnAreaEnergy : (class$jvx$numeric$PnAreaEnergy = PnAreaEnergy.class$("jvx.numeric.PnAreaEnergy")))) {
            this.init();
        }
    }

    public PdMatrix evalHessian(PdMatrix pdMatrix) {
        if (pdMatrix == null) {
            pdMatrix = new PdMatrix();
        }
        int n = this.m_index.length;
        pdMatrix.setSize(this.m_dim * n);
        pdMatrix.setConstant(0.0);
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        PiVector[] piVectorArray = this.m_surface.getElements();
        this.m_surface.makeElementNormals();
        PdVector[] pdVectorArray2 = this.m_surface.getElementNormals();
        int n2 = this.m_surface.getNumElements();
        double[] dArray = new double[3];
        PdVector[] pdVectorArray3 = PdVector.realloc(null, (int)3, (int)this.m_dim);
        PdVector[] pdVectorArray4 = PdVector.realloc(null, (int)3, (int)this.m_dim);
        PdMatrix pdMatrix2 = new PdMatrix(this.m_dim);
        PdMatrix pdMatrix3 = new PdMatrix(this.m_dim);
        PdMatrix pdMatrix4 = new PdMatrix(this.m_dim);
        int n3 = 0;
        while (n3 < n2) {
            int[] nArray = piVectorArray[n3].m_data;
            PuVectorGeom.ctg((double[])dArray, (PdVector)pdVectorArray[nArray[0]], (PdVector)pdVectorArray[nArray[1]], (PdVector)pdVectorArray[nArray[2]]);
            pdMatrix2.adjoint(pdVectorArray2[n3]);
            int n4 = 0;
            do {
                pdVectorArray4[n4].sub(pdVectorArray[nArray[(n4 + 2) % 3]], pdVectorArray[nArray[(n4 + 1) % 3]]);
            } while (++n4 < 3);
            n4 = 0;
            do {
                pdVectorArray3[n4].blend(dArray[(n4 + 1) % 3], pdVectorArray4[(n4 + 1) % 3], -dArray[(n4 + 2) % 3], pdVectorArray4[(n4 + 2) % 3]);
            } while (++n4 < 3);
            n4 = 0;
            do {
                pdVectorArray4[n4].normalize();
                pdVectorArray3[n4].normalize();
            } while (++n4 < 3);
            n4 = 0;
            do {
                int n5;
                int n6;
                int n7;
                if (this.m_bUseConstrainMatrix || !pdVectorArray[nArray[n4]].hasTag(14)) {
                    n7 = this.m_dim * this.m_invIndex[nArray[n4]];
                    if (n7 < 0 || n7 > 3 * n + 2) {
                        PsDebug.warning((String)("index out of range: i=" + n7));
                        return pdMatrix;
                    }
                    n6 = 0;
                    while (n6 < this.m_dim) {
                        n5 = 0;
                        while (n5 < this.m_dim) {
                            double[] dArray2 = pdMatrix.m_data[n7 + n6];
                            int n8 = n7 + n5;
                            dArray2[n8] = dArray2[n8] + (dArray[(n4 + 1) % 3] + dArray[(n4 + 2) % 3]) * pdMatrix2.m_data[n6][n5] / 2.0;
                            ++n5;
                        }
                        ++n6;
                    }
                }
                if (!this.m_bUseConstrainMatrix && (pdVectorArray[nArray[(n4 + 2) % 3]].hasTag(14) || pdVectorArray[nArray[(n4 + 1) % 3]].hasTag(14))) continue;
                pdMatrix3.adjoint(pdVectorArray4[n4], pdVectorArray3[n4]);
                pdMatrix4.adjoint(pdVectorArray3[n4], pdVectorArray4[n4]);
                n7 = this.m_dim * this.m_invIndex[nArray[(n4 + 2) % 3]];
                int n9 = this.m_dim * this.m_invIndex[nArray[(n4 + 1) % 3]];
                if (n7 < 0 || n7 > this.m_dim * n + this.m_dim - 1 || n9 < 0 || n9 > this.m_dim * n + this.m_dim - 1) {
                    return pdMatrix;
                }
                n6 = 0;
                while (n6 < this.m_dim) {
                    n5 = 0;
                    while (n5 < this.m_dim) {
                        double[] dArray3 = pdMatrix.m_data[n7 + n6];
                        int n10 = n9 + n5;
                        dArray3[n10] = dArray3[n10] + (-pdMatrix3.m_data[n6][n5] + pdMatrix4.m_data[n6][n5] - dArray[n4] * pdMatrix2.m_data[n6][n5]) / 2.0;
                        double[] dArray4 = pdMatrix.m_data[n9 + n6];
                        int n11 = n7 + n5;
                        dArray4[n11] = dArray4[n11] + (pdMatrix3.m_data[n6][n5] - pdMatrix4.m_data[n6][n5] - dArray[n4] * pdMatrix2.m_data[n6][n5]) / 2.0;
                        ++n5;
                    }
                    ++n6;
                }
            } while (++n4 < 3);
            ++n3;
        }
        return pdMatrix;
    }

    public PdVector evalGradient(PdVector pdVector, PdVector pdVector2) {
        this.initStiff(pdVector);
        return super.evalGradient(pdVector, pdVector2);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void initStiff(PdVector pdVector) {
        if (this.m_surface == null) {
            return;
        }
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_nop) {
            int n3 = 0;
            while (n3 < this.m_dim) {
                pdVectorArray[n2].m_data[n3] = pdVector.m_data[n++];
                ++n3;
            }
            ++n2;
        }
        this.m_stiffMatrix.init(this.m_surface);
    }

    public void init() {
        super.init();
    }

    public double eval(PdVector pdVector) {
        this.initStiff(pdVector);
        return super.eval(pdVector);
    }

    public void initSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (this.m_stiffMatrix == null) {
            PsDebug.warning((String)"missing m_stiffMatrix, call setSurface before.");
            return;
        }
        super.initSurface(pgElementSet, pgElementSet2);
        this.m_stiffMatrix.init(pgElementSet2);
    }
}

