/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jvx.numeric.PnSparseMatrix;

public class PnBiconjugateGradient {
    private PdVector m_p = new PdVector();
    private PdVector m_pp = new PdVector();
    private PdVector m_r = new PdVector();
    private PdVector m_rr = new PdVector();
    private PdVector m_z = new PdVector();
    private PdVector m_zz = new PdVector();
    private int m_size;
    private int m_iter;
    private double m_err;
    private int m_itol = 1;
    private int m_itmax = 1000;
    private double m_tol = 1.0E-10;
    private int m_dim = 1;
    private double m_eps = 1.0E-14;
    private boolean m_bUseJacobiPreCond = false;

    public double getTolerance() {
        return this.m_tol;
    }

    private double snrm(double[] dArray, int n) {
        int n2 = this.m_size * this.m_dim;
        if (n <= 3) {
            double d = 0.0;
            int n3 = 0;
            while (n3 < n2) {
                d += dArray[n3] * dArray[n3];
                ++n3;
            }
            return Math.sqrt(d);
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            if (Math.abs(dArray[n5]) > Math.abs(dArray[n4])) {
                n4 = n5;
            }
            ++n5;
        }
        return Math.abs(dArray[n4]);
    }

    public void setMaxNumIterations(int n) {
        this.m_itmax = n;
    }

    public int getMaxNumIterations() {
        return this.m_itmax;
    }

    /*
     * Unable to fully structure code
     */
    public double linbcg(PnSparseMatrix var1_1, PdVector var2_2, PdVector var3_3) {
        block26: {
            block25: {
                block24: {
                    if (var1_1 == null) {
                        PsDebug.warning((String)"Cannot solve linear system given matrix is null.");
                        return -1.0;
                    }
                    if (var2_2 == null || var3_3 == null) {
                        PsDebug.warning((String)"Cannot solve linear system given vector is null.");
                        return -1.0;
                    }
                    if (this.m_size != var1_1.m_nop) {
                        this.setSize(var1_1.m_nop);
                    }
                    var4_4 = this.m_size * this.m_dim;
                    if (var3_3.getSize() < var4_4) {
                        PsDebug.warning((String)"Cannot solve linear system size of given vector b is to small.");
                        return -1.0;
                    }
                    if (var2_2.getSize() < var4_4) {
                        var2_2.setSize(var4_4);
                    }
                    if (var3_3.length() < 1.0E-10) {
                        var2_2.setConstant(0.0);
                        return 0.0;
                    }
                    if (this.m_bUseJacobiPreCond) {
                        PnBiconjugateGradient.preconditionJacobiLeft(var1_1, var3_3, this.m_dim);
                    }
                    var12_5 = 0.0;
                    var24_6 = 0.0;
                    this.m_iter = 0;
                    PnSparseMatrix.leftMult(var1_1, var2_2, this.m_r, this.m_dim);
                    var5_7 = 0;
                    while (var5_7 < var4_4) {
                        this.m_r.m_data[var5_7] = var3_3.m_data[var5_7] - this.m_r.m_data[var5_7];
                        this.m_rr.m_data[var5_7] = this.m_r.m_data[var5_7];
                        ++var5_7;
                    }
                    if (this.m_itol != 1) break block24;
                    var16_8 = this.snrm(var3_3.m_data, this.m_itol);
                    PnSparseMatrix.diagonalSolve(var1_1, this.m_z, this.m_r, this.m_dim);
                    ** GOTO lbl126
                }
                if (this.m_itol != 2) break block25;
                PnSparseMatrix.diagonalSolve(var1_1, this.m_z, var3_3, this.m_dim);
                var16_8 = this.snrm(this.m_z.m_data, this.m_itol);
                PnSparseMatrix.diagonalSolve(var1_1, this.m_z, this.m_r, this.m_dim);
                ** GOTO lbl126
            }
            if (this.m_itol != 3 && this.m_itol != 4) break block26;
            PnSparseMatrix.diagonalSolve(var1_1, this.m_z, var3_3, this.m_dim);
            var16_8 = this.snrm(this.m_z.m_data, this.m_itol);
            PnSparseMatrix.diagonalSolve(var1_1, this.m_z, this.m_r, this.m_dim);
            var24_6 = this.snrm(this.m_z.m_data, this.m_itol);
            if (true) ** GOTO lbl126
        }
        PsDebug.warning((String)"Illegal itol in Method linbcg.");
        return -1.0;
        do {
            ++this.m_iter;
            PnSparseMatrix.diagonalSolve(var1_1, this.m_zz, this.m_rr, this.m_dim);
            var14_12 = 0.0;
            var5_7 = 0;
            while (var5_7 < var4_4) {
                var14_12 += this.m_z.m_data[var5_7] * this.m_rr.m_data[var5_7];
                ++var5_7;
            }
            if (this.m_iter == 1) {
                var5_7 = 0;
                while (var5_7 < var4_4) {
                    this.m_p.m_data[var5_7] = this.m_z.m_data[var5_7];
                    this.m_pp.m_data[var5_7] = this.m_zz.m_data[var5_7];
                    ++var5_7;
                }
            } else {
                var10_11 = var14_12 / var12_5;
                var5_7 = 0;
                while (var5_7 < var4_4) {
                    this.m_p.m_data[var5_7] = var10_11 * this.m_p.m_data[var5_7] + this.m_z.m_data[var5_7];
                    this.m_pp.m_data[var5_7] = var10_11 * this.m_pp.m_data[var5_7] + this.m_zz.m_data[var5_7];
                    ++var5_7;
                }
            }
            var12_5 = var14_12;
            PnSparseMatrix.leftMult(var1_1, this.m_p, this.m_z, this.m_dim);
            var8_10 = 0.0;
            var5_7 = 0;
            while (var5_7 < var4_4) {
                var8_10 += this.m_z.m_data[var5_7] * this.m_pp.m_data[var5_7];
                ++var5_7;
            }
            var6_9 = var14_12 / var8_10;
            PnSparseMatrix.rightMult(var1_1, this.m_pp, this.m_zz, this.m_dim);
            var5_7 = 0;
            while (var5_7 < var4_4) {
                v0 = var5_7;
                var2_2.m_data[v0] = var2_2.m_data[v0] + var6_9 * this.m_p.m_data[var5_7];
                v1 = var5_7;
                this.m_r.m_data[v1] = this.m_r.m_data[v1] - var6_9 * this.m_z.m_data[var5_7];
                v2 = var5_7;
                this.m_rr.m_data[v2] = this.m_rr.m_data[v2] - var6_9 * this.m_zz.m_data[var5_7];
                ++var5_7;
            }
            PnSparseMatrix.diagonalSolve(var1_1, this.m_z, this.m_r, this.m_dim);
            if (this.m_itol == 1) {
                this.m_err = this.snrm(this.m_r.m_data, this.m_itol) / var16_8;
            } else if (this.m_itol == 2) {
                this.m_err = this.snrm(this.m_z.m_data, this.m_itol) / var16_8;
            } else if (this.m_itol == 3 || this.m_itol == 4) {
                var22_15 = var24_6;
                if (!(Math.abs(var22_15 - (var24_6 = this.snrm(this.m_z.m_data, this.m_itol))) > this.m_eps * var24_6)) {
                    this.m_err = var24_6 / var16_8;
                    continue;
                }
                var18_13 = Math.abs(var6_9) * this.snrm(this.m_p.m_data, this.m_itol);
                this.m_err = var24_6 / Math.abs(var22_15 - var24_6) * var18_13;
                var20_14 = this.snrm(var2_2.m_data, this.m_itol);
                if (this.m_err <= 0.5 * var20_14) {
                    this.m_err /= var20_14;
                } else {
                    this.m_err = var24_6 / var16_8;
                    continue;
                }
            }
            if (this.m_err <= this.m_tol) break;
lbl126:
            // 6 sources

        } while (this.m_iter <= this.m_itmax);
        return this.m_err;
    }

    public void usePreconditioning(boolean bl) {
        this.m_bUseJacobiPreCond = bl;
    }

    public boolean isUsingPrecondioning() {
        return this.m_bUseJacobiPreCond;
    }

    public void setEPS(double d) {
        this.m_eps = d;
    }

    public double getEPS() {
        return this.m_eps;
    }

    public void setConvergenceTest(int n) {
        if (n > 4 || n < 1) {
            PsDebug.warning((String)"Cannot set convergence test method, desired method is unknown.");
            return;
        }
        this.m_itol = n;
    }

    public double getConvergenceTest() {
        return this.m_itol;
    }

    public static void preconditionJacobiLeft(PnSparseMatrix pnSparseMatrix, PdVector pdVector, int n) {
        if (n < 1) {
            n = 1;
        }
        if (pnSparseMatrix == null) {
            PsDebug.warning((String)"given matrix is null.");
            return;
        }
        if (pdVector.m_data.length < n * pnSparseMatrix.m_nop) {
            PsDebug.warning((String)"given vector and matrix size do not match.");
            return;
        }
        int n2 = 0;
        while (n2 < pnSparseMatrix.m_nop) {
            double d;
            int n3 = pnSparseMatrix.getIndex(n2, n2);
            if (pnSparseMatrix.m_stiff[n2].m_data.length >= 1 && !(Math.abs(d = 1.0 / pnSparseMatrix.m_stiff[n2].m_data[n3]) < 1.0E-10)) {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = n * n2 + n4;
                    pdVector.m_data[n5] = pdVector.m_data[n5] * d;
                    ++n4;
                }
                n4 = 0;
                while (n4 < pnSparseMatrix.m_snoe.m_data[n2]) {
                    int n6 = n4++;
                    pnSparseMatrix.m_stiff[n2].m_data[n6] = pnSparseMatrix.m_stiff[n2].m_data[n6] * d;
                }
            }
            ++n2;
        }
    }

    public static void preconditionJacobiLeft(PnSparseMatrix pnSparseMatrix, PdVector pdVector) {
        PnBiconjugateGradient.preconditionJacobiLeft(pnSparseMatrix, pdVector, 1);
    }

    public int getActualNumOfTakenIterations() {
        return this.m_iter;
    }

    public void setDimension(int n) {
        this.m_dim = n;
    }

    public int getDimension() {
        return this.m_dim;
    }

    private void setSize(int n) {
        this.m_size = n;
        this.m_p.setSize(n * this.m_dim);
        this.m_pp.setSize(n * this.m_dim);
        this.m_r.setSize(n * this.m_dim);
        this.m_rr.setSize(n * this.m_dim);
        this.m_z.setSize(n * this.m_dim);
        this.m_zz.setSize(n * this.m_dim);
    }

    public double getActualEstimatedError() {
        return this.m_err;
    }

    public void setTolerance(double d) {
        this.m_tol = d;
    }
}

