/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jvx.numeric.PnEnergy;
import jvx.numeric.PnStiffConformal;

public class PnConfEnergy
extends PnEnergy {
    private static /* synthetic */ Class class$jvx$numeric$PnConfEnergy;

    public boolean setSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (!super.setSurface(pgElementSet, pgElementSet2)) {
            return false;
        }
        if (pgElementSet.isConforming() != pgElementSet2.isConforming()) {
            PsDebug.error((String)"domain and surface have different conformality", (Object)((Object)this));
            return false;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)("domain=" + pgElementSet.getName() + " not triangulated"));
            PgElementSet.triangulate((PgElementSet)pgElementSet);
        }
        if (pgElementSet2.getDimOfElements() != 3) {
            PsDebug.warning((String)("surface=" + pgElementSet2.getName() + " not triangulated"));
            PgElementSet.triangulate((PgElementSet)pgElementSet2);
        }
        this.m_stiffMatrix = this.m_domain.isConforming() ? new PnStiffConformal(pgElementSet, pgElementSet2) : new PnStiffConformal(pgElementSet, pgElementSet2);
        return true;
    }

    public PnConfEnergy() {
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnConfEnergy != null ? class$jvx$numeric$PnConfEnergy : (class$jvx$numeric$PnConfEnergy = PnConfEnergy.class$("jvx.numeric.PnConfEnergy")))) {
            this.init();
        }
    }

    public PdMatrix evalHessian(PdMatrix pdMatrix) {
        PsDebug.warning((String)"method not implemented yet");
        return pdMatrix;
    }

    public PdVector evalGradient(PdVector pdVector, PdVector pdVector2) {
        this.initStiff(pdVector);
        if (!this.m_bNormal && this.m_surface.hasVertexNormals()) {
            PdVector[] pdVectorArray = this.m_surface.getVertexNormals();
            int n = 0;
            int n2 = 0;
            while (n2 < this.m_nop) {
                int n3 = 0;
                while (n3 < this.m_dim) {
                    pdVectorArray[n2].m_data[n3] = pdVector.m_data[n + n3];
                    ++n3;
                }
                pdVectorArray[n2].normalize();
                n += this.m_dim;
                ++n2;
            }
        }
        return super.evalGradient(pdVector, pdVector2);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void initStiff(PdVector pdVector) {
        if (this.m_surface == null) {
            return;
        }
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_nop) {
            int n3 = 0;
            while (n3 < this.m_dim) {
                pdVectorArray[n2].m_data[n3] = pdVector.m_data[n++];
                ++n3;
            }
            ++n2;
        }
        this.m_stiffMatrix.init(this.m_domain, this.m_surface);
    }

    public void init() {
        super.init();
    }

    public double eval(PdVector pdVector) {
        this.initStiff(pdVector);
        if (!this.m_bNormal) {
            PdVector pdVector2 = new PdVector(this.m_dim);
            int n = 0;
            int n2 = 0;
            while (n2 < this.m_nop) {
                int n3 = 0;
                while (n3 < this.m_dim) {
                    pdVector2.m_data[n3] = pdVector.m_data[n + n3];
                    ++n3;
                }
                pdVector2.normalize();
                n3 = 0;
                while (n3 < this.m_dim) {
                    pdVector.m_data[n + n3] = pdVector2.m_data[n3];
                    ++n3;
                }
                n += this.m_dim;
                ++n2;
            }
        }
        return super.eval(pdVector);
    }

    public void initSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (this.m_stiffMatrix == null) {
            PsDebug.warning((String)"missing m_stiffMatrix, call setSurface before.");
            return;
        }
        super.initSurface(pgElementSet, pgElementSet2);
        this.m_stiffMatrix.init(pgElementSet, pgElementSet2);
    }
}

