/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import java.io.Serializable;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jvx.numeric.PnFunction;
import jvx.numeric.PnLinMin_Local;

public class PnConjugateGradient
implements Serializable {
    protected static int ITMAX = 100;
    protected static double EPS = 1.0E-14;
    private int m_iter;
    protected int m_size;
    protected PnLinMin_Local m_linmin = new PnLinMin_Local();
    protected PdVector m_g = new PdVector();
    protected PdVector m_h = new PdVector();
    protected PdVector m_xi = new PdVector();
    protected boolean m_bStopped;

    public double dfrprmn(PdVector pdVector, double d, PnFunction pnFunction) {
        this.m_bStopped = false;
        this.m_iter = 0;
        if (pdVector == null) {
            return 0.0;
        }
        if (this.m_size != pdVector.getSize()) {
            this.setSize(pdVector.getSize());
        }
        pnFunction.evalGradient(pdVector, this.m_xi);
        double d2 = pnFunction.eval(pdVector);
        int n = 0;
        while (n < this.m_size) {
            this.m_g.m_data[n] = -this.m_xi.m_data[n];
            this.m_xi.m_data[n] = this.m_h.m_data[n] = this.m_g.m_data[n];
            ++n;
        }
        int n2 = 1;
        while (n2 <= ITMAX) {
            this.m_iter = n2;
            double d3 = this.m_linmin.dlinmin(d, pdVector, this.m_xi, pnFunction);
            if (!pnFunction.isEvaluable()) {
                pnFunction.enableEvaluation(true);
                return d3;
            }
            if (2.0 * Math.abs(d3 - d2) <= d * (Math.abs(d3) + Math.abs(d2) + EPS)) {
                return d3;
            }
            pnFunction.evalGradient(pdVector, this.m_xi);
            d2 = pnFunction.eval(pdVector);
            double d4 = 0.0;
            double d5 = 0.0;
            n = 0;
            while (n < this.m_size) {
                d4 += this.m_g.m_data[n] * this.m_g.m_data[n];
                d5 += (this.m_xi.m_data[n] + this.m_g.m_data[n]) * this.m_xi.m_data[n];
                ++n;
            }
            if (d4 == 0.0) {
                return d3;
            }
            double d6 = d5 / d4;
            n = 0;
            while (n < this.m_size) {
                this.m_g.m_data[n] = -this.m_xi.m_data[n];
                this.m_xi.m_data[n] = this.m_h.m_data[n] = this.m_g.m_data[n] + d6 * this.m_h.m_data[n];
                ++n;
            }
            if (this.m_bStopped) {
                PsDebug.warning((String)("stopped by hand = " + this.m_iter));
                return d2;
            }
            ++n2;
        }
        PsDebug.warning((String)("too many iterations = " + this.m_iter));
        return d2;
    }

    protected void setSize(int n) {
        this.m_size = n;
        this.m_linmin.setDim(this.m_size);
        this.m_g.setSize(this.m_size);
        this.m_h.setSize(this.m_size);
        this.m_xi.setSize(this.m_size);
    }

    public int getNumIterations() {
        return this.m_iter;
    }
}

