/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jvx.geom.PwBary;
import jvx.numeric.PnGeodesicRK;

public class PnElementRK
extends PnGeodesicRK {
    protected PdBaryDir[] m_vec = null;

    public PnElementRK(PgElementSet pgElementSet) {
        super(pgElementSet);
    }

    public void setVectorField(PdBaryDir[] pdBaryDirArray) {
        this.m_vec = pdBaryDirArray;
    }

    public void setVectorField(PgVectorField pgVectorField) {
        int n = pgVectorField.getNumVectors();
        this.m_vec = new PdBaryDir[n];
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        int n2 = 0;
        while (n2 < n) {
            this.m_vec[n2] = new PdBaryDir(3);
            PwBary.projectOntoElement(this.m_geom, n2, pdVectorArray[n2], this.m_vec[n2]);
            ++n2;
        }
    }

    public void eval(int n, PdBary pdBary, PdBaryDir pdBaryDir) {
        pdBaryDir.setSize(3);
        pdBaryDir.copy(this.m_vec[n]);
        if (this.m_bInvert) {
            int n2 = 0;
            do {
                int n3 = n2++;
                pdBaryDir.m_data[n3] = pdBaryDir.m_data[n3] * -1.0;
            } while (n2 < 3);
        }
    }
}

