/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;
import jvx.numeric.PnConjugateGradient;
import jvx.numeric.PnEnergy;
import jvx.numeric.PnJacobi;

public class PnEnergyMinimizer
extends PsObject
implements Runnable {
    public static final int DIRICHLET = 1;
    public static final int AREA = 2;
    public static final int CONFORMAL = 3;
    public static final int SPRING = 4;
    public static final int ALIGNMENT = 5;
    public static final int VOLUME = 6;
    public static final int GAUSS = 7;
    protected PgElementSet m_domain;
    protected PgElementSet m_surface;
    protected PgVectorField m_vf;
    protected PdMatrix m_hessian;
    protected boolean m_bLogEnergy = false;
    protected boolean m_bReduceRedraw = false;
    protected boolean m_bUpdateNormals = false;
    protected boolean m_bUpdateDomain = true;
    protected boolean m_bDoublePrecision = true;
    protected boolean m_bFixMarkedVertices = true;
    protected PdVector m_coord;
    protected PnConjugateGradient m_cgMethod = new PnConjugateGradient();
    protected PnEnergy m_energy = null;
    protected int m_numLoops;
    protected int m_currLoop;
    protected double m_cgEps;
    protected double m_initialEnergy;
    protected double m_finalEnergy;
    protected int m_numIterations;
    protected Thread m_thread;
    protected PdVector[] m_eVector;
    protected PdVector m_eValue;
    protected int[] m_evSortInd;
    protected boolean m_bHessianIsL2Normalized = true;
    protected boolean m_bUseConstrainMatrix = false;
    protected double m_step = 0.01;
    protected boolean m_bUseSteps = false;
    protected boolean m_bRunning = false;
    protected boolean m_bStopped = true;
    private static /* synthetic */ Class class$jvx$numeric$PnEnergyMinimizer;

    public void stop() {
        if (this.m_bRunning) {
            this.m_bRunning = false;
            this.m_thread = null;
            this.m_cgMethod.m_bStopped = true;
            this.updatePanels(this);
        }
        this.m_bUseSteps = false;
    }

    public void printEigenvalues() {
        if (this.m_eVector == null && !this.computeEigenvectors()) {
            return;
        }
        PnJacobi.printEigenvalues(this.m_eValue.getSize(), this.m_eValue);
    }

    public double getInitialStepsize() {
        return this.m_step;
    }

    public void setInitialStepsize(double d) {
        this.m_step = d;
    }

    private void minimizeStep() {
        this.m_eVector = null;
        this.m_eValue = null;
        if (this.m_surface == null) {
            PsDebug.warning((String)"missing elementSet");
            return;
        }
        PnEnergyMinimizer pnEnergyMinimizer = this;
        synchronized (pnEnergyMinimizer) {
            block13: {
                this.m_energy.initSurface(this.m_domain, this.m_surface);
                this.m_finalEnergy = this.m_initialEnergy = this.m_energy.eval(this.m_coord);
                if (this.m_bLogEnergy) {
                    PsDebug.message((String)("\t " + PsConfig.getMessage((int)63009) + " = " + this.m_initialEnergy));
                }
                if (!this.m_bReduceRedraw) {
                    this.updatePanels(this);
                }
                this.m_finalEnergy = this.m_cgMethod.dfrprmn(this.m_coord, this.m_cgEps, this.m_energy);
                if (!this.m_bReduceRedraw) {
                    this.updatePanels(this);
                }
                this.m_numIterations = this.m_cgMethod.getNumIterations();
                if (this.m_bLogEnergy) {
                    PsDebug.message((String)("\t " + PsConfig.getMessage((int)63010) + "     = " + this.m_finalEnergy + " " + PsConfig.getMessage((int)63011) + " " + this.m_numIterations + " " + PsConfig.getMessage((int)63012)));
                }
                if (this.m_surface.getNumVertices() * this.m_surface.getDimOfVertices() != this.m_coord.getSize()) {
                    Object var8_2 = null;
                    return;
                }
                PdVector[] pdVectorArray = this.m_surface.getVertices();
                int n = this.m_surface.getDimOfVertices();
                int n2 = this.m_surface.getNumVertices();
                int n3 = 0;
                int n4 = 0;
                while (n4 < n2) {
                    int n5 = 0;
                    while (n5 < n) {
                        pdVectorArray[n4].m_data[n5] = this.m_coord.m_data[n3++];
                        ++n5;
                    }
                    ++n4;
                }
                if (this.m_bUpdateNormals) {
                    this.m_surface.makeVertexNormals();
                }
                if (this.m_surface.hasElementNormals()) {
                    this.m_surface.makeElementNormals();
                }
                if (this.m_domain == null || !this.m_bUpdateDomain || this.m_domain == this.m_surface || this.m_domain.getNumVertices() != n2 || this.m_domain.getDimOfVertices() != n) break block13;
                this.m_domain.copy((PsObject)this.m_surface);
            }
            Object var8_3 = null;
            return;
        }
    }

    public void step() {
        int n;
        int n2;
        int n3;
        int n4 = this.m_surface.getDimOfVertices();
        int n5 = this.m_surface.getNumVertices();
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        PdVector pdVector = null;
        this.m_initialEnergy = this.m_energy.eval(this.m_coord);
        pdVector = this.m_energy.evalGradient(this.m_coord, pdVector);
        double d = this.m_step;
        int n6 = 0;
        do {
            n3 = 0;
            n2 = 0;
            while (n2 < n5) {
                n = 0;
                while (n < n4) {
                    this.m_coord.m_data[n3] = pdVectorArray[n2].m_data[n] - d * pdVector.m_data[n3];
                    ++n3;
                    ++n;
                }
                ++n2;
            }
            d /= 5.0;
            this.m_finalEnergy = this.m_energy.eval(this.m_coord);
        } while (++n6 < 15 && this.m_initialEnergy <= this.m_finalEnergy);
        if (n6 < 15) {
            if (this.m_bLogEnergy) {
                PsDebug.message((String)("\t " + PsConfig.getMessage((int)63010) + "     = " + this.m_energy.eval(this.m_coord) + " " + PsConfig.getMessage((int)63013) + " h = " + d));
            }
        } else {
            PsDebug.warning((String)("unable to do a steepest descent with stepsize = " + d * 5.0));
            this.restoreCoords(this.m_coord, pdVectorArray, n5, n4);
            this.m_finalEnergy = this.m_initialEnergy;
            return;
        }
        n3 = 0;
        n2 = 0;
        while (n2 < n5) {
            n = 0;
            while (n < n4) {
                pdVectorArray[n2].m_data[n] = this.m_coord.m_data[n3++];
                ++n;
            }
            ++n2;
        }
        if (this.m_bUpdateNormals) {
            this.m_surface.makeVertexNormals();
        }
        if (this.m_surface.hasElementNormals()) {
            this.m_surface.makeElementNormals();
        }
    }

    public PgElementSet getDomain() {
        return this.m_domain;
    }

    public void step(int n) {
        this.m_bUseSteps = true;
        this.start();
    }

    public void printGradient() {
        PdVector pdVector = this.m_energy.evalGradient(this.m_coord, null);
        int n = this.m_surface.getDimOfVertices();
        int n2 = this.m_surface.getNumVertices();
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        StringBuffer stringBuffer = new StringBuffer(PsConfig.getMessage((int)63014) + " =\n");
        int n3 = Integer.toString(n2).length() + 1;
        int n4 = 0;
        while (n4 < n2) {
            stringBuffer.append("\t [" + PuString.intToString((int)n4, (int)n3) + "] = {");
            stringBuffer.append(String.valueOf(pdVector.getEntry(n4 * n)));
            int n5 = 1;
            while (n5 < n) {
                stringBuffer.append(", " + String.valueOf(pdVector.getEntry(n4 * n + n5)));
                ++n5;
            }
            if (pdVectorArray[n4].hasTag(14)) {
                stringBuffer.append("} Attr = { BND, ... }");
            }
            stringBuffer.append("}\n");
            ++n4;
        }
        PsDebug.message((String)stringBuffer.toString());
    }

    public void showNone() {
        if (this.m_surface != null) {
            this.m_surface.removeAllVectorFields();
        }
        this.m_vf = null;
        this.m_eVector = null;
        this.m_eValue = null;
        this.m_evSortInd = null;
    }

    public void setNumLoops(int n) {
        this.m_numLoops = n;
    }

    public boolean update(Object object) {
        if (this.m_domain != null && this.m_domain == object) {
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public boolean computeEigenvectors() {
        PsDebug.message((String)(PsConfig.getMessage((int)63016) + " ..."));
        if (this.m_eValue == null) {
            this.m_eValue = new PdVector();
        }
        PsDebug.message((String)("\t" + PsConfig.getMessage((int)63017) + "      = " + String.valueOf(this.m_bHessianIsL2Normalized)));
        PsDebug.message((String)("\t" + PsConfig.getMessage((int)63018) + " = " + this.m_bUseConstrainMatrix));
        PsDebug.message((String)("\t... " + PsConfig.getMessage((int)63019) + "           = " + this.m_energy.m_bUseConstrainMatrix));
        if (this.m_bHessianIsL2Normalized) {
            PsDebug.message((String)("\t" + PsConfig.getMessage((int)63030)));
            this.m_eVector = this.m_energy.getSpectrum(this.m_eValue, this.m_eVector);
            PsDebug.message((String)("\t" + PsConfig.getMessage((int)63031)));
            int n = this.m_eValue.getSize();
            this.m_evSortInd = new int[n];
            PuMath.heapsort((int)n, (double[])this.m_eValue.m_data, (int[])this.m_evSortInd);
        } else {
            PsDebug.message((String)("\t" + PsConfig.getMessage((int)63030)));
            this.m_hessian = this.m_energy.evalHessian(this.m_hessian);
            PsDebug.message((String)("\t" + PsConfig.getMessage((int)63031)));
            int n = this.m_hessian.getSize();
            if (n == -1) {
                PsDebug.message((String)("\t..." + PsConfig.getMessage((int)63020)));
                PsDebug.error((String)"Hessian is non-square matrix", (Object)this.m_hessian);
                return false;
            }
            if (this.m_energy.m_bUseConstrainMatrix) {
                PsDebug.message((String)("\t" + PsConfig.getMessage((int)63032)));
                PdMatrix pdMatrix = this.m_energy.m_constrain;
                PdMatrix pdMatrix2 = new PdMatrix(n);
                pdMatrix2.mult(this.m_hessian, pdMatrix);
                PdMatrix pdMatrix3 = pdMatrix;
                pdMatrix3.transpose();
                this.m_hessian.mult(pdMatrix3, pdMatrix2);
                PsDebug.message((String)("\t" + PsConfig.getMessage((int)63031)));
            }
            this.m_eValue.setSize(n);
            this.m_evSortInd = new int[n];
            this.m_eVector = PdVector.realloc((PdVector[])this.m_eVector, (int)n, (int)n);
            int n2 = 0;
            if (this.m_bDoublePrecision) {
                PsDebug.message((String)("\t" + PsConfig.getMessage((int)63033)));
                n2 = PnJacobi.computeEigenvectors(this.m_hessian, n, this.m_eValue, this.m_eVector);
            } else {
                PsDebug.message((String)("\t" + PsConfig.getMessage((int)63034)));
                n2 = PnJacobi.fcomputeEigenvectors(this.m_hessian, n, this.m_eValue, this.m_eVector);
            }
            if (PnJacobi.isInterrupted()) {
                PsDebug.warning((String)"Computation of spectrum aborted by user.");
                return false;
            }
            PsDebug.message((String)("\t" + PsConfig.getMessage((int)63031)));
            PuMath.heapsort((int)n, (double[])this.m_eValue.m_data, (int[])this.m_evSortInd);
        }
        PsDebug.message((String)("\t..." + PsConfig.getMessage((int)63021)));
        return true;
    }

    public void printEigenvectors() {
        if (this.m_eVector == null && !this.computeEigenvectors()) {
            return;
        }
        PnJacobi.printEigenvectors(this.m_eValue.getSize(), this.m_eValue, this.m_eVector);
    }

    public boolean isEnabledConstrainMatrix() {
        return this.m_bUseConstrainMatrix;
    }

    public void start() {
        if (!this.m_bStopped || this.m_bRunning) {
            return;
        }
        this.m_currLoop = 0;
        if (this.m_currLoop >= this.m_numLoops) {
            return;
        }
        this.m_bRunning = true;
        this.m_thread = new Thread((Runnable)this, "JavaView: Energy Minimization");
        this.m_thread.setPriority(5);
        this.m_thread.start();
    }

    public double minimize() {
        this.start();
        return this.m_finalEnergy;
    }

    public void setEnabledFixVertices(boolean bl) {
        if (this.m_bFixMarkedVertices == bl) {
            return;
        }
        this.m_bFixMarkedVertices = bl;
        if (this.m_energy != null) {
            this.m_energy.m_bFixMarkedVertices = bl;
        }
    }

    public void printHessian() {
        this.m_hessian = this.m_energy.evalHessian(this.m_hessian);
        PsDebug.message((String)(PsConfig.getMessage((int)63015) + " = \n" + this.m_hessian.toString()));
    }

    public boolean isStopped() {
        return this.m_bStopped;
    }

    public boolean isRunning() {
        return this.m_bRunning;
    }

    public boolean isEnabledFixVertices() {
        return this.m_bFixMarkedVertices;
    }

    public PgElementSet getSurface() {
        return this.m_surface;
    }

    public boolean setSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (pgElementSet2 == null) {
            PsDebug.error((String)"missing surface", (Object)this);
            return false;
        }
        if (pgElementSet != null && pgElementSet.getNumElements() != pgElementSet2.getNumElements()) {
            pgElementSet.copy((PsObject)pgElementSet2);
        }
        PnEnergyMinimizer pnEnergyMinimizer = this;
        synchronized (pnEnergyMinimizer) {
            block11: {
                this.m_domain = pgElementSet;
                this.m_surface = pgElementSet2;
                if (!(!this.m_bUpdateNormals || this.m_energy != null && this.m_energy.m_bTangential && this.m_energy.m_bNormal)) {
                    pgElementSet2.makeVertexNormals();
                }
                this.m_vf = this.m_surface.getVectorField(PsConfig.getMessage((int)45053));
                if (this.m_vf != null) {
                    this.m_vf.setGeometry((PgPointSet)this.m_surface);
                } else {
                    this.showNone();
                }
                int n = this.m_surface.getDimOfVertices();
                int n2 = this.m_surface.getNumVertices();
                PdVector[] pdVectorArray = this.m_surface.getVertices();
                this.m_coord.setSize(n * n2);
                int n3 = 0;
                int n4 = 0;
                while (n4 < n2) {
                    int n5 = 0;
                    while (n5 < n) {
                        this.m_coord.m_data[n3++] = pdVectorArray[n4].m_data[n5];
                        ++n5;
                    }
                    ++n4;
                }
                this.m_initialEnergy = Double.NaN;
                this.m_finalEnergy = Double.NaN;
                if (this.m_energy == null) break block11;
                if (!this.m_energy.setSurface(pgElementSet, pgElementSet2)) {
                    boolean bl = false;
                    Object var10_11 = null;
                    return bl;
                }
                this.m_finalEnergy = this.m_initialEnergy = this.m_energy.eval(this.m_coord);
            }
            Object var10_12 = null;
        }
        this.updatePanels(this);
        return true;
    }

    public PnEnergyMinimizer() {
        this.m_coord = new PdVector();
        if (this.getClass() == (class$jvx$numeric$PnEnergyMinimizer != null ? class$jvx$numeric$PnEnergyMinimizer : (class$jvx$numeric$PnEnergyMinimizer = PnEnergyMinimizer.class$("jvx.numeric.PnEnergyMinimizer")))) {
            this.init();
        }
    }

    public void enableUpdateDomain(boolean bl) {
        this.m_bUpdateDomain = bl;
    }

    public void setUpdateDomain(boolean bl) {
        if (this.m_bUpdateDomain == bl) {
            return;
        }
        this.m_bUpdateDomain = bl;
        if (bl && this.m_domain != null && this.m_surface != null && this.m_domain != this.m_surface && this.m_domain.getNumVertices() == this.m_surface.getNumVertices() && this.m_domain.getDimOfVertices() == this.m_surface.getDimOfVertices()) {
            this.m_domain.copy((PsObject)this.m_surface);
        }
    }

    public void setEnabledConstrainMatrix(boolean bl) {
        this.m_bUseConstrainMatrix = bl;
        this.showNone();
        if (this.m_energy != null) {
            this.m_energy.setEnabledConstrainMatrix(bl);
            this.m_energy.setSurface(this.m_domain, this.m_surface);
        }
    }

    public void showGradient() {
        PdVector pdVector = this.m_energy.evalGradient(this.m_coord, null);
        int n = this.m_surface.getDimOfVertices();
        int n2 = this.m_surface.getNumVertices();
        if (this.m_vf != null) {
            this.m_vf = this.m_surface.getVectorField(PsConfig.getMessage((int)45053));
        }
        if (this.m_vf == null) {
            this.m_vf = new PgVectorField(n);
            this.m_vf.setName(PsConfig.getMessage((int)45053));
            this.m_surface.addVectorField(this.m_vf);
        }
        this.m_vf.setGeometry((PgPointSet)this.m_surface);
        PdVector[] pdVectorArray = this.m_vf.getVectors();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                pdVectorArray[n4].m_data[n5] = pdVector.m_data[n3++];
                ++n5;
            }
            ++n4;
        }
    }

    public void showEigenvector(int n) {
        int n2 = this.m_surface.getDimOfVertices();
        int n3 = this.m_surface.getNumVertices();
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        if (this.m_eVector == null && !this.computeEigenvectors()) {
            return;
        }
        this.m_vf = this.m_surface.getVectorField(PsConfig.getMessage((int)45053));
        if (this.m_vf == null) {
            this.m_vf = new PgVectorField(n2);
            this.m_vf.setName(PsConfig.getMessage((int)45053));
            this.m_surface.addVectorField(this.m_vf);
        }
        this.m_vf.setGeometry((PgPointSet)this.m_surface);
        PdVector[] pdVectorArray2 = this.m_vf.getVectors();
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            try {
                if (!this.m_energy.m_bUseConstrainMatrix && pdVectorArray[n6].hasTag(14)) {
                    pdVectorArray2[n6].setConstant(0.0);
                } else {
                    n4 = 0;
                    while (n4 < n2) {
                        pdVectorArray2[n6].m_data[n4] = this.m_eVector[this.m_evSortInd[n]].m_data[n5];
                        ++n5;
                        ++n4;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                PsDebug.warning((String)("ArrayIndexOutOfBoundsException, i=" + n6 + ", k=" + n4 + ", ipos=" + n5));
            }
            ++n6;
        }
    }

    private void restoreCoords(PdVector pdVector, PdVector[] pdVectorArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                pdVector.m_data[n3++] = pdVectorArray[n4].m_data[n5];
                ++n5;
            }
            ++n4;
        }
    }

    public PnEnergy getEnergy() {
        return this.m_energy;
    }

    public void setEnergy(PnEnergy pnEnergy) {
        this.m_energy = pnEnergy;
        if (this.m_surface != null) {
            this.m_energy.m_bFixMarkedVertices = this.isEnabledFixVertices();
            this.m_energy.setEnabledConstrainMatrix(this.isEnabledConstrainMatrix());
            this.m_energy.setSurface(this.m_domain, this.m_surface);
            this.m_finalEnergy = this.m_initialEnergy = this.m_energy.eval(this.m_coord);
        }
        this.showNone();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void saveEigenvectors() {
        if (this.m_eVector == null && !this.computeEigenvectors()) {
            return;
        }
        this.m_surface.removeAllVectorFields();
        int n = this.m_surface.getDimOfVertices();
        int n2 = this.m_surface.getNumVertices();
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        int n3 = this.m_eVector.length;
        int n4 = 0;
        while (n4 < n3) {
            PgVectorField pgVectorField = new PgVectorField(n);
            pgVectorField.setName(PsConfig.getMessage((int)45055) + "[" + String.valueOf(n4) + "]");
            this.m_surface.addVectorField(pgVectorField);
            pgVectorField.setGeometry((PgPointSet)this.m_surface);
            PdVector[] pdVectorArray2 = pgVectorField.getVectors();
            int n5 = -1;
            int n6 = 0;
            int n7 = 0;
            while (n7 < n2) {
                try {
                    if (!this.m_energy.m_bUseConstrainMatrix && pdVectorArray[n7].hasTag(14)) {
                        pdVectorArray2[n7].setConstant(0.0);
                    } else {
                        n5 = 0;
                        while (n5 < n) {
                            pdVectorArray2[n7].m_data[n5] = this.m_eVector[this.m_evSortInd[n4]].m_data[n6];
                            ++n6;
                            ++n5;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    PsDebug.warning((String)("ArrayIndexOutOfBoundsException, i=" + n7 + ", k=" + n5 + ", ipos=" + n6));
                }
                ++n7;
            }
            ++n4;
        }
    }

    public void run() {
        this.m_bStopped = false;
        while (this.m_thread != null && this.m_bRunning) {
            if (this.m_bUseSteps) {
                this.step();
            } else {
                this.minimizeStep();
            }
            ++this.m_currLoop;
            if (!this.m_bReduceRedraw || (this.m_numLoops - this.m_currLoop) % 5 == 0) {
                this.update(this);
            }
            if (this.m_currLoop >= this.m_numLoops) {
                this.stop();
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.m_bStopped = true;
        this.update(this);
    }

    public void init() {
        super.init();
        this.stop();
        this.m_numLoops = 1;
        this.m_initialEnergy = Double.NaN;
        this.m_finalEnergy = Double.NaN;
        this.m_cgEps = 1.0E-10;
        this.showNone();
    }
}

