/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import java.util.Date;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;

public class PnJacobi {
    public static final int FAILURE = -1;
    public static final int INTERRUPTED = -2;
    protected static boolean m_bInterrupted;

    public static void printEigenvalues(int n, PdVector pdVector) {
        int n2 = (int)PuMath.log((double)10.0, (double)n) + 1 + 1;
        int[] nArray = new int[n];
        PuMath.heapsort((int)n, (double[])pdVector.m_data, (int[])nArray);
        StringBuffer stringBuffer = new StringBuffer(PsConfig.getMessage((int)63026) + ":\n");
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append(" eValue[" + PuString.intToString((int)n3, (int)n2) + "] = " + String.valueOf(pdVector.getEntry(nArray[n3])) + "\n");
            ++n3;
        }
        PsDebug.message((String)stringBuffer.toString());
    }

    public static boolean test(PdMatrix pdMatrix, int n, PdVector pdVector, PdVector[] pdVectorArray) {
        int n2 = (int)PuMath.log((double)10.0, (double)n) + 1 + 1;
        boolean bl = true;
        PdVector pdVector2 = new PdVector(n);
        StringBuffer stringBuffer = new StringBuffer(PsConfig.getMessage((int)63027) + ":\n");
        int n3 = 0;
        while (n3 < n) {
            pdVector2.setConstant(0.0);
            pdVector2.leftMultMatrix(pdMatrix, pdVectorArray[n3]);
            pdVectorArray[n3].multScalar(pdVector.getEntry(n3));
            pdVector2.sub(pdVectorArray[n3]);
            double d = pdVector2.length();
            stringBuffer.append("\t Abs(Mat*eVec[" + PuString.intToString((int)n3, (int)n2) + "]-eValue[" + PuString.intToString((int)n3, (int)n2) + "]*eVec[" + PuString.intToString((int)n3, (int)n2) + "]) = " + d + "\n");
            if (d > 1.0E-10) {
                bl = false;
            }
            ++n3;
        }
        PsDebug.message((String)stringBuffer.toString());
        return bl;
    }

    public static int fcomputeEigenvectors(PdMatrix pdMatrix, int n, PdVector pdVector, PdVector[] pdVectorArray) {
        int n2;
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        float[] fArray3 = new float[n];
        float[][] fArray4 = new float[n][n];
        int n3 = 0;
        while (n3 < n) {
            n2 = 0;
            while (n2 < n) {
                fArray4[n3][n2] = (float)pdMatrix.m_data[n3][n2];
                ++n2;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            pdVectorArray[n4].setConstant(0.0);
            pdVectorArray[n4].setEntry(n4, 1.0);
            fArray2[n4] = fArray4[n4][n4];
            fArray[n4] = fArray2[n4];
            fArray3[n4] = 0.0f;
            ++n4;
        }
        int n5 = 0;
        double d = new Date().getTime();
        n3 = 0;
        do {
            int n6;
            PsDebug.message((String)("Jacobi iteration = " + String.valueOf(n3)));
            float f = 0.0f;
            n4 = 0;
            while (n4 < n - 1) {
                n6 = n4 + 1;
                while (n6 < n) {
                    f += Math.abs(fArray4[n4][n6]);
                    ++n6;
                }
                ++n4;
            }
            if ((double)f < 1.0E-10) {
                n4 = 0;
                while (n4 < n) {
                    pdVector.m_data[n4] = fArray[n4];
                    ++n4;
                }
                return n5;
            }
            float f2 = n3 < 3 ? 0.2f * f / (float)(n * n) : 0.0f;
            n4 = 0;
            while (n4 < n - 1) {
                if (m_bInterrupted) {
                    return -2;
                }
                n6 = n4 + 1;
                while (n6 < n) {
                    float f3 = 100.0f * Math.abs(fArray4[n4][n6]);
                    if (n3 > 3 && Math.abs(fArray[n4]) + f3 == Math.abs(fArray[n4]) && Math.abs(fArray[n6]) + f3 == Math.abs(fArray[n6])) {
                        fArray4[n4][n6] = 0.0f;
                    } else if (Math.abs(fArray4[n4][n6]) > f2) {
                        float f4;
                        float f5 = fArray[n6] - fArray[n4];
                        if (Math.abs(f5) + f3 == Math.abs(f5)) {
                            f4 = fArray4[n4][n6] / f5;
                        } else {
                            float f6 = 0.5f * f5 / fArray4[n4][n6];
                            f4 = 1.0f / (Math.abs(f6) + (float)Math.sqrt(1.0f + f6 * f6));
                            if (f6 < 0.0f) {
                                f4 = -f4;
                            }
                        }
                        float f7 = 1.0f / (float)Math.sqrt(1.0f + f4 * f4);
                        float f8 = f4 * f7;
                        float f9 = f8 / (1.0f + f7);
                        f5 = f4 * fArray4[n4][n6];
                        int n7 = n4;
                        fArray3[n7] = fArray3[n7] - f5;
                        int n8 = n6;
                        fArray3[n8] = fArray3[n8] + f5;
                        int n9 = n4;
                        fArray[n9] = fArray[n9] - f5;
                        int n10 = n6;
                        fArray[n10] = fArray[n10] + f5;
                        fArray4[n4][n6] = 0.0f;
                        n2 = 0;
                        while (n2 < n4) {
                            f3 = fArray4[n2][n4];
                            f5 = fArray4[n2][n6];
                            fArray4[n2][n4] = f3 - f8 * (f5 + f3 * f9);
                            fArray4[n2][n6] = f5 + f8 * (f3 - f5 * f9);
                            ++n2;
                        }
                        n2 = n4 + 1;
                        while (n2 < n6) {
                            f3 = fArray4[n4][n2];
                            f5 = fArray4[n2][n6];
                            fArray4[n4][n2] = f3 - f8 * (f5 + f3 * f9);
                            fArray4[n2][n6] = f5 + f8 * (f3 - f5 * f9);
                            ++n2;
                        }
                        n2 = n6 + 1;
                        while (n2 < n) {
                            f3 = fArray4[n4][n2];
                            f5 = fArray4[n6][n2];
                            fArray4[n4][n2] = f3 - f8 * (f5 + f3 * f9);
                            fArray4[n6][n2] = f5 + f8 * (f3 - f5 * f9);
                            ++n2;
                        }
                        n2 = 0;
                        while (n2 < n) {
                            f3 = (float)pdVectorArray[n4].m_data[n2];
                            f5 = (float)pdVectorArray[n6].m_data[n2];
                            pdVectorArray[n4].m_data[n2] = f3 - f8 * (f5 + f3 * f9);
                            pdVectorArray[n6].m_data[n2] = f5 + f8 * (f3 - f5 * f9);
                            ++n2;
                        }
                        ++n5;
                    }
                    ++n6;
                }
                ++n4;
            }
            n4 = 0;
            while (n4 < n) {
                int n11 = n4;
                fArray2[n11] = fArray2[n11] + fArray3[n4];
                fArray[n4] = fArray2[n4];
                fArray3[n4] = 0.0f;
                ++n4;
            }
            double d2 = new Date().getTime();
            PsDebug.message((String)("\tDuration of Loop (ms, float) = " + String.valueOf((float)(d2 - d))));
            d = d2;
        } while (++n3 < 50);
        PsDebug.warning((String)"Too many iterations in routine jacobi");
        return n5;
    }

    public static void setInterrupted(boolean bl) {
        m_bInterrupted = bl;
    }

    public static boolean isInterrupted() {
        return m_bInterrupted;
    }

    public static int computeEigenvectors(PdMatrix pdMatrix, int n, PdVector pdVector, PdVector[] pdVectorArray) {
        int n2;
        double[] dArray = pdVector.m_data;
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[][] dArray4 = new double[n][n];
        int n3 = 0;
        while (n3 < n) {
            n2 = 0;
            while (n2 < n) {
                dArray4[n3][n2] = pdMatrix.m_data[n3][n2];
                ++n2;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            pdVectorArray[n4].setConstant(0.0);
            pdVectorArray[n4].setEntry(n4, 1.0);
            dArray2[n4] = dArray4[n4][n4];
            dArray[n4] = dArray2[n4];
            dArray3[n4] = 0.0;
            ++n4;
        }
        int n5 = 0;
        n3 = 0;
        do {
            int n6;
            double d = 0.0;
            n4 = 0;
            while (n4 < n - 1) {
                n6 = n4 + 1;
                while (n6 < n) {
                    d += Math.abs(dArray4[n4][n6]);
                    ++n6;
                }
                ++n4;
            }
            if (d < 1.0E-10) {
                return n5;
            }
            double d2 = n3 < 3 ? 0.2 * d / (double)(n * n) : 0.0;
            n4 = 0;
            while (n4 < n - 1) {
                if (m_bInterrupted) {
                    return -2;
                }
                n6 = n4 + 1;
                while (n6 < n) {
                    double d3 = 100.0 * Math.abs(dArray4[n4][n6]);
                    if (n3 > 3 && (float)(Math.abs(dArray[n4]) + d3) == (float)Math.abs(dArray[n4]) && (float)(Math.abs(dArray[n6]) + d3) == (float)Math.abs(dArray[n6])) {
                        dArray4[n4][n6] = 0.0;
                    } else if (Math.abs(dArray4[n4][n6]) > d2) {
                        double d4;
                        double d5 = dArray[n6] - dArray[n4];
                        if ((float)(Math.abs(d5) + d3) == (float)Math.abs(d5)) {
                            d4 = dArray4[n4][n6] / d5;
                        } else {
                            double d6 = 0.5 * d5 / dArray4[n4][n6];
                            d4 = 1.0 / (Math.abs(d6) + Math.sqrt(1.0 + d6 * d6));
                            if (d6 < 0.0) {
                                d4 = -d4;
                            }
                        }
                        double d7 = 1.0 / Math.sqrt(1.0 + d4 * d4);
                        double d8 = d4 * d7;
                        double d9 = d8 / (1.0 + d7);
                        d5 = d4 * dArray4[n4][n6];
                        int n7 = n4;
                        dArray3[n7] = dArray3[n7] - d5;
                        int n8 = n6;
                        dArray3[n8] = dArray3[n8] + d5;
                        int n9 = n4;
                        dArray[n9] = dArray[n9] - d5;
                        int n10 = n6;
                        dArray[n10] = dArray[n10] + d5;
                        dArray4[n4][n6] = 0.0;
                        n2 = 0;
                        while (n2 < n4) {
                            d3 = dArray4[n2][n4];
                            d5 = dArray4[n2][n6];
                            dArray4[n2][n4] = d3 - d8 * (d5 + d3 * d9);
                            dArray4[n2][n6] = d5 + d8 * (d3 - d5 * d9);
                            ++n2;
                        }
                        n2 = n4 + 1;
                        while (n2 < n6) {
                            d3 = dArray4[n4][n2];
                            d5 = dArray4[n2][n6];
                            dArray4[n4][n2] = d3 - d8 * (d5 + d3 * d9);
                            dArray4[n2][n6] = d5 + d8 * (d3 - d5 * d9);
                            ++n2;
                        }
                        n2 = n6 + 1;
                        while (n2 < n) {
                            d3 = dArray4[n4][n2];
                            d5 = dArray4[n6][n2];
                            dArray4[n4][n2] = d3 - d8 * (d5 + d3 * d9);
                            dArray4[n6][n2] = d5 + d8 * (d3 - d5 * d9);
                            ++n2;
                        }
                        n2 = 0;
                        while (n2 < n) {
                            d3 = pdVectorArray[n4].m_data[n2];
                            d5 = pdVectorArray[n6].m_data[n2];
                            pdVectorArray[n4].m_data[n2] = d3 - d8 * (d5 + d3 * d9);
                            pdVectorArray[n6].m_data[n2] = d5 + d8 * (d3 - d5 * d9);
                            ++n2;
                        }
                        ++n5;
                    }
                    ++n6;
                }
                ++n4;
            }
            n4 = 0;
            while (n4 < n) {
                int n11 = n4;
                dArray2[n11] = dArray2[n11] + dArray3[n4];
                dArray[n4] = dArray2[n4];
                dArray3[n4] = 0.0;
                ++n4;
            }
        } while (++n3 < 50);
        PsDebug.warning((String)"Too many iterations in routine jacobi");
        return n5;
    }

    public static void printEigenvectors(int n, PdVector pdVector, PdVector[] pdVectorArray) {
        int n2 = (int)PuMath.log((double)10.0, (double)n) + 1 + 1;
        int[] nArray = new int[n];
        PuMath.heapsort((int)n, (double[])pdVector.m_data, (int[])nArray);
        StringBuffer stringBuffer = new StringBuffer(PsConfig.getMessage((int)63025) + ":\n");
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append(" eValue[" + PuString.intToString((int)n3, (int)n2) + "] = " + String.valueOf(pdVector.getEntry(nArray[n3])));
            stringBuffer.append(" eVector[" + PuString.intToString((int)n3, (int)n2) + "] = ");
            stringBuffer.append(pdVectorArray[nArray[n3]].toShortString());
            ++n3;
        }
        PsDebug.message((String)stringBuffer.toString());
    }
}

