/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.objectGui.PsScanline;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PwBary;
import jvx.numeric.PnGeodesicRK;
import jvx.numeric.PnNoise;

public class PnLIC {
    protected PgElementSet m_geom;
    protected int m_maxhits = 3;
    protected PnGeodesicRK m_rk;
    protected double m_integralh = 1.0;
    protected int m_width;
    protected int m_height;
    protected int[] m_pix;
    protected PdVector[][] m_texCoords;
    protected double m_steplen;
    protected int m_kernelwidth = 100;
    protected int m_minKernel = 1;
    protected double m_kernelwidthWorld = 1.0;
    protected double m_minKernelWorld = 0.0;
    protected float m_coarseness = 1.0f;
    protected PnNoise m_noise;
    private PgPolygonOnElementSet m_poly;
    private PgPolygonOnElementSet m_lastpoly;
    private PiVector m_evalelem;
    private PdVector[] m_evalbary;
    private int m_evalsize;
    private PiVector m_evalx;
    private PiVector m_evaly;
    private PdVector m_noisecol;
    private PiVector m_kernelW;
    private int m_nextkernelw;
    private int m_nextpolysize;
    private boolean m_nextedgereached;
    private double m_kernelFac;
    private static final int m_maxIter = 30;
    private static PiVector[] m_oneTexCoord = new PiVector[3];
    private PdBary m_point = new PdBary(3);
    private PdVector m_texpoint = new PdVector(2);
    private PdBary m_eval = new PdBary(3);
    private PdVector[] m_coord = null;
    private static int VGAP = 8;
    protected static boolean m_bKeepTransparency = true;

    public void setRungeKutta(PnGeodesicRK pnGeodesicRK) {
        this.m_rk = pnGeodesicRK;
    }

    public int getTextureHeight() {
        return this.m_height;
    }

    private void makeEvalXY(int n, int n2, PdBary pdBary, PdVector[] pdVectorArray, PdVector pdVector) {
        pdVectorArray = this.m_texCoords[this.m_evalelem.m_data[n]];
        int n3 = 0;
        do {
            pdBary.m_data[n3] = this.m_evalbary[n3].m_data[n];
        } while (++n3 < 3);
        PdBary.getVertex((PdVector)pdVector, (PdBary)pdBary, (PdVector)pdVectorArray[0], (PdVector)pdVectorArray[1], (PdVector)pdVectorArray[2]);
        this.m_evalx.m_data[n2] = (int)Math.round(pdVector.m_data[0] * ((double)(this.m_width - 1) - 0.98) + 0.49);
        this.m_evaly.m_data[n2] = (int)Math.round((1.0 - pdVector.m_data[1]) * ((double)(this.m_height - 1) - 0.98) + 0.49);
    }

    public int[] getPixArray(int[] nArray) {
        return this.getPixArray(nArray, 10.0);
    }

    public int[] getPixArray(int[] nArray, double d) {
        int n;
        if (this.m_pix == null) {
            return null;
        }
        if (nArray == null) {
            nArray = new int[this.m_pix.length];
        }
        if ((n = this.m_pix.length) > nArray.length) {
            n = nArray.length;
        }
        int[] nArray2 = new int[256];
        int n2 = 0;
        do {
            nArray2[n2] = (int)(256.0 / (1.0 + Math.exp(-d * (double)(n2 - 128) / 256.0)));
        } while (++n2 < 256);
        n2 = 0;
        while (n2 < n) {
            int n3 = this.m_pix[n2] >> 24 & 0xFF;
            int n4 = this.m_pix[n2] & 0xFFFFFF;
            if (n3 != 0) {
                n4 /= n3;
            }
            if (n4 >= 255) {
                n4 = 255;
            } else if (n4 != 0) {
                n4 = nArray2[n4];
            }
            nArray[n2] = -16777216 + (n4 << 16) + (n4 << 8) + n4;
            ++n2;
        }
        return nArray;
    }

    public void reset() {
        if (this.m_pix == null) {
            return;
        }
        int n = this.m_pix.length - 1;
        while (n >= 0) {
            this.m_pix[n] = 0;
            --n;
        }
    }

    public static synchronized int getOutline(PdVector[] pdVectorArray, int n, int n2, PiVector piVector, PiVector piVector2) {
        int n3;
        int n4;
        if (m_oneTexCoord[0] == null) {
            n4 = 0;
            do {
                PnLIC.m_oneTexCoord[n4] = new PiVector(2);
            } while (++n4 < 3);
        }
        n4 = 0;
        do {
            PnLIC.m_oneTexCoord[n4].m_data[0] = (int)(pdVectorArray[n4].m_data[0] * (double)(n - 1));
            PnLIC.m_oneTexCoord[n4].m_data[1] = (int)((1.0 - pdVectorArray[n4].m_data[1]) * (double)(n2 - 1));
        } while (++n4 < 3);
        int n5 = PnLIC.m_oneTexCoord[0].m_data[1];
        int n6 = 0;
        int n7 = n5;
        int n8 = 1;
        while (n8 < m_oneTexCoord.length) {
            if (n5 > PnLIC.m_oneTexCoord[n8].m_data[1] || n5 >= PnLIC.m_oneTexCoord[n8].m_data[1] && n8 == n6 + 1) {
                n5 = PnLIC.m_oneTexCoord[n8].m_data[1];
                n6 = n8;
            }
            if (n7 < PnLIC.m_oneTexCoord[n8].m_data[1]) {
                n7 = PnLIC.m_oneTexCoord[n8].m_data[1];
            }
            ++n8;
        }
        int n9 = (n7 - n5 + 1) * 2;
        piVector.setSize(n9);
        piVector2.setSize(n9);
        if (n9 == 2) {
            int n10 = Integer.MAX_VALUE;
            int n11 = Integer.MIN_VALUE;
            n4 = 0;
            do {
                if (PnLIC.m_oneTexCoord[n4].m_data[0] < n10) {
                    n10 = PnLIC.m_oneTexCoord[n4].m_data[0];
                }
                if (PnLIC.m_oneTexCoord[n4].m_data[1] <= n11) continue;
                n11 = PnLIC.m_oneTexCoord[n4].m_data[0];
            } while (++n4 < 3);
            piVector.setEntry(0, n10);
            piVector.setEntry(1, n11);
            piVector2.setEntry(0, PnLIC.m_oneTexCoord[0].m_data[1]);
            piVector2.setEntry(1, PnLIC.m_oneTexCoord[0].m_data[1]);
            n3 = 2;
        } else {
            int n12;
            n3 = 0;
            n4 = n6;
            while (n4 < n6 + 3) {
                int n13 = n4 % 3;
                n12 = (n4 + 1) % 3;
                int n14 = PnLIC.m_oneTexCoord[n13].m_data[0];
                int n15 = PnLIC.m_oneTexCoord[n13].m_data[1];
                int n16 = PnLIC.m_oneTexCoord[n12].m_data[1] - n15;
                int n17 = n16 < 0 ? -n16 : n16;
                int n18 = PnLIC.m_oneTexCoord[n12].m_data[0] - n14;
                if (n17 != 0 || n18 != 0) {
                    int n19 = 0;
                    int n20 = 1;
                    if (n16 < 0) {
                        n20 = -1;
                    }
                    if (n16 < 0) {
                        n16 = -n16;
                    }
                    int n21 = 1;
                    if (n18 < 0) {
                        n21 = -1;
                    }
                    if (n18 < 0) {
                        n18 = -n18;
                    }
                    do {
                        piVector.m_data[n3] = n14;
                        piVector2.m_data[n3] = n15;
                        n15 += n20;
                        n19 += n18;
                        while (n19 >= n16 && n16 != 0) {
                            n14 += n21;
                            n19 -= n16;
                        }
                        ++n3;
                    } while (--n17 > 0);
                }
                ++n4;
            }
            n12 = (n6 + 3) % 3;
            piVector.setEntry(n3, PnLIC.m_oneTexCoord[n12].m_data[0]);
            piVector2.setEntry(n3, PnLIC.m_oneTexCoord[n12].m_data[1]);
            ++n3;
        }
        return n3;
    }

    public int getTextureWidth() {
        return this.m_width;
    }

    public PnLIC(PgElementSet pgElementSet, int n, double d, PnGeodesicRK pnGeodesicRK) {
        this.m_geom = pgElementSet;
        this.setRungeKutta(pnGeodesicRK);
        this.setSize(n);
        this.m_noise = new PnNoise();
        this.m_poly = new PgPolygonOnElementSet(this.m_geom);
        this.m_lastpoly = new PgPolygonOnElementSet(this.m_geom);
    }

    public PnLIC(PgElementSet pgElementSet) {
        this.m_geom = pgElementSet;
        this.m_noise = new PnNoise();
        this.m_poly = new PgPolygonOnElementSet(this.m_geom);
        this.m_lastpoly = new PgPolygonOnElementSet(this.m_geom);
    }

    public void makeElement(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = n;
        PdVector[] pdVectorArray = this.m_texCoords[n6];
        if (pdVectorArray[0].m_data[0] == pdVectorArray[1].m_data[0] && pdVectorArray[0].m_data[0] == pdVectorArray[2].m_data[0] && pdVectorArray[0].m_data[1] == pdVectorArray[1].m_data[1] && pdVectorArray[0].m_data[1] == pdVectorArray[2].m_data[1]) {
            return;
        }
        if (this.m_pix == null || this.m_pix.length != this.m_width * this.m_height) {
            this.m_pix = new int[this.m_width * this.m_height];
        }
        if (this.m_kernelwidthWorld >= 0.0) {
            this.m_kernelwidth = (int)(this.m_kernelwidthWorld / this.m_steplen);
        }
        this.m_kernelFac = this.m_steplen / this.m_integralh * (double)(this.m_kernelwidth - this.m_minKernel);
        int n7 = this.m_evalx.getSize();
        PsScanline psScanline = new PsScanline();
        int n8 = (int)(pdVectorArray[0].m_data[0] * (double)(this.m_width - 1));
        int n9 = (int)((1.0 - pdVectorArray[0].m_data[1]) * (double)(this.m_height - 1));
        int n10 = (int)(pdVectorArray[1].m_data[0] * (double)(this.m_width - 1));
        int n11 = (int)((1.0 - pdVectorArray[1].m_data[1]) * (double)(this.m_height - 1));
        int n12 = (int)(pdVectorArray[2].m_data[0] * (double)(this.m_width - 1));
        int n13 = (int)((1.0 - pdVectorArray[2].m_data[1]) * (double)(this.m_height - 1));
        psScanline.makeScanlines(n8, n9, n10, n11, n12, n13);
        int n14 = 0;
        while (n14 < psScanline.length) {
            int n15;
            int n16;
            n5 = psScanline.xa[n14];
            n4 = psScanline.xe[n14];
            n3 = n14 + psScanline.ymin;
            int n17 = n4 - n5;
            float f = psScanline.aAnteile[0][n14];
            float f2 = psScanline.aAnteile[1][n14];
            float f3 = psScanline.aAnteile[2][n14];
            float f4 = (psScanline.eAnteile[0][n14] - f) / (float)n17;
            float f5 = (psScanline.eAnteile[1][n14] - f2) / (float)n17;
            float f6 = (psScanline.eAnteile[2][n14] - f3) / (float)n17;
            n2 = n5;
            while (n2 <= n4) {
                if (n2 + n3 * this.m_width < 0 || n2 + n3 * this.m_width >= this.m_pix.length) {
                    System.err.println("OUCH!");
                }
                if (this.m_pix[n2 + n3 * this.m_width] >> 24 <= this.m_maxhits) {
                    int n18;
                    int n19;
                    int n20;
                    int n21;
                    this.m_point.m_data[0] = f;
                    this.m_point.m_data[1] = f2;
                    this.m_point.m_data[2] = f3;
                    n16 = 0;
                    do {
                        if (!(this.m_point.m_data[n16] < 0.0)) continue;
                        this.m_point.m_data[n16] = 0.0;
                        this.m_point.validate();
                    } while (++n16 < 3);
                    this.m_rk.prepareSolve(this.m_poly, n6, this.m_point, this.m_integralh);
                    boolean bl = false;
                    boolean bl2 = false;
                    int n22 = 0;
                    int n23 = 0;
                    int n24 = 0;
                    float f7 = 0.0f;
                    this.makeNextStep();
                    block3: do {
                        int n25 = this.m_nextpolysize;
                        n21 = this.m_nextkernelw;
                        bl = this.m_nextedgereached;
                        if (n7 < n24 + n25 + 1) {
                            n7 = this.m_evalsize > n25 + 1 ? (n7 += this.m_evalsize) : (n7 += n25 + 1);
                            this.m_evalx.setSize(n7);
                            this.m_evaly.setSize(n7);
                            this.m_kernelW.setSize(n7);
                            this.m_noisecol.setSize(n7);
                        }
                        n20 = n24 + n25;
                        n16 = n24;
                        while (n16 < n20) {
                            this.makeEvalXY(n16 - n24, n16, this.m_eval, this.m_coord, this.m_texpoint);
                            float f8 = this.m_noise.intNoise(this.m_coarseness * (float)this.m_evalx.m_data[n16], this.m_coarseness * (float)this.m_evaly.m_data[n16]);
                            this.m_noisecol.m_data[n16] = f8;
                            ++n16;
                        }
                        this.makeNextStep();
                        float f9 = (float)(this.m_nextkernelw - n21) / (float)n25;
                        float f10 = n21;
                        n16 = 0;
                        while (n16 < n25) {
                            this.m_kernelW.m_data[n24] = (int)f10;
                            f10 += f9;
                            ++n24;
                            ++n16;
                        }
                        n21 = this.m_kernelW.m_data[n23];
                        while (n23 < n24 && n24 - n23 >= n21) {
                            n15 = this.m_evalx.m_data[n23] + this.m_evaly.m_data[n23] * this.m_width;
                            if (this.m_pix[n15] >> 24 > this.m_maxhits) {
                                if (n22 > this.m_maxhits) {
                                    bl2 = true;
                                    continue block3;
                                }
                                ++n22;
                            }
                            f7 = 0.0f;
                            n20 = n23 + n21;
                            n16 = n23;
                            while (n16 < n20) {
                                f7 = (float)((double)f7 + this.m_noisecol.m_data[n16]);
                                ++n16;
                            }
                            n19 = 0x1000000 + (int)(f7 /= (float)n21);
                            int n26 = n15;
                            this.m_pix[n26] = this.m_pix[n26] + n19;
                            if (n23 == 0 && (this.m_evalx.m_data[0] != n2 || this.m_evaly.m_data[0] != n3)) {
                                int n27 = n18 = n3 * this.m_width + n2;
                                this.m_pix[n27] = this.m_pix[n27] + n19;
                            }
                            if (this.m_kernelW.m_data.length <= ++n23) {
                                System.err.println("brrR");
                            }
                            n21 = this.m_kernelW.m_data[n23];
                        }
                    } while (!bl && !bl2);
                    if (bl) {
                        while (n23 < n24) {
                            n15 = this.m_evalx.m_data[n23] + this.m_evaly.m_data[n23] * this.m_width;
                            n21 = this.m_kernelW.m_data[n23];
                            float f11 = 0.0f;
                            n20 = n23 + n21;
                            n16 = n23;
                            while (n16 < n20) {
                                f11 = (float)((double)f11 + this.m_noisecol.m_data[n16 % n24]);
                                ++n16;
                            }
                            n19 = 0x1000000 + (int)(f11 /= (float)n21);
                            int n28 = n15;
                            this.m_pix[n28] = this.m_pix[n28] + n19;
                            if (n23 == 0 && (this.m_evalx.m_data[0] != n2 || this.m_evaly.m_data[0] != n3)) {
                                int n29 = n18 = n3 * this.m_width + n2;
                                this.m_pix[n29] = this.m_pix[n29] + n19;
                            }
                            ++n23;
                        }
                    }
                }
                f += f4;
                f2 += f5;
                f3 += f6;
                ++n2;
            }
            n15 = n3 * this.m_width;
            n16 = 1;
            do {
                if (n5 - n16 >= 0) {
                    int n30 = n15 + n5 - n16;
                    this.m_pix[n30] = this.m_pix[n30] + this.m_pix[n15 + n5];
                }
                if (n4 + n16 >= this.m_width) continue;
                int n31 = n15 + n4 + n16;
                this.m_pix[n31] = this.m_pix[n31] + this.m_pix[n15 + n4];
            } while (++n16 <= 2);
            ++n14;
        }
        if (psScanline.length >= 1) {
            n3 = psScanline.length + psScanline.ymin;
            n5 = psScanline.xa[psScanline.length - 1];
            n4 = psScanline.xe[psScanline.length - 1];
            if (n3 < this.m_height) {
                n2 = n5 - 2;
                while (n2 <= n4 + 2) {
                    if (n2 >= 0 && n2 < this.m_width) {
                        int n32 = n3 * this.m_width + n2;
                        this.m_pix[n32] = this.m_pix[n32] + this.m_pix[(n3 - 1) * this.m_width + n2];
                    }
                    ++n2;
                }
            }
            n3 = psScanline.ymin - 1;
            n5 = psScanline.xa[0];
            n4 = psScanline.xe[0];
            if (n3 >= 0) {
                n2 = n5 - 2;
                while (n2 <= n4 + 2) {
                    if (n2 >= 0 && n2 < this.m_width) {
                        int n33 = n3 * this.m_width + n2;
                        this.m_pix[n33] = this.m_pix[n33] + this.m_pix[(n3 + 1) * this.m_width + n2];
                    }
                    ++n2;
                }
            }
        }
    }

    public void makeFastElement(int n, PdVector[] pdVectorArray, PdBaryDir[] pdBaryDirArray, double[] dArray, PdVector[] pdVectorArray2, boolean[] blArray, boolean[] blArray2) {
        int n2;
        int n3;
        int n4;
        PiVector[] piVectorArray = this.m_geom.getNeighbours();
        PdVector[] pdVectorArray3 = this.m_texCoords[n];
        if (pdVectorArray3[0].m_data[0] == pdVectorArray3[1].m_data[0] && pdVectorArray3[0].m_data[0] == pdVectorArray3[2].m_data[0] && pdVectorArray3[0].m_data[1] == pdVectorArray3[1].m_data[1] && pdVectorArray3[0].m_data[1] == pdVectorArray3[2].m_data[1]) {
            return;
        }
        if (this.m_pix == null || this.m_pix.length != this.m_width * this.m_height) {
            this.m_pix = new int[this.m_width * this.m_height];
        }
        this.m_noise.preComputeNoise(this.m_coarseness, 0, 0, this.m_width - 1, this.m_height - 1);
        PsScanline psScanline = new PsScanline();
        int n5 = 3 * n;
        if (pdVectorArray2[n5] == null || !blArray2[n]) {
            if (pdVectorArray2[n5] == null) {
                pdVectorArray2[n5] = new PdVector(2);
                pdVectorArray2[n5 + 1] = new PdVector(2);
                pdVectorArray2[n5 + 2] = new PdVector(2);
            }
            pdVectorArray3 = this.m_texCoords[n];
            pdVectorArray2[n5].set((double)((int)(pdVectorArray3[0].m_data[0] * (double)(this.m_width - 1))), (double)((int)((1.0 - pdVectorArray3[0].m_data[1]) * (double)(this.m_height - 1))));
            pdVectorArray2[n5 + 1].set((double)((int)(pdVectorArray3[1].m_data[0] * (double)(this.m_width - 1))), (double)((int)((1.0 - pdVectorArray3[1].m_data[1]) * (double)(this.m_height - 1))));
            pdVectorArray2[n5 + 2].set((double)((int)(pdVectorArray3[2].m_data[0] * (double)(this.m_width - 1))), (double)((int)((1.0 - pdVectorArray3[2].m_data[1]) * (double)(this.m_height - 1))));
            blArray2[n] = true;
        }
        psScanline.makeScanlines((int)pdVectorArray2[n5].m_data[0], (int)pdVectorArray2[n5].m_data[1], (int)pdVectorArray2[n5 + 1].m_data[0], (int)pdVectorArray2[n5 + 1].m_data[1], (int)pdVectorArray2[n5 + 2].m_data[0], (int)pdVectorArray2[n5 + 2].m_data[1]);
        if (this.m_kernelwidthWorld < 0.0) {
            this.m_kernelwidthWorld = this.m_steplen * (double)this.m_kernelwidth;
        }
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = null;
        double[] dArray5 = null;
        int[] nArray = null;
        double d = this.m_integralh * 10.0;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        int n9 = -2;
        int n10 = -1;
        double d2 = 0.0;
        double d3 = 1.0E-10;
        double d4 = -d3;
        boolean bl = false;
        int n11 = psScanline.ymin;
        int n12 = psScanline.ymin * this.m_width;
        int n13 = 0;
        while (n13 < psScanline.length) {
            n4 = psScanline.xa[n13];
            n3 = psScanline.xe[n13];
            int n14 = n3 - n4;
            double d5 = psScanline.aAnteile[0][n13];
            double d6 = psScanline.aAnteile[1][n13];
            double d7 = psScanline.aAnteile[2][n13];
            double d8 = ((double)psScanline.eAnteile[0][n13] - d5) / (double)n14;
            double d9 = ((double)psScanline.eAnteile[1][n13] - d6) / (double)n14;
            double d10 = ((double)psScanline.eAnteile[2][n13] - d7) / (double)n14;
            int n15 = n12 + n4;
            n2 = n4;
            while (n2 <= n3) {
                double d11 = n11;
                double d12 = n2;
                n7 = this.m_noise.getPreComputedNoise((int)d12, (int)d11);
                n6 = 1;
                double d13 = 0.0;
                if (n8 != n) {
                    n9 = -1;
                    n8 = n;
                }
                dArray2[0] = d5;
                dArray2[1] = d6;
                dArray2[2] = d7;
                n10 = -1;
                while (d13 < this.m_kernelwidthWorld) {
                    double d14;
                    if (n9 != n8) {
                        n9 = n8;
                        if (pdVectorArray[n8] == null || !blArray[n8]) {
                            if (pdBaryDirArray[n8] == null) {
                                pdBaryDirArray[n8] = new PdBaryDir(3);
                            }
                            this.m_rk.eval(n8, PdBary.TRIANGLE_MID, pdBaryDirArray[n8]);
                            n5 = 3 * n8;
                            pdVectorArray[n8] = PdBaryDir.getVector((PdVector)pdVectorArray[n8], (PdBaryDir)pdBaryDirArray[n8], (PdVector)pdVectorArray2[n5], (PdVector)pdVectorArray2[n5 + 1], (PdVector)pdVectorArray2[n5 + 2]);
                            dArray[n8] = PwBary.norm(this.m_geom, n8, pdBaryDirArray[n8], false);
                            if (dArray[n8] < d3 && dArray[n8] > d4) {
                                pdVectorArray[n8].m_data[0] = 0.0;
                                pdVectorArray[n8].m_data[1] = 0.0;
                                pdBaryDirArray[n8].m_data[0] = 0.0;
                                pdBaryDirArray[n8].m_data[1] = 0.0;
                                pdBaryDirArray[n8].m_data[2] = 0.0;
                            } else {
                                pdVectorArray[n8].multScalar(d * this.m_steplen / dArray[n8]);
                                pdBaryDirArray[n8].multScalar(d * this.m_steplen / dArray[n8]);
                            }
                            blArray[n8] = true;
                        }
                        dArray4 = pdVectorArray[n8].m_data;
                        dArray5 = pdBaryDirArray[n8].m_data;
                        nArray = piVectorArray[n8].m_data;
                        if (dArray4[0] < d3 && dArray4[0] > d4 && dArray4[1] < d3 && dArray4[1] > d4) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        d2 = d * this.m_steplen / dArray[n8];
                    }
                    if (bl) break;
                    dArray2[0] = dArray2[0] + dArray5[0];
                    dArray2[1] = dArray2[1] + dArray5[1];
                    dArray2[2] = dArray2[2] + dArray5[2];
                    n7 += this.m_noise.getPreComputedNoise((int)(d12 += dArray4[0]), (int)(d11 += dArray4[1]));
                    ++n6;
                    d13 += d2;
                    int n16 = -1;
                    if (dArray2[0] < 0.0) {
                        n16 = 0;
                    } else if (dArray2[1] < 0.0) {
                        n16 = 1;
                    } else if (dArray2[2] < 0.0) {
                        n16 = 2;
                    }
                    if (n16 == -1 || nArray[n16] == -1 || nArray[n16] == n10) continue;
                    n10 = n8;
                    n8 = nArray[n16];
                    nArray = piVectorArray[n8].m_data;
                    if (dArray5[n16] < d3 && dArray5[n16] > d4) {
                        d14 = dArray2[n16] / dArray5[n16];
                        dArray2[0] = dArray2[0] - dArray5[0] * d14;
                        dArray2[1] = dArray2[1] - dArray5[1] * d14;
                        dArray2[2] = dArray2[2] - dArray5[2] * d14;
                        d13 -= this.m_steplen / dArray[n9] * d14 / 2.0;
                    }
                    n5 = 0;
                    while (piVectorArray[n8].m_data[n5] != n9 && ++n5 < 3) {
                    }
                    dArray3[n5] = 0.0;
                    dArray3[(n5 + 1) % 3] = dArray2[(n16 + 2) % 3];
                    dArray3[(n5 + 2) % 3] = dArray2[(n16 + 1) % 3];
                    d14 = dArray3[0] + dArray3[1] + dArray3[2];
                    dArray2[0] = dArray3[0] / d14;
                    dArray2[1] = dArray3[1] / d14;
                    dArray2[2] = dArray3[2] / d14;
                    n5 = 3 * n8;
                    if (pdVectorArray2[n5] == null || !blArray2[n8]) {
                        if (pdVectorArray2[n5] == null) {
                            pdVectorArray2[n5] = new PdVector(2);
                            pdVectorArray2[n5 + 1] = new PdVector(2);
                            pdVectorArray2[n5 + 2] = new PdVector(2);
                        }
                        pdVectorArray3 = this.m_texCoords[n8];
                        pdVectorArray2[n5].set((double)((int)Math.round(pdVectorArray3[0].m_data[0] * ((double)(this.m_width - 1) - 0.98) + 0.49)), (double)((int)Math.round((1.0 - pdVectorArray3[0].m_data[1]) * ((double)(this.m_height - 1) - 0.98) + 0.49)));
                        pdVectorArray2[n5 + 1].set((double)((int)Math.round(pdVectorArray3[1].m_data[0] * ((double)(this.m_width - 1) - 0.98) + 0.49)), (double)((int)Math.round((1.0 - pdVectorArray3[1].m_data[1]) * ((double)(this.m_height - 1) - 0.98) + 0.49)));
                        pdVectorArray2[n5 + 2].set((double)((int)Math.round(pdVectorArray3[2].m_data[0] * ((double)(this.m_width - 1) - 0.98) + 0.49)), (double)((int)Math.round((1.0 - pdVectorArray3[2].m_data[1]) * ((double)(this.m_height - 1) - 0.98) + 0.49)));
                    }
                    d12 = dArray2[0] * pdVectorArray2[n5].m_data[0] + dArray2[1] * pdVectorArray2[n5 + 1].m_data[0] + dArray2[2] * pdVectorArray2[n5 + 2].m_data[0];
                    d11 = dArray2[0] * pdVectorArray2[n5].m_data[1] + dArray2[1] * pdVectorArray2[n5 + 1].m_data[1] + dArray2[2] * pdVectorArray2[n5 + 2].m_data[1];
                }
                this.m_pix[n15] = 0x1000000 + (n7 /= n6);
                ++n15;
                d5 += d8;
                d6 += d9;
                d7 += d10;
                ++n2;
            }
            n6 = 1;
            do {
                if (n4 - n6 >= 0) {
                    this.m_pix[n12 + n4 - n6] = this.m_pix[n12 + n4];
                }
                if (n3 + n6 >= this.m_width) continue;
                this.m_pix[n12 + n3 + n6] = this.m_pix[n12 + n3];
            } while (++n6 <= 2);
            ++n11;
            n12 += this.m_width;
            ++n13;
        }
        if (psScanline.length >= 1) {
            n11 = psScanline.length + psScanline.ymin;
            n4 = psScanline.xa[psScanline.length - 1];
            n3 = psScanline.xe[psScanline.length - 1];
            if (n11 < this.m_height) {
                n2 = n4 - 2;
                while (n2 <= n3 + 2) {
                    if (n2 >= 0 && n2 < this.m_width) {
                        int n17 = n11 * this.m_width + n2;
                        this.m_pix[n17] = this.m_pix[n17] + this.m_pix[(n11 - 1) * this.m_width + n2];
                    }
                    ++n2;
                }
            }
            n11 = psScanline.ymin - 1;
            n4 = psScanline.xa[0];
            n3 = psScanline.xe[0];
            if (n11 >= 0) {
                n2 = n4 - 2;
                while (n2 <= n3 + 2) {
                    if (n2 >= 0 && n2 < this.m_width) {
                        int n18 = n11 * this.m_width + n2;
                        this.m_pix[n18] = this.m_pix[n18] + this.m_pix[(n11 + 1) * this.m_width + n2];
                    }
                    ++n2;
                }
            }
        }
    }

    private static int newRow(boolean[] blArray, PdVector pdVector, int[] nArray) {
        double d = 0.0;
        int n = 0;
        while (!blArray[nArray[n]]) {
            ++n;
        }
        d = pdVector.m_data[nArray[n]];
        int n2 = (int)d + VGAP;
        return n2;
    }

    public static double[] makeElementTextureCoords(PgElementSet pgElementSet, int n) {
        int n2;
        int n3;
        int n4;
        pgElementSet.setDimOfTextures(2);
        pgElementSet.assureElementTextures();
        int n5 = pgElementSet.getNumElements();
        if (n5 == 0) {
            return new double[3];
        }
        double d = 0.0;
        double d2 = 0.0;
        PiVector piVector = new PiVector(n5);
        PdVector pdVector = new PdVector(n5);
        PdVector pdVector2 = new PdVector(n5);
        PdVector pdVector3 = new PdVector(n5);
        PdVector pdVector4 = new PdVector(n5);
        PdVector pdVector5 = new PdVector(n5);
        PdVector pdVector6 = new PdVector(n5);
        PdBaryDir pdBaryDir = new PdBaryDir(3);
        PdBaryDir pdBaryDir2 = new PdBaryDir(3);
        int n6 = 0;
        while (n6 < n5) {
            double d3;
            piVector.m_data[n6] = 0;
            pdVector.m_data[n6] = 0.0;
            int n7 = 0;
            do {
                pdBaryDir.m_data[n7] = 0.0;
                pdBaryDir.m_data[(n7 + 1) % 3] = 1.0;
                pdBaryDir.m_data[(n7 + 2) % 3] = -1.0;
                d3 = PwBary.norm(pgElementSet, n6, pdBaryDir, n7 == 0);
                if (d3 > pdVector.m_data[n6]) {
                    piVector.m_data[n6] = n7;
                    pdVector.m_data[n6] = d3;
                }
                if (!(d3 > d)) continue;
                d = d3;
            } while (++n7 < 3);
            n7 = piVector.m_data[n6];
            pdBaryDir.m_data[n7] = 0.0;
            pdBaryDir.m_data[(n7 + 1) % 3] = 1.0;
            pdBaryDir.m_data[(n7 + 2) % 3] = -1.0;
            pdBaryDir2.m_data[n7] = 1.0;
            pdBaryDir2.m_data[(n7 + 1) % 3] = 0.0;
            pdBaryDir2.m_data[(n7 + 2) % 3] = -1.0;
            pdVector2.m_data[n6] = PwBary.scalar(pgElementSet, n6, pdBaryDir, pdBaryDir2, false) / pdVector.m_data[n6];
            d3 = PwBary.norm(pgElementSet, n6, pdBaryDir2, false);
            d3 *= d3;
            if ((d3 -= pdVector2.m_data[n6] * pdVector2.m_data[n6]) < 0.0) {
                d3 = 0.0;
            }
            pdVector3.m_data[n6] = Math.sqrt(d3);
            if (pdVector3.m_data[n6] > d2) {
                d2 = pdVector3.m_data[n6];
            }
            if (pdVector2.m_data[n6] < 1.0E-10) {
                pdVector4.setEntry(n6, 1.5707963267948966);
            } else {
                pdVector4.setEntry(n6, Math.atan(pdVector3.m_data[n6] / pdVector2.m_data[n6]));
            }
            double d4 = pdVector.m_data[n6] - pdVector2.m_data[n6];
            if (d4 < 1.0E-10) {
                pdVector5.setEntry(n6, 1.5707963267948966);
            } else {
                pdVector5.setEntry(n6, Math.atan(pdVector3.m_data[n6] / d4));
            }
            ++n6;
        }
        double d5 = (double)n / d;
        int n8 = 0;
        while (n8 < n5) {
            pdVector.m_data[n8] = Math.ceil(pdVector.m_data[n8] * d5);
            pdVector2.m_data[n8] = Math.ceil(pdVector2.m_data[n8] * d5);
            pdVector3.m_data[n8] = Math.ceil(pdVector3.m_data[n8] * d5);
            pdVector6.m_data[n8] = pdVector.m_data[n8] * pdVector3.m_data[n8] / 2.0;
            ++n8;
        }
        int[] nArray = new int[n5];
        PuMath.heapsort((int)n5, (double[])pdVector3.m_data, (int[])nArray);
        int n9 = n5 / 2;
        int n10 = 0;
        while (n10 < n9) {
            int n11 = nArray[n10];
            nArray[n10] = nArray[n5 - 1 - n10];
            nArray[n5 - 1 - n10] = n11;
            ++n10;
        }
        n10 = 0;
        int n12 = 0;
        PiVector[][] piVectorArray = new PiVector[n5][3];
        int n13 = 12;
        boolean[] blArray = new boolean[n5];
        int n14 = n5;
        int n15 = 0;
        while (n15 < n5) {
            if (pdVector3.m_data[nArray[n15]] < 1.0E-10 || pdVector.m_data[nArray[n15]] < 1.0E-10) {
                --n14;
                blArray[nArray[n15]] = false;
                piVectorArray[nArray[n15]][0] = new PiVector(0, 0);
                piVectorArray[nArray[n15]][1] = new PiVector(0, 0);
                piVectorArray[nArray[n15]][2] = new PiVector(0, 0);
            } else {
                blArray[nArray[n15]] = true;
            }
            ++n15;
        }
        double d6 = 0.0;
        int n16 = 0;
        while (n16 < n5) {
            d6 += pdVector.m_data[n16] * 2.0 / 3.0;
            ++n16;
        }
        double d7 = d6 / 2.0;
        double d8 = pdVector3.m_data[nArray[0]];
        if (d8 > 1.0E-10) {
            while (d6 > 1.5 * d8 || d6 < d8 * 2.0 / 3.0) {
                d6 = d6 > 1.5 * d8 ? (d6 -= d7) : (d6 += d7);
                d7 /= 2.0;
                d8 = 0.0;
                double d9 = 0.0;
                n4 = 0;
                while (n4 < n5) {
                    if ((d9 += pdVector.m_data[nArray[n4]] * 2.0 / 3.0) > d6) {
                        d8 += pdVector3.m_data[nArray[n4]];
                        d9 = 0.0;
                    }
                    ++n4;
                }
            }
        }
        int n17 = 0;
        int n18 = VGAP / 2;
        int n19 = 0;
        int n20 = 0;
        int n21 = PnLIC.newRow(blArray, pdVector3, nArray);
        n10 += n21;
        ++n17;
        int n22 = 100;
        while (n14 > 0) {
            double d10;
            int n23;
            int n24;
            int n25;
            int n26;
            int n27;
            double d11;
            double d12;
            if ((double)n19 > d6 || (double)n20 > d6) {
                if (n19 > n12) {
                    n12 = n19;
                }
                if (n20 > n12) {
                    n12 = n20;
                }
                n18 = n10 + VGAP / 2;
                n19 = 0;
                n20 = 0;
                n21 = PnLIC.newRow(blArray, pdVector3, nArray);
                n10 += n21;
                ++n17;
                continue;
            }
            n4 = n21 - VGAP;
            if (n19 > n20) {
                d12 = Math.atan((double)n4 / (double)(n19 - n20));
                d11 = Double.MAX_VALUE;
                n3 = -1;
                n2 = 0;
                n27 = 0;
                n26 = 0;
                while (n26 < n5) {
                    if (n27 > n22) break;
                    n25 = nArray[n26];
                    if (blArray[n25]) {
                        ++n27;
                        double d13 = pdVector5.m_data[n25] < d12 ? ((n24 = (int)((double)(n20 + n13) + pdVector.m_data[n25] - pdVector2.m_data[n25] * (double)n4 / pdVector3.m_data[n25])) <= n19 ? (double)n4 * ((double)n13 + pdVector.m_data[n25]) / 2.0 - pdVector6.m_data[n25] : (double)n4 * (((double)n13 + pdVector.m_data[n25] - (double)n24 + (double)n19 - 1.0) / 2.0 + (double)n24 - (double)n19 + 1.0) - pdVector6.m_data[n25]) : (double)n4 * ((double)n13 + (double)(n19 - n20) * pdVector3.m_data[n25] / (double)n4 + pdVector2.m_data[n25]) / 2.0 - pdVector6.m_data[n25];
                        if (d13 < d11) {
                            d11 = d13;
                            n3 = n25;
                            n2 = 0;
                        }
                        d13 = pdVector4.m_data[n25] < d12 ? ((n24 = (int)((double)(n20 + n13) + pdVector2.m_data[n25] * (double)n4 / pdVector3.m_data[n25])) <= n19 ? (double)n4 * ((double)n13 + pdVector.m_data[n25]) / 2.0 - pdVector6.m_data[n25] : (double)n4 * (((double)n13 + pdVector.m_data[n25] - (double)n24 + (double)n19 - 1.0) / 2.0 + (double)n24 - (double)n19 + 1.0) - pdVector6.m_data[n25]) : (double)n4 * ((double)n13 + (double)(n19 - n20) * pdVector3.m_data[n25] / (double)n4 + pdVector.m_data[n25] - pdVector2.m_data[n25]) / 2.0 - pdVector6.m_data[n25];
                        if (d13 < d11) {
                            d11 = d13;
                            n3 = n25;
                            n2 = 1;
                        }
                    }
                    ++n26;
                }
                if (n3 == -1) {
                    throw new IllegalStateException("OUCH!!!");
                }
                n26 = piVector.m_data[n3];
                if (n2 != 0) {
                    n25 = 2;
                    n23 = 1;
                } else {
                    n25 = 1;
                    n23 = 2;
                }
                d10 = n2 != 0 ? pdVector.m_data[n3] - pdVector2.m_data[n3] : pdVector2.m_data[n3];
                if (pdVector5.m_data[n3] < d12 && n2 == 0 || pdVector4.m_data[n3] < d12 && n2 != 0) {
                    piVectorArray[n3][(n26 + n25) % 3] = new PiVector(n20 + n13 / 2, n4 + n18);
                    piVectorArray[n3][(n26 + n23) % 3] = new PiVector(n20 + n13 / 2 + (int)pdVector.m_data[n3], n4 + n18);
                    piVectorArray[n3][n26] = new PiVector(n20 + n13 / 2 + (int)(pdVector.m_data[n3] - d10), n4 + n18 - (int)pdVector3.m_data[n3]);
                } else {
                    piVectorArray[n3][(n26 + n25) % 3] = new PiVector((int)((double)(n20 + n13 / 2) + (double)(n19 - n20) * pdVector3.m_data[n3] / (double)n4 + d10 - pdVector.m_data[n3]), n4 + n18);
                    piVectorArray[n3][(n26 + n23) % 3] = new PiVector((int)((double)(n20 + n13 / 2) + (double)(n19 - n20) * pdVector3.m_data[n3] / (double)n4 + d10), n4 + n18);
                    piVectorArray[n3][n26] = new PiVector((int)((double)(n20 + n13 / 2) + (double)(n19 - n20) * pdVector3.m_data[n3] / (double)n4), n4 + n18 - (int)pdVector3.m_data[n3]);
                }
                n19 = (int)Math.max((double)(n19 + n13 / 2), (double)piVectorArray[n3][(n26 + n23) % 3].m_data[0] - d10 * (double)n4 / pdVector3.m_data[n3] + (double)(n13 / 2));
                n20 = piVectorArray[n3][(n26 + n23) % 3].m_data[0] + n13 / 2;
                blArray[n3] = false;
                --n14;
                continue;
            }
            d12 = n20 != n19 ? Math.atan((double)n4 / (double)(n20 - n19)) : 1.5707963267948966;
            d11 = Double.MAX_VALUE;
            n3 = -1;
            n2 = 0;
            n27 = 0;
            n26 = 0;
            while (n26 < n5) {
                if (n27 > n22) break;
                n25 = nArray[n26];
                if (blArray[n25]) {
                    ++n27;
                    double d14 = pdVector4.m_data[n25] < d12 ? ((n24 = (int)((double)(n19 + n13) + pdVector.m_data[n25] - (pdVector.m_data[n25] - pdVector2.m_data[n25]) * (double)n4 / pdVector3.m_data[n25])) <= n20 ? (double)n4 * ((double)n13 + pdVector.m_data[n25]) / 2.0 - pdVector6.m_data[n25] : (double)n4 * (((double)n13 + pdVector.m_data[n25] - (double)n24 + (double)n20 - 1.0) / 2.0 + (double)n24 - (double)n20 + 1.0) - pdVector6.m_data[n25]) : (double)n4 * ((double)n13 + (double)(n20 - n19) * pdVector3.m_data[n25] / (double)n4 + pdVector.m_data[n25] - pdVector2.m_data[n25]) / 2.0 - pdVector6.m_data[n25];
                    if (d14 < d11) {
                        d11 = d14;
                        n3 = n25;
                        n2 = 0;
                    }
                    d14 = pdVector5.m_data[n25] < d12 ? ((n24 = (int)((double)(n20 + n13) + pdVector.m_data[n25] - pdVector2.m_data[n25] * (double)n4 / pdVector3.m_data[n25])) <= n19 ? (double)n4 * ((double)n13 + pdVector.m_data[n25]) / 2.0 - pdVector6.m_data[n25] : (double)n4 * (((double)n13 + pdVector.m_data[n25] - (double)n24 + (double)n19 - 1.0) / 2.0 + (double)n24 - (double)n19 + 1.0) - pdVector6.m_data[n25]) : (double)n4 * ((double)n13 + (double)(n19 - n20) * pdVector3.m_data[n25] / (double)n4 + pdVector2.m_data[n25]) / 2.0 - pdVector6.m_data[n25];
                    if (d14 < d11) {
                        d11 = d14;
                        n3 = n25;
                        n2 = 1;
                    }
                }
                ++n26;
            }
            if (n3 == -1) {
                throw new IllegalStateException("OUCH (2)!!!");
            }
            n26 = piVector.m_data[n3];
            if (n2 != 0) {
                n25 = 2;
                n23 = 1;
            } else {
                n25 = 1;
                n23 = 2;
            }
            d10 = n2 != 0 ? pdVector.m_data[n3] - pdVector2.m_data[n3] : pdVector2.m_data[n3];
            if (pdVector4.m_data[n3] < d12 && n2 == 0 || pdVector5.m_data[n3] < d12 && n2 == 1) {
                piVectorArray[n3][(n26 + n23) % 3] = new PiVector(n19 + n13 / 2, n18);
                piVectorArray[n3][(n26 + n25) % 3] = new PiVector(n19 + n13 / 2 + (int)pdVector.m_data[n3], n18);
                piVectorArray[n3][n26] = new PiVector(n19 + n13 / 2 + (int)d10, n18 + (int)pdVector3.m_data[n3]);
            } else {
                piVectorArray[n3][(n26 + n23) % 3] = new PiVector((int)((double)(n19 + n13 / 2) + (double)(n20 - n19) * pdVector3.m_data[n3] / (double)n4 - d10), n18);
                piVectorArray[n3][(n26 + n25) % 3] = new PiVector((int)((double)(n19 + n13 / 2) + (double)(n20 - n19) * pdVector3.m_data[n3] / (double)n4 - d10 + pdVector.m_data[n3]), n18);
                piVectorArray[n3][n26] = new PiVector((int)((double)(n19 + n13 / 2) + (double)(n20 - n19) * pdVector3.m_data[n3] / (double)n4), n18 + (int)pdVector3.m_data[n3]);
            }
            n19 = piVectorArray[n3][(n26 + n25) % 3].m_data[0] + n13 / 2;
            n20 = (int)Math.max((double)(n20 + n13 / 2), (double)piVectorArray[n3][(n26 + n25) % 3].m_data[0] - (pdVector.m_data[n3] - d10) * (double)n4 / pdVector3.m_data[n3] + (double)(n13 / 2));
            blArray[n3] = false;
            --n14;
        }
        double d15 = 1.0 / (double)n10;
        double d16 = 1.0 / (double)n12;
        PdVector[][] pdVectorArray = new PdVector[n5][3];
        n3 = 0;
        while (n3 < n5) {
            n2 = 0;
            do {
                pdVectorArray[n3][n2] = new PdVector((double)piVectorArray[n3][n2].m_data[0] * d16, 1.0 - (double)piVectorArray[n3][n2].m_data[1] * d15);
            } while (++n2 < 3);
            ++n3;
        }
        pgElementSet.setElementTextures(pdVectorArray);
        double[] dArray = new double[]{d5, n12, n10};
        return dArray;
    }

    private void makeNextStep() {
        int n = 0;
        this.m_poly.setNumVertices(1);
        this.m_lastpoly.setNumVertices(1);
        boolean bl = false;
        double d = 0.0;
        do {
            this.m_nextedgereached = !this.m_rk.nextStep();
            d += this.m_rk.getStepLength();
            this.m_lastpoly.setNumVertices(this.m_lastpoly.getNumVertices() - 1);
            this.m_lastpoly.addPolygon(this.m_rk.getStepPolygon());
            if (++n >= 30) {
                this.m_nextedgereached = true;
            }
            if (this.m_nextedgereached) {
                bl = true;
                continue;
            }
            if (!(d >= this.m_steplen)) continue;
            bl = true;
        } while (!bl);
        this.m_lastpoly.eval(this.m_evalbary[0], this.m_evalbary[1], this.m_evalbary[2], this.m_evalelem, this.m_steplen);
        this.m_nextpolysize = this.m_evalelem.getSize() - 1;
        this.m_nextkernelw = (int)(this.m_kernelFac * (double)this.m_nextpolysize / (double)n + (double)this.m_minKernel);
        if (this.m_nextpolysize <= 1) {
            this.m_nextkernelw = 1;
            if (this.m_nextpolysize < 1) {
                ++this.m_nextpolysize;
            }
        }
    }

    public boolean setWorldConvolutionWidth(double d) {
        this.m_kernelwidthWorld = d;
        return !(d < 0.0);
    }

    public double getWorldConvolutionWidth() {
        return this.m_kernelwidthWorld;
    }

    public boolean setConvolutionWidth(int n) {
        if (n < 1) {
            return false;
        }
        this.m_kernelwidth = n;
        return true;
    }

    public boolean setCoarseness(double d) {
        if (d < 0.0 || d > 1.0) {
            return false;
        }
        this.m_coarseness = (float)(1.0 - d);
        return true;
    }

    public double getCoarseness() {
        return 1.0 - (double)this.m_coarseness;
    }

    public int getConvolutionWidth() {
        return this.m_kernelwidth;
    }

    public boolean setMinConvolutionWidth(int n) {
        if (n < 1 || n > this.m_kernelwidth) {
            return false;
        }
        this.m_minKernel = n;
        return true;
    }

    public int getMinConvolutionWidth() {
        return this.m_minKernel;
    }

    public void makeLIC() {
        this.reset();
        int n = this.m_geom.getNumElements();
        int n2 = n - 1;
        while (n2 >= 0) {
            this.makeElement(n2);
            --n2;
        }
    }

    public void makeFastLIC() {
        this.reset();
        int n = this.m_geom.getNumElements();
        PdVector[] pdVectorArray = new PdVector[n];
        PdBaryDir[] pdBaryDirArray = new PdBaryDir[n];
        double[] dArray = new double[n];
        PdVector[] pdVectorArray2 = new PdVector[3 * n];
        boolean[] blArray = new boolean[n];
        boolean[] blArray2 = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            blArray[n2] = false;
            blArray2[n2] = false;
            ++n2;
        }
        n2 = n - 1;
        while (n2 >= 0) {
            this.makeFastElement(n2, pdVectorArray, pdBaryDirArray, dArray, pdVectorArray2, blArray, blArray2);
            --n2;
        }
    }

    public void setSize(int n) {
        double[] dArray = PnLIC.makeElementTextureCoords(this.m_geom, n);
        if (dArray[0] < 1.0E-10) {
            return;
        }
        this.m_steplen = 1.0 / dArray[0];
        this.m_width = (int)dArray[1];
        this.m_height = (int)dArray[2];
        this.m_texCoords = this.m_geom.getElementTextures();
        if (this.m_pix != null && this.m_pix.length == this.m_width * this.m_height) {
            this.reset();
        }
        this.m_evalsize = (this.m_width + this.m_height) / 2;
        this.m_evalbary = new PdVector[3];
        int n2 = 0;
        do {
            this.m_evalbary[n2] = new PdVector(this.m_evalsize);
        } while (++n2 < 3);
        this.m_evalelem = new PiVector(this.m_evalsize);
        this.m_evalx = new PiVector(this.m_evalsize);
        this.m_evaly = new PiVector(this.m_evalsize);
        this.m_kernelW = new PiVector(this.m_evalsize);
        this.m_noisecol = new PdVector(this.m_evalsize);
    }

    public void setStepSize(double d) {
        this.m_integralh = d;
    }

    public double getStepSize() {
        return this.m_integralh;
    }

    public static void setEnabledKeepTransparency(boolean bl) {
        m_bKeepTransparency = bl;
    }
}

