/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnBiconjugateGradient;
import jvx.numeric.PnStiffMatrix;

public class PnMassMatrix
extends PnStiffMatrix {
    protected boolean m_bLumped;
    protected PnBiconjugateGradient m_solver;
    private PdVector[] m_store;
    private static /* synthetic */ Class class$jvx$numeric$PnMassMatrix;

    public PnMassMatrix(PgElementSet pgElementSet) {
        this(pgElementSet, false);
    }

    public PnMassMatrix(PgElementSet pgElementSet, boolean bl) {
        super(pgElementSet);
        this.m_bLumped = bl;
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        this.m_nop = pgElementSet.getNumVertices();
        this.m_noe = pgElementSet.getNumElements();
        this.m_snoe = new PiVector(this.m_nop);
        this.m_sindx = new PiVector[this.m_nop];
        this.m_stiff = new PdVector[this.m_nop];
        this.m_snoe.setConstant(0);
        int n = 0;
        while (n < this.m_noe) {
            int n2 = piVectorArray[n].getSize();
            int n3 = 0;
            while (n3 < n2) {
                if (piVectorArray2[n].m_data[n3] < 0 || piVectorArray2[n].m_data[n3] > n) {
                    int n4 = piVectorArray[n].m_data[(n3 + 1) % n2];
                    this.m_snoe.m_data[n4] = this.m_snoe.m_data[n4] + 1;
                    int n5 = piVectorArray[n].m_data[(n3 + 2) % n2];
                    this.m_snoe.m_data[n5] = this.m_snoe.m_data[n5] + 1;
                }
                ++n3;
            }
            ++n;
        }
        n = 0;
        while (n < this.m_nop) {
            if (this.m_snoe.m_data[n] > 0) {
                int n6 = n;
                this.m_snoe.m_data[n6] = this.m_snoe.m_data[n6] + 1;
            }
            ++n;
        }
        n = 0;
        while (n < this.m_nop) {
            this.m_sindx[n] = new PiVector(this.m_snoe.m_data[n]);
            this.m_stiff[n] = new PdVector(this.m_snoe.m_data[n]);
            ++n;
        }
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnMassMatrix != null ? class$jvx$numeric$PnMassMatrix : (class$jvx$numeric$PnMassMatrix = PnMassMatrix.class$("jvx.numeric.PnMassMatrix")))) {
            this.init(pgElementSet);
        }
    }

    public void useLumpedMass(boolean bl) {
        this.m_bLumped = bl;
    }

    public PnBiconjugateGradient getSolver() {
        return this.m_solver;
    }

    public PdVector[] multInvMassMatrix(PdVector[] pdVectorArray) {
        if (pdVectorArray == null || pdVectorArray.length != this.m_nop) {
            PsDebug.warning((String)"Cannot multiply with inverse mass matrix. Invalid size of given vector.");
            return pdVectorArray;
        }
        if (this.m_bLumped) {
            int n = 0;
            while (n < this.m_nop) {
                if (this.m_snoe.m_data[n] != 0) {
                    double d = this.m_stiff[n].m_data[this.getIndex(n, n)];
                    if (d < 1.0E-10) {
                        PsDebug.warning((String)("Problems computing multiplication with inverse lumped mass matrix. Area of star of vertex " + n + " " + "is smaller then " + d + "."));
                    } else {
                        pdVectorArray[n].multScalar(1.0 / d);
                    }
                }
                ++n;
            }
        } else {
            int n = pdVectorArray[0].m_data.length;
            if (this.m_store == null) {
                this.m_store = new PdVector[2];
            }
            if (this.m_store[0] == null) {
                this.m_store[0] = new PdVector(this.m_nop);
            } else if (this.m_store[0].m_data.length != this.m_nop) {
                this.m_store[0].setSize(this.m_nop);
            }
            if (this.m_store[1] == null) {
                this.m_store[1] = new PdVector(this.m_nop);
            } else if (this.m_store[1].m_data.length != this.m_nop) {
                this.m_store[1].setSize(this.m_nop);
            }
            if (this.m_solver == null) {
                this.m_solver = new PnBiconjugateGradient();
            }
            int n2 = 0;
            while (n2 < n) {
                int n3 = 0;
                while (n3 < this.m_nop) {
                    this.m_store[1].m_data[n3] = pdVectorArray[n3].m_data[n2];
                    ++n3;
                }
                double d = this.m_solver.linbcg(this, this.m_store[0], this.m_store[1]);
                if (d > 1.0E-10 || d < 0.0) {
                    PsDebug.warning((String)("Solving linear system to compute multiplication with inverse mass matrix produced an esimated error of " + d + ". " + "Mass matrix seems to have bad condition."));
                }
                n3 = 0;
                while (n3 < this.m_nop) {
                    pdVectorArray[n3].m_data[n2] = this.m_store[0].m_data[n3];
                    ++n3;
                }
                ++n2;
            }
        }
        return pdVectorArray;
    }

    public static PdVector multInvMassMatrix(PgElementSet pgElementSet, PdVector pdVector, boolean bl) {
        int n = pgElementSet.getNumVertices();
        if (pdVector.m_data.length != n) {
            PsDebug.warning((String)"length of given vector does not match with the number of vertices of the given geometry.");
            return pdVector;
        }
        int n2 = pgElementSet.getNumElements();
        double[] dArray = new double[n];
        PiVector[] piVectorArray = pgElementSet.getElements();
        int n3 = 0;
        while (n3 < n2) {
            double d = pgElementSet.getAreaOfElement(n3);
            int n4 = 0;
            while (n4 < piVectorArray[n3].m_data.length) {
                int n5 = piVectorArray[n3].m_data[n4];
                dArray[n5] = dArray[n5] + d;
                ++n4;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            int n6 = n3;
            pdVector.m_data[n6] = pdVector.m_data[n6] * (3.0 / dArray[n3]);
            ++n3;
        }
        return pdVector;
    }

    public static PdVector[] multInvMassMatrix(PgElementSet pgElementSet, PdVector[] pdVectorArray, boolean bl) {
        int n = pgElementSet.getNumVertices();
        if (pdVectorArray.length != n) {
            PsDebug.warning((String)"given array of vectors does not match with the number of vertices of the given geometry");
            return pdVectorArray;
        }
        if (bl) {
            int n2;
            int n3 = pgElementSet.getNumElements();
            double[] dArray = new double[n];
            PiVector[] piVectorArray = pgElementSet.getElements();
            int n4 = 0;
            while (n4 < n3) {
                double d = pgElementSet.getAreaOfElement(n4);
                n2 = 0;
                while (n2 < piVectorArray[n4].m_data.length) {
                    int n5 = piVectorArray[n4].m_data[n2];
                    dArray[n5] = dArray[n5] + d;
                    ++n2;
                }
                ++n4;
            }
            double d = 0.0;
            n4 = 0;
            while (n4 < n) {
                d = 3.0 / dArray[n4];
                n2 = 0;
                while (n2 < pdVectorArray[n4].m_data.length) {
                    int n6 = n2++;
                    pdVectorArray[n4].m_data[n6] = pdVectorArray[n4].m_data[n6] * d;
                }
                ++n4;
            }
        } else {
            PnMassMatrix pnMassMatrix = new PnMassMatrix(pgElementSet);
            pdVectorArray = pnMassMatrix.multInvMassMatrix(pdVectorArray);
        }
        return pdVectorArray;
    }

    public static PdMatrix[] multInvMassMatrix(PgElementSet pgElementSet, PdMatrix[] pdMatrixArray, boolean bl) {
        int n = pgElementSet.getNumVertices();
        if (pdMatrixArray.length != n) {
            PsDebug.warning((String)"given array of matrices does not match with the number of vertices of the given geometry");
            return pdMatrixArray;
        }
        int n2 = pgElementSet.getNumElements();
        double[] dArray = new double[n];
        PiVector[] piVectorArray = pgElementSet.getElements();
        int n3 = 0;
        while (n3 < n2) {
            double d = pgElementSet.getAreaOfElement(n3);
            int n4 = 0;
            while (n4 < piVectorArray[n3].m_data.length) {
                int n5 = piVectorArray[n3].m_data[n4];
                dArray[n5] = dArray[n5] + d;
                ++n4;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            pdMatrixArray[n3].multScalar(3.0 / dArray[n3]);
            ++n3;
        }
        return pdMatrixArray;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init(PgElementSet pgElementSet) {
        if (pgElementSet.getNumVertices() != this.m_nop || pgElementSet.getNumElements() != this.m_noe) {
            return;
        }
        int n = 0;
        while (n < this.m_nop) {
            if (this.m_snoe.m_data[n] > 0) {
                this.m_sindx[n].setConstant(-1);
                this.m_stiff[n].setConstant(0.0);
            }
            ++n;
        }
        n = pgElementSet.getNumElements();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        int n2 = 0;
        while (n2 < n) {
            int[] nArray = piVectorArray[n2].m_data;
            double d = PdVector.area((PdVector)pdVectorArray[nArray[0]], (PdVector)pdVectorArray[nArray[1]], (PdVector)pdVectorArray[nArray[2]]);
            if (!this.m_bLumped) {
                int n3 = this.getIndex(nArray[0], nArray[0]);
                this.m_stiff[nArray[0]].m_data[n3] = this.m_stiff[nArray[0]].m_data[n3] + d / 6.0;
                int n4 = this.getIndex(nArray[1], nArray[1]);
                this.m_stiff[nArray[1]].m_data[n4] = this.m_stiff[nArray[1]].m_data[n4] + d / 6.0;
                int n5 = this.getIndex(nArray[2], nArray[2]);
                this.m_stiff[nArray[2]].m_data[n5] = this.m_stiff[nArray[2]].m_data[n5] + d / 6.0;
                int n6 = this.getIndex(nArray[0], nArray[1]);
                this.m_stiff[nArray[0]].m_data[n6] = this.m_stiff[nArray[0]].m_data[n6] + d / 12.0;
                int n7 = this.getIndex(nArray[0], nArray[2]);
                this.m_stiff[nArray[0]].m_data[n7] = this.m_stiff[nArray[0]].m_data[n7] + d / 12.0;
                int n8 = this.getIndex(nArray[1], nArray[0]);
                this.m_stiff[nArray[1]].m_data[n8] = this.m_stiff[nArray[1]].m_data[n8] + d / 12.0;
                int n9 = this.getIndex(nArray[1], nArray[2]);
                this.m_stiff[nArray[1]].m_data[n9] = this.m_stiff[nArray[1]].m_data[n9] + d / 12.0;
                int n10 = this.getIndex(nArray[2], nArray[0]);
                this.m_stiff[nArray[2]].m_data[n10] = this.m_stiff[nArray[2]].m_data[n10] + d / 12.0;
                int n11 = this.getIndex(nArray[2], nArray[1]);
                this.m_stiff[nArray[2]].m_data[n11] = this.m_stiff[nArray[2]].m_data[n11] + d / 12.0;
            } else {
                int n12 = this.getIndex(nArray[0], nArray[0]);
                this.m_stiff[nArray[0]].m_data[n12] = this.m_stiff[nArray[0]].m_data[n12] + d / 3.0;
                int n13 = this.getIndex(nArray[1], nArray[1]);
                this.m_stiff[nArray[1]].m_data[n13] = this.m_stiff[nArray[1]].m_data[n13] + d / 3.0;
                int n14 = this.getIndex(nArray[2], nArray[2]);
                this.m_stiff[nArray[2]].m_data[n14] = this.m_stiff[nArray[2]].m_data[n14] + d / 3.0;
            }
            ++n2;
        }
    }

    public boolean isUsingLumpedMass() {
        return this.m_bLumped;
    }
}

