/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jv.object.PsObject;

public class PnOde
extends PsObject {
    protected int m_order;
    protected double m_x0;
    protected double[] m_y0;
    protected double m_stepSize;
    protected double m_length;
    private static /* synthetic */ Class class$jvx$numeric$PnOde;

    public static boolean solve(PgPolygon pgPolygon, PnOde pnOde, double d, double[] dArray, double d2, double d3) {
        if (pgPolygon == null) {
            PsDebug.warning((String)"missing polygon");
            return false;
        }
        if (dArray == null || d2 == 0.0 || d3 < d2) {
            PsDebug.warning((String)"wrong argument");
            return false;
        }
        int n = dArray.length;
        if (n == 0) {
            PsDebug.warning((String)"dim of initial value yStart is 0");
            return false;
        }
        int n2 = (int)(d3 / d2);
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        double d4 = d;
        int n3 = 0;
        while (n3 < n) {
            dArray2[n3] = dArray[n3];
            ++n3;
        }
        pgPolygon.setNumVertices(n2);
        pgPolygon.setVertex(0, d4, dArray2[0], 0.0);
        int n4 = 1;
        while (n4 < n2) {
            PnOde.rungeKutta(pnOde, d4, dArray2, d2, dArray3);
            System.arraycopy(dArray3, 0, dArray2, 0, n);
            pgPolygon.setVertex(n4, d4 += d2, dArray2[0], 0.0);
            ++n4;
        }
        return true;
    }

    public void setInitialData(double d, double[] dArray, double d2, double d3) {
        this.m_x0 = d;
        int n = 0;
        while (n < this.m_order) {
            this.m_y0[n] = dArray[n];
            ++n;
        }
        this.m_stepSize = d2;
        this.m_length = d3;
    }

    public PnOde() {
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnOde != null ? class$jvx$numeric$PnOde : (class$jvx$numeric$PnOde = PnOde.class$("jvx.numeric.PnOde")))) {
            this.init();
        }
    }

    public void setOrder(int n) {
        if (n == this.m_order) {
            return;
        }
        this.m_order = n;
        this.m_y0 = new double[this.m_order];
    }

    public void diffEquation(double d, double[] dArray, double[] dArray2) {
        dArray2[0] = d;
    }

    public static void rungeKutta(PnOde pnOde, double d, double[] dArray, double d2, double[] dArray2) {
        if (pnOde == null || dArray == null || dArray2 == null) {
            PsDebug.warning((String)"missing argument");
            return;
        }
        int n = dArray.length;
        if (n == 0) {
            PsDebug.warning((String)"dim of 'y' argument is 0");
            return;
        }
        double[][] dArray3 = new double[4][n];
        double[] dArray4 = new double[n];
        pnOde.diffEquation(d, dArray, dArray3[0]);
        int n2 = 0;
        while (n2 < n) {
            dArray4[n2] = dArray[n2] + d2 / 2.0 * dArray3[0][n2];
            ++n2;
        }
        pnOde.diffEquation(d + d2 / 2.0, dArray4, dArray3[1]);
        n2 = 0;
        while (n2 < n) {
            dArray4[n2] = dArray[n2] + d2 / 2.0 * dArray3[1][n2];
            ++n2;
        }
        pnOde.diffEquation(d + d2 / 2.0, dArray4, dArray3[2]);
        n2 = 0;
        while (n2 < n) {
            dArray4[n2] = dArray[n2] + d2 * dArray3[2][n2];
            ++n2;
        }
        pnOde.diffEquation(d + d2, dArray4, dArray3[3]);
        n2 = 0;
        while (n2 < n) {
            dArray2[n2] = dArray[n2] + d2 / 6.0 * (dArray3[0][n2] + 2.0 * dArray3[1][n2] + 2.0 * dArray3[2][n2] + dArray3[3][n2]);
            ++n2;
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
    }

    public void solve(PgPolygon pgPolygon) {
        PnOde.solve(pgPolygon, this, this.m_x0, this.m_y0, this.m_stepSize, this.m_length);
    }
}

