/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PnSparseMatrix
extends PsObject {
    public int m_nop;
    public PiVector m_snoe;
    public PiVector[] m_sindx;
    public PdVector[] m_stiff;

    public static PdVector rightMult(PnSparseMatrix pnSparseMatrix, PdVector pdVector, PdVector pdVector2, int n) {
        if (pnSparseMatrix == null) {
            PsDebug.warning((String)"Cannot compute multiplication with sparse matrix, sparse matrix is null.");
            return null;
        }
        int n2 = pnSparseMatrix.m_nop * n;
        if (pdVector.getSize() < n2) {
            PsDebug.warning((String)"Cannot compute multiplication with sparse matrix, input array has wrong size.");
            return null;
        }
        if (pdVector2 == null) {
            pdVector2 = new PdVector(n2);
        } else if (pdVector2.getSize() < n2) {
            PsDebug.warning((String)"Size of given vector out is to small. Adjusting size.");
            pdVector2.setSize(n2);
        }
        int n3 = 0;
        while (n3 < n2) {
            pdVector2.m_data[n3] = 0.0;
            ++n3;
        }
        n3 = 0;
        while (n3 < pnSparseMatrix.m_nop) {
            int n4 = 0;
            while (n4 < pnSparseMatrix.m_snoe.m_data[n3]) {
                int n5 = n * pnSparseMatrix.m_sindx[n3].m_data[n4];
                if (n5 >= 0) {
                    int n6 = 0;
                    while (n6 < n) {
                        int n7 = n5 + n6;
                        pdVector2.m_data[n7] = pdVector2.m_data[n7] + pnSparseMatrix.m_stiff[n3].m_data[n4] * pdVector.m_data[n * n3 + n6];
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n3;
        }
        return pdVector2;
    }

    public static PdVector rightMult(PnSparseMatrix pnSparseMatrix, PdVector pdVector, PdVector pdVector2) {
        return PnSparseMatrix.rightMult(pnSparseMatrix, pdVector, pdVector2, 1);
    }

    public static void multScalar(PnSparseMatrix pnSparseMatrix, double d) {
        int n = pnSparseMatrix.m_nop;
        int n2 = 0;
        while (n2 < n) {
            if (pnSparseMatrix.m_stiff[n2] != null) {
                pnSparseMatrix.m_stiff[n2].multScalar(d);
            }
            ++n2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t " + PsConfig.getMessage((int)63028) + "= \n");
        int n = 0;
        while (n < this.m_nop) {
            stringBuffer.append("\t [" + PuString.intToString((int)n, (int)3) + "]" + " (len = " + PuString.intToString((int)this.m_snoe.m_data[n], (int)3) + ") = ");
            stringBuffer.append(this.m_sindx[n].toShortString());
            ++n;
        }
        PdMatrix pdMatrix = new PdMatrix(this.m_nop);
        pdMatrix.setConstant(0.0);
        n = 0;
        while (n < this.m_nop) {
            int n2 = 0;
            while (n2 < this.m_snoe.m_data[n]) {
                int n3 = this.m_sindx[n].m_data[n2];
                pdMatrix.m_data[n][n3] = this.m_stiff[n].m_data[n2];
                ++n2;
            }
            ++n;
        }
        stringBuffer.append(PsConfig.getMessage((int)63029) + "\n" + pdMatrix.toShortString());
        return stringBuffer.toString();
    }

    public static PdVector diagonalSolve(PnSparseMatrix pnSparseMatrix, PdVector pdVector, PdVector pdVector2, int n) {
        int n2 = pnSparseMatrix.m_nop;
        if (pdVector.getSize() < n * n2 || pdVector2.getSize() < n * n2) {
            PsDebug.warning((String)"Cannot solve equation system. Size of given vector is to small.");
            return pdVector;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            double d = pnSparseMatrix.m_snoe.m_data[n3] == 0 ? 0.0 : pnSparseMatrix.m_stiff[n3].m_data[pnSparseMatrix.getIndex(n3, n3)];
            int n5 = n * n3;
            if (Math.abs(d) < 1.0E-10) {
                n4 = 0;
                while (n4 < n) {
                    pdVector.m_data[n5 + n4] = 0.0;
                    ++n4;
                }
            } else {
                d = 1.0 / d;
                n4 = 0;
                while (n4 < n) {
                    pdVector.m_data[n5 + n4] = pdVector2.m_data[n5 + n4] * d;
                    ++n4;
                }
            }
            ++n3;
        }
        return pdVector;
    }

    public int getIndex(int n, int n2) {
        if (n >= this.m_nop) {
            PsDebug.warning((String)("aLine out of bounds, aLine = " + n));
            return 0;
        }
        if (this.m_sindx[n].m_data == null || this.m_sindx[n].m_data.length == 0) {
            PsDebug.warning((String)("matrix has an empty row, aLine = " + n));
            return 0;
        }
        int n3 = 0;
        while (this.m_sindx[n].m_data[n3] != -1 && this.m_sindx[n].m_data[n3] != n2) {
            if (++n3 < this.m_sindx[n].m_data.length) continue;
            PsDebug.warning((String)("i out of bounds, i = " + n3));
            return 0;
        }
        if (n3 >= this.m_snoe.m_data[n]) {
            PsDebug.error((String)("entry out of range in line=" + n + ": max=" + this.m_snoe.m_data[n] + "but " + n3 + " found"), (Object)((Object)this));
            return 0;
        }
        if (this.m_sindx[n].m_data[n3] == -1) {
            this.m_sindx[n].m_data[n3] = n2;
        }
        return n3;
    }

    public static PdVector leftMult(PnSparseMatrix pnSparseMatrix, PdVector pdVector, PdVector pdVector2, int n) {
        if (pnSparseMatrix == null) {
            PsDebug.warning((String)"Cannot compute multiplication with sparse matrix, sparse matrix is null.");
            return null;
        }
        int n2 = pnSparseMatrix.m_nop * n;
        if (pdVector.getSize() < n2) {
            PsDebug.warning((String)"Cannot compute multiplication with sparse matrix, input array has wrong size.");
            return null;
        }
        if (pdVector2 == null) {
            pdVector2 = new PdVector(n2);
        } else if (pdVector2.getSize() < n2) {
            pdVector2.setSize(n2);
        }
        int n3 = 0;
        while (n3 < n2) {
            pdVector2.m_data[n3] = 0.0;
            ++n3;
        }
        n3 = 0;
        while (n3 < pnSparseMatrix.m_nop) {
            int n4 = 0;
            while (n4 < pnSparseMatrix.m_snoe.m_data[n3]) {
                int n5 = n * pnSparseMatrix.m_sindx[n3].m_data[n4];
                if (n5 >= 0) {
                    int n6 = 0;
                    while (n6 < n) {
                        int n7 = n * n3 + n6;
                        pdVector2.m_data[n7] = pdVector2.m_data[n7] + pnSparseMatrix.m_stiff[n3].m_data[n4] * pdVector.m_data[n5 + n6];
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n3;
        }
        return pdVector2;
    }

    public static PdVector leftMult(PnSparseMatrix pnSparseMatrix, PdVector pdVector, PdVector pdVector2) {
        return PnSparseMatrix.leftMult(pnSparseMatrix, pdVector, pdVector2, 1);
    }
}

