/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.numeric.PnStiffMatrix;

public class PnStiffAniso
extends PnStiffMatrix {
    protected double m_featureDetect = Double.MAX_VALUE;
    protected boolean m_bUseStepFunc = false;
    private static /* synthetic */ Class class$jvx$numeric$PnStiffAniso;

    public PnStiffAniso(PgElementSet pgElementSet) {
        super(pgElementSet);
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        this.m_nop = pgElementSet.getNumVertices();
        this.m_noe = pgElementSet.getNumElements();
        this.m_snoe = new PiVector(this.m_nop);
        this.m_sindx = new PiVector[this.m_nop];
        this.m_stiff = new PdVector[this.m_nop];
        this.m_snoe.setConstant(0);
        int n = 0;
        while (n < this.m_noe) {
            int n2 = piVectorArray[n].getSize();
            int n3 = 0;
            while (n3 < n2) {
                if (piVectorArray2[n].m_data[n3] < 0 || piVectorArray2[n].m_data[n3] > n) {
                    int n4 = piVectorArray[n].m_data[(n3 + 1) % n2];
                    this.m_snoe.m_data[n4] = this.m_snoe.m_data[n4] + 1;
                    int n5 = piVectorArray[n].m_data[(n3 + 2) % n2];
                    this.m_snoe.m_data[n5] = this.m_snoe.m_data[n5] + 1;
                }
                ++n3;
            }
            ++n;
        }
        n = 0;
        while (n < this.m_nop) {
            if (this.m_snoe.m_data[n] > 0) {
                int n6 = n;
                this.m_snoe.m_data[n6] = this.m_snoe.m_data[n6] + 1;
            }
            ++n;
        }
        n = 0;
        while (n < this.m_nop) {
            this.m_sindx[n] = new PiVector(this.m_snoe.m_data[n]);
            this.m_stiff[n] = new PdVector(this.m_snoe.m_data[n]);
            ++n;
        }
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnStiffAniso != null ? class$jvx$numeric$PnStiffAniso : (class$jvx$numeric$PnStiffAniso = PnStiffAniso.class$("jvx.numeric.PnStiffAniso")))) {
            this.init(pgElementSet);
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setFeatureDetect(double d) {
        if (d > 0.0) {
            this.m_featureDetect = d;
            return;
        }
        this.m_featureDetect = Math.abs(d);
        PsDebug.warning((String)"Given feature detection parameter is negative, absolute of the given value is used.");
    }

    public double getFeatureDetect() {
        return this.m_featureDetect;
    }

    public void init(PgElementSet pgElementSet) {
        if (pgElementSet.getNumVertices() != this.m_nop || pgElementSet.getNumElements() != this.m_noe) {
            return;
        }
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        int n = 0;
        while (n < this.m_nop) {
            if (this.m_snoe.m_data[n] > 0) {
                this.m_sindx[n].setConstant(-1);
                this.m_stiff[n].setConstant(0.0);
            }
            ++n;
        }
        PdVector pdVector = new PdVector(3);
        double[] dArray = pdVector.m_data;
        PdVector pdVector2 = new PdVector(3);
        double[] dArray2 = pdVector2.m_data;
        boolean bl = false;
        n = 0;
        while (n < this.m_noe) {
            int[] nArray = piVectorArray[n].m_data;
            PuVectorGeom.ctg((double[])dArray, (PdVector)pdVectorArray[nArray[0]], (PdVector)pdVectorArray[nArray[1]], (PdVector)pdVectorArray[nArray[2]]);
            if (!bl && pdVector.maxAbs() > 10000.0) {
                bl = true;
                PsDebug.warning((String)("ctg out of range, first in elem = " + n + "\n\tctg = [" + dArray[0] + ", " + dArray[1] + ", " + dArray[2] + "]"));
            }
            pdVector.multScalar(0.5);
            int n2 = 0;
            do {
                if (piVectorArray2[n].m_data[n2] < n) continue;
                int[] nArray2 = piVectorArray[piVectorArray2[n].m_data[n2]].m_data;
                PuVectorGeom.ctg((double[])dArray2, (PdVector)pdVectorArray[nArray2[0]], (PdVector)pdVectorArray[nArray2[1]], (PdVector)pdVectorArray[nArray2[2]]);
                pdVector2.multScalar(0.5);
                int n3 = (n2 + 1) % 3;
                int n4 = (n2 + 2) % 3;
                int n5 = pgElementSet.getOppVertexLocInd(n, n2);
                int n6 = (n5 + 1) % 3;
                int n7 = (n5 + 2) % 3;
                double d = 0.0;
                int n8 = 0;
                do {
                    double d2 = dArray[n3] * (pdVectorArray[nArray[n4]].m_data[n8] - pdVectorArray[nArray[n2]].m_data[n8]) + dArray[n4] * (pdVectorArray[nArray[n3]].m_data[n8] - pdVectorArray[nArray[n2]].m_data[n8]) + dArray2[n6] * (pdVectorArray[nArray2[n7]].m_data[n8] - pdVectorArray[nArray2[n5]].m_data[n8]) + dArray2[n7] * (pdVectorArray[nArray2[n6]].m_data[n8] - pdVectorArray[nArray2[n5]].m_data[n8]);
                    d += d2 * d2;
                } while (++n8 < 3);
                if (d > this.m_featureDetect * this.m_featureDetect) {
                    if (this.m_bUseStepFunc) continue;
                    d = Math.sqrt(d);
                    double d3 = 10.0;
                    double d4 = this.m_featureDetect;
                    d = d4 * d4 / (d4 * d4 + d3 * (d - d4) * (d - d4));
                } else {
                    d = 1.0;
                }
                int n9 = this.getIndex(nArray[n3], nArray[n4]);
                this.m_stiff[nArray[n3]].m_data[n9] = this.m_stiff[nArray[n3]].m_data[n9] + (dArray[n3] + dArray2[n7]) * d;
                int n10 = this.getIndex(nArray[n3], nArray[n3]);
                this.m_stiff[nArray[n3]].m_data[n10] = this.m_stiff[nArray[n3]].m_data[n10] + (dArray[n4] + dArray2[n6]) * d;
                int n11 = this.getIndex(nArray[n3], nArray2[n5]);
                this.m_stiff[nArray[n3]].m_data[n11] = this.m_stiff[nArray[n3]].m_data[n11] - (dArray2[n6] + dArray2[n7]) * d;
                int n12 = this.getIndex(nArray[n3], nArray[n2]);
                this.m_stiff[nArray[n3]].m_data[n12] = this.m_stiff[nArray[n3]].m_data[n12] - (dArray[n3] + dArray[n4]) * d;
                int n13 = this.getIndex(nArray[n4], nArray[n4]);
                this.m_stiff[nArray[n4]].m_data[n13] = this.m_stiff[nArray[n4]].m_data[n13] + (dArray[n3] + dArray2[n7]) * d;
                int n14 = this.getIndex(nArray[n4], nArray[n3]);
                this.m_stiff[nArray[n4]].m_data[n14] = this.m_stiff[nArray[n4]].m_data[n14] + (dArray[n4] + dArray2[n6]) * d;
                int n15 = this.getIndex(nArray[n4], nArray2[n5]);
                this.m_stiff[nArray[n4]].m_data[n15] = this.m_stiff[nArray[n4]].m_data[n15] - (dArray2[n6] + dArray2[n7]) * d;
                int n16 = this.getIndex(nArray[n4], nArray[n2]);
                this.m_stiff[nArray[n4]].m_data[n16] = this.m_stiff[nArray[n4]].m_data[n16] - (dArray[n3] + dArray[n4]) * d;
            } while (++n2 < 3);
            ++n;
        }
    }

    public void useStepFunction(boolean bl) {
        this.m_bUseStepFunc = bl;
    }
}

