/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwBary;
import jvx.numeric.PnGeodesicRK;

public class PnVertexRKIgnoreDirection
extends PnGeodesicRK {
    protected PdBaryDir[][] m_vec;

    public PnVertexRKIgnoreDirection(PgElementSet pgElementSet) {
        super(pgElementSet);
        if (pgElementSet.getDimOfElements() != 3) {
            throw new IllegalArgumentException("geometry is no triangulation");
        }
        this.m_vec = null;
    }

    public void setVectorField(PdBaryDir[][] pdBaryDirArray) {
        this.m_vec = pdBaryDirArray;
    }

    public void setVectorField(PgVectorField pgVectorField) {
        int n = pgVectorField.getNumVectors();
        int n2 = this.m_geom.getNumElements();
        this.m_vec = new PdBaryDir[n2][3];
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector pdVector = new PdVector(this.m_geom.getDimOfVertices());
        int n3 = 0;
        while (n3 < n2) {
            int n4 = piVectorArray[n3].getSize();
            int n5 = 0;
            while (n5 < n4) {
                int n6 = piVectorArray[n3].m_data[n5];
                this.m_vec[n3][n5] = new PdBaryDir(3);
                if (n6 < n) {
                    pdVector.copy(pdVectorArray[n6]);
                    if (n5 > 0 && PdVector.dot((PdVector)pdVectorArray[piVectorArray[n3].m_data[0]], (PdVector)pdVector) < 0.0) {
                        pdVector.multScalar(-1.0);
                    }
                    PwBary.projectOntoElement(this.m_geom, n3, pdVector, this.m_vec[n3][n5]);
                }
                ++n5;
            }
            ++n3;
        }
    }

    public void eval(int n, PdBary pdBary, PdBaryDir pdBaryDir) {
        int n2;
        pdBaryDir.setSize(3);
        PdBaryDir pdBaryDir2 = PdBaryDir.copyNew((PdBaryDir)pdBaryDir);
        int n3 = 0;
        do {
            pdBaryDir.m_data[n3] = 0.0;
            n2 = 0;
            do {
                int n4 = n3;
                pdBaryDir.m_data[n4] = pdBaryDir.m_data[n4] + pdBary.m_data[n2] * this.m_vec[n][n2].m_data[n3];
            } while (++n2 < 3);
        } while (++n3 < 3);
        if (this.m_bInvert) {
            n2 = 0;
            do {
                pdBaryDir.m_data[n2] = -pdBaryDir.m_data[n2];
            } while (++n2 < 3);
        }
        int n5 = n3 = !(PwBary.scalar(this.m_geom, n, pdBaryDir2, pdBaryDir, false) < 0.0) ? 0 : 1;
        if (n3 != 0) {
            n2 = 0;
            do {
                pdBaryDir.m_data[n2] = -pdBaryDir.m_data[n2];
            } while (++n2 < 3);
        }
    }
}

