/*
 * Decompiled with CFR 0.152.
 */
package de.jave.ascii.plate.textareabased;

import de.jave.ascii.plate.ITextContentListener;
import de.jave.ascii.plate.JaveGuiImageProvider;
import de.jave.ascii.plate.ruler.AsciiTextAreaHorizontalRuler;
import de.jave.ascii.plate.ruler.AsciiTextAreaVerticalRuler;
import de.jave.ascii.plate.textareabased.AsciiTextAreaComponent;
import de.jave.ascii.plate.textareabased.AsciiTextAreaProperties;
import de.jave.text.TextTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.events.AbstractDocumentChangeListener;

public final class AsciiTextArea {
    private AsciiTextAreaComponent textArea;
    private JComponent content;
    private List listeners = new ArrayList();
    private SmartAction copyAction;
    private SmartAction selectAllAction;
    private SmartAction cutAction;
    private SmartAction pasteAction;
    private AsciiTextAreaProperties properties;

    public AsciiTextArea(Dimension size, AsciiTextAreaProperties properties) {
        this.properties = properties;
        this.textArea = new AsciiTextAreaComponent(size, properties);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        scrollPane.setColumnHeaderView(new AsciiTextAreaHorizontalRuler(properties.getRulerProperties(), this.textArea));
        scrollPane.setRowHeaderView(new AsciiTextAreaVerticalRuler(properties.getRulerProperties(), this.textArea));
        this.content = scrollPane;
        this.textArea.getDocument().addDocumentListener(new AbstractDocumentChangeListener(){

            protected final void documentChanged() {
                AsciiTextArea.this.fireTextContentChangedEvent();
            }
        });
        this.textArea.addMouseListener(new MouseAdapter(){

            public final void mouseReleased(MouseEvent e) {
                if (!e.isMetaDown()) {
                    return;
                }
                AsciiTextArea.this.showPopupMenu(e.getPoint());
            }
        });
        this.cutAction = new SmartAction("Cu&t"){

            protected final void execute(Component parentComponent) {
                AsciiTextArea.this.textArea.cut();
            }
        };
        this.cutAction.setIcon(JaveGuiImageProvider.getInstance().getImageIcon("ascii/plate/cut.gif"));
        this.copyAction = new SmartAction("&Copy"){

            protected final void execute(Component parentComponent) {
                AsciiTextArea.this.textArea.copy();
            }
        };
        this.copyAction.setIcon(JaveGuiImageProvider.getInstance().getImageIcon("ascii/plate/copy.gif"));
        this.pasteAction = new SmartAction("&Paste"){

            protected final void execute(Component parentComponent) {
                AsciiTextArea.this.textArea.paste();
            }
        };
        this.pasteAction.setIcon(JaveGuiImageProvider.getInstance().getImageIcon("ascii/plate/paste.gif"));
        this.selectAllAction = new SmartAction("Select All"){

            protected final void execute(Component parentComponent) {
                AsciiTextArea.this.selectAll();
            }
        };
        this.selectAllAction.setIcon(JaveGuiImageProvider.EMPTY_ICON);
    }

    private void showPopupMenu(Point point) {
        boolean hasSelection = this.textArea.getSelectedText() != null;
        JPopupMenu menu = new JPopupMenu();
        this.cutAction.setEnabled(this.getProperties().isEditable() && hasSelection);
        menu.add(this.cutAction);
        this.copyAction.setEnabled(hasSelection);
        menu.add(this.copyAction);
        if (this.getProperties().isEditable()) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(null);
            boolean hasClipboardContents = transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
            this.pasteAction.setEnabled(hasClipboardContents);
            menu.add(this.pasteAction);
        }
        menu.addSeparator();
        menu.add(this.selectAllAction);
        menu.show(this.textArea, point.x, point.y);
    }

    public final void setText(String text) {
        this.textArea.setText(text);
    }

    public final JComponent getContent() {
        return this.content;
    }

    public final synchronized void addTextContentListener(ITextContentListener listener) {
        this.listeners.add(listener);
    }

    protected final synchronized void fireTextContentChangedEvent() {
        ArrayList copy = new ArrayList(this.listeners);
        Iterator iter = copy.iterator();
        while (iter.hasNext()) {
            ITextContentListener listener = (ITextContentListener)iter.next();
            listener.textContentChanged();
        }
    }

    public final String getText() {
        return this.textArea.getText();
    }

    public final Dimension getTextSize() {
        return TextTools.getDimensionOf(this.getText());
    }

    public final void selectAll() {
        this.textArea.selectAll();
        this.textArea.getCaret().setSelectionVisible(true);
    }

    public final void requestFocus() {
        this.textArea.requestFocus();
    }

    public final void setToolTipText(String text) {
        this.textArea.setToolTipText(text);
    }

    public final AsciiTextAreaProperties getProperties() {
        return this.properties;
    }
}

